#ifndef _INTERFACE_H
#define _INTERFACE_H

#include <stdint.h>
#include "fcsi_access_functions.h"


/* register packages */
/*#include "ant_fcsi_addrmap.h"
#include "antenna_clockbiasldoanamux_fcsi_regpkg.h"
#include "antenna_dac40m_macro_fcsi_regpkg.h"
#include "antenna_sdadc40m_macro_fcsi_regpkg.h"
#include "antenna_ssiadc_fcsi_regpkg.h"

#include "central_fcsi_addrmap.h"
#include "central_centralstuff_fcsi_regpkg.h"
#include "central_lcpll_macro_fcsi_regpkg.h"*/

#include "fcsi_access_defines.h"

// define for ISR
#define NULL_POINTER 0

// Defines for Antenna Access
#define ABB_ANT0 		1 //00001
#define ABB_ANT1 		2 //00010
#define ABB_ANT10		3 //00011
#define ABB_ANT2 		4 //00100
#define ABB_ANT20 		5 //00101
#define ABB_ANT21 		6 //00110
#define ABB_ANT210 		7 //00111
#define ABB_ANT3 		8 //01000
#define ABB_ANT30 		9 //01001
#define ABB_ANT31 	       10 //01010
#define ABB_ANT310 	       11 //01011
#define ABB_ANT32 	       12 //01100
#define ABB_ANT320 	       13 //01101
#define ABB_ANT321 	       14 //01110
#define ABB_ANT3210 	       15 //01111

#define ABB_CENTRAL 	       16 //10000

#define NR_OF_ANTENNAS 5

#define ABB_ANT0_INDEX		0
#define ABB_ANT1_INDEX		1
#define ABB_ANT2_INDEX		2
#define ABB_ANT3_INDEX		3
#define ABB_CENTRAL_INDEX       4
extern void* ABB_fcsi_mirror;

void ABB_wait(uint32_t cnt, uint32_t unit);

void     ABB_vFcsiRmw  (void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usMask, uint16_t P_usValue);
uint16_t ABB_usFcsiRead(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t *P_pusData);
void     ABB_vFcsiWrite(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usValue);

void     ABB_vPortWrite (uint32_t P_ulPort, uint32_t P_ulValue);
void     ABB_vPortsWrite(uint32_t P_ulPort, uint32_t P_ulWidth, uint32_t P_ulValue);
uint32_t ABB_ulPortRead (uint32_t P_ulPort);


#define ABB_DIR_CTRL_WRITE(port_name, value)          ABB_vPortWrite(port_name, value)         // direct control of port
#define ABB_DIR_CTRL_READ(port_name)                  ABB_ulPortRead(port_name)         // direct control of port
#define ABB_DIR_CTRL_WRITES(port_name, width, value)  ABB_vPortsWrite(port_name, width, value) // direct control of a bus

#define ABB_FCSI_RMW(antenna, address, mask, value) ABB_vFcsiRmw(ABB_fcsi_mirror, antenna, address, mask, value)
#define ABB_FCSI_Read(antenna, address, data)       ABB_usFcsiRead(ABB_fcsi_mirror, antenna, address, data)
#define ABB_FCSI_Write(antenna, address, value)     ABB_vFcsiWrite(ABB_fcsi_mirror, antenna, address, value)


//void ABB_vFcsiRmw(void *mirror, uint16_t antenna, uint16_t address, uint16_t mask, uint16_t value);
//uint16_t ABB_usFcsiRead(void *mirror, uint16_t antenna, uint16_t address);
//void ABB_vFcsiWrite(void *mirror, uint16_t antenna, uint16_t address, uint16_t value);

#endif //  _INTERFACE_H

// v: void --> no values returned
// macros & defines are written with capital letters
