#include <stdint.h>
#include <stdio.h>
#include "target.h"
#include "fcsvtb_fcsi2_n_dpi.h"  // defines for "_config"
#include "tb_abb11ac_fcsi2_n_defines.h"
//#include "tb_abb11ac_fcsi2_n_functions.h"
#include "interface_abb11ac.h"

void tb_set_all_gp_outs(int Value)
{
  int i_max     = GPIO_PORT_WIDTH / 32;
  int remainder = GPIO_PORT_WIDTH % 32;

  for (int i = 0; i < i_max; i++) {
    _ports_set(32*i, 32, Value);
    debug_printf("imax: %d, rem: %d, loop: %d\n", i_max, remainder, i);

  }
  while (remainder > 0) {
    _port_set(GPIO_PORT_WIDTH-remainder, Value);
    remainder--;
  }
}


void init_abb11ac_tb (void)
{

  // Configuring printouts
  dpi_io_config(DPI_CFG_PRINT_IDX,0); // switch off detailed io printout from C
  dpi_io_v_config(0);                 // switch off detailed io printout from Verilog !

  /*_config_set(FCSI2_N_CONFIG_IDX_RDDELAY,1);

  _out_n_cfg(NR_OF_ANTENNAS); // this must match with SV parameter amount of fcsi "ports"

  _config_set(FCSI2_N_CONFIG_IDX_ENABMASK,(1<<NR_OF_ANTENNAS)-1);*/

  tb_set_all_gp_outs(0);
  _wait(1, T_USEC);
  ABB_DIR_CTRL_WRITES(lcpll_op_buf_pdn_d2a, 5, 0x1F);
}


void abb11ac_TXDAC_reset_pin_controls(int antenna)
{
    //  read tx_on values in order not to switch off all
    int value0 = ABB_DIR_CTRL_READ(TX_ON);
    int value1 = ABB_DIR_CTRL_READ(TX_ON+1);
    int value2 = ABB_DIR_CTRL_READ(TX_ON+2);
    int value3 = ABB_DIR_CTRL_READ(TX_ON+3);
    int value =  value3*8 + value2*4 + value1*2 + value0;
    ABB_DIR_CTRL_WRITES(TX_ON, 4, value & ~antenna);
    
    //  read tx_data_valid values in order not to switch off all
    value0 = ABB_DIR_CTRL_READ(TX_IQ_DATA_VALID);
    value1 = ABB_DIR_CTRL_READ(TX_IQ_DATA_VALID+1);
    value2 = ABB_DIR_CTRL_READ(TX_IQ_DATA_VALID+2);
    value3 = ABB_DIR_CTRL_READ(TX_IQ_DATA_VALID+3);
    value =  value3*8 + value2*4 + value1*2 + value0;
    ABB_DIR_CTRL_WRITES(TX_IQ_DATA_VALID, 4, value & ~antenna);
    
    //  read reset valuesin order not to put all to reset
    value0 = ABB_DIR_CTRL_READ(TX_IQ_RSTN);
    value1 = ABB_DIR_CTRL_READ(TX_IQ_RSTN+1);
    value2 = ABB_DIR_CTRL_READ(TX_IQ_RSTN+2);
    value3 = ABB_DIR_CTRL_READ(TX_IQ_RSTN+3);
    value =  value3*8 + value2*4 + value1*2 + value0;
    ABB_DIR_CTRL_WRITES(TX_IQ_RSTN, 4, value & ~antenna);
}


void abb11ac_SSIADC_reset_pin_controls(int antenna)
{
    //  read ssi_on values in order not to switch off all
    int value0 = ABB_DIR_CTRL_READ(SSI_ON);
    int value1 = ABB_DIR_CTRL_READ(SSI_ON+1);
    int value2 = ABB_DIR_CTRL_READ(SSI_ON+2);
    int value3 = ABB_DIR_CTRL_READ(SSI_ON+3);
    int value =  value3*8 + value2*4 + value1*2 + value0;
    ABB_DIR_CTRL_WRITES(SSI_ON, 4, value & ~antenna);
}

void abb11ac_RXADC_reset_pin_controls(int antenna)
{
    //  read rx_on values in order not to switch off all
    int value0 = ABB_DIR_CTRL_READ(RX_ON);
    int value1 = ABB_DIR_CTRL_READ(RX_ON+1);
    int value2 = ABB_DIR_CTRL_READ(RX_ON+2);
    int value3 = ABB_DIR_CTRL_READ(RX_ON+3);
    int value =  value3*8 + value2*4 + value1*2 + value0;
    ABB_DIR_CTRL_WRITES(RX_ON, 4, value & ~antenna);
    
    
    //  read reset values in order not to put all to reset
    value0 = ABB_DIR_CTRL_READ(RX_IQ_RSTN);
    value1 = ABB_DIR_CTRL_READ(RX_IQ_RSTN+1);
    value2 = ABB_DIR_CTRL_READ(RX_IQ_RSTN+2);
    value3 = ABB_DIR_CTRL_READ(RX_IQ_RSTN+3);
    value =  value3*8 + value2*4 + value1*2 + value0;
    ABB_DIR_CTRL_WRITES(RX_IQ_RSTN, 4, value & ~antenna);
}
