#ifndef TB_ABB11AC_FCSI2_N_DEFINES_H
#define TB_ABB11AC_FCSI2_N_DEFINES_H

#define NR_OF_ANTENNAS 5
#define GPIO_PORT_WIDTH    512
// defines for fcsi access functions
#define MAX_PORT_COUNT NR_OF_ANTENNAS
#define MAX_PORT_MASK ((1<<MAX_PORT_COUNT)-1)
#define RCCOUNTNOM 353

// DUT Ports
#define FCSI2_RST_N          0
#define FCSI2_FORCE_DEFAULT  1
#define NON_CHANNEL_BONDING  2

#define GEN_EN_WIDTH         4
#define SSI_GEN_EN          16
#define RX_GEN_EN            SSI_GEN_EN + GEN_EN_WIDTH
#define TX_GEN_EN            RX_GEN_EN + GEN_EN_WIDTH

#define TX_ON              50
#define TX_IQ_RSTN         55
#define TX_IQ_DATA_VALID   60

#define RX_ON              65
#define RX_IQ_RSTN         70

#define SSI_ON             75

// direct control signals
#define BB_CLKSRC                   192
#define lcpll_bypass_d2a            193
#define lcpll_pup_d2a               194
#define lcpll_divider_int_d2a       195
#define lcpll_op_buf_pdn_d2a        203
#define lcpll_op_freq_sel_clk1_d2a  208
#define lcpll_op_freq_sel_clk2_d2a  210
#define lcpll_op_freq_sel_clk3_d2a  212
#define lcpll_op_freq_sel_clk4_d2a  214
#define lcpll_op_freq_sel_clk5_d2a  216
#define lcpll_resetn_d2a            218
#define usb_spnd_wup_d2a            219
#define lcpll_scan_rstn             220
#define lcpll_scan_enable           221
#define lcpll_scan_mode             222
#define lcpll_scan_clk              223
#define fcsi_rf_dout0               224
#define fcsi_rf_dout1               225
#define fcsi_rf_dout2               226
#define fcsi_rf_dout3               227
#define fcsi_rf_en                  228
#define fcsi_rf_oen                 229
#define fcsi_rf_resetq              230

// direct observe signals   
#define FCSI_CTLIFCLK               231
#define FCSI_RESET_Q                232
#define USB_SPND                    233
#define lcpll_clkout1_cmos_a2d      234
#define lcpll_clkout2_cmos_a2d      235
#define lcpll_clkref_cml_p_a2d      236
#define lcpll_clkref_cml_n_a2d      237
#define clkref_cmos_a2d             238
#define lcpll_lock_a2d              239

// FCSI
#define FCSI2_RST_N_0               250
#define FCSI2_RST_N_1               251
#define FCSI2_RST_N_2               252
#define FCSI2_RST_N_3               253
#define FCSI2_RST_N_C               254

#define FCSI2_FORCE_DEFAULT_0       260
#define FCSI2_FORCE_DEFAULT_1       261
#define FCSI2_FORCE_DEFAULT_2       262
#define FCSI2_FORCE_DEFAULT_3       263
#define FCSI2_FORCE_DEFAULT_C       264


#endif
