#ifndef _LIB_DPI_H
#define _LIB_DPI_H

#include <stdint.h>

// benchdriver configuration section:
// *********************************

#undef V_IF_USE_RTL_PRINT
#undef V_IF_USE_SELECT_CONV
#define V_IF_NO_UNIT_WAIT
#undef V_IF_USE_BENCHPORT


// bench driver internal defines and interface functions 
// *****************************************************

#define DPI_CFG_PRINT_IDX 1
#define DPI_MAX_SCOPES 128

#ifndef BASE_UNIT
#define BASE_UNIT T_PSEC 
#endif

#ifndef T_FSEC
#define T_FSEC   0x20FA
#endif

#ifndef T_PSEC
#define T_PSEC   0x20FB
#endif

#ifndef T_NSEC
#define T_NSEC   0x20FC
#endif

#ifndef T_USEC
#define T_USEC   0x20FD
#endif

#ifndef T_MSEC
#define T_MSEC   0x20FE
#endif

#ifndef T_SEC
#define T_SEC    0x20FF
#endif

#define LOGIC_Z  3
#define LOGIC_X  2


// structure definitions:
// **********************

// struct for burst access
typedef enum {READ,WRITE,NOP} access_type_e;

typedef struct
{
  unsigned long Addr;
  unsigned long Data;
  access_type_e type;
}AccessEntry_t;

typedef struct
{
  AccessEntry_t * pEntry;  // pointer to array of structs !
  unsigned long   len;
}AccessTable_t;


typedef struct
{
  unsigned long len;
}stBurst_t;


typedef struct 
{
  char* Name;  // scope pointer
  uint32_t clk_p; // clk period of that scope
}stScope_t;


// Interface function declarations:
// ********************************
int32_t  dpi_show_scope(uint32_t Index, stScope_t* ScopeInfo);
uint32_t dpi_cnt_scopes(void);
void     dpi_io_config(uint32_t Idx, uint32_t Value);
void     dpi_io_v_config(uint32_t Value);

// print functions
int debug_printf (const char *msg, ...);
int raw_printf (const char *msg, ...);

// Compatibility functions:
void     _io_write(uint32_t Addr, uint32_t data);
uint32_t _io_read(uint32_t Addr);
void     c_io_bus_write(uint32_t Addr, uint32_t Data);
uint32_t c_io_bus_read(uint32_t Addr);
// end of compatibiltiy

void     _wait(uint32_t time, uint32_t unit);
uint64_t _get_time_base(void);
uint32_t _get_time(uint32_t unit);

uint32_t _in(uint32_t Addr);
void     _out(uint32_t Addr, uint32_t Data);
int      _nop(void);
uint32_t _int_get(void);
uint32_t _get_int(void);

int     _burst(stBurst_t * AccessTable); // experimental use only !

// config functions for printouts a.s.o.
int32_t _config_set(int index, int value);
int32_t _config_get(int index);


// benchport io functions ( with/without wait)
void     _port_set(uint32_t PortId, uint32_t level);
uint32_t _port_get(uint32_t PortId);

void     _port_write(uint32_t PortId, uint32_t level);
uint32_t _port_read(uint32_t PortId);

void     _ports_set(uint32_t PortNum, uint32_t Width, uint32_t Value);
uint32_t _ports_get(uint32_t PortNum, uint32_t Width);

void     _port_wait(uint32_t PortNum);

int32_t _bench_write(int port_id,int level);
int32_t _bench_read(int port_id);

int _set_clk_p(void);

void* get_so_handle(uint32_t Idx);

#endif
