// Module /////////////////////////
module_ANT = new Array ();
module_ANT.parent = "system_ANT_SYSTEM";
// BasicInfo //////////////////////////
module_ANT.jsName      = "module_ANT";
module_ANT.type        = "module";
module_ANT.baseName    = "ANTENNA";
module_ANT.instName    = "ANT";
module_ANT.aliasName   = "ANT";
module_ANT.longName    = "Antenna of ABB11AC WAVE500";
module_ANT.description = "Antenna of ABB11AC WAVE500 containing SDADC40M, DAC40M, SSIADC and bits for LDO and BIAS";
module_ANT.file = "";
module_ANT.contacts    = "user_hebeinth";
module_ANT.references = [
];
module_ANT.links = new Array ();
module_ANT.pictures = new Array ();
module_ANT.pictures ["ant.svg"] = "Generated SVG";
module_ANT.debugMessages = [
];
module_ANT.ports = [
        "port_ANT_FCSI"
];
module_ANT.buses = [
        "bus_ANT_FCSI"
];
module_ANT.modules = [
        "module_ANT_SDADC40M",
        "module_ANT_CLOCKBIASLDOANAMUX",
        "module_ANT_DAC40M",
        "module_ANT_SSI"
];
module_ANT.attributes = new Array ();
// AttributeContainer ////////////////////
///////////////////////////////////
// Port /////////////////////////
port_ANT_FCSI = new Array ();
port_ANT_FCSI.parent = "module_ANT";
port_ANT_FCSI.masterBus = "";
port_ANT_FCSI.slaveBus = "";
port_ANT_FCSI.masterBusProtocol = "FCSI";
port_ANT_FCSI.slaveBusProtocol = "FCSI";
port_ANT_FCSI.isInterface = "true";
port_ANT_FCSI.isSystemPort = "false";
port_ANT_FCSI.isView = "true";
port_ANT_FCSI.isBridge = "false";
port_ANT_FCSI.isDefaultSlave = "false";
port_ANT_FCSI.hasMutationsByAttributes = "false";
port_ANT_FCSI.isIndirectAccessPort = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
port_ANT_FCSI.jsName      = "port_ANT_FCSI";
port_ANT_FCSI.type        = "port";
port_ANT_FCSI.baseName    = "BASIC";
port_ANT_FCSI.instName    = "FCSI";
port_ANT_FCSI.aliasName   = "FCSI";
port_ANT_FCSI.longName    = "Full custom serial interface";
port_ANT_FCSI.description = "";
port_ANT_FCSI.file = "";
port_ANT_FCSI.contacts    = "user_hebeinth";
port_ANT_FCSI.references = [
];
port_ANT_FCSI.links = new Array ();
port_ANT_FCSI.pictures = new Array ();
port_ANT_FCSI.debugMessages = [
];
port_ANT_FCSI.views  = [
        "port_ANT_FCSI"
];
port_ANT_FCSI.addrBase   = "32'b00000000000000000000000000010000";
port_ANT_FCSI.addrStart  = new Array ();
port_ANT_FCSI.addrEnd    = new Array ();
port_ANT_FCSI.addrSpace  = new Array ();
port_ANT_FCSI.dataWidth  = new Array ();
port_ANT_FCSI.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000000000000";
port_ANT_FCSI.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001111111";
port_ANT_FCSI.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000010000000";
port_ANT_FCSI.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000000000";
port_ANT_FCSI.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000000000000";
port_ANT_FCSI.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001111111";
port_ANT_FCSI.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000010000000";
port_ANT_FCSI.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
port_ANT_FCSI.offsetAsView     = "32'b00000000000000000000000000000000"
port_ANT_FCSI.allowAddrOverlap = false;
port_ANT_FCSI.isCollapsedIntoPort = false;
port_ANT_FCSI.isLossless = true;
port_ANT_FCSI.access       = new Array ();
port_ANT_FCSI.access ["port_ANT_FCSI"] = "RW";
port_ANT_FCSI.access ["port_ANT_FCSI"] = "RW";
port_ANT_FCSI.hierarchies       = new Array ();
port_ANT_FCSI.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI"
];
port_ANT_FCSI.registers = [
        "register_ANT_FCSI_RESERVED0",
        "register_ANT_FCSI_IQADCREG0",
        "register_ANT_FCSI_IQADCREG1",
        "register_ANT_FCSI_IQADCREG2",
        "register_ANT_FCSI_IQADCREG3",
        "register_ANT_FCSI_REGCLOCKING",
        "register_ANT_FCSI_REGBIASING",
        "register_ANT_FCSI_REGLDO",
        "register_ANT_FCSI_REGANAMUX",
        "register_ANT_FCSI_IQDACREG0",
        "register_ANT_FCSI_IQDACREG1",
        "register_ANT_FCSI_RESERVED1",
        "register_ANT_FCSI_REG0",
        "register_ANT_FCSI_REG1",
        "register_ANT_FCSI_REG2",
        "register_ANT_FCSI_REG3",
        "register_ANT_FCSI_RESERVED2"
];
        // Register //////////////////////////
        register_ANT_FCSI_RESERVED0 = new Object ();
        register_ANT_FCSI_RESERVED0.reserved = true;
        register_ANT_FCSI_RESERVED0.parent = "port_ANT_FCSI";
        register_ANT_FCSI_RESERVED0.resetVal = "16'bXXXXXXXXXXXXXXXX";
        register_ANT_FCSI_RESERVED0.usedBits = "16'b0000000000000000";
        register_ANT_FCSI_RESERVED0.undefBits = "16'b1111111111111111";
        register_ANT_FCSI_RESERVED0.indirectAccessPort = "";
        register_ANT_FCSI_RESERVED0.hasMutationsByAttributes = "false";
        // AddressableNode //////////////////////
        // BasicInfo //////////////////////////
        register_ANT_FCSI_RESERVED0.jsName      = "register_ANT_FCSI_RESERVED0";
        register_ANT_FCSI_RESERVED0.type        = "register";
        register_ANT_FCSI_RESERVED0.baseName    = "RESERVED";
        register_ANT_FCSI_RESERVED0.instName    = "RESERVED0";
        register_ANT_FCSI_RESERVED0.aliasName   = "RESERVED0";
        register_ANT_FCSI_RESERVED0.longName    = "reserved";
        register_ANT_FCSI_RESERVED0.description = "";
        register_ANT_FCSI_RESERVED0.file = "";
        register_ANT_FCSI_RESERVED0.contacts    = "user_hebeinth";
        register_ANT_FCSI_RESERVED0.references = [
        ];
        register_ANT_FCSI_RESERVED0.links = new Array ();
        register_ANT_FCSI_RESERVED0.pictures = new Array ();
        register_ANT_FCSI_RESERVED0.debugMessages = [
];
        register_ANT_FCSI_RESERVED0.views  = [
                "port_ANT_FCSI"
        ];
        register_ANT_FCSI_RESERVED0.addrBase   = "32'b00000000000000000000000000010000";
        register_ANT_FCSI_RESERVED0.addrStart  = new Array ();
        register_ANT_FCSI_RESERVED0.addrEnd    = new Array ();
        register_ANT_FCSI_RESERVED0.addrSpace  = new Array ();
        register_ANT_FCSI_RESERVED0.dataWidth  = new Array ();
        register_ANT_FCSI_RESERVED0.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000000000000";
        register_ANT_FCSI_RESERVED0.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000000111111";
        register_ANT_FCSI_RESERVED0.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000001000000";
        register_ANT_FCSI_RESERVED0.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
        register_ANT_FCSI_RESERVED0.addrStart ["register_ANT_FCSI_RESERVED0"] = "32'b00000000000000000000000000000000";
        register_ANT_FCSI_RESERVED0.addrEnd ["register_ANT_FCSI_RESERVED0"] = "32'b00000000000000000000000000111111";
        register_ANT_FCSI_RESERVED0.addrSpace ["register_ANT_FCSI_RESERVED0"] = "32'b00000000000000000000000001000000";
        register_ANT_FCSI_RESERVED0.dataWidth ["register_ANT_FCSI_RESERVED0"] = "32'b00000000000000000000000000010000";
        register_ANT_FCSI_RESERVED0.offsetAsView     = "32'b00000000000000000000000000000000"
        register_ANT_FCSI_RESERVED0.allowAddrOverlap = false;
        register_ANT_FCSI_RESERVED0.isCollapsedIntoPort = false;
        register_ANT_FCSI_RESERVED0.isLossless = true;
        register_ANT_FCSI_RESERVED0.access       = new Array ();
        register_ANT_FCSI_RESERVED0.access ["port_ANT_FCSI"] = "NONE";
        register_ANT_FCSI_RESERVED0.access ["register_ANT_FCSI_RESERVED0"] = "NONE";
        register_ANT_FCSI_RESERVED0.hierarchies       = new Array ();
        register_ANT_FCSI_RESERVED0.hierarchies ["port_ANT_FCSI"] = [
                "port_ANT_FCSI",
                "register_ANT_FCSI_RESERVED0"
        ];
        register_ANT_FCSI_RESERVED0.fields = new Array ();
        register_ANT_FCSI_RESERVED0.fields = [
        ];
        register_ANT_FCSI_RESERVED0.attributes = new Array ();
        // AttributeContainer ////////////////////
        /////////////////////////////////

        // Register //////////////////////////
        register_ANT_FCSI_RESERVED1 = new Object ();
        register_ANT_FCSI_RESERVED1.reserved = true;
        register_ANT_FCSI_RESERVED1.parent = "port_ANT_FCSI";
        register_ANT_FCSI_RESERVED1.resetVal = "16'bXXXXXXXXXXXXXXXX";
        register_ANT_FCSI_RESERVED1.usedBits = "16'b0000000000000000";
        register_ANT_FCSI_RESERVED1.undefBits = "16'b1111111111111111";
        register_ANT_FCSI_RESERVED1.indirectAccessPort = "";
        register_ANT_FCSI_RESERVED1.hasMutationsByAttributes = "false";
        // AddressableNode //////////////////////
        // BasicInfo //////////////////////////
        register_ANT_FCSI_RESERVED1.jsName      = "register_ANT_FCSI_RESERVED1";
        register_ANT_FCSI_RESERVED1.type        = "register";
        register_ANT_FCSI_RESERVED1.baseName    = "RESERVED";
        register_ANT_FCSI_RESERVED1.instName    = "RESERVED1";
        register_ANT_FCSI_RESERVED1.aliasName   = "RESERVED1";
        register_ANT_FCSI_RESERVED1.longName    = "reserved";
        register_ANT_FCSI_RESERVED1.description = "";
        register_ANT_FCSI_RESERVED1.file = "";
        register_ANT_FCSI_RESERVED1.contacts    = "user_hebeinth";
        register_ANT_FCSI_RESERVED1.references = [
        ];
        register_ANT_FCSI_RESERVED1.links = new Array ();
        register_ANT_FCSI_RESERVED1.pictures = new Array ();
        register_ANT_FCSI_RESERVED1.debugMessages = [
];
        register_ANT_FCSI_RESERVED1.views  = [
                "port_ANT_FCSI"
        ];
        register_ANT_FCSI_RESERVED1.addrBase   = "32'b00000000000000000000000000010000";
        register_ANT_FCSI_RESERVED1.addrStart  = new Array ();
        register_ANT_FCSI_RESERVED1.addrEnd    = new Array ();
        register_ANT_FCSI_RESERVED1.addrSpace  = new Array ();
        register_ANT_FCSI_RESERVED1.dataWidth  = new Array ();
        register_ANT_FCSI_RESERVED1.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001001010";
        register_ANT_FCSI_RESERVED1.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001001011";
        register_ANT_FCSI_RESERVED1.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000010";
        register_ANT_FCSI_RESERVED1.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
        register_ANT_FCSI_RESERVED1.addrStart ["register_ANT_FCSI_RESERVED1"] = "32'b00000000000000000000000001001010";
        register_ANT_FCSI_RESERVED1.addrEnd ["register_ANT_FCSI_RESERVED1"] = "32'b00000000000000000000000001001011";
        register_ANT_FCSI_RESERVED1.addrSpace ["register_ANT_FCSI_RESERVED1"] = "32'b00000000000000000000000000000010";
        register_ANT_FCSI_RESERVED1.dataWidth ["register_ANT_FCSI_RESERVED1"] = "32'b00000000000000000000000000010000";
        register_ANT_FCSI_RESERVED1.offsetAsView     = "32'b00000000000000000000000000000000"
        register_ANT_FCSI_RESERVED1.allowAddrOverlap = false;
        register_ANT_FCSI_RESERVED1.isCollapsedIntoPort = false;
        register_ANT_FCSI_RESERVED1.isLossless = true;
        register_ANT_FCSI_RESERVED1.access       = new Array ();
        register_ANT_FCSI_RESERVED1.access ["port_ANT_FCSI"] = "NONE";
        register_ANT_FCSI_RESERVED1.access ["register_ANT_FCSI_RESERVED1"] = "NONE";
        register_ANT_FCSI_RESERVED1.hierarchies       = new Array ();
        register_ANT_FCSI_RESERVED1.hierarchies ["port_ANT_FCSI"] = [
                "port_ANT_FCSI",
                "register_ANT_FCSI_RESERVED1"
        ];
        register_ANT_FCSI_RESERVED1.fields = new Array ();
        register_ANT_FCSI_RESERVED1.fields = [
        ];
        register_ANT_FCSI_RESERVED1.attributes = new Array ();
        // AttributeContainer ////////////////////
        /////////////////////////////////

        // Register //////////////////////////
        register_ANT_FCSI_RESERVED2 = new Object ();
        register_ANT_FCSI_RESERVED2.reserved = true;
        register_ANT_FCSI_RESERVED2.parent = "port_ANT_FCSI";
        register_ANT_FCSI_RESERVED2.resetVal = "16'bXXXXXXXXXXXXXXXX";
        register_ANT_FCSI_RESERVED2.usedBits = "16'b0000000000000000";
        register_ANT_FCSI_RESERVED2.undefBits = "16'b1111111111111111";
        register_ANT_FCSI_RESERVED2.indirectAccessPort = "";
        register_ANT_FCSI_RESERVED2.hasMutationsByAttributes = "false";
        // AddressableNode //////////////////////
        // BasicInfo //////////////////////////
        register_ANT_FCSI_RESERVED2.jsName      = "register_ANT_FCSI_RESERVED2";
        register_ANT_FCSI_RESERVED2.type        = "register";
        register_ANT_FCSI_RESERVED2.baseName    = "RESERVED";
        register_ANT_FCSI_RESERVED2.instName    = "RESERVED2";
        register_ANT_FCSI_RESERVED2.aliasName   = "RESERVED2";
        register_ANT_FCSI_RESERVED2.longName    = "reserved";
        register_ANT_FCSI_RESERVED2.description = "";
        register_ANT_FCSI_RESERVED2.file = "";
        register_ANT_FCSI_RESERVED2.contacts    = "user_hebeinth";
        register_ANT_FCSI_RESERVED2.references = [
        ];
        register_ANT_FCSI_RESERVED2.links = new Array ();
        register_ANT_FCSI_RESERVED2.pictures = new Array ();
        register_ANT_FCSI_RESERVED2.debugMessages = [
];
        register_ANT_FCSI_RESERVED2.views  = [
                "port_ANT_FCSI"
        ];
        register_ANT_FCSI_RESERVED2.addrBase   = "32'b00000000000000000000000000010000";
        register_ANT_FCSI_RESERVED2.addrStart  = new Array ();
        register_ANT_FCSI_RESERVED2.addrEnd    = new Array ();
        register_ANT_FCSI_RESERVED2.addrSpace  = new Array ();
        register_ANT_FCSI_RESERVED2.dataWidth  = new Array ();
        register_ANT_FCSI_RESERVED2.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001010000";
        register_ANT_FCSI_RESERVED2.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001111111";
        register_ANT_FCSI_RESERVED2.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000110000";
        register_ANT_FCSI_RESERVED2.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
        register_ANT_FCSI_RESERVED2.addrStart ["register_ANT_FCSI_RESERVED2"] = "32'b00000000000000000000000001010000";
        register_ANT_FCSI_RESERVED2.addrEnd ["register_ANT_FCSI_RESERVED2"] = "32'b00000000000000000000000001111111";
        register_ANT_FCSI_RESERVED2.addrSpace ["register_ANT_FCSI_RESERVED2"] = "32'b00000000000000000000000000110000";
        register_ANT_FCSI_RESERVED2.dataWidth ["register_ANT_FCSI_RESERVED2"] = "32'b00000000000000000000000000010000";
        register_ANT_FCSI_RESERVED2.offsetAsView     = "32'b00000000000000000000000000000000"
        register_ANT_FCSI_RESERVED2.allowAddrOverlap = false;
        register_ANT_FCSI_RESERVED2.isCollapsedIntoPort = false;
        register_ANT_FCSI_RESERVED2.isLossless = true;
        register_ANT_FCSI_RESERVED2.access       = new Array ();
        register_ANT_FCSI_RESERVED2.access ["port_ANT_FCSI"] = "NONE";
        register_ANT_FCSI_RESERVED2.access ["register_ANT_FCSI_RESERVED2"] = "NONE";
        register_ANT_FCSI_RESERVED2.hierarchies       = new Array ();
        register_ANT_FCSI_RESERVED2.hierarchies ["port_ANT_FCSI"] = [
                "port_ANT_FCSI",
                "register_ANT_FCSI_RESERVED2"
        ];
        register_ANT_FCSI_RESERVED2.fields = new Array ();
        register_ANT_FCSI_RESERVED2.fields = [
        ];
        register_ANT_FCSI_RESERVED2.attributes = new Array ();
        // AttributeContainer ////////////////////
        /////////////////////////////////

port_ANT_FCSI.viewPorts = [
"port_ANT_FCSI"
 ];
port_ANT_FCSI.viewRegisters = [
"register_ANT_FCSI_IQADCREG0", 
"register_ANT_FCSI_IQADCREG1", 
"register_ANT_FCSI_IQADCREG2", 
"register_ANT_FCSI_IQADCREG3", 
"register_ANT_FCSI_REGCLOCKING", 
"register_ANT_FCSI_REGBIASING", 
"register_ANT_FCSI_REGLDO", 
"register_ANT_FCSI_REGANAMUX", 
"register_ANT_FCSI_IQDACREG0", 
"register_ANT_FCSI_IQDACREG1", 
"register_ANT_FCSI_REG0", 
"register_ANT_FCSI_REG1", 
"register_ANT_FCSI_REG2", 
"register_ANT_FCSI_REG3"
 ];
port_ANT_FCSI.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_REG3 = new Object ();
register_ANT_FCSI_REG3.reserved = false;
register_ANT_FCSI_REG3.parent = "port_ANT_FCSI";
register_ANT_FCSI_REG3.resetVal = "16'bXXXXXXXX00000000";
register_ANT_FCSI_REG3.usedBits = "16'b0000000011111111";
register_ANT_FCSI_REG3.undefBits = "16'b1111111100000000";
register_ANT_FCSI_REG3.indirectAccessPort = "";
register_ANT_FCSI_REG3.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_REG3.jsName      = "register_ANT_FCSI_REG3";
register_ANT_FCSI_REG3.type        = "register";
register_ANT_FCSI_REG3.baseName    = "BASIC";
register_ANT_FCSI_REG3.instName    = "REG3";
register_ANT_FCSI_REG3.aliasName   = "REG3";
register_ANT_FCSI_REG3.longName    = "SSI_REG3";
register_ANT_FCSI_REG3.description = "SSI_REG3";
register_ANT_FCSI_REG3.file = "";
register_ANT_FCSI_REG3.contacts    = "user_pridnig";
register_ANT_FCSI_REG3.references = [
];
register_ANT_FCSI_REG3.links = new Array ();
register_ANT_FCSI_REG3.pictures = new Array ();
register_ANT_FCSI_REG3.debugMessages = [
];
register_ANT_FCSI_REG3.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_REG3.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG3.addrStart  = new Array ();
register_ANT_FCSI_REG3.addrEnd    = new Array ();
register_ANT_FCSI_REG3.addrSpace  = new Array ();
register_ANT_FCSI_REG3.dataWidth  = new Array ();
register_ANT_FCSI_REG3.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001001111";
register_ANT_FCSI_REG3.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001001111";
register_ANT_FCSI_REG3.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REG3.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG3.addrStart ["register_ANT_FCSI_REG3"] = "32'b00000000000000000000000001001111";
register_ANT_FCSI_REG3.addrEnd ["register_ANT_FCSI_REG3"] = "32'b00000000000000000000000001001111";
register_ANT_FCSI_REG3.addrSpace ["register_ANT_FCSI_REG3"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REG3.dataWidth ["register_ANT_FCSI_REG3"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG3.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_REG3.allowAddrOverlap = false;
register_ANT_FCSI_REG3.isCollapsedIntoPort = false;
register_ANT_FCSI_REG3.isLossless = true;
register_ANT_FCSI_REG3.access       = new Array ();
register_ANT_FCSI_REG3.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_REG3.access ["register_ANT_FCSI_REG3"] = "RW";
register_ANT_FCSI_REG3.hierarchies       = new Array ();
register_ANT_FCSI_REG3.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_REG3"
];
register_ANT_FCSI_REG3.fields = new Array ();
register_ANT_FCSI_REG3.fields = [
        "rfield_ANT_FCSI_REG3_CALRDO"
];
register_ANT_FCSI_REG3.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG3_CALRDO = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG3_CALRDO.jsName      = "rfield_ANT_FCSI_REG3_CALRDO";
rfield_ANT_FCSI_REG3_CALRDO.type        = "rfield";
rfield_ANT_FCSI_REG3_CALRDO.baseName    = "BASIC";
rfield_ANT_FCSI_REG3_CALRDO.instName    = "CALRDO";
rfield_ANT_FCSI_REG3_CALRDO.aliasName   = "CALRDO";
rfield_ANT_FCSI_REG3_CALRDO.longName    = "cal_rd_o";
rfield_ANT_FCSI_REG3_CALRDO.description = "<p>cal_rd_o</p>";
rfield_ANT_FCSI_REG3_CALRDO.file = "";
rfield_ANT_FCSI_REG3_CALRDO.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG3_CALRDO.references = [
];
rfield_ANT_FCSI_REG3_CALRDO.links = new Array ();
rfield_ANT_FCSI_REG3_CALRDO.pictures = new Array ();
rfield_ANT_FCSI_REG3_CALRDO.debugMessages = [
];
rfield_ANT_FCSI_REG3_CALRDO.parent = "register_ANT_FCSI_REG3";
rfield_ANT_FCSI_REG3_CALRDO.resetVal = "8'b00000000";
rfield_ANT_FCSI_REG3_CALRDO.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REG3_CALRDO.addrEnd = "32'b00000000000000000000000000000111";
rfield_ANT_FCSI_REG3_CALRDO.dataWidth = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_REG3_CALRDO.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG3_CALRDO.accessProperties = new Array ();
rfield_ANT_FCSI_REG3_CALRDO.accessProperties ["port_ANT_FCSI"] = "r,DEFAULT,-,-,Read only field.";
rfield_ANT_FCSI_REG3_CALRDO.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0 = [
        [ "MIN", "8'b00000000", "MIN" ], 
        [ "MAX", "8'b11111111", "MAX" ]];
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG3_CALRDO";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0";
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration [0] = rfield_ANT_FCSI_REG3_CALRDO.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_REG2 = new Object ();
register_ANT_FCSI_REG2.reserved = false;
register_ANT_FCSI_REG2.parent = "port_ANT_FCSI";
register_ANT_FCSI_REG2.resetVal = "16'b0000000000000000";
register_ANT_FCSI_REG2.usedBits = "16'b1111111111111111";
register_ANT_FCSI_REG2.undefBits = "16'b0000000000000000";
register_ANT_FCSI_REG2.indirectAccessPort = "";
register_ANT_FCSI_REG2.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_REG2.jsName      = "register_ANT_FCSI_REG2";
register_ANT_FCSI_REG2.type        = "register";
register_ANT_FCSI_REG2.baseName    = "BASIC";
register_ANT_FCSI_REG2.instName    = "REG2";
register_ANT_FCSI_REG2.aliasName   = "REG2";
register_ANT_FCSI_REG2.longName    = "SSI_REG2";
register_ANT_FCSI_REG2.description = "SSI_REG2";
register_ANT_FCSI_REG2.file = "";
register_ANT_FCSI_REG2.contacts    = "user_pridnig";
register_ANT_FCSI_REG2.references = [
];
register_ANT_FCSI_REG2.links = new Array ();
register_ANT_FCSI_REG2.pictures = new Array ();
register_ANT_FCSI_REG2.debugMessages = [
];
register_ANT_FCSI_REG2.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_REG2.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG2.addrStart  = new Array ();
register_ANT_FCSI_REG2.addrEnd    = new Array ();
register_ANT_FCSI_REG2.addrSpace  = new Array ();
register_ANT_FCSI_REG2.dataWidth  = new Array ();
register_ANT_FCSI_REG2.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001001110";
register_ANT_FCSI_REG2.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001001110";
register_ANT_FCSI_REG2.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REG2.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG2.addrStart ["register_ANT_FCSI_REG2"] = "32'b00000000000000000000000001001110";
register_ANT_FCSI_REG2.addrEnd ["register_ANT_FCSI_REG2"] = "32'b00000000000000000000000001001110";
register_ANT_FCSI_REG2.addrSpace ["register_ANT_FCSI_REG2"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REG2.dataWidth ["register_ANT_FCSI_REG2"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG2.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_REG2.allowAddrOverlap = false;
register_ANT_FCSI_REG2.isCollapsedIntoPort = false;
register_ANT_FCSI_REG2.isLossless = true;
register_ANT_FCSI_REG2.access       = new Array ();
register_ANT_FCSI_REG2.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_REG2.access ["register_ANT_FCSI_REG2"] = "RW";
register_ANT_FCSI_REG2.hierarchies       = new Array ();
register_ANT_FCSI_REG2.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_REG2"
];
register_ANT_FCSI_REG2.fields = new Array ();
register_ANT_FCSI_REG2.fields = [
        "rfield_ANT_FCSI_REG2_CALWR",
        "rfield_ANT_FCSI_REG2_CALPPSEL",
        "rfield_ANT_FCSI_REG2_CALSELMSB",
        "rfield_ANT_FCSI_REG2_CALWREN",
        "rfield_ANT_FCSI_REG2_CALSTOP",
        "rfield_ANT_FCSI_REG2_UPPPON",
        "rfield_ANT_FCSI_REG2_UPPPSEL"
];
register_ANT_FCSI_REG2.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG2_UPPPSEL = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_UPPPSEL.jsName      = "rfield_ANT_FCSI_REG2_UPPPSEL";
rfield_ANT_FCSI_REG2_UPPPSEL.type        = "rfield";
rfield_ANT_FCSI_REG2_UPPPSEL.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_UPPPSEL.instName    = "UPPPSEL";
rfield_ANT_FCSI_REG2_UPPPSEL.aliasName   = "UPPPSEL";
rfield_ANT_FCSI_REG2_UPPPSEL.longName    = "up_ppsel";
rfield_ANT_FCSI_REG2_UPPPSEL.description = "<p>up_ppsel</p>";
rfield_ANT_FCSI_REG2_UPPPSEL.file = "";
rfield_ANT_FCSI_REG2_UPPPSEL.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_UPPPSEL.references = [
];
rfield_ANT_FCSI_REG2_UPPPSEL.links = new Array ();
rfield_ANT_FCSI_REG2_UPPPSEL.pictures = new Array ();
rfield_ANT_FCSI_REG2_UPPPSEL.debugMessages = [
];
rfield_ANT_FCSI_REG2_UPPPSEL.parent = "register_ANT_FCSI_REG2";
rfield_ANT_FCSI_REG2_UPPPSEL.resetVal = "2'b00";
rfield_ANT_FCSI_REG2_UPPPSEL.addrStart = "32'b00000000000000000000000000001110";
rfield_ANT_FCSI_REG2_UPPPSEL.addrEnd = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_REG2_UPPPSEL.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REG2_UPPPSEL.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG2_UPPPSEL.accessProperties = new Array ();
rfield_ANT_FCSI_REG2_UPPPSEL.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0 = [
        [ "OFF", "2'b00", "OFF" ], 
        [ "ON", "2'b01", "ON" ]];
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG2_UPPPSEL";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration [0] = rfield_ANT_FCSI_REG2_UPPPSEL.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG2_UPPPON = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_UPPPON.jsName      = "rfield_ANT_FCSI_REG2_UPPPON";
rfield_ANT_FCSI_REG2_UPPPON.type        = "rfield";
rfield_ANT_FCSI_REG2_UPPPON.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_UPPPON.instName    = "UPPPON";
rfield_ANT_FCSI_REG2_UPPPON.aliasName   = "UPPPON";
rfield_ANT_FCSI_REG2_UPPPON.longName    = "up_ppon";
rfield_ANT_FCSI_REG2_UPPPON.description = "<p>up_ppon</p>";
rfield_ANT_FCSI_REG2_UPPPON.file = "";
rfield_ANT_FCSI_REG2_UPPPON.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_UPPPON.references = [
];
rfield_ANT_FCSI_REG2_UPPPON.links = new Array ();
rfield_ANT_FCSI_REG2_UPPPON.pictures = new Array ();
rfield_ANT_FCSI_REG2_UPPPON.debugMessages = [
];
rfield_ANT_FCSI_REG2_UPPPON.parent = "register_ANT_FCSI_REG2";
rfield_ANT_FCSI_REG2_UPPPON.resetVal = "1'b0";
rfield_ANT_FCSI_REG2_UPPPON.addrStart = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_REG2_UPPPON.addrEnd = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_REG2_UPPPON.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG2_UPPPON.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG2_UPPPON.accessProperties = new Array ();
rfield_ANT_FCSI_REG2_UPPPON.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG2_UPPPON.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "OFF" ], 
        [ "ON", "1'b1", "ON" ]];
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG2_UPPPON";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0";
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration [0] = rfield_ANT_FCSI_REG2_UPPPON.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG2_CALSTOP = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALSTOP.jsName      = "rfield_ANT_FCSI_REG2_CALSTOP";
rfield_ANT_FCSI_REG2_CALSTOP.type        = "rfield";
rfield_ANT_FCSI_REG2_CALSTOP.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALSTOP.instName    = "CALSTOP";
rfield_ANT_FCSI_REG2_CALSTOP.aliasName   = "CALSTOP";
rfield_ANT_FCSI_REG2_CALSTOP.longName    = "cal_stop_i";
rfield_ANT_FCSI_REG2_CALSTOP.description = "<p>Stop offset calibration</p>";
rfield_ANT_FCSI_REG2_CALSTOP.file = "";
rfield_ANT_FCSI_REG2_CALSTOP.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALSTOP.references = [
];
rfield_ANT_FCSI_REG2_CALSTOP.links = new Array ();
rfield_ANT_FCSI_REG2_CALSTOP.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALSTOP.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALSTOP.parent = "register_ANT_FCSI_REG2";
rfield_ANT_FCSI_REG2_CALSTOP.resetVal = "1'b0";
rfield_ANT_FCSI_REG2_CALSTOP.addrStart = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_REG2_CALSTOP.addrEnd = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_REG2_CALSTOP.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG2_CALSTOP.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG2_CALSTOP.accessProperties = new Array ();
rfield_ANT_FCSI_REG2_CALSTOP.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG2_CALSTOP.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "Calibration Stop OFF (default)" ], 
        [ "ON", "1'b1", "Calibration Stop ON" ]];
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG2_CALSTOP";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0";
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration [0] = rfield_ANT_FCSI_REG2_CALSTOP.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG2_CALWREN = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALWREN.jsName      = "rfield_ANT_FCSI_REG2_CALWREN";
rfield_ANT_FCSI_REG2_CALWREN.type        = "rfield";
rfield_ANT_FCSI_REG2_CALWREN.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALWREN.instName    = "CALWREN";
rfield_ANT_FCSI_REG2_CALWREN.aliasName   = "CALWREN";
rfield_ANT_FCSI_REG2_CALWREN.longName    = "cal_wren";
rfield_ANT_FCSI_REG2_CALWREN.description = "<p>Write enable for calibration register</p>";
rfield_ANT_FCSI_REG2_CALWREN.file = "";
rfield_ANT_FCSI_REG2_CALWREN.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALWREN.references = [
];
rfield_ANT_FCSI_REG2_CALWREN.links = new Array ();
rfield_ANT_FCSI_REG2_CALWREN.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALWREN.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALWREN.parent = "register_ANT_FCSI_REG2";
rfield_ANT_FCSI_REG2_CALWREN.resetVal = "1'b0";
rfield_ANT_FCSI_REG2_CALWREN.addrStart = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_REG2_CALWREN.addrEnd = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_REG2_CALWREN.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG2_CALWREN.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG2_CALWREN.accessProperties = new Array ();
rfield_ANT_FCSI_REG2_CALWREN.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG2_CALWREN.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "Calibration Selection WREN OFF (default)" ], 
        [ "ON", "1'b1", "Calibration Selection WREN ON" ]];
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG2_CALWREN";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0";
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration [0] = rfield_ANT_FCSI_REG2_CALWREN.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG2_CALSELMSB = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALSELMSB.jsName      = "rfield_ANT_FCSI_REG2_CALSELMSB";
rfield_ANT_FCSI_REG2_CALSELMSB.type        = "rfield";
rfield_ANT_FCSI_REG2_CALSELMSB.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALSELMSB.instName    = "CALSELMSB";
rfield_ANT_FCSI_REG2_CALSELMSB.aliasName   = "CALSELMSB";
rfield_ANT_FCSI_REG2_CALSELMSB.longName    = "cal_selmsb";
rfield_ANT_FCSI_REG2_CALSELMSB.description = "<p>cal_selmsb</p>";
rfield_ANT_FCSI_REG2_CALSELMSB.file = "";
rfield_ANT_FCSI_REG2_CALSELMSB.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALSELMSB.references = [
];
rfield_ANT_FCSI_REG2_CALSELMSB.links = new Array ();
rfield_ANT_FCSI_REG2_CALSELMSB.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALSELMSB.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALSELMSB.parent = "register_ANT_FCSI_REG2";
rfield_ANT_FCSI_REG2_CALSELMSB.resetVal = "1'b0";
rfield_ANT_FCSI_REG2_CALSELMSB.addrStart = "32'b00000000000000000000000000001010";
rfield_ANT_FCSI_REG2_CALSELMSB.addrEnd = "32'b00000000000000000000000000001010";
rfield_ANT_FCSI_REG2_CALSELMSB.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG2_CALSELMSB.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG2_CALSELMSB.accessProperties = new Array ();
rfield_ANT_FCSI_REG2_CALSELMSB.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "Cal Selection MSB OFF (default)" ], 
        [ "ON", "1'b1", "Cal Selection MSB ON" ]];
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG2_CALSELMSB";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration [0] = rfield_ANT_FCSI_REG2_CALSELMSB.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG2_CALPPSEL = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALPPSEL.jsName      = "rfield_ANT_FCSI_REG2_CALPPSEL";
rfield_ANT_FCSI_REG2_CALPPSEL.type        = "rfield";
rfield_ANT_FCSI_REG2_CALPPSEL.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALPPSEL.instName    = "CALPPSEL";
rfield_ANT_FCSI_REG2_CALPPSEL.aliasName   = "CALPPSEL";
rfield_ANT_FCSI_REG2_CALPPSEL.longName    = "cal_ppsel";
rfield_ANT_FCSI_REG2_CALPPSEL.description = "<p>cal_ppsel</p>";
rfield_ANT_FCSI_REG2_CALPPSEL.file = "";
rfield_ANT_FCSI_REG2_CALPPSEL.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALPPSEL.references = [
];
rfield_ANT_FCSI_REG2_CALPPSEL.links = new Array ();
rfield_ANT_FCSI_REG2_CALPPSEL.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALPPSEL.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALPPSEL.parent = "register_ANT_FCSI_REG2";
rfield_ANT_FCSI_REG2_CALPPSEL.resetVal = "2'b00";
rfield_ANT_FCSI_REG2_CALPPSEL.addrStart = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_REG2_CALPPSEL.addrEnd = "32'b00000000000000000000000000001001";
rfield_ANT_FCSI_REG2_CALPPSEL.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REG2_CALPPSEL.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG2_CALPPSEL.accessProperties = new Array ();
rfield_ANT_FCSI_REG2_CALPPSEL.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0 = [
        [ "MIN", "2'b00", "Cal PolyPhase Selection OFF" ]];
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG2_CALPPSEL";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration [0] = rfield_ANT_FCSI_REG2_CALPPSEL.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG2_CALWR = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALWR.jsName      = "rfield_ANT_FCSI_REG2_CALWR";
rfield_ANT_FCSI_REG2_CALWR.type        = "rfield";
rfield_ANT_FCSI_REG2_CALWR.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALWR.instName    = "CALWR";
rfield_ANT_FCSI_REG2_CALWR.aliasName   = "CALWR";
rfield_ANT_FCSI_REG2_CALWR.longName    = "cal_wr";
rfield_ANT_FCSI_REG2_CALWR.description = "<p>Write offset calibration data</p>";
rfield_ANT_FCSI_REG2_CALWR.file = "";
rfield_ANT_FCSI_REG2_CALWR.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALWR.references = [
];
rfield_ANT_FCSI_REG2_CALWR.links = new Array ();
rfield_ANT_FCSI_REG2_CALWR.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALWR.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALWR.parent = "register_ANT_FCSI_REG2";
rfield_ANT_FCSI_REG2_CALWR.resetVal = "8'b00000000";
rfield_ANT_FCSI_REG2_CALWR.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REG2_CALWR.addrEnd = "32'b00000000000000000000000000000111";
rfield_ANT_FCSI_REG2_CALWR.dataWidth = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_REG2_CALWR.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG2_CALWR.accessProperties = new Array ();
rfield_ANT_FCSI_REG2_CALWR.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG2_CALWR.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0 = [
        [ "MIN", "8'b00000000", "MIN (default)" ], 
        [ "MAX", "8'b11111111", "MAX" ]];
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG2_CALWR";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0";
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration [0] = rfield_ANT_FCSI_REG2_CALWR.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_REG1 = new Object ();
register_ANT_FCSI_REG1.reserved = false;
register_ANT_FCSI_REG1.parent = "port_ANT_FCSI";
register_ANT_FCSI_REG1.resetVal = "16'bXX011100XX110010";
register_ANT_FCSI_REG1.usedBits = "16'b0011111100111111";
register_ANT_FCSI_REG1.undefBits = "16'b1100000011000000";
register_ANT_FCSI_REG1.indirectAccessPort = "";
register_ANT_FCSI_REG1.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_REG1.jsName      = "register_ANT_FCSI_REG1";
register_ANT_FCSI_REG1.type        = "register";
register_ANT_FCSI_REG1.baseName    = "BASIC";
register_ANT_FCSI_REG1.instName    = "REG1";
register_ANT_FCSI_REG1.aliasName   = "REG1";
register_ANT_FCSI_REG1.longName    = "SSI_REG1";
register_ANT_FCSI_REG1.description = "SSI_REG1";
register_ANT_FCSI_REG1.file = "";
register_ANT_FCSI_REG1.contacts    = "user_pridnig";
register_ANT_FCSI_REG1.references = [
];
register_ANT_FCSI_REG1.links = new Array ();
register_ANT_FCSI_REG1.pictures = new Array ();
register_ANT_FCSI_REG1.debugMessages = [
];
register_ANT_FCSI_REG1.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_REG1.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG1.addrStart  = new Array ();
register_ANT_FCSI_REG1.addrEnd    = new Array ();
register_ANT_FCSI_REG1.addrSpace  = new Array ();
register_ANT_FCSI_REG1.dataWidth  = new Array ();
register_ANT_FCSI_REG1.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001001101";
register_ANT_FCSI_REG1.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001001101";
register_ANT_FCSI_REG1.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REG1.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG1.addrStart ["register_ANT_FCSI_REG1"] = "32'b00000000000000000000000001001101";
register_ANT_FCSI_REG1.addrEnd ["register_ANT_FCSI_REG1"] = "32'b00000000000000000000000001001101";
register_ANT_FCSI_REG1.addrSpace ["register_ANT_FCSI_REG1"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REG1.dataWidth ["register_ANT_FCSI_REG1"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG1.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_REG1.allowAddrOverlap = false;
register_ANT_FCSI_REG1.isCollapsedIntoPort = false;
register_ANT_FCSI_REG1.isLossless = true;
register_ANT_FCSI_REG1.access       = new Array ();
register_ANT_FCSI_REG1.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_REG1.access ["register_ANT_FCSI_REG1"] = "RW";
register_ANT_FCSI_REG1.hierarchies       = new Array ();
register_ANT_FCSI_REG1.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_REG1"
];
register_ANT_FCSI_REG1.fields = new Array ();
register_ANT_FCSI_REG1.fields = [
        "rfield_ANT_FCSI_REG1_SSISEL",
        "rfield_ANT_FCSI_REG1_SSIBUFBIASCONF",
        "rfield_ANT_FCSI_REG1_ENPHASES",
        "rfield_ANT_FCSI_REG1_NOCYCLES",
        "rfield_ANT_FCSI_REG1_TRIMOFF"
];
register_ANT_FCSI_REG1.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG1_TRIMOFF = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_TRIMOFF.jsName      = "rfield_ANT_FCSI_REG1_TRIMOFF";
rfield_ANT_FCSI_REG1_TRIMOFF.type        = "rfield";
rfield_ANT_FCSI_REG1_TRIMOFF.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_TRIMOFF.instName    = "TRIMOFF";
rfield_ANT_FCSI_REG1_TRIMOFF.aliasName   = "TRIMOFF";
rfield_ANT_FCSI_REG1_TRIMOFF.longName    = "trim_off";
rfield_ANT_FCSI_REG1_TRIMOFF.description = "<p><b>Not Used</b><br/><br/>trim_off of vcm</p>";
rfield_ANT_FCSI_REG1_TRIMOFF.file = "";
rfield_ANT_FCSI_REG1_TRIMOFF.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_TRIMOFF.references = [
];
rfield_ANT_FCSI_REG1_TRIMOFF.links = new Array ();
rfield_ANT_FCSI_REG1_TRIMOFF.pictures = new Array ();
rfield_ANT_FCSI_REG1_TRIMOFF.debugMessages = [
];
rfield_ANT_FCSI_REG1_TRIMOFF.parent = "register_ANT_FCSI_REG1";
rfield_ANT_FCSI_REG1_TRIMOFF.resetVal = "2'b01";
rfield_ANT_FCSI_REG1_TRIMOFF.addrStart = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_REG1_TRIMOFF.addrEnd = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_REG1_TRIMOFF.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REG1_TRIMOFF.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG1_TRIMOFF.accessProperties = new Array ();
rfield_ANT_FCSI_REG1_TRIMOFF.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0 = [
        [ "490MV", "2'b00", "490mV" ], 
        [ "500MV", "2'b01", "500mV (default)" ], 
        [ "510MV", "2'b10", "510mV" ], 
        [ "520MV", "2'b11", "520mV" ]];
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG1_TRIMOFF";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration [0] = rfield_ANT_FCSI_REG1_TRIMOFF.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG1_NOCYCLES = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_NOCYCLES.jsName      = "rfield_ANT_FCSI_REG1_NOCYCLES";
rfield_ANT_FCSI_REG1_NOCYCLES.type        = "rfield";
rfield_ANT_FCSI_REG1_NOCYCLES.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_NOCYCLES.instName    = "NOCYCLES";
rfield_ANT_FCSI_REG1_NOCYCLES.aliasName   = "NOCYCLES";
rfield_ANT_FCSI_REG1_NOCYCLES.longName    = "no_cycles_i";
rfield_ANT_FCSI_REG1_NOCYCLES.description = "<p>Number of cycles: use values between 4 and 12 (4 = 1bit, 12 = 9bit)</p>";
rfield_ANT_FCSI_REG1_NOCYCLES.file = "";
rfield_ANT_FCSI_REG1_NOCYCLES.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_NOCYCLES.references = [
];
rfield_ANT_FCSI_REG1_NOCYCLES.links = new Array ();
rfield_ANT_FCSI_REG1_NOCYCLES.pictures = new Array ();
rfield_ANT_FCSI_REG1_NOCYCLES.debugMessages = [
];
rfield_ANT_FCSI_REG1_NOCYCLES.parent = "register_ANT_FCSI_REG1";
rfield_ANT_FCSI_REG1_NOCYCLES.resetVal = "4'b1100";
rfield_ANT_FCSI_REG1_NOCYCLES.addrStart = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_REG1_NOCYCLES.addrEnd = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_REG1_NOCYCLES.dataWidth = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_REG1_NOCYCLES.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG1_NOCYCLES.accessProperties = new Array ();
rfield_ANT_FCSI_REG1_NOCYCLES.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0 = [
        [ "11AC", "4'b1100", "11ac -&gt; 9bit (default)" ]];
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG1_NOCYCLES";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration [0] = rfield_ANT_FCSI_REG1_NOCYCLES.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG1_ENPHASES = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_ENPHASES.jsName      = "rfield_ANT_FCSI_REG1_ENPHASES";
rfield_ANT_FCSI_REG1_ENPHASES.type        = "rfield";
rfield_ANT_FCSI_REG1_ENPHASES.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_ENPHASES.instName    = "ENPHASES";
rfield_ANT_FCSI_REG1_ENPHASES.aliasName   = "ENPHASES";
rfield_ANT_FCSI_REG1_ENPHASES.longName    = "en_phases";
rfield_ANT_FCSI_REG1_ENPHASES.description = "<p>Enable Polyphases:use 2 both polyphases for WAVE500; just 1 polyphase -&gt; clkstrb/2</p>";
rfield_ANT_FCSI_REG1_ENPHASES.file = "";
rfield_ANT_FCSI_REG1_ENPHASES.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_ENPHASES.references = [
];
rfield_ANT_FCSI_REG1_ENPHASES.links = new Array ();
rfield_ANT_FCSI_REG1_ENPHASES.pictures = new Array ();
rfield_ANT_FCSI_REG1_ENPHASES.debugMessages = [
];
rfield_ANT_FCSI_REG1_ENPHASES.parent = "register_ANT_FCSI_REG1";
rfield_ANT_FCSI_REG1_ENPHASES.resetVal = "2'b11";
rfield_ANT_FCSI_REG1_ENPHASES.addrStart = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_REG1_ENPHASES.addrEnd = "32'b00000000000000000000000000000101";
rfield_ANT_FCSI_REG1_ENPHASES.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REG1_ENPHASES.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG1_ENPHASES.accessProperties = new Array ();
rfield_ANT_FCSI_REG1_ENPHASES.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG1_ENPHASES.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0 = [
        [ "NU", "2'b00", "not allowed" ], 
        [ "PP0", "2'b01", "pp0 active" ], 
        [ "PP1", "2'b10", "pp1 active" ], 
        [ "PP01", "2'b11", "pp0 and 1 active" ]];
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG1_ENPHASES";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0";
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration [0] = rfield_ANT_FCSI_REG1_ENPHASES.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.jsName      = "rfield_ANT_FCSI_REG1_SSIBUFBIASCONF";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.type        = "rfield";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.instName    = "SSIBUFBIASCONF";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.aliasName   = "SSIBUFBIASCONF";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.longName    = "ssibuf_bias_conf";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.description = "<p>Bias configuration for the SSI buffer</p>";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.file = "";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.references = [
];
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.links = new Array ();
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.pictures = new Array ();
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.debugMessages = [
];
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.parent = "register_ANT_FCSI_REG1";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.resetVal = "2'b00";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.addrStart = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.addrEnd = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.accessProperties = new Array ();
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0 = [
        [ "11AC", "2'b00", "11ac" ], 
        [ "NU", "2'b01", "Not Used" ], 
        [ "11N", "2'b10", "11n" ], 
        [ "LP", "2'b11", "LP" ]];
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG1_SSIBUFBIASCONF";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration [0] = rfield_ANT_FCSI_REG1_SSIBUFBIASCONF.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG1_SSISEL = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_SSISEL.jsName      = "rfield_ANT_FCSI_REG1_SSISEL";
rfield_ANT_FCSI_REG1_SSISEL.type        = "rfield";
rfield_ANT_FCSI_REG1_SSISEL.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_SSISEL.instName    = "SSISEL";
rfield_ANT_FCSI_REG1_SSISEL.aliasName   = "SSISEL";
rfield_ANT_FCSI_REG1_SSISEL.longName    = "ssi_sel";
rfield_ANT_FCSI_REG1_SSISEL.description = "<p>ssi_sel</p>";
rfield_ANT_FCSI_REG1_SSISEL.file = "";
rfield_ANT_FCSI_REG1_SSISEL.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_SSISEL.references = [
];
rfield_ANT_FCSI_REG1_SSISEL.links = new Array ();
rfield_ANT_FCSI_REG1_SSISEL.pictures = new Array ();
rfield_ANT_FCSI_REG1_SSISEL.debugMessages = [
];
rfield_ANT_FCSI_REG1_SSISEL.parent = "register_ANT_FCSI_REG1";
rfield_ANT_FCSI_REG1_SSISEL.resetVal = "2'b10";
rfield_ANT_FCSI_REG1_SSISEL.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REG1_SSISEL.addrEnd = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG1_SSISEL.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REG1_SSISEL.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG1_SSISEL.accessProperties = new Array ();
rfield_ANT_FCSI_REG1_SSISEL.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG1_SSISEL.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0 = [
        [ "IDAC", "2'b00", "idac selected (just testmode)" ], 
        [ "QDAC", "2'b01", "qdac selected (just testmode)" ], 
        [ "WRX", "2'b10", "wrx signal selected (default)" ], 
        [ "SINGLE", "2'b11", "single ended mode" ]];
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG1_SSISEL";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0";
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration [0] = rfield_ANT_FCSI_REG1_SSISEL.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_REG0 = new Object ();
register_ANT_FCSI_REG0.reserved = false;
register_ANT_FCSI_REG0.parent = "port_ANT_FCSI";
register_ANT_FCSI_REG0.resetVal = "16'b0110000000000001";
register_ANT_FCSI_REG0.usedBits = "16'b1111111111111111";
register_ANT_FCSI_REG0.undefBits = "16'b0000000000000000";
register_ANT_FCSI_REG0.indirectAccessPort = "";
register_ANT_FCSI_REG0.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_REG0.jsName      = "register_ANT_FCSI_REG0";
register_ANT_FCSI_REG0.type        = "register";
register_ANT_FCSI_REG0.baseName    = "BASIC";
register_ANT_FCSI_REG0.instName    = "REG0";
register_ANT_FCSI_REG0.aliasName   = "REG0";
register_ANT_FCSI_REG0.longName    = "SSI_REG0";
register_ANT_FCSI_REG0.description = "SSI_REG0";
register_ANT_FCSI_REG0.file = "";
register_ANT_FCSI_REG0.contacts    = "user_pridnig";
register_ANT_FCSI_REG0.references = [
];
register_ANT_FCSI_REG0.links = new Array ();
register_ANT_FCSI_REG0.pictures = new Array ();
register_ANT_FCSI_REG0.debugMessages = [
];
register_ANT_FCSI_REG0.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_REG0.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG0.addrStart  = new Array ();
register_ANT_FCSI_REG0.addrEnd    = new Array ();
register_ANT_FCSI_REG0.addrSpace  = new Array ();
register_ANT_FCSI_REG0.dataWidth  = new Array ();
register_ANT_FCSI_REG0.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001001100";
register_ANT_FCSI_REG0.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001001100";
register_ANT_FCSI_REG0.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REG0.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG0.addrStart ["register_ANT_FCSI_REG0"] = "32'b00000000000000000000000001001100";
register_ANT_FCSI_REG0.addrEnd ["register_ANT_FCSI_REG0"] = "32'b00000000000000000000000001001100";
register_ANT_FCSI_REG0.addrSpace ["register_ANT_FCSI_REG0"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REG0.dataWidth ["register_ANT_FCSI_REG0"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REG0.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_REG0.allowAddrOverlap = false;
register_ANT_FCSI_REG0.isCollapsedIntoPort = false;
register_ANT_FCSI_REG0.isLossless = true;
register_ANT_FCSI_REG0.access       = new Array ();
register_ANT_FCSI_REG0.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_REG0.access ["register_ANT_FCSI_REG0"] = "RW";
register_ANT_FCSI_REG0.hierarchies       = new Array ();
register_ANT_FCSI_REG0.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_REG0"
];
register_ANT_FCSI_REG0.fields = new Array ();
register_ANT_FCSI_REG0.fields = [
        "rfield_ANT_FCSI_REG0_PD",
        "rfield_ANT_FCSI_REG0_RESN",
        "rfield_ANT_FCSI_REG0_OBSPP",
        "rfield_ANT_FCSI_REG0_OBSPPSEL",
        "rfield_ANT_FCSI_REG0_OBSPPEN",
        "rfield_ANT_FCSI_REG0_OBSDIG",
        "rfield_ANT_FCSI_REG0_COMPBIASCONF"
];
register_ANT_FCSI_REG0.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG0_COMPBIASCONF = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_COMPBIASCONF.jsName      = "rfield_ANT_FCSI_REG0_COMPBIASCONF";
rfield_ANT_FCSI_REG0_COMPBIASCONF.type        = "rfield";
rfield_ANT_FCSI_REG0_COMPBIASCONF.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_COMPBIASCONF.instName    = "COMPBIASCONF";
rfield_ANT_FCSI_REG0_COMPBIASCONF.aliasName   = "COMPBIASCONF";
rfield_ANT_FCSI_REG0_COMPBIASCONF.longName    = "comp_bias_conf";
rfield_ANT_FCSI_REG0_COMPBIASCONF.description = "<p>Bias configuration for the comparator<br/>Note:<br/>always on: 50uA/12*6 = 25uA</p>";
rfield_ANT_FCSI_REG0_COMPBIASCONF.file = "";
rfield_ANT_FCSI_REG0_COMPBIASCONF.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_COMPBIASCONF.references = [
];
rfield_ANT_FCSI_REG0_COMPBIASCONF.links = new Array ();
rfield_ANT_FCSI_REG0_COMPBIASCONF.pictures = new Array ();
rfield_ANT_FCSI_REG0_COMPBIASCONF.debugMessages = [
];
rfield_ANT_FCSI_REG0_COMPBIASCONF.parent = "register_ANT_FCSI_REG0";
rfield_ANT_FCSI_REG0_COMPBIASCONF.resetVal = "4'b0110";
rfield_ANT_FCSI_REG0_COMPBIASCONF.addrStart = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_REG0_COMPBIASCONF.addrEnd = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_REG0_COMPBIASCONF.dataWidth = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_REG0_COMPBIASCONF.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG0_COMPBIASCONF.accessProperties = new Array ();
rfield_ANT_FCSI_REG0_COMPBIASCONF.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0 = [
        [ "MIN", "4'b0000", "25u" ], 
        [ "LSB", "4'b0001", "25uA + 50uA/12*1 = 25uA + 4.16uA = 29.16uA" ], 
        [ "LSB1", "4'b0010", "25uA + 50uA/12*2 = 25uA + 8.3uA = 33.3uA" ], 
        [ "LSB2", "4'b0100", "25uA + 50uA/12*4 = 25uA + 16.6uA = 41.6uA" ], 
        [ "MAX", "4'b1000", "25uA + 50uA/12*8 = 25uA + 33.3uA = 58.3uA" ], 
        [ "DEFAULT", "4'b0110", "25uA + 16.6uA + 8.3uA = 50uA (default)" ]];
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG0_COMPBIASCONF";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration [0] = rfield_ANT_FCSI_REG0_COMPBIASCONF.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG0_OBSDIG = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_OBSDIG.jsName      = "rfield_ANT_FCSI_REG0_OBSDIG";
rfield_ANT_FCSI_REG0_OBSDIG.type        = "rfield";
rfield_ANT_FCSI_REG0_OBSDIG.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_OBSDIG.instName    = "OBSDIG";
rfield_ANT_FCSI_REG0_OBSDIG.aliasName   = "OBSDIG";
rfield_ANT_FCSI_REG0_OBSDIG.longName    = "obs_dig";
rfield_ANT_FCSI_REG0_OBSDIG.description = "<p>test enable digital core (adc_2pp_shell)</p>";
rfield_ANT_FCSI_REG0_OBSDIG.file = "";
rfield_ANT_FCSI_REG0_OBSDIG.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_OBSDIG.references = [
];
rfield_ANT_FCSI_REG0_OBSDIG.links = new Array ();
rfield_ANT_FCSI_REG0_OBSDIG.pictures = new Array ();
rfield_ANT_FCSI_REG0_OBSDIG.debugMessages = [
];
rfield_ANT_FCSI_REG0_OBSDIG.parent = "register_ANT_FCSI_REG0";
rfield_ANT_FCSI_REG0_OBSDIG.resetVal = "5'b00000";
rfield_ANT_FCSI_REG0_OBSDIG.addrStart = "32'b00000000000000000000000000000111";
rfield_ANT_FCSI_REG0_OBSDIG.addrEnd = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_REG0_OBSDIG.dataWidth = "32'b00000000000000000000000000000101";
rfield_ANT_FCSI_REG0_OBSDIG.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG0_OBSDIG.accessProperties = new Array ();
rfield_ANT_FCSI_REG0_OBSDIG.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG0_OBSDIG.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0 = [
        [ "MIN", "5'b00000", "default" ], 
        [ "MAX", "5'b11111", "Last" ]];
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG0_OBSDIG";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0";
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration [0] = rfield_ANT_FCSI_REG0_OBSDIG.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG0_OBSPPEN = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_OBSPPEN.jsName      = "rfield_ANT_FCSI_REG0_OBSPPEN";
rfield_ANT_FCSI_REG0_OBSPPEN.type        = "rfield";
rfield_ANT_FCSI_REG0_OBSPPEN.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_OBSPPEN.instName    = "OBSPPEN";
rfield_ANT_FCSI_REG0_OBSPPEN.aliasName   = "OBSPPEN";
rfield_ANT_FCSI_REG0_OBSPPEN.longName    = "obs_pp_en";
rfield_ANT_FCSI_REG0_OBSPPEN.description = "<p>test enable analog polyphase</p>";
rfield_ANT_FCSI_REG0_OBSPPEN.file = "";
rfield_ANT_FCSI_REG0_OBSPPEN.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_OBSPPEN.references = [
];
rfield_ANT_FCSI_REG0_OBSPPEN.links = new Array ();
rfield_ANT_FCSI_REG0_OBSPPEN.pictures = new Array ();
rfield_ANT_FCSI_REG0_OBSPPEN.debugMessages = [
];
rfield_ANT_FCSI_REG0_OBSPPEN.parent = "register_ANT_FCSI_REG0";
rfield_ANT_FCSI_REG0_OBSPPEN.resetVal = "1'b0";
rfield_ANT_FCSI_REG0_OBSPPEN.addrStart = "32'b00000000000000000000000000000110";
rfield_ANT_FCSI_REG0_OBSPPEN.addrEnd = "32'b00000000000000000000000000000110";
rfield_ANT_FCSI_REG0_OBSPPEN.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG0_OBSPPEN.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG0_OBSPPEN.accessProperties = new Array ();
rfield_ANT_FCSI_REG0_OBSPPEN.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0 = [
        [ "DIS", "1'b0", "PP Observe disabled (default)" ], 
        [ "EN", "1'b1", "PP Observe enabled" ]];
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG0_OBSPPEN";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration [0] = rfield_ANT_FCSI_REG0_OBSPPEN.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG0_OBSPPSEL = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_OBSPPSEL.jsName      = "rfield_ANT_FCSI_REG0_OBSPPSEL";
rfield_ANT_FCSI_REG0_OBSPPSEL.type        = "rfield";
rfield_ANT_FCSI_REG0_OBSPPSEL.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_OBSPPSEL.instName    = "OBSPPSEL";
rfield_ANT_FCSI_REG0_OBSPPSEL.aliasName   = "OBSPPSEL";
rfield_ANT_FCSI_REG0_OBSPPSEL.longName    = "obs_pp_sel";
rfield_ANT_FCSI_REG0_OBSPPSEL.description = "<p>Select polyphase for observation on analog testbus</p>";
rfield_ANT_FCSI_REG0_OBSPPSEL.file = "";
rfield_ANT_FCSI_REG0_OBSPPSEL.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_OBSPPSEL.references = [
];
rfield_ANT_FCSI_REG0_OBSPPSEL.links = new Array ();
rfield_ANT_FCSI_REG0_OBSPPSEL.pictures = new Array ();
rfield_ANT_FCSI_REG0_OBSPPSEL.debugMessages = [
];
rfield_ANT_FCSI_REG0_OBSPPSEL.parent = "register_ANT_FCSI_REG0";
rfield_ANT_FCSI_REG0_OBSPPSEL.resetVal = "1'b0";
rfield_ANT_FCSI_REG0_OBSPPSEL.addrStart = "32'b00000000000000000000000000000101";
rfield_ANT_FCSI_REG0_OBSPPSEL.addrEnd = "32'b00000000000000000000000000000101";
rfield_ANT_FCSI_REG0_OBSPPSEL.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG0_OBSPPSEL.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG0_OBSPPSEL.accessProperties = new Array ();
rfield_ANT_FCSI_REG0_OBSPPSEL.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0 = [
        [ "PP0", "1'b0", "PP0" ], 
        [ "PP1", "1'b1", "PP1" ]];
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG0_OBSPPSEL";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration [0] = rfield_ANT_FCSI_REG0_OBSPPSEL.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG0_OBSPP = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_OBSPP.jsName      = "rfield_ANT_FCSI_REG0_OBSPP";
rfield_ANT_FCSI_REG0_OBSPP.type        = "rfield";
rfield_ANT_FCSI_REG0_OBSPP.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_OBSPP.instName    = "OBSPP";
rfield_ANT_FCSI_REG0_OBSPP.aliasName   = "OBSPP";
rfield_ANT_FCSI_REG0_OBSPP.longName    = "obs_pp";
rfield_ANT_FCSI_REG0_OBSPP.description = "<p>Analog testbus control</p>";
rfield_ANT_FCSI_REG0_OBSPP.file = "";
rfield_ANT_FCSI_REG0_OBSPP.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_OBSPP.references = [
];
rfield_ANT_FCSI_REG0_OBSPP.links = new Array ();
rfield_ANT_FCSI_REG0_OBSPP.pictures = new Array ();
rfield_ANT_FCSI_REG0_OBSPP.debugMessages = [
];
rfield_ANT_FCSI_REG0_OBSPP.parent = "register_ANT_FCSI_REG0";
rfield_ANT_FCSI_REG0_OBSPP.resetVal = "3'b000";
rfield_ANT_FCSI_REG0_OBSPP.addrStart = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REG0_OBSPP.addrEnd = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_REG0_OBSPP.dataWidth = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_REG0_OBSPP.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG0_OBSPP.accessProperties = new Array ();
rfield_ANT_FCSI_REG0_OBSPP.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG0_OBSPP.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0 = [
        [ "OBS0", "3'b000", " VDD/VSS(default)" ], 
        [ "OBS1", "3'b001", "VcascP/VcascN" ], 
        [ "OBS2", "3'b010", "VBP/VSS" ], 
        [ "OBS3", "3'b011", "Vbpp/Vbpn" ], 
        [ "OBS4", "3'b100", "VrefP/VrefN" ], 
        [ "OBS5", "3'b101", "Ibiascomp_cur/ibiascomp_cas" ], 
        [ "OBS6", "3'b110", "Ibn_50u_comp/Ibp50u_vcmbuf" ], 
        [ "OBS7", "3'b111", "Vcm_buf/vcm " ]];
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG0_OBSPP";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0";
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration [0] = rfield_ANT_FCSI_REG0_OBSPP.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG0_RESN = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_RESN.jsName      = "rfield_ANT_FCSI_REG0_RESN";
rfield_ANT_FCSI_REG0_RESN.type        = "rfield";
rfield_ANT_FCSI_REG0_RESN.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_RESN.instName    = "RESN";
rfield_ANT_FCSI_REG0_RESN.aliasName   = "RESN";
rfield_ANT_FCSI_REG0_RESN.longName    = "resn_ssiadc";
rfield_ANT_FCSI_REG0_RESN.description = "<p>Resetn SSIADC</p>";
rfield_ANT_FCSI_REG0_RESN.file = "";
rfield_ANT_FCSI_REG0_RESN.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_RESN.references = [
];
rfield_ANT_FCSI_REG0_RESN.links = new Array ();
rfield_ANT_FCSI_REG0_RESN.pictures = new Array ();
rfield_ANT_FCSI_REG0_RESN.debugMessages = [
];
rfield_ANT_FCSI_REG0_RESN.parent = "register_ANT_FCSI_REG0";
rfield_ANT_FCSI_REG0_RESN.resetVal = "1'b0";
rfield_ANT_FCSI_REG0_RESN.addrStart = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG0_RESN.addrEnd = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG0_RESN.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG0_RESN.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG0_RESN.accessProperties = new Array ();
rfield_ANT_FCSI_REG0_RESN.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG0_RESN.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0 = [
        [ "RESET", "1'b0", "Reset (default)" ], 
        [ "NO_RESET", "1'b1", "Reset Released" ]];
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG0_RESN";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0";
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG0_RESN.attributes.enumeration [0] = rfield_ANT_FCSI_REG0_RESN.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REG0_PD = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_PD.jsName      = "rfield_ANT_FCSI_REG0_PD";
rfield_ANT_FCSI_REG0_PD.type        = "rfield";
rfield_ANT_FCSI_REG0_PD.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_PD.instName    = "PD";
rfield_ANT_FCSI_REG0_PD.aliasName   = "PD";
rfield_ANT_FCSI_REG0_PD.longName    = "pd";
rfield_ANT_FCSI_REG0_PD.description = "<p>SSI-ADC power-down</p>";
rfield_ANT_FCSI_REG0_PD.file = "";
rfield_ANT_FCSI_REG0_PD.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_PD.references = [
];
rfield_ANT_FCSI_REG0_PD.links = new Array ();
rfield_ANT_FCSI_REG0_PD.pictures = new Array ();
rfield_ANT_FCSI_REG0_PD.debugMessages = [
];
rfield_ANT_FCSI_REG0_PD.parent = "register_ANT_FCSI_REG0";
rfield_ANT_FCSI_REG0_PD.resetVal = "1'b1";
rfield_ANT_FCSI_REG0_PD.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REG0_PD.addrEnd = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REG0_PD.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REG0_PD.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REG0_PD.accessProperties = new Array ();
rfield_ANT_FCSI_REG0_PD.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REG0_PD.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REG0_PD.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0 = [
        [ "PUP", "1'b0", "power-up" ], 
        [ "PD", "1'b1", "power-down (default)" ]];
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REG0_PD";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0";
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.contacts    = "user_pridnig";
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REG0_PD.attributes.enumeration [0] = rfield_ANT_FCSI_REG0_PD.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_IQDACREG1 = new Object ();
register_ANT_FCSI_IQDACREG1.reserved = false;
register_ANT_FCSI_IQDACREG1.parent = "port_ANT_FCSI";
register_ANT_FCSI_IQDACREG1.resetVal = "16'bXX00010010010000";
register_ANT_FCSI_IQDACREG1.usedBits = "16'b0011111111111111";
register_ANT_FCSI_IQDACREG1.undefBits = "16'b1100000000000000";
register_ANT_FCSI_IQDACREG1.indirectAccessPort = "";
register_ANT_FCSI_IQDACREG1.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_IQDACREG1.jsName      = "register_ANT_FCSI_IQDACREG1";
register_ANT_FCSI_IQDACREG1.type        = "register";
register_ANT_FCSI_IQDACREG1.baseName    = "BASIC";
register_ANT_FCSI_IQDACREG1.instName    = "IQDACREG1";
register_ANT_FCSI_IQDACREG1.aliasName   = "IQDACREG1";
register_ANT_FCSI_IQDACREG1.longName    = "IQ_DAC_REG1";
register_ANT_FCSI_IQDACREG1.description = "Register 1 of IQ DAC";
register_ANT_FCSI_IQDACREG1.file = "";
register_ANT_FCSI_IQDACREG1.contacts    = "user_dario";
register_ANT_FCSI_IQDACREG1.references = [
];
register_ANT_FCSI_IQDACREG1.links = new Array ();
register_ANT_FCSI_IQDACREG1.pictures = new Array ();
register_ANT_FCSI_IQDACREG1.debugMessages = [
];
register_ANT_FCSI_IQDACREG1.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_IQDACREG1.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQDACREG1.addrStart  = new Array ();
register_ANT_FCSI_IQDACREG1.addrEnd    = new Array ();
register_ANT_FCSI_IQDACREG1.addrSpace  = new Array ();
register_ANT_FCSI_IQDACREG1.dataWidth  = new Array ();
register_ANT_FCSI_IQDACREG1.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001001001";
register_ANT_FCSI_IQDACREG1.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001001001";
register_ANT_FCSI_IQDACREG1.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQDACREG1.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQDACREG1.addrStart ["register_ANT_FCSI_IQDACREG1"] = "32'b00000000000000000000000001001001";
register_ANT_FCSI_IQDACREG1.addrEnd ["register_ANT_FCSI_IQDACREG1"] = "32'b00000000000000000000000001001001";
register_ANT_FCSI_IQDACREG1.addrSpace ["register_ANT_FCSI_IQDACREG1"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQDACREG1.dataWidth ["register_ANT_FCSI_IQDACREG1"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQDACREG1.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_IQDACREG1.allowAddrOverlap = false;
register_ANT_FCSI_IQDACREG1.isCollapsedIntoPort = false;
register_ANT_FCSI_IQDACREG1.isLossless = true;
register_ANT_FCSI_IQDACREG1.access       = new Array ();
register_ANT_FCSI_IQDACREG1.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_IQDACREG1.access ["register_ANT_FCSI_IQDACREG1"] = "RW";
register_ANT_FCSI_IQDACREG1.hierarchies       = new Array ();
register_ANT_FCSI_IQDACREG1.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_IQDACREG1"
];
register_ANT_FCSI_IQDACREG1.fields = new Array ();
register_ANT_FCSI_IQDACREG1.fields = [
        "rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP",
        "rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS",
        "rfield_ANT_FCSI_IQDACREG1_ABSGAIN",
        "rfield_ANT_FCSI_IQDACREG1_GAINRELI",
        "rfield_ANT_FCSI_IQDACREG1_GAINRELQ",
        "rfield_ANT_FCSI_IQDACREG1_DEMMODE",
        "rfield_ANT_FCSI_IQDACREG1_ENDEM"
];
register_ANT_FCSI_IQDACREG1.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG1_ENDEM = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_ENDEM.jsName      = "rfield_ANT_FCSI_IQDACREG1_ENDEM";
rfield_ANT_FCSI_IQDACREG1_ENDEM.type        = "rfield";
rfield_ANT_FCSI_IQDACREG1_ENDEM.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_ENDEM.instName    = "ENDEM";
rfield_ANT_FCSI_IQDACREG1_ENDEM.aliasName   = "ENDEM";
rfield_ANT_FCSI_IQDACREG1_ENDEM.longName    = "en_dem";
rfield_ANT_FCSI_IQDACREG1_ENDEM.description = "<p>IQ-DAC enable dynamic element matching</p>";
rfield_ANT_FCSI_IQDACREG1_ENDEM.file = "";
rfield_ANT_FCSI_IQDACREG1_ENDEM.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_ENDEM.references = [
];
rfield_ANT_FCSI_IQDACREG1_ENDEM.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_ENDEM.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_ENDEM.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_ENDEM.parent = "register_ANT_FCSI_IQDACREG1";
rfield_ANT_FCSI_IQDACREG1_ENDEM.resetVal = "1'b0";
rfield_ANT_FCSI_IQDACREG1_ENDEM.addrStart = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_IQDACREG1_ENDEM.addrEnd = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_IQDACREG1_ENDEM.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG1_ENDEM.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG1_ENDEM.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG1_ENDEM.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "no DEM (default)" ], 
        [ "ON", "1'b1", "DEM activated" ]];
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG1_ENDEM";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG1_ENDEM.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG1_DEMMODE = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_DEMMODE.jsName      = "rfield_ANT_FCSI_IQDACREG1_DEMMODE";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.type        = "rfield";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.instName    = "DEMMODE";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.aliasName   = "DEMMODE";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.longName    = "dem_mode";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.description = "<p>IQ-DAC dynamic element matching</p>";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.file = "";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.references = [
];
rfield_ANT_FCSI_IQDACREG1_DEMMODE.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_DEMMODE.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_DEMMODE.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_DEMMODE.parent = "register_ANT_FCSI_IQDACREG1";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.resetVal = "2'b00";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.addrStart = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.addrEnd = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG1_DEMMODE.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0 = [
        [ "FIB4", "2'b00", "FIB4 (default)" ], 
        [ "CLA6F", "2'b01", "CLA6F" ], 
        [ "CLA6R4", "2'b10", "CLA6R4" ], 
        [ "CLA4R4", "2'b11", "CLA4R4" ]];
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG1_DEMMODE";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG1_DEMMODE.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG1_GAINRELQ = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.jsName      = "rfield_ANT_FCSI_IQDACREG1_GAINRELQ";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.type        = "rfield";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.instName    = "GAINRELQ";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.aliasName   = "GAINRELQ";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.longName    = "gain_rel_Q";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.description = "<p>IQ-DAC relative gain Q-path</p>";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.file = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.references = [
];
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.parent = "register_ANT_FCSI_IQDACREG1";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.resetVal = "3'b100";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.addrStart = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.addrEnd = "32'b00000000000000000000000000001010";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.dataWidth = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0 = [
        [ "M0P91DB", "3'b000", "-0.91dB" ], 
        [ "M0P67DB", "3'b001", "-0.67dB" ], 
        [ "M0P44DB", "3'b010", "-0.44dB" ], 
        [ "M0P22DB", "3'b011", "-0.22dB" ], 
        [ "M0DB", "3'b100", "-0.00dB (default)" ], 
        [ "P0P21DB", "3'b101", "+0.21dB" ], 
        [ "P0P42DB", "3'b110", "+0.42dB" ], 
        [ "P0P62DB", "3'b111", "+0.62dB" ]];
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG1_GAINRELQ";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG1_GAINRELQ.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG1_GAINRELI = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_GAINRELI.jsName      = "rfield_ANT_FCSI_IQDACREG1_GAINRELI";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.type        = "rfield";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.instName    = "GAINRELI";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.aliasName   = "GAINRELI";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.longName    = "gain_rel_I";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.description = "<p>IQ-DAC relative gain I-path</p>";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.file = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.references = [
];
rfield_ANT_FCSI_IQDACREG1_GAINRELI.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELI.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELI.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_GAINRELI.parent = "register_ANT_FCSI_IQDACREG1";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.resetVal = "3'b100";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.addrStart = "32'b00000000000000000000000000000101";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.addrEnd = "32'b00000000000000000000000000000111";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.dataWidth = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELI.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0 = [
        [ "M0P91DB", "3'b000", "-0.91dB" ], 
        [ "M0P67DB", "3'b001", "-0.67dB" ], 
        [ "M0P44DB", "3'b010", "-0.44dB" ], 
        [ "M0P22DB", "3'b011", "-0.22dB" ], 
        [ "P0DB", "3'b100", "-0.00dB (default)" ], 
        [ "P0P21DB", "3'b101", "+0.21dB" ], 
        [ "P0P42DB", "3'b110", "+0.42dB" ], 
        [ "P0P62DB", "3'b111", "+0.62dB" ]];
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG1_GAINRELI";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG1_GAINRELI.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG1_ABSGAIN = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.jsName      = "rfield_ANT_FCSI_IQDACREG1_ABSGAIN";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.type        = "rfield";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.instName    = "ABSGAIN";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.aliasName   = "ABSGAIN";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.longName    = "abs_gain";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.description = "<p>IQ-DAC absolute gain</p>";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.file = "";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.references = [
];
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.parent = "register_ANT_FCSI_IQDACREG1";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.resetVal = "3'b100";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.addrStart = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.addrEnd = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.dataWidth = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0 = [
        [ "M1P92DB", "3'b000", "-1.92dB" ], 
        [ "M1P40DB", "3'b001", "-1.40dB" ], 
        [ "M0P91DB", "3'b010", "-0.91dB" ], 
        [ "M0P44DB", "3'b011", "-0.44dB" ], 
        [ "0DB", "3'b100", "-0.00dB (default)" ], 
        [ "P0P42DB", "3'b101", "+0.42dB" ], 
        [ "P0P82DB", "3'b110", "+0.82dB" ], 
        [ "P1P21DB", "3'b111", "+1.21dB" ]];
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG1_ABSGAIN";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG1_ABSGAIN.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.jsName      = "rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.type        = "rfield";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.instName    = "PDBULKBIAS";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.aliasName   = "PDBULKBIAS";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.longName    = "pd_bulk_bias";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.description = "<p>IQ-DAC power down bulk of forward biasing</p>";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.file = "";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.references = [
];
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.parent = "register_ANT_FCSI_IQDACREG1";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.resetVal = "1'b0";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.addrStart = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.addrEnd = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0 = [
        [ "ON", "1'b0", "pd - bulk of forward biasing (default)" ], 
        [ "OFF", "1'b1", "pup - no bulk of forward biasing" ]];
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG1_PDBULKBIAS.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.jsName      = "rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.type        = "rfield";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.instName    = "PDLEAKCOMP";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.aliasName   = "PDLEAKCOMP";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.longName    = "pd_leak_comp";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.description = "<p>IQ-DAC power down leakage compensation</p>";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.file = "";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.references = [
];
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.parent = "register_ANT_FCSI_IQDACREG1";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.resetVal = "1'b0";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.addrEnd = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0 = [
        [ "ON", "1'b0", "pd - leakage compensation (default)" ], 
        [ "OFF", "1'b1", "pup - no leakage compensation active" ]];
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG1_PDLEAKCOMP.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_IQDACREG0 = new Object ();
register_ANT_FCSI_IQDACREG0.reserved = false;
register_ANT_FCSI_IQDACREG0.parent = "port_ANT_FCSI";
register_ANT_FCSI_IQDACREG0.resetVal = "16'b000XXXX100XXXX00";
register_ANT_FCSI_IQDACREG0.usedBits = "16'b1110000111000011";
register_ANT_FCSI_IQDACREG0.undefBits = "16'b0001111000111100";
register_ANT_FCSI_IQDACREG0.indirectAccessPort = "";
register_ANT_FCSI_IQDACREG0.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_IQDACREG0.jsName      = "register_ANT_FCSI_IQDACREG0";
register_ANT_FCSI_IQDACREG0.type        = "register";
register_ANT_FCSI_IQDACREG0.baseName    = "BASIC";
register_ANT_FCSI_IQDACREG0.instName    = "IQDACREG0";
register_ANT_FCSI_IQDACREG0.aliasName   = "IQDACREG0";
register_ANT_FCSI_IQDACREG0.longName    = "IQ_DAC_REG0";
register_ANT_FCSI_IQDACREG0.description = "Register 0 of IQ DAC";
register_ANT_FCSI_IQDACREG0.file = "";
register_ANT_FCSI_IQDACREG0.contacts    = "user_dario";
register_ANT_FCSI_IQDACREG0.references = [
];
register_ANT_FCSI_IQDACREG0.links = new Array ();
register_ANT_FCSI_IQDACREG0.pictures = new Array ();
register_ANT_FCSI_IQDACREG0.debugMessages = [
];
register_ANT_FCSI_IQDACREG0.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_IQDACREG0.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQDACREG0.addrStart  = new Array ();
register_ANT_FCSI_IQDACREG0.addrEnd    = new Array ();
register_ANT_FCSI_IQDACREG0.addrSpace  = new Array ();
register_ANT_FCSI_IQDACREG0.dataWidth  = new Array ();
register_ANT_FCSI_IQDACREG0.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001001000";
register_ANT_FCSI_IQDACREG0.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001001000";
register_ANT_FCSI_IQDACREG0.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQDACREG0.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQDACREG0.addrStart ["register_ANT_FCSI_IQDACREG0"] = "32'b00000000000000000000000001001000";
register_ANT_FCSI_IQDACREG0.addrEnd ["register_ANT_FCSI_IQDACREG0"] = "32'b00000000000000000000000001001000";
register_ANT_FCSI_IQDACREG0.addrSpace ["register_ANT_FCSI_IQDACREG0"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQDACREG0.dataWidth ["register_ANT_FCSI_IQDACREG0"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQDACREG0.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_IQDACREG0.allowAddrOverlap = false;
register_ANT_FCSI_IQDACREG0.isCollapsedIntoPort = false;
register_ANT_FCSI_IQDACREG0.isLossless = true;
register_ANT_FCSI_IQDACREG0.access       = new Array ();
register_ANT_FCSI_IQDACREG0.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_IQDACREG0.access ["register_ANT_FCSI_IQDACREG0"] = "RW";
register_ANT_FCSI_IQDACREG0.hierarchies       = new Array ();
register_ANT_FCSI_IQDACREG0.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_IQDACREG0"
];
register_ANT_FCSI_IQDACREG0.fields = new Array ();
register_ANT_FCSI_IQDACREG0.fields = [
        "rfield_ANT_FCSI_IQDACREG0_PUPBUF",
        "rfield_ANT_FCSI_IQDACREG0_PUPDAC",
        "rfield_ANT_FCSI_IQDACREG0_INVMSB",
        "rfield_ANT_FCSI_IQDACREG0_FMODE",
        "rfield_ANT_FCSI_IQDACREG0_PDLBIAS",
        "rfield_ANT_FCSI_IQDACREG0_RESQ",
        "rfield_ANT_FCSI_IQDACREG0_INVCLK"
];
register_ANT_FCSI_IQDACREG0.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG0_INVCLK = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_INVCLK.jsName      = "rfield_ANT_FCSI_IQDACREG0_INVCLK";
rfield_ANT_FCSI_IQDACREG0_INVCLK.type        = "rfield";
rfield_ANT_FCSI_IQDACREG0_INVCLK.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_INVCLK.instName    = "INVCLK";
rfield_ANT_FCSI_IQDACREG0_INVCLK.aliasName   = "INVCLK";
rfield_ANT_FCSI_IQDACREG0_INVCLK.longName    = "inv_clk";
rfield_ANT_FCSI_IQDACREG0_INVCLK.description = "<p>IQ-DAC clock inversion</p>";
rfield_ANT_FCSI_IQDACREG0_INVCLK.file = "";
rfield_ANT_FCSI_IQDACREG0_INVCLK.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_INVCLK.references = [
];
rfield_ANT_FCSI_IQDACREG0_INVCLK.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVCLK.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVCLK.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_INVCLK.parent = "register_ANT_FCSI_IQDACREG0";
rfield_ANT_FCSI_IQDACREG0_INVCLK.resetVal = "1'b0";
rfield_ANT_FCSI_IQDACREG0_INVCLK.addrStart = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_IQDACREG0_INVCLK.addrEnd = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_IQDACREG0_INVCLK.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG0_INVCLK.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG0_INVCLK.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVCLK.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0 = [
        [ "NORM", "1'b0", "non-inverted clock (default)" ], 
        [ "INV", "1'b1", "inverted clock" ]];
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG0_INVCLK";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG0_INVCLK.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG0_RESQ = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_RESQ.jsName      = "rfield_ANT_FCSI_IQDACREG0_RESQ";
rfield_ANT_FCSI_IQDACREG0_RESQ.type        = "rfield";
rfield_ANT_FCSI_IQDACREG0_RESQ.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_RESQ.instName    = "RESQ";
rfield_ANT_FCSI_IQDACREG0_RESQ.aliasName   = "RESQ";
rfield_ANT_FCSI_IQDACREG0_RESQ.longName    = "resq";
rfield_ANT_FCSI_IQDACREG0_RESQ.description = "<p>IQ-DAC reset low active</p>";
rfield_ANT_FCSI_IQDACREG0_RESQ.file = "";
rfield_ANT_FCSI_IQDACREG0_RESQ.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_RESQ.references = [
];
rfield_ANT_FCSI_IQDACREG0_RESQ.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_RESQ.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_RESQ.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_RESQ.parent = "register_ANT_FCSI_IQDACREG0";
rfield_ANT_FCSI_IQDACREG0_RESQ.resetVal = "1'b0";
rfield_ANT_FCSI_IQDACREG0_RESQ.addrStart = "32'b00000000000000000000000000001110";
rfield_ANT_FCSI_IQDACREG0_RESQ.addrEnd = "32'b00000000000000000000000000001110";
rfield_ANT_FCSI_IQDACREG0_RESQ.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG0_RESQ.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG0_RESQ.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG0_RESQ.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0 = [
        [ "ON", "1'b0", "reset (default)" ], 
        [ "OFF", "1'b1", "normal operation" ]];
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG0_RESQ";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG0_RESQ.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG0_PDLBIAS = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.jsName      = "rfield_ANT_FCSI_IQDACREG0_PDLBIAS";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.type        = "rfield";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.instName    = "PDLBIAS";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.aliasName   = "PDLBIAS";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.longName    = "pd_local_bias";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.description = "<p>IQ-DAC Power-down local bias</p>";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.file = "";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.references = [
];
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.parent = "register_ANT_FCSI_IQDACREG0";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.resetVal = "1'b0";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.addrStart = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.addrEnd = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "no power down - local bias active (default)" ], 
        [ "ON", "1'b1", "power down local bias" ]];
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG0_PDLBIAS";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG0_PDLBIAS.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG0_FMODE = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_FMODE.jsName      = "rfield_ANT_FCSI_IQDACREG0_FMODE";
rfield_ANT_FCSI_IQDACREG0_FMODE.type        = "rfield";
rfield_ANT_FCSI_IQDACREG0_FMODE.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_FMODE.instName    = "FMODE";
rfield_ANT_FCSI_IQDACREG0_FMODE.aliasName   = "FMODE";
rfield_ANT_FCSI_IQDACREG0_FMODE.longName    = "f_mode";
rfield_ANT_FCSI_IQDACREG0_FMODE.description = "<p>IQ-DAC F-Mode</p>";
rfield_ANT_FCSI_IQDACREG0_FMODE.file = "";
rfield_ANT_FCSI_IQDACREG0_FMODE.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_FMODE.references = [
];
rfield_ANT_FCSI_IQDACREG0_FMODE.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_FMODE.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_FMODE.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_FMODE.parent = "register_ANT_FCSI_IQDACREG0";
rfield_ANT_FCSI_IQDACREG0_FMODE.resetVal = "2'b10";
rfield_ANT_FCSI_IQDACREG0_FMODE.addrStart = "32'b00000000000000000000000000000111";
rfield_ANT_FCSI_IQDACREG0_FMODE.addrEnd = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_IQDACREG0_FMODE.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_IQDACREG0_FMODE.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG0_FMODE.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG0_FMODE.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0 = [
        [ "CB", "2'b00", "CB (default)" ], 
        [ "NCB", "2'b01", "nCB" ], 
        [ "11AC", "2'b10", "11ac" ], 
        [ "NU", "2'b11", "not used (11ac)" ]];
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG0_FMODE";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG0_FMODE.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG0_INVMSB = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_INVMSB.jsName      = "rfield_ANT_FCSI_IQDACREG0_INVMSB";
rfield_ANT_FCSI_IQDACREG0_INVMSB.type        = "rfield";
rfield_ANT_FCSI_IQDACREG0_INVMSB.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_INVMSB.instName    = "INVMSB";
rfield_ANT_FCSI_IQDACREG0_INVMSB.aliasName   = "INVMSB";
rfield_ANT_FCSI_IQDACREG0_INVMSB.longName    = "inv_msb";
rfield_ANT_FCSI_IQDACREG0_INVMSB.description = "<p>IQ-DAC input data format</p>";
rfield_ANT_FCSI_IQDACREG0_INVMSB.file = "";
rfield_ANT_FCSI_IQDACREG0_INVMSB.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_INVMSB.references = [
];
rfield_ANT_FCSI_IQDACREG0_INVMSB.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVMSB.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVMSB.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_INVMSB.parent = "register_ANT_FCSI_IQDACREG0";
rfield_ANT_FCSI_IQDACREG0_INVMSB.resetVal = "1'b0";
rfield_ANT_FCSI_IQDACREG0_INVMSB.addrStart = "32'b00000000000000000000000000000110";
rfield_ANT_FCSI_IQDACREG0_INVMSB.addrEnd = "32'b00000000000000000000000000000110";
rfield_ANT_FCSI_IQDACREG0_INVMSB.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG0_INVMSB.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG0_INVMSB.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVMSB.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0 = [
        [ "2COMPL", "1'b0", "2&apos;s complement (default)" ], 
        [ "BIN", "1'b1", "binary" ]];
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG0_INVMSB";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG0_INVMSB.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG0_PUPDAC = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_PUPDAC.jsName      = "rfield_ANT_FCSI_IQDACREG0_PUPDAC";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.type        = "rfield";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.instName    = "PUPDAC";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.aliasName   = "PUPDAC";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.longName    = "pup_dac";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.description = "<p>IQ-DAC reference enable</p>";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.file = "";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.references = [
];
rfield_ANT_FCSI_IQDACREG0_PUPDAC.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPDAC.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPDAC.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_PUPDAC.parent = "register_ANT_FCSI_IQDACREG0";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.resetVal = "1'b0";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.addrStart = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.addrEnd = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPDAC.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "Power-down  (default)" ], 
        [ "ON", "1'b1", "Power-up (if pup_buf=&apos;1&apos;)" ]];
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG0_PUPDAC";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG0_PUPDAC.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQDACREG0_PUPBUF = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_PUPBUF.jsName      = "rfield_ANT_FCSI_IQDACREG0_PUPBUF";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.type        = "rfield";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.instName    = "PUPBUF";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.aliasName   = "PUPBUF";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.longName    = "pup_buf";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.description = "<p>IQ-DAC buffer enable</p>";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.file = "";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.references = [
];
rfield_ANT_FCSI_IQDACREG0_PUPBUF.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPBUF.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPBUF.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_PUPBUF.parent = "register_ANT_FCSI_IQDACREG0";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.resetVal = "1'b0";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.addrEnd = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.accessProperties = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPBUF.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "Power-down (default) (if pup_dac =&apos;0&apos;), standby (if pup_dac=&apos;1&apos;)" ], 
        [ "ON", "1'b1", "Power-up" ]];
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQDACREG0_PUPBUF";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.contacts    = "user_dario";
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration [0] = rfield_ANT_FCSI_IQDACREG0_PUPBUF.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_REGANAMUX = new Object ();
register_ANT_FCSI_REGANAMUX.reserved = false;
register_ANT_FCSI_REGANAMUX.parent = "port_ANT_FCSI";
register_ANT_FCSI_REGANAMUX.resetVal = "16'bXXXXXXXXXXXXXX00";
register_ANT_FCSI_REGANAMUX.usedBits = "16'b0000000000000011";
register_ANT_FCSI_REGANAMUX.undefBits = "16'b1111111111111100";
register_ANT_FCSI_REGANAMUX.indirectAccessPort = "";
register_ANT_FCSI_REGANAMUX.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_REGANAMUX.jsName      = "register_ANT_FCSI_REGANAMUX";
register_ANT_FCSI_REGANAMUX.type        = "register";
register_ANT_FCSI_REGANAMUX.baseName    = "BASIC";
register_ANT_FCSI_REGANAMUX.instName    = "REGANAMUX";
register_ANT_FCSI_REGANAMUX.aliasName   = "REGANAMUX";
register_ANT_FCSI_REGANAMUX.longName    = "Mix-block Register 3 ANAMUX";
register_ANT_FCSI_REGANAMUX.description = "mux switching";
register_ANT_FCSI_REGANAMUX.file = "";
register_ANT_FCSI_REGANAMUX.contacts    = "user_hebeinth";
register_ANT_FCSI_REGANAMUX.references = [
];
register_ANT_FCSI_REGANAMUX.links = new Array ();
register_ANT_FCSI_REGANAMUX.pictures = new Array ();
register_ANT_FCSI_REGANAMUX.debugMessages = [
];
register_ANT_FCSI_REGANAMUX.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_REGANAMUX.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGANAMUX.addrStart  = new Array ();
register_ANT_FCSI_REGANAMUX.addrEnd    = new Array ();
register_ANT_FCSI_REGANAMUX.addrSpace  = new Array ();
register_ANT_FCSI_REGANAMUX.dataWidth  = new Array ();
register_ANT_FCSI_REGANAMUX.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001000111";
register_ANT_FCSI_REGANAMUX.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001000111";
register_ANT_FCSI_REGANAMUX.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REGANAMUX.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGANAMUX.addrStart ["register_ANT_FCSI_REGANAMUX"] = "32'b00000000000000000000000001000111";
register_ANT_FCSI_REGANAMUX.addrEnd ["register_ANT_FCSI_REGANAMUX"] = "32'b00000000000000000000000001000111";
register_ANT_FCSI_REGANAMUX.addrSpace ["register_ANT_FCSI_REGANAMUX"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REGANAMUX.dataWidth ["register_ANT_FCSI_REGANAMUX"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGANAMUX.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_REGANAMUX.allowAddrOverlap = false;
register_ANT_FCSI_REGANAMUX.isCollapsedIntoPort = false;
register_ANT_FCSI_REGANAMUX.isLossless = true;
register_ANT_FCSI_REGANAMUX.access       = new Array ();
register_ANT_FCSI_REGANAMUX.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_REGANAMUX.access ["register_ANT_FCSI_REGANAMUX"] = "RW";
register_ANT_FCSI_REGANAMUX.hierarchies       = new Array ();
register_ANT_FCSI_REGANAMUX.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_REGANAMUX"
];
register_ANT_FCSI_REGANAMUX.fields = new Array ();
register_ANT_FCSI_REGANAMUX.fields = [
        "rfield_ANT_FCSI_REGANAMUX_SELMUXANT"
];
register_ANT_FCSI_REGANAMUX.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGANAMUX_SELMUXANT = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.jsName      = "rfield_ANT_FCSI_REGANAMUX_SELMUXANT";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.type        = "rfield";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.baseName    = "BASIC";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.instName    = "SELMUXANT";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.aliasName   = "SELMUXANT";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.longName    = "sel_mux_ant";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.description = "<p>Selections in antenna anamux - outputs seen just if dedicated antenna is selected in anamux of central fcsi</p>";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.file = "";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.references = [
];
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.links = new Array ();
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.pictures = new Array ();
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.debugMessages = [
];
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.parent = "register_ANT_FCSI_REGANAMUX";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.resetVal = "2'b00";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.addrEnd = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.accessProperties = new Array ();
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0 = [
        [ "LDO", "2'b00", "VDDA1V1LDOANT connected to BB_ITRIM, no connection to BB_VREF (gnd)" ], 
        [ "NC1", "2'b01", "not connected (gnd)" ], 
        [ "SSI", "2'b10", "ssi testoutputs (p @ BB_ITRIM, n @ BB_VREF)" ], 
        [ "NC3", "2'b11", "not connected (gnd)" ]];
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGANAMUX_SELMUXANT";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration [0] = rfield_ANT_FCSI_REGANAMUX_SELMUXANT.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_REGLDO = new Object ();
register_ANT_FCSI_REGLDO.reserved = false;
register_ANT_FCSI_REGLDO.parent = "port_ANT_FCSI";
register_ANT_FCSI_REGLDO.resetVal = "16'bXXXXXXXXX0000010";
register_ANT_FCSI_REGLDO.usedBits = "16'b0000000001111111";
register_ANT_FCSI_REGLDO.undefBits = "16'b1111111110000000";
register_ANT_FCSI_REGLDO.indirectAccessPort = "";
register_ANT_FCSI_REGLDO.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_REGLDO.jsName      = "register_ANT_FCSI_REGLDO";
register_ANT_FCSI_REGLDO.type        = "register";
register_ANT_FCSI_REGLDO.baseName    = "BASIC";
register_ANT_FCSI_REGLDO.instName    = "REGLDO";
register_ANT_FCSI_REGLDO.aliasName   = "REGLDO";
register_ANT_FCSI_REGLDO.longName    = "Mix-block Register 2 LDOANT";
register_ANT_FCSI_REGLDO.description = "pup and programming";
register_ANT_FCSI_REGLDO.file = "";
register_ANT_FCSI_REGLDO.contacts    = "user_hebeinth";
register_ANT_FCSI_REGLDO.references = [
];
register_ANT_FCSI_REGLDO.links = new Array ();
register_ANT_FCSI_REGLDO.pictures = new Array ();
register_ANT_FCSI_REGLDO.debugMessages = [
];
register_ANT_FCSI_REGLDO.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_REGLDO.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGLDO.addrStart  = new Array ();
register_ANT_FCSI_REGLDO.addrEnd    = new Array ();
register_ANT_FCSI_REGLDO.addrSpace  = new Array ();
register_ANT_FCSI_REGLDO.dataWidth  = new Array ();
register_ANT_FCSI_REGLDO.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001000110";
register_ANT_FCSI_REGLDO.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001000110";
register_ANT_FCSI_REGLDO.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REGLDO.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGLDO.addrStart ["register_ANT_FCSI_REGLDO"] = "32'b00000000000000000000000001000110";
register_ANT_FCSI_REGLDO.addrEnd ["register_ANT_FCSI_REGLDO"] = "32'b00000000000000000000000001000110";
register_ANT_FCSI_REGLDO.addrSpace ["register_ANT_FCSI_REGLDO"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REGLDO.dataWidth ["register_ANT_FCSI_REGLDO"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGLDO.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_REGLDO.allowAddrOverlap = false;
register_ANT_FCSI_REGLDO.isCollapsedIntoPort = false;
register_ANT_FCSI_REGLDO.isLossless = true;
register_ANT_FCSI_REGLDO.access       = new Array ();
register_ANT_FCSI_REGLDO.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_REGLDO.access ["register_ANT_FCSI_REGLDO"] = "RW";
register_ANT_FCSI_REGLDO.hierarchies       = new Array ();
register_ANT_FCSI_REGLDO.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_REGLDO"
];
register_ANT_FCSI_REGLDO.fields = new Array ();
register_ANT_FCSI_REGLDO.fields = [
        "rfield_ANT_FCSI_REGLDO_PUPLDOANT",
        "rfield_ANT_FCSI_REGLDO_PUPLCLDOANT",
        "rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT",
        "rfield_ANT_FCSI_REGLDO_TLLDOANT",
        "rfield_ANT_FCSI_REGLDO_PRGLDOANT"
];
register_ANT_FCSI_REGLDO.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGLDO_PRGLDOANT = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_PRGLDOANT.jsName      = "rfield_ANT_FCSI_REGLDO_PRGLDOANT";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.type        = "rfield";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.instName    = "PRGLDOANT";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.aliasName   = "PRGLDOANT";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.longName    = "prg_ldo_ant";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.description = "<p></p>";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.file = "";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.references = [
];
rfield_ANT_FCSI_REGLDO_PRGLDOANT.links = new Array ();
rfield_ANT_FCSI_REGLDO_PRGLDOANT.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_PRGLDOANT.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_PRGLDOANT.parent = "register_ANT_FCSI_REGLDO";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.resetVal = "3'b000";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.addrStart = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.addrEnd = "32'b00000000000000000000000000000110";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.dataWidth = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.accessProperties = new Array ();
rfield_ANT_FCSI_REGLDO_PRGLDOANT.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0 = [
        [ "0", "3'b000", "1.15V" ], 
        [ "1", "3'b001", "1.18V" ], 
        [ "2", "3'b010", "1.21V" ], 
        [ "3", "3'b011", "1.24V" ], 
        [ "4", "3'b100", "1.03V" ], 
        [ "5", "3'b101", "1.06V" ], 
        [ "6", "3'b110", "1.09V" ], 
        [ "7", "3'b111", "1.12V" ]];
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGLDO_PRGLDOANT";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration [0] = rfield_ANT_FCSI_REGLDO_PRGLDOANT.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGLDO_TLLDOANT = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_TLLDOANT.jsName      = "rfield_ANT_FCSI_REGLDO_TLLDOANT";
rfield_ANT_FCSI_REGLDO_TLLDOANT.type        = "rfield";
rfield_ANT_FCSI_REGLDO_TLLDOANT.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_TLLDOANT.instName    = "TLLDOANT";
rfield_ANT_FCSI_REGLDO_TLLDOANT.aliasName   = "TLLDOANT";
rfield_ANT_FCSI_REGLDO_TLLDOANT.longName    = "tl_ldo_ant";
rfield_ANT_FCSI_REGLDO_TLLDOANT.description = "<p>Test load for antenna ldo</p>";
rfield_ANT_FCSI_REGLDO_TLLDOANT.file = "";
rfield_ANT_FCSI_REGLDO_TLLDOANT.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_TLLDOANT.references = [
];
rfield_ANT_FCSI_REGLDO_TLLDOANT.links = new Array ();
rfield_ANT_FCSI_REGLDO_TLLDOANT.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_TLLDOANT.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_TLLDOANT.parent = "register_ANT_FCSI_REGLDO";
rfield_ANT_FCSI_REGLDO_TLLDOANT.resetVal = "1'b0";
rfield_ANT_FCSI_REGLDO_TLLDOANT.addrStart = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_REGLDO_TLLDOANT.addrEnd = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_REGLDO_TLLDOANT.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGLDO_TLLDOANT.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGLDO_TLLDOANT.accessProperties = new Array ();
rfield_ANT_FCSI_REGLDO_TLLDOANT.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "no test load for antenna ldo" ], 
        [ "ON", "1'b1", "5mA test load for antenna ldo" ]];
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGLDO_TLLDOANT";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration [0] = rfield_ANT_FCSI_REGLDO_TLLDOANT.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.jsName      = "rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.type        = "rfield";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.instName    = "ENBYPASSLDOANT";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.aliasName   = "ENBYPASSLDOANT";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.longName    = "en_bypass_ldoant";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.description = "<p>enable bypass for antenna ldo</p>";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.file = "";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.references = [
];
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.links = new Array ();
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.parent = "register_ANT_FCSI_REGLDO";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.resetVal = "1'b0";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.addrStart = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.addrEnd = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.accessProperties = new Array ();
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "bypass off antenna ldo" ], 
        [ "ON", "1'b1", "bypass on antenna ldo" ]];
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration [0] = rfield_ANT_FCSI_REGLDO_ENBYPASSLDOANT.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.jsName      = "rfield_ANT_FCSI_REGLDO_PUPLCLDOANT";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.type        = "rfield";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.instName    = "PUPLCLDOANT";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.aliasName   = "PUPLCLDOANT";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.longName    = "pup_lc_ldo_ant";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.description = "<p>pup loop compensation of antenna ldo</p>";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.file = "";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.references = [
];
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.links = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.parent = "register_ANT_FCSI_REGLDO";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.resetVal = "1'b1";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.addrStart = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.addrEnd = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.accessProperties = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "power-down loop compensation of antenna ldo" ], 
        [ "ON", "1'b1", "power-up loop compensation of antenna ldo" ]];
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGLDO_PUPLCLDOANT";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration [0] = rfield_ANT_FCSI_REGLDO_PUPLCLDOANT.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGLDO_PUPLDOANT = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_PUPLDOANT.jsName      = "rfield_ANT_FCSI_REGLDO_PUPLDOANT";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.type        = "rfield";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.instName    = "PUPLDOANT";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.aliasName   = "PUPLDOANT";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.longName    = "pup_ldo_ant";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.description = "<p>pup antenna ldo</p>";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.file = "";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.references = [
];
rfield_ANT_FCSI_REGLDO_PUPLDOANT.links = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLDOANT.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLDOANT.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_PUPLDOANT.parent = "register_ANT_FCSI_REGLDO";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.resetVal = "1'b0";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.addrEnd = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.accessProperties = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLDOANT.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "power-down antenna ldo" ], 
        [ "ON", "1'b1", "power-up antenna ldo" ]];
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGLDO_PUPLDOANT";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration [0] = rfield_ANT_FCSI_REGLDO_PUPLDOANT.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_REGBIASING = new Object ();
register_ANT_FCSI_REGBIASING.reserved = false;
register_ANT_FCSI_REGBIASING.parent = "port_ANT_FCSI";
register_ANT_FCSI_REGBIASING.resetVal = "16'bXX00XX00XX00XXX0";
register_ANT_FCSI_REGBIASING.usedBits = "16'b0011001100110001";
register_ANT_FCSI_REGBIASING.undefBits = "16'b1100110011001110";
register_ANT_FCSI_REGBIASING.indirectAccessPort = "";
register_ANT_FCSI_REGBIASING.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_REGBIASING.jsName      = "register_ANT_FCSI_REGBIASING";
register_ANT_FCSI_REGBIASING.type        = "register";
register_ANT_FCSI_REGBIASING.baseName    = "BASIC";
register_ANT_FCSI_REGBIASING.instName    = "REGBIASING";
register_ANT_FCSI_REGBIASING.aliasName   = "REGBIASING";
register_ANT_FCSI_REGBIASING.longName    = "Mix-block Register 1 Biasing";
register_ANT_FCSI_REGBIASING.description = "pup and ibias programming";
register_ANT_FCSI_REGBIASING.file = "";
register_ANT_FCSI_REGBIASING.contacts    = "user_hebeinth";
register_ANT_FCSI_REGBIASING.references = [
];
register_ANT_FCSI_REGBIASING.links = new Array ();
register_ANT_FCSI_REGBIASING.pictures = new Array ();
register_ANT_FCSI_REGBIASING.debugMessages = [
];
register_ANT_FCSI_REGBIASING.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_REGBIASING.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGBIASING.addrStart  = new Array ();
register_ANT_FCSI_REGBIASING.addrEnd    = new Array ();
register_ANT_FCSI_REGBIASING.addrSpace  = new Array ();
register_ANT_FCSI_REGBIASING.dataWidth  = new Array ();
register_ANT_FCSI_REGBIASING.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001000101";
register_ANT_FCSI_REGBIASING.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001000101";
register_ANT_FCSI_REGBIASING.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REGBIASING.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGBIASING.addrStart ["register_ANT_FCSI_REGBIASING"] = "32'b00000000000000000000000001000101";
register_ANT_FCSI_REGBIASING.addrEnd ["register_ANT_FCSI_REGBIASING"] = "32'b00000000000000000000000001000101";
register_ANT_FCSI_REGBIASING.addrSpace ["register_ANT_FCSI_REGBIASING"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REGBIASING.dataWidth ["register_ANT_FCSI_REGBIASING"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGBIASING.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_REGBIASING.allowAddrOverlap = false;
register_ANT_FCSI_REGBIASING.isCollapsedIntoPort = false;
register_ANT_FCSI_REGBIASING.isLossless = true;
register_ANT_FCSI_REGBIASING.access       = new Array ();
register_ANT_FCSI_REGBIASING.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_REGBIASING.access ["register_ANT_FCSI_REGBIASING"] = "RW";
register_ANT_FCSI_REGBIASING.hierarchies       = new Array ();
register_ANT_FCSI_REGBIASING.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_REGBIASING"
];
register_ANT_FCSI_REGBIASING.fields = new Array ();
register_ANT_FCSI_REGBIASING.fields = [
        "rfield_ANT_FCSI_REGBIASING_PUPLB",
        "rfield_ANT_FCSI_REGBIASING_PROGSDADC25U",
        "rfield_ANT_FCSI_REGBIASING_PROGSDADC50U",
        "rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U"
];
register_ANT_FCSI_REGBIASING.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.jsName      = "rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.type        = "rfield";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.baseName    = "BASIC";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.instName    = "PROGSSIADC25U";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.aliasName   = "PROGSSIADC25U";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.longName    = "prog_ssiadc_25u";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.description = "<p>Programming of the 25uA Bias Current for the SSIADC</p>";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.file = "";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.references = [
];
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.links = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.pictures = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.debugMessages = [
];
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.parent = "register_ANT_FCSI_REGBIASING";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.resetVal = "2'b00";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.addrStart = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.addrEnd = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.accessProperties = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0 = [
        [ "25U", "2'b00", "25u" ], 
        [ "18U75", "2'b01", "18.75u" ], 
        [ "31U25", "2'b10", "31.25u" ], 
        [ "37U5", "2'b11", "37.5" ]];
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration [0] = rfield_ANT_FCSI_REGBIASING_PROGSSIADC25U.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.jsName      = "rfield_ANT_FCSI_REGBIASING_PROGSDADC50U";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.type        = "rfield";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.baseName    = "BASIC";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.instName    = "PROGSDADC50U";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.aliasName   = "PROGSDADC50U";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.longName    = "prog_sdadc_50u";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.description = "<p>Programming of the 50uA Bias Current for the SDADC</p>";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.file = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.references = [
];
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.links = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.pictures = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.debugMessages = [
];
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.parent = "register_ANT_FCSI_REGBIASING";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.resetVal = "2'b00";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.addrStart = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.addrEnd = "32'b00000000000000000000000000001001";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.accessProperties = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0 = [
        [ "50U", "2'b00", "50u" ], 
        [ "37U5", "2'b01", "37.5u" ], 
        [ "62U5", "2'b10", "62.5u" ], 
        [ "75U", "2'b11", "75u" ]];
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGBIASING_PROGSDADC50U";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration [0] = rfield_ANT_FCSI_REGBIASING_PROGSDADC50U.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.jsName      = "rfield_ANT_FCSI_REGBIASING_PROGSDADC25U";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.type        = "rfield";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.baseName    = "BASIC";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.instName    = "PROGSDADC25U";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.aliasName   = "PROGSDADC25U";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.longName    = "prog_sdadc_25u";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.description = "<p>Programming of the 25uA Bias Current for the SDADC</p>";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.file = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.references = [
];
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.links = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.pictures = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.debugMessages = [
];
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.parent = "register_ANT_FCSI_REGBIASING";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.resetVal = "2'b00";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.addrStart = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.addrEnd = "32'b00000000000000000000000000000101";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.accessProperties = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0 = [
        [ "25U", "2'b00", "25u" ], 
        [ "18U75", "2'b01", "18.75u" ], 
        [ "31U25", "2'b10", "31.25u" ], 
        [ "37U5", "2'b11", "37.5u" ]];
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGBIASING_PROGSDADC25U";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration [0] = rfield_ANT_FCSI_REGBIASING_PROGSDADC25U.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGBIASING_PUPLB = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGBIASING_PUPLB.jsName      = "rfield_ANT_FCSI_REGBIASING_PUPLB";
rfield_ANT_FCSI_REGBIASING_PUPLB.type        = "rfield";
rfield_ANT_FCSI_REGBIASING_PUPLB.baseName    = "BASIC";
rfield_ANT_FCSI_REGBIASING_PUPLB.instName    = "PUPLB";
rfield_ANT_FCSI_REGBIASING_PUPLB.aliasName   = "PUPLB";
rfield_ANT_FCSI_REGBIASING_PUPLB.longName    = "pup_local_bias";
rfield_ANT_FCSI_REGBIASING_PUPLB.description = "<p>Pup local bias</p>";
rfield_ANT_FCSI_REGBIASING_PUPLB.file = "";
rfield_ANT_FCSI_REGBIASING_PUPLB.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGBIASING_PUPLB.references = [
];
rfield_ANT_FCSI_REGBIASING_PUPLB.links = new Array ();
rfield_ANT_FCSI_REGBIASING_PUPLB.pictures = new Array ();
rfield_ANT_FCSI_REGBIASING_PUPLB.debugMessages = [
];
rfield_ANT_FCSI_REGBIASING_PUPLB.parent = "register_ANT_FCSI_REGBIASING";
rfield_ANT_FCSI_REGBIASING_PUPLB.resetVal = "1'b0";
rfield_ANT_FCSI_REGBIASING_PUPLB.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REGBIASING_PUPLB.addrEnd = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REGBIASING_PUPLB.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGBIASING_PUPLB.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGBIASING_PUPLB.accessProperties = new Array ();
rfield_ANT_FCSI_REGBIASING_PUPLB.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "power-down local biasing" ], 
        [ "ON", "1'b1", "power-up local biasing" ]];
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGBIASING_PUPLB";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration [0] = rfield_ANT_FCSI_REGBIASING_PUPLB.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_REGCLOCKING = new Object ();
register_ANT_FCSI_REGCLOCKING.reserved = false;
register_ANT_FCSI_REGCLOCKING.parent = "port_ANT_FCSI";
register_ANT_FCSI_REGCLOCKING.resetVal = "16'bXXXXXXXXXXX1XXX1";
register_ANT_FCSI_REGCLOCKING.usedBits = "16'b0000000000010001";
register_ANT_FCSI_REGCLOCKING.undefBits = "16'b1111111111101110";
register_ANT_FCSI_REGCLOCKING.indirectAccessPort = "";
register_ANT_FCSI_REGCLOCKING.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_REGCLOCKING.jsName      = "register_ANT_FCSI_REGCLOCKING";
register_ANT_FCSI_REGCLOCKING.type        = "register";
register_ANT_FCSI_REGCLOCKING.baseName    = "BASIC";
register_ANT_FCSI_REGCLOCKING.instName    = "REGCLOCKING";
register_ANT_FCSI_REGCLOCKING.aliasName   = "REGCLOCKING";
register_ANT_FCSI_REGCLOCKING.longName    = "Mix-block Register 0 Clocking";
register_ANT_FCSI_REGCLOCKING.description = "Power-downs for cml2cmos buffers";
register_ANT_FCSI_REGCLOCKING.file = "";
register_ANT_FCSI_REGCLOCKING.contacts    = "user_hebeinth";
register_ANT_FCSI_REGCLOCKING.references = [
];
register_ANT_FCSI_REGCLOCKING.links = new Array ();
register_ANT_FCSI_REGCLOCKING.pictures = new Array ();
register_ANT_FCSI_REGCLOCKING.debugMessages = [
];
register_ANT_FCSI_REGCLOCKING.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_REGCLOCKING.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGCLOCKING.addrStart  = new Array ();
register_ANT_FCSI_REGCLOCKING.addrEnd    = new Array ();
register_ANT_FCSI_REGCLOCKING.addrSpace  = new Array ();
register_ANT_FCSI_REGCLOCKING.dataWidth  = new Array ();
register_ANT_FCSI_REGCLOCKING.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001000100";
register_ANT_FCSI_REGCLOCKING.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001000100";
register_ANT_FCSI_REGCLOCKING.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REGCLOCKING.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGCLOCKING.addrStart ["register_ANT_FCSI_REGCLOCKING"] = "32'b00000000000000000000000001000100";
register_ANT_FCSI_REGCLOCKING.addrEnd ["register_ANT_FCSI_REGCLOCKING"] = "32'b00000000000000000000000001000100";
register_ANT_FCSI_REGCLOCKING.addrSpace ["register_ANT_FCSI_REGCLOCKING"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_REGCLOCKING.dataWidth ["register_ANT_FCSI_REGCLOCKING"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_REGCLOCKING.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_REGCLOCKING.allowAddrOverlap = false;
register_ANT_FCSI_REGCLOCKING.isCollapsedIntoPort = false;
register_ANT_FCSI_REGCLOCKING.isLossless = true;
register_ANT_FCSI_REGCLOCKING.access       = new Array ();
register_ANT_FCSI_REGCLOCKING.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_REGCLOCKING.access ["register_ANT_FCSI_REGCLOCKING"] = "RW";
register_ANT_FCSI_REGCLOCKING.hierarchies       = new Array ();
register_ANT_FCSI_REGCLOCKING.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_REGCLOCKING"
];
register_ANT_FCSI_REGCLOCKING.fields = new Array ();
register_ANT_FCSI_REGCLOCKING.fields = [
        "rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC",
        "rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC"
];
register_ANT_FCSI_REGCLOCKING.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.jsName      = "rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.type        = "rfield";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.baseName    = "BASIC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.instName    = "PDCML2CMOSDAC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.aliasName   = "PDCML2CMOSDAC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.longName    = "pd_cml2cmos_dac";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.description = "<p>Power Down cml2cmos buffer for dac</p>";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.file = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.references = [
];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.links = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.pictures = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.debugMessages = [
];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.parent = "register_ANT_FCSI_REGCLOCKING";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.resetVal = "1'b1";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.addrStart = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.addrEnd = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.accessProperties = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0 = [
        [ "PUP", "1'b0", "power-up cml2cmos buffer dac" ], 
        [ "PD", "1'b1", "power-down cml2cmos buffer dac" ]];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration [0] = rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSDAC.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.jsName      = "rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.type        = "rfield";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.baseName    = "BASIC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.instName    = "PDCML2CMOSADC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.aliasName   = "PDCML2CMOSADC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.longName    = "pd_cml2cmos_adc";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.description = "<p>Power Down cml2cmos-buffer for adc</p>";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.file = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.references = [
];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.links = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.pictures = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.debugMessages = [
];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.parent = "register_ANT_FCSI_REGCLOCKING";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.resetVal = "1'b1";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.addrEnd = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.accessProperties = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0 = [
        [ "PUP", "1'b0", "power-up cml2cmos buffer adc" ], 
        [ "PD", "1'b1", "power-down cml2cmos buffer adc" ]];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.parent = "rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.contacts    = "user_hebeinth";
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration [0] = rfield_ANT_FCSI_REGCLOCKING_PDCML2CMOSADC.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_IQADCREG3 = new Object ();
register_ANT_FCSI_IQADCREG3.reserved = false;
register_ANT_FCSI_IQADCREG3.parent = "port_ANT_FCSI";
register_ANT_FCSI_IQADCREG3.resetVal = "16'b0000000000000000";
register_ANT_FCSI_IQADCREG3.usedBits = "16'b1111111111111111";
register_ANT_FCSI_IQADCREG3.undefBits = "16'b0000000000000000";
register_ANT_FCSI_IQADCREG3.indirectAccessPort = "";
register_ANT_FCSI_IQADCREG3.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_IQADCREG3.jsName      = "register_ANT_FCSI_IQADCREG3";
register_ANT_FCSI_IQADCREG3.type        = "register";
register_ANT_FCSI_IQADCREG3.baseName    = "BASIC";
register_ANT_FCSI_IQADCREG3.instName    = "IQADCREG3";
register_ANT_FCSI_IQADCREG3.aliasName   = "IQADCREG3";
register_ANT_FCSI_IQADCREG3.longName    = "IQ_ADC_REG3";
register_ANT_FCSI_IQADCREG3.description = "IQ_ADC_REG3";
register_ANT_FCSI_IQADCREG3.file = "";
register_ANT_FCSI_IQADCREG3.contacts    = "user_presicce";
register_ANT_FCSI_IQADCREG3.references = [
];
register_ANT_FCSI_IQADCREG3.links = new Array ();
register_ANT_FCSI_IQADCREG3.pictures = new Array ();
register_ANT_FCSI_IQADCREG3.debugMessages = [
];
register_ANT_FCSI_IQADCREG3.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_IQADCREG3.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG3.addrStart  = new Array ();
register_ANT_FCSI_IQADCREG3.addrEnd    = new Array ();
register_ANT_FCSI_IQADCREG3.addrSpace  = new Array ();
register_ANT_FCSI_IQADCREG3.dataWidth  = new Array ();
register_ANT_FCSI_IQADCREG3.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001000011";
register_ANT_FCSI_IQADCREG3.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001000011";
register_ANT_FCSI_IQADCREG3.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQADCREG3.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG3.addrStart ["register_ANT_FCSI_IQADCREG3"] = "32'b00000000000000000000000001000011";
register_ANT_FCSI_IQADCREG3.addrEnd ["register_ANT_FCSI_IQADCREG3"] = "32'b00000000000000000000000001000011";
register_ANT_FCSI_IQADCREG3.addrSpace ["register_ANT_FCSI_IQADCREG3"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQADCREG3.dataWidth ["register_ANT_FCSI_IQADCREG3"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG3.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_IQADCREG3.allowAddrOverlap = false;
register_ANT_FCSI_IQADCREG3.isCollapsedIntoPort = false;
register_ANT_FCSI_IQADCREG3.isLossless = true;
register_ANT_FCSI_IQADCREG3.access       = new Array ();
register_ANT_FCSI_IQADCREG3.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_IQADCREG3.access ["register_ANT_FCSI_IQADCREG3"] = "RW";
register_ANT_FCSI_IQADCREG3.hierarchies       = new Array ();
register_ANT_FCSI_IQADCREG3.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_IQADCREG3"
];
register_ANT_FCSI_IQADCREG3.fields = new Array ();
register_ANT_FCSI_IQADCREG3.fields = [
        "rfield_ANT_FCSI_IQADCREG3_EXTENC11X3",
        "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1",
        "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2",
        "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3",
        "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1",
        "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2",
        "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3"
];
register_ANT_FCSI_IQADCREG3.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.type        = "rfield";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.instName    = "EXTTRIMIBOPA3";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.aliasName   = "EXTTRIMIBOPA3";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.longName    = "ext_trim_ib_opa3";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.description = "<p>IQ-ADC Trim op3 bias current (set &apos;1010&apos; for 40MHz; set &apos;0100&apos; for 20MHz, op3 not used 10MHz, therefore ib settings nut used)</p>";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.parent = "register_ANT_FCSI_IQADCREG3";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.resetVal = "4'b0000";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.addrStart = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.addrEnd = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.dataWidth = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0 = [
        [ "MIN", "4'b0000", "min current = 0.3 * 50uA (default)" ], 
        [ "MAX", "4'b1111", "max current = 1.2 * 50uA" ]];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA3.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.type        = "rfield";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.instName    = "EXTTRIMIBOPA2";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.aliasName   = "EXTTRIMIBOPA2";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.longName    = "ext_trim_ib_opa2";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.description = "<p>IQ-ADC Trim op2 bias current (set &apos;0101&apos; for 40MHz; op2 not used for 20MHz and 10MHz, therefore ib settings nut used)</p>";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.parent = "register_ANT_FCSI_IQADCREG3";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.resetVal = "4'b0000";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.addrStart = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.addrEnd = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.dataWidth = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0 = [
        [ "MIN", "4'b0000", "min current = 0.3 * 50uA (default)" ], 
        [ "MAX", "4'b1111", "max current = 1.2 * 50uA" ]];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA2.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.type        = "rfield";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.instName    = "EXTTRIMIBOPA1";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.aliasName   = "EXTTRIMIBOPA1";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.longName    = "ext_trim_ib_opa1";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.description = "<p>IQ-ADC Trim op1 bias current (set &apos;0110&apos; for 40MHz; set &apos;0010&apos; for 20MHz; set &apos;0011&apos; for 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.parent = "register_ANT_FCSI_IQADCREG3";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.resetVal = "4'b0000";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.addrStart = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.addrEnd = "32'b00000000000000000000000000000111";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.dataWidth = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0 = [
        [ "MIN", "4'b0000", "min current = 0.3 * 50uA (default)" ], 
        [ "MAX", "4'b1111", "max current = 1.2 * 50uA" ]];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG3_EXTTRIMIBOPA1.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.type        = "rfield";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.instName    = "EXTPDOPA3";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.aliasName   = "EXTPDOPA3";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.longName    = "ext_pd_opa3";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.description = "<p>IQ-ADC Power down opamp3 (set &apos;0&apos; for 40MHz and 20MHz; set &apos;1&apos; for 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.parent = "register_ANT_FCSI_IQADCREG3";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.addrStart = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.addrEnd = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0 = [
        [ "PUP", "1'b0", "opa3 in power-up (default)" ], 
        [ "PDN", "1'b1", "opa3 in power-down" ]];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG3_EXTPDOPA3.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.type        = "rfield";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.instName    = "EXTPDOPA2";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.aliasName   = "EXTPDOPA2";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.longName    = "ext_pd_opa2";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.description = "<p>IQ-ADC Power down opamp2 (set &apos;0&apos; for 40MHz; set &apos;1&apos; for 20MHz and 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.parent = "register_ANT_FCSI_IQADCREG3";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.addrStart = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.addrEnd = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0 = [
        [ "PUP", "1'b0", "opa2 in power-up (default)" ], 
        [ "PDN", "1'b1", "opa2 in power-down" ]];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG3_EXTPDOPA2.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.type        = "rfield";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.instName    = "EXTPDOPA1";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.aliasName   = "EXTPDOPA1";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.longName    = "ext_pd_opa1";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.description = "<p>IQ-ADC Power down opamp1 (set &apos;0&apos; for 40MHz, 20MHzand 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.parent = "register_ANT_FCSI_IQADCREG3";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.addrStart = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.addrEnd = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0 = [
        [ "PUP", "1'b0", "opa1 in power-up (default)" ], 
        [ "PDN", "1'b1", "opa1 in power-down" ]];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG3_EXTPDOPA1.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTENC11X3";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.type        = "rfield";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.instName    = "EXTENC11X3";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.aliasName   = "EXTENC11X3";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.longName    = "ext_en_c1_1x3";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.description = "<p>IQ-ADC Enable increasing C1 value by factor 1.3 (set &apos;0&apos; for 40MHz and 20MHz; set &apos;1&apos; for 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.parent = "register_ANT_FCSI_IQADCREG3";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.addrEnd = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "default C1_value (default)" ], 
        [ "ON", "1'b1", "C1_value*1.3" ]];
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG3_EXTENC11X3";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG3_EXTENC11X3.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_IQADCREG2 = new Object ();
register_ANT_FCSI_IQADCREG2.reserved = false;
register_ANT_FCSI_IQADCREG2.parent = "port_ANT_FCSI";
register_ANT_FCSI_IQADCREG2.resetVal = "16'b0000000000000000";
register_ANT_FCSI_IQADCREG2.usedBits = "16'b1111111111111111";
register_ANT_FCSI_IQADCREG2.undefBits = "16'b0000000000000000";
register_ANT_FCSI_IQADCREG2.indirectAccessPort = "";
register_ANT_FCSI_IQADCREG2.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_IQADCREG2.jsName      = "register_ANT_FCSI_IQADCREG2";
register_ANT_FCSI_IQADCREG2.type        = "register";
register_ANT_FCSI_IQADCREG2.baseName    = "BASIC";
register_ANT_FCSI_IQADCREG2.instName    = "IQADCREG2";
register_ANT_FCSI_IQADCREG2.aliasName   = "IQADCREG2";
register_ANT_FCSI_IQADCREG2.longName    = "IQ_ADC_REG2";
register_ANT_FCSI_IQADCREG2.description = "IQ_ADC_REG2";
register_ANT_FCSI_IQADCREG2.file = "";
register_ANT_FCSI_IQADCREG2.contacts    = "user_presicce";
register_ANT_FCSI_IQADCREG2.references = [
];
register_ANT_FCSI_IQADCREG2.links = new Array ();
register_ANT_FCSI_IQADCREG2.pictures = new Array ();
register_ANT_FCSI_IQADCREG2.debugMessages = [
];
register_ANT_FCSI_IQADCREG2.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_IQADCREG2.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG2.addrStart  = new Array ();
register_ANT_FCSI_IQADCREG2.addrEnd    = new Array ();
register_ANT_FCSI_IQADCREG2.addrSpace  = new Array ();
register_ANT_FCSI_IQADCREG2.dataWidth  = new Array ();
register_ANT_FCSI_IQADCREG2.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001000010";
register_ANT_FCSI_IQADCREG2.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001000010";
register_ANT_FCSI_IQADCREG2.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQADCREG2.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG2.addrStart ["register_ANT_FCSI_IQADCREG2"] = "32'b00000000000000000000000001000010";
register_ANT_FCSI_IQADCREG2.addrEnd ["register_ANT_FCSI_IQADCREG2"] = "32'b00000000000000000000000001000010";
register_ANT_FCSI_IQADCREG2.addrSpace ["register_ANT_FCSI_IQADCREG2"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQADCREG2.dataWidth ["register_ANT_FCSI_IQADCREG2"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG2.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_IQADCREG2.allowAddrOverlap = false;
register_ANT_FCSI_IQADCREG2.isCollapsedIntoPort = false;
register_ANT_FCSI_IQADCREG2.isLossless = true;
register_ANT_FCSI_IQADCREG2.access       = new Array ();
register_ANT_FCSI_IQADCREG2.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_IQADCREG2.access ["register_ANT_FCSI_IQADCREG2"] = "RW";
register_ANT_FCSI_IQADCREG2.hierarchies       = new Array ();
register_ANT_FCSI_IQADCREG2.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_IQADCREG2"
];
register_ANT_FCSI_IQADCREG2.fields = new Array ();
register_ANT_FCSI_IQADCREG2.fields = [
        "rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT",
        "rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE",
        "rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE",
        "rfield_ANT_FCSI_IQADCREG2_EXTENC3X2",
        "rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3",
        "rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3",
        "rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2",
        "rfield_ANT_FCSI_IQADCREG2_EXTENSWR3",
        "rfield_ANT_FCSI_IQADCREG2_EXTENSWR4",
        "rfield_ANT_FCSI_IQADCREG2_EXTENSWLP"
];
register_ANT_FCSI_IQADCREG2.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWLP";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.instName    = "EXTENSWLP";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.aliasName   = "EXTENSWLP";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.longName    = "ext_en_switch_lp";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.description = "<p>IQ-ADC Enable switch to bypass inte 2 &amp; 3 (set &apos;0&apos; for 40MHz and 20MHz; set &apos;1&apos; for 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.addrStart = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.addrEnd = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "switch open (default)" ], 
        [ "ON", "1'b1", "switch shorts inte1 output to lf output" ]];
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_EXTENSWLP";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_EXTENSWLP.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWR4";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.instName    = "EXTENSWR4";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.aliasName   = "EXTENSWR4";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.longName    = "ext_en_switch_r4";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.description = "<p>IQ-ADC Enable switch of R4 (set &apos;1&apos; for 40MHz; set &apos;0&apos; for 20MHz and 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.addrStart = "32'b00000000000000000000000000001110";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.addrEnd = "32'b00000000000000000000000000001110";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "R4 open (default)" ], 
        [ "ON", "1'b1", "R4 = R4_40MHz" ]];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_EXTENSWR4";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_EXTENSWR4.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWR3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.instName    = "EXTENSWR3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.aliasName   = "EXTENSWR3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.longName    = "ext_en_switch_r3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.description = "<p>IQ-ADC Enable switch of R3 (set &apos;1&apos; for 40MHz; set &apos;0&apos; for 20MHz and 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.addrStart = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.addrEnd = "32'b00000000000000000000000000001101";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "R3 open (default)" ], 
        [ "ON", "1'b1", "R3 = R3_40MHz" ]];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_EXTENSWR3";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_EXTENSWR3.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.instName    = "EXTENSWRC2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.aliasName   = "EXTENSWRC2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.longName    = "ext_en_switch_rc2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.description = "<p>IQ-ADC Enable switch of Rc2 (set &apos;1&apos; for 40MHz; set &apos;0&apos; for 20MHz and 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.addrStart = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.addrEnd = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "Rc2 = inf (switch open) (default)" ], 
        [ "ON", "1'b1", "Rc2 = switch resistance" ]];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_EXTENSWRC2.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.instName    = "EXTENSWRC3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.aliasName   = "EXTENSWRC3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.longName    = "ext_en_switch_rc3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.description = "<p>IQ-ADC Enable switch of Rc3 (set &apos;1&apos; for 40MHz; set &apos;0&apos; for 20MHz and 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.addrStart = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.addrEnd = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "Rc3 = Rc3fix (default)" ], 
        [ "ON", "1'b1", "Rc3 = Rc3fix // Rc3add" ]];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_EXTENSWRC3.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.instName    = "EXTENSWRESC3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.aliasName   = "EXTENSWRESC3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.longName    = "ext_en_switch_resc3";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.description = "<p>IQ-ADC Enable short of Rc3 + C3 (set &apos;0&apos; for 40MHz and 20MHz; set &apos;1&apos; for 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.addrStart = "32'b00000000000000000000000000001010";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.addrEnd = "32'b00000000000000000000000000001010";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "feedback of 3rd integrator = series of C3 + Rc3 (default)" ], 
        [ "ON", "1'b1", "C3 + Rc3 is shorted, no integrator" ]];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_EXTENSWRESC3.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENC3X2";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.instName    = "EXTENC3X2";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.aliasName   = "EXTENC3X2";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.longName    = "ext_en_c3_x2";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.description = "<p>IQ-ADC Enable doubling C3 value (set &apos;0&apos; for 40MHz; set &apos;1&apos; for 20MHz and 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.addrStart = "32'b00000000000000000000000000001001";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.addrEnd = "32'b00000000000000000000000000001001";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "standard C3 value (default)" ], 
        [ "ON", "1'b1", "C3 value*2" ]];
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_EXTENC3X2";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_EXTENC3X2.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.instName    = "EXTC3TUNE";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.aliasName   = "EXTC3TUNE";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.longName    = "ext_c3_tune";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.description = "<p>IQ-ADC Tune C3 value (set &apos;0101&apos; for 40MHz and 20MHz, set &apos;1111&apos; for 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.resetVal = "4'b0000";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.addrStart = "32'b00000000000000000000000000000101";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.addrEnd = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.dataWidth = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0 = [
        [ "MIN", "4'b0000", "min cap (default)" ], 
        [ "MAX", "4'b1111", "max cap" ]];
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_EXTC3TUNE.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.instName    = "EXTC2TUNE";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.aliasName   = "EXTC2TUNE";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.longName    = "ext_c2_tune";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.description = "<p>IQ-ADC Tune C2 value (set &apos;0101&apos; for 40MHz, 20MHz and 10MHz)</p>";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.resetVal = "4'b0000";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.addrStart = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.addrEnd = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.dataWidth = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0 = [
        [ "MIN", "4'b0000", "min cap (default)" ], 
        [ "MAX", "4'b1111", "max cap" ]];
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_EXTC2TUNE.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.jsName      = "rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.type        = "rfield";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.instName    = "ENFORCEEXT";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.aliasName   = "ENFORCEEXT";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.longName    = "en_force_external";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.description = "<p>IQ-ADC Enable usage of register Bits of IQADCREG2 and IQADCREG3 (set to 1 for 40MHz,20MHz, and 10MHz mode)</p>";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.file = "";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.references = [
];
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.parent = "register_ANT_FCSI_IQADCREG2";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.addrEnd = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "IQADCREG2 and IQADCREG3 ignored (default)" ], 
        [ "ON", "1'b1", "use IQADCREG2 and IQADCREG3" ]];
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG2_ENFORCEEXT.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_IQADCREG1 = new Object ();
register_ANT_FCSI_IQADCREG1.reserved = false;
register_ANT_FCSI_IQADCREG1.parent = "port_ANT_FCSI";
register_ANT_FCSI_IQADCREG1.resetVal = "16'b1XX101X011X10111";
register_ANT_FCSI_IQADCREG1.usedBits = "16'b1001110111011111";
register_ANT_FCSI_IQADCREG1.undefBits = "16'b0110001000100000";
register_ANT_FCSI_IQADCREG1.indirectAccessPort = "";
register_ANT_FCSI_IQADCREG1.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_IQADCREG1.jsName      = "register_ANT_FCSI_IQADCREG1";
register_ANT_FCSI_IQADCREG1.type        = "register";
register_ANT_FCSI_IQADCREG1.baseName    = "BASIC";
register_ANT_FCSI_IQADCREG1.instName    = "IQADCREG1";
register_ANT_FCSI_IQADCREG1.aliasName   = "IQADCREG1";
register_ANT_FCSI_IQADCREG1.longName    = "IQ_ADC_REG1";
register_ANT_FCSI_IQADCREG1.description = "IQ_ADC_REG1";
register_ANT_FCSI_IQADCREG1.file = "";
register_ANT_FCSI_IQADCREG1.contacts    = "user_presicce";
register_ANT_FCSI_IQADCREG1.references = [
];
register_ANT_FCSI_IQADCREG1.links = new Array ();
register_ANT_FCSI_IQADCREG1.pictures = new Array ();
register_ANT_FCSI_IQADCREG1.debugMessages = [
];
register_ANT_FCSI_IQADCREG1.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_IQADCREG1.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG1.addrStart  = new Array ();
register_ANT_FCSI_IQADCREG1.addrEnd    = new Array ();
register_ANT_FCSI_IQADCREG1.addrSpace  = new Array ();
register_ANT_FCSI_IQADCREG1.dataWidth  = new Array ();
register_ANT_FCSI_IQADCREG1.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001000001";
register_ANT_FCSI_IQADCREG1.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001000001";
register_ANT_FCSI_IQADCREG1.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQADCREG1.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG1.addrStart ["register_ANT_FCSI_IQADCREG1"] = "32'b00000000000000000000000001000001";
register_ANT_FCSI_IQADCREG1.addrEnd ["register_ANT_FCSI_IQADCREG1"] = "32'b00000000000000000000000001000001";
register_ANT_FCSI_IQADCREG1.addrSpace ["register_ANT_FCSI_IQADCREG1"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQADCREG1.dataWidth ["register_ANT_FCSI_IQADCREG1"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG1.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_IQADCREG1.allowAddrOverlap = false;
register_ANT_FCSI_IQADCREG1.isCollapsedIntoPort = false;
register_ANT_FCSI_IQADCREG1.isLossless = true;
register_ANT_FCSI_IQADCREG1.access       = new Array ();
register_ANT_FCSI_IQADCREG1.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_IQADCREG1.access ["register_ANT_FCSI_IQADCREG1"] = "RW";
register_ANT_FCSI_IQADCREG1.hierarchies       = new Array ();
register_ANT_FCSI_IQADCREG1.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_IQADCREG1"
];
register_ANT_FCSI_IQADCREG1.fields = new Array ();
register_ANT_FCSI_IQADCREG1.fields = [
        "rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM",
        "rfield_ANT_FCSI_IQADCREG1_ADCCLKINV",
        "rfield_ANT_FCSI_IQADCREG1_COMPL2",
        "rfield_ANT_FCSI_IQADCREG1_PROGCD",
        "rfield_ANT_FCSI_IQADCREG1_ENSLEEP",
        "rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL",
        "rfield_ANT_FCSI_IQADCREG1_DELPROG",
        "rfield_ANT_FCSI_IQADCREG1_RESET"
];
register_ANT_FCSI_IQADCREG1.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG1_RESET = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_RESET.jsName      = "rfield_ANT_FCSI_IQADCREG1_RESET";
rfield_ANT_FCSI_IQADCREG1_RESET.type        = "rfield";
rfield_ANT_FCSI_IQADCREG1_RESET.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_RESET.instName    = "RESET";
rfield_ANT_FCSI_IQADCREG1_RESET.aliasName   = "RESET";
rfield_ANT_FCSI_IQADCREG1_RESET.longName    = "reset";
rfield_ANT_FCSI_IQADCREG1_RESET.description = "<p>IQ-ADC reset (not used in wave500)</p>";
rfield_ANT_FCSI_IQADCREG1_RESET.file = "";
rfield_ANT_FCSI_IQADCREG1_RESET.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_RESET.references = [
];
rfield_ANT_FCSI_IQADCREG1_RESET.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_RESET.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_RESET.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_RESET.parent = "register_ANT_FCSI_IQADCREG1";
rfield_ANT_FCSI_IQADCREG1_RESET.resetVal = "1'b1";
rfield_ANT_FCSI_IQADCREG1_RESET.addrStart = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_IQADCREG1_RESET.addrEnd = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_IQADCREG1_RESET.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG1_RESET.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG1_RESET.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG1_RESET.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "no reset" ], 
        [ "ON", "1'b1", "reset (default)" ]];
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG1_RESET";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG1_RESET.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG1_DELPROG = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_DELPROG.jsName      = "rfield_ANT_FCSI_IQADCREG1_DELPROG";
rfield_ANT_FCSI_IQADCREG1_DELPROG.type        = "rfield";
rfield_ANT_FCSI_IQADCREG1_DELPROG.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_DELPROG.instName    = "DELPROG";
rfield_ANT_FCSI_IQADCREG1_DELPROG.aliasName   = "DELPROG";
rfield_ANT_FCSI_IQADCREG1_DELPROG.longName    = "del_prog";
rfield_ANT_FCSI_IQADCREG1_DELPROG.description = "<p>IQ-ADC delay between power-up and reset release select</p>";
rfield_ANT_FCSI_IQADCREG1_DELPROG.file = "";
rfield_ANT_FCSI_IQADCREG1_DELPROG.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_DELPROG.references = [
];
rfield_ANT_FCSI_IQADCREG1_DELPROG.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_DELPROG.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_DELPROG.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_DELPROG.parent = "register_ANT_FCSI_IQADCREG1";
rfield_ANT_FCSI_IQADCREG1_DELPROG.resetVal = "2'b10";
rfield_ANT_FCSI_IQADCREG1_DELPROG.addrStart = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_IQADCREG1_DELPROG.addrEnd = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_IQADCREG1_DELPROG.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_IQADCREG1_DELPROG.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG1_DELPROG.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG1_DELPROG.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0 = [
        [ "25NS", "2'b00", "25ns delay" ], 
        [ "50NS", "2'b01", "50ns delay" ], 
        [ "75NS", "2'b10", "75ns delay (default)" ], 
        [ "100NS", "2'b11", "100ns delay" ]];
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG1_DELPROG";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG1_DELPROG.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.jsName      = "rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.type        = "rfield";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.instName    = "ENPDRESDEL";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.aliasName   = "ENPDRESDEL";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.longName    = "en_pdres_del";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.description = "<p>IQ-ADC Enable programmable delay between pd and reset</p>";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.file = "";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.references = [
];
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.parent = "register_ANT_FCSI_IQADCREG1";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.resetVal = "1'b1";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.addrStart = "32'b00000000000000000000000000001010";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.addrEnd = "32'b00000000000000000000000000001010";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "reset = reset" ], 
        [ "ON", "1'b1", "reset = delayed version of pd (default)" ]];
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG1_ENPDRESDEL.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG1_ENSLEEP = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.jsName      = "rfield_ANT_FCSI_IQADCREG1_ENSLEEP";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.type        = "rfield";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.instName    = "ENSLEEP";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.aliasName   = "ENSLEEP";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.longName    = "en_sleep";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.description = "<p>IQ-ADC Enable sleep mode</p>";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.file = "";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.references = [
];
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.parent = "register_ANT_FCSI_IQADCREG1";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.addrStart = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.addrEnd = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0 = [
        [ "OFF", "1'b0", "ADC disabled (default)" ], 
        [ "ON", "1'b1", "ADC enabled" ]];
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG1_ENSLEEP";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG1_ENSLEEP.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG1_PROGCD = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_PROGCD.jsName      = "rfield_ANT_FCSI_IQADCREG1_PROGCD";
rfield_ANT_FCSI_IQADCREG1_PROGCD.type        = "rfield";
rfield_ANT_FCSI_IQADCREG1_PROGCD.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_PROGCD.instName    = "PROGCD";
rfield_ANT_FCSI_IQADCREG1_PROGCD.aliasName   = "PROGCD";
rfield_ANT_FCSI_IQADCREG1_PROGCD.longName    = "clip detection delay programming";
rfield_ANT_FCSI_IQADCREG1_PROGCD.description = "<p>IQ-ADC Programs the minimum pulse duration for clip detection from 4 clockcycles up to 10 clockcycles</p>";
rfield_ANT_FCSI_IQADCREG1_PROGCD.file = "";
rfield_ANT_FCSI_IQADCREG1_PROGCD.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_PROGCD.references = [
];
rfield_ANT_FCSI_IQADCREG1_PROGCD.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_PROGCD.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_PROGCD.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_PROGCD.parent = "register_ANT_FCSI_IQADCREG1";
rfield_ANT_FCSI_IQADCREG1_PROGCD.resetVal = "2'b11";
rfield_ANT_FCSI_IQADCREG1_PROGCD.addrStart = "32'b00000000000000000000000000000110";
rfield_ANT_FCSI_IQADCREG1_PROGCD.addrEnd = "32'b00000000000000000000000000000111";
rfield_ANT_FCSI_IQADCREG1_PROGCD.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_IQADCREG1_PROGCD.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG1_PROGCD.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG1_PROGCD.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0 = [
        [ "TCLK4", "2'b00", "4*Tclk" ], 
        [ "TCLK6", "2'b01", "6*Tclk" ], 
        [ "TCLK8", "2'b10", "8*Tclk" ], 
        [ "TCLK10", "2'b11", "10*Tclk (default)" ]];
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG1_PROGCD";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG1_PROGCD.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG1_COMPL2 = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_COMPL2.jsName      = "rfield_ANT_FCSI_IQADCREG1_COMPL2";
rfield_ANT_FCSI_IQADCREG1_COMPL2.type        = "rfield";
rfield_ANT_FCSI_IQADCREG1_COMPL2.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_COMPL2.instName    = "COMPL2";
rfield_ANT_FCSI_IQADCREG1_COMPL2.aliasName   = "COMPL2";
rfield_ANT_FCSI_IQADCREG1_COMPL2.longName    = "compl2";
rfield_ANT_FCSI_IQADCREG1_COMPL2.description = "<p>IQ-ADC Enable 2&apos;s complement</p>";
rfield_ANT_FCSI_IQADCREG1_COMPL2.file = "";
rfield_ANT_FCSI_IQADCREG1_COMPL2.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_COMPL2.references = [
];
rfield_ANT_FCSI_IQADCREG1_COMPL2.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_COMPL2.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_COMPL2.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_COMPL2.parent = "register_ANT_FCSI_IQADCREG1";
rfield_ANT_FCSI_IQADCREG1_COMPL2.resetVal = "1'b1";
rfield_ANT_FCSI_IQADCREG1_COMPL2.addrStart = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG1_COMPL2.addrEnd = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG1_COMPL2.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG1_COMPL2.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG1_COMPL2.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG1_COMPL2.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0 = [
        [ "DEFAULT", "1'b0", "binary (default)" ], 
        [ "2COMPL", "1'b1", "2&apos;s complement" ]];
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG1_COMPL2";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG1_COMPL2.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.jsName      = "rfield_ANT_FCSI_IQADCREG1_ADCCLKINV";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.type        = "rfield";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.instName    = "ADCCLKINV";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.aliasName   = "ADCCLKINV";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.longName    = "adc_clk_inv";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.description = "<p>IQ-ADC invert clk</p>";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.file = "";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.references = [
];
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.parent = "register_ANT_FCSI_IQADCREG1";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.addrStart = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.addrEnd = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0 = [
        [ "NORMAL", "1'b0", "clk not inverted" ], 
        [ "INV", "1'b1", "clk inverted" ]];
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG1_ADCCLKINV";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG1_ADCCLKINV.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.jsName      = "rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.type        = "rfield";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.instName    = "IBSLEEPTRIM";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.aliasName   = "IBSLEEPTRIM";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.longName    = "ibsleeptrim";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.description = "<p>IQ-ADC Program sleep current</p>";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.file = "";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.references = [
];
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.parent = "register_ANT_FCSI_IQADCREG1";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.resetVal = "3'b111";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.addrEnd = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.dataWidth = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0 = [
        [ "100", "3'b000", "100%" ], 
        [ "50", "3'b001", "50%" ], 
        [ "33", "3'b010", "33%" ], 
        [ "25", "3'b011", "25%" ], 
        [ "20", "3'b100", "20%" ], 
        [ "16P6", "3'b101", "16.6%" ], 
        [ "4P3", "3'b110", "14.3%" ], 
        [ "12P5", "3'b111", "12.5% (default)" ]];
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG1_IBSLEEPTRIM.attributes.enumeration_0;
/////////////////////////////////
// Register //////////////////////////
register_ANT_FCSI_IQADCREG0 = new Object ();
register_ANT_FCSI_IQADCREG0.reserved = false;
register_ANT_FCSI_IQADCREG0.parent = "port_ANT_FCSI";
register_ANT_FCSI_IQADCREG0.resetVal = "16'b1XX111X0X1100111";
register_ANT_FCSI_IQADCREG0.usedBits = "16'b1001110101111111";
register_ANT_FCSI_IQADCREG0.undefBits = "16'b0110001010000000";
register_ANT_FCSI_IQADCREG0.indirectAccessPort = "";
register_ANT_FCSI_IQADCREG0.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
register_ANT_FCSI_IQADCREG0.jsName      = "register_ANT_FCSI_IQADCREG0";
register_ANT_FCSI_IQADCREG0.type        = "register";
register_ANT_FCSI_IQADCREG0.baseName    = "BASIC";
register_ANT_FCSI_IQADCREG0.instName    = "IQADCREG0";
register_ANT_FCSI_IQADCREG0.aliasName   = "IQADCREG0";
register_ANT_FCSI_IQADCREG0.longName    = "IQ_ADC_REG0";
register_ANT_FCSI_IQADCREG0.description = "IQ_ADC_REG0";
register_ANT_FCSI_IQADCREG0.file = "";
register_ANT_FCSI_IQADCREG0.contacts    = "user_presicce";
register_ANT_FCSI_IQADCREG0.references = [
];
register_ANT_FCSI_IQADCREG0.links = new Array ();
register_ANT_FCSI_IQADCREG0.pictures = new Array ();
register_ANT_FCSI_IQADCREG0.debugMessages = [
];
register_ANT_FCSI_IQADCREG0.views  = [
        "port_ANT_FCSI"
];
register_ANT_FCSI_IQADCREG0.addrBase   = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG0.addrStart  = new Array ();
register_ANT_FCSI_IQADCREG0.addrEnd    = new Array ();
register_ANT_FCSI_IQADCREG0.addrSpace  = new Array ();
register_ANT_FCSI_IQADCREG0.dataWidth  = new Array ();
register_ANT_FCSI_IQADCREG0.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000001000000";
register_ANT_FCSI_IQADCREG0.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001000000";
register_ANT_FCSI_IQADCREG0.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQADCREG0.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG0.addrStart ["register_ANT_FCSI_IQADCREG0"] = "32'b00000000000000000000000001000000";
register_ANT_FCSI_IQADCREG0.addrEnd ["register_ANT_FCSI_IQADCREG0"] = "32'b00000000000000000000000001000000";
register_ANT_FCSI_IQADCREG0.addrSpace ["register_ANT_FCSI_IQADCREG0"] = "32'b00000000000000000000000000000001";
register_ANT_FCSI_IQADCREG0.dataWidth ["register_ANT_FCSI_IQADCREG0"] = "32'b00000000000000000000000000010000";
register_ANT_FCSI_IQADCREG0.offsetAsView     = "32'b00000000000000000000000000000000"
register_ANT_FCSI_IQADCREG0.allowAddrOverlap = false;
register_ANT_FCSI_IQADCREG0.isCollapsedIntoPort = false;
register_ANT_FCSI_IQADCREG0.isLossless = true;
register_ANT_FCSI_IQADCREG0.access       = new Array ();
register_ANT_FCSI_IQADCREG0.access ["port_ANT_FCSI"] = "RW";
register_ANT_FCSI_IQADCREG0.access ["register_ANT_FCSI_IQADCREG0"] = "RW";
register_ANT_FCSI_IQADCREG0.hierarchies       = new Array ();
register_ANT_FCSI_IQADCREG0.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "register_ANT_FCSI_IQADCREG0"
];
register_ANT_FCSI_IQADCREG0.fields = new Array ();
register_ANT_FCSI_IQADCREG0.fields = [
        "rfield_ANT_FCSI_IQADCREG0_CTUNE",
        "rfield_ANT_FCSI_IQADCREG0_EN20M",
        "rfield_ANT_FCSI_IQADCREG0_PROGLFRES",
        "rfield_ANT_FCSI_IQADCREG0_ENLOWPOW",
        "rfield_ANT_FCSI_IQADCREG0_SWBULK",
        "rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE",
        "rfield_ANT_FCSI_IQADCREG0_ENCD",
        "rfield_ANT_FCSI_IQADCREG0_PDADC"
];
register_ANT_FCSI_IQADCREG0.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG0_PDADC = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_PDADC.jsName      = "rfield_ANT_FCSI_IQADCREG0_PDADC";
rfield_ANT_FCSI_IQADCREG0_PDADC.type        = "rfield";
rfield_ANT_FCSI_IQADCREG0_PDADC.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_PDADC.instName    = "PDADC";
rfield_ANT_FCSI_IQADCREG0_PDADC.aliasName   = "PDADC";
rfield_ANT_FCSI_IQADCREG0_PDADC.longName    = "pd_adc";
rfield_ANT_FCSI_IQADCREG0_PDADC.description = "<p>IQ-ADC Power down ADC</p>";
rfield_ANT_FCSI_IQADCREG0_PDADC.file = "";
rfield_ANT_FCSI_IQADCREG0_PDADC.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_PDADC.references = [
];
rfield_ANT_FCSI_IQADCREG0_PDADC.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_PDADC.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_PDADC.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_PDADC.parent = "register_ANT_FCSI_IQADCREG0";
rfield_ANT_FCSI_IQADCREG0_PDADC.resetVal = "1'b1";
rfield_ANT_FCSI_IQADCREG0_PDADC.addrStart = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_IQADCREG0_PDADC.addrEnd = "32'b00000000000000000000000000001111";
rfield_ANT_FCSI_IQADCREG0_PDADC.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG0_PDADC.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG0_PDADC.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG0_PDADC.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0 = [
        [ "PUP", "1'b0", "ADC in active mode" ], 
        [ "PD", "1'b1", "ADC off (default)" ]];
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG0_PDADC";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG0_PDADC.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG0_ENCD = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_ENCD.jsName      = "rfield_ANT_FCSI_IQADCREG0_ENCD";
rfield_ANT_FCSI_IQADCREG0_ENCD.type        = "rfield";
rfield_ANT_FCSI_IQADCREG0_ENCD.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_ENCD.instName    = "ENCD";
rfield_ANT_FCSI_IQADCREG0_ENCD.aliasName   = "ENCD";
rfield_ANT_FCSI_IQADCREG0_ENCD.longName    = "en_cd";
rfield_ANT_FCSI_IQADCREG0_ENCD.description = "<p>IQ-ADC Enable clip detector</p>";
rfield_ANT_FCSI_IQADCREG0_ENCD.file = "";
rfield_ANT_FCSI_IQADCREG0_ENCD.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_ENCD.references = [
];
rfield_ANT_FCSI_IQADCREG0_ENCD.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENCD.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENCD.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_ENCD.parent = "register_ANT_FCSI_IQADCREG0";
rfield_ANT_FCSI_IQADCREG0_ENCD.resetVal = "1'b1";
rfield_ANT_FCSI_IQADCREG0_ENCD.addrStart = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_IQADCREG0_ENCD.addrEnd = "32'b00000000000000000000000000001100";
rfield_ANT_FCSI_IQADCREG0_ENCD.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG0_ENCD.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG0_ENCD.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENCD.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0 = [
        [ "DISCD", "1'b0", "clip detector off" ], 
        [ "ENCD", "1'b1", "clip detector active (default)" ]];
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG0_ENCD";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG0_ENCD.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.jsName      = "rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.type        = "rfield";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.instName    = "ENLFRESETPULSE";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.aliasName   = "ENLFRESETPULSE";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.longName    = "en_lfreset_pulse";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.description = "<p>IQ-ADC Enable reset pulse duration for programmable time</p>";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.file = "";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.references = [
];
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.parent = "register_ANT_FCSI_IQADCREG0";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.resetVal = "1'b1";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.addrStart = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.addrEnd = "32'b00000000000000000000000000001011";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0 = [
        [ "DISLFRESETPULSE", "1'b0", "clip detection signal controls lf reset" ], 
        [ "ENLFRESETPULSE", "1'b1", "after clip detection reset is kept for a minimum time (depends on rising edge of clip detection signal) (default)" ]];
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG0_ENLFRESETPULSE.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG0_SWBULK = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_SWBULK.jsName      = "rfield_ANT_FCSI_IQADCREG0_SWBULK";
rfield_ANT_FCSI_IQADCREG0_SWBULK.type        = "rfield";
rfield_ANT_FCSI_IQADCREG0_SWBULK.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_SWBULK.instName    = "SWBULK";
rfield_ANT_FCSI_IQADCREG0_SWBULK.aliasName   = "SWBULK";
rfield_ANT_FCSI_IQADCREG0_SWBULK.longName    = "sw_bulk";
rfield_ANT_FCSI_IQADCREG0_SWBULK.description = "<p>IQ-ADC Enable sw bulk for opamp 2 &amp; 3</p>";
rfield_ANT_FCSI_IQADCREG0_SWBULK.file = "";
rfield_ANT_FCSI_IQADCREG0_SWBULK.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_SWBULK.references = [
];
rfield_ANT_FCSI_IQADCREG0_SWBULK.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_SWBULK.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_SWBULK.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_SWBULK.parent = "register_ANT_FCSI_IQADCREG0";
rfield_ANT_FCSI_IQADCREG0_SWBULK.resetVal = "1'b1";
rfield_ANT_FCSI_IQADCREG0_SWBULK.addrStart = "32'b00000000000000000000000000001010";
rfield_ANT_FCSI_IQADCREG0_SWBULK.addrEnd = "32'b00000000000000000000000000001010";
rfield_ANT_FCSI_IQADCREG0_SWBULK.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG0_SWBULK.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG0_SWBULK.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG0_SWBULK.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0 = [
        [ "NOSWBULK", "1'b0", "bulk = source; used for 20MHz and 10MHz mode" ], 
        [ "SWBULK", "1'b1", "bulk voltage &gt; source voltage (default)" ]];
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG0_SWBULK";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG0_SWBULK.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.jsName      = "rfield_ANT_FCSI_IQADCREG0_ENLOWPOW";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.type        = "rfield";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.instName    = "ENLOWPOW";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.aliasName   = "ENLOWPOW";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.longName    = "en_low_pow";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.description = "<p>IQ-ADC Enable low power mode</p>";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.file = "";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.references = [
];
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.parent = "register_ANT_FCSI_IQADCREG0";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.addrStart = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.addrEnd = "32'b00000000000000000000000000001000";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0 = [
        [ "DEFAULT", "1'b0", "standard mode (default)" ], 
        [ "ENLOWPOW", "1'b1", "low power mode enabled (op2 and op3 off)" ]];
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG0_ENLOWPOW";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG0_ENLOWPOW.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG0_PROGLFRES = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.jsName      = "rfield_ANT_FCSI_IQADCREG0_PROGLFRES";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.type        = "rfield";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.instName    = "PROGLFRES";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.aliasName   = "PROGLFRES";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.longName    = "prog_lfres";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.description = "<p>IQ-ADC Program loopfilter reset pulse duration</p>";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.file = "";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.references = [
];
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.parent = "register_ANT_FCSI_IQADCREG0";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.resetVal = "2'b11";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.addrStart = "32'b00000000000000000000000000000101";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.addrEnd = "32'b00000000000000000000000000000110";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.dataWidth = "32'b00000000000000000000000000000010";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0 = [
        [ "DEL15", "2'b00", "1.5 Tclk @160MHz ~ 9.3ns" ], 
        [ "DEL25", "2'b01", "2.5 Tclk @160MHz ~ 15.6ns" ], 
        [ "DEL35", "2'b10", "3.5 Tclk @160MHz ~ 21.9ns" ], 
        [ "DEFAULT", "2'b11", "4.5 Tclk @160MHz ~ 28ns (default)" ]];
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG0_PROGLFRES";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG0_PROGLFRES.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG0_EN20M = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_EN20M.jsName      = "rfield_ANT_FCSI_IQADCREG0_EN20M";
rfield_ANT_FCSI_IQADCREG0_EN20M.type        = "rfield";
rfield_ANT_FCSI_IQADCREG0_EN20M.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_EN20M.instName    = "EN20M";
rfield_ANT_FCSI_IQADCREG0_EN20M.aliasName   = "EN20M";
rfield_ANT_FCSI_IQADCREG0_EN20M.longName    = "en_20MHz";
rfield_ANT_FCSI_IQADCREG0_EN20M.description = "<p>IQ-ADC enable 20MHz mode</p>";
rfield_ANT_FCSI_IQADCREG0_EN20M.file = "";
rfield_ANT_FCSI_IQADCREG0_EN20M.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_EN20M.references = [
];
rfield_ANT_FCSI_IQADCREG0_EN20M.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_EN20M.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_EN20M.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_EN20M.parent = "register_ANT_FCSI_IQADCREG0";
rfield_ANT_FCSI_IQADCREG0_EN20M.resetVal = "1'b0";
rfield_ANT_FCSI_IQADCREG0_EN20M.addrStart = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG0_EN20M.addrEnd = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG0_EN20M.dataWidth = "32'b00000000000000000000000000000001";
rfield_ANT_FCSI_IQADCREG0_EN20M.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG0_EN20M.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG0_EN20M.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0 = [
        [ "DEFAULT", "1'b0", "40MHz mode (default)" ], 
        [ "EN20MHZ", "1'b1", "20MHz mode (op2 off)" ]];
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG0_EN20M";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG0_EN20M.attributes.enumeration_0;
/////////////////////////////////
// Field //////////////////////////
rfield_ANT_FCSI_IQADCREG0_CTUNE = new Array ();
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_CTUNE.jsName      = "rfield_ANT_FCSI_IQADCREG0_CTUNE";
rfield_ANT_FCSI_IQADCREG0_CTUNE.type        = "rfield";
rfield_ANT_FCSI_IQADCREG0_CTUNE.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_CTUNE.instName    = "CTUNE";
rfield_ANT_FCSI_IQADCREG0_CTUNE.aliasName   = "CTUNE";
rfield_ANT_FCSI_IQADCREG0_CTUNE.longName    = "c_tune";
rfield_ANT_FCSI_IQADCREG0_CTUNE.description = "<p>IQ-ADC corner frequency tuning</p>";
rfield_ANT_FCSI_IQADCREG0_CTUNE.file = "";
rfield_ANT_FCSI_IQADCREG0_CTUNE.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_CTUNE.references = [
];
rfield_ANT_FCSI_IQADCREG0_CTUNE.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_CTUNE.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_CTUNE.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_CTUNE.parent = "register_ANT_FCSI_IQADCREG0";
rfield_ANT_FCSI_IQADCREG0_CTUNE.resetVal = "4'b0111";
rfield_ANT_FCSI_IQADCREG0_CTUNE.addrStart = "32'b00000000000000000000000000000000";
rfield_ANT_FCSI_IQADCREG0_CTUNE.addrEnd = "32'b00000000000000000000000000000011";
rfield_ANT_FCSI_IQADCREG0_CTUNE.dataWidth = "32'b00000000000000000000000000000100";
rfield_ANT_FCSI_IQADCREG0_CTUNE.hasMutationsByAttributes = "false";
rfield_ANT_FCSI_IQADCREG0_CTUNE.accessProperties = new Array ();
rfield_ANT_FCSI_IQADCREG0_CTUNE.accessProperties ["port_ANT_FCSI"] = "rw,DEFAULT,DEFAULT,DEFAULT,Readable and writable field.";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes = new Array ();
// AttributeContainer ////////////////////
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration = new Array ();
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0 = [
        [ "MIN", "4'b0000", "min cap" ], 
        [ "DEFAULT", "4'b0111", "default" ], 
        [ "MAX", "4'b1111", "max cap" ]];
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.parent = "rfield_ANT_FCSI_IQADCREG0_CTUNE";
// BasicInfo //////////////////////////
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.jsName      = "rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.type        = "attribute";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.baseName    = "BASIC";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.instName    = "";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.aliasName   = "";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.longName    = "";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.description = "";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.file = "";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.contacts    = "user_presicce";
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.references = [
];
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.links = new Array ();
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.pictures = new Array ();
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0.debugMessages = [
];
rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration [0] = rfield_ANT_FCSI_IQADCREG0_CTUNE.attributes.enumeration_0;
/////////////////////////////////
// Bus //////////////////////////
bus_ANT_FCSI = new Array ();
bus_ANT_FCSI.parent = "module_ANT";
bus_ANT_FCSI.busProtocol = "FCSI";
bus_ANT_FCSI.defaultSlave = "";
bus_ANT_FCSI.hasMutationsByAttributes = "false";
// AddressableNode //////////////////////
// BasicInfo //////////////////////////
bus_ANT_FCSI.jsName      = "bus_ANT_FCSI";
bus_ANT_FCSI.type        = "bus";
bus_ANT_FCSI.baseName    = "BASIC";
bus_ANT_FCSI.instName    = "FCSI";
bus_ANT_FCSI.aliasName   = "FCSI";
bus_ANT_FCSI.longName    = "Full custom serial interface";
bus_ANT_FCSI.description = "";
bus_ANT_FCSI.file = "";
bus_ANT_FCSI.contacts    = "user_hebeinth";
bus_ANT_FCSI.references = [
];
bus_ANT_FCSI.links = new Array ();
bus_ANT_FCSI.pictures = new Array ();
bus_ANT_FCSI.debugMessages = [
];
bus_ANT_FCSI.views  = [
        "port_ANT_FCSI"
];
bus_ANT_FCSI.addrBase   = "32'b00000000000000000000000000010000";
bus_ANT_FCSI.addrStart  = new Array ();
bus_ANT_FCSI.addrEnd    = new Array ();
bus_ANT_FCSI.addrSpace  = new Array ();
bus_ANT_FCSI.dataWidth  = new Array ();
bus_ANT_FCSI.addrStart ["port_ANT_FCSI"] = "32'b00000000000000000000000000000000";
bus_ANT_FCSI.addrEnd ["port_ANT_FCSI"] = "32'b00000000000000000000000001111111";
bus_ANT_FCSI.addrSpace ["port_ANT_FCSI"] = "32'b00000000000000000000000010000000";
bus_ANT_FCSI.dataWidth ["port_ANT_FCSI"] = "32'b00000000000000000000000000010000";
bus_ANT_FCSI.addrStart ["bus_ANT_FCSI"] = "32'b00000000000000000000000000000000";
bus_ANT_FCSI.addrEnd ["bus_ANT_FCSI"] = "32'b00000000000000000000000001111111";
bus_ANT_FCSI.addrSpace ["bus_ANT_FCSI"] = "32'b00000000000000000000000010000000";
bus_ANT_FCSI.dataWidth ["bus_ANT_FCSI"] = "32'b00000000000000000000000000010000";
bus_ANT_FCSI.offsetAsView     = "32'b00000000000000000000000000000000"
bus_ANT_FCSI.allowAddrOverlap = true;
bus_ANT_FCSI.isCollapsedIntoPort = true;
bus_ANT_FCSI.isLossless = true;
bus_ANT_FCSI.access       = new Array ();
bus_ANT_FCSI.access ["port_ANT_FCSI"] = "RW";
bus_ANT_FCSI.access ["bus_ANT_FCSI"] = "RW";
bus_ANT_FCSI.hierarchies       = new Array ();
bus_ANT_FCSI.hierarchies ["port_ANT_FCSI"] = [
        "port_ANT_FCSI",
        "bus_ANT_FCSI"
];
bus_ANT_FCSI.masterPorts = [
        "port_ANT_FCSI"
];
bus_ANT_FCSI.slavePorts = [
        "port_ANT_SDADC40M_FCSI",
        "port_ANT_CLOCKBIASLDOANAMUX_FCSI",
        "port_ANT_DAC40M_FCSI",
        "port_ANT_SSI_FCSI"
];
bus_ANT_FCSI.attributes = new Array ();
// AttributeContainer ////////////////////
/////////////////////////////////
