function SearchStatus () {
  this.searching = false;
  this.savedBody = "";
  this.searchRegExp = "";
  this.searchLength = 0;
  this.enabledModules = true;
  this.enabledPorts = true;
  this.enabledBuses = true;
  this.enabledRegisters = true;
  this.enabledFields = true;
  this.foundModules = [];
  this.foundPorts = [];
  this.foundBuses = [];
  this.foundRegisters = [];
  this.foundFields = [];
  this.clear = function () {
    this.searchLength = 0;
    this.searchLength = 0;
    this.foundModules = [];
    this.foundPorts = [];
    this.foundBuses = [];
    this.foundRegisters = [];
    this.foundFields = [];
  };
}

globalSearchStatus = new SearchStatus ();

function search (inputReference) {
  var body = document.getElementById ("pageBody");
  if (globalSearchStatus.searching === false && inputReference.value.length > 0) {
    this.savedBody = body.innerHTML;

    globalSearchStatus.searchRegExp = new RegExp (inputReference.value, "i");
    globalSearchStatus.searchLength = inputReference.value.length;
    globalSearchStatus.searching = true;
    searchDataBase (globalSearchStatus);

    body.innerHTML = "";
    showResults (inputReference, body, globalSearchStatus);
  } else if (inputReference.value.length > 0) {
    globalSearchStatus.searchRegExp = new RegExp (inputReference.value, "i");
    if (globalSearchStatus.searchLength > inputReference.value.length) {
      searchDataBase (globalSearchStatus);
    } else {
      restrict (globalSearchStatus);
    }
    globalSearchStatus.searchLength = inputReference.value.length;

    body.innerHTML = "";
    showResults (inputReference, body, globalSearchStatus);
  } else {
    globalSearchStatus.searchLength = 0;
    body.innerHTML = this.savedBody;
    globalSearchStatus.searching = false;
  }
}

function showResults (inputReference, sectionReference, searchStatus) {
  var body = sectionReference;

  showSettings (inputReference, sectionReference, searchStatus);

  showModuleResults (sectionReference, searchStatus);
  showPortResults (sectionReference, searchStatus);
  showBusResults (sectionReference, searchStatus);
  showRegisterResults (sectionReference, searchStatus);
  showFieldResults (sectionReference, searchStatus);
}

function showSettings (inputReference, sectionReference, searchStatus) {
  var body = sectionReference;
  var table = document.createElement ("table");
  table.className = "hier_elem";
  body.appendChild (table);
  var row;
  var cell;

  row = document.createElement ("tr");
  table.appendChild (row);
  cell = document.createElement ("td");
  cell.className = "hide";
  cell.colSpan = 1;
  cell.innerHTML = "SEARCH SETTINGS:";
  row.appendChild (cell);

  // row = document.createElement("tr");
  // table.appendChild (row);
  var cbox0;

  cell = document.createElement ("td");
  cell.className = "hide";
  row.appendChild (cell);
  cbox0 = document.createElement ("input");
  cbox0.type = "checkbox";
  cbox0.defaultChecked = searchStatus.enabledModules;
  cbox0.setAttribute ("onclick", "hookSwitchEnable (\"" + inputReference.id
      + "\", this, \"module\", \"null\")");
  cell.appendChild (cbox0);
  cell.innerHTML += "Modules";

  cell = document.createElement ("td");
  cell.className = "hide";
  row.appendChild (cell);
  cbox0 = document.createElement ("input");
  cbox0.type = "checkbox";
  cbox0.defaultChecked = searchStatus.enabledPorts;
  cbox0.setAttribute ("onclick", "hookSwitchEnable (\"" + inputReference.id
      + "\", this, \"port\", \"null\")");
  cell.appendChild (cbox0);
  cell.innerHTML += "Ports";

  cell = document.createElement ("td");
  cell.className = "hide";
  row.appendChild (cell);
  cbox0 = document.createElement ("input");
  cbox0.type = "checkbox";
  cbox0.defaultChecked = searchStatus.enabledBuses;
  cbox0.setAttribute ("onclick", "hookSwitchEnable (\"" + inputReference.id
      + "\", this, \"bus\", \"null\")");
  cell.appendChild (cbox0);
  cell.innerHTML += "Buses";

  cell = document.createElement ("td");
  cell.className = "hide";
  row.appendChild (cell);
  cbox0 = document.createElement ("input");
  cbox0.type = "checkbox";
  cbox0.defaultChecked = searchStatus.enabledRegisters;
  cbox0.setAttribute ("onclick", "hookSwitchEnable (\"" + inputReference.id
      + "\", this, \"register\", \"null\")");
  cell.appendChild (cbox0);
  cell.innerHTML += "Registers";

  cell = document.createElement ("td");
  cell.className = "hide";
  row.appendChild (cell);
  cbox0 = document.createElement ("input");
  cbox0.type = "checkbox";
  cbox0.defaultChecked = searchStatus.enabledFields;
  cbox0.setAttribute ("onclick", "hookSwitchEnable (\"" + inputReference.id
      + "\", this, \"field\", \"null\")");
  cell.appendChild (cbox0);
  cell.innerHTML += "Fields";
}

function hookSwitchEnable (inputName, checkboxReference, type, searchStatusName) {
  var inputReference = document.getElementById (inputName);
  switchEnable (inputReference, checkboxReference, type, globalSearchStatus);
}

function switchEnable (inputReference, checkboxReference, type, searchStatus) {
  console.log ("type=" + type);
  if (type == "module") {
    searchStatus.enabledModules = checkboxReference.checked;
  } else if (type == "port") {
    searchStatus.enabledPorts = checkboxReference.checked;
  } else if (type == "bus") {
    searchStatus.enabledBuses = checkboxReference.checked;
  } else if (type == "register") {
    searchStatus.enabledRegisters = checkboxReference.checked;
  } else if (type == "field") {
    searchStatus.enabledFields = checkboxReference.checked;
  }

  search (inputReference);
}

function showModuleResults (sectionReference, searchStatus) {
  var body = sectionReference;
  // HEAD
  // <table class="header"><tr><td><h1
  // id="descriptionHead">Description</h1></td><td><h2><a
  // href="#TOP">&uarr;</a></h2> </td></tr></table>
  var headerTable = document.createElement ("table");
  headerTable.className = "header";
  var row = document.createElement ("tr");
  headerTable.appendChild (row);
  var cell = document.createElement ("td");
  row.appendChild (cell);
  var header = document.createElement ("h1");
  cell.appendChild (header);
  header.innerHTML = "Module Search Results:";
  body.appendChild (headerTable);

  if (searchStatus.foundModules.length === 0
      || searchStatus.enabledModules === false) {
    return;
  }

  // BODY
  var tableMaster = document.createElement ("table");
  tableMaster.id = "moduleResultBody0";
  searchStatus.foundModules.jsName = "foundModules";
  window [searchStatus.foundModules.jsName] = searchStatus.foundModules;
  body.appendChild (tableMaster);
  createModulesTable1Init (searchStatus.foundModules, "moduleResult",
      searchStatus.searchRegExp);
}

function showPortResults (sectionReference, searchStatus) {
  var body = sectionReference;
  // HEAD
  // <table class="header"><tr><td><h1
  // id="descriptionHead">Description</h1></td><td><h2><a
  // href="#TOP">&uarr;</a></h2> </td></tr></table>
  var headerTable = document.createElement ("table");
  headerTable.className = "header";
  var row = document.createElement ("tr");
  headerTable.appendChild (row);
  var cell = document.createElement ("td");
  row.appendChild (cell);
  var header = document.createElement ("h1");
  cell.appendChild (header);
  header.innerHTML = "Port Search Results:";
  body.appendChild (headerTable);

  if (searchStatus.foundPorts.length === 0
      || searchStatus.enabledPorts === false) {
    return;
  }
  // BODY
  var tableMaster = document.createElement ("table");
  tableMaster.id = "portResultBody0";
  searchStatus.foundPorts.jsName = "foundPorts";
  window [searchStatus.foundPorts.jsName] = searchStatus.foundPorts;
  body.appendChild (tableMaster);
  createPortsTable1Init (searchStatus.foundPorts, "portResult",
      searchStatus.searchRegExp);
}

function showBusResults (sectionReference, searchStatus) {
  var body = sectionReference;
  // HEAD
  // <table class="header"><tr><td><h1
  // id="descriptionHead">Description</h1></td><td><h2><a
  // href="#TOP">&uarr;</a></h2> </td></tr></table>
  var headerTable = document.createElement ("table");
  headerTable.className = "header";
  var row = document.createElement ("tr");
  headerTable.appendChild (row);
  var cell = document.createElement ("td");
  row.appendChild (cell);
  var header = document.createElement ("h1");
  cell.appendChild (header);
  header.innerHTML = "Bus Search Results:";
  body.appendChild (headerTable);

  if (searchStatus.foundBuses.length === 0
      || searchStatus.enabledBuses === false) {
    return;
  }

  // BODY
  var tableMaster = document.createElement ("table");
  tableMaster.id = "busResultBody0";
  searchStatus.foundBuses.jsName = "foundBuses";
  window [searchStatus.foundBuses.jsName] = searchStatus.foundBuses;
  body.appendChild (tableMaster);
  createBusesTable1Init (searchStatus.foundBuses, "busResult",
      searchStatus.searchRegExp);
}

function showRegisterResults (sectionReference, searchStatus) {
  var body = sectionReference;
  // HEAD
  // <table class="header"><tr><td><h1
  // id="descriptionHead">Description</h1></td><td><h2><a
  // href="#TOP">&uarr;</a></h2> </td></tr></table>
  var headerTable = document.createElement ("table");
  headerTable.className = "header";
  var row = document.createElement ("tr");
  headerTable.appendChild (row);
  var cell = document.createElement ("td");
  row.appendChild (cell);
  var header = document.createElement ("h1");
  cell.appendChild (header);
  header.innerHTML = "Register Search Results:";
  body.appendChild (headerTable);

  if (searchStatus.foundRegisters.length === 0
      || searchStatus.enabledRegisters === false) {
    return;
  }
  // BODY
  var tableMaster = document.createElement ("table");
  tableMaster.id = "registerResultBody0";
  searchStatus.foundRegisters.jsName = "foundRegisters";
  window [searchStatus.foundRegisters.jsName] = searchStatus.foundRegisters;
  body.appendChild (tableMaster);
  createRegistersTable1Init (searchStatus.foundRegisters, "registerResult",
      searchStatus.searchRegExp);
}

function showFieldResults (sectionReference, searchStatus) {
  var body = sectionReference;
  var registers = filterUniqueRegisters (searchStatus.foundFields);

  // HEAD
  // <table class="header"><tr><td><h1
  // id="descriptionHead">Description</h1></td><td><h2><a
  // href="#TOP">&uarr;</a></h2> </td></tr></table>
  var headerTable = document.createElement ("table");
  headerTable.className = "header";
  var row = document.createElement ("tr");
  headerTable.appendChild (row);
  var cell = document.createElement ("td");
  row.appendChild (cell);
  var header = document.createElement ("h1");
  cell.appendChild (header);
  header.innerHTML = "Field Search Results:";
  body.appendChild (headerTable);

  if (searchStatus.foundFields.length === 0
      || searchStatus.enabledFields === false) {
    return;
  }
  // BODY
  var tableMaster = document.createElement ("table");
  body.appendChild (tableMaster);

  for (var idx = 0; idx < registers.length; idx++) {
    var register = window [registers [idx]];
    var tableSlave;
    var M = document.createElement ("sup");
    var P = document.createElement ("sup");
    var R = document.createElement ("sup");
    M.innerHTML = "M";
    P.innerHTML = "P";
    R.innerHTML = "R";
    var home = "register.html?" + registers [idx] + "?" + register.views [0];
    // var color = "gainsboro";
    // var color = "lavender";
    var color = "lightgreen";
    // 1ND
    row = document.createElement ("tr");
    if (idx % 2 === 0) {
      row.style.backgroundColor = color;
    }

    // Module Name
    cell = document.createElement ("td");
    cell.title = getAliasContextName (
        window [window [window [registers [idx]].parent].parent], true);
    cell.appendChild (document.createTextNode (window [window [window [registers [idx]].parent].parent].aliasName));
    cell.appendChild (M);
    row.appendChild (cell);

    // Fields Scheme Table
    cell = document.createElement ("td");
    cell.rowSpan = "3";
    tableSlave = document.createElement ("table");
    tableSlave.className = "scheme";
    createRegisterScheme (tableSlave, register, register.views [0],
        searchStatus.searchRegExp, home);
    cell.appendChild (tableSlave);
    row.appendChild (cell);

    // Append row
    tableMaster.appendChild (row);

    // 2ND
    row = document.createElement ("tr");
    if (idx % 2 === 0) {
      row.style.backgroundColor = color;
    }
    // Port Name
    cell = document.createElement ("td");
    cell.appendChild (document.createTextNode (window [window [registers [idx]].parent].aliasName));
    cell.appendChild (P);
    row.appendChild (cell);
    // Append row
    tableMaster.appendChild (row);

    // 3RD
    row = document.createElement ("tr");
    if (idx % 2 === 0) {
      row.style.backgroundColor = color;
    }
    // Register Name
    cell = document.createElement ("td");
    cell.className = "emph";
    cell.appendChild (document.createTextNode (window [registers [idx]].aliasName));
    cell.appendChild (R);
    row.appendChild (cell);
    // Append row
    tableMaster.appendChild (row);
  }
}

function searchDataBase (searchStatus) {
  searchStatus.clear ();
  for (var idx = 0; idx < system.allViews.length; idx++) {
    searchDataBase4Port (searchStatus, system.allViews [idx]);
  }
  searchDataBase4Module (searchStatus, system.jsName);
}

function searchDataBase4Module (searchStatus, moduleName) {
  if (moduleName.length === 0)
    return;
  var module = window [moduleName];
  if (searchStatus.enabledModules) {
    var found = getAliasContextName (module, false).match (
        searchStatus.searchRegExp);
    if (found !== null && searchStatus.foundModules.indexOf (moduleName) === -1) {
      searchStatus.foundModules.push (moduleName);
    }
  }
  for (var idx = 0; idx < module.modules.length; idx++) {
    searchDataBase4Module (searchStatus, module.modules [idx]);
  }
}

function searchDataBase4Port (searchStatus, portName) {
  if (portName.length === 0)
    return;
  var port = window [portName];
  if (searchStatus.enabledPorts) {
    var found = getAliasContextName (port, false).match (
        searchStatus.searchRegExp);
    if (found !== null && searchStatus.foundPorts.indexOf (portName) === -1) {
      searchStatus.foundPorts.push (portName);
    }
  }
  searchDataBase4Bus (searchStatus, port.slaveBus);
  for (var idx = 0; idx < port.registers.length; idx++) {
    searchDataBase4Register (searchStatus, port.registers [idx]);
  }
}

function searchDataBase4Bus (searchStatus, busName) {
  if (busName.length === 0)
    return;
  var bus = window [busName];
  if (searchStatus.enabledBuses) {
    var found = getAliasContextName (bus, false).match (
        searchStatus.searchRegExp);
    if (found !== null && searchStatus.foundBuses.indexOf (busName) === -1) {
      searchStatus.foundBuses.push (busName);
    }
  }
  for (var idx = 0; idx < bus.slavePorts.length; idx++) {
    searchDataBase4Port (searchStatus, bus.slavePorts [idx]);
  }
}

function searchDataBase4Register (searchStatus, registerName) {
  if (registerName.length === 0)
    return;
  var register = window [registerName];
  if (searchStatus.enabledRegisters && register.reserved === false) {
    var found = register.aliasName.match (searchStatus.searchRegExp);
    if (found !== null
        && searchStatus.foundRegisters.indexOf (registerName) === -1) {
      searchStatus.foundRegisters.push (registerName);
    }
  }
  for (var idx = 0; idx < register.fields.length; idx++) {
    searchDataBase4Field (searchStatus, register.fields [idx]);
  }
}

function searchDataBase4Field (searchStatus, fieldName) {
  if (fieldName.length === 0)
    return;
  var field = window [fieldName];
  if (searchStatus.enabledFields) {
    var found = field.aliasName.match (searchStatus.searchRegExp);
    if (found !== null && searchStatus.foundFields.indexOf (fieldName) === -1) {
      searchStatus.foundFields.push (fieldName);
    }
  }
}

function restrict (searchStatus) {
  restrictModuleList (searchStatus);
  restrictPortList (searchStatus);
  restrictBusList (searchStatus);
  restrictRegisterList (searchStatus);
  restrictFieldList (searchStatus);
}

function restrictModuleList (searchStatus) {
  var array = searchStatus.foundModules;
  for (var idx = 0; idx < array.length; idx++) {
    var module = window [array [idx]];
    var found = getAliasContextName (module, false).match (
        searchStatus.searchRegExp);
    if (found === null) {
      array.splice (idx, 1);
      idx--;
    }
  }
}
function restrictPortList (searchStatus) {
  var array = searchStatus.foundPorts;
  for (var idx = 0; idx < array.length; idx++) {
    var port = window [array [idx]];
    var found = getAliasContextName (port, false).match (
        searchStatus.searchRegExp);
    if (found === null) {
      array.splice (idx, 1);
      idx--;
    }
  }
}
function restrictBusList (searchStatus) {
  var array = searchStatus.foundBuses;
  for (var idx = 0; idx < array.length; idx++) {
    var bus = window [array [idx]];
    var found = getAliasContextName (bus, false).match (
        searchStatus.searchRegExp);
    if (found === null) {
      array.splice (idx, 1);
      idx--;
    }
  }
}
function restrictRegisterList (searchStatus) {
  var array = searchStatus.foundRegisters;
  for (var idx = 0; idx < array.length; idx++) {
    var register = window [array [idx]];
    var found = register.aliasName.match (searchStatus.searchRegExp);
    if (found === null) {
      array.splice (idx, 1);
      idx--;
    }
  }
}
function restrictFieldList (searchStatus) {
  var array = searchStatus.foundFields;
  for (var idx = 0; idx < array.length; idx++) {
    var field = window [array [idx]];
    var found = field.aliasName.match (searchStatus.searchRegExp);
    if (found === null) {
      array.splice (idx, 1);
      idx--;
    }
  }
}

function filterUniqueRegisters (fieldsArray) {
  var registerArray = new Array ();
  for (var idx = 0; idx < fieldsArray.length; idx++) {
    var field = window [fieldsArray [idx]];
    if (registerArray.indexOf (field.parent) === -1) {
      registerArray.push (field.parent);
    }
  }
  return (registerArray);
}

function highlightSearch (text, searchRegExp) {
  var regExp = new RegExp (searchRegExp.source, "ig");
  var match = text.match (regExp);
  if (match !== null) {
    var result = document.createElement ("span");
    for (var idx = 0; idx < match.length; idx++) {
      var posStart = text.indexOf (match [idx]);
      var span = document.createElement ("span");
      span.style.backgroundColor = "yellow";
      span.innerHTML = match [idx];
      var prefix = text.slice (0, posStart);
      text = text.slice (posStart + match [idx].length);
      result.appendChild (document.createTextNode (prefix));
      result.appendChild (span);
    }
    result.appendChild (document.createTextNode (text));
    return (result.innerHTML);
  } else {
    return (text);
  }
}
