include ("tables_attributes.js", "tables_dbgmessages.js",
    "tables_filterNsort.js", "tables_register.js", "tables_ports.js",
    "tables_buses.js", "tables_modules.js");

function TableStatus (columns) {
  var i;
  this.id = "";
  // Sort
  this.currentSortPos = 0;
  this.currentSortDir = "up";
  this.sortTypes = new Array ();
  this.sortEnabled = new Array ();
  this.sortClassNames = new Array ();
  // Filter
  this.currentFilterPos = 0;
  this.filterRowId = "";  // id of connected row
  this.filterRow = null; // copy of connected row
  this.filterInputCopy = null;
  this.filterSet = new Array ();
  this.filterTypes = new Array ();
  this.filterEnabled = new Array ();
  this.filterClassNames = new Array ();
  // Combine cells
  this.combineCell = new Array ();
  // Hook function
  this.hookFunctionName = null;
  // INIT
  for (i = 0; i < columns; i++) {
    // Sort
    this.sortTypes.push ("string");
    this.sortEnabled.push (true);
    this.sortClassNames.push ("");
    // Filter
    this.filterSet.push (".*");
    this.filterTypes.push ("string");
    this.filterEnabled.push (true);
    this.filterClassNames.push (".");
    // Combine cells
    this.combineCell.push (false);
  }
  // Table array
  this.tableArray = new Array ();
  // Debug method
  this.print = function () {
    console.log ("TableStatus for '" + this.id + "'");
    console.log ("  currentSortPos = " + this.currentSortPos);
    console.log ("  currentSortDir = " + this.currentSortDir);
    console.log ("  sortTypes = " + this.sortTypes);
    console.log ("  sortEnabled = " + this.sortEnabled);
    console.log ("  sortClassNames = " + this.sortlassNames);
    console.log ("  currentFilterPos = " + this.currentFilterPos);
    console.log ("  filterSet = " + this.filterSet);
    console.log ("  filterTypes = " + this.filterTypes);
    console.log ("  filterEnabled = " + this.filterEnabled);
    console.log ("  filterClassNames = " + this.filterClassNames);
  };
}

// ###############################################
// #####-------------------------------------#####
// #####------------ VIEW TABLE -------------#####
// #####-------------------------------------#####
// ###############################################

/**
 * This is how it should look like:
 * 
 * <table id="views_elem"> <caption>*System Port **View Port</caption>
 * <tr>
 * <th>Host Module</th>
 * <th>Port (View)</th>
 * <th>SP*</th>
 * <th>Description</th>
 * </tr>
 * <tr class="cview">
 * <td title="codxs2_CODXS2C_ARCSS_ARCC">ARCC</td>
 * <td class="emph">CODE</td>
 * <td class="sel">X</td>
 * <td></td>
 * </tr>
 * <tr>
 * <td title="codxs2_CODXS2C_ARCSS_ARCC">ARCC</td>
 * <td class="emph"><a
 * href="../codxs2_CODXS2C_ARCSS_ARCC_DATARAM/codxs2_CODXS2C_ARCSS_CODERAM_port.html">DATARAM</a></td>
 * <td class="sel"> </td>
 * <td></td>
 * </tr>
 * </table>
 */
function createViewsTable (spectool2Element, viewName) {
  // Description
  var head = document.getElementById ("viewsHead");
  var body = document.getElementById ("viewsBody0");

  // Make description table switchable
  head.innerHTML += createToggleImage ("views");

  // Table Caption
  var caption = document.createElement ("caption");
  var one = document.createElement ("sup");
  var two = document.createElement ("sup");
  one.innerHTML = "1";
  caption.appendChild (one);
  caption.appendChild (document.createTextNode ("System Port "));
  body.appendChild (caption);
  // Table Headers
  var container0 = document.createElement ("span");
  container0.appendChild (document.createTextNode ("SP"));
  container0.appendChild (one);
  var headerCells = [ "Module", "View Port", container0.innerHTML,
      "Description" ];
  var row = document.createElement ("tr");
  for (idx in headerCells) {
    var cell = document.createElement ("th");
    cell.innerHTML = headerCells [idx];
    row.appendChild (cell);
  }
  body.appendChild (row);

  // Table Body
  for (idx in spectool2Element.views) {
    row = document.createElement ("tr");

    if (spectool2Element.views [idx] == viewName) {
      row.className = "cview";
    } else if (idx % 2 === 0) {
      row.className = "interleave";
    }
    var view = window [spectool2Element.views [idx]];
    var parent = window [view.parent];
    // Module
    cell = document.createElement ("td");
    cell.innerHTML = parent.aliasName;
    row.appendChild (cell);
    // View Port
    var link = document.createElement ("a");
    link.href = "port.html?" + spectool2Element.jsName + "?"
        + spectool2Element.views [idx];
    link.innerHTML = view.aliasName;
    cell = document.createElement ("td");
    cell.appendChild (link);
    cell.className = "emph";
    row.appendChild (cell);
    // Is System Port
    cell = document.createElement ("td");
    cell.className = "sel";
    if (view.isSystemPort == "true") {
      cell.innerHTML = "X";
    }
    row.appendChild (cell);
    // Description
    cell = document.createElement ("td");
    cell.innerHTML = view.description;
    row.appendChild (cell);
    body.appendChild (row);
  }
}

// ###############################################
// #####-------------------------------------#####
// #####--------- HIERARCHY TABLE -----------#####
// #####-------------------------------------#####
// ###############################################

/**
 * This is how it should look like:
 * 
 * <table class="hier_elem" id="hier_elem"> <caption><sup>M</sup>Module <sup>P</sup>Port
 * <sup>B</sup>Bus <sup>R</sup>Register</caption>
 * <tr class="top">
 * <td class="viewmod" colspan="1"><a
 * href="../codxs2_CODXS2C_ARCSS_ARCC_module.html">ARCC</a><sup>M</sup></td>
 * <td class="hide"></td>
 * <td class="mod" colspan="7">ARCSS<sup>M</sup></td>
 * <td class="hide"></td>
 * </tr>
 * <tr class="middle">
 * <td class="viewport"><a href="codxs2_CODXS2C_ARCSS_ARCC_CODE_port.html">CODE</a><sup>P</sup></td>
 * <td class="arrow">&rarr;</td>
 * <td class="bus"><a href="codxs2_CODXS2C_ARCSS_CODE_bus.html">CODE</a><sup>B</sup></td>
 * <td class="arrow">&rarr;</td>
 * <td class="port"><a href="codxs2_CODXS2C_ARCSS_CODERAMX_port.html">CODERAMX</a><sup>P</sup></td>
 * <td class="arrow">&rarr;</td>
 * <td class="bus"><a href="codxs2_CODXS2C_ARCSS_CODEXDATA_bus.html">CODEXDATA</a><sup>B</sup></td>
 * <td class="arrow">&rarr;</td>
 * <td class="port"><a href="codxs2_CODXS2C_ARCSS_CODERAM_port.html">CODERAM</a><sup>P</sup></td>
 * </tr>
 * <tr class="bottom">
 * <td class="hide">00000000<sub>H</sub>*</td>
 * <td class="hide"></td>
 * <td class="hide">00000000<sub>H</sub>*</td>
 * <td class="hide"></td>
 * <td class="hide">00040000<sub>H</sub>*</td>
 * <td class="hide"></td>
 * <td class="hide">00040000<sub>H</sub>*</td>
 * <td class="hide"></td>
 * <td class="hide">00040000<sub>H</sub>*</td>
 * </tr>
 * </table>
 */
function createHierarchy (spectool2Element, viewName) {
  // Description
  var head = document.getElementById ("hierarchyHead");
  var body = document.getElementById ("hierarchyBody0");

  // Make description table switchable
  head.innerHTML += createToggleImage ("hierarchy");

  // Table Caption
  // <caption><sup>M</sup>Module <sup>P</sup>Port <sup>B</sup>Bus
  // <sup>R</sup>Register</caption>
  var caption = document.createElement ("caption");
  var M = document.createElement ("sup");
  var P = document.createElement ("sup");
  var B = document.createElement ("sup");
  var R = document.createElement ("sup");
  M.innerHTML = "M";
  P.innerHTML = "P";
  B.innerHTML = "B";
  R.innerHTML = "R";
  caption.appendChild (M);
  caption.appendChild (document.createTextNode ("Module "));
  caption.appendChild (P);
  caption.appendChild (document.createTextNode ("Port "));
  caption.appendChild (B);
  caption.appendChild (document.createTextNode ("Bus "));
  caption.appendChild (R);
  caption.appendChild (document.createTextNode ("Register"));
  body.appendChild (caption);

  var row;
  var cell;
  var link;
  var sameNo;
  var ignore;
  var module;

  // copy the hierarchy array
  var hierarchyArray = spectool2Element.hierarchies [viewName].slice ();
  var firstElement = hierarchyArray [0];
  var lastElement; // only needed for register types
  // remove the first element from the array
  hierarchyArray.shift ();
  // if array is of type register remove the last part from the hierarchy
  if (spectool2Element.type == "register") {
    // store the last element
    lastElement = hierarchyArray [hierarchyArray.length - 1];
    // remove the first element from the array
    hierarchyArray.pop ();
  }

  // Print first row (modules)
  row = document.createElement ("tr");
  row.className = "top";

  sameNo = calcConstParentModelOverHierarchy (
      spectool2Element.hierarchies [viewName].slice (), spectool2Element.type);
  cell = document.createElement ("td");
  cell.className = "viewmod";
  cell.colSpan = (sameNo * 2 - 1).toString ();
  link = document.createElement ("a");
  link.href = "module.html?" + window [firstElement].parent;
  link.innerHTML = "";
  link.appendChild (document.createTextNode (window [window [firstElement].parent].aliasName));
  link.appendChild (M);
  cell.appendChild (link);
  row.appendChild (cell);
  sameNo--;
  for (var idx = 0; idx < hierarchyArray.length; idx++) {
    if (sameNo === 0) {
      module = window [hierarchyArray [idx]].parent;
      cell = document.createElement ("td");
      cell.className = "hide";
      row.appendChild (cell);
      sameNo = calcConstParentModelOverHierarchy (hierarchyArray.slice (idx),
          spectool2Element.type);
      cell = document.createElement ("td");
      cell.className = "mod";
      cell.colSpan = (sameNo * 2 - 1).toString ();
      link = document.createElement ("a");
      link.href = "module.html?" + window [module].jsName;
      link.innerHTML = "";
      link.appendChild (document.createTextNode (window [module].aliasName));
      link.appendChild (M);
      cell.appendChild (link);
      row.appendChild (cell);
    }
    sameNo--;
  }

  if (spectool2Element.type == "register") {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
  }

  body.appendChild (row);
  // Print second row (ports, buses, registers, arrows)
  row = document.createElement ("tr");
  row.className = "middle";

  cell = document.createElement ("td");
  cell.className = "viewport";
  link = document.createElement ("a");
  link.href = "port.html?" + firstElement + "?" + viewName;
  link.innerHTML = "";
  link.appendChild (document.createTextNode (window [firstElement].aliasName));
  link.appendChild (P);
  cell.appendChild (link);
  row.appendChild (cell);
  for (idx = 0; idx < hierarchyArray.length; idx++) {
    var node = hierarchyArray [idx];
    cell = document.createElement ("td");
    cell.className = "arrow";
    cell.innerHTML = "&rarr;";
    row.appendChild (cell);
    cell = document.createElement ("td");
    cell.className = window [node].type;
    link = document.createElement ("a");
    if (window [node].type == "bus") {
      link.href = "bus.html?" + node + "?" + viewName;
      link.innerHTML = "";
      link.appendChild (document.createTextNode (window [node].aliasName));
      link.appendChild (B);
    } else {
      link.href = "port.html?" + node + "?" + viewName;
      link.innerHTML = "";
      link.appendChild (document.createTextNode (window [node].aliasName));
      link.appendChild (P);
    }
    cell.appendChild (link);
    row.appendChild (cell);
  }

  if (spectool2Element.type == "register") {
    cell = document.createElement ("td");
    cell.className = "arrow";
    cell.innerHTML = "&rarr;";
    row.appendChild (cell);
    cell = document.createElement ("td");
    cell.className = window [lastElement].type;
    link = document.createElement ("a");
    link.href = "register.html?" + lastElement + "?" + viewName;
    link.innerHTML = "";
    link.appendChild (document.createTextNode (window [lastElement].aliasName));
    link.appendChild (R);
    cell.appendChild (link);
    row.appendChild (cell);
  }

  body.appendChild (row);

  // print third row (addresses)
  row = document.createElement ("tr");
  row.className = "bottom";

  cell = document.createElement ("td");
  cell.className = "hide";
  cell.innerHTML = int2hexM (getAddrStart (window [firstElement], viewName), 8);
  row.appendChild (cell);
  for (idx = 0; idx < hierarchyArray.length; idx++) {
    node = hierarchyArray [idx];
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    cell = document.createElement ("td");
    cell.className = "hide";
    cell.innerHTML = int2hexM (getAddrStart (window [node], viewName), 8);
    row.appendChild (cell);
  }

  if (spectool2Element.type == "register") {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    cell = document.createElement ("td");
    cell.className = "hide";
    cell.innerHTML = int2hexM (getAddrStart (window [lastElement], viewName), 8);
    row.appendChild (cell);
  }

  body.appendChild (row);
}
/**
 * 
 * @param hierarchyArray
 *          A hierarchy array which must only contain port, iaport, and bus!
 */
function calcConstParentModelOverHierarchy (hierarchyArray, type) {
  var a;
  if (type == "register") {
    a = hierarchyArray.slice (0, hierarchyArray.length - 1);
  } else {
    a = hierarchyArray;
  }
  var count = 0;
  var module = window [hierarchyArray [0]].parent;
  for (node in a) {
    if (module != window [a [node]].parent) {
      return (count);
    }
    count++;
  }
  if (count==0) return (1);
  else return (count);
}

function padString (string, char, length) {
  var pad = new Array (length + 1).join (char);
  return (pad + string).slice (-length);
}

// ###############################################
// #####-------------------------------------#####
// #####--------- TABLE CELL CREATON --------#####
// #####-------------------------------------#####
// ###############################################

function createNrTableCell (value, bitWidth, defaultRadix) {
  if (typeof value == "number") {
    value = int2bin (value);
  }
  var bin = value;
  var hex = bin2hex (value);
  var dec = bin2dec (value);
  var sub = document.createElement ("sub");
  var cell = document.createElement ("td");
  if (bitWidth != 0) {
    bin = padString (bin, "0", bitWidth);
    hex = padString (hex, "0", bitWidth / 4);
  }
  cell.style.textAlign = "right";
  cell.title = "BIN=" + bin + "\n";
  cell.title += "HEX=" + hex + "\n";
  cell.title += "DEC=" + dec + "\n";
  if (defaultRadix == "bin") {
    sub.innerHTML = "B";
    cell.appendChild (document.createTextNode (bin));
    cell.appendChild (sub);
  } else if (defaultRadix == "hex") {
    sub.innerHTML = "H";
    cell.appendChild (document.createTextNode (hex));
    cell.appendChild (sub);
  } else {
    sub.innerHTML = "D";
    cell.appendChild (document.createTextNode (dec));
    cell.appendChild (sub);
  }

  return (cell);
}

function createNrTableCellRange (value0, value1, bitWidth, defaultRadix) {
  if (typeof value0 == "number") {
    value0 = int2bin (value0);
  }
  if (typeof value1 == "number") {
    value1 = int2bin (value1);
  }
  var bin0 = value0;
  var hex0 = bin2hex (value0);
  var dec0 = bin2dec (value0);
  var bin1 = value1;
  var hex1 = bin2hex (value1);
  var dec1 = bin2dec (value1);
  var sub = document.createElement ("sub");
  var cell = document.createElement ("td");
  if (bitWidth != 0) {
    bin0 = padString (bin0, "0", bitWidth);
    bin1 = padString (bin1, "0", bitWidth);
    hex0 = padString (hex0, "0", bitWidth / 4);
    hex1 = padString (hex1, "0", bitWidth / 4);
  }
  cell.style.textAlign = "right";
  cell.title = "BIN=" + bin0 + ":" + bin1 + "\n";
  cell.title += "HEX=" + hex0 + ":" + hex1 + "\n";
  cell.title += "DEC=" + dec0 + ":" + dec1 + "\n";
  if (defaultRadix == "bin") {
    sub.innerHTML = "B";
    cell.appendChild (document.createTextNode (bin0));
    cell.appendChild (sub);
    cell.appendChild (document.createTextNode (":"));
    cell.appendChild (document.createTextNode (bin1));
    cell.appendChild (sub);
  } else if (defaultRadix == "hex") {
    sub.innerHTML = "H";
    cell.appendChild (document.createTextNode (hex0));
    cell.appendChild (sub);
    cell.appendChild (document.createTextNode (":"));
    cell.appendChild (document.createTextNode (hex1));
    cell.appendChild (sub);
  } else {
    sub.innerHTML = "D";
    cell.appendChild (document.createTextNode (dec0));
    cell.appendChild (sub);
    cell.appendChild (document.createTextNode (":"));
    cell.appendChild (document.createTextNode (dec1));
    cell.appendChild (sub);
  }

  return (cell);
}

function createNrTableCellDuo (value, bitWidth, defaultRadix) {
  var bin = value;
  var hex = bin2hex (value);
  var dec = bin2dec (value);
  var sub = document.createElement ("sub");
  var cell = document.createElement ("td");
  if (bitWidth != 0) {
    bin = padString (bin, "0", bitWidth);
    hex = padString (hex, "0", bitWidth / 4);
  }
  cell.style.textAlign = "right";
  cell.title = "BIN=" + bin + "\n";
  cell.title += "HEX=" + hex + "\n";
  cell.title += "DEC=" + dec + "\n";
  if (defaultRadix == "bin") {
    sub.innerHTML = "B";
    cell.appendChild (document.createTextNode (bin));
    cell.appendChild (sub);
    cell.appendChild (document.createTextNode ("/"));
    cell.appendChild (document.createTextNode (convert2Stage (bin)));
    cell.appendChild (sub);
  } else if (defaultRadix == "hex") {
    sub.innerHTML = "H";
    cell.appendChild (document.createTextNode (hex));
    cell.appendChild (sub);
    cell.appendChild (document.createTextNode ("/"));
    cell.appendChild (document.createTextNode (bin2hex (convert2Stage (bin))));
    cell.appendChild (sub);
  } else {
    sub.innerHTML = "D";
    cell.appendChild (document.createTextNode (dec));
    cell.appendChild (sub);
    cell.appendChild (document.createTextNode ("/"));
    cell.appendChild (document.createTextNode (bin2dec (convert2Stage (bin))));
    cell.appendChild (sub);
  }

  return (cell);
}

// ###############################################
// #####-------------------------------------#####
// #####------------ FOOTER -----------------#####
// #####-------------------------------------#####
// ###############################################

// <div class="footer">
// <table class="footer" width="100%">
// <tr>
// <td align="left"><address>getContact(): Miedl Stefan Dipl.Ing. (miedlste), <a
// href="mailto:stefan.miedl@lantiq.com">stefan.miedl@lantiq.com</a></address></td>
// <td align="right">Generated by "miedlste" on Thursday 2014-10-02
// 09:24:11</td>
// </tr>
// <tr>
// <td>
// <a href="http://validator.w3.org/check?uri=referer"><img
// src="http://www.w3.org/Icons/valid-xhtml10" alt="Valid XHTML 1.0 Strict"
// height="31" width="88" /></a>
// </td>
// <td align="right"><a href="../DebugMessages.html"
// style="background-color:darkred;font-weight:bold; color:white">All System
// Debug Messages</a></td>
// </tr>
// </table>
// </div>

function createFooter (spectool2Element) {
  var table = document.getElementById ("footer");
  var row;
  var cell;
  var address;
  var link;
  row = document.createElement ("tr");
  if (spectool2Element !== undefined) {
    var users = spectool2Element.contacts.split (",");
    // line0
    // author
    cell = document.createElement ("td");
    cell.align = "left";
    if (users.length > 1) {
      cell.innerHTML = "Contact Persons:";
    } else {
      cell.innerHTML = "Contact Person:";
    }
    for (var idx = 0; idx < users.length; idx++) {
      var user = window [users [idx]];
      address = document.createElement ("address");
      link = document.createElement ("a");
      link.href = "users.html#user_" + user.shortName;
      link.innerHTML = user.longName;
      address.appendChild (link);
      cell.appendChild (address);
    }
    row.appendChild (cell);
  }

  var user = window [spectool2.currentUser];
  cell = document.createElement ("td");
  cell.align = "right";
  link = document.createElement ("a");
  link.href = "users.html#user_" + user.shortName;
  link.innerHTML = user.longName;
  cell.appendChild (link);
  cell.innerHTML = "";
  cell.appendChild (document.createTextNode ("Generated by "));
  cell.appendChild (link);
  cell.appendChild (document.createTextNode (" on "+spectool2.generationTime));
  row.appendChild (cell);

  table.appendChild (row);
}
