//###############################################
//#####-------------------------------------#####
//#####------ PORTS TABLE -------------#####
//#####-------------------------------------#####
//###############################################
function createPortsTable0Init (portArray, viewName, identifier) {
  var head = document.getElementById (identifier + "Head");
  var body = document.getElementById (identifier + "Body0");

  head.innerHTML += createToggleImage (identifier);

  var tableStatus = new TableStatus (10);
  // TABLE: | View Addresses {START & END} | Local Addresses {START & END}
  //        | Module | Port | Long Name | Master Bus | Slave Bus | Description |
  // init sort
  tableStatus.id = identifier + "TableStatus";
  tableStatus.sortEnabled [1] = false;
  tableStatus.sortEnabled [3] = false;
  tableStatus.sortTypes [0] = "number";
  tableStatus.sortTypes [2] = "number";
  tableStatus.sortClassNames [1] = "hiddenCell";
  tableStatus.sortClassNames [3] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  tableStatus.filterEnabled [1] = false;
  tableStatus.filterEnabled [3] = false;
  tableStatus.filterTypes [0] = "number";
  tableStatus.filterTypes [2] = "number";
  tableStatus.filterSet [0] = ">=0";
  tableStatus.filterSet [2] = ">=0";
  tableStatus.filterClassNames [1] = "hiddenCell";
  tableStatus.filterClassNames [3] = "hiddenCell";
  // combine
  //tableStatus.combineCell [4] = true;
  //tableStatus.combineCell [7] = true;
  //tableStatus.combineCell [8] = true;

  tableStatus.hookFunctionName = "hookPortTable0";

  window [tableStatus.id] = tableStatus;

  hookPortTable0 (body, portArray, viewName, tableStatus);
}

function hookPortTable0 (tableReference, portArray, viewName, tableStatus) {
  // generate data array
  buildPortTable0Array (portArray, viewName, tableStatus);
  // generate table
  createPortTable0 (tableReference, portArray, viewName, tableStatus);
}

function buildPortTable0Array (portArray, viewName, tableStatus) {
  // TABLE: | View Addresses {START & END} | Local Addresses {START & END}
  //        | Module | Port | Long Name | Master Bus | Slave Bus | Description |
  var bodyArray = new Array;
  // build bodyArray
  for (var idx = portArray.length - 1; idx >= 0; idx--) {
    bodyArray [idx] = new Array;
    var port = window [portArray [idx]];
    // View Address START
    var pos = 0;
    if (port.addrStart [viewName] === undefined) {
      bodyArray [idx] [pos] = "32'b0";
    } else {
      bodyArray [idx] [pos] = "32'b" + getViewAddrStart (port, viewName).toString (2);
    }
    // View Address END
    pos++;
    if (port.addrEnd [viewName] === undefined) {
      bodyArray [idx] [pos] = "32'b0";
    } else {
      bodyArray [idx] [pos] = "32'b" + getViewAddrEnd (port, viewName).toString (2);
    }
    // Local Address START
    pos++;
    if (port.addrStart [viewName] === undefined) {
      bodyArray [idx] [pos] = "32'b0";
    } else {
      bodyArray [idx] [pos] = port.addrStart [portArray [idx]];
    }
    // Local Address END
    pos++;
    if (port.addrStart [viewName] === undefined) {
      bodyArray [idx] [pos] = "32'b0";
    } else {
      bodyArray [idx] [pos] = port.addrEnd [portArray [idx]];
    }
    // Module
    pos++;
    bodyArray [idx] [pos] = window [port.parent].aliasName;
    // Name
    pos++;
    bodyArray [idx] [pos] = port.aliasName;
    // Long Name
    pos++;
    bodyArray [idx] [pos] = port.longName;
    // Master Bus
    pos++;
    if (port.masterBus === "") {
      bodyArray [idx] [pos] = "-";
    } else {
      bodyArray [idx] [pos] = port.masterBus;
    }
    // Slave Bus
    pos++;
    if (port.slaveBus === "") {
      bodyArray [idx] [pos] = "-";
    } else {
      bodyArray [idx] [pos] = port.slaveBus;
    }
    // Slave Bus
    pos++;
    bodyArray [idx] [pos] = port.description;
    // Port reference
    pos++;
    bodyArray [idx] [pos] = port;
    // isViewPort??
    pos++;
    bodyArray [idx] [pos] = (port.isView == "true");
  }
  tableStatus.tableArray = bodyArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus)
  return (bodyArray);
}
function createPortTable0 (tableReference, portArray, viewName, tableStatus) {
  // TABLE: | View Addresses {START & END} | Local Addresses {START & END}
  //        | Module | Port | Long Name | Master Bus | Slave Bus | Description |
  var body = tableReference;
  var bodyCells = tableStatus.tableArray;
  var headerCells = [ "View Address<br/>Start:End", "", "Local Address<br/>Start:End", "",
                      "Module", "Name", "Long Name", "Master Bus", "Slave Bus", "Description"];
  var row;
  var cell;
  var link;
  var addrStart;
  var addrEnd;
  // create header
  createSortableHeader (body, headerCells, portArray, viewName, tableStatus);

  // create filter inputs
  if (tableStatus.filterRow === null && bodyCells.length > 1) {
    // function createFilterInput (tableReference, tableRefreshFunctionName,
    // spectool2Element, viewName, portsTableStatus)
    createFilterInput (body, portArray, viewName, tableStatus);
  } else if (tableStatus.filterRow !== null) {
    // function refreshFilterInput2 (tableReference, filterRow)
    refreshFilterInput2 (body, tableStatus);
  }

  // create body
  for (var line = 0; line < bodyCells.length; line++) {
    var port = bodyCells [line] [bodyCells [line].length - 4];
    var isView = bodyCells [line] [bodyCells [line].length - 3];
    var classNames = bodyCells [line] [bodyCells [line].length - 2];
    var rowSpans = bodyCells [line] [bodyCells [line].length - 1];

    row = document.createElement ("tr");
    if (isView === true) {
      row.className = "viewport";
    } else if (line % 2 === 0) {
      row.className = "interleave";
    }
    // View Start Address START:END
    var pos = 0;
    if (port.addrStart [viewName] === undefined) {
      cell = document.createElement ("td");
      cell.style.textAlign = "right";
      cell.innerHTML = "N/A";
    } else {
      addrStart = vlogb2bin (bodyCells [line] [pos]);
      addrEnd = vlogb2bin (bodyCells [line] [pos + 1]);
      if ((tableStatus.currentSortPos===0 || tableStatus.currentSortPos===2) && tableStatus.currentSortDir==="up") {
        cell = createNrTableCellRange (addrStart, addrEnd, 32, "hex");
      } else {
        cell = createNrTableCellRange (addrEnd, addrStart, 32, "hex");
      }
    }
    // cell.className = bodyCells[line][pos];
    row.appendChild (cell);
    // HIDDEN CELL
    pos++;
    cell = document.createElement ("td");
    cell.className = "hiddenCell";
    row.appendChild (cell);
    // Local Start Address START:END
    pos++;
    if (port.addrStart [viewName] === undefined) {
      cell = document.createElement ("td");
      cell.style.textAlign = "right";
      cell.innerHTML = "N/A";
    } else {
      addrStart = vlogb2bin (bodyCells [line] [pos]);
      addrEnd = vlogb2bin (bodyCells [line] [pos + 1]);
      if ((tableStatus.currentSortPos===0 || tableStatus.currentSortPos===2) && tableStatus.currentSortDir==="up") {
        cell = createNrTableCellRange (addrStart, addrEnd, 32, "hex");
      } else {
        cell = createNrTableCellRange (addrEnd, addrStart, 32, "hex");
      }
    }
    // cell.className = bodyCells[line][pos];
    row.appendChild (cell);
    // HIDDEN CELL
    pos++;
    cell = document.createElement ("td");
    cell.className = "hiddenCell";
    row.appendChild (cell);
    // Module
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      if (row.className!=="viewport") cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      if (port.addrStart [viewName] === undefined) {
        cell.innerHTML = bodyCells [line] [pos];
      } else {
        link = document.createElement ("a");
        link.href = "module.html?" + window [port.parent].jsName;
        link.innerHTML = bodyCells [line] [pos];
        cell.appendChild (link);
      }
      row.appendChild (cell);
    }
    // Name
    pos++;
    cell = document.createElement ("td");
    cell.className = "emph";
    if (port.addrStart [viewName] === undefined || port.isCollapsedIntoPort) {
      cell.innerHTML = bodyCells [line] [pos];
    } else {
      link = document.createElement ("a");
      link.href = "port.html?" + port.jsName + "?" + viewName;
      link.title = getAliasContextName (port, true);
      link.innerHTML = bodyCells [line] [pos];
      cell.appendChild (link);
    }
    row.appendChild (cell);
    // Long Name
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Master Bus
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      if (row.className!=="viewport") cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      if (bodyCells [line] [pos] == "-") {
        cell.innerHTML = "-";
      } else {
        var bus = window [bodyCells [line] [pos]];
        if (port.addrStart [viewName] === undefined || port.isCollapsedIntoPort) {
          cell.innerHTML = getAliasContextName (bus, false);
          cell.title = getAliasContextName (bus, true);
        } else {
          link = document.createElement ("a");
          link.href = "bus.html?" + bus.jsName + "?" + viewName;
          link.title = getAliasContextName (bus, true);
          link.innerHTML = getAliasContextName (bus, false);
          cell.appendChild (link);
        }
      }
      row.appendChild (cell);
    }
    // Slave Bus
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      if (row.className!=="viewport") cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      if (bodyCells [line] [pos] == "-") {
        cell.innerHTML = "-";
      } else {
        bus = window [bodyCells [line] [pos]];
        if (port.addrStart [viewName] === undefined || port.isCollapsedIntoPort) {
          cell.innerHTML = getAliasContextName (bus, false);
          cell.title = getAliasContextName (bus, true);
        } else {
          link = document.createElement ("a");
          link.href = "bus.html?" + bus.jsName + "?" + viewName;
          link.title = getAliasContextName (bus, true);
          link.innerHTML = getAliasContextName (bus, false);
          cell.appendChild (link);
        }
      }
      row.appendChild (cell);
    }
    // Slave Bus
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      if (row.className!=="viewport") cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.innerHTML = bodyCells [line] [pos];
      row.appendChild (cell);
    }

    // Append ROW
    body.appendChild (row);
  }
}

function createPortsTable1Init (portArray, identifier, searchRegExp) {
  var head = document.getElementById (identifier + "Head");
  var body = document.getElementById (identifier + "Body0");

  if (head !== null) {
    head.innerHTML += createToggleImage (identifier);
  }

  var tableStatus = new TableStatus (10);
  // TABLE: | Module | Port | Long Name | Views on this Port | NV | MP | SP | IF | CR | Description |
  // init sort
  tableStatus.id = identifier + "TableStatus";
  tableStatus.sortEnabled [3] = false;
  // tableStatus.sortTypes [X] = "number";
  // tableStatus.sortClassNames [X] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  tableStatus.filterEnabled [4] = false;
  tableStatus.filterEnabled [5] = false;
  tableStatus.filterEnabled [6] = false;
  tableStatus.filterEnabled [7] = false;
  tableStatus.filterEnabled [8] = false;
  // tableStatus.filterTypes [X] = "number";
  // tableStatus.filterSet [X] = ">=0";
  // tableStatus.filterClassNames [X] = "hiddenCell";
  // combine
  tableStatus.combineCell [0] = true;
  //tableStatus.combineCell [3] = true;

  tableStatus.hookFunctionName = "hookPortTable1";

  window [tableStatus.id] = tableStatus;

  hookPortTable1 (body, portArray, null, tableStatus, searchRegExp);
}

function hookPortTable1 (tableReference, portArray, viewName, tableStatus, searchRegExp) {
  // generate data array
  var bodyArray = buildPortTable1Array (portArray, viewName, tableStatus);
  // generate table
  createPortTable1 (tableReference, bodyArray, portArray, viewName,
      tableStatus, searchRegExp);
}

function buildPortTable1Array (portArray, viewName, tableStatus) {
  // TABLE: | Module | Port | Long Name | Views on this Port | NV | MP | SP | IF | CR | Description |
  // Description
  var bodyArray = new Array;
  // build bodyArray
  for (var idx = portArray.length - 1; idx >= 0; idx--) {
    bodyArray [idx] = new Array;
    var port = window [portArray [idx]];
    // Module
    var pos = 0;
    bodyArray [idx] [pos] = window [port.parent].aliasName;
    // Name
    pos++;
    bodyArray [idx] [pos] = port.aliasName;
    // Long Name
    pos++;
    bodyArray [idx] [pos] = port.longName;
    // Views on this Port
    pos++;
    bodyArray [idx] [pos] = "";
    for (var i = 0; i < port.views.length; i++) {
      bodyArray [idx] [pos] += getAliasContextName (window [port.views [i]], false);
      if ( (i + 1) < port.views.length) {
        bodyArray [idx] [pos] += " ";
      }
    }
    // Native View
    pos++;
    if (port.isView == "true") {
      bodyArray [idx] [pos] = "X";
    } else {
      bodyArray [idx] [pos] = "";
    }

    // Master Port
    pos++;
    if (port.slaveBus.length > 0) {
      bodyArray [idx] [pos] = "X";
    } else {
      bodyArray [idx] [pos] = "";
    }
    // Slave Port
    pos++;
    if (port.masterBus.length > 0) {
      bodyArray [idx] [pos] = "X";
    } else {
      bodyArray [idx] [pos] = "";
    }
    // Interface
    pos++;
    if (port.isInterface == "true") {
      bodyArray [idx] [pos] = "X";
    } else {
      bodyArray [idx] [pos] = "";
    }
    // Contains Registers
    pos++;
    if (port.registers.length > 0) {
      bodyArray [idx] [pos] = "X";
    } else {
      bodyArray [idx] [pos] = "";
    }
    // Description
    pos++;
    bodyArray [idx] [pos] = port.description;
    // Port reference
    pos++;
    bodyArray [idx] [pos] = port;
  }

  tableStatus.tableArray = bodyArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus)
  return (bodyArray);
}
function createPortTable1 (tableReference, bodyCells, portArray, viewName,
                           tableStatus, searchRegExp) {
  // TABLE: | Module | Port | Long Name | Views on this Port | NV | MP | SP | IF | CR | Description |
  var body = tableReference;
  var one = document.createElement ("sup");
  one.innerHTML = "1";
  var two = document.createElement ("sup");
  two.innerHTML = "2";
  var three = document.createElement ("sup");
  three.innerHTML = "3";
  var four = document.createElement ("sup");
  four.innerHTML = "4";
  var five = document.createElement ("sup");
  five.innerHTML = "5";

  var container0 = document.createElement ("span");
  container0.appendChild (document.createTextNode ("NV"));
  container0.appendChild (one);
  var container1 = document.createElement ("span");
  container1.appendChild (document.createTextNode ("MP"));
  container1.appendChild (two);
  var container2 = document.createElement ("span");
  container2.appendChild (document.createTextNode ("SP"));
  container2.appendChild (two);
  var container3 = document.createElement ("span");
  container3.appendChild (document.createTextNode ("IF"));
  container3.appendChild (two);
  var container4 = document.createElement ("span");
  container4.appendChild (document.createTextNode ("CR"));
  container4.appendChild (two);

  var headerCellNames = [ "Module", "Name", "Long Name", "Views on this Port",
      container0.innerHTML, container1.innerHTML, container2.innerHTML,
      container3.innerHTML, container4.innerHTML, "Description" ];
  var headerCellTitles = [ "", "", "", "", "Native View", "Master Port",
      "Slave Port", "Interface between modules (or open port)",
      "Contains Registers", "" ];
  var row;
  var cell;
  var link;
  // create caption
  var caption = document.createElement ("caption");
  caption.appendChild (one);
  caption.appendChild (document.createTextNode ("Native View "));
  caption.appendChild (two);
  caption.appendChild (document.createTextNode ("Master Port "));
  caption.appendChild (three);
  caption.appendChild (document.createTextNode ("Slave Port "));
  caption.appendChild (four);
  caption.appendChild (document.createTextNode ("Interface between modules (or open port) "));
  caption.appendChild (five);
  caption.appendChild (document.createTextNode ("Contains Registers "));
  body.appendChild (caption);

  // create header
  row = document.createElement ("tr");
  for (pos in headerCellNames) {
    cell = document.createElement ("th");
    cell.className = tableStatus.sortClassNames [pos];
    cell.title = headerCellTitles [pos];
    cell.innerHTML = headerCellNames [pos];
    if (tableStatus.sortEnabled [pos] === true) {
      createSortHook (body, cell, pos, portArray, viewName, tableStatus);
    }
    row.appendChild (cell);
  }
  body.appendChild (row);

  // create filter inputs
  if (tableStatus.filterRow === null && bodyCells.length > 1) {
    createFilterInput (body, portArray, viewName, tableStatus);
  } else if (tableStatus.filterRow !== null) {
    refreshFilterInput2 (body, tableStatus);
  }

  // create body
  for (var line = 0; line < bodyCells.length; line++) {
    var port = bodyCells [line] [bodyCells [line].length - 3];
    var classNames = bodyCells [line] [bodyCells [line].length - 2];
    var rowSpans = bodyCells [line] [bodyCells [line].length - 1];

    var isView = (port.isView == "true");
    row = document.createElement ("tr");
    if (isView === true) {
      row.className = "viewport";
    } else if (line % 2 === 0) {
      row.className = "interleave";
    }

    // Module
    var pos = 0;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      if (row.className!=="viewport") cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.title = getAliasContextName (window [port.parent], true);
      link = document.createElement ("a");
      link.href = "module.html?" + window [port.parent].jsName;
      if (searchRegExp !== undefined) {
        link.innerHTML = highlightSearch (bodyCells [line] [pos], searchRegExp);
      } else {
        link.innerHTML = bodyCells [line] [pos];
      }
      cell.appendChild (link);
      row.appendChild (cell);
    }
    // Name
    pos++;
    cell = document.createElement ("td");
    cell.className = "emph";
    if (searchRegExp !== undefined) {
      cell.innerHTML = highlightSearch (bodyCells [line] [pos], searchRegExp);
    } else {
      cell.innerHTML = bodyCells [line] [pos];
    }
    row.appendChild (cell);
    // Long Name
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Views on this Port
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      if (row.className!=="viewport") cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.innerHTML = "";
      if (port.isCollapsedIntoPort == false) {
        for (var idx = 0; idx < port.views.length; idx++) {
          var bold = document.createElement ("b");
          bold.innerHTML = getAliasContextName (window [port.views [idx]], false);
          link = document.createElement ("a");
          link.appendChild (bold);
          link.appendChild (document.createTextNode ("." + getAliasContextName (port, false)));
          link.href = "port.html?" + port.jsName + "?" + port.views [idx];
          cell.appendChild (link);
          if ( (idx + 1) < port.views.length) {
            cell.innerHTML += "<br/>";
          }
        }
      }
      row.appendChild (cell);
    }
    // Native view
    pos++;
    cell = document.createElement ("td");
    cell.className = "sel";
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Master Port
    pos++;
    cell = document.createElement ("td");
    cell.className = "sel";
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    row.appendChild (cell);
    // Slave Port
    pos++;
    cell = document.createElement ("td");
    cell.className = "sel";
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Interface
    pos++;
    cell = document.createElement ("td");
    cell.className = "sel";
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Contains Registers
    pos++;
    cell = document.createElement ("td");
    cell.className = "sel";
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Description
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Append ROW
    body.appendChild (row);
  }
}

function createViewsTable1Init (portArray, identifier) {
  var head = document.getElementById (identifier + "Head");
  var body = document.getElementById (identifier + "Body0");

  if (head !== null) {
    head.innerHTML += createToggleImage (identifier);
  }

  var tableStatus = new TableStatus (5);
  // TABLE: | Module | Port | Long Name | #Registers | Description |
  // init sort
  tableStatus.id = identifier + "TableStatus";
  tableStatus.sortTypes [3] = "number";
  // tableStatus.sortClassNames [X] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  tableStatus.filterTypes [3] = "number";
  tableStatus.filterSet [3] = ">=0";
  // tableStatus.filterClassNames [X] = "hiddenCell";
  // combine
  tableStatus.combineCell [0] = true;

  tableStatus.hookFunctionName = "hookViewTable1";

  window [tableStatus.id] = tableStatus;

  hookViewTable1 (body, portArray, null, tableStatus);
}

function hookViewTable1 (tableReference, portArray, viewName, tableStatus) {
  // generate data array
  buildViewTable1Array (portArray, tableStatus);
  // generate table
  createViewTable1 (tableReference, portArray, tableStatus);
}

function buildViewTable1Array (portArray, tableStatus) {
  // TABLE: | Module | Port | Long Name | #Registers | FAM | Description |
  var bodyArray = new Array;
  // build bodyArray
  for (var idx = portArray.length - 1; idx >= 0; idx--) {
    bodyArray [idx] = new Array;
    var port = window [portArray [idx]];
    // Module
    var pos = 0;
    bodyArray [idx] [pos] = window [port.parent].aliasName;
    // Port
    pos++;
    bodyArray [idx] [pos] = port.aliasName;
    // Long Name
    pos++;
    bodyArray [idx] [pos] = port.longName;
    // #Registers
    pos++;
    bodyArray [idx] [pos] = "32'b" + port.viewRegisters.length.toString (2);
    // Description
    pos++;
    bodyArray [idx] [pos] = port.description;
    // Port reference
    pos++;
    bodyArray [idx] [pos] = port;
  }

  tableStatus.tableArray = bodyArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus)
  return (bodyArray);
}
function createViewTable1 (tableReference, portArray, tableStatus) {
  // TABLE: | Module | Port | Long Name | #Registers | FAM | Description |
  var body = tableReference;
  var bodyCells = tableStatus.tableArray;

  var one = document.createElement ("sup");
  one.innerHTML = "1";
  var two = document.createElement ("sup");
  two.innerHTML = "2";
  var three = document.createElement ("sup");
  three.innerHTML = "3";
  var four = document.createElement ("sup");
  four.innerHTML = "4";
  var five = document.createElement ("sup");
  five.innerHTML = "5";
  // TABLE: | Module | Port | Long Name | #Registers | FAM | Description |
  var headerCellNames = [ "Module", "Name", "Long Name", "Registers", "Description" ];
  var headerCellTitles = [ "", "", "", "", "" ];
  var row;
  var cell;
  var link;

  // create header
  row = document.createElement ("tr");
  for (pos in headerCellNames) {
    cell = document.createElement ("th");
    cell.className = tableStatus.sortClassNames [pos];
    cell.title = headerCellTitles [pos];
    cell.innerHTML = headerCellNames [pos];
    if (tableStatus.sortEnabled [pos] === true) {
      createSortHook (body, cell, pos, portArray, null, tableStatus);
    }
    row.appendChild (cell);
  }
  body.appendChild (row);

  // create filter inputs
  if (tableStatus.filterRow == null && bodyCells.length > 1) {
    createFilterInput (body, portArray, null, tableStatus);
  } else if (tableStatus.filterRow !== null) {
    refreshFilterInput2 (body, tableStatus);
  }
  // console.log ("========================");
  // create body
  for (var line = 0; line < bodyCells.length; line++) {
    var port = bodyCells [line] [bodyCells [line].length - 3];
    var classNames = bodyCells [line] [bodyCells [line].length - 2];
    var rowSpans = bodyCells [line] [bodyCells [line].length - 1];

    row = document.createElement ("tr");
    if (line % 2 === 0) {
      row.className = "interleave";
    }
    //console.log ("MODULE/PORT="+getAliasContextName(port, false));
    //console.log ("Combine="+bodyCells [line] [0]);
    //console.log (rowSpans);
    // Module
    var pos = 0;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.title = getAliasContextName (window [port.parent], true);
      link = document.createElement ("a");
      link.href = "module.html?" + window [port.parent].jsName;
      link.innerHTML = bodyCells [line] [pos];
      cell.appendChild (link);
      row.appendChild (cell);
    }
    // Name
    pos++;
    cell = document.createElement ("td");
    if (port.isCollapsedIntoPort) {
      cell.innerHTML = bodyCells [line] [pos];
    } else {
      cell.className = "emph";
      link = document.createElement ("a");
      link.href = "port.html?" + port.jsName + "?" + port.jsName;
      link.innerHTML = bodyCells [line] [pos];
      cell.appendChild (link);
    }
    row.appendChild (cell);
    // Long Name
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // #Registers
    pos++;
    cell = document.createElement ("td");
    if (vlogb2int (bodyCells [line] [pos])>0) {
      link = document.createElement ("a");
      link.href = "fam_registers.html?" + port.jsName;
      link.innerHTML = vlogb2dec (bodyCells [line] [pos]);
      cell.appendChild (link);
    } else {
      cell.innerHTML = vlogb2dec (bodyCells [line] [pos]);
    }
    row.appendChild (cell);
    // Description
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Append ROW
    body.appendChild (row);
  }
}
