//###############################################
//#####-------------------------------------#####
//#####------ DEBUG MESSAGE TABLE ----------#####
//#####-------------------------------------#####
//###############################################
function createDebugMsgTable (spectool2Element, viewName) {
  var head = document.getElementById ("debugmsgHead");
  var body0 = document.getElementById ("debugmsgBody0");

  if (hasDebugMessages (spectool2Element) === false) {
    hideBundle ("debugmsgBody", undefined);
    return;
  }

  head.innerHTML += createToggleImage ("debugmsg");

  var tableStatus = new TableStatus (7);
  // TABLE: | DbgMsg | module hier. | bus hier. | src | type | inv. | Description |
  // init sort
  tableStatus.id = "globalDebugMsgTable";
  // tableStatus.sortEnabled [X] = false;
  // tableStatus.sortTypes [X] = "number";
  // tableStatus.sortClassNames [X] = "hiddenCell";
  tableStatus.currentSortPos = 1;
  tableStatus.currentSortDir = "down";
  // init filter
  // tableStatus.filterEnabled [X] = false;
  // tableStatus.filterTypes [X] = "number";
  // tableStatus.filterSet [X] = ">=0";
  // tableStatus.filterClassNames [X] = "hiddenCell";
  // combine
  tableStatus.combineCell [1] = true;
  tableStatus.combineCell [2] = true;
  tableStatus.combineCell [3] = true;
  
  tableStatus.hookFunctionName = "hookDebugMsgTable";

  window [tableStatus.id] = tableStatus;

  hookDebugMsgTable (body0, spectool2Element, viewName, tableStatus);
}
// f (body, dataSource, viewName, tStatus, row);
function hookDebugMsgTable (body, spectool2Element, viewName, tableStatus) {
  // clear body
  body.innerHTML = "";

  // create header
  var headerCellNames = [ "MsgType", "Module Hierarchy", "Bus Hierarchy", "Source",
                          "Type", "Involved", "Description" ];
  var row;
  var cell;
  var link;
  var idx;

  // create body rows
  var debugMessages = spectool2Element.debugMessages.slice ();
  if (spectool2Element.type == "register") {
    for (idx = 0; idx < spectool2Element.fields.length; idx++) {
      var field = window [spectool2Element.fields [idx]];
      debugMessages.push.apply (debugMessages, field.debugMessages);
    }
  } else if (spectool2Element.type == "system") {
    debugMessages.push.apply (debugMessages, spectool2Element.allDebugMessages);
  }

  // build table array
  var tableArray = buildDebugMessageTableArray (debugMessages, tableStatus);
  
  // create header
  createSortableHeader (body, headerCellNames, spectool2Element, viewName, tableStatus);

  // create filter inputs
  if (tableStatus.filterRow === null && tableArray.length>1) {
    // function createFilterInput (tableReference, tableRefreshFunctionName,
    // spectool2Element, viewName, fieldsTableStatus)
    createFilterInput (body, spectool2Element, viewName, tableStatus);
  } else  if (tableStatus.filterRow !== null) {
    // function refreshFilterInput2 (tableReference, filterRow)
    refreshFilterInput2 (body, tableStatus);
  }

  // build html table
  var dm;
  for (idx = 0; idx < (tableArray.length); idx++) {
    var element = tableArray [idx] [tableArray [idx].length - 3];
    var classNames = tableArray [idx] [tableArray [idx].length - 2];
    var rowSpans = tableArray [idx] [tableArray [idx].length - 1];

    if (element.type == "sequence")
      continue; // TODO: howto deal with sequences???

    row = document.createElement ("tr");
    if (idx % 2 === 0) {
      row.className = "interleave";
    }
    // MsgType
    var pos = 0;
    var msgType = tableArray [idx] [pos].split (" ") [0];
    var msgSeverity = tableArray [idx] [pos].split (" ") [1];
    cell = document.createElement ("td");
    cell.innerHTML = msgType;
    cell.className = msgSeverity.toLowerCase ();
    row.appendChild (cell);
    // Module Hierarchy
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.innerHTML = "";
      var hElements = tableArray [idx] [pos].split (",");
      var view = window [hElements [0]];
      for (var j = 0; j < hElements.length; j++) {
        if (hElements [j] === "")
          continue;
        var hElem = window [hElements [j]];
        var link = document.createElement ("a");
        if (hElem.type == "system") {
          link.href = "index.html";
        } else if (hElem.type == "module") {
          link.href = hElem.type + ".html?" + hElem.jsName;
        } else {
          link.href = hElem.type + ".html?" + hElem.jsName + "?"
              + hElem.views [0];
        }
        link.innerHTML = hElem.aliasName; // getAliasContextName (hElem, false);
        cell.appendChild (link);
        if ( (j + 1) < hElements.length) {
          cell.innerHTML += "::";
        }
      }
      row.appendChild (cell);
    }
    // Bus Hierarchy
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.innerHTML = "";
      hElements = tableArray [idx] [pos].split (",");
      var view = window [hElements [0]];
      for (var j = 0; j < hElements.length; j++) {
        if (hElements [j] === "")
          continue;
        var hElem = window [hElements [j]];
        var link = document.createElement ("a");
        link.href = hElem.type + ".html?" + hElem.jsName + "?" + view.jsName;
        link.innerHTML = getAliasContextName (hElem, false);
        cell.appendChild (link);
        if ( (j + 1) < hElements.length) {
          cell.innerHTML += " &#8594; ";
        }
      }
      row.appendChild (cell);
    }
    // Source
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.innerHTML = tableArray [idx] [pos];
      //console.log ("element.jsName="+element.jsName);
      var effected = window [element.jsName];
      if (effected.file.length > 0) {
        link = document.createElement ("a");
        link.href = "file://" + effected.file;
        link.innerHTML = effected.file;
        cell.innerHTML += "<br/>";
        cell.appendChild (link);
      }
      row.appendChild (cell);
    }
    // Type
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = tableArray [idx] [pos];
    row.appendChild (cell);
    // Involved
    pos++;
    cell = document.createElement ("td");
    var involved = tableArray [idx] [pos].split (",");
    for (var i = 0; i < involved.length; i++) {
      cell.innerHTML += involved [i];
      if ( (i + 1) < involved.length) {
        cell.appendChild (document.createElement ("br"));
      }
    }
    row.appendChild (cell);
    // Description
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = tableArray [idx] [pos];
    row.appendChild (cell);

    body.appendChild (row);
  }
}

function buildDebugMessageTableArray (debugMessages, tableStatus) {
  var dm;
  var tableArray = new Array ();
  for (var idx = 0; idx < debugMessages.length; idx++) {
    tableArray [idx] = new Array ();
    dm = window [debugMessages [idx]];
    // MsgType,MsgSeverity
    var pos = 0;
    tableArray [idx] [pos] = dm.msgType + " " + dm.msgSeverity.toLowerCase ();
    // Contextname ==> Module Hierarchy
    pos++;
    tableArray [idx] [pos] = dm.moduleHierarchy;
    // Bus Hierarchy
    pos++;
    tableArray [idx] [pos] = dm.busHierarchy;
    // Source
    pos++;
    tableArray [idx] [pos] = dm.source;
    // Type
    pos++;
    tableArray [idx] [pos] = dm.type;
    // Involved
    pos++;
    tableArray [idx] [pos] = dm.involved;
    // Description
    pos++;
    tableArray [idx] [pos] = dm.description;
    // ref
    pos++;
    tableArray [idx] [pos] = dm;
  }

  tableStatus.tableArray = tableArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus)
  return (tableArray);
}
