#include <stdint.h>
#include "target.h"
#include "interface_abb11ac.h"
#include "fcsvtb_fcsi2_n_dpi.h"
#include "tb_abb11ac_fcsi2_n_defines.h"
#include "regtrace.h"
// Configuration Section:

//#define USE_FCSI_SINGLE_PORT_ACC


void ABB_vPortWrite (uint32_t P_ulPort, uint32_t P_ulValue)
{
  _port_set(P_ulPort,P_ulValue);
}

void ABB_vPortsWrite (uint32_t P_ulPort, uint32_t P_ulWidth, uint32_t P_ulValue)
{
  _ports_set(P_ulPort,P_ulWidth, P_ulValue);
}

uint32_t ABB_ulPortRead (uint32_t P_ulPort)
{
  return _port_get(P_ulPort);
}

void ABB_wait(uint32_t cnt, uint32_t unit)
{
    _wait(cnt, unit);
}

#ifdef USE_FCSI_SINGLE_PORT_ACC

void ABB_vFcsiRmw(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usMask, uint16_t P_usValue)

{
 #ifdef DEBUGFCSI
  debug_printf("usAntenna: %d\n",P_usAntenna);
  debug_printf("usAddress: 0x%x\n",P_usAddress);
  debug_printf("usMask   : 0x%x\n",P_usMask);
  debug_printf("usValue  : 0x%x\n",P_usValue);

 #endif 
	uint16_t usValue;

	usValue = _in(P_usAddress);
	
	#ifdef DEBUGFCSI
	debug_printf("ReadValue 0x%x\n",usValue);
	#endif
	usValue &=  P_usMask ;
	usValue |=  P_usValue;
	//_out(P_usAddress,usValue);
	_trace_out(P_usAddress,usValue);
}



uint16_t ABB_usFcsiRead(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress)

{
 	uint16_t usValue;

	usValue = _in(P_usAddress);
	
	return usValue;

}

void ABB_vFcsiWrite( void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usValue)

{
 	//_out(P_usAddress,P_usValue);
	_trace_out(P_usAddress,P_usValue);
}




#else

// Multiport Implementation
// -----------------------------------


void ABB_vFcsiWrite( void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usValue)
{
	uint32_t ulPortcnt;
	uint32_t AddrBuff[MAX_PORT_COUNT];
	uint32_t DataWrBuff[MAX_PORT_COUNT];

	_out_n_cfg(MAX_PORT_COUNT); // this must match with SV parameter amount of fcsi "ports"

	// ALL Ports always active, only dummy address is used
	_config_set(FCSI2_N_CONFIG_IDX_ENABMASK,P_usAntenna); // testwise enabling only one fcsi driver


	for (ulPortcnt=0; ulPortcnt<MAX_PORT_COUNT; ulPortcnt++)
	{
		AddrBuff[ulPortcnt]=P_usAddress;
		DataWrBuff[ulPortcnt]=P_usValue;
	}

	  //_out_n(AddrBuff,DataWrBuff);
	  _trace_out_n(AddrBuff,DataWrBuff, "");
}


// TODO: howto select between Single and Multiport Driver !?
void ABB_vFcsiRmw(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t P_usMask, uint16_t P_usValue)
{
  uint32_t ulPortcnt;
  uint32_t AddrBuff[MAX_PORT_COUNT];
  uint32_t DataRdBuff[MAX_PORT_COUNT];


  //#ifdef DEBUGFCSI
  debug_printf("usAntenna: %d\n",P_usAntenna);
  debug_printf("usAddress: 0x%x\n",P_usAddress);
  debug_printf("usMask   : 0x%x\n",P_usMask);
  debug_printf("usValue  : 0x%x\n",P_usValue);
  //#endif 

  _out_n_cfg(MAX_PORT_COUNT); // this must match with SV parameter amount of fcsi "ports"
  _config_set(FCSI2_N_CONFIG_IDX_ENABMASK,P_usAntenna); // enabling all fcsi driver

  for (ulPortcnt=0; ulPortcnt<MAX_PORT_COUNT; ulPortcnt++)
  {
     AddrBuff[ulPortcnt]=P_usAddress;
  }


 // debug_printf("running _in_n");
 _in_n(AddrBuff,DataRdBuff);
 // debug_printf("running _in_n done");

  
  for (ulPortcnt=0; ulPortcnt<MAX_PORT_COUNT; ulPortcnt++)
    {
      DataRdBuff[ulPortcnt] &= P_usMask;
      DataRdBuff[ulPortcnt] |= P_usValue;
    }

  //_out_n(AddrBuff,DataRdBuff);
  _trace_out_n(AddrBuff,DataRdBuff, "");
	
}


uint16_t ABB_usFcsiRead(void *P_pvMirror, uint16_t P_usAntenna, uint16_t P_usAddress, uint16_t *P_pusData)

{
	uint32_t ulPortcnt;
	uint32_t ulReadCnt=0;
	uint32_t ulValidIndex=0;
	uint32_t AddrBuff[MAX_PORT_COUNT];
	uint32_t DataRdBuff[MAX_PORT_COUNT];

	_out_n_cfg(MAX_PORT_COUNT); // this must match with SV parameter amount of fcsi "ports"
	_config_set(FCSI2_N_CONFIG_IDX_ENABMASK,P_usAntenna); // testwise enabling only one fcsi driver

		
	for (ulPortcnt=0; ulPortcnt<MAX_PORT_COUNT; ulPortcnt++)
	{
		AddrBuff[ulPortcnt]=P_usAddress;
	}


	_in_n(AddrBuff,DataRdBuff);

	for (ulPortcnt=0; ulPortcnt<MAX_PORT_COUNT; ulPortcnt++)
	{
		P_pusData[ulPortcnt]=(uint16_t) DataRdBuff[ulPortcnt];
	}

	return (uint16_t) DataRdBuff[ulValidIndex];

}

#endif
// uint16 --> unsigned integer 16bit
// us --> unsigned short endspricht dem unsigned integer
// P --> parameter
// < ...> --> header out of c library
// "..." --> self written header
// ...



