%% initialization of matlab APIs and channel to BBS
start_once;

%% RFIC api use
%rfid.rfic('func_name', param_list);
rfid.rfic_api('rfic_set_rxdcoffset', 1,0,1);

%Path to rfic mex creation file:    C:\work\RFSystemEnv\RF_sync\regs_rfic\wrx654\lab\rfic_api.c
%Path to rfic C API lib:            C:\work\RFSystemEnv\RF_sync\regs_rfic\wrx654\source\c\lib_wrx654_api\lib_wrx654_api.h

%% BBIC - Input struct
% - A struct that holds all input parameters for all bbic API functions
% - If properly used, it will hold a mirror of all the configs done from
% matlab. Properly means using get functions with input_struct fields, as
% shown later.
% - Created in start once
input_struct
input_struct.bbic_set_accum_params.AccumShift; %delete AccumShift and press Tab to see all input params for bbic_set_accum_params, by alphabetical order (not C input order!)

%% BBIC - path to lib
% Path to bbic .m files lib, useful for getting the correct order of input
% params:                   C:\work\RFSystemEnv\RF_sync\regs_bbic\WAV654\lab\@WAV_654\bbic_write_ram_fir_coeffs.m
% Path to bbic .c API:      C:\work\RFSystemEnv\RF_sync\regs_bbic\WAV654\source\lib_wav600_api.h

%% BBIC - set functions examples

%bbid.funcname(input_values)
%Option 1 - values - easier to use
bbid.bbic_rxon(1); %The only input parameter for bbic_rxon is AntMask
bbid.bbic_set_difi2_gain(1, [0 0 0 0]);%The input parameters for bbic_set_difi2_gain are AntMask and a vector of 4 difi2 gains (1 per antenna)

%Option 2 - input_struct fields as parameters - uses input_struct as a
%mirror of configs
AntMsk = 1;
input_struct.bbic_rxon.AntMsk = AntMsk;

bbid.bbic_rxon(input_struct.bbic_rxon.AntMsk);
input_struct.bbic_set_difi2_gain.AntMsk = AntMsk;
input_struct.bbic_set_difi2_gain.DifiGain = [0 0 0 0];
bbid.bbic_set_difi2_gain(AntMsk, input_struct.bbic_set_difi2_gain.DifiGain);

%Option 3 - input_struct fields as parameters - uses input_struct as a
%mirror of configs but provides input as stand alone parameters and not
%hard-coded values or long named fields in structures.
% This way the struct is internally updated and still carries the correct
% values!

AntMsk = 1;
tx_scale = 2;
bbid.bbic_set_tx_scale(AntMsk, tx_scale);


%% BBIC - get functions examples

%bbid.funcname(input_values)
input_struct.bbic_get_accum.AntMsk =1;
bbid.bbic_get_accum(input_struct.bbic_get_accum.AntMsk, input_struct.bbic_get_accum.pAccumResults, input_struct.bbic_get_accum.pAccumOF);
% In this example pAccumResults and pAccumOF will be filled with readings
% from the chip. The struct was ceated and zeroed in input_struct, and it's
% values will be overriden by values read from the chip

%% BBIC - optional TODOs

% 1. Provide the possibility to set only one parameter that was changed 
% instead of all the inputs
% 2. At get functions, return the value also in the "matlab way", and not
% only as a change in input struct (providing a parameter by reference).
% 3. Defend .m files from input in illegal structure (int instead of vector
% or any other illegal input structure)