clc;
clear all;
close all

%fid = fopen('lib_600_temp.h');
cd(fileparts(which(mfilename)));
cd '..\source'
%cd 'D:\work\RFSystemEnv\RF_sync\regs_bbic\WAV654\source'

fid = fopen('lib_wav600_api.h');

tline = fgetl(fid);
i = 1;
legal_return_types = {'void';'int'; 'uint'; 'uint8_t';'uint16_t';'uint32_t'; 'int8_t';'int16_t'; 'int32_t'; 'BOOL'} ;
names = cell(200,1);
returnVal = cell(200,1);
types = cell(200,20);
type_bits = 8*ones(200,20);
vars = cell(200,20);
returnVars = zeros(200,20);
neglect_typedefs = 1;
while ischar(tline)
    if strcmp(tline,'#endif //end')
        break;
    end
    func = false;
    disp(tline);
    tline = fgetl(fid);
    b = strsplit(tline,')');
    c = strsplit(char(b(1)),{' ', '(', ')', ','});
    for j=1:1:length(legal_return_types)
        if ((strcmp(c(1),legal_return_types(j))) && (size(strsplit(tline,'('),2)>1))
            func = true;
        end
    end
    
    if (func)
        if contains(string(c(2)), 'block')
            continue;
        end
        names(i) = c(2);
        returnVal(i) = c(1);
        if ~strcmp(string(c(3)), 'void')
            types(i,1:size(c(3:2:end),2)) = c(3:2:end);
            vars(i,1:size(c(4:2:end),2)) = c(4:2:end); 
        end
        i = i+1;
    else
        if contains(tline, '#define')
            b = strsplit(tline,{' ', '(', ')', '\t'});
            %if (length(b)>2) && isstrprop(b{3}(1),'digit')   
            if (length(b)>2)
                try
                    eval(strcat(b{2}, '=' ,b{3}));  
                catch
                end
            end
        end
        fields = [];
        subtypes = [];
        if (~neglect_typedefs) && contains(tline, 'typedef struct')
             tline = fgetl(fid);
             tline = fgetl(fid);

            while ~contains(tline, '}')
                struct_props = strsplit(tline,{' ',';'});
                fields = [fields struct_props(2)];
                if or(contains(struct_props(1), '8'), contains(struct_props(1), 'BOOL'))
                    subtypes =[subtypes 8];
                else
                    subtypes =[subtypes 32];
                end
                tline = fgetl(fid);

            end
            struct_props = strsplit(tline,{' ', ';'});
            struct_name = struct_props(2);
            for l = 1 : length(fields)
                eval(strcat(struct_name, '.' ,string(fields(l)), ' = int',string(subtypes(l)),'(0);'));
            end
            eval(strcat(struct_name, 'bits = ', string(subtypes(1)), ';'));
        end
        if contains(tline, 'Dedicated')
            neglect_typedefs = 0;
        end
    end
        
    
end
fclose(fid);

num_inputs = sum(~cellfun(@isempty,types),2);
num_funcs = sum(~cellfun(@isempty,names),1);
cd '..\lab'
fid2 = fopen('bbic_api.m','w');
fprintf(fid2, '%s\n%s\n%s\n%s\n%s\n', ["function y = bbic_api(func_name, input_struct)  %#codegen" "global input_struct2" "input_struct2 = input_struct;" "y=0;" "switch(func_name)"]);

clean_vars = cell(num_funcs,max(num_inputs));
rtrn_vars = zeros(1, num_funcs);
for i=1:1:num_funcs
    if mod(i,127)==0
    fprintf(fid2, '%s\n%s\n',["end" "switch(func_name)"]);
    end
    fprintf(fid2,'\t%s%s%c \n', ["case '" names(i) "'"]); 
    if strcmp(returnVal(i), "void") ~= 1
        fprintf(fid2, '\t\t%s%s%c', ["y = coder.ceval('" names(i) "'"]);
    else
        fprintf(fid2, '\t\t%s%s%c', ["coder.ceval('" names(i) "'"]);
    end
    %if num_inputs(i)>0
    j=1;
    while j<=(num_inputs(i))
        str1 = '';
        str2 = '';
        if or(contains(string(vars(i,j)),'['), contains(string(types(i,j)),'*'))
           str1 = 'coder.ref(';
           str2 = ')';
        end
        c = strsplit(string(vars(i,j)),'[');
        if  c(1) ~= vars(i,j)
            clean_vars(i,j) = {char(c(1))};
        else
            clean_vars(i,j) = vars(i,j);
        end
        if or(contains(types(i,j), '8'), contains(types(i,j), 'BOOL'))
            type_bits(i,j) = 8;
        elseif contains(types(i,j), '16')
            type_bits(i,j) = 16;
        elseif contains(types(i,j), '32')
            type_bits(i,j) = 32;
        end
        if contains(string(clean_vars(i,j)), 'rtrn')
            temp_str = char(clean_vars(i,j));
            rtrn_vars(i) = rtrn_vars(i) +1;
            returnVars(i,j) = 1;
            clean_vars(i,j) = {temp_str(1:end-5)};
        end
        fprintf(fid2, ', %s%s.%s.%s%s', [str1 "input_struct2" names(i) string(clean_vars(i,j)) str2]);
        
        j = j+1;    
    end

    %end
    fprintf(fid2, ');\n');

        
end
fprintf(fid2, '%s\n', "end");

fid2 = fclose(fid2);

for k = 1:num_funcs
   if (num_inputs(k) > 0)
    for m = 1:num_inputs(k)
        d = strsplit(char(vars(k,m)),{'[', ']'});
        if length(d) == 1
            eval(strcat('input_struct.', string(names(k)), '.' ,string(clean_vars(k,m)), ' = int',string(type_bits(k,m)),'(0);' ));
        end
        if length(d) == 2
            if exist(string(types(k,m)))
                eval(strcat('type_bits(k,m) =' , string(types(k,m)), 'bits;'));
                eval(strcat('input_struct.', string(names(k)), '.' ,string(clean_vars(k,m)), ' = ', string(types(k,m)), ';'));
            end
        end
        if length(d) == 3
            if exist(string(types(k,m)))
                eval(strcat('type_bits(k,m) =' , string(types(k,m)), 'bits;'));
                sructarray = [];
                eval(strcat('cnt_to = ', string(d(2)), ';'));
                eval(strcat('tmp', '=', string(types(k,m)),'(1);'));
                eval(strcat('clear ', {' '}, string(types(k,m))));
                for cnt = 1:cnt_to
                    eval(strcat(string(types(k,m)), '(cnt)=tmp;'));
                end
                eval(strcat('input_struct.', string(names(k)), '.' ,string(clean_vars(k,m)), ' = ', string(types(k,m)), ';'));
            else
                eval(strcat('input_struct.', string(names(k)), '.' ,string(clean_vars(k,m)), '= int', string(type_bits(k,m)) , '(zeros(1,', string(d(2)), '));'));
            end
        end
        if length(d) == 4
            eval(strcat('input_struct.', string(names(k)), '.' ,string(clean_vars(k,m)), '=  int', string(type_bits(k,m)) , '(zeros(', string(d(2)), ',', string(d(3)), '));'));
        end   
    end
   else
       eval(strcat('input_struct.', string(names(k)), ' = [];'));
   end
end

%input_struct.bbic_get_rx_ant_mask.AntMsk = int8(input_struct.bbic_get_rx_ant_mask.AntMsk);
%input_struct.bbic_get_rx_ant_mask.NumOfAnt = int8(input_struct.bbic_get_rx_ant_mask.NumOfAnt);
save('input_struct.mat','input_struct');
global input_struct2
input_struct2 = input_struct;
%codegen -config:mex bbic_api ../source/lib_wav600_api.c ../source/lib_wav600_api.h  -args {coder.typeof('0',[1 100],[0 1]),input_struct}

for j = 1:3
    cd '..\source'
    fid = fopen('chip_rev_header.h', 'w');
    switch (j)
        case 1
            fwrite(fid, '') ;                         % Save to file.
        case 2
            fwrite(fid, '#define ENET_INC_ARCH_WAVE600B') ; 
        case 3
            fwrite(fid, '#define ENET_INC_ARCH_WAVE600D2') ; 
    end
    fclose(fid);
    cd '..\lab'
    codegen -config:mex bbic_api ../source/lib_wav600_api.c ../source/lib_wav600_api.h  -I ..\platfrom\ -I ..\..\..\shared_header\HwHeaders\Wave600 -I ..\..\..\shared_header\HwRegs\Wave600 -args {coder.typeof('0',[1 100],[0 1]),input_struct}
    switch (j)
        case 1
            movefile bbic_api_mex.mexw64 MEX_A0
        case 2
            movefile bbic_api_mex.mexw64 MEX_B0
        case 3
            movefile bbic_api_mex.mexw64 MEX_Dash2
    end
end

%start_once;

%%%%% To Delete: coder.ref(input_struct.bbic_get_rx_ant_mask.AntMsk), coder.ref(input_struct.bbic_get_rx_ant_mask.NumOfAnt)
%global channel
%global target
%channel = tcpip('localhost', 1115, 'Timeout', 3, 'InputBufferSize', 100000);
%fopen(channel);
%target = 0;


%% .m file library building

cd @WAV_654
%copyfile('../bbic_api_mex.mexw64');
for i =1:num_funcs
    eval(strcat('fid3 = fopen(''' , string(names(i)) , '.m''',',''w'');'));
    rtrn_vec = "";
    if rtrn_vars(i) > 0
        for k = 1:num_inputs(i)
            if returnVars(i,k)
                if string(rtrn_vec) == ""
                    rtrn_vec = strcat(rtrn_vec, string(clean_vars(i,k)),'_rtrn');
                else
                    rtrn_vec = strcat(rtrn_vec, ',', string(clean_vars(i,k)),'_rtrn');
                end
            end
        end
    end
    if ~strcmpi(returnVal(i), 'void')
        if rtrn_vars(i) > 0
            comma = ',';
        else
            comma = '';
        end
        rtrn_vec_all(i) = strcat(' [output', comma, rtrn_vec, '] = ');
        funcout = rtrn_vec_all(i);
        mex_rtrn = " [output] = ";
    else
        mex_rtrn = "";
        if rtrn_vars(i) > 0
            rtrn_vec_all(i) = strcat(' [', rtrn_vec, '] = ');
            funcout = rtrn_vec_all(i);
        else
            funcout = " ";
        end
    end
    %first_string = strcat('function',funcout , string(names(i)), '(obj');
    first_string = strcat('function',funcout , string(names(i)), '(~');
    inputnum = 1;
    while inputnum <= num_inputs(i)
        first_string = strcat(first_string, ',', string(clean_vars(i,inputnum)));
        inputnum = inputnum + 1 ;
    end
    first_string = strcat(first_string, ')');
    fprintf(fid3, '%s\n\n', first_string);
    fprintf(fid3, '\tglobal input_struct\n\tglobal input_struct2\n\n');
    fprintf(fid3, '\ttemp = input_struct.%s;\n', string(names(i)));
    fprintf(fid3, '\ttry\n');
    for k = 1:num_inputs(i)
        if ~returnVars(i,k)
            caststr1 ='';
            caststr2 = ';';
            if ~exist(string(types(i,k)))
                caststr1 = strcat('int', string(type_bits(i,k)), '(');
                caststr2 = ');';
            end
            var_input = strcat('input_struct.', names(i), '.', string(clean_vars(i,k)), '=', caststr1, string(clean_vars(i,k)), caststr2);
            fprintf(fid3, '\t\t%s\n', var_input);
        end
    end
    %lib_wrapper_mex('bbic_set_tx_scale',input_struct)
    
    %mexrun = strcat(funcout, 'obj.bbic_api_mex(''', string(names(i)), ''' , input_struct);');
    mexrun = strcat(mex_rtrn, 'bbic_api_mex(''', string(names(i)), ''' , input_struct);');
    fprintf(fid3, '\t\t%s\n', mexrun);
    fprintf(fid3, '\tcatch\n');
    fprintf(fid3, '\t\tinput_struct2.%s = temp;', string(names(i)));
    fprintf(fid3, '\n\t\twarning(''Problem using function. Check needed types of input'');');
    fprintf(fid3, '\n\tend\n');
    ret_val_cnt = 1;
    for k = 1:num_inputs(i)
        strct2strct = strcat('input_struct.', names(i), '.', string(clean_vars(i,k)), '=', 'input_struct2.', names(i), '.', string(clean_vars(i,k)), ';');
        fprintf(fid3, '\n\t%s\n', strct2strct);
        if returnVars(i,k)
            rtrn_line = strcat(clean_vars(i,k), '_rtrn = ', 'input_struct.', names(i), '.', string(clean_vars(i,k)), ';');
            fprintf(fid3, '\n\t%s\n', rtrn_line);
            ret_val_cnt = ret_val_cnt + 1;
        end
    end
    fprintf(fid3, '\n\tclear input_struct\n\tclear input_struct2');
    fprintf(fid3, '\nend\n');
    fid3 = fclose(fid3);
end
fid4 = fopen('WAV_654.m','w');
fprintf(fid4, 'classdef WAV_654 < matlab.mixin.SetGet \n \t%% WAV_654\n\t%%   class to allow simple API access for BB chip\n\t%%\n\n');
fprintf(fid4, '\tproperties\n\t\tMexRev;\n\tend\n');
fprintf(fid4, '\n\tmethods\n\t\t%% constructor\n\t\tfunction oBlk = WAV_654(varargin)\n');
fid5 = fopen('..\MEX_Rev.txt','r');
tline = fgetl(fid5);
b = strsplit(tline,' ');
fid5 = fclose(fid5);
Revnum= b(2);
fprintf(fid4,'\t\t\toBlk.MexRev = %s;\n', string(Revnum));
fprintf(fid4,'\t\t\tglobal input_struct\n\t\t\tinput_struct =[];\n ');
fprintf(fid4,'\t\t\ts = which(''input_struct.mat''); \n');
fprintf(fid4,'\t\t\tload(s, ''input_struct'');\n');
fprintf(fid4,'\t\t\tclear input_struct\n\t\tend\n\tend\n\n');
fprintf(fid4,'\tmethods (Sealed)\n');
for i =1:num_funcs
    if or(string(returnVal(i)) ~= 'void', rtrn_vars(i)>0)
        str = char(rtrn_vec_all(i));
        fprintf(fid4,'\n\t\t%s', str(2:end));
    else
        fprintf(fid4,'\n\t\t');
    end
    fprintf(fid4,'%s',strcat(string(names(i)),'(obj'));
    for k = 1:num_inputs(i)
        fprintf(fid4, ', %s', string(clean_vars(i,k)));
    end
    fprintf(fid4,');');
end
fprintf(fid4,'\n\tend\nend');
fid4 = fclose(fid4);

cd '..\..\source'
fid5 = fopen('chip_rev_header.h', 'w'); % deleting the content of chip_rev_header. needed only for mex compilation
fprintf(fid5, '//Mex compiled for A0 and B0\n') ;                         % Save to file.
fclose(fid5);

