classdef WAV_654 < matlab.mixin.SetGet 
 	% WAV_654
	%   class to allow simple API access for BB chip
	%

	properties
		MexRev;
	end

	methods
		% constructor
		function oBlk = WAV_654(varargin)
			oBlk.MexRev = 1.5;
			global input_struct
			input_struct =[];
 			s = which('input_struct.mat'); 
			load(s, 'input_struct');
			clear input_struct
		end
	end

	methods (Sealed)

		[AntMsk_rtrn,NumOfAnt_rtrn] =bbic_get_rx_ant_mask(obj, AntMsk, NumOfAnt);
		bbic_tx_reset(obj);
		bbic_set_tx_reset(obj);
		bbic_release_tx_reset(obj);
		bbic_set_endless_tx_reset(obj);
		bbic_rxon(obj, AntMsk);
		bbic_rxoff(obj, AntMsk);
		bbic_txon(obj, AntMsk);
		bbic_txoff(obj, AntMsk);
		bbic_auxadc_on(obj, AntMsk);
		bbic_auxadc_off(obj, AntMsk);
		bbic_rxon_all(obj, AntMsk);
		bbic_iqram_read_trigger(obj, AntMsk);
		bbic_bypass_ram_xtalk(obj, AntMsk, BypassRamMode);
		bbic_bypass_ram_fdl(obj, AntMsk, BypassRamMode);
		bbic_write_ram_fdl(obj, AntMsk, BwIdx, CoeffArray);
		[CoeffArray_rtrn] =bbic_read_ram_fdl(obj, AntMsk, BwIdx, CoeffArray);
		bbic_write_ram_xtalk(obj, AntMsk, BwIdx, CoeffArrayKa, CoeffArrayKb);
		[CoeffArrayKa_rtrn,CoeffArrayKb_rtrn] =bbic_read_ram_xtalk(obj, AntMsk, BwIdx, CoeffArrayKa, CoeffArrayKb);
		bbic_enable_iir(obj, AntMsk, IsEnabled);
		bbic_set_iir_shift(obj, AntMsk, IirShift);
		[IirShift_rtrn] =bbic_get_iir_shift(obj, AntMsk, IirShift);
		bbic_enable_xtalk(obj, AntMsk, IsEnabled);
		bbic_set_xtalk_coeffs(obj, AntMsk, Ka, Kb);
		[Ka_rtrn,Kb_rtrn] =bbic_get_xtalk_coeffs_pm(obj, AntMsk, Ka, Kb);
		[Ka_rtrn,Kb_rtrn] =bbic_get_xtalk_coeffs(obj, AntMsk, Ka, Kb);
		bbic_enable_decorr(obj, AntMsk, IsEnabled);
		bbic_set_decorr_coeffs(obj, AntMsk, W1, W2, BW);
		[W1_rtrn,W2_rtrn] =bbic_get_decorr_coeffs(obj, AntMsk, W1, W2, BW);
		bbic_enable_fdl(obj, AntMsk, IsEnabled);
		bbic_set_fdl_coeffs(obj, AntMsk, D);
		[D_rtrn] =bbic_get_fdl_coeffs_pm(obj, AntMsk, D);
		[D_rtrn] =bbic_get_fdl_coeffs(obj, AntMsk, D);
		bbic_set_accum_nos(obj, AntMsk, NOS);
		bbic_set_accum_shift(obj, AntMsk, AccumShift);
		bbic_set_accum_params(obj, AntMsk, NOS, DCMode, RssiMode, Rate, AccumShift);
		bbic_start_accum(obj, AntMsk);
		[output] =bbic_wait_accum(obj, AntMsk, Timeout);
		[pAccumResults_rtrn,pAccumOF_rtrn] =bbic_get_accum(obj, AntMsk, pAccumResults, pAccumOF);
		[output,pAccumResults_rtrn,AccumOF_rtrn] =bbic_read_accum(obj, AntMsk, Timeout, pAccumResults, AccumOF);
		bbic_set_goert_tone(obj, AntMsk, Tone);
		bbic_set_goert_length(obj, AntMsk, Length);
		bbic_set_goert_cycles(obj, AntMsk, NumOfCycles);
		bbic_set_goert_params(obj, AntMsk, Length, NumOfCycles, Tone0, Tone1);
		bbic_start_goert(obj, AntMsk);
		[output] =bbic_wait_goert(obj, AntMsk, Timeout);
		[pGoertResult_rtrn] =bbic_get_goert(obj, AntMsk, pGoertResult);
		[output,pGoertResult_rtrn] =bbic_read_goert(obj, AntMsk, Timeout, pGoertResult);
		bbic_reset_channel_filter(obj);
		bbic_reset_rxtd(obj, IsEnabled);
		bbic_enable_rxtd_fifo(obj, IsEnabled);
		bbic_enable_detector(obj, IsEnabled);
		bbic_enable_cal_mode(obj, IsEnabled);
		bbic_set_lms_params(obj, AntMsk, CalMode, NumOfSteps, Mu, Alpha);
		bbic_set_valid_coeffs(obj, AntMsk, NumOfEnabledCoeffs);
		bbic_set_lms_cal_mode(obj, AntMsk, NlmsCalMode);
		bbic_set_bypass_ram_coeffs(obj, AntMsk, BypassRamMode);
		bbic_start_lms_cycle(obj, AntMsk);
		bbic_adc_onoff(obj, AdcStatus);
		bbic_enable_fir(obj, AntMsk, BypassFirStatus);
		bbic_set_iq_delays(obj, AntMsk, EqLength_q, IqFirDelay);
		[pCoeffs_rtrn] =bbic_get_fir_coeffs(obj, AntMsk, pCoeffs);
		bbic_set_fir_coeffs_to_progmodel(obj, AntMsk, pCoeffs);
		[pCoeffs_rtrn] =bbic_get_fir_coeffs_from_progmodel(obj, AntMsk, pCoeffs);
		[pErrorInd_rtrn,pErrorValid_rtrn] =bbic_get_lms_error_indicator(obj, AntMsk, pErrorInd, pErrorValid);
		bbic_write_ram_fir_coeffs(obj, AntMsk, pCoeffs, iBW, PgcSetting);
		[pCoeffs_rtrn] =bbic_read_ram_fir_coeffs(obj, AntMsk, pCoeffs, iBW, PgcSetting);
		bbic_lms_reset(obj);
		bbic_enable_clk_bypass(obj, IsEnabled);
		bbic_mac_emu_set_tcr0_common(obj);
		bbic_mac_emu_set_inter_packet_gap(obj, Gap);
		bbic_mac_emu_activate(obj);
		bbic_mac_emu_deactivate(obj);
		bbic_mac_emu_set_endless(obj, IsEnabled);
		bbic_mac_emu_set_scrambler(obj, IsEnabled);
		bbic_set_tcr_for_cal(obj, AntMsk, RfPow, BW, DefaultTCRs, ReadFromPM);
		bbic_mac_emu_set_tcr(obj, AntMsk, RfPow, BW, packet_format, mcs, nss, packet_length, ldpc);
		bbic_mac_emu_set_num_of_packets(obj, num_of_packets);
		bbic_set_difi2_gain(obj, AntMsk, DifiGain);
		[pDifiGain_rtrn] =bbic_read_difi2_gain(obj, AntMsk, pDifiGain);
		bbic_set_dc_cancellation_mode(obj, AntMsk, DcCancelOn);
		bbic_enable_difi2_gain_agc(obj, AntMsk, EnableDifi2Control);
		bbic_enable_dc_accelerator(obj, AntMsk, EnableDcAccelerator);
		bbic_write_dc_values_to_pm(obj, AntMsk, pDcRegsI, pDcRegsQ);
		[pDcRegsI_rtrn,pDcRegsQ_rtrn] =bbic_read_dc_values_from_pm(obj, AntMsk, pDcRegsI, pDcRegsQ);
		[output,pDCVer_rtrn] =bbic_verify_DC_results(obj, AntMsk, pDcRegsI, pDcRegsQ, pAccumOF, pDCVer, SuccessVal_uV);
		bbic_write_ram_DC(obj, AntMsk, pDcRegsI, pDcRegsQ, pDCVer, Pgc_Gain_dB, lnagainidx, iBW);
		[pDcRegsI_rtrn,pDcRegsQ_rtrn] =bbic_read_ram_DC(obj, AntMsk, pDcRegsI, pDcRegsQ, Pgc_Gain_dB, lnagainidx, iBW);
		[pDcRegsI_rtrn,pDcRegsQ_rtrn] =bbic_accum_avg_DC(obj, AntMsk, pAccumResults, pDcRegsI, pDcRegsQ, NOS);
		bbic_clear_dc_values_ram(obj, AntMsk);
		[pDCmV_I_rtrn,pDCmV_Q_rtrn] =accum_dc_to_uv(obj, pAccumResults, NOS, pDCmV_I, pDCmV_Q);
		bbic_set_tx_dc_to_progmodel(obj, AntMsk, DcOffset_i, DcOffset_q, offset_ser);
		[pDcOffset_i_rtrn,pDcOffset_q_rtrn] =bbic_get_tx_dc_from_progmodel(obj, AntMsk, pDcOffset_i, pDcOffset_q, offset_ser);
		bbic_set_tx_dpd_bypass(obj, AntMsk, Dpd_bypass);
		bbic_enable_tx_11b_mode(obj, AntMsk, Enable_11b);
		bbic_set_tx_iq_coefficients(obj, AntMsk, Bin, a, b);
		[a_rtrn,b_rtrn] =bbic_get_tx_iq_coefficients(obj, AntMsk, Bin, a, b);
		bbic_clear_all_tx_iq_coefficients(obj, AntMsk);
		[output] =tone2idx(obj, Tone);
		[output] =bbic_generate_multi_tone_gen(obj, tones, numOfTones, scale, digGain, AntMsk);
		[output] =bbic_generate_tone_gen(obj, tone, scale, digGain, AntMsk);
		bbic_clear_and_disable_tone_gen(obj, AntMsk);
		bbic_set_gen_tone(obj, Tone);
		bbic_clear_gen_tone(obj, Tone);
		bbic_set_gen_two_tones(obj, Tone1, Tone2);
		bbic_clear_gen_two_tones(obj, Tone1, Tone2);
		bbic_set_gen_missing_tone(obj, ToneStart, ToneStop, ToneMissing);
		bbic_clear_gen_tone_all(obj);
		bbic_enable_tone_gen(obj, isEnabled);
		bbic_start_tone_gen(obj);
		[output] =bbic_wait_tone_gen(obj, Timeout);
		bbic_set_tx_diggain(obj, AntMsk, DigGain);
		[DigGain_rtrn] =bbic_get_tx_diggain(obj, AntMsk, DigGain);
		bbic_enable_tpc_accelerator(obj, AntMsk, IsEnabled);
		bbic_set_tx_pgc2_gain_select(obj, AntMsk, tpcgainidx);
		bbic_set_tx_scale(obj, AntMsk, TxTdScale);
		bbic_set_gen_backoff(obj, AntMsk);
		bbic_enable_streamer(obj, StreamerMode, IsEnabled);
		bbic_set_streamer_size(obj, Length, Offset);
		bbic_streamer_txon(obj, AntMsk);
		bbic_streamer_txoff(obj, AntMsk);
		[output] =fxp_limit_sign(obj, Val, Bits);
		[output] =fxp_limit_unsign(obj, Val, Bits);
		bbic_detector_rotate(obj);
		[tempsens_raw_rtrn] =bbic_get_soc_tempsens(obj, Timeout, tempsens_raw);
		[voltsens_raw_rtrn] =bbic_get_soc_voltsens(obj, Timeout, voltsens_raw);
		bbic_set_tx_power_table_offset(obj, AntIdx, BwIdx, rf_power_offset_val);
		[rf_power_offset_val_rtrn] =bbic_get_tx_power_table_offset(obj, AntIdx, BwIdx, rf_power_offset_val);
		bbic_set_tx_open_loop(obj, AntMsk, OpenLoopIsEnabled);
		[OpenLoopIsEnabled_rtrn] =bbic_get_tx_open_loop(obj, AntMsk, OpenLoopIsEnabled);
		bbic_set_tx_power_coef(obj, AntIdx, BWIdx, RegionIdx, Coef_A, Coef_B);
		[PowerThreshold_rtrn] =bbic_get_tx_power_PowerThreshold(obj, AntIdx, BWIdx, RegionIdx, PowerThreshold);
		[Coef_C_rtrn] =bbic_get_tx_power_Coef_C(obj, AntIdx, BWIdx, RegionIdx, Coef_C);
		[rssiValues_rtrn] =bbic_get_rssi(obj, AntMsk, rssiValues);
		bbic_set_lna_gain_lut(obj, AntIdx, LnaGainValues);
		[LnaGainValues_rtrn] =bbic_get_lna_gain_lut(obj, AntIdx, LnaGainValues);
		bbic_set_rx_non_agg_test_mode(obj, RxNonAggIsEnabled);
		[RxNonAggIsEnabled_rtrn] =bbic_get_rx_non_agg_test_mode(obj, RxNonAggIsEnabled);
		bbic_bypass_phy_frc(obj, AntMsk, BypassFRCMode);
		[Frc_status_rtrn] =bbic_get_bypass_phy_frc_status(obj, AntMsk, Frc_status);
		bbic_bypass_phy_fdl(obj, AntMsk, BypassPhyFDLMode);
		[PhyFDL_status_rtrn] =bbic_get_bypass_phy_fdl_status(obj, AntMsk, PhyFDL_status);
		bbic_set_detector_reset_th(obj, DetectorResetMode);
		[output] =bbic_get_detector_reset_th(obj);
		bbic_enable_11b_detector(obj, Enable_Detector_11b);
		[output] =bbic_get_11b_detector_state(obj);
		bbic_set_rx_Sc2FcPhase(obj, AntMsk, RxSc2FcPhase);
		[RxSc2FcPhase_rtrn] =bbic_get_rx_Sc2FcPhase(obj, AntMsk, RxSc2FcPhase);
		bbic_set_tx_Sc2FcPhase(obj, AntMsk, TxSc2FcPhase);
		[TxSc2FcPhase_rtrn] =bbic_get_tx_Sc2FcPhase(obj, AntMsk, TxSc2FcPhase);
		bbic_set_PgcFiltLut(obj, AntMsk, PgcFiltLUT_local);
		bbic_set_rx_rssi_coef(obj, AntIdx, RegionIdx, Coef_A, Coef_B);
		[Coef_A_rtrn,Coef_B_rtrn] =bbic_get_rx_rssi_coef(obj, AntIdx, RegionIdx, Coef_A, Coef_B);
		bbic_set_rx_rssi_offset1(obj, AntIdx, RegionIdx, offset1);
		[offset1_rtrn] =bbic_get_rx_rssi_offset1(obj, AntIdx, RegionIdx, offset1);
		[Rev_rtrn] =bbic_api_chip_rev(obj, Rev);
		bbic_tx_fft_in_scale(obj, AntMsk, ScaleFactor);
	end
end