function y = bbic_api(func_name, input_struct)  %#codegen
global input_struct2
input_struct2 = input_struct;
y=0;
switch(func_name)
	case 'bbic_get_rx_ant_mask' 
		coder.ceval('bbic_get_rx_ant_mask', coder.ref(input_struct2.bbic_get_rx_ant_mask.AntMsk), coder.ref(input_struct2.bbic_get_rx_ant_mask.NumOfAnt));
	case 'bbic_tx_reset' 
		coder.ceval('bbic_tx_reset');
	case 'bbic_set_tx_reset' 
		coder.ceval('bbic_set_tx_reset');
	case 'bbic_release_tx_reset' 
		coder.ceval('bbic_release_tx_reset');
	case 'bbic_set_endless_tx_reset' 
		coder.ceval('bbic_set_endless_tx_reset');
	case 'bbic_rxon' 
		coder.ceval('bbic_rxon', input_struct2.bbic_rxon.AntMsk);
	case 'bbic_rxoff' 
		coder.ceval('bbic_rxoff', input_struct2.bbic_rxoff.AntMsk);
	case 'bbic_txon' 
		coder.ceval('bbic_txon', input_struct2.bbic_txon.AntMsk);
	case 'bbic_txoff' 
		coder.ceval('bbic_txoff', input_struct2.bbic_txoff.AntMsk);
	case 'bbic_auxadc_on' 
		coder.ceval('bbic_auxadc_on', input_struct2.bbic_auxadc_on.AntMsk);
	case 'bbic_auxadc_off' 
		coder.ceval('bbic_auxadc_off', input_struct2.bbic_auxadc_off.AntMsk);
	case 'bbic_rxon_all' 
		coder.ceval('bbic_rxon_all', input_struct2.bbic_rxon_all.AntMsk);
	case 'bbic_iqram_read_trigger' 
		coder.ceval('bbic_iqram_read_trigger', input_struct2.bbic_iqram_read_trigger.AntMsk);
	case 'bbic_bypass_ram_xtalk' 
		coder.ceval('bbic_bypass_ram_xtalk', input_struct2.bbic_bypass_ram_xtalk.AntMsk, input_struct2.bbic_bypass_ram_xtalk.BypassRamMode);
	case 'bbic_bypass_ram_fdl' 
		coder.ceval('bbic_bypass_ram_fdl', input_struct2.bbic_bypass_ram_fdl.AntMsk, input_struct2.bbic_bypass_ram_fdl.BypassRamMode);
	case 'bbic_write_ram_fdl' 
		coder.ceval('bbic_write_ram_fdl', input_struct2.bbic_write_ram_fdl.AntMsk, input_struct2.bbic_write_ram_fdl.BwIdx, coder.ref(input_struct2.bbic_write_ram_fdl.CoeffArray));
	case 'bbic_read_ram_fdl' 
		coder.ceval('bbic_read_ram_fdl', input_struct2.bbic_read_ram_fdl.AntMsk, input_struct2.bbic_read_ram_fdl.BwIdx, coder.ref(input_struct2.bbic_read_ram_fdl.CoeffArray));
	case 'bbic_write_ram_xtalk' 
		coder.ceval('bbic_write_ram_xtalk', input_struct2.bbic_write_ram_xtalk.AntMsk, input_struct2.bbic_write_ram_xtalk.BwIdx, coder.ref(input_struct2.bbic_write_ram_xtalk.CoeffArrayKa), coder.ref(input_struct2.bbic_write_ram_xtalk.CoeffArrayKb));
	case 'bbic_read_ram_xtalk' 
		coder.ceval('bbic_read_ram_xtalk', input_struct2.bbic_read_ram_xtalk.AntMsk, input_struct2.bbic_read_ram_xtalk.BwIdx, coder.ref(input_struct2.bbic_read_ram_xtalk.CoeffArrayKa), coder.ref(input_struct2.bbic_read_ram_xtalk.CoeffArrayKb));
	case 'bbic_enable_iir' 
		coder.ceval('bbic_enable_iir', input_struct2.bbic_enable_iir.AntMsk, input_struct2.bbic_enable_iir.IsEnabled);
	case 'bbic_set_iir_shift' 
		coder.ceval('bbic_set_iir_shift', input_struct2.bbic_set_iir_shift.AntMsk, coder.ref(input_struct2.bbic_set_iir_shift.IirShift));
	case 'bbic_get_iir_shift' 
		coder.ceval('bbic_get_iir_shift', input_struct2.bbic_get_iir_shift.AntMsk, coder.ref(input_struct2.bbic_get_iir_shift.IirShift));
	case 'bbic_enable_xtalk' 
		coder.ceval('bbic_enable_xtalk', input_struct2.bbic_enable_xtalk.AntMsk, input_struct2.bbic_enable_xtalk.IsEnabled);
	case 'bbic_set_xtalk_coeffs' 
		coder.ceval('bbic_set_xtalk_coeffs', input_struct2.bbic_set_xtalk_coeffs.AntMsk, coder.ref(input_struct2.bbic_set_xtalk_coeffs.Ka), coder.ref(input_struct2.bbic_set_xtalk_coeffs.Kb));
	case 'bbic_get_xtalk_coeffs_pm' 
		coder.ceval('bbic_get_xtalk_coeffs_pm', input_struct2.bbic_get_xtalk_coeffs_pm.AntMsk, coder.ref(input_struct2.bbic_get_xtalk_coeffs_pm.Ka), coder.ref(input_struct2.bbic_get_xtalk_coeffs_pm.Kb));
	case 'bbic_get_xtalk_coeffs' 
		coder.ceval('bbic_get_xtalk_coeffs', input_struct2.bbic_get_xtalk_coeffs.AntMsk, coder.ref(input_struct2.bbic_get_xtalk_coeffs.Ka), coder.ref(input_struct2.bbic_get_xtalk_coeffs.Kb));
	case 'bbic_enable_decorr' 
		coder.ceval('bbic_enable_decorr', input_struct2.bbic_enable_decorr.AntMsk, input_struct2.bbic_enable_decorr.IsEnabled);
	case 'bbic_set_decorr_coeffs' 
		coder.ceval('bbic_set_decorr_coeffs', input_struct2.bbic_set_decorr_coeffs.AntMsk, coder.ref(input_struct2.bbic_set_decorr_coeffs.W1), coder.ref(input_struct2.bbic_set_decorr_coeffs.W2), input_struct2.bbic_set_decorr_coeffs.BW);
	case 'bbic_get_decorr_coeffs' 
		coder.ceval('bbic_get_decorr_coeffs', input_struct2.bbic_get_decorr_coeffs.AntMsk, coder.ref(input_struct2.bbic_get_decorr_coeffs.W1), coder.ref(input_struct2.bbic_get_decorr_coeffs.W2), input_struct2.bbic_get_decorr_coeffs.BW);
	case 'bbic_enable_fdl' 
		coder.ceval('bbic_enable_fdl', input_struct2.bbic_enable_fdl.AntMsk, input_struct2.bbic_enable_fdl.IsEnabled);
	case 'bbic_set_fdl_coeffs' 
		coder.ceval('bbic_set_fdl_coeffs', input_struct2.bbic_set_fdl_coeffs.AntMsk, coder.ref(input_struct2.bbic_set_fdl_coeffs.D));
	case 'bbic_get_fdl_coeffs_pm' 
		coder.ceval('bbic_get_fdl_coeffs_pm', input_struct2.bbic_get_fdl_coeffs_pm.AntMsk, coder.ref(input_struct2.bbic_get_fdl_coeffs_pm.D));
	case 'bbic_get_fdl_coeffs' 
		coder.ceval('bbic_get_fdl_coeffs', input_struct2.bbic_get_fdl_coeffs.AntMsk, coder.ref(input_struct2.bbic_get_fdl_coeffs.D));
	case 'bbic_set_accum_nos' 
		coder.ceval('bbic_set_accum_nos', input_struct2.bbic_set_accum_nos.AntMsk, coder.ref(input_struct2.bbic_set_accum_nos.NOS));
	case 'bbic_set_accum_shift' 
		coder.ceval('bbic_set_accum_shift', input_struct2.bbic_set_accum_shift.AntMsk, coder.ref(input_struct2.bbic_set_accum_shift.AccumShift));
	case 'bbic_set_accum_params' 
		coder.ceval('bbic_set_accum_params', input_struct2.bbic_set_accum_params.AntMsk, coder.ref(input_struct2.bbic_set_accum_params.NOS), coder.ref(input_struct2.bbic_set_accum_params.DCMode), coder.ref(input_struct2.bbic_set_accum_params.RssiMode), coder.ref(input_struct2.bbic_set_accum_params.Rate), coder.ref(input_struct2.bbic_set_accum_params.AccumShift));
	case 'bbic_start_accum' 
		coder.ceval('bbic_start_accum', input_struct2.bbic_start_accum.AntMsk);
	case 'bbic_wait_accum' 
		y = coder.ceval('bbic_wait_accum', input_struct2.bbic_wait_accum.AntMsk, input_struct2.bbic_wait_accum.Timeout);
	case 'bbic_get_accum' 
		coder.ceval('bbic_get_accum', input_struct2.bbic_get_accum.AntMsk, coder.ref(input_struct2.bbic_get_accum.pAccumResults), coder.ref(input_struct2.bbic_get_accum.pAccumOF));
	case 'bbic_read_accum' 
		y = coder.ceval('bbic_read_accum', input_struct2.bbic_read_accum.AntMsk, input_struct2.bbic_read_accum.Timeout, coder.ref(input_struct2.bbic_read_accum.pAccumResults), coder.ref(input_struct2.bbic_read_accum.AccumOF));
	case 'bbic_set_goert_tone' 
		coder.ceval('bbic_set_goert_tone', input_struct2.bbic_set_goert_tone.AntMsk, coder.ref(input_struct2.bbic_set_goert_tone.Tone));
	case 'bbic_set_goert_length' 
		coder.ceval('bbic_set_goert_length', input_struct2.bbic_set_goert_length.AntMsk, coder.ref(input_struct2.bbic_set_goert_length.Length));
	case 'bbic_set_goert_cycles' 
		coder.ceval('bbic_set_goert_cycles', input_struct2.bbic_set_goert_cycles.AntMsk, coder.ref(input_struct2.bbic_set_goert_cycles.NumOfCycles));
	case 'bbic_set_goert_params' 
		coder.ceval('bbic_set_goert_params', input_struct2.bbic_set_goert_params.AntMsk, coder.ref(input_struct2.bbic_set_goert_params.Length), coder.ref(input_struct2.bbic_set_goert_params.NumOfCycles), coder.ref(input_struct2.bbic_set_goert_params.Tone0), coder.ref(input_struct2.bbic_set_goert_params.Tone1));
	case 'bbic_start_goert' 
		coder.ceval('bbic_start_goert', input_struct2.bbic_start_goert.AntMsk);
	case 'bbic_wait_goert' 
		y = coder.ceval('bbic_wait_goert', input_struct2.bbic_wait_goert.AntMsk, input_struct2.bbic_wait_goert.Timeout);
	case 'bbic_get_goert' 
		coder.ceval('bbic_get_goert', input_struct2.bbic_get_goert.AntMsk, coder.ref(input_struct2.bbic_get_goert.pGoertResult));
	case 'bbic_read_goert' 
		y = coder.ceval('bbic_read_goert', input_struct2.bbic_read_goert.AntMsk, input_struct2.bbic_read_goert.Timeout, coder.ref(input_struct2.bbic_read_goert.pGoertResult));
	case 'bbic_reset_channel_filter' 
		coder.ceval('bbic_reset_channel_filter');
	case 'bbic_reset_rxtd' 
		coder.ceval('bbic_reset_rxtd', input_struct2.bbic_reset_rxtd.IsEnabled);
	case 'bbic_enable_rxtd_fifo' 
		coder.ceval('bbic_enable_rxtd_fifo', input_struct2.bbic_enable_rxtd_fifo.IsEnabled);
	case 'bbic_enable_detector' 
		coder.ceval('bbic_enable_detector', input_struct2.bbic_enable_detector.IsEnabled);
	case 'bbic_enable_cal_mode' 
		coder.ceval('bbic_enable_cal_mode', input_struct2.bbic_enable_cal_mode.IsEnabled);
	case 'bbic_set_lms_params' 
		coder.ceval('bbic_set_lms_params', input_struct2.bbic_set_lms_params.AntMsk, input_struct2.bbic_set_lms_params.CalMode, input_struct2.bbic_set_lms_params.NumOfSteps, input_struct2.bbic_set_lms_params.Mu, input_struct2.bbic_set_lms_params.Alpha);
	case 'bbic_set_valid_coeffs' 
		coder.ceval('bbic_set_valid_coeffs', input_struct2.bbic_set_valid_coeffs.AntMsk, input_struct2.bbic_set_valid_coeffs.NumOfEnabledCoeffs);
	case 'bbic_set_lms_cal_mode' 
		coder.ceval('bbic_set_lms_cal_mode', input_struct2.bbic_set_lms_cal_mode.AntMsk, input_struct2.bbic_set_lms_cal_mode.NlmsCalMode);
	case 'bbic_set_bypass_ram_coeffs' 
		coder.ceval('bbic_set_bypass_ram_coeffs', input_struct2.bbic_set_bypass_ram_coeffs.AntMsk, input_struct2.bbic_set_bypass_ram_coeffs.BypassRamMode);
	case 'bbic_start_lms_cycle' 
		coder.ceval('bbic_start_lms_cycle', input_struct2.bbic_start_lms_cycle.AntMsk);
	case 'bbic_adc_onoff' 
		coder.ceval('bbic_adc_onoff', input_struct2.bbic_adc_onoff.AdcStatus);
	case 'bbic_enable_fir' 
		coder.ceval('bbic_enable_fir', input_struct2.bbic_enable_fir.AntMsk, input_struct2.bbic_enable_fir.BypassFirStatus);
	case 'bbic_set_iq_delays' 
		coder.ceval('bbic_set_iq_delays', input_struct2.bbic_set_iq_delays.AntMsk, input_struct2.bbic_set_iq_delays.EqLength_q, input_struct2.bbic_set_iq_delays.IqFirDelay);
	case 'bbic_get_fir_coeffs' 
		coder.ceval('bbic_get_fir_coeffs', input_struct2.bbic_get_fir_coeffs.AntMsk, coder.ref(input_struct2.bbic_get_fir_coeffs.pCoeffs));
	case 'bbic_set_fir_coeffs_to_progmodel' 
		coder.ceval('bbic_set_fir_coeffs_to_progmodel', input_struct2.bbic_set_fir_coeffs_to_progmodel.AntMsk, coder.ref(input_struct2.bbic_set_fir_coeffs_to_progmodel.pCoeffs));
	case 'bbic_get_fir_coeffs_from_progmodel' 
		coder.ceval('bbic_get_fir_coeffs_from_progmodel', input_struct2.bbic_get_fir_coeffs_from_progmodel.AntMsk, coder.ref(input_struct2.bbic_get_fir_coeffs_from_progmodel.pCoeffs));
	case 'bbic_get_lms_error_indicator' 
		coder.ceval('bbic_get_lms_error_indicator', input_struct2.bbic_get_lms_error_indicator.AntMsk, coder.ref(input_struct2.bbic_get_lms_error_indicator.pErrorInd), coder.ref(input_struct2.bbic_get_lms_error_indicator.pErrorValid));
	case 'bbic_write_ram_fir_coeffs' 
		coder.ceval('bbic_write_ram_fir_coeffs', input_struct2.bbic_write_ram_fir_coeffs.AntMsk, coder.ref(input_struct2.bbic_write_ram_fir_coeffs.pCoeffs), input_struct2.bbic_write_ram_fir_coeffs.iBW, input_struct2.bbic_write_ram_fir_coeffs.PgcSetting);
	case 'bbic_read_ram_fir_coeffs' 
		coder.ceval('bbic_read_ram_fir_coeffs', input_struct2.bbic_read_ram_fir_coeffs.AntMsk, coder.ref(input_struct2.bbic_read_ram_fir_coeffs.pCoeffs), input_struct2.bbic_read_ram_fir_coeffs.iBW, input_struct2.bbic_read_ram_fir_coeffs.PgcSetting);
	case 'bbic_lms_reset' 
		coder.ceval('bbic_lms_reset');
	case 'bbic_enable_clk_bypass' 
		coder.ceval('bbic_enable_clk_bypass', input_struct2.bbic_enable_clk_bypass.IsEnabled);
	case 'bbic_mac_emu_set_tcr0_common' 
		coder.ceval('bbic_mac_emu_set_tcr0_common');
	case 'bbic_mac_emu_set_inter_packet_gap' 
		coder.ceval('bbic_mac_emu_set_inter_packet_gap', input_struct2.bbic_mac_emu_set_inter_packet_gap.Gap);
	case 'bbic_mac_emu_activate' 
		coder.ceval('bbic_mac_emu_activate');
	case 'bbic_mac_emu_deactivate' 
		coder.ceval('bbic_mac_emu_deactivate');
	case 'bbic_mac_emu_set_endless' 
		coder.ceval('bbic_mac_emu_set_endless', input_struct2.bbic_mac_emu_set_endless.IsEnabled);
	case 'bbic_mac_emu_set_scrambler' 
		coder.ceval('bbic_mac_emu_set_scrambler', input_struct2.bbic_mac_emu_set_scrambler.IsEnabled);
	case 'bbic_set_tcr_for_cal' 
		coder.ceval('bbic_set_tcr_for_cal', input_struct2.bbic_set_tcr_for_cal.AntMsk, input_struct2.bbic_set_tcr_for_cal.RfPow, input_struct2.bbic_set_tcr_for_cal.BW, coder.ref(input_struct2.bbic_set_tcr_for_cal.DefaultTCRs), input_struct2.bbic_set_tcr_for_cal.ReadFromPM);
	case 'bbic_mac_emu_set_tcr' 
		coder.ceval('bbic_mac_emu_set_tcr', input_struct2.bbic_mac_emu_set_tcr.AntMsk, input_struct2.bbic_mac_emu_set_tcr.RfPow, input_struct2.bbic_mac_emu_set_tcr.BW, input_struct2.bbic_mac_emu_set_tcr.packet_format, input_struct2.bbic_mac_emu_set_tcr.mcs, input_struct2.bbic_mac_emu_set_tcr.nss, input_struct2.bbic_mac_emu_set_tcr.packet_length, input_struct2.bbic_mac_emu_set_tcr.ldpc);
	case 'bbic_mac_emu_set_num_of_packets' 
		coder.ceval('bbic_mac_emu_set_num_of_packets', input_struct2.bbic_mac_emu_set_num_of_packets.num_of_packets);
	case 'bbic_set_difi2_gain' 
		coder.ceval('bbic_set_difi2_gain', input_struct2.bbic_set_difi2_gain.AntMsk, coder.ref(input_struct2.bbic_set_difi2_gain.DifiGain));
	case 'bbic_read_difi2_gain' 
		coder.ceval('bbic_read_difi2_gain', input_struct2.bbic_read_difi2_gain.AntMsk, coder.ref(input_struct2.bbic_read_difi2_gain.pDifiGain));
	case 'bbic_set_dc_cancellation_mode' 
		coder.ceval('bbic_set_dc_cancellation_mode', input_struct2.bbic_set_dc_cancellation_mode.AntMsk, input_struct2.bbic_set_dc_cancellation_mode.DcCancelOn);
	case 'bbic_enable_difi2_gain_agc' 
		coder.ceval('bbic_enable_difi2_gain_agc', input_struct2.bbic_enable_difi2_gain_agc.AntMsk, input_struct2.bbic_enable_difi2_gain_agc.EnableDifi2Control);
	case 'bbic_enable_dc_accelerator' 
		coder.ceval('bbic_enable_dc_accelerator', input_struct2.bbic_enable_dc_accelerator.AntMsk, input_struct2.bbic_enable_dc_accelerator.EnableDcAccelerator);
	case 'bbic_write_dc_values_to_pm' 
		coder.ceval('bbic_write_dc_values_to_pm', input_struct2.bbic_write_dc_values_to_pm.AntMsk, coder.ref(input_struct2.bbic_write_dc_values_to_pm.pDcRegsI), coder.ref(input_struct2.bbic_write_dc_values_to_pm.pDcRegsQ));
	case 'bbic_read_dc_values_from_pm' 
		coder.ceval('bbic_read_dc_values_from_pm', input_struct2.bbic_read_dc_values_from_pm.AntMsk, coder.ref(input_struct2.bbic_read_dc_values_from_pm.pDcRegsI), coder.ref(input_struct2.bbic_read_dc_values_from_pm.pDcRegsQ));
	case 'bbic_verify_DC_results' 
		y = coder.ceval('bbic_verify_DC_results', input_struct2.bbic_verify_DC_results.AntMsk, coder.ref(input_struct2.bbic_verify_DC_results.pDcRegsI), coder.ref(input_struct2.bbic_verify_DC_results.pDcRegsQ), coder.ref(input_struct2.bbic_verify_DC_results.pAccumOF), coder.ref(input_struct2.bbic_verify_DC_results.pDCVer), input_struct2.bbic_verify_DC_results.SuccessVal_uV);
	case 'bbic_write_ram_DC' 
		coder.ceval('bbic_write_ram_DC', input_struct2.bbic_write_ram_DC.AntMsk, coder.ref(input_struct2.bbic_write_ram_DC.pDcRegsI), coder.ref(input_struct2.bbic_write_ram_DC.pDcRegsQ), coder.ref(input_struct2.bbic_write_ram_DC.pDCVer), input_struct2.bbic_write_ram_DC.Pgc_Gain_dB, input_struct2.bbic_write_ram_DC.lnagainidx, input_struct2.bbic_write_ram_DC.iBW);
	case 'bbic_read_ram_DC' 
		coder.ceval('bbic_read_ram_DC', input_struct2.bbic_read_ram_DC.AntMsk, coder.ref(input_struct2.bbic_read_ram_DC.pDcRegsI), coder.ref(input_struct2.bbic_read_ram_DC.pDcRegsQ), input_struct2.bbic_read_ram_DC.Pgc_Gain_dB, input_struct2.bbic_read_ram_DC.lnagainidx, input_struct2.bbic_read_ram_DC.iBW);
	case 'bbic_accum_avg_DC' 
		coder.ceval('bbic_accum_avg_DC', input_struct2.bbic_accum_avg_DC.AntMsk, coder.ref(input_struct2.bbic_accum_avg_DC.pAccumResults), coder.ref(input_struct2.bbic_accum_avg_DC.pDcRegsI), coder.ref(input_struct2.bbic_accum_avg_DC.pDcRegsQ), coder.ref(input_struct2.bbic_accum_avg_DC.NOS));
	case 'bbic_clear_dc_values_ram' 
		coder.ceval('bbic_clear_dc_values_ram', input_struct2.bbic_clear_dc_values_ram.AntMsk);
	case 'accum_dc_to_uv' 
		coder.ceval('accum_dc_to_uv', coder.ref(input_struct2.accum_dc_to_uv.pAccumResults), coder.ref(input_struct2.accum_dc_to_uv.NOS), coder.ref(input_struct2.accum_dc_to_uv.pDCmV_I), coder.ref(input_struct2.accum_dc_to_uv.pDCmV_Q));
	case 'bbic_set_tx_dc_to_progmodel' 
		coder.ceval('bbic_set_tx_dc_to_progmodel', input_struct2.bbic_set_tx_dc_to_progmodel.AntMsk, coder.ref(input_struct2.bbic_set_tx_dc_to_progmodel.DcOffset_i), coder.ref(input_struct2.bbic_set_tx_dc_to_progmodel.DcOffset_q), input_struct2.bbic_set_tx_dc_to_progmodel.offset_ser);
	case 'bbic_get_tx_dc_from_progmodel' 
		coder.ceval('bbic_get_tx_dc_from_progmodel', input_struct2.bbic_get_tx_dc_from_progmodel.AntMsk, coder.ref(input_struct2.bbic_get_tx_dc_from_progmodel.pDcOffset_i), coder.ref(input_struct2.bbic_get_tx_dc_from_progmodel.pDcOffset_q), input_struct2.bbic_get_tx_dc_from_progmodel.offset_ser);
	case 'bbic_set_tx_dpd_bypass' 
		coder.ceval('bbic_set_tx_dpd_bypass', input_struct2.bbic_set_tx_dpd_bypass.AntMsk, input_struct2.bbic_set_tx_dpd_bypass.Dpd_bypass);
	case 'bbic_enable_tx_11b_mode' 
		coder.ceval('bbic_enable_tx_11b_mode', input_struct2.bbic_enable_tx_11b_mode.AntMsk, input_struct2.bbic_enable_tx_11b_mode.Enable_11b);
	case 'bbic_set_tx_iq_coefficients' 
		coder.ceval('bbic_set_tx_iq_coefficients', input_struct2.bbic_set_tx_iq_coefficients.AntMsk, input_struct2.bbic_set_tx_iq_coefficients.Bin, coder.ref(input_struct2.bbic_set_tx_iq_coefficients.a), coder.ref(input_struct2.bbic_set_tx_iq_coefficients.b));
	case 'bbic_get_tx_iq_coefficients' 
		coder.ceval('bbic_get_tx_iq_coefficients', input_struct2.bbic_get_tx_iq_coefficients.AntMsk, input_struct2.bbic_get_tx_iq_coefficients.Bin, coder.ref(input_struct2.bbic_get_tx_iq_coefficients.a), coder.ref(input_struct2.bbic_get_tx_iq_coefficients.b));
	case 'bbic_clear_all_tx_iq_coefficients' 
		coder.ceval('bbic_clear_all_tx_iq_coefficients', input_struct2.bbic_clear_all_tx_iq_coefficients.AntMsk);
	case 'tone2idx' 
		y = coder.ceval('tone2idx', input_struct2.tone2idx.Tone);
	case 'bbic_generate_multi_tone_gen' 
		y = coder.ceval('bbic_generate_multi_tone_gen', coder.ref(input_struct2.bbic_generate_multi_tone_gen.tones), input_struct2.bbic_generate_multi_tone_gen.numOfTones, input_struct2.bbic_generate_multi_tone_gen.scale, coder.ref(input_struct2.bbic_generate_multi_tone_gen.digGain), input_struct2.bbic_generate_multi_tone_gen.AntMsk);
	case 'bbic_generate_tone_gen' 
		y = coder.ceval('bbic_generate_tone_gen', input_struct2.bbic_generate_tone_gen.tone, input_struct2.bbic_generate_tone_gen.scale, coder.ref(input_struct2.bbic_generate_tone_gen.digGain), input_struct2.bbic_generate_tone_gen.AntMsk);
	case 'bbic_clear_and_disable_tone_gen' 
		coder.ceval('bbic_clear_and_disable_tone_gen', input_struct2.bbic_clear_and_disable_tone_gen.AntMsk);
	case 'bbic_set_gen_tone' 
		coder.ceval('bbic_set_gen_tone', input_struct2.bbic_set_gen_tone.Tone);
	case 'bbic_clear_gen_tone' 
		coder.ceval('bbic_clear_gen_tone', input_struct2.bbic_clear_gen_tone.Tone);
	case 'bbic_set_gen_two_tones' 
		coder.ceval('bbic_set_gen_two_tones', input_struct2.bbic_set_gen_two_tones.Tone1, input_struct2.bbic_set_gen_two_tones.Tone2);
	case 'bbic_clear_gen_two_tones' 
		coder.ceval('bbic_clear_gen_two_tones', input_struct2.bbic_clear_gen_two_tones.Tone1, input_struct2.bbic_clear_gen_two_tones.Tone2);
	case 'bbic_set_gen_missing_tone' 
		coder.ceval('bbic_set_gen_missing_tone', input_struct2.bbic_set_gen_missing_tone.ToneStart, input_struct2.bbic_set_gen_missing_tone.ToneStop, input_struct2.bbic_set_gen_missing_tone.ToneMissing);
	case 'bbic_clear_gen_tone_all' 
		coder.ceval('bbic_clear_gen_tone_all');
	case 'bbic_enable_tone_gen' 
		coder.ceval('bbic_enable_tone_gen', input_struct2.bbic_enable_tone_gen.isEnabled);
	case 'bbic_start_tone_gen' 
		coder.ceval('bbic_start_tone_gen');
	case 'bbic_wait_tone_gen' 
		y = coder.ceval('bbic_wait_tone_gen', input_struct2.bbic_wait_tone_gen.Timeout);
	case 'bbic_set_tx_diggain' 
		coder.ceval('bbic_set_tx_diggain', input_struct2.bbic_set_tx_diggain.AntMsk, coder.ref(input_struct2.bbic_set_tx_diggain.DigGain));
	case 'bbic_get_tx_diggain' 
		coder.ceval('bbic_get_tx_diggain', input_struct2.bbic_get_tx_diggain.AntMsk, coder.ref(input_struct2.bbic_get_tx_diggain.DigGain));
	case 'bbic_enable_tpc_accelerator' 
		coder.ceval('bbic_enable_tpc_accelerator', input_struct2.bbic_enable_tpc_accelerator.AntMsk, input_struct2.bbic_enable_tpc_accelerator.IsEnabled);
	case 'bbic_set_tx_pgc2_gain_select' 
		coder.ceval('bbic_set_tx_pgc2_gain_select', input_struct2.bbic_set_tx_pgc2_gain_select.AntMsk, input_struct2.bbic_set_tx_pgc2_gain_select.tpcgainidx);
	case 'bbic_set_tx_scale' 
		coder.ceval('bbic_set_tx_scale', input_struct2.bbic_set_tx_scale.AntMsk, input_struct2.bbic_set_tx_scale.TxTdScale);
	case 'bbic_set_gen_backoff' 
		coder.ceval('bbic_set_gen_backoff', input_struct2.bbic_set_gen_backoff.AntMsk);
	case 'bbic_enable_streamer' 
		coder.ceval('bbic_enable_streamer', input_struct2.bbic_enable_streamer.StreamerMode, input_struct2.bbic_enable_streamer.IsEnabled);
	case 'bbic_set_streamer_size' 
		coder.ceval('bbic_set_streamer_size', input_struct2.bbic_set_streamer_size.Length, input_struct2.bbic_set_streamer_size.Offset);
	case 'bbic_streamer_txon' 
		coder.ceval('bbic_streamer_txon', input_struct2.bbic_streamer_txon.AntMsk);
	case 'bbic_streamer_txoff' 
		coder.ceval('bbic_streamer_txoff', input_struct2.bbic_streamer_txoff.AntMsk);
	case 'fxp_limit_sign' 
		y = coder.ceval('fxp_limit_sign', input_struct2.fxp_limit_sign.Val, input_struct2.fxp_limit_sign.Bits);
	case 'fxp_limit_unsign' 
		y = coder.ceval('fxp_limit_unsign', input_struct2.fxp_limit_unsign.Val, input_struct2.fxp_limit_unsign.Bits);
	case 'bbic_detector_rotate' 
		coder.ceval('bbic_detector_rotate');
	case 'bbic_get_soc_tempsens' 
		coder.ceval('bbic_get_soc_tempsens', input_struct2.bbic_get_soc_tempsens.Timeout, coder.ref(input_struct2.bbic_get_soc_tempsens.tempsens_raw));
	case 'bbic_get_soc_voltsens' 
		coder.ceval('bbic_get_soc_voltsens', input_struct2.bbic_get_soc_voltsens.Timeout, coder.ref(input_struct2.bbic_get_soc_voltsens.voltsens_raw));
end
switch(func_name)
	case 'bbic_set_tx_power_table_offset' 
		coder.ceval('bbic_set_tx_power_table_offset', input_struct2.bbic_set_tx_power_table_offset.AntIdx, input_struct2.bbic_set_tx_power_table_offset.BwIdx, input_struct2.bbic_set_tx_power_table_offset.rf_power_offset_val);
	case 'bbic_get_tx_power_table_offset' 
		coder.ceval('bbic_get_tx_power_table_offset', input_struct2.bbic_get_tx_power_table_offset.AntIdx, input_struct2.bbic_get_tx_power_table_offset.BwIdx, coder.ref(input_struct2.bbic_get_tx_power_table_offset.rf_power_offset_val));
	case 'bbic_set_tx_open_loop' 
		coder.ceval('bbic_set_tx_open_loop', input_struct2.bbic_set_tx_open_loop.AntMsk, input_struct2.bbic_set_tx_open_loop.OpenLoopIsEnabled);
	case 'bbic_get_tx_open_loop' 
		coder.ceval('bbic_get_tx_open_loop', input_struct2.bbic_get_tx_open_loop.AntMsk, coder.ref(input_struct2.bbic_get_tx_open_loop.OpenLoopIsEnabled));
	case 'bbic_set_tx_power_coef' 
		coder.ceval('bbic_set_tx_power_coef', input_struct2.bbic_set_tx_power_coef.AntIdx, input_struct2.bbic_set_tx_power_coef.BWIdx, input_struct2.bbic_set_tx_power_coef.RegionIdx, input_struct2.bbic_set_tx_power_coef.Coef_A, input_struct2.bbic_set_tx_power_coef.Coef_B);
	case 'bbic_get_tx_power_PowerThreshold' 
		coder.ceval('bbic_get_tx_power_PowerThreshold', input_struct2.bbic_get_tx_power_PowerThreshold.AntIdx, input_struct2.bbic_get_tx_power_PowerThreshold.BWIdx, input_struct2.bbic_get_tx_power_PowerThreshold.RegionIdx, coder.ref(input_struct2.bbic_get_tx_power_PowerThreshold.PowerThreshold));
	case 'bbic_get_tx_power_Coef_C' 
		coder.ceval('bbic_get_tx_power_Coef_C', input_struct2.bbic_get_tx_power_Coef_C.AntIdx, input_struct2.bbic_get_tx_power_Coef_C.BWIdx, input_struct2.bbic_get_tx_power_Coef_C.RegionIdx, coder.ref(input_struct2.bbic_get_tx_power_Coef_C.Coef_C));
	case 'bbic_get_rssi' 
		coder.ceval('bbic_get_rssi', input_struct2.bbic_get_rssi.AntMsk, coder.ref(input_struct2.bbic_get_rssi.rssiValues));
	case 'bbic_set_lna_gain_lut' 
		coder.ceval('bbic_set_lna_gain_lut', input_struct2.bbic_set_lna_gain_lut.AntIdx, coder.ref(input_struct2.bbic_set_lna_gain_lut.LnaGainValues));
	case 'bbic_get_lna_gain_lut' 
		coder.ceval('bbic_get_lna_gain_lut', input_struct2.bbic_get_lna_gain_lut.AntIdx, coder.ref(input_struct2.bbic_get_lna_gain_lut.LnaGainValues));
	case 'bbic_set_rx_non_agg_test_mode' 
		coder.ceval('bbic_set_rx_non_agg_test_mode', input_struct2.bbic_set_rx_non_agg_test_mode.RxNonAggIsEnabled);
	case 'bbic_get_rx_non_agg_test_mode' 
		coder.ceval('bbic_get_rx_non_agg_test_mode', coder.ref(input_struct2.bbic_get_rx_non_agg_test_mode.RxNonAggIsEnabled));
	case 'bbic_bypass_phy_frc' 
		coder.ceval('bbic_bypass_phy_frc', input_struct2.bbic_bypass_phy_frc.AntMsk, input_struct2.bbic_bypass_phy_frc.BypassFRCMode);
	case 'bbic_get_bypass_phy_frc_status' 
		coder.ceval('bbic_get_bypass_phy_frc_status', input_struct2.bbic_get_bypass_phy_frc_status.AntMsk, coder.ref(input_struct2.bbic_get_bypass_phy_frc_status.Frc_status));
	case 'bbic_bypass_phy_fdl' 
		coder.ceval('bbic_bypass_phy_fdl', input_struct2.bbic_bypass_phy_fdl.AntMsk, input_struct2.bbic_bypass_phy_fdl.BypassPhyFDLMode);
	case 'bbic_get_bypass_phy_fdl_status' 
		coder.ceval('bbic_get_bypass_phy_fdl_status', input_struct2.bbic_get_bypass_phy_fdl_status.AntMsk, coder.ref(input_struct2.bbic_get_bypass_phy_fdl_status.PhyFDL_status));
	case 'bbic_set_detector_reset_th' 
		coder.ceval('bbic_set_detector_reset_th', input_struct2.bbic_set_detector_reset_th.DetectorResetMode);
	case 'bbic_get_detector_reset_th' 
		y = coder.ceval('bbic_get_detector_reset_th');
	case 'bbic_enable_11b_detector' 
		coder.ceval('bbic_enable_11b_detector', input_struct2.bbic_enable_11b_detector.Enable_Detector_11b);
	case 'bbic_get_11b_detector_state' 
		y = coder.ceval('bbic_get_11b_detector_state');
	case 'bbic_set_rx_Sc2FcPhase' 
		coder.ceval('bbic_set_rx_Sc2FcPhase', input_struct2.bbic_set_rx_Sc2FcPhase.AntMsk, input_struct2.bbic_set_rx_Sc2FcPhase.RxSc2FcPhase);
	case 'bbic_get_rx_Sc2FcPhase' 
		coder.ceval('bbic_get_rx_Sc2FcPhase', input_struct2.bbic_get_rx_Sc2FcPhase.AntMsk, coder.ref(input_struct2.bbic_get_rx_Sc2FcPhase.RxSc2FcPhase));
	case 'bbic_set_tx_Sc2FcPhase' 
		coder.ceval('bbic_set_tx_Sc2FcPhase', input_struct2.bbic_set_tx_Sc2FcPhase.AntMsk, input_struct2.bbic_set_tx_Sc2FcPhase.TxSc2FcPhase);
	case 'bbic_get_tx_Sc2FcPhase' 
		coder.ceval('bbic_get_tx_Sc2FcPhase', input_struct2.bbic_get_tx_Sc2FcPhase.AntMsk, coder.ref(input_struct2.bbic_get_tx_Sc2FcPhase.TxSc2FcPhase));
	case 'bbic_set_PgcFiltLut' 
		coder.ceval('bbic_set_PgcFiltLut', input_struct2.bbic_set_PgcFiltLut.AntMsk, coder.ref(input_struct2.bbic_set_PgcFiltLut.PgcFiltLUT_local));
	case 'bbic_set_rx_rssi_coef' 
		coder.ceval('bbic_set_rx_rssi_coef', input_struct2.bbic_set_rx_rssi_coef.AntIdx, input_struct2.bbic_set_rx_rssi_coef.RegionIdx, input_struct2.bbic_set_rx_rssi_coef.Coef_A, input_struct2.bbic_set_rx_rssi_coef.Coef_B);
	case 'bbic_get_rx_rssi_coef' 
		coder.ceval('bbic_get_rx_rssi_coef', input_struct2.bbic_get_rx_rssi_coef.AntIdx, input_struct2.bbic_get_rx_rssi_coef.RegionIdx, coder.ref(input_struct2.bbic_get_rx_rssi_coef.Coef_A), coder.ref(input_struct2.bbic_get_rx_rssi_coef.Coef_B));
	case 'bbic_set_rx_rssi_offset1' 
		coder.ceval('bbic_set_rx_rssi_offset1', input_struct2.bbic_set_rx_rssi_offset1.AntIdx, input_struct2.bbic_set_rx_rssi_offset1.RegionIdx, input_struct2.bbic_set_rx_rssi_offset1.offset1);
	case 'bbic_get_rx_rssi_offset1' 
		coder.ceval('bbic_get_rx_rssi_offset1', input_struct2.bbic_get_rx_rssi_offset1.AntIdx, input_struct2.bbic_get_rx_rssi_offset1.RegionIdx, coder.ref(input_struct2.bbic_get_rx_rssi_offset1.offset1));
	case 'bbic_api_chip_rev' 
		coder.ceval('bbic_api_chip_rev', coder.ref(input_struct2.bbic_api_chip_rev.Rev));
	case 'bbic_tx_fft_in_scale' 
		coder.ceval('bbic_tx_fft_in_scale', input_struct2.bbic_tx_fft_in_scale.AntMsk, input_struct2.bbic_tx_fft_in_scale.ScaleFactor);
end
