/*
 * rfsys_platform.c
 *
 *  Created on: Feb 22, 2018
 *      Author: ldemyan
 * 
 * PLATFORM 
 */
#include "rfsys_platform.h"
#include "mex.h"
//#include "time.h"
//#include<time.h> 
//#include "windows.h"



// ######################################################################################################
// # Platform dependent functions																		#
// ######################################################################################################
void DEBUG_WRITE(uint32 data) 
{
    mxArray  *input_array[1];
    input_array[0] = mxCreateDoubleScalar((double)data);
    mexCallMATLAB(0, NULL, 1, input_array, "DEBUG_WRITE");
}


void BBIC_Reg_Write(uint32 address,uint32 data) 
{
	mxArray  *input_array[2];

	input_array[0] = mxCreateDoubleScalar((double)address);
	input_array[1] = mxCreateDoubleScalar((double)data);

	mexCallMATLAB(0, NULL, 2, input_array, "BBS_HYP_WRITE");
}

uint32_t BBIC_Reg_Read(uint32 address) 
{
	mxArray  *input_array[1];
	mxArray  *output_array[1];
	double *read_par;

	input_array[0] = mxCreateDoubleScalar((double)address);

	mexCallMATLAB(1, output_array, 1, input_array, "BBS_HYP_READ");
	read_par = mxGetPr(output_array[0]);
    DEBUG_WRITE((uint32_t)*read_par);
	return (uint32_t)*read_par;

}

uint32_t BBIC_Time_Stamp(uint8_t mode, uint32_t refTime) {
	uint32_t elapsedTime = 0;
	mxArray  *output_array[1];
	double *read_par;
	uint32_t miliseconds;
	mexCallMATLAB(1, output_array, 0, NULL, "TIME_STAMP");
	read_par = mxGetPr(output_array[0]);
	if (mode == 0)
		elapsedTime = (uint32_t)read_par;
	else
	{
		miliseconds = (uint32_t)read_par - refTime;
		if (miliseconds > 0)
			elapsedTime = miliseconds;
		else //matlab function TIMESTAMP counts miliseconds from the begining of the day. If the function is used at midnight that timestamp will be smaller than the previous one.
		{
			elapsedTime = (uint32_t)read_par;
		}
	}

	return elapsedTime;
}



