/*
 * lib_wav600_api.h
 *
 *  Created on: Sep 3, 2017
 *      Author: delishan
 */
#ifndef LIB_WAV600_API_H_
#define LIB_WAV600_API_H_

#ifndef BBIC_API_ARC
#include "chip_rev_header.h"
#endif

#include "rfsys_platform.h"

#define ANT_OFFSET 	((PHY_RXTD_ANT1_BASE_ADDRESS) - (PHY_RXTD_ANT0_BASE_ADDRESS)) 	// 0x4000 TODO: change to global define antenna offset
#define RAM_FDL_XTALK_BASE_ADDRESS (PHY_RXTD_ANT0_BASE_ADDRESS + 0x2400)			// Base address of the RXIQ FDL+XTALK RAM
#define RAM_FIREQ_BASE_ADDRESS (PHY_RXTD_ANT0_BASE_ADDRESS + 0x2800)				// Base address of the RXIQ FIR equalizer RAM
#define RAM_TONE_GEN_BASE_ADDRESS (PHY_TX_BASE_ADDRESS + 0x4000)				  	// Base address of the Tone Generator RAM (txtd_long_preamble)
#define RAM_RX_DC_BASE_ADDRESS (PHY_RXTD_ANT0_BASE_ADDRESS + 0x3800)	// Base address of the RX DC RAM
#define RAM_TX_IQ_BASE_ADDRESS (PHY_TXTD_ANT0_BASE_ADDRESS + 0x1800)    // Base address of the TX IQ RAM
#define RAM_TX_TSSI_BASE_ADDRESS (PHY_TXTD_ANT0_BASE_ADDRESS + 0x2200)  // Base address of the TX TSSI RAM
#define RAM_RX_PGC_FILTER_BASE_ADDRESS (PHY_RXTD_ANT0_BASE_ADDRESS + 0x3e00)	// Base address of the RX PGC FILTER RAM
#define TXIQ_BIN_BYTE_WIDTH (4)
#define RXDC_RAM_REG_WIDTH (4)
#define TXIQ_BINS_NUM (512) //
#define TSSI_RAM_BW_SIZE (6) 
#define TSSI_RAM_REGINE_SIZE (2) 
#define TAP_OFFSET  (REG_PHY_RXTD_ANT0_PHY_RXTD_ANT_REG11 - REG_PHY_RXTD_ANT0_PHY_RXTD_ANT_REG10)
#define ANT_NUM 	(4)			// TODO: change to global define antenna number
#define ANT_ALL 	(15)	
#define BAND_NUM 	(1)			// TODO: change to global define band number
#define FIR_COEFFS_NUM 	(12)
#define PGC_GAIN_NUM (11)		// number of RFIC PGC gain indexes; [0:2:20] in dB
#define LNA_DC_RAM_GAIN_NUM (8)		// number of LNA gains in the DC RAM
#define LNA_GAIN_NUM	(7) 		// number of effective LNA gain indexes
#define TOTAL_GAINS_NUM 	(PGC_GAIN_NUM * LNA_DC_RAM_GAIN_NUM)	// number of RFIC total gain options - every LNA with every PGC
#define ADC_BITS 	(14) //Number of Bits
#define ADC_FS (3) // ADC full scale in Volts, multipled by 2 (in order to make it integer). Actual value is 1.5.
#define BW_NUM (4)				// number of supported bandwidths; [0,1,2,3] for 20/40/80/160MHz
#define FFT_LENGTH (1024)
#define COS_LUT_LENGTH (FFT_LENGTH / 4)
#define SCALE_FFT_TONE 		 (2)
#define SCALE_FFT_MULTI_TONE (3)


#define SIGN_EXTEND(value, Bits)          if(value  >= (1<< (Bits-1) ) ) value-=(1<<Bits)


// the names conventions for phy registers: bbic_, wav_, phy_rxtd_, etc

// ######################################################################################################
// # General configurations																				#
// ######################################################################################################

/*REG_B0_PHY_RX_TD_PHY_RXTD_REG2F 0xBC */
typedef union
{
	uint32 val; 				//gclk bypass - when '1' clocks will be always active, reset value: 0x0, access type: RW
	struct
	{
		uint32 difi 		: 1; //Difi1, difi2, hyp2_adcif_stb, hyp2_rssi
		uint32 iq_fix 		: 1; //iq_fix_crosstalk, iq_fix_decorrelator, iq_fix_fir_equalizer, iq_fix_dc_iir
		uint32 iq_cal 		: 1; //iq_fix_nlms, iq_fix_estimator, goertzel 0/1, ola
		uint32 fdl 			: 1; //fdl
		uint32 chan_filt	: 1; //frequency_shift1, channel_filter, frequency_shift2, freq_shift_control
		uint32 band_sel 	: 1; //band_select, band_select_routing, bs_dc_iir
		uint32 cca 			: 1; //cca_seg, cca_ant
		uint32 det_fine		: 1; //detector_ant_fine, detector_seg_fine
		uint32 det_coarse	: 1; //detector_ant_coarse, detector_seg_coarse
		uint32 det_aci		: 1; //detector_aci
		uint32 agc_periph	: 1; //agc_peripherals
		uint32 agc_gain		: 1; //agc_gain
		uint32 fcsi 		: 1; //Fcsi, ant_risc_fcsi_arbiter
		uint32 nco	 		: 1; //top_nco(dc_removal, rxtd_nco)
		uint32 rxtd_fifo	: 1; //Rxtd_fifo
		uint32 fft	 		: 1; //fft
		uint32 afe	 		: 1; //Hyp_rxtd_ant_afe
		uint32 rxtd_ant	 	: 1; //Hyp_rxtd_ant
		uint32 lst_smp_ind	: 1; //last sample indication
		uint32 csim	 		: 1; //rxtd_csm
		uint32 dc_manager	: 1; //dc_cancellation_manager
		uint32 delta_f		: 1; //delta_f
		uint32 noise_est	: 1; //noise_est
		uint32 agc_acc_arb	: 1; //agc_acc, risc_fcsi_arbiter, risc_arbiter_logic
		uint32 test_bus		: 1; //hyp_test_absorption_fifo, test bus
		uint32 det_11b		: 1; //detector_11b_selector
		uint32 cp_timing	: 1; //cp_timing
		uint32 gen_risc	 	: 1; //gen_risc
		uint32 he_crc_err 	: 1; //He crc err
		uint32 reserved0 	: 3;
	} bitFields;
} RegB0PhyRxTdPhyRxtdReg2F_RFSys_u;



/*REG_B0_PHY_TX_GCLK_CONTROL 0x3C */
/*
typedef union
{
	uint32 val; //Sub blocks Gated clock bypass, reset value: 0x0, access type: RW
	struct
		{
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32  		: 1; //
			uint32 reserved0 	: 3;
		} bitFields;
} RegB0PhyTxGclkControl_RFSys_u;
*/


int16_t	get_sin_value(int16_t tone);
int16_t	get_cos_value(int16_t tone);
int32_t	matlab_test(int16_t input);

// returns antenna mask and num of antennas per band
void bbic_get_rx_ant_mask (uint8_t* AntMsk_rtrn, uint8_t* NumOfAnt_rtrn);
// reset functions
void bbic_tx_reset(void);
void bbic_set_tx_reset(void);
void bbic_release_tx_reset(void);
void bbic_set_endless_tx_reset(void);
// ######################################################################################################
// # AFE Standby																						#
// ######################################################################################################
void bbic_rxon (uint8_t AntMsk);			// turn ON RX bits according to the antenna mask
void bbic_rxoff (uint8_t AntMsk);			// turn OFF RX bits according to the antenna mask
void bbic_txon (uint8_t AntMsk);			// turn ON TX bits according to the antenna mask
void bbic_txoff (uint8_t AntMsk);			// turn OFF TX bits according to the antenna mask
void bbic_auxadc_on (uint8_t AntMsk);		// turn ON AuxADC according to the antenna mask
void bbic_auxadc_off (uint8_t AntMsk);		// turn OFF AuxADC according to the antenna mask
void bbic_rxon_all (uint8_t AntMsk);		// turn ON simultaneously both RXIQ ADC and AuxADC

// ######################################################################################################
// ### RXIQ 																							#
// ######################################################################################################
// *** RXIQ RAM functions ***
void bbic_iqram_read_trigger(uint8_t AntMsk); 			// Sends a pulse to trigger the IQRAM read operation
void bbic_bypass_ram_xtalk(uint8_t AntMsk, BOOL BypassRamMode);
void bbic_bypass_ram_fdl(uint8_t AntMsk, BOOL BypassRamMode);
//void bbic_block_write(uint8_t AntMsk, uint32_t BaseOffset, uint32_t Array[][ANT_NUM], uint16_t ArraySize, uint8_t WordLength);
//void bbic_block_read(uint8_t AntMsk, uint32_t BaseOffset, uint32_t Array[][ANT_NUM], uint16_t ArraySize);
void bbic_write_ram_fdl(uint8_t AntMsk, uint8_t BwIdx, int16_t CoeffArray[PGC_GAIN_NUM][ANT_NUM]);
void bbic_read_ram_fdl(uint8_t AntMsk, uint8_t BwIdx, int16_t CoeffArray_rtrn[PGC_GAIN_NUM][ANT_NUM]);
void bbic_write_ram_xtalk(uint8_t AntMsk, uint8_t BwIdx, int8_t CoeffArrayKa[PGC_GAIN_NUM][ANT_NUM], int8_t CoeffArrayKb[PGC_GAIN_NUM][ANT_NUM]);
void bbic_read_ram_xtalk(uint8_t AntMsk, uint8_t BwIdx, int8_t CoeffArrayKa_rtrn[PGC_GAIN_NUM][ANT_NUM], int8_t CoeffArrayKb_rtrn[PGC_GAIN_NUM][ANT_NUM]);

// *** IIR ***
void bbic_enable_iir(uint8_t AntMsk, BOOL IsEnabled);
void bbic_set_iir_shift(uint8_t AntMsk, uint8_t IirShift[ANT_NUM]);
void bbic_get_iir_shift(uint8_t AntMsk, uint8_t IirShift_rtrn[ANT_NUM]);
// *** XTALK ***
void bbic_enable_xtalk(uint8_t AntMsk, BOOL IsEnabled);
void bbic_set_xtalk_coeffs(uint8_t AntMsk, uint8_t Ka[ANT_NUM], uint8_t Kb[ANT_NUM]);
void bbic_get_xtalk_coeffs_pm(uint8_t AntMsk, uint8_t Ka_rtrn[ANT_NUM], uint8_t Kb_rtrn[ANT_NUM]);
void bbic_get_xtalk_coeffs(uint8_t AntMsk, uint8_t Ka_rtrn[ANT_NUM], uint8_t Kb_rtrn[ANT_NUM]);
// *** W1W2 ***
void bbic_enable_decorr(uint8_t AntMsk, BOOL IsEnabled);
void bbic_set_decorr_coeffs(uint8_t AntMsk, uint16_t W1[ANT_NUM], int16_t W2[ANT_NUM], uint8_t BW);
void bbic_get_decorr_coeffs(uint8_t AntMsk, uint16_t W1_rtrn[ANT_NUM], int16_t W2_rtrn[ANT_NUM], uint8_t BW);

// ***FDL ***
void bbic_enable_fdl(uint8_t AntMsk, BOOL IsEnabled);
void bbic_set_fdl_coeffs(uint8_t AntMsk, int16_t D[ANT_NUM]);
void bbic_get_fdl_coeffs_pm(uint8_t AntMsk, int16_t D_rtrn[ANT_NUM]);
void bbic_get_fdl_coeffs(uint8_t AntMsk, int16_t D_rtrn[ANT_NUM]);

// *** accumulators functions ***
//Dedicated typedefs
typedef union
{
	uint32_t 	pwrVal:32;  	// pwr value (always positive)
	int32_t 	dcVal:32;		// dc value, signed
} CorrResult_u;

typedef struct
{
	CorrResult_u II;
	CorrResult_u QQ;
	int32_t IQ;
} CorrResults_t;

typedef struct
{
	uint8_t II;
	uint8_t QQ;
	uint8_t IQ;
} CorrOF_t;
// accumulator configuration functions
void bbic_set_accum_nos(uint8_t AntMsk,uint32_t NOS[ANT_NUM]);
void bbic_set_accum_shift(uint8_t AntMsk, uint8_t AccumShift[ANT_NUM]);
void bbic_set_accum_params (uint8_t AntMsk,uint32_t NOS[ANT_NUM], uint8_t DCMode[ANT_NUM], uint8_t RssiMode[ANT_NUM], uint8_t Rate[ANT_NUM], uint8_t AccumShift[ANT_NUM]);
// accumulator reading functions
void bbic_start_accum (uint8_t AntMsk);
uint8_t bbic_wait_accum (uint8_t AntMsk, uint16_t Timeout);
void bbic_get_accum (uint8_t AntMsk, CorrResults_t pAccumResults_rtrn[ANT_NUM], CorrOF_t pAccumOF_rtrn[ANT_NUM]);
// accumulator reading sequence
uint8_t bbic_read_accum (uint8_t AntMsk, uint16_t Timeout, CorrResults_t pAccumResults_rtrn[ANT_NUM], CorrOF_t AccumOF_rtrn[ANT_NUM]);

// *** Goertzel functions ***
typedef union
{
	uint32_t val;
	struct
	{
		int32_t Result:30;	// Goertzel Result.
		uint32_t NA:2;
	} bitFields;
} GoertResult_u;

typedef struct
{
	int32_t      Result_I_Real;
	int32_t      Result_I_Imag;
	int32_t      Result_Q_Real;
	int32_t      Result_Q_Imag;
} GoertzelResults_t;

// Goertzel configuration functions
void bbic_set_goert_tone (uint8_t AntMsk, int16_t Tone[ANT_NUM]);
void bbic_set_goert_length (uint8_t AntMsk,uint32_t Length[ANT_NUM]);
void bbic_set_goert_cycles (uint8_t AntMsk, uint8_t NumOfCycles[ANT_NUM]);
void bbic_set_goert_params (uint8_t AntMsk,uint32_t Length[ANT_NUM], uint8_t NumOfCycles[ANT_NUM], int16_t Tone0[ANT_NUM], int16_t Tone1[ANT_NUM]);
// Goertzel reading functions
void bbic_start_goert (uint8_t AntMsk);
uint8_t bbic_wait_goert (uint8_t AntMsk, uint16_t Timeout);
void bbic_get_goert (uint8_t AntMsk, GoertzelResults_t pGoertResult_rtrn[ANT_NUM]);
// Goertzel reading sequence
uint8_t bbic_read_goert (uint8_t AntMsk, uint16_t Timeout, GoertzelResults_t pGoertResult_rtrn[ANT_NUM]);



//**** Lev's Part
void bbic_reset_channel_filter(void);
/* Resets channel filter 
*/

void bbic_reset_rxtd(BOOL IsEnabled);
/* Reset RXTD - write IsEnabled to 18 LSB of REG_PHY_RX_TD_PHY_RXTD_REG00
IsEnabled - 1/True - enabled, 0/False - Disabled
*/
void bbic_enable_rxtd_fifo(BOOL IsEnabled);
/* Enable/Disable rxtd
IsEnabled - 1/True - enabled, 0/False - Disabled
*/
void bbic_enable_detector(BOOL IsEnabled);
/* Enable/Disable bbic_enable_detector
IsEnabled - 1/True - enabled, 0/False - Disabled
*/
void bbic_enable_cal_mode(BOOL IsEnabled);
/* global Enable/Disable for rxiq calibration mode (estimator, lms, Goertzel & OLA get clocks)
IsEnabled - 1/True - enabled, 0/False - Disabled
*/
void bbic_set_lms_params (uint8_t AntMsk, BOOL CalMode, uint32_t NumOfSteps, uint8_t Mu, uint8_t Alpha);
/* Set LMS parameters
****
The following three parameters are internally set using separate functions:
AntMsk - Antenna mask, CalMode -TRUE/1 for cal mode, FALSE/0 for regular mode (operational FIR if enabled), TRUE/1 for bypassing RAM and using progmodels, FALSE/0 for using values from RAM (RXIQ FIR accelerator),
NumOfEnabledCoeffs -  number of enabled FIR coefficients 
****
The following parameters are set without separate functions:
Mu - LMS convergence parameter - set per LMS cycle, NumOfSteps - Number of steps (iterations) per LMS cycle, Alpha - Error calculation statistical parameter (IIR) 

*/
void bbic_set_valid_coeffs (uint8_t AntMsk, uint32_t NumOfEnabledCoeffs);
/* Enable number of FIR coeffs to be used
AntMsk - Antenna mask, NumOfEnabledCoeffs - number of enabled FIR coefficients
*/
void bbic_set_lms_cal_mode (uint8_t AntMsk, BOOL NlmsCalMode);
/* Set LMS calibration mode
AntMsk - Antenna mask, NlmsCalMode -TRUE/1 for cal mode, FALSE/0 for regular mode (operational FIR if enabled)
*/
void bbic_set_bypass_ram_coeffs (uint8_t AntMsk, BOOL BypassRamMode);
/* Read FIR coeffs from progmodels or from RAM = Enabling RXIQ FIR accelerator
AntMsk - Antenna mask, BypassRamMode - TRUE/1 for bypassing RAM and using progmodels, FALSE/0 for using values from RAM (RXIQ FIR accelerator)
*/
void bbic_start_lms_cycle (uint8_t AntMsk);
/* Start LMS cycle 
AntMsk - Antenna mask
*/
void bbic_adc_onoff (BOOL AdcStatus);
/* Set adc on - global, not per antenna
AdcStatus - TRUE/1 for enable, FALSE/0 for disable
*/
void bbic_enable_fir(uint8_t AntMsk, BOOL BypassFirStatus);
/* Enable RXIQ FIR - 
AntMsk - Antenna mask, BypassFirStatus - TRUE/1 for passing FIR, FALSE/0 for bypass
*/
void bbic_set_iq_delays(uint8_t AntMsk, uint8_t EqLength_q, uint8_t IqFirDelay );
/* Manually set I and Q delays in RXIQ FIR block, to sync between Q line and I line after FIR and to set ventral FIR bin number
AntMsk - Antenna mask, EqLength_q - Manual Q line delay,  IqFirDelay - Central bin number
*/

//void bbic_disable_fir(uint8_t AntMsk);
void bbic_get_fir_coeffs(uint8_t AntMsk, uint32_t pCoeffs_rtrn[ANT_NUM][FIR_COEFFS_NUM]);
/* Read FIR coefficients values from progmodels (registers) - used for temporary storage 
AntMsk - Antenna mask
pCoeffs - pointers to an array that should be filled with values read from the progmodels. The array indices art the antenna number and coefficient number.
*/
void bbic_set_fir_coeffs_to_progmodel(uint8_t AntMsk, uint32_t pCoeffs[ANT_NUM][FIR_COEFFS_NUM]);
/* Write FIR coefficients values to progmodels (registers) - used for temporary storage 
AntMsk - Antenna mask
pCoeffs - A structure of results to be written using the function - 12 coefficients for each antenna
*/
void bbic_get_fir_coeffs_from_progmodel(uint8_t AntMsk, uint32_t pCoeffs_rtrn[ANT_NUM][FIR_COEFFS_NUM]);
/* Read FIR coefficients values to progmodels (registers) - used for temporary storage
AntMsk - Antenna mask
pCoeffs - A structure to be filed using the function - 12 coefficients for each antenna
*/
void bbic_get_lms_error_indicator(uint8_t AntMsk, uint32_t pErrorInd_rtrn[ANT_NUM], uint8_t pErrorValid_rtrn[ANT_NUM]);
/* Read LMS error value
AntMsk - Antenna mask
pErrorInd - A pointer to a structure the errors should be written into using the function - Error per antenna. pErrorValid - A pointer to an array of validity values (if the error is valid it will be 1 for the antenna index).
*/
void bbic_write_ram_fir_coeffs(uint8_t AntMsk, uint32_t pCoeffs[ANT_NUM][FIR_COEFFS_NUM], uint8_t iBW, uint8_t PgcSetting);
/* Write RXIQ FIR coefficients values to RAM RXIQ FIR table
AntMsk - Antenna mask, PgcSetting - PGC gain index (not in dB),  iBW - BW index
pCoeffs - A structure of results to be written using the function - 12 coefficients for each antenna.
*/
void bbic_read_ram_fir_coeffs(uint8_t AntMsk, uint32_t pCoeffs_rtrn[ANT_NUM][FIR_COEFFS_NUM], uint8_t iBW, uint8_t PgcSetting);
/* Read RXIQ FIR coefficients values from RAM RXIQ FIR table
AntMsk - Antenna mask, PgcSetting - PGC gain index (not in dB),  iBW - BW index
pCoeffs - A pointer to a structure of results to be filled from RAM using the function - 12 coefficients for each antenna.
*/
void bbic_lms_reset(void);
/* Reset LMS block
*/
void bbic_enable_clk_bypass(BOOL IsEnabled);
/* Manually set clock bypass to allow concurrent TX and RX operation (for calibration purposes)
*/
void bbic_mac_emu_set_tcr0_common(void);
/*Manually set TCR0 common values for simplest use - not to be used in automatic mode, just for debug
*/
void bbic_mac_emu_set_inter_packet_gap(uint8_t Gap);
/* Manually set inter packet gap,(uSec) in MAC emulator
*/
void bbic_mac_emu_activate(void);
/* Activate MAC emulator
*/
void bbic_mac_emu_deactivate(void);
/* Deactivate MAC emulator - (Stop endless packects.)
*/
void bbic_mac_emu_set_endless(BOOL IsEnabled);
/* Set MAC emulator to endless mode - endless data, one long packet
IsEnabled - MAC emulator endless mode status - TRUE/1 for Endless, FALSE/0 for regular
*/
void bbic_mac_emu_set_scrambler(BOOL IsEnabled);

//void RunMacEmulator(void);
//void SetMacEmulatorEndless(void);
void bbic_set_tcr_for_cal(uint8_t AntMsk, uint8_t RfPow, uint16_t BW, uint32_t  DefaultTCRs[3][4], BOOL ReadFromPM);
/*Manually set all TCR values for simplest use - not to be used in automatic mode, just for debug
AntMsk - Antenna mask, RfPow - RF power, BW - Requested BW, DefaultTCRs - two dimensional array of TCR values to be set
ReadFromPM - Read modify write of relevant values(1) OR override all with values from DefaultTCRs (0) 
*/

void bbic_mac_emu_set_tcr(uint8_t AntMsk, uint8_t RfPow, uint16_t BW, uint8_t packet_format, uint8_t mcs, uint8_t nss, uint32_t packet_length, uint8_t ldpc );
/*Manually set all TCR values for simplest use
//RfPow - set in 0.5dB
// bw:0-20,1-40,2-80,3-160
// packet format: 0 - legacy,1 - 11b,2 - HT,3 - VHT,4 - HE (SU),5 - HE (EX SU),6 - HE (MU – trigger based) (not supported by the Mac), 7- HE (MU – DL) 
// mcs  0 - 11 depands on packet format
// nss - number of streams
//packet lenfth - in bytes
// ldpc - 1 on, 0 - no ldpc
*/
void bbic_mac_emu_set_num_of_packets(uint16_t num_of_packets);
/* Manually Mac emulatir set number of packets to transmit, 0 means endless packets. 
*/

void bbic_set_difi2_gain(uint8_t AntMsk, uint8_t DifiGain[ANT_NUM]);
/* Set difi2 gain
AntMsk - Antenna mask, DifiGain - Gain in d, per antenna
*/
void bbic_read_difi2_gain(uint8_t AntMsk, uint8_t pDifiGain_rtrn[ANT_NUM]);
/* Read difi2 gain value
AntMsk - Antenna mask, pDifiGain - A pionter to an array of DIFI2 gain values in dB to be filled using the function
*/
void bbic_set_dc_cancellation_mode(uint8_t AntMsk, BOOL DcCancelOn);
/* Enable digital dc cancelation
AntMsk - Antenna mask, DcCancelOn - TRUE/1 for enable, FALSE/0 for disable
*/

void bbic_enable_difi2_gain_agc(uint8_t AntMsk, BOOL EnableDifi2Control);
/* Enable difi2 gain control from hw (disable allows manual control)
AntMsk - Antenna mask, EnableDifi2Control - TRUE/1 for disable manual difi2 gain control, FALSE/0 for enable
*/
void bbic_enable_dc_accelerator(uint8_t AntMsk, BOOL EnableDcAccelerator);
/* Enable  dc accelerator (or read digital DC cancelation values from progmodel)
AntMsk - Antenna mask, EnableDcAccelerator - TRUE/1 for reading from RAM , FALSE/0 for reading from progmodel
*/
typedef struct
{
	BOOL      DcSuccessI;
	BOOL      DcSuccessQ;
} DCVerificationResults_t; //DCVerificationResults_t is a type that holds the status of verification of RXDC calibration with two values - one for I and one for Q


//DC verification
void bbic_write_dc_values_to_pm(uint8_t AntMsk, int16_t pDcRegsI[ANT_NUM], int16_t pDcRegsQ[ANT_NUM]);
/* Write DC calibration values to progmodels (registers) - used for temporary storage - two (I,Q) per antenna
AntMsk - Antenna mask
pDCmV_I/Q - arrays of DC cancellation values to be written to pm - Array for I and array for Q(Array index is the antenna number)
*/
void bbic_read_dc_values_from_pm(uint8_t AntMsk, int16_t pDcRegsI_rtrn[ANT_NUM], int16_t pDcRegsQ_rtrn[ANT_NUM]);
/* Read DC calibration values from progmodels (registers) - used for temporary storage - two (I,Q) per antenna
AntMsk - Antenna mask
pDcRegsI, pDcRegsQ - pointers to arrays that should be filled with values read from the progmodels. The array index is the antenna number.
*/
uint8_t  bbic_verify_DC_results(uint8_t AntMsk, int16_t pDcRegsI[ANT_NUM], int16_t pDcRegsQ[ANT_NUM], CorrOF_t pAccumOF[ANT_NUM], DCVerificationResults_t pDCVer_rtrn[ANT_NUM], uint16_t SuccessVal_uV);
/* Verify DC calibration results
AntMsk - Antenna mask, SuccessVal - Threshold for succesful verification
pDcRegsI, pDcRegsQ - arrays with DC cancellation values , pAccumOF - pointer to offset indication from accumulators
pDCVer - DC verification status for I and Q (True/False), SuccessVal_uV - success threshold in uV
*/
void  bbic_write_ram_DC(uint8_t AntMsk, int16_t pDcRegsI[ANT_NUM], int16_t pDcRegsQ[ANT_NUM], DCVerificationResults_t pDCVer[ANT_NUM], uint8_t Pgc_Gain_dB, uint8_t lnagainidx, uint8_t iBW);
/* Write DC calibration values to RAM DC table
AntMsk - Antenna mask, Pgc_Gain_dB - PGC gain in dB, lnagainidx - LNA gain index (comination of internal and external), iBW - BW index
pDCVer - Array of DC verification results (Bool values Success/failure)
pDcRegsI, pDcRegsQ - arrays with DC cancellation values that should be written to RAM. The array index is the antenna number.
*/
void  bbic_read_ram_DC(uint8_t AntMsk, int16_t pDcRegsI_rtrn[ANT_NUM], int16_t pDcRegsQ_rtrn[ANT_NUM], uint8_t Pgc_Gain_dB, uint8_t lnagainidx, uint8_t iBW);
/* Read DC calibration values from RAM DC table
AntMsk - Antenna mask, Pgc_Gain_dB - PGC gain in dB, lnagainidx - LNA gain index (comination of internal and external), iBW - BW index
pDcRegsI, pDcRegsQ - Pointers to arrays of DC cancellation values to be filled from RAM 
*/
void bbic_accum_avg_DC(uint8_t AntMsk, CorrResults_t pAccumResults[ANT_NUM], int16_t pDcRegsI_rtrn[ANT_NUM], int16_t pDcRegsQ_rtrn[ANT_NUM], uint32_t NOS[ANT_NUM]);
/* Convert accumulator readings to DC cancelation values by deviding it by NOS
AntMsk - Antenna mask, pAccumResults - pointer to a structure of accumulator results,  NOS - array of number of samples the accumulators worked on
pDcRegsI/Q - Pointers to arrays of DC cancellation values to be used (calculated in the function) 
*/
void bbic_clear_dc_values_ram(uint8_t AntMsk);
/*Set all Ram DC registers on zero for selected antennas
AntMsk - Antenna mask
*/
void accum_dc_to_uv(CorrResults_t pAccumResults[ANT_NUM], uint32_t NOS[ANT_NUM], int16_t pDCmV_I_rtrn[ANT_NUM], int16_t pDCmV_Q_rtrn[ANT_NUM]);
/* Translate accumulator reads to actual DC values in uV
pAccumResults - pointer to a structure of accumulator results. NOS - Number of samples the accumulator accumulated (array - per antenna)
pDCmV_I/Q - Pointers to arrays of DC cancellation values to be filled by the function (array for I and array for Q, index - antenna)
*/

void bbic_set_tx_dc_to_progmodel(uint8_t AntMsk, int16_t DcOffset_i[ANT_NUM], int16_t DcOffset_q[ANT_NUM], uint8_t offset_ser );
/* Set Tx DC values (BB DAC) to dedicated progmodels
AntMsk - Antenna mask, DcOffset_i/Q - Vectors of DC values per antenna for I/Q, offset_ser - offset setting serial number (TPC)
*/
void bbic_get_tx_dc_from_progmodel(uint8_t AntMsk, int16_t pDcOffset_i_rtrn[ANT_NUM], int16_t pDcOffset_q_rtrn[ANT_NUM], uint8_t offset_ser );
/* Get Tx DC values (BB DAC) from dedicated progmodels
AntMsk - Antenna mask, DcOffset_i/Q - Vectors of DC values per antenna for I/Q, offset_ser - offset setting serial number (TPC)
*/
void bbic_set_tx_dpd_bypass(uint8_t AntMsk, BOOL Dpd_bypass);
/* Set Tx DPD mode (on/bypass)
AntMsk - Antenna mask, Dpd_bypass - DPD mode: 1/TRUE for bypass, 0/FALSE for on
*/
void bbic_enable_tx_11b_mode(uint8_t AntMsk, BOOL Enable_11b);
/* Set Tx 11b mode (on/off)
AntMsk - Antenna mask, Enable_11b - 11b mode: 1/TRUE for enabled, 0/FALSE for disabled
*/
void bbic_set_tx_iq_coefficients(uint8_t AntMsk, int16_t Bin, int16_t  a[ANT_NUM], int16_t  b[ANT_NUM] );
/* Set Tx iq coefficients per bin
AntMsk - Antenna mask, Bin - bin number, a,b - vectors of a,b parameters per antenna for the bin
*/
void bbic_get_tx_iq_coefficients(uint8_t AntMsk, int16_t Bin, int16_t  a_rtrn[ANT_NUM], int16_t  b_rtrn[ANT_NUM] );
/* Set Tx iq coefficients per bin
AntMsk - Antenna mask, Bin - bin number, a,b - vectors to be filled with a,b parameters per antenna for the bin
*/
void bbic_clear_all_tx_iq_coefficients(uint8_t AntMsk);
/* Nullify Tx iq coefficients per antenna
AntMsk - Antenna mask
*/


//**** End of Lev's part

// *** Tone Generator functions ***
uint16_t tone2idx(int16_t Tone);
BOOL bbic_generate_multi_tone_gen(int16_t* tones, int8_t numOfTones, int8_t scale, int16_t digGain[ANT_NUM], uint8_t AntMsk);
BOOL bbic_generate_tone_gen(int16_t tone, int8_t scale, int16_t digGain[ANT_NUM], uint8_t AntMsk);
void bbic_clear_and_disable_tone_gen(uint8_t AntMsk);
void bbic_set_gen_tone (int16_t Tone);
void bbic_clear_gen_tone (int16_t Tone);
void bbic_set_gen_two_tones (int16_t Tone1, int16_t Tone2);
void bbic_clear_gen_two_tones (int16_t Tone1, int16_t Tone2);
void bbic_set_gen_missing_tone (int16_t ToneStart, int16_t ToneStop, int16_t ToneMissing);
void bbic_clear_gen_tone_all(void);
void bbic_enable_tone_gen (BOOL isEnabled);
void bbic_start_tone_gen(void);
uint8_t bbic_wait_tone_gen (uint16_t Timeout);
void bbic_set_tx_diggain (uint8_t AntMsk, int16_t DigGain[ANT_NUM]);
void bbic_get_tx_diggain (uint8_t AntMsk, int16_t DigGain_rtrn[ANT_NUM]);

void bbic_enable_tpc_accelerator(uint8_t AntMsk, BOOL IsEnabled);
void bbic_set_tx_pgc2_gain_select(uint8_t AntMsk, int8_t tpcgainidx); //Set dc offset reg per tpc (pgc2)
void bbic_set_tx_scale (uint8_t AntMsk, int8_t TxTdScale);
uint32 bbic_get_tx_scale (void);

void bbic_set_gen_backoff (uint8_t AntMsk);


// *** Streamer functions

void bbic_enable_streamer(uint8_t StreamerMode, BOOL IsEnabled);
/* Enables/disables the streamer and set streamer mode (StreamerMode: 1= cyclic, IsEnabled: 1/0 = streamer on/off)
 * if StreamerMode set to 1, the streamer will play in cycles by taking first L samples from the streamer RAM
 * the number of samples (vector length) should be set by calling bbic_set_streamer_size(Length)
 */
void bbic_set_streamer_size(int16_t Length, int16_t Offset);
/* Set start and stop indexes to play, according to the offset and length parameters
 * the length is provided as the number of samples/vector size (e.g. to play 1K samples, provide Length=1024)
 * the maximum supported number of samples per antenna is 16K
 */
void bbic_streamer_txon(uint8_t AntMsk);
void bbic_streamer_txoff(uint8_t AntMsk);
/* turn on/off the streamer in the certain antenna path, according to the antenna mask
 * the streamer module should be turned on first by calling bbic_enable_streamer(StreamerMode)
*/

// *** Fixed Point Arithmetic ***
int32_t fxp_limit_sign(int32_t Val, uint8_t Bits);
uint32_t fxp_limit_unsign(uint32_t Val, uint8_t Bits);

// ######################################################################################################
// # Auxiliary functions for regression																						#
// ######################################################################################################

void bbic_detector_rotate (void);

// ####################
// Soc Pvt Sensor     #
// ####################
void bbic_get_soc_tempsens (uint16_t Timeout, uint16_t* tempsens_raw_rtrn);
void bbic_get_soc_voltsens (uint16_t Timeout, uint16_t* voltsens_raw_rtrn);
// Soc PVT temprature sensor, activate, reruten the temp, deactivate.

void bbic_set_tx_power_table_offset(uint8_t AntIdx, uint8_t BwIdx, int16_t rf_power_offset_val);
// Set TX RF POWER offset used to shift the TPC table
//AntIdx - antenna index, 
//BwIdx - BW index 0 -20, 1-40, 2 -80, 3- 160/ 11B
//rf_power_offset_val - offset value	
void bbic_get_tx_power_table_offset(uint8_t AntIdx, uint8_t BwIdx, int16_t* rf_power_offset_val_rtrn);

void bbic_set_tx_open_loop(uint8_t AntMsk, BOOL OpenLoopIsEnabled);
// Set TX  POWER Control Open Loop Mode = Correct gain to fix output power
//AntMsk- antenna Mask, 
//OpenLoopIsEnabled - 1 - Open Loop, 0 - Close loop 
void bbic_get_tx_open_loop(uint8_t AntMsk, BOOL OpenLoopIsEnabled_rtrn[ANT_NUM]);

void bbic_set_tx_power_coef(uint8_t AntIdx, uint8_t BWIdx, uint8_t RegionIdx, int16_t Coef_A, int16_t Coef_B);
// Set TX RF POWER Coefs: A,B
//AntIdx - antenna index, 
//BwIdx - BW index 0 -20, 1-40, 2 -80, 3- 160/ 11B
//RegionIdx	-Range Index 0-2

//void bbic_set_tx_power_s2dIdx(uint8_t AntIdx, uint8_t BWIdx, uint8_t RangeIdx, int16_t s2dIdx);
// Set TX RF POWER Coefs: s2dIdx
//AntIdx - antenna index, 
//BwIdx - BW index 0 -20, 1-40, 2 -80, 3- 160/ 11B
//RangeIdx	-Range Index 0-2

//void bbic_set_tx_power_PowerThreshold(uint8_t AntIdx, uint8_t BWIdx, uint8_t RangeIdx, int16_t PowerThreshold);
// Set TX RF POWER Coefs: PowerThreshold
//AntIdx - antenna index, 
//BwIdx - BW index 0 -20, 1-40, 2 -80, 3- 160/ 11B
//RangeIdx	-Range Index 0-2
void bbic_get_tx_power_PowerThreshold(uint8_t AntIdx, uint8_t BWIdx, uint8_t RegionIdx, int16_t* PowerThreshold_rtrn);
void bbic_get_tx_power_Coef_C(uint8_t AntIdx, uint8_t BWIdx, uint8_t RegionIdx, int16_t* Coef_C_rtrn);


void bbic_get_rssi(uint8_t AntMsk, int8_t rssiValues_rtrn[ANT_NUM] );
void bbic_set_lna_gain_lut(uint8_t AntIdx, int16_t LnaGainValues[8] );
/// Set LNA gain values , vector of 8 gains 0 - high, 7 lowest
////AnIdx - antenna Index ,(read one antenna at a time)
void bbic_get_lna_gain_lut(uint8_t AntIdx, int16_t LnaGainValues_rtrn[8] );
/// Get LNA gain values , vector of 8. 0 high, 7 lowest
////AnIdx - antenna Index ,(read one antenna at a time)
void bbic_set_rx_non_agg_test_mode(BOOL RxNonAggIsEnabled);
// Set RX Test mode: VHT / HE non aggregation mode 
// RxNonAggIsEnabled - 1 - Rx non agg, test mode 0 - RX regular mode 
void bbic_get_rx_non_agg_test_mode(BOOL* RxNonAggIsEnabled_rtrn);
// Get RX Test mode: VHT / HE non aggregation mode 
// RxNonAggIsEnabled - 1 - Rx non agg, test mode 0 - RX regular mode 

void bbic_bypass_phy_frc(uint8_t AntMsk, BOOL BypassFRCMode);
void bbic_get_bypass_phy_frc_status(uint8_t AntMsk, BOOL Frc_status_rtrn[ANT_NUM]);

void bbic_bypass_phy_fdl(uint8_t AntMsk, BOOL BypassPhyFDLMode);
void bbic_get_bypass_phy_fdl_status(uint8_t AntMsk, BOOL PhyFDL_status_rtrn[ANT_NUM]);

void bbic_set_detector_reset_th(uint8_t DetectorResetMode);
uint8_t bbic_get_detector_reset_th(void);
void bbic_enable_11b_detector(uint8_t Enable_Detector_11b);
uint8_t bbic_get_11b_detector_state(void);


void bbic_set_rx_Sc2FcPhase(int8_t AntMsk , uint8_t RxSc2FcPhase);
// Set RX digial Soc to ABB phase compensator: 0,1,2,3
void bbic_get_rx_Sc2FcPhase(int8_t AntMsk , uint8_t RxSc2FcPhase_rtrn[ANT_NUM]);
// Get  RX digial Soc to ABB phase compensator: 0,1,2,3
void bbic_set_tx_Sc2FcPhase(int8_t AntMsk , uint8_t TxSc2FcPhase);
// SetTX digial Soc to ABB phase compensator: 0,1,2,3
void bbic_get_tx_Sc2FcPhase(int8_t AntMsk , uint8_t TxSc2FcPhase_rtrn[ANT_NUM]);
// Get  TX digial Soc to ABB phase compensator: 0,1,2,3

void bbic_set_PgcFiltLut(int8_t AntMsk , uint8_t PgcFiltLUT_local[5][11]);
// take RFIC PGC gain Filter Lut from Efuse, write into PHY RAM

void bbic_set_rx_rssi_coef(uint8_t AntIdx, uint8_t RegionIdx, int16_t Coef_A, int16_t Coef_B);
void bbic_get_rx_rssi_coef(uint8_t AntIdx, uint8_t RegionIdx, int16_t* Coef_A_rtrn, int16_t* Coef_B_rtrn);
// Set RX RF RSSI  Coefs: A,B,c  A -> nLog, B->C
//AntIdx - antenna index, 
//RangeIdx	-Range Index 0-2
void bbic_set_rx_rssi_offset1(uint8_t AntIdx, uint8_t RegionIdx, int16_t offset1);
// Set RX RF RSSI  offset1 - for DC 
//AntIdx - antenna index, 
//RangeIdx	-Range Index 0-1
void bbic_get_rx_rssi_offset1(uint8_t AntIdx, uint8_t RegionIdx, int16_t* offset1_rtrn);
// Set RX RF RSSI  offset1 - for DC 
//AntIdx - antenna index, 
//RangeIdx	-Range Index 0-1

void bbic_api_chip_rev(uint8_t* Rev_rtrn);
//Chip Rev: 1-600A0, 2-600B0, TBA...

void bbic_tx_fft_in_scale(int8_t AntMsk, uint8_t ScaleFactor);
//Set FFT input scaling value (gain), used for tonegen 
//ScaleFactor - 2 bit values(0:3)

void bbic_set_cdd(uint8_t No_of_Ant, uint8_t offset1,uint8_t offset2,uint8_t offset3);
// set cdd for each antenna relative to ant 0

void bbic_get_cdd(uint8_t No_of_Ant, uint32_t* offset1_rtrn,uint32_t* offset2_rtrn,uint32_t* offset3_rtrn);
// get cdd for each antenna relative to ant 0

#endif //end
