classdef WRX_654 < hgsetget 
    % WRX_654
    %   class to allow simple API access
    %   (may serve as superclass for @wrx654 class in rf_system repo)
    %
       
    
    properties (Hidden)
        cSubs;  % Subsref Parser Output to build Command History 
    end
    
    properties (Dependent)
        cHist;    % API Command History
    end
    
    methods
        % constructor
        function oBlk = WRX_654(varargin)
            oBlk.cSubs = cell(0,1);
        end
        
        % get history
        function cHist = get.cHist(oBlk)
            cHist = oBlk.get_cHist();
        end

        % clear history
        function oBlk = clear_hist(oBlk)
            oBlk.cSubs = cell(0,1);
        end
        
        % re-run from history
        function rOutput = re_run(oBlk, vIdx)
            rOutput = struct;
            if sum(vIdx > length(oBlk.cSubs))
                error('Re-run index out of range!');
            else
                for iR = 1:length(vIdx)
                    if ismethod(oBlk, oBlk.cSubs{vIdx(iR)}(1).subs)
                        [varargout{1:nargout}] = builtin('subsref', oBlk, oBlk.cSubs{vIdx(iR)});
                    else                        
                        [varargout{1:nargout}] = oBlk.call_api(oBlk.cSubs{vIdx(iR)});
                    end
                    rOutput(iR).cVarargout = varargout;
                end
            end
        end
        
        % try/catch to implement dynamic methods for API calls
        function varargout = subsref(oBlk, S)
            try
                [varargout{1:nargout}] = builtin('subsref', oBlk, S);
                % update command history (if called method ran properly, and not cHist, re_run or clear_hist)
                if ~(strcmp(S(1).subs,'cHist') || strcmp(S(1).subs,'re_run') || strcmp(S(1).subs,'clear_hist'))
                    oBlk.cSubs{end+1,1} = S;
                end
            catch ME
                if isempty(strfind(ME.message,'No appropriate method, property, or field'))
                    rethrow(ME);
                else
                    if length(S) <= 2
                        [varargout{1:nargout}] = oBlk.call_api(S);
                    else
                        % if not wrong arguments error, then re-throw error
                        % message
                        rethrow(ME);
                    end
                end
            end
        end
    end
    methods (Static)
        % rfic_api header (MEX file rfic_api.mexw32/64 must be compiled and copied to class folder) 
        varargout = rfic_api(varargin);
    end
    
    methods (Access = protected)
        % call API method
        function varargout = call_api(oBlk,S)
            if length(S) == 1
                % executing void API functions
                [varargout{1:nargout}] = oBlk.rfic_api(sprintf('rfic_%s',S(1).subs));
            elseif length(S) == 2
                % executing API functions with parameters
                [varargout{1:nargout}] = oBlk.rfic_api(sprintf('rfic_%s',S(1).subs), S(2).subs{:});
            end
            % update command history
            oBlk.cSubs{end+1,1} = S;
        end
        
        % cHist getter function
        function cHist = get_cHist(oBlk)
            cHist = cell(size(oBlk.cSubs));
            for iS = 1:length(oBlk.cSubs)
                S = oBlk.cSubs{iS};
                if length(S) == 1
                    cHist{iS} = sprintf('[%3d] %s()', iS, S(1).subs);
                elseif length(S) == 2
                    c1 = sprintf('[%3d] %s(', iS, S(1).subs);
                    c2 = sprintf('%s', num2str(S(2).subs{1}));
                    for iL = 2:length(S(2).subs)
                        c2 = sprintf('%s,%s', c2, num2str(S(2).subs{iL}));
                    end
                    cHist{iS} = sprintf('%s%s)', c1, c2);
                end
            end
        end
    end
end