function oWRX = switch_pll(oWRX, sAntSet, sPll, sLoFreq, sRefClk, bHighPwr)
% switch_pll - re-direct subset of antennas to PLL0 or 1 and (re-)program mode and frequencies 
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

% default: PLL in High Power Mode
if nargin < 6
    bHighPwr = 1;
end

% derive HB/LB information from frequency
bHbLb = (sLoFreq(1) > 2500);

% default RefClk: 20MHz for 5G, 40MHz for LB
if nargin < 5
    sRefClk = 40 - 20*bHbLb;
end

% default LO Freq
if nargin < 4
    sLoFreq = 5250;
end

% default: use PLL0
if nargin < 3
    sPll = 0;
end

% default: use all antennas if not specified 
if nargin < 2
    sAntSet = 15;
end

% program PLLx to 2G Frac-N or 5G Integer mode with RefClk ref clk (PLL resets automatically)
oWRX.rfic_api('rfic_set_pll_mode', sPll, bHbLb, sRefClk, bHighPwr);

% set PLLx HB single frequency or multiple frequencies (max. 6)
nLo = length(sLoFreq);
if nLo > 1
    vLoFreq = ones(1,6)*5250;
    vLoFreq(1:nLo) = sLoFreq;
    if bHbLb
        oWRX.rfic_api('rfic_set_lo_frequencies_intn', sPll, vLoFreq(1), vLoFreq(2), vLoFreq(3), vLoFreq(4), vLoFreq(5), vLoFreq(6), 1, sRefClk);        
    else
        oWRX.rfic_api('rfic_set_lo_frequencies_fracn', sPll, vLoFreq(1), vLoFreq(2), vLoFreq(3), vLoFreq(4), vLoFreq(5), vLoFreq(6), 0);        
    end
else
    if bHbLb
        oWRX.rfic_api('rfic_set_lo_frequency_intn', sPll, sLoFreq, 1, sRefClk);
    else
        oWRX.rfic_api('rfic_set_lo_frequency_fracn', sPll, sLoFreq, 0);
    end
end

% release PLLx
oWRX.rfic_api('rfic_release_pllreset', sPll);

% wait for calibration to finish
pause(0.5);

% set Central LO switches for AntSet to PLLx LB or HB output and activate according LO Central LDO
if bHbLb
    oWRX.rfic_api('rfic_select_pll', sAntSet, sPll, 1);
else
    oWRX.rfic_api('rfic_select_pll', sAntSet, sPll, 0);
end
