// -------------------------------------------------------------
// 
// File Name: C:\repo\perforce\wrx600_vdfv\ipg_fc\wrx654\model\run\rx_rfic2dig\hdlsrc\rx_rfic2dig_core.v
// Created: 2018-03-02 09:11:26
// 
// Generated by MATLAB 9.3, MATLAB Coder 3.4 and HDL Coder 3.11
// 
// 
// 
// -- -------------------------------------------------------------
// -- Rate and Clocking Details
// -- -------------------------------------------------------------
// Design base rate: 1
// 
// -------------------------------------------------------------


// -------------------------------------------------------------
// 
// Module: rx_rfic2dig_core
// Source Path: rx_rfic2dig_core
// Hierarchy Level: 0
// 
// -------------------------------------------------------------

`timescale 1 ns / 1 ns

module rx_rfic2dig_core
          (clk,
           reset_n,
           inp_i,
           inn_i,
           inp_q,
           inn_q,
           inp_rssi,
           inn_rssi,
           out_i,
           out_q,
           out_ssi);


  input   clk;
  input   reset_n;
  input   signed [23:0] inp_i;  // sfix24_En21
  input   signed [23:0] inn_i;  // sfix24_En21
  input   signed [23:0] inp_q;  // sfix24_En21
  input   signed [23:0] inn_q;  // sfix24_En21
  input   signed [23:0] inp_rssi;  // sfix24_En21
  input   signed [23:0] inn_rssi;  // sfix24_En21
  output  signed [13:0] out_i;  // sfix14_En13
  output  signed [13:0] out_q;  // sfix14_En13
  output  [9:0] out_ssi;  // ufix10

  reg signed [23:0] inp_i_1;  // sfix24_En21
  wire signed [24:0] tmp;  // sfix25_En21
  reg signed [23:0] inn_i_1;  // sfix24_En21
  wire signed [24:0] tmp_1;  // sfix25_En21
  wire signed [24:0] tmp_2;  // sfix25_En21
  wire signed [25:0] p59tmp_sub_cast;  // sfix26_En21
  wire signed [25:0] p59tmp_sub_cast_1;  // sfix26_En21
  wire signed [25:0] p59tmp_sub_temp;  // sfix26_En21
  wire signed [40:0] tmp_3;  // sfix41_En34
  wire signed [15:0] tmp_4;  // sfix16_En13
  wire tmp_5;
  wire signed [15:0] maxval;  // sfix16_En13
  reg signed [15:0] maxval_1;  // sfix16_En13
  wire signed [15:0] tmp_6;  // sfix16_En13
  wire tmp_7;
  wire signed [15:0] minval;  // sfix16_En13
  reg signed [15:0] minval_1;  // sfix16_En13
  wire signed [15:0] tmp_8;  // sfix16_En13
  wire signed [13:0] tmp_9;  // sfix14_En13
  reg signed [13:0] out_i_1;  // sfix14_En13
  reg signed [23:0] inp_q_1;  // sfix24_En21
  wire signed [24:0] tmp_10;  // sfix25_En21
  reg signed [23:0] inn_q_1;  // sfix24_En21
  wire signed [24:0] tmp_11;  // sfix25_En21
  wire signed [24:0] tmp_12;  // sfix25_En21
  wire signed [25:0] p57tmp_sub_cast;  // sfix26_En21
  wire signed [25:0] p57tmp_sub_cast_1;  // sfix26_En21
  wire signed [25:0] p57tmp_sub_temp;  // sfix26_En21
  wire signed [40:0] tmp_13;  // sfix41_En34
  wire signed [15:0] tmp_14;  // sfix16_En13
  wire tmp_15;
  wire signed [15:0] maxval_2;  // sfix16_En13
  reg signed [15:0] maxval_3;  // sfix16_En13
  wire signed [15:0] tmp_16;  // sfix16_En13
  wire tmp_17;
  wire signed [15:0] minval_2;  // sfix16_En13
  reg signed [15:0] minval_3;  // sfix16_En13
  wire signed [15:0] tmp_18;  // sfix16_En13
  wire signed [13:0] tmp_19;  // sfix14_En13
  reg signed [13:0] out_q_1;  // sfix14_En13
  reg signed [23:0] inp_rssi_1;  // sfix24_En21
  wire signed [24:0] tmp_20;  // sfix25_En21
  reg signed [23:0] inn_rssi_1;  // sfix24_En21
  wire signed [24:0] tmp_21;  // sfix25_En21
  wire signed [24:0] tmp_22;  // sfix25_En21
  wire signed [25:0] p39tmp_sub_cast;  // sfix26_En21
  wire signed [25:0] p39tmp_sub_cast_1;  // sfix26_En21
  wire signed [25:0] p39tmp_sub_temp;  // sfix26_En21
  wire signed [48:0] tmp_23;  // sfix49_En34
  wire signed [49:0] p38tmp_mul_temp;  // sfix50_En34
  wire signed [50:0] tmp_24;  // sfix51_En34
  wire signed [50:0] tmp_25;  // sfix51_En34
  wire signed [51:0] p37tmp_add_cast;  // sfix52_En34
  wire signed [51:0] p37tmp_add_temp;  // sfix52_En34
  wire signed [12:0] tmp_26;  // sfix13
  wire tmp_27;
  wire signed [12:0] maxval_4;  // sfix13
  reg signed [12:0] maxval_5;  // sfix13
  wire signed [12:0] tmp_28;  // sfix13
  wire tmp_29;
  wire signed [12:0] minval_4;  // sfix13
  reg signed [12:0] minval_5;  // sfix13
  wire signed [12:0] tmp_30;  // sfix13
  wire [9:0] tmp_31;  // ufix10
  reg [9:0] out_ssi_1;  // ufix10


  always @(posedge clk or negedge reset_n)
    begin : inp_i_reg_process
      if (reset_n == 1'b0) begin
        inp_i_1 <= 24'sb000000000000000000000000;
      end
      else begin
        inp_i_1 <= inp_i;
      end
    end



  // HDL code generation from MATLAB function: rx_rfic2dig_core
  // 
  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  // 
  //                                                                          %
  // 
  //           Generated by MATLAB 9.3 and Fixed-Point Designer 6.0           %
  // 
  //                                                                          %
  // 
  // %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  // 
  // rx_rfic2dig - RFIC-to-Digital Interface Block Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
  // 
  // --- Authors -------------------------------------------------------------
  // 
  // Steffen Trautmann
  // 
  // -------------------------------------------------------------------------
  // 
  // --- Copyright -----------------------------------------------------------
  // 
  // Intel Austria GmbH, Connected Home Division, Villach
  // 
  // -------------------------------------------------------------------------
  // 
  // underlying fixed-point math rules
  // 
  // oFm = hdlfimath();
  // 
  // ADC Gain
  // 
  // (linear) gain range: -4..4
  // 
  // SSI ADC Gain and Shift
  // 
  // (linear) gain range: 0..2047
  // 
  // (linear) range: 0..1023
  // 
  // calculate digital 14-bit output
  assign tmp = {inp_i_1[23], inp_i_1};



  always @(posedge clk or negedge reset_n)
    begin : inn_i_reg_process
      if (reset_n == 1'b0) begin
        inn_i_1 <= 24'sb000000000000000000000000;
      end
      else begin
        inn_i_1 <= inn_i;
      end
    end



  assign tmp_1 = {inn_i_1[23], inn_i_1};



  assign p59tmp_sub_cast = {tmp[24], tmp};
  assign p59tmp_sub_cast_1 = {tmp_1[24], tmp_1};
  assign p59tmp_sub_temp = p59tmp_sub_cast - p59tmp_sub_cast_1;
  assign tmp_2 = ((p59tmp_sub_temp[25] == 1'b0) && (p59tmp_sub_temp[24] != 1'b0) ? 25'sb0111111111111111111111111 :
              ((p59tmp_sub_temp[25] == 1'b1) && (p59tmp_sub_temp[24] != 1'b1) ? 25'sb1000000000000000000000000 :
              $signed(p59tmp_sub_temp[24:0])));



  assign tmp_3 = 16'sb0011010101010101 * tmp_2;



  // HDL code generation from MATLAB function: rx_rfic2dig_core_falseregionp52
  assign tmp_4 = (((tmp_3[40] == 1'b0) && (tmp_3[39:36] != 4'b0000)) || ((tmp_3[40] == 1'b0) && (tmp_3[36:21] == 16'sb0111111111111111)) ? 16'sb0111111111111111 :
              ((tmp_3[40] == 1'b1) && (tmp_3[39:36] != 4'b1111) ? 16'sb1000000000000000 :
              tmp_3[36:21] + $signed({1'b0, tmp_3[20]})));



  // Limiter
  assign tmp_5 = 16'sb1110000001010010 > tmp_4;



  // HDL code generation from MATLAB function: rx_rfic2dig_core_trueregionp52
  assign maxval = 16'sb1110000001010010;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_process
      if (reset_n == 1'b0) begin
        maxval_1 <= 16'sb0000000000000000;
      end
      else begin
        maxval_1 <= maxval;
      end
    end



  // HDL code generation from MATLAB function: rx_rfic2dig_core_falseregionp48
  assign tmp_6 = (tmp_5 == 1'b0 ? tmp_4 :
              maxval_1);



  assign tmp_7 = 16'sb0001111110101110 < tmp_6;



  // HDL code generation from MATLAB function: rx_rfic2dig_core_trueregionp48
  assign minval = 16'sb0001111110101110;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_1_process
      if (reset_n == 1'b0) begin
        minval_1 <= 16'sb0000000000000000;
      end
      else begin
        minval_1 <= minval;
      end
    end



  assign tmp_8 = (tmp_7 == 1'b0 ? tmp_6 :
              minval_1);



  assign tmp_9 = ((tmp_8[15] == 1'b0) && (tmp_8[14:13] != 2'b00) ? 14'sb01111111111111 :
              ((tmp_8[15] == 1'b1) && (tmp_8[14:13] != 2'b11) ? 14'sb10000000000000 :
              $signed(tmp_8[13:0])));



  always @(posedge clk or negedge reset_n)
    begin : out_i_reg_process
      if (reset_n == 1'b0) begin
        out_i_1 <= 14'sb00000000000000;
      end
      else begin
        out_i_1 <= tmp_9;
      end
    end



  always @(posedge clk or negedge reset_n)
    begin : inp_q_reg_process
      if (reset_n == 1'b0) begin
        inp_q_1 <= 24'sb000000000000000000000000;
      end
      else begin
        inp_q_1 <= inp_q;
      end
    end



  // range -4..+4  
  assign tmp_10 = {inp_q_1[23], inp_q_1};



  always @(posedge clk or negedge reset_n)
    begin : inn_q_reg_process
      if (reset_n == 1'b0) begin
        inn_q_1 <= 24'sb000000000000000000000000;
      end
      else begin
        inn_q_1 <= inn_q;
      end
    end



  assign tmp_11 = {inn_q_1[23], inn_q_1};



  assign p57tmp_sub_cast = {tmp_10[24], tmp_10};
  assign p57tmp_sub_cast_1 = {tmp_11[24], tmp_11};
  assign p57tmp_sub_temp = p57tmp_sub_cast - p57tmp_sub_cast_1;
  assign tmp_12 = ((p57tmp_sub_temp[25] == 1'b0) && (p57tmp_sub_temp[24] != 1'b0) ? 25'sb0111111111111111111111111 :
              ((p57tmp_sub_temp[25] == 1'b1) && (p57tmp_sub_temp[24] != 1'b1) ? 25'sb1000000000000000000000000 :
              $signed(p57tmp_sub_temp[24:0])));



  assign tmp_13 = 16'sb0011010101010101 * tmp_12;



  // HDL code generation from MATLAB function: rx_rfic2dig_core_falseregionp44
  assign tmp_14 = (((tmp_13[40] == 1'b0) && (tmp_13[39:36] != 4'b0000)) || ((tmp_13[40] == 1'b0) && (tmp_13[36:21] == 16'sb0111111111111111)) ? 16'sb0111111111111111 :
              ((tmp_13[40] == 1'b1) && (tmp_13[39:36] != 4'b1111) ? 16'sb1000000000000000 :
              tmp_13[36:21] + $signed({1'b0, tmp_13[20]})));



  // range -1..+1
  assign tmp_15 = 16'sb1110000001010010 > tmp_14;



  // HDL code generation from MATLAB function: rx_rfic2dig_core_trueregionp44
  assign maxval_2 = 16'sb1110000001010010;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_2_process
      if (reset_n == 1'b0) begin
        maxval_3 <= 16'sb0000000000000000;
      end
      else begin
        maxval_3 <= maxval_2;
      end
    end



  // HDL code generation from MATLAB function: rx_rfic2dig_core_falseregionp40
  assign tmp_16 = (tmp_15 == 1'b0 ? tmp_14 :
              maxval_3);



  assign tmp_17 = 16'sb0001111110101110 < tmp_16;



  // HDL code generation from MATLAB function: rx_rfic2dig_core_trueregionp40
  assign minval_2 = 16'sb0001111110101110;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_3_process
      if (reset_n == 1'b0) begin
        minval_3 <= 16'sb0000000000000000;
      end
      else begin
        minval_3 <= minval_2;
      end
    end



  assign tmp_18 = (tmp_17 == 1'b0 ? tmp_16 :
              minval_3);



  assign tmp_19 = ((tmp_18[15] == 1'b0) && (tmp_18[14:13] != 2'b00) ? 14'sb01111111111111 :
              ((tmp_18[15] == 1'b1) && (tmp_18[14:13] != 2'b11) ? 14'sb10000000000000 :
              $signed(tmp_18[13:0])));



  always @(posedge clk or negedge reset_n)
    begin : out_q_reg_process
      if (reset_n == 1'b0) begin
        out_q_1 <= 14'sb00000000000000;
      end
      else begin
        out_q_1 <= tmp_19;
      end
    end



  always @(posedge clk or negedge reset_n)
    begin : inp_rssi_reg_process
      if (reset_n == 1'b0) begin
        inp_rssi_1 <= 24'sb000000000000000000000000;
      end
      else begin
        inp_rssi_1 <= inp_rssi;
      end
    end



  // range -1..+1
  // 
  // calculate digital 10-bit xSSI output
  assign tmp_20 = {inp_rssi_1[23], inp_rssi_1};



  always @(posedge clk or negedge reset_n)
    begin : inn_rssi_reg_process
      if (reset_n == 1'b0) begin
        inn_rssi_1 <= 24'sb000000000000000000000000;
      end
      else begin
        inn_rssi_1 <= inn_rssi;
      end
    end



  assign tmp_21 = {inn_rssi_1[23], inn_rssi_1};



  assign p39tmp_sub_cast = {tmp_20[24], tmp_20};
  assign p39tmp_sub_cast_1 = {tmp_21[24], tmp_21};
  assign p39tmp_sub_temp = p39tmp_sub_cast - p39tmp_sub_cast_1;
  assign tmp_22 = ((p39tmp_sub_temp[25] == 1'b0) && (p39tmp_sub_temp[24] != 1'b0) ? 25'sb0111111111111111111111111 :
              ((p39tmp_sub_temp[25] == 1'b1) && (p39tmp_sub_temp[24] != 1'b1) ? 25'sb1000000000000000000000000 :
              $signed(p39tmp_sub_temp[24:0])));



  assign p38tmp_mul_temp = 25'sb0011111111110000000000000 * tmp_22;
  assign tmp_23 = ((p38tmp_mul_temp[49] == 1'b0) && (p38tmp_mul_temp[48] != 1'b0) ? 49'sh0FFFFFFFFFFFF :
              ((p38tmp_mul_temp[49] == 1'b1) && (p38tmp_mul_temp[48] != 1'b1) ? 49'sh1000000000000 :
              $signed(p38tmp_mul_temp[48:0])));



  assign tmp_24 = {{2{tmp_23[48]}}, tmp_23};



  assign p37tmp_add_cast = {tmp_24[50], tmp_24};
  assign p37tmp_add_temp = p37tmp_add_cast + 52'sh0080000000000;
  assign tmp_25 = ((p37tmp_add_temp[51] == 1'b0) && (p37tmp_add_temp[50] != 1'b0) ? 51'sh3FFFFFFFFFFFF :
              ((p37tmp_add_temp[51] == 1'b1) && (p37tmp_add_temp[50] != 1'b1) ? 51'sh4000000000000 :
              $signed(p37tmp_add_temp[50:0])));



  // HDL code generation from MATLAB function: rx_rfic2dig_core_falseregionp33
  assign tmp_26 = (((tmp_25[50] == 1'b0) && (tmp_25[49:46] != 4'b0000)) || ((tmp_25[50] == 1'b0) && (tmp_25[46:34] == 13'sb0111111111111)) ? 13'sb0111111111111 :
              ((tmp_25[50] == 1'b1) && (tmp_25[49:46] != 4'b1111) ? 13'sb1000000000000 :
              tmp_25[46:34] + $signed({1'b0, tmp_25[33]})));



  // SSI Limiter
  assign tmp_27 = 13'sb0000000000000 > tmp_26;



  // HDL code generation from MATLAB function: rx_rfic2dig_core_trueregionp33
  assign maxval_4 = 13'sb0000000000000;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_4_process
      if (reset_n == 1'b0) begin
        maxval_5 <= 13'sb0000000000000;
      end
      else begin
        maxval_5 <= maxval_4;
      end
    end



  // HDL code generation from MATLAB function: rx_rfic2dig_core_falseregionp29
  assign tmp_28 = (tmp_27 == 1'b0 ? tmp_26 :
              maxval_5);



  assign tmp_29 = 13'sb0001111111111 < tmp_28;



  // HDL code generation from MATLAB function: rx_rfic2dig_core_trueregionp29
  assign minval_4 = 13'sb0001111111111;



  always @(posedge clk or negedge reset_n)
    begin : delayMatch_5_process
      if (reset_n == 1'b0) begin
        minval_5 <= 13'sb0000000000000;
      end
      else begin
        minval_5 <= minval_4;
      end
    end



  assign tmp_30 = (tmp_29 == 1'b0 ? tmp_28 :
              minval_5);



  assign tmp_31 = ((tmp_30[12] == 1'b0) && (tmp_30[11:10] != 2'b00) ? 10'b1111111111 :
              (tmp_30[12] == 1'b1 ? 10'b0000000000 :
              tmp_30[9:0]));



  always @(posedge clk or negedge reset_n)
    begin : out_ssi_reg_process
      if (reset_n == 1'b0) begin
        out_ssi_1 <= 10'b0000000000;
      end
      else begin
        out_ssi_1 <= tmp_31;
      end
    end



  assign out_i = out_i_1;

  assign out_q = out_q_1;

  assign out_ssi = out_ssi_1;

endmodule  // rx_rfic2dig_core

