function DC_OS_CMP_OUT = DCOS_CANC_CMP_BLOCK(IN_P, IN_N, P_nN, ENABLE, ib_pc_const_12u5, VDD1V2, VSS)
% DCOS_CANC_CMP_BLOCK - DC State Machine Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% block enabled and active, all supplies connected?
bSupply = logical(VDD1V2 && ~VSS);
bBias = logical(ib_pc_const_12u5);
bActive = logical(ENABLE && bSupply && bBias);

% Comparator Threshold
% oTh = fi(0.005, 1, 24, 21, oFm); 
oTh = fi(0.000, 1, 24, 21, oFm); 

% determine output
if bActive
    if P_nN
        DC_OS_CMP_OUT = logical((IN_P - IN_N) >= oTh);
    else
        DC_OS_CMP_OUT = ~logical((IN_N - IN_P) >= oTh);
    end
else
    DC_OS_CMP_OUT = false;
end

end

