% DCOS_CANC_CMP_BLOCK_svgen - Script for Matlab-to-Verilog Conversion of DC State Machine Comparator Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'DCOS_CANC_CMP_BLOCK';

%% ------------------------------ Model Arguments -----------------------------



% function DC_OS_CMP_OUT = DCOS_CANC_CMP_BLOCK(IN_P, IN_N, P_nN, ENABLE, ib_pc_const_12u5, VDD1V2, VSS)
cModelArgs = cell(7,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,21)));   % IN_P 
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,21)));   % IN_N
cModelArgs{3} = coder.typeof(false);                        % P_nN
cModelArgs{4} = coder.typeof(false);                        % ENABLE
cModelArgs{5} = coder.typeof(false);                        % ib_pc_const_12u5
cModelArgs{6} = coder.typeof(false);                        % VDD1V2
cModelArgs{7} = coder.typeof(false);                        % VSS


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
