% PassiveMixer5G4_svgen - Script for Matlab-to-Verilog Conversion of 5G Passive Mixer Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'PassiveMixer5G4';

%% ------------------------------ Model Arguments -----------------------------
% function [rf_outp, rf_outn, rf_ct] = PassiveMixer5G4(bb_inp_i, bb_inn_i, bb_inp_q, bb_inn_q, lo_inp_i, lo_inn_i,...
% lo_inp_q, lo_inn_q, ctl_vcm_txmixer, vcm_0v5, VDD1V2, VDD1V2BBLDO, VSS1V2, VSSPSUB, imp_sqrt_gmm, imp_sqrt_gmmi, imp_cos_pmm2, imp_sin_pmm2)

cModelArgs = cell(18,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,21)));   % bb_inp_i
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,21)));   % bb_inn_i
cModelArgs{3} = coder.typeof(fi(0,numerictype(1,24,21)));   % bb_inp_q
cModelArgs{4} = coder.typeof(fi(0,numerictype(1,24,21)));   % bb_inn_q
cModelArgs{5} = coder.typeof(false);                        % lo_inp_i
cModelArgs{6} = coder.typeof(false);                        % lo_inn_i
cModelArgs{7} = coder.typeof(false);                        % lo_inp_q
cModelArgs{8} = coder.typeof(false);                        % lo_inn_q
cModelArgs{9} = coder.typeof(false);                        % ctl_vcm_txmixer
cModelArgs{10} = coder.typeof(false);                       % vcm_0v5
cModelArgs{11} = coder.typeof(false);                       % VDD1V2
cModelArgs{12} = coder.typeof(false);                       % VDD1V2BBLDO
cModelArgs{13} = coder.typeof(false);                       % VSS1V2
cModelArgs{14} = coder.typeof(false);                       % VSSPSUB
% cModelArgs{15} = coder.typeof(fi(0,numerictype(1,24,21)));  % imp_iq_gmm (IQ Gain Mismatch in dB, max. -4..+4 dB)
% cModelArgs{16} = coder.typeof(fi(0,numerictype(1,24,19)));  % imp_iq_pmm (IQ Phase Mismatch, max. -16..+16 degree)
cModelArgs{15} = coder.typeof(fi(0,numerictype(1,24,22)));  % imp_sqrt_gmm (pre-calculated IQMM Gain factor)
cModelArgs{16} = coder.typeof(fi(0,numerictype(1,24,22)));  % imp_sqrt_gmmi (pre-calculated inverse IQMM Gain factor)
cModelArgs{17} = coder.typeof(fi(0,numerictype(1,24,22)));  % imp_cos_pmm2 (pre-calculated IQMM Cos Phase factor)
cModelArgs{18} = coder.typeof(fi(0,numerictype(1,24,22)));  % imp_sin_pmm2 (pre-calculated IQMM Sin Phase factor)


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
