% PassiveMixer5G4 - Testbench to check 5G Passive Mixer Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

vLoInpI = repmat([1 1 0 0], 1, 64);
vLoInnI = repmat([0 0 1 1], 1, 64);
vLoInpQ = repmat([0 1 1 0], 1, 64);
vLoInnQ = repmat([1 0 0 1], 1, 64);

vInI = repmat(sin(2*pi*[0:15]/16),1,16);
vInQ = repmat(cos(2*pi*[0:15]/16),1,16);

sIqGmm = 0.5;   % Gain Mismatch in dB
sIqPmm = 5;     % Phase Mismatch in Degree

bb_inp_i        = fi(vInI/2, 1, 24, 21);
bb_inn_i        = fi(-vInI/2, 1, 24, 21);
bb_inp_q        = fi(vInQ/2, 1, 24, 21);
bb_inn_q        = fi(-vInQ/2, 1, 24, 21);
lo_inp_i        = logical(vLoInpI);
lo_inn_i        = logical(vLoInnI);
lo_inp_q        = logical(vLoInpQ);
lo_inn_q        = logical(vLoInnQ);
ctl_vcm_txmixer = false;
vcm_0v5        = true;
VDD1V2          = true;
VDD1V2BBLDO     = true;
VSS1V2          = false;
VSSPSUB         = false;
imp_iq_gmm      = fi(sIqGmm, 1, 24, 21);
imp_iq_pmm      = fi(sIqPmm, 1, 24, 19);
imp_sqrt_gmm    = fi(sqrt(10^(sIqGmm/20)),1,24,22);
imp_sqrt_gmmi   = fi(1/sqrt(10^(sIqGmm/20)),1,24,22);
imp_cos_pmm2    =  fi(cos(sIqPmm/180*pi/2),1,24,22);
imp_sin_pmm2    =  fi(sin(sIqPmm/180*pi/2),1,24,22);
nSigLen = 256;
nCount = 0;
sErrMax = 1e-3;

sMixerGain = -1;

for iS = 1:nSigLen
    
    [rf_outp, rf_outn, rf_ct] = PassiveMixer5G4(bb_inp_i(iS), bb_inn_i(iS), bb_inp_q(iS), bb_inn_q(iS), lo_inp_i(iS), lo_inn_i(iS),...
        lo_inp_q(iS), lo_inn_q(iS), ctl_vcm_txmixer, vcm_0v5, VDD1V2, VDD1V2BBLDO, VSS1V2, VSSPSUB, imp_sqrt_gmm,imp_sqrt_gmmi,imp_cos_pmm2, imp_sin_pmm2);
    
    oOutPRe = bitsliceget(rf_outp,48,25);
    oOutPIm = bitsliceget(rf_outp,24,1);
    oOutPRe = reinterpretcast(oOutPRe,numerictype(1, 24, 21));
    oOutPIm = reinterpretcast(oOutPIm,numerictype(1, 24, 21));
    oOutNRe = bitsliceget(rf_outn,48,25);
    oOutNIm = bitsliceget(rf_outn,24,1);
    oOutNRe = reinterpretcast(oOutNRe,numerictype(1, 24, 21));
    oOutNIm = reinterpretcast(oOutNIm,numerictype(1, 24, 21));
    
    vInIiq = sqrt(10^(sIqGmm/20))*(vInI(iS)*cos(sIqPmm/180*pi/2)+vInQ(iS)*sin(sIqPmm/180*pi/2));
    vInQiq = 1/sqrt(10^(sIqGmm/20))*(vInQ(iS)*cos(sIqPmm/180*pi/2)+vInI(iS)*sin(sIqPmm/180*pi/2));
        
    sYpM = 10^((sMixerGain-3)/20) * (vInIiq + 1i*vInQiq)/2;
    sYnM = -sYpM;
    
    sYp = double(oOutPRe + 1i*oOutPIm);
    sYn = double(oOutNRe + 1i*oOutNIm);
    if (abs(sYp - sYpM) > sErrMax) || (abs(sYn - sYnM) > sErrMax)
        error('Passive Mixer Differential Output not correct - Expected: %6.4f%+6.4fj|%6.4f%+6.4fj, Actual: %6.4f%+6.4fj|%6.4f%+6.4fj',...
            real(sYpM), imag(sYpM), real(sYnM), imag(sYnM), real(sYp), imag(sYp), real(sYn), imag(sYn));
    end
    nCount = nCount+1;
    
end

fprintf('\nAll %d test runs successfully finished!\n', nCount);
