% RSSI_svgen - Script for Matlab-to-Verilog Conversion of RSSI Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'RSSI';

%% ------------------------------ Model Arguments -----------------------------
% function out_se_rssi = RSSI(rf_inp_rssi, rf_inn_rssi, en_1v2_rssi, stby_1v2_rssi,...
%         ib_nio_55uA, ib_nio_const_25uA, VDDA1V2, VDDRF2V5, VSSRF)
cModelArgs = cell(9,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(0,48,0)));    % rf_inp_rssi, positive differential RF Input 
cModelArgs{2} = coder.typeof(fi(0,numerictype(0,48,0)));    % rf_inn_rssi, negative differential RF Input
cModelArgs{3} = coder.typeof(false);                        % en_1v2_rssi
cModelArgs{4} = coder.typeof(false);                        % stby_1v2_rssi
cModelArgs{5} = coder.typeof(false);                        % ib_nio_55uA
cModelArgs{6} = coder.typeof(false);                        % ib_nio_const_25uA
cModelArgs{7} = coder.typeof(false);                        % VDDA1V2
cModelArgs{8} = coder.typeof(false);                        % VDDRF2V5
cModelArgs{9} = coder.typeof(false);                        % VSSRF

%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
