% RSSI_tb - Testbench to check RSSI Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    
sX      = 0.11234 + 1i*0.16789;
sXp     = sX/2;
sXn     = -sXp;

%% Default Inputs
rf_inp_rssi = bitshift(fi(reinterpretcast(fi(real(sXp),1,24,21),numerictype(0, 24, 0)),0,48,0),24);
rf_inp_rssi = fi(rf_inp_rssi + reinterpretcast(fi(imag(sXp),1,24,21),numerictype(0, 24, 0)),0,48,0);
rf_inn_rssi = bitshift(fi(reinterpretcast(fi(real(sXn),1,24,21),numerictype(0, 24, 0)),0,48,0),24);
rf_inn_rssi = fi(rf_inn_rssi + reinterpretcast(fi(imag(sXn),1,24,21),numerictype(0, 24, 0)),0,48,0);
en_1v2_rssi         = true;
stby_1v2_rssi       = false;
ib_nio_55uA         = true;
ib_nio_const_25uA   = true;
VDDA1V2             = true;
VDDRF2V5            = true;
VSSRF               = false;

%% Nested Loops to verify Output for different Inputs (VDD/VSS/Ibias pins not varied, always active!)
nCount = 1;
out_se_rssi = RSSI(rf_inp_rssi, rf_inn_rssi, en_1v2_rssi, stby_1v2_rssi,...
        ib_nio_55uA, ib_nio_const_25uA, VDDA1V2, VDDRF2V5, VSSRF);

fprintf('\nAll %d test runs successfully finished!\n', nCount);

    
    
    