% RSSI_bias - Testbench to check RSSI Bias Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

% initial settings
ctl_Outbias = fi(0, 0, 3, 0);
ctl_bias_select = true;
pd = false;
pd_b = ~pd;
TC = true;
TC_n = ~TC;
ibp_const_25u = true;
ibn_P2PR_25u = true;
VDDRF2V5 = true;
VDDA1V2 = true;
VSS = false;

% vIcoarse = [75/1000 0 -100/1000 -200/1000];
vIcoarse = [1 0 1 1];     % @@@ consequence of the workaround (coarse offset always 1 (==75A) except for b01 code)

nCount = 0;
sErrMax = 1e-4;
for iS = 1:4
    ctl_Outbias(:) = iS-1;
    for i1 = 1:2
        pd(:) = i1-1;
        pd_b = ~pd;
        
        [ibp_const_75u, ibn_55u_out, Ib_const_25u_Vb1] = RSSI_bias(ctl_Outbias, ctl_bias_select, pd, pd_b, TC, TC_n,...
            ibp_const_25u, ibn_P2PR_25u, VDDRF2V5, VDDA1V2, VSS);
        
        ibp_const_75u_model = ~pd * vIcoarse(iS);
        ibn_55u_out_model = ~pd;
        Ib_const_25u_Vb1_model = ~pd;
        
        if (ibn_55u_out ~= ibn_55u_out_model || Ib_const_25u_Vb1~= Ib_const_25u_Vb1_model || abs(double(ibp_const_75u)-ibp_const_75u_model) > sErrMax)
            error('SupplyMon Output not correct - Expected: p%7.4f|%d|%d, Actual: p%7.4f|%d|%d',...
                ibp_const_75u_model, ibn_55u_out_model, Ib_const_25u_Vb1_model, ibp_const_75u, ibn_55u_out, Ib_const_25u_Vb1);
        end
        nCount = nCount+1;
    end
end
        
fprintf('\nAll %d test runs successfully finished!\n', nCount);
