function [TPC_DIFF_OUTP, TPC_DIFF_OUTN] = TPC_ana_top(TPC_DIFF_INP, TPC_DIFF_INN, CMFB_P, CMFB_N, TPC_GAIN_UN_SEL,...
    TPC_FB_CSEL, TPC_OA_CTRL, TPC_OSDAC_CTRL, TPC_DAC_ENABLE, TPC_OA_ENABLE, IB_PC_CONST_25U, IB_PC_DAC, VCM_REF_0V5, VDDA1V26, VSSA, imp_dc)
% TPC_ana_top - TPC (single I or Q) Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    
    
%% --------------------------------- Pin List ---------------------------------                            
% module TPC_ana_top (
%       // 'analog' inputs
%       input  datatype_defs::GW_EMUL_SIGNED24 TPC_DIFF_INP,
%       input  datatype_defs::GW_EMUL_SIGNED24 TPC_DIFF_INN,
%       input  datatype_defs::GW_EMUL_SIGNED24 CMFB_N, // ??? what signal type?
%       input  datatype_defs::GW_EMUL_SIGNED24 CMFB_P, // ??? what signal type?
%      
%       // control bits     
%       input logic [3:0] TPC_OA_CTRL,
%       input logic [3:0] TPC_OSDAC_CTRL,
%       input logic [6:0] TPC_GAIN_UN_SEL,
%       input logic [6:0] TPC_FB_CSEL,
%       input logic  TPC_DAC_ENABLE,
%       input logic  TPC_OA_ENABLE,          
%      
%       // bias currents
%       input logic [1:0] IB_PC_CONST_25U,
%       input logic  IB_NC_P2PR_50U,
%       input logic  IB_PC_DAC,
%       // supplies
%       input logic  VDDA1V26,
%       input logic  VSSA,
%      
%       // 'analog' outputs
%       output  datatype_defs::GW_EMUL_SIGNED24 TPC_DIFF_OUTP,
%       output  datatype_defs::GW_EMUL_SIGNED24 TPC_DIFF_OUTN
%       );
%  reg  clk;
%  reg  reset_n;
%   
%    // Module for clk and res_n inputs from FPGA:
%    xray_connector xray_connector_clk_I (.Z(clk));
%    xray_connector xray_connector_res_n_I (.Z(reset_n));
%  
%    // Core instantiation in shell module
%    TPC_ana_top_core I_TPC_ana_top(.*)
%  
%    // pragma translate_off
%    // pragma translate_on
%   
% endmodule // TPC_ana_top
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% check supplies
bSupply = logical(VDDA1V26 && ~VSSA);

% check Biasing
bBias = logical(IB_PC_CONST_25U==3 && IB_PC_DAC && VCM_REF_0V5);

% active sub-blocks
bActiveTpc = logical(TPC_OA_ENABLE && bSupply && bBias);
bActiveDac = logical(TPC_DAC_ENABLE && bSupply && bBias);

% Offset DAC Value
oDacStep = fi(0.8e-3, 1, 24, 21, oFm);
oDacVal = fi(fi(TPC_OSDAC_CTRL + 0.5, 1, 24, 19, oFm) * oDacStep * bActiveDac, 1, 24, 21, oFm);

% TPC Gain (not very elegant but faster?)
switch TPC_GAIN_UN_SEL
    case fi(1, 0, 7, 0, oFm)
        oGain = fi(10.^(-6/20), 0, 24, 21, oFm);
    case fi(3, 0, 7, 0, oFm)
        oGain = fi(10.^(-4/20), 0, 24, 21, oFm);
    case fi(7, 0, 7, 0, oFm)
        oGain = fi(10.^(-2/20), 0, 24, 21, oFm);
    case fi(15, 0, 7, 0, oFm)
        oGain = fi(1, 0, 24, 21, oFm);
    case fi(31, 0, 7, 0, oFm)
        oGain = fi(10.^(2/20), 0, 24, 21, oFm);
    case fi(63, 0, 7, 0, oFm)
        oGain = fi(10.^(4/20), 0, 24, 21, oFm);
    case fi(127, 0, 7, 0, oFm)
        oGain = fi(10.^(6/20), 0, 24, 21, oFm);
    otherwise
        oGain = fi(1, 0, 24, 21, oFm);        
end

TPC_DIFF_OUTP = fi(oGain/2 * (TPC_DIFF_INP-TPC_DIFF_INN + oDacVal) * bActiveTpc, 1, 26, 21, oFm);

% DC offset
oGainDc = fi(1 + oGain, 0, 24, 21, oFm);        % DC Offset Gain 1+G
TPC_DIFF_OUTP = fi(TPC_DIFF_OUTP + bActiveTpc * oGainDc * imp_dc/2, 1, 26, 21, oFm);

% Limiter
sLimPos = fi(0.7, 1, 26, 21, oFm);
sLimNeg = fi(-0.7, 1, 26, 21, oFm);
TPC_DIFF_OUTP = fi(min(sLimPos,max(sLimNeg,TPC_DIFF_OUTP)), 1, 24, 21, oFm);

TPC_DIFF_OUTN = fi(-TPC_DIFF_OUTP, 1, 24, 21, oFm);

end

