% TPC_ana_top_tb - Testbench to check TPC Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    
sX = 0.123;

sDc = 0.005;

%% Default Inputs
TPC_DIFF_INP = fi(sX, 1, 24, 21);   % BB Voltage Input, -4..+4 V range 
TPC_DIFF_INN = fi(-sX, 1, 24, 21);   % BB Voltage Input, -4..+4 V range 
CMFB_P = fi(0, 1, 24, 21); 
CMFB_N = fi(0, 1, 24, 21);
TPC_GAIN_UN_SEL = fi(0, 0, 7, 0); 
TPC_FB_CSEL = fi(0, 0, 7, 0);
TPC_OA_CTRL = fi(0, 0, 4, 0);
TPC_OSDAC_CTRL = fi(0, 1, 4, 0);
TPC_DAC_ENABLE = true;
TPC_OA_ENABLE = true;
IB_PC_CONST_25U = fi(3, 0, 2, 0);
IB_PC_DAC = true;
VCM_REF_0V5 = true;
VDDA1V26 = true;
VSSA = false;

% Impairments
imp_dc = fi(sDc, 1, 24, 21);


%% Nested Loops to verify Output for different Inputs (VDD/VSS/Ibias pins not varied, always active!)
vGainCtl = [1 3 7 15 31 63 127]; 
vGain = -6:2:6;

nCount = 0;
for i1 = 1:7
    TPC_GAIN_UN_SEL(:) = vGainCtl(i1);
    for i2 = -8:7
        TPC_OSDAC_CTRL(:) = i2;
        for i3 = 1:2
            TPC_DAC_ENABLE(:) = i3-1;
            for i4 = 1:2
                TPC_OA_ENABLE(:) = i4-1;
                sTpcOutRef = 1/2 * (10^(vGain(i1)/20) * (2*sX + (i2+0.5)*0.8e-3*(i3-1)) + (1+10^(vGain(i1)/20))*sDc ) * (i4-1);
                
                [TPC_DIFF_OUTP, TPC_DIFF_OUTN] = TPC_ana_top(TPC_DIFF_INP, TPC_DIFF_INN, CMFB_P, CMFB_N, TPC_GAIN_UN_SEL,...
                    TPC_FB_CSEL, TPC_OA_CTRL, TPC_OSDAC_CTRL, TPC_DAC_ENABLE, TPC_OA_ENABLE, IB_PC_CONST_25U,...
                    IB_PC_DAC, VCM_REF_0V5, VDDA1V26, VSSA, imp_dc);
                
                if abs(TPC_DIFF_OUTP - sTpcOutRef) > 1e-3
                    error('Wrong Output at TPC_DIFF_OUTP: Expected: %6.4f, Actual: %6.4f!', sTpcOutRef, TPC_DIFF_OUTP);
                end
                if abs(TPC_DIFF_OUTN + sTpcOutRef) > 1e-3
                    error('Wrong Output at TPC_DIFF_OUTN: Expected: %6.4f, Actual: %6.4f!', -sTpcOutRef, TPC_DIFF_OUTN);
                end
                nCount = nCount+1;
            end
        end
    end
end

fprintf('\nAll %d test runs successfully finished!\n', nCount);

    
    
    