function [TSSI_S2D_OUTP,TSSI_S2D_OUTN] = TSSI(TSSI_SENSE_5G, TSSI_SENSE_2G, TSSI_S2D_IN, TSSI_OFFSET_CTRL,...
        TSSI_GAIN_CTRL, TSSI_VTAP_SELECT, HBLB, TSSI_ENABLE_V2I, TSSI_ENABLE_COS_CTRL, TSSI_ENABLE_S2D,...
        IREF_P2R_25u_ODAC, IREF_P2R_25u_S2D, IB_PIO_CONST_25u, VDDA1V2, VDDRF2V5LDO, VDDD3V3FECTL, VSS, VSSA_LDO2V5, VSSDFECTL)
% TSSI - TSSI Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    
    
%% --------------------------------- Pin List ---------------------------------                            
% module TSSI ( TSSI_S2D_OUTN, TSSI_S2D_OUTP, VDDA1V2, VDDRF2V5LDO, VDDD3V3FECTL,
% VSS, IB_PIO_CONST_25u, IREF_P2R_25u_ODAC, TSSI_ENABLE_COS_CTRL, TSSI_ENABLE_S2D,
% TSSI_ENABLE_V2I, TSSI_GAIN_CTRL, TSSI_OFFSET_CTRL, TSSI_S2D_IN, TSSI_SENSE_5G,
% TSSI_VTAP_SELECT, IREF_P2R_25u_S2D, VSSDFECTL, TSSI_SENSE_2G, HBLB );
%   input HBLB;
%   input TSSI_SENSE_5G;
%   output TSSI_S2D_OUTP;
%   input TSSI_SENSE_2G;
%   input TSSI_ENABLE_S2D;
%   input  [1:0] IREF_P2R_25u_ODAC;
%   input VDDD3V3FECTL;
%   input VSSDFECTL;
%   input IREF_P2R_25u_S2D;
%   input TSSI_S2D_IN;
%   input TSSI_ENABLE_V2I;
%   input TSSI_ENABLE_COS_CTRL;
%   input  [1:0] IB_PIO_CONST_25u;
%   input TSSI_VTAP_SELECT;
%   input  [4:0] TSSI_OFFSET_CTRL;
%   input VSS;
%   input VDDA1V2;
%   output TSSI_S2D_OUTN;
%   input  [3:0] TSSI_GAIN_CTRL;
%   input VDDRF2V5LDO;
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% Highband/Lowband selection
% HBLB=1: 5G | HBLB=0: 2G
if HBLB
    oTssiSense = TSSI_SENSE_5G;
else
    oTssiSense = TSSI_SENSE_2G;
end

% Resistive divider selection
% TSSI_VTAP_SELECT=1: 0.9 | TSSI_VTAP_SELECT=1: 0.9
if TSSI_VTAP_SELECT
    oResDiv = fi(0.9, 1, 24, 21, oFm);
else
    oResDiv = fi(0.6, 1, 24, 21, oFm);
end

% check supplies
bSupplyV2I = logical(VDDA1V2 && VDDD3V3FECTL && ~VSSDFECTL);
bSupplyOC = logical(VDDA1V2 && VDDD3V3FECTL && ~VSS);
bSupplyS2D = logical(VDDA1V2 && VDDRF2V5LDO && VDDD3V3FECTL && ~VSSA_LDO2V5);

% check Biasing
bBiasV2I = logical(bitget(IB_PIO_CONST_25u,2));
bBiasOC = logical(IREF_P2R_25u_ODAC==3);
bBiasS2D = logical(bitget(IB_PIO_CONST_25u,1) && IREF_P2R_25u_S2D);

% Reference resistor for V2I conversion (in kOhm!)
oRref = fi(5, 1, 24, 13, oFm);   % range: -1024..+1024 kOhm

% V2I current Output 
oV2iOut = fi(oResDiv * oTssiSense / oRref * TSSI_ENABLE_V2I * bSupplyV2I * bBiasV2I, 1, 24, 23, oFm);    % range: -1..+1mA

% Offset Current
oOcStep = fi(-0.005, 1, 24, 23, oFm);       % Offset Control step size
oOcOut = fi(TSSI_OFFSET_CTRL * oOcStep * TSSI_ENABLE_COS_CTRL * bSupplyOC * bBiasOC, 1, 24, 23, oFm);    % range: -1..+1mA

% S2D Voltage Output (inverted)
oS2dGainVec = fi(10.^([-10:2:20]/20), 0, 24, 19, oFm);   % (linear) gain range: 0..32
TSSI_S2D_OUTN = fi((TSSI_S2D_IN + oV2iOut + oOcOut) * oS2dGainVec(TSSI_GAIN_CTRL+1) * oRref / 2 * TSSI_ENABLE_S2D * bSupplyS2D * bBiasS2D, 1, 24, 21, oFm);
TSSI_S2D_OUTP = fi(-TSSI_S2D_OUTN, 1, 24, 21, oFm);

end

