function [amux_outp, amux_outn] = anamux(amux_inp0, amux_inn0, amux_inp1, amux_inn1, amux_inp2_esd, amux_inn2_esd,...
    en, en_in0, en_in1, en_in2, prog_ib, ib_pc_25u, vcm_0v55, VDD, VSS)
% anamux - AnaMux Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    
    
%% --------------------------------- Pin List ---------------------------------                            
% module anamux
%   (
%   // digital control
%     input logic en,
%     input logic en_in0, // ldomon (supplymon)
%     input logic en_in1, // comparator (former rssi)
%     input logic en_in2, // tssi
%   // digital config
%     input logic [1:0] prog_ib,
%   // 'analog' biasing
%     input logic vcm_0v55,
%     input logic ib_pc_25u,
%   // 'analog' supplies
%     input logic VDD,
%     input logic VSS,
%   // analog I/O signals
%     input  GW_EMUL_SIGNED24 amux_inp0, // ldomon (supplymon)
%     input  GW_EMUL_SIGNED24 amux_inn0,
%     input logic amux_inp1, // comparator (former rssi)
%     input logic amux_inn1,
%     input  GW_EMUL_SIGNED24 amux_inp2_esd, // tssi
%     input  GW_EMUL_SIGNED24 amux_inn2_esd,
%     output  GW_EMUL_SIGNED24 amux_outp,
%     output  GW_EMUL_SIGNED24 amux_outn
%   );
%  
%    reg   clk;
%    reg   reset_n;
%   
%    // Module for clk and res_n inputs from FPGA:
%    xray_connector xray_connector_clk_I (.Z(clk));
%    xray_connector xray_connector_res_n_I (.Z(reset_n));
%  
%    // Core instantiation in shell module
%    anamux_core I_anamux_core(.*)
%  
%    // pragma translate_off
%    // pragma translate_on
%   
% endmodule // anamux 

% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% check supplies
bSupply = logical(VDD && ~VSS);

% check Biasing
bBias = logical(ib_pc_25u && vcm_0v55);

% active sub-blocks
bActive = logical(en && bSupply && bBias);
        
amux_outp = fi(1/2 * ((amux_inp0-amux_inn0)*en_in0 + (amux_inp1-amux_inn1)*en_in1 +(amux_inp2_esd-amux_inn2_esd)*en_in2) * bActive, 1, 24, 21, oFm);
amux_outn = fi(-amux_outp, 1, 24, 21, oFm);

end

