% anamux_tb - Testbench to check AnaMux Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
    
sIn0 = 0.1;
sIn1 = 0.0;
sIn2 = 0.4;

%% Default Inputs
amux_inp0 = fi(sIn0/2, 1, 24, 21);   % BB Voltage Input, -4..+4 V range 
amux_inn0 = fi(-sIn0/2, 1, 24, 21);   % BB Voltage Input, -4..+4 V range 
% amux_inp1 = fi(sIn1/2, 1, 24, 21);   % BB Voltage Input, -4..+4 V range 
% amux_inn1 = fi(-sIn1/2, 1, 24, 21);   % BB Voltage Input, -4..+4 V range 
amux_inp1 = false;   % BB Voltage Input, -4..+4 V range 
amux_inn1 = false;   % BB Voltage Input, -4..+4 V range 
amux_inp2_esd = fi(sIn2/2, 1, 24, 21);   % BB Voltage Input, -4..+4 V range 
amux_inn2_esd = fi(-sIn2/2, 1, 24, 21);   % BB Voltage Input, -4..+4 V range 
en = true;
en_in0 = true;
en_in1 = false;
en_in2 = false;
prog_ib = fi(0, 0, 2, 0);
ib_pc_25u = true;
vcm_0v55 = true;
VDD = true;
VSS = false;

%% Nested Loops to verify Output for different Inputs (VDD/VSS/Ibias pins not varied, always active!)

nCount = 0;
for i0 = 1:2
    en_in0(:) = i0-1;
    for i1 = 1:2
        en_in1(:) = i1-1;
        for i2 = 1:2
            en_in2(:) = i2-1;
            for i3 = 1:2
                en(:) = i3-1;
                sAnaMuxOutRef = 1/2 * (sIn0*(i0-1)+sIn1*(i1-1)+sIn2*(i2-1)) * (i3-1);
                
                [amux_outp, amux_outn] = anamux(amux_inp0, amux_inn0, amux_inp1, amux_inn1, amux_inp2_esd, amux_inn2_esd,...
                    en, en_in0, en_in1, en_in2, prog_ib, ib_pc_25u, vcm_0v55, VDD, VSS);
                
                if abs(double(amux_outp) - sAnaMuxOutRef) > 1e-3
                    error('Wrong Output at TPC_DIFF_OUTP: Expected: %6.4f, Actual: %6.4f!', sAnaMuxOutRef, amux_outp);
                end
                if abs(double(amux_outn) + sAnaMuxOutRef) > 1e-3
                    error('Wrong Output at TPC_DIFF_OUTN: Expected: %6.4f, Actual: %6.4f!', -sAnaMuxOutRef, amux_outnN);
                end
                nCount = nCount+1;
            end
        end
    end
end

fprintf('\nAll %d test runs successfully finished!\n', nCount);

    
    
    