% io2inandout_splitting_bbio - Script for Matlab-to-Verilog Conversion of BBIO Splitter Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'io2inandout_splitting_bbio';

%% ------------------------------ Model Arguments -----------------------------
% function [sout, sout_reverse] = io2inandout_splitting_bbio(sinout, sin)
cModelArgs = cell(2,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,24,23)));   % sinout (generic 24-bit signed input - for currents and voltages)
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,24,23)));   % sin (generic 24-bit signed input - for currents and voltages)


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
