% io2inandout_splitting_bbio - Testbench to check BBIO Splitter Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

vSinout = [0.012 0.023 0.034 0.045 0.056 0.067 0.078 0.089];
vSin = -[0.098 0.087 0.076 0.065 0.054 0.043 0.032 0.021];

% initial settings
sinout = fi(0, 1, 24, 23);
sin = fi(0, 1, 24, 23);

nCount = 0;
sErrMax = 1e-4;
for iS = 1:length(vSin)
    
    sinout(:) = vSinout(iS);
    sin(:) = vSin(iS);
    
    [sout, sout_reverse] = io2inandout_splitting_bbio(sinout, sin);
    
    sout_model = vSinout(iS);
    sout_reverse_model = vSin(iS);
    
    if abs(sout - sout_model) > sErrMax || abs(sout_reverse - sout_reverse_model) > sErrMax
        error('Splitter Output not correct - Expected: p%7.4f|p%7.4f, Actual: p%7.4f|p%7.4f',...
            sout_model, sout_reverse_model, sout, sout_reverse);
    end
    nCount = nCount+1;
end
        
fprintf('\nAll %d test runs successfully finished!\n', nCount);
