function sout = io3inandout_split_multdatatyp(sin0, sin1, sin2)
% io3inandout_splitting - 3-to-1 Signal Adder Fix-Point Model for
% Matlab-to-Verilog Conversion (special version with logical input)
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
  
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

if sin1
    oSin1 = fi(-0.100, 1, 24, 23, oFm);
else
    oSin1 = fi(0, 1, 24, 23, oFm);
end

% calculate output
sout = fi(sin0 + oSin1 + sin2, 1, 24, 23, oFm);    % generic 24-bit signed output

end

