function sout = io3inandout_splitting(sin0, sin1, sin2)
% io3inandout_splitting - 3-to-1 Signal Adder Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
  
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% calculate output
sout = fi(sin0 + sin1 + sin2, 1, 24, 23, oFm);    % generic 24-bit signed output

end

