function [rf_outp,rf_outn] = rx2_rf_lna(RFRX_ANTx, RFRXGND_ANTx, ctl_gain_lna0, ctl_freq_lna0, ctl_lna_bias0, en_lna0, stby_lna0,...
                                en_noise_lna0, en_clamp_lna0, ib_pc_const_25u, VDDRF2V5LDO, VDDRF1V2RXLDO, VSSAANTx, VSSPSUB)
% rx2_rf_lna - 2G LNA Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% extract 2 x 24bit Re and Im parts from 48bit input
% oInRe = bitsliceget(RFRX_ANTx,48,25);
% oInIm = bitsliceget(RFRX_ANTx,24,1);
% oInRe = reinterpretcast(oInRe,numerictype(1, 24, 21));
% oInIm = reinterpretcast(oInIm,numerictype(1, 24, 21));
oInRe = bitsliceget(RFRX_ANTx,47,25);oInReSign = logical(bitsliceget(RFRX_ANTx,48,48));
oInIm = bitsliceget(RFRX_ANTx,23,1);oInImSign = logical(bitsliceget(RFRX_ANTx,24,24));
oOffs = fi(-4, 1, 24, 21, oFm);
oInRe = fi(reinterpretcast(oInRe,numerictype(0, 23, 21)),1, 24, 21, oFm);
oInIm = fi(reinterpretcast(oInIm,numerictype(0, 23, 21)),1, 24, 21, oFm);
if oInReSign 
    oInRe = fi(oInRe + oOffs, 1, 24, 21, oFm);
end
if oInImSign
    oInIm = fi(oInIm + oOffs, 1, 24, 21, oFm);
end

% extract 2 x 24bit Re and Im parts from 48bit input
% oInGndRe = bitsliceget(RFRXGND_ANTx,48,25);
% oInGndIm = bitsliceget(RFRXGND_ANTx,24,1);
% oInGndRe = reinterpretcast(oInGndRe,numerictype(1, 24, 21));
% oInGndIm = reinterpretcast(oInGndIm,numerictype(1, 24, 21));
oInGnd = logical(~RFRXGND_ANTx);

% block enabled and active, all supplies connected?
% bSupply = logical(VDDRF2V5LDO && VDDRF1V2RXLDO && ~VSSAANTx && ~VSSPSUB);
bSupply = logical(VDDRF2V5LDO && VDDRF1V2RXLDO && ~VSSAANTx);
bBias = logical(ib_pc_const_25u);
bActive = logical(en_lna0 && ~stby_lna0 && bSupply && bBias);

% calculate the gains
% oLnaMidGainVec = [8.9 9.3 9.7 10.2 10.8 11.4 12 12.6 13.3 14 14.8 15.7 16.7 17.8 19 20.5]';   % (dB) gain range: 0..32
% oLnaMaxGainVec = [20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5]';   % (dB) gain range: 0..32
% oLnaGainMat = fi(10.^([oLnaMidGainVec-12 oLnaMidGainVec-6 oLnaMidGainVec oLnaMaxGainVec]/20), 0, 24, 19, oFm);   % (linear) gain range: 0..32
oLnaGainMat = fi(10.^([[8.9 9.3 9.7 10.2 10.8 11.4 12 12.6 13.3 14 14.8 15.7 16.7 17.8 19 20.5]'-12,...
    [8.9 9.3 9.7 10.2 10.8 11.4 12 12.6 13.3 14 14.8 15.7 16.7 17.8 19 20.5]'-6,...
    [8.9 9.3 9.7 10.2 10.8 11.4 12 12.6 13.3 14 14.8 15.7 16.7 17.8 19 20.5]',...
    [20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5 20.5]']/20), 0, 24, 19, oFm);   % (linear) gain range: 0..32
oLnaMidGainSel = bitsliceget(ctl_gain_lna0, 4, 1);
oLnaGainSel = bitsliceget(ctl_gain_lna0, 6, 5);
oLnaGain = oLnaGainMat(oLnaMidGainSel+1, oLnaGainSel+1);

% LNA noise source active?
oNoiseLvl = fi(0.01, 1, 24, 21, oFm);       % currently just a placeholder, normally a random number would be needed
oNoise = fi(en_noise_lna0 * oNoiseLvl, 1, 24, 21, oFm);

% calculate output
% oOutPRe = fi(bActive * ((oInRe-oInGndRe) * oLnaGain + oNoise) / 2, 1, 24, 21, oFm);
% oOutPIm = fi(bActive * ((oInIm-oInGndIm) * oLnaGain + oNoise) / 2, 1, 24, 21, oFm);
oOutPRe = fi(bActive * (oInRe*oInGnd * oLnaGain + oNoise) / 2, 1, 32, 21, oFm);
oOutPIm = fi(bActive * (oInIm*oInGnd * oLnaGain + oNoise) / 2, 1, 32, 21, oFm);

% Limiter
sLimPos = fi(1.5, 1, 32, 21, oFm);
sLimNeg = fi(-1.5, 1, 32, 21, oFm);
oOutPRe = fi(min(sLimPos,max(sLimNeg,oOutPRe)), 1, 24, 21, oFm);
oOutPIm = fi(min(sLimPos,max(sLimNeg,oOutPIm)), 1, 24, 21, oFm);

oOutNRe = fi(-oOutPRe,1,24,21,oFm);
oOutNIm = fi(-oOutPIm,1,24,21,oFm);

% construct 48bit outputs P and N from 24bit Re and Im parts
rf_outp = bitshift(fi(reinterpretcast(oOutPRe,numerictype(0, 24, 0)), 0, 48, 0, oFm),24);
rf_outp = fi(rf_outp + reinterpretcast(oOutPIm,numerictype(0, 24, 0)), 0, 48, 0, oFm);
rf_outn = bitshift(fi(reinterpretcast(oOutNRe,numerictype(0, 24, 0)), 0, 48, 0, oFm),24);
rf_outn = fi(rf_outn + reinterpretcast(oOutNIm,numerictype(0, 24, 0)), 0, 48, 0, oFm);

end

