% rx2_rf_lna_tb - Testbench to check 2G LNA Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
sX      = -0.11234 + 1i*0.16789;
% sXGnd   = 0.0;

RFRX_ANTx = bitshift(fi(reinterpretcast(fi(real(sX),1,24,21),numerictype(0, 24, 0)),0,48,0),24);
RFRX_ANTx = fi(RFRX_ANTx + reinterpretcast(fi(imag(sX),1,24,21),numerictype(0, 24, 0)),0,48,0);
% RFRXGND_ANTx = bitshift(fi(reinterpretcast(fi(real(sXGnd),1,24,21),numerictype(0, 24, 0)),0,48,0),24);
% RFRXGND_ANTx = fi(RFRXGND_ANTx + reinterpretcast(fi(imag(sXGnd),1,24,21),numerictype(0, 24, 0)),0,48,0);
RFRXGND_ANTx = false;

ctl_gain_lna0   = fi(0,0,6,0);
ctl_freq_lna0   = fi(0,0,3,0);
ctl_lna_bias0   = false;

en_lna0         = true;
stby_lna0       = false;
en_noise_lna0   = false;
en_clamp_lna0   = false;
ib_pc_const_25u = true;
VDDRF2V5LDO     = true;
VDDRF1V2RXLDO   = true;
VSSAANTx        = false;
VSSPSUB         = false;

vMidGain = [8.9 9.3 9.7 10.2 10.8 11.4 12 12.6 13.3 14 14.8 15.7 16.7 17.8 19 20.5]';
mGain = 10.^([vMidGain-12 vMidGain-6 vMidGain 20.5*ones(size(vMidGain))]/20);
nCount = 0;
sErrMax = 1e-3;

for iG = 0:3
    for iMg = 0:15
        
        ctl_gain_lna0(:) = 16*iG+iMg;
        
        [rf_outp,rf_outn] = rx2_rf_lna(RFRX_ANTx, RFRXGND_ANTx, ctl_gain_lna0, ctl_freq_lna0, ctl_lna_bias0, en_lna0, stby_lna0,...
            en_noise_lna0, en_clamp_lna0, ib_pc_const_25u, VDDRF2V5LDO, VDDRF1V2RXLDO, VSSAANTx, VSSPSUB);
        
        oOutPRe = bitsliceget(rf_outp,48,25);
        oOutPIm = bitsliceget(rf_outp,24,1);
        oOutPRe = reinterpretcast(oOutPRe,numerictype(1, 24, 21));
        oOutPIm = reinterpretcast(oOutPIm,numerictype(1, 24, 21));
        oOutNRe = bitsliceget(rf_outn,48,25);
        oOutNIm = bitsliceget(rf_outn,24,1);
        oOutNRe = reinterpretcast(oOutNRe,numerictype(1, 24, 21));
        oOutNIm = reinterpretcast(oOutNIm,numerictype(1, 24, 21));
        
%         sYpM = mGain(iMg+1,iG+1) * (sX-sXGnd) / 2;
        sYpM = mGain(iMg+1,iG+1) * sX / 2;
        sYnM = -sYpM;
        
        sYp = double(oOutPRe + 1i*oOutPIm);
        sYn = double(oOutNRe + 1i*oOutNIm);
        if (abs(sYp - sYpM) > sErrMax) || (abs(sYn - sYnM) > sErrMax)
            error('PAD Differential Output not correct - Expected: %6.4f+%6.4fj|%6.4f++%6.4fj, Actual: %6.4f+%6.4fj|%6.4f+%6.4fj',...
                real(sYpM), imag(sYpM), real(sYnM), imag(sYnM), real(sYp), imag(sYp), real(sYn), imag(sYn));
        end
        nCount = nCount+1;

    end
end

fprintf('\nAll %d test runs successfully finished!\n', nCount);
