function [outp_i, outn_i, outp_q, outn_q] = rx_bb_pga1(inp_i, inn_i, inp_q, inn_q, inp_cal, inn_cal,...
    cnt_gain0, cnt_fc0, cnt_pga1_tuning0, en0, en_cal0, stby0, sm0, Iref_25uA0, Vref_600mV0, VDDRF2V5LDO, VDDRF1V2RXLDO, VSSAANTx, imp_dc_i, imp_dc_q, imp_sqrt_gmm, imp_sqrt_gmmi, imp_cos_pmm2, imp_sin_pmm2, bFilter)
% rx_bb_pga1 - PGC1 Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% filter states (for second-order IIR filter implementation)
persistent oWn1I oWn2I oWn1Q oWn2Q;        % w(n-1), w(n-2) for I and Q branch 

% initialize filter states in first call
if isempty(oWn1I) || ~bFilter
    oWn1I = fi(0.0, 1, 28, 18, oFm);
    oWn2I = fi(0.0, 1, 28, 18, oFm);
    oWn1Q = fi(0.0, 1, 28, 18, oFm);
    oWn2Q = fi(0.0, 1, 28, 18, oFm);
end
                            
% filter coefficients (currently 2nd-order Butterworth with fg = 0.25*fs)
oA1 = fi(-0.599376933681924, 1, 24, 21, oFm);   % a1 coefficient
oA2 = fi(0.0, 1, 24, 21, oFm);                  % a2 coefficient
oB0 = fi(0.200311533159038, 1, 24, 21, oFm);    % b0 coefficient
oB1 = fi(0.200311533159038, 1, 24, 21, oFm);    % b1 coefficient
oB2 = fi(0.0, 1, 24, 21, oFm);                  % b2 coefficient

% block enabled and active, all supplies connected?
bSupply = logical(VDDRF2V5LDO && VDDRF1V2RXLDO && ~VSSAANTx);
bBias = logical(Iref_25uA0 && Vref_600mV0);
bActive = logical(en0 && ~stby0 && bSupply && bBias);
bCalI = logical(bitget(en_cal0,1));
bCalQ = logical(bitget(en_cal0,2));

% Reference Resistor for TIA I2V conversion
oRref = fi(0.25, 1, 24, 13, oFm);   % range: -1024..+1024 kOhm

% Gain
%oGainVec = fi(10.^([0:2:20]/20), 0, 24, 19, oFm);   % (linear) gain range: 0..32
%oGainDeltaCal = fi(10^(-3/20), 0, 24, 19, oFm);     % -3dB gain drop ehrn connected to SSB cal path (for IQ vene higher)
oGainVec = fi(10.^([0:2:20]*0.05), 0, 24, 19, oFm);   % (linear) gain range: 0..32
oGainDeltaCal = fi(10^(-3*0.05), 0, 24, 19, oFm);     % -3dB gain drop ehrn connected to SSB cal path (for IQ vene higher)

% % IQMM Impairments
% oLn10d20 = fi(0.115129254649702, 1, 24, 23, oFm);   % K = ln(10)/20 = 0.115129..., range -1..+1
% oX = fi(oLn10d20 * imp_iq_gmm, 1, 24, 22, oFm);     % X = K * Gmm_dB, range -2..+2
% oGmmLin = fi(1 + oX + oX*oX/2, 1, 24, 22, oFm);     % Approx. linear gain: GmmLin = 1 + X + x^2/2 + ..., range -2..+2
% 
% [oSqrtGmm, oSqrtGmmI] = rx_bb_pga1_osqrtGmm(oGmmLin,oFm);
% %oSqrtGmm = fi(1+(oGmmLin-1)/2, 1, 24, 22, oFm);                                         % sqrt(gmm) equals approx. 1+(gmm-1)/2, range -2..+2
% %oSqrtGmmI = fi(1-(oGmmLin-1)/2, 1, 24, 22, oFm);                                        % 1/sqrt(gmm) equals approx. 1-(gmm-1)/2, range -2..+2
% %oPmm2Rad = fi(imp_iq_pmm/360*3.1416, 1, 24, 22, oFm);                                   % convert Phase mismatch form Grad to Rad, range -2..+2
% oPmm2Rad = fi(imp_iq_pmm*0.002777777*3.1416, 1, 24, 22, oFm);                                   % convert Phase mismatch form Grad to Rad, range -2..+2
% %oCosPmm2 = fi((oPmm2Rad*oPmm2Rad/12 - 1) * oPmm2Rad*oPmm2Rad/2 + 1, 1, 24, 22, oFm);    % approx. for cos(x) = (x^2/12-1)*x^2/2+1, range -2..+2
% oCosPmm2 = fi((oPmm2Rad*oPmm2Rad - 1) * oPmm2Rad*oPmm2Rad/2 + 1, 1, 24, 22, oFm);    % approx. for cos(x) = (x^2/12-1)*x^2/2+1, range -2..+2
% oSinPmm2 = fi(oPmm2Rad - oPmm2Rad*oPmm2Rad*oPmm2Rad/6, 1, 24, 22, oFm);                 % approx. for sin(x) = x-x^3/6, range -2..+2

% calculate output including gain-independent DC offset impairment
if ~bCalI
    outp_i = fi(bActive * oGainVec(cnt_gain0+1)/2 * (inp_i-inn_i)*oRref, 1, 28, 21, oFm);  % range -4V..4V
else
    outp_i = fi(bActive * oGainVec(cnt_gain0+1)/2 * ((inp_i-inn_i)*oRref + (inp_cal-inn_cal)*oGainDeltaCal), 1, 28, 21, oFm);  % range -4V..4V
end
outp_i = coder.hdl.pipeline(fi(outp_i + bActive * imp_dc_i/2, 1, 28, 21, oFm));
if ~bCalQ
    outp_q = fi(bActive * oGainVec(cnt_gain0+1)/2 * (inp_q-inn_q)*oRref, 1, 28, 21, oFm);  % range -4V..4V
else
    outp_q = fi(bActive * oGainVec(cnt_gain0+1)/2 * ((inp_q-inn_q)*oRref + (inp_cal-inn_cal)*oGainDeltaCal), 1, 28, 21, oFm);  % range -4V..4V
end    
outp_q = coder.hdl.pipeline(fi(outp_q + bActive * imp_dc_q/2, 1, 28, 21, oFm));

% Phase Mismatch (symmetrically applied)
outp_i_tmp = fi(imp_cos_pmm2*outp_i + imp_sin_pmm2*outp_q, 1, 28, 21, oFm);  % range -4V..4V  
outp_q_tmp = fi(imp_cos_pmm2*outp_q + imp_sin_pmm2*outp_i, 1, 28, 21, oFm);  % range -4V..4V  

% Gain Mismatch (symmetrically applied)
outp_i = coder.hdl.pipeline(fi(outp_i_tmp * imp_sqrt_gmm, 1, 28, 21, oFm));  % range -4V..4V
outp_q = coder.hdl.pipeline(fi(outp_q_tmp * imp_sqrt_gmmi, 1, 28, 21, oFm));  % range -4V..4V

% filter I branch 
if bFilter
    oWn = fi(outp_i - oA1*oWn1I - oA2*oWn2I, 1, 28, 18, oFm);
    outp_i = fi(oB0*oWn + oB1*oWn1I + oB2*oWn2I, 1, 28, 21, oFm);
    % update filter states
    oWn2I = oWn1I; oWn1I = oWn;
    % filter Q branch
    oWn = fi(outp_q - oA1*oWn1Q - oA2*oWn2Q, 1, 28, 18, oFm);
    outp_q = fi(oB0*oWn + oB1*oWn1Q + oB2*oWn2Q, 1, 28, 21, oFm);
    % update filter states
    oWn2Q = oWn1Q; oWn1Q = oWn;
end

% Limiter
sLimPos = fi(0.7, 1, 28, 21, oFm);
sLimNeg = fi(-0.7, 1, 28, 21, oFm);
outp_i = fi(min(sLimPos,max(sLimNeg,outp_i)), 1, 24, 21, oFm);
outp_q = fi(min(sLimPos,max(sLimNeg,outp_q)), 1, 24, 21, oFm);

% finally calculate negative outputs
outn_i = fi(-outp_i, 1, 24, 21, oFm);
outn_q = fi(-outp_q, 1, 24, 21, oFm);

end

