% rx_bb_pga1 - Testbench to check PGC1 Behavioral Fix-Point Model
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

sInI = 0.0876;     % 2.345mA I input current
sInQ = -0.1234;    % -1.987mA Q input current

sInCal = 0.0432;   % 0.0432V at calibration input

sDcI = 0.005;      % DC Offset impairment
sDcQ = -0.003;     % DC Offset impairment

sIqGmm = 0;%0.5;      % Gain Mismatch in dB
sIqPmm = 0;%5;        % Phase Mismatch in Degree

inp_i = fi(sInI/2, 1, 24, 19);
inn_i = fi(-sInI/2, 1, 24, 19);
inp_q = fi(sInQ/2, 1, 24, 19);
inn_q = fi(-sInQ/2, 1, 24, 19);
inp_cal = fi(sInCal/2, 1, 24, 21);
inn_cal = fi(-sInCal/2, 1, 24, 21);
cnt_gain0 = fi(0, 0, 4, 0);
cnt_fc0 = fi(0, 0, 6, 0);
cnt_pga1_tuning0 = fi(0, 0, 3, 0);
en0 = true;
en_cal0 = fi(0, 0, 2, 0);
stby0 = false;
sm0 = fi(0, 0, 2, 0);
Iref_25uA0 = true;
Vref_600mV0 = true;
VDDRF2V5LDO = true;
VDDRF1V2RXLDO = true;
VSSAANTx = false;

% Impairments
imp_dc_i = fi(sDcI, 1, 24, 21);
imp_dc_q = fi(sDcQ, 1, 24, 21);
imp_iq_gmm = fi(sIqGmm, 1, 24, 21);
imp_iq_pmm = fi(sIqPmm, 1, 24, 19);
imp_sqrt_gmm=  fi(sqrt(10^(sIqGmm/20)),1,24,22);
imp_sqrt_gmmi= fi(1/sqrt(10^(sIqGmm/20)),1,24,22);
imp_cos_pmm2=fi(cos(sIqPmm/180*pi/2),1,24,22);
imp_sin_pmm2=fi(sin(sIqPmm/180*pi/2),1,24,22);

% filter on/off
bFilter = false;
bPlot = 0;

nCount = 0;
sErrMax = 1e-3;

vGain = 10.^([0:2:20]/20);
sGainDelta = 10.^(-3/20);
sRref = 0.25;   % kOhm

for iS = 1:11
    cnt_gain0(:) = iS-1;
    for i0 = 1:2
        en0(:) = i0-1;
        for i1 = 1:2
            for i2 = 1:2
                en_cal0(:) = i1-1 + 2*(i2-1);
                for i4 = 1:2
                    stby0(:) = i4-1;
                    
                    [outp_i, outn_i, outp_q, outn_q] = rx_bb_pga1(inp_i, inn_i, inp_q, inn_q, inp_cal, inn_cal,...
                        cnt_gain0, cnt_fc0, cnt_pga1_tuning0, en0, en_cal0, stby0, sm0, Iref_25uA0, Vref_600mV0, VDDRF2V5LDO, VDDRF1V2RXLDO, VSSAANTx, imp_dc_i, imp_dc_q, imp_sqrt_gmm,imp_sqrt_gmmi,imp_cos_pmm2,imp_sin_pmm2, bFilter);
                    
                    bCalI = (i1-1);
                    bCalQ = (i2-1);
                    bActive = (en0 && ~stby0);
                    sYpM = bActive/2 * (vGain(iS) * ((sInI+1i*sInQ)*sRref + sInCal*(bCalI+1i*bCalQ)*sGainDelta) + sDcI+1i*sDcQ);
                    sYpM = sqrt(10^(sIqGmm/20))*(real(sYpM)*cos(sIqPmm/180*pi/2)+imag(sYpM)*sin(sIqPmm/180*pi/2)) + ...
                        1j/sqrt(10^(sIqGmm/20))*(real(sYpM)*sin(sIqPmm/180*pi/2)+imag(sYpM)*cos(sIqPmm/180*pi/2));
                    sYnM = -sYpM;
                    
                    sYp = double(outp_i + 1i*outp_q);
                    sYn = double(outn_i + 1i*outn_q);
                    if (abs(sYp - sYpM) > sErrMax) || (abs(sYn - sYnM) > sErrMax)
                        error('PGC1 Differential Output not correct - Expected: %6.4f%+6.4fj|%6.4f%+6.4fj, Actual: %6.4f%+6.4fj|%6.4f%+6.4fj',...
                            real(sYpM), imag(sYpM), real(sYnM), imag(sYnM), real(sYp), imag(sYp), real(sYn), imag(sYn));
                    end
                    nCount = nCount+1;
                end
            end
        end
    end
end

% check filter functionality
[vB, vA] = butter(1, 25/160);  % Butterworth 1st-order, fg = 25MHz at 320MHz sampling rate
vB = [vB 0];
vA = [vA 0];
vWI = zeros(2,1);
vWQ = zeros(2,1);

iGain = 10;
cnt_gain0 = fi(iGain, 0, 4, 0);
en0 = true;
en_cal0 = fi(0, 0, 2, 0);
stby0 = false;
bFilter = true;

nN = 1024;
vInI = randn(nN, 1)/10;
vInQ = randn(nN, 1)/10;
bCalI = 0;
bCalQ = 0;
bActive = 1;

vYpM = zeros(nN, 1);
vYnM = zeros(nN, 1);
vYp = zeros(nN, 1);
vYn = zeros(nN, 1);

for iN = 1:nN
    inp_i(:) = vInI(iN)/2;
    inn_i(:) = -vInI(iN)/2;
    inp_q(:) = vInQ(iN)/2;
    inn_q(:) = -vInQ(iN)/2;
    
    if iN == 1
        [outp_i, outn_i, outp_q, outn_q] = rx_bb_pga1(inp_i, inn_i, inp_q, inn_q, inp_cal, inn_cal,...
            cnt_gain0, cnt_fc0, cnt_pga1_tuning0, en0, en_cal0, stby0, sm0, Iref_25uA0, Vref_600mV0, VDDRF2V5LDO, VDDRF1V2RXLDO, VSSAANTx, imp_dc_i, imp_dc_q, imp_sqrt_gmm, imp_sqrt_gmmi, imp_cos_pmm2, imp_sin_pmm2, false);
    end
    [outp_i, outn_i, outp_q, outn_q] = rx_bb_pga1(inp_i, inn_i, inp_q, inn_q, inp_cal, inn_cal,...
        cnt_gain0, cnt_fc0, cnt_pga1_tuning0, en0, en_cal0, stby0, sm0, Iref_25uA0, Vref_600mV0, VDDRF2V5LDO, VDDRF1V2RXLDO, VSSAANTx, imp_dc_i, imp_dc_q, imp_sqrt_gmm, imp_sqrt_gmmi, imp_cos_pmm2, imp_sin_pmm2, bFilter);
    
    sYpM = bActive/2 * (vGain(iGain+1) * ((vInI(iN)+1i*vInQ(iN))*sRref + sInCal*(bCalI+1i*bCalQ)*sGainDelta) + sDcI+1i*sDcQ);
    sYpMreal = sqrt(10^(sIqGmm/20))*(real(sYpM)*cos(sIqPmm/180*pi/2)+imag(sYpM)*sin(sIqPmm/180*pi/2));
    sYpMimag = sqrt(10^(sIqGmm/20))*(real(sYpM)*sin(sIqPmm/180*pi/2)+imag(sYpM)*cos(sIqPmm/180*pi/2));
    [sYpMreal, vWI] = filter(vB, vA, sYpMreal, vWI);
    [sYpMimag, vWQ] = filter(vB, vA, sYpMimag, vWQ);
    vYpM(iN) = sYpMreal + 1i*sYpMimag;
    vYnM(iN) = -vYpM(iN);
    
    vYp(iN) = double(outp_i + 1i*outp_q);
    vYn(iN) = double(outn_i + 1i*outn_q);
    if (abs(vYp(iN) - vYpM(iN)) > sErrMax) || (abs(vYn(iN) - vYnM(iN)) > sErrMax)
        error('PGC1 Differential Output not correct - Expected: %6.4f%+6.4fj|%6.4f%+6.4fj, Actual: %6.4f%+6.4fj|%6.4f%+6.4fj',...
            real(sYpM), imag(sYpM), real(sYnM), imag(sYnM), real(sYp), imag(sYp), real(sYn), imag(sYn));
    end
    nCount = nCount+1;
end

if bPlot
    figure; hold on; grid on;
    plot(smooth(20*log10(abs(fft(vInI+1i*vInQ)))));
    plot(smooth(20*log10(abs(fft(vYp-vYn)))));
    plot(smooth(20*log10(abs(fft(vYpM-vYnM)))));
end

        
fprintf('\nAll %d test runs successfully finished!\n', nCount);
