function [outp_i, outn_i, outp_q, outn_q] = rx_mixer_bb(inp_i, inn_i, inp_q, inn_q, cnt_odac0, en0, en_ch0,...
    en_cal0, stby0, Iref_25uA0, Vref_600mV0, VDDRF2V5LDO, VDDA1V2BBFILTLDO, VSSAANTx, VSSPSUB)
% rx_mixer_bb - RX Mixer Baseband Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% block enabled and active, all supplies connected?
% bSupply = logical(VDDRF2V5LDO && VDDA1V2BBFILTLDO && ~VSSAANTx && ~VSSPSUB);
bSupply = logical(VDDRF2V5LDO && VDDA1V2BBFILTLDO && ~VSSAANTx);
bBias = logical(Iref_25uA0 && Vref_600mV0);
bActiveI = logical(bitget(en_ch0,1) && ((en0 && ~stby0) || en_cal0) && bSupply && bBias);
bActiveQ = logical(bitget(en_ch0,2) && ((en0 && ~stby0) || en_cal0) && bSupply && bBias);

% Offset DAC value
oDacValI = fi(0.0014516 * max(-31,reinterpretcast(bitsliceget(cnt_odac0,6,1),numerictype(1, 6, 0))), 1, 24, 23, oFm); % step size 1.4516µA
oDacValQ = fi(0.0014516 * max(-31,reinterpretcast(bitsliceget(cnt_odac0,12,7),numerictype(1, 6, 0))), 1, 24, 23, oFm); % step size 1.4516µA

% calculate current(!) output
outp_i = fi(bActiveI * ((inp_i-inn_i) + oDacValI)/2, 1, 24, 19, oFm);  % range -16mA..16mA
outn_i = fi(-outp_i, 1, 24, 19, oFm);
outp_q = fi(bActiveQ * ((inp_q-inn_q) + oDacValQ)/2, 1, 24, 19, oFm);  % range -16mA..16mA
outn_q = fi(-outp_q, 1, 24, 19, oFm);

end

