function [outp_i, outn_i, outp_q, outn_q] = rx_mixer_rf(inrf_p, inrf_n, inlop_i, inlon_i, inlop_q, inlon_q,...
    en_mixer0, stby_mixer0, en_ch_mixer0, en_Isink_mixer0, VDDRF1V2RXLDO, VSSAANTx, VSSPSUB)
% rx_mixer_rf - 2G/5G RX Mixer Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
                            
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% 48bit RF inputs
% oInpRe = bitsliceget(inrf_p,48,25);
% oInpIm = bitsliceget(inrf_p,24,1);
% oInpRe = reinterpretcast(oInpRe,numerictype(1, 24, 21));
% oInpIm = reinterpretcast(oInpIm,numerictype(1, 24, 21));
oInpRe = bitsliceget(inrf_p,47,25);oInpReSign = logical(bitsliceget(inrf_p,48,48));
oInpIm = bitsliceget(inrf_p,23,1);oInpImSign = logical(bitsliceget(inrf_p,24,24));
oOffs = fi(-4, 1, 24, 21, oFm);
oInpRe = fi(reinterpretcast(oInpRe,numerictype(0, 23, 21)),1, 24, 21, oFm);
oInpIm = fi(reinterpretcast(oInpIm,numerictype(0, 23, 21)),1, 24, 21, oFm);
if oInpReSign 
    oInpRe = fi(oInpRe + oOffs, 1, 24, 21, oFm);
end
if oInpImSign
    oInpIm = fi(oInpIm + oOffs, 1, 24, 21, oFm);
end

% oInnRe = bitsliceget(inrf_n,48,25);
% oInnIm = bitsliceget(inrf_n,24,1);
% oInnRe = reinterpretcast(oInnRe,numerictype(1, 24, 21));
% oInnIm = reinterpretcast(oInnIm,numerictype(1, 24, 21));
oInnRe = bitsliceget(inrf_n,47,25);oInnReSign = logical(bitsliceget(inrf_n,48,48));
oInnIm = bitsliceget(inrf_n,23,1);oInnImSign = logical(bitsliceget(inrf_n,24,24));
oOffs = fi(-4, 1, 24, 21, oFm);
oInnRe = fi(reinterpretcast(oInnRe,numerictype(0, 23, 21)),1, 24, 21, oFm);
oInnIm = fi(reinterpretcast(oInnIm,numerictype(0, 23, 21)),1, 24, 21, oFm);
if oInnReSign 
    oInnRe = fi(oInnRe + oOffs, 1, 24, 21, oFm);
end
if oInnImSign
    oInnIm = fi(oInnIm + oOffs, 1, 24, 21, oFm);
end

% LO Inputs active?
% bLoInI = logical(inlop_i && ~inlon_i || ~inlop_i && inlon_i);
% bLoInQ = logical(inlop_q && ~inlon_q || ~inlop_q && inlon_q);
% one common LO active flag to allow correct complex baseband mixing with both PLL models, full-blown and static EMUL 
bLoIn = logical(inlop_i || inlon_i || inlop_q || inlon_q);

% block enabled and active, all supplies connected?
% bSupply = logical(VDDRF1V2RXLDO && ~VSSAANTx && ~VSSPSUB);
bSupply = logical(VDDRF1V2RXLDO && ~VSSAANTx);
bActiveI = logical(bitget(en_ch_mixer0,1) && en_mixer0 && ~stby_mixer0 && ~en_Isink_mixer0 && bSupply);
bActiveQ = logical(bitget(en_ch_mixer0,2) && en_mixer0 && ~stby_mixer0 && ~en_Isink_mixer0 && bSupply);

% calculate Mixer gain (voltage to current)
oMixerGain = fi(10^((0 +3)/20)/0.25, 0, 24, 19, oFm); % 0dB nominal and +3dB from RF to BB, 0.25kOhm Rref

% calculate current(!) output
% outp_i = fi(bActiveI * oMixerGain * (oInpRe-oInnRe)/2 * bLoInI, 1, 24, 21, oFm);  % range -4mA..4mA
outp_i = fi(bActiveI * oMixerGain * (oInpRe-oInnRe)/2 * bLoIn, 1, 24, 19, oFm);
% outp_q = fi(bActiveQ * oMixerGain * (oInpIm-oInnIm)/2 * bLoInQ, 1, 24, 21, oFm);
outp_q = fi(bActiveQ * oMixerGain * (oInpIm-oInnIm)/2 * bLoIn, 1, 24, 19, oFm);

% Limiter
sLimPos = fi(8.5, 1, 24, 19, oFm);
sLimNeg = fi(-8.5, 1, 24, 19, oFm);
outp_i = fi(min(sLimPos,max(sLimNeg,outp_i)), 1, 24, 19, oFm);
outp_q = fi(min(sLimPos,max(sLimNeg,outp_q)), 1, 24, 19, oFm);

outn_i = fi(-outp_i, 1, 24, 19, oFm);
outn_q = fi(-outp_q, 1, 24, 19, oFm);

end

