% rx_rfic2dig_svgen - Script for Matlab-to-Verilog Conversion of interface
% block between RFIC RX BB output and Digital RX input
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'rx_rfic2dig';

%% ------------------------------ Model Arguments -----------------------------
% function [out_i, out_q, out_ssi] = rx_rfic2dig(inp_i, inn_i, inp_q, inn_q, inp_ssi, inn_ssi)
cModelArgs = cell(6,1);
cModelArgs{1} = coder.typeof(fi(-1,numerictype(1,24,21)));   % inp_i (connects to 24-bit fix-point RFIC RX BB output)
cModelArgs{2} = coder.typeof(fi(-1,numerictype(1,24,21)));   % inn_i
cModelArgs{3} = coder.typeof(fi(-1,numerictype(1,24,21)));   % inp_q
cModelArgs{4} = coder.typeof(fi(-1,numerictype(1,24,21)));   % inn_q
cModelArgs{5} = coder.typeof(fi(-1,numerictype(1,24,21)));   % inp_ssi
cModelArgs{6} = coder.typeof(fi(-1,numerictype(1,24,21)));   % inn_ssi


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
