function [bb_outp_ssbcal, bb_outn_ssbcal] = ssbcal(rf_inp_ssbcal, rf_inn_ssbcal, ctl_Iss_ssbcal,...
    ctl_bias_select_ssbcal, en_1v2_ssbcal, ib_pc_const_25uA, vcm_0v6_ssbcal, VDDA3V3, VDDA2V5, VDDA1V2, VDDRF1V2, VSS, VSSA_LDO2V5)
% ssbcal - SSBCal Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------


%% --------------------------------- Pin List ---------------------------------                            
% module ssbcal (
%         // 'analog' Inputs
%         input    datatype_defs::GW_EMUL_SIGNED24 rf_inn_ssbcal,
%         input    datatype_defs::GW_EMUL_SIGNED24 rf_inp_ssbcal,
%        
%         // control bits
%         input logic [3:0] ctl_Iss_ssbcal,
%         input logic   ctl_bias_select_ssbcal,
%         input logic   en_1v2_ssbcal,
%        
%         // bias currents
%         input logic   ib_pc_const_25uA,
%        
%         // supplies      
%         input logic   VDDRF1V2,
%         input logic   VDDA2V5,
%         input logic   VSS,
%         input logic   VDDA1V2,
%         input logic   VDDA3V3,
%         // vcm input
%         input logic   vcm_0v6_ssbcal,
%        
%         // 'analog' Outputs
%         output    datatype_defs::GW_EMUL_SIGNED24 bb_outn_ssbcal,
%         output    datatype_defs::GW_EMUL_SIGNED24 bb_outp_ssbcal       
%         );
%    reg  clk;
%    reg  reset_n;
%   
%    // Module for clk and res_n inputs from FPGA:
%    xray_connector xray_connector_clk_I (.Z(clk));
%    xray_connector xray_connector_res_n_I (.Z(reset_n));
%  
%    // Core instantiation in shell module
%    ssbcal_core I_ssbcal(.*)
%  
%    // pragma translate_off
%    // pragma translate_on
%   
% endmodule //ssbcal

% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% extract 2 x 24bit Re and Im parts from 48bit input
% oRfInpRe = bitsliceget(rf_inp_ssbcal,48,25);
% oRfInpIm = bitsliceget(rf_inp_ssbcal,24,1);
% oRfInpRe = reinterpretcast(oRfInpRe,numerictype(1, 24, 21));
% oRfInpIm = reinterpretcast(oRfInpIm,numerictype(1, 24, 21));
oRfInpRe = bitsliceget(rf_inp_ssbcal,47,25);oRfInpReSign = logical(bitsliceget(rf_inp_ssbcal,48,48));
oRfInpIm = bitsliceget(rf_inp_ssbcal,23,1);oRfInpImSign = logical(bitsliceget(rf_inp_ssbcal,24,24));
oOffs = fi(-4, 1, 24, 21, oFm);
oRfInpRe = fi(reinterpretcast(oRfInpRe,numerictype(0, 23, 21)),1, 24, 21, oFm);
oRfInpIm = fi(reinterpretcast(oRfInpIm,numerictype(0, 23, 21)),1, 24, 21, oFm);
if oRfInpReSign 
    oRfInpRe = fi(oRfInpRe + oOffs, 1, 24, 21, oFm);
end
if oRfInpImSign
    oRfInpIm = fi(oRfInpIm + oOffs, 1, 24, 21, oFm);
end

% oRfInnRe = bitsliceget(rf_inn_ssbcal,48,25);
% oRfInnIm = bitsliceget(rf_inn_ssbcal,24,1);
% oRfInnRe = reinterpretcast(oRfInnRe,numerictype(1, 24, 21));
% oRfInnIm = reinterpretcast(oRfInnIm,numerictype(1, 24, 21));
oRfInnRe = bitsliceget(rf_inn_ssbcal,47,25);oRfInnReSign = logical(bitsliceget(rf_inn_ssbcal,48,48));
oRfInnIm = bitsliceget(rf_inn_ssbcal,23,1);oRfInnImSign = logical(bitsliceget(rf_inn_ssbcal,24,24));
oOffs = fi(-4, 1, 24, 21, oFm);
oRfInnRe = fi(reinterpretcast(oRfInnRe,numerictype(0, 23, 21)),1, 24, 21, oFm);
oRfInnIm = fi(reinterpretcast(oRfInnIm,numerictype(0, 23, 21)),1, 24, 21, oFm);
if oRfInnReSign 
    oRfInnRe = fi(oRfInnRe + oOffs, 1, 24, 21, oFm);
end
if oRfInnImSign
    oRfInnIm = fi(oRfInnIm + oOffs, 1, 24, 21, oFm);
end

oRfInRe = fi(oRfInpRe-oRfInnRe, 1, 24, 21, oFm);
oRfInIm = fi(oRfInpIm-oRfInnIm, 1, 24, 21, oFm);

% check supplies
bSupply = logical(VDDA3V3 && VDDA2V5 && VDDA1V2 && VDDRF1V2 && ~VSS && ~VSSA_LDO2V5);

% check biasing
bBias = logical(ib_pc_const_25uA && vcm_0v6_ssbcal);

% SSB in active state and supplied?
bActive = logical(en_1v2_ssbcal && bSupply && bBias);

% Nominal SSB gain
oGain = fi(10^(0/20), 0, 24, 19, oFm);     % range: 0..32

% SSB Output (for simplicity perfect squarer is assumed)
bb_outp_ssbcal = fi((oRfInRe*oRfInRe+oRfInIm*oRfInIm)*oGain/2 * bActive, 1, 24, 21, oFm);    % range: -4..+4V
bb_outn_ssbcal = fi(-bb_outp_ssbcal, 1, 24, 21, oFm);    % range: -4..+4V

end

