function [supplymon_oup, supplymon_oun] = supplymon(VDDA1V2RXLDO, VDDA1V2TXLDO, VDDRF1V2BBLDO, VDDRF1V2BBFILTLDO,...
    VDDRF2V5LDO, VDD1V5LDO12in, VDD3V3LDO25in, VDD3V3FECTL, TSSI_cal_sens, ctl,...
    ib_pc_const_25u_supplymon1, ib_pc_const_25u_supplymon2, VDD, VSS)
% supplymon - Supply Monitor Behavioral Fix-Point Model for Matlab-to-Verilog Conversion
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
  
% underlying fixed-point math rules
oFm = fimath('RoundingMethod', 'Nearest', 'OverflowAction', 'Saturate', 'ProductMode', 'FullPrecision', 'SumMode', 'FullPrecision');

% block enabled and active, all supplies connected?
bEnable = logical(bitget(ctl,1));
bSupply = logical(VDD && ~VSS);
bBias = logical(ib_pc_const_25u_supplymon1 & ib_pc_const_25u_supplymon2);
bActive = logical(bEnable && bSupply && bBias);

% reference voltage at Vdd3v3FECTL for gain calibration
if VDD3V3FECTL
    oVcal07 = fi(0.7, 1, 24, 21, oFm);
else
    oVcal07 = fi(0.0, 1, 24, 21, oFm);
end

% calculate output
bToggle = logical(bitget(ctl,2));
% oR40 = fi(40, 1, 24, 13, oFm);   % range: -1024..+1024 kOhm
% oR30 = fi(30, 1, 24, 13, oFm);   % range: -1024..+1024 kOhm
oR40 = fi(42, 1, 24, 13, oFm);   % range: -1024..+1024 kOhm
oR30 = fi(31, 1, 24, 13, oFm);   % range: -1024..+1024 kOhm
%               VDDA1V2RXLDO          VDDA1V2TXLDO        VDDRF1V2BBLDO       VDDRF1V2BBFILTLDO   VDDRF2V5LDO         VDD1V5LDO12in       VDD3V3LDO25in
% oRxVec =  fi([  56                    56                  56                  56                  180                 80                  260 ], 1, 24, 13, oFm);
% oVddVec = fi([  1.26                  1.26                1.26                1.26                2.5                 1.5                 3.3 ], 1, 24, 21, oFm);
oRxVec =  fi([  54                    55                  56                  57                  183                 77                  255 ], 1, 24, 13, oFm);
oVddVec = fi([  1.27                  1.26                1.25                1.24                2.45                1.53                3.35 ], 1, 24, 21, oFm);
if ~logical(bitget(ctl,10))
    % if no calibration
    switch bitsliceget(ctl, 12, 3)
        case fi(1, 0, 10, 0)    % VDDA1V2RXLDO
            oVdd = fi(VDDA1V2RXLDO * oVddVec(1), 1, 24, 21, oFm);
            oRx = fi(oRxVec(1), 1, 24, 13, oFm);
        case fi(2, 0, 10, 0)    % VDDA1V2TXLDO
            oVdd = fi(VDDA1V2TXLDO * oVddVec(2), 1, 24, 21, oFm);
            oRx = fi(oRxVec(2), 1, 24, 13, oFm);
        case fi(4, 0, 10, 0)    % VDDRF1V2BBLDO
            oVdd = fi(VDDRF1V2BBLDO * oVddVec(3), 1, 24, 21, oFm);
            oRx = fi(oRxVec(3), 1, 24, 13, oFm);
        case fi(8, 0, 10, 0)    % VDDRF1V2BBFILTLDO
            oVdd = fi(VDDRF1V2BBFILTLDO * oVddVec(4), 1, 24, 21, oFm);
            oRx = fi(oRxVec(4), 1, 24, 13, oFm);
        case fi(16, 0, 10, 0)   % VDDRF2V5LDO
            oVdd = fi(VDDRF2V5LDO * oVddVec(5), 1, 24, 21, oFm);
            oRx = fi(oRxVec(5), 1, 24, 13, oFm);
        case fi(32 + 256, 0, 10, 0) % VDD1V5LDO12in (extra switch to limit leakage current)
            oVdd = fi(VDD1V5LDO12in * oVddVec(6), 1, 24, 21, oFm);
            oRx = fi(oRxVec(6), 1, 24, 13, oFm);
        case fi(64 + 512, 0, 10, 0) % VDD3V3LDO25in (extra switch to limit leakage current)
            oVdd = fi(VDD3V3LDO25in * oVddVec(7), 1, 24, 21, oFm);
            oRx = fi(oRxVec(7), 1, 24, 13, oFm);
        otherwise
            oVdd = fi(0.0, 1, 24, 21, oFm);
            oRx = fi(56, 1, 24, 13, oFm);
    end
    if bToggle
        supplymon_oup = fi(bActive * oVdd * (oR40 + oR30) / (oR40 + oR30 + oRx), 1, 24, 21, oFm);
        supplymon_oun = fi(bActive * oVdd * oR40 / (oR40 + oR30 + oRx), 1, 24, 21, oFm);
    else
        supplymon_oun = fi(bActive * oVdd * (oR40 + oR30) / (oR40 + oR30 + oRx), 1, 24, 21, oFm);
        supplymon_oup = fi(bActive * oVdd * oR40 / (oR40 + oR30 + oRx), 1, 24, 21, oFm);
    end
else
    % if calibration
    if bToggle
        supplymon_oup = fi(bActive * oVcal07, 1, 24, 21, oFm);
        supplymon_oun = fi(bActive * TSSI_cal_sens, 1, 24, 21, oFm);
    else
        supplymon_oun = fi(bActive * oVcal07, 1, 24, 21, oFm);
        supplymon_oup = fi(bActive * TSSI_cal_sens, 1, 24, 21, oFm);
    end
end

end

