% svgen_all     -   Script to run Matlab-to-Verilog Conversion for all models
%                   (Needs to run in model/setup folder)
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------
                            
rDir = dir;

nDir = length(rDir);

for iD = 1:nDir
    if ~(isequal(rDir(iD).name,'matlab2sv') | isequal(rDir(iD).name,'.') | isequal(rDir(iD).name,'..') | isequal(rDir(iD).name,'svgen_all.m') | isequal(rDir(iD).name,'test-setup-file.txt'))
        
        % extract folder/block name
        tBlockAct = rDir(iD).name;
        
        % generate function handle to block-specific conversion script
        hSvGenFun = str2func(sprintf('%s_svgen',tBlockAct));
        
        % change to block folder
        cd(tBlockAct);
        
        % run blockname_svgen script
        hSvGenFun();
        
        % return to model/setup folder
        cd ..
    end
end