%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'tx_PAD5G4_6bit_11AC';

%% ------------------------------ Model Arguments -----------------------------
% function [rf_out_se_pad5g, rf_gnd_pad5g, rf_outp_pad5g, rf_outn_pad5g, OP_outp, OP_outn, vb_pad5g] = tx_PAD5G4_6bit_11AC(...
%     rf_inp_pad5g, rf_inn_pad5g, ctl_gain_pad5g, ctl_band_pad5g, ctl_ibias_pad5g, ctl_vc_pad5g, ctl_vc_bias_pad5g...
%     en_pad5g, stby_pad5g, en_active_mirror_pad5g, en_vc_bias, ib_pc_const_50uA, VDD2V5, VDDRF1V2, VSSRF1V2, VSSPSUB);
cModelArgs = cell(16,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(0,48,0)));    % rf_inp_pad5g
cModelArgs{2} = coder.typeof(fi(0,numerictype(0,48,0)));    % rf_inn_pad5g
cModelArgs{3} = coder.typeof(fi(0,numerictype(0,6,0)));     % [5:0] ctl_gain_pad5g
cModelArgs{4} = coder.typeof(fi(0,numerictype(0,3,0)));     % [2:0] ctl_band_pad5g
cModelArgs{5} = coder.typeof(fi(0,numerictype(0,3,0)));     % [2:0] ctl_ibias_pad5g
cModelArgs{6} = coder.typeof(fi(0,numerictype(0,3,0)));     % [2:0] ctl_vc_pad5g
cModelArgs{7} = coder.typeof(fi(0,numerictype(0,2,0)));     % [1:0] ctl_vc_bias_pad5g
cModelArgs{8} = coder.typeof(false);                        % en_pad5g
cModelArgs{9} = coder.typeof(false);                        % stby_pad5g
cModelArgs{10} = coder.typeof(false);                       % en_active_mirror_pad5g
cModelArgs{11} = coder.typeof(false);                       % en_vc_bias
cModelArgs{12} = coder.typeof(false);                       % ib_pc_const_50uA
cModelArgs{13} = coder.typeof(false);                       % VDD2V5
cModelArgs{14} = coder.typeof(false);                       % VDDRF1V2
cModelArgs{15} = coder.typeof(false);                       % VSSRF1V2
cModelArgs{16} = coder.typeof(false);                       % VSSPSUB



%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
