% create some input
sX  = 0.11234 + 1i*0.16789;
sXp = sX/2;
sXn = -sX/2;
rf_inp_pad5g = bitshift(fi(reinterpretcast(fi(real(sXp),1,24,21),numerictype(0, 24, 0)),0,48,0),24);
rf_inp_pad5g = fi(rf_inp_pad5g + reinterpretcast(fi(imag(sXp),1,24,21),numerictype(0, 24, 0)),0,48,0);
rf_inn_pad5g = bitshift(fi(reinterpretcast(fi(real(sXn),1,24,21),numerictype(0, 24, 0)),0,48,0),24);
rf_inn_pad5g = fi(rf_inn_pad5g + reinterpretcast(fi(imag(sXn),1,24,21),numerictype(0, 24, 0)),0,48,0);

% other defaults
ctl_gain_pad5g          = fi(63,0,6,0);     % [5:0] ctl_gain_pad5g
ctl_band_pad5g          = fi(4,0,3,0);      % [2:0] ctl_band_pad5g
ctl_ibias_pad5g         = fi(3,0,3,0);      % [2:0] ctl_ibias_pad5g
ctl_vc_pad5g            = fi(3,0,3,0);      % [2:0] ctl_ibias_pad5g
ctl_vc_bias_pad5g       = fi(3,0,2,0);      % [1:0] ctl_ibias_pad5g
en_pad5g                = logical(true);
stby_pad5g              = logical(false);
en_active_mirror_pad5g  = logical(false);
en_vc_bias              = logical(false);
ib_pc_const_50uA        = logical(true);
VDD2V5                  = logical(true);
VDDRF1V2                = logical(true);
VSSRF1V2                = logical(false);
VSSPSUB                 = logical(false);


sGainMax = 10^(7.5/20);
sErrMax = 1e-3;
nCount = 0;

for iG = 0:63
    
    % change gain
    ctl_gain_pad5g(:)   = iG;
    
    [rf_out_se_pad5g, rf_gnd_pad5g, rf_outp_pad5g, rf_outn_pad5g, OP_outp, OP_outn, vb_pad5g] = tx_PAD5G4_6bit_11AC(...
    rf_inp_pad5g, rf_inn_pad5g, ctl_gain_pad5g, ctl_band_pad5g, ctl_ibias_pad5g, ctl_vc_pad5g, ctl_vc_bias_pad5g,...
    en_pad5g, stby_pad5g, en_active_mirror_pad5g, en_vc_bias, ib_pc_const_50uA, VDD2V5, VDDRF1V2, VSSRF1V2, VSSPSUB);
    
    oOutTmpRe = bitsliceget(rf_out_se_pad5g,48,25);
    oOutTmpIm = bitsliceget(rf_out_se_pad5g,24,1);
    oOutSeRe = reinterpretcast(oOutTmpRe,numerictype(1, 24, 21));
    oOutSeIm = reinterpretcast(oOutTmpIm,numerictype(1, 24, 21));
%     oOutTmpRe = bitsliceget(rf_gnd_pad5g,48,25);
%     oOutTmpIm = bitsliceget(rf_gnd_pad5g,24,1);
%     oOutGndRe = reinterpretcast(oOutTmpRe,numerictype(1, 24, 21));
%     oOutGndIm = reinterpretcast(oOutTmpIm,numerictype(1, 24, 21));
    oOutGndRe = rf_gnd_pad5g;
    oOutGndIm = rf_gnd_pad5g;

    oOutTmpRe = bitsliceget(rf_outp_pad5g,48,25);
    oOutTmpIm = bitsliceget(rf_outp_pad5g,24,1);
    oOutpRe = reinterpretcast(oOutTmpRe,numerictype(1, 24, 21));
    oOutpIm = reinterpretcast(oOutTmpIm,numerictype(1, 24, 21));
    oOutTmpRe = bitsliceget(rf_outn_pad5g,48,25);
    oOutTmpIm = bitsliceget(rf_outn_pad5g,24,1);
    oOutnRe = reinterpretcast(oOutTmpRe,numerictype(1, 24, 21));
    oOutnIm = reinterpretcast(oOutTmpIm,numerictype(1, 24, 21));
    
    sGainAct = iG/63*sGainMax;
    
    sYse = double(oOutSeRe + 1i*oOutSeIm);
    sYgnd = double(oOutGndRe + 1i*oOutGndIm);
    sYp = double(oOutpRe + 1i*oOutpIm);
    sYn = double(oOutnRe + 1i*oOutnIm);
    
    if abs(sYse - sX*sGainAct) > sErrMax
        error('PAD Single-ended Output not correct - Expected: %6.4f, Actual: %6.4f', sX*sGainAct, sYse);
    end
    if (abs(sYp - sXp*sGainAct) > sErrMax) || (abs(sYn - sXn*sGainAct) > sErrMax)
        error('PAD Differential Output not correct - Expected: %6.4f+%6.4fj|%6.4f++%6.4fj, Actual: %6.4f+%6.4fj|%6.4f+%6.4fj',...
            real(sXp*sGainAct), imag(sXp*sGainAct), real(sXn*sGainAct), imag(sXn*sGainAct), sYp, sYn);
    end
    nCount = nCount+1;
    
end

fprintf('\nAll %d test runs successfully finished!\n', nCount);