% tx_dig2rfic_svgen - Script for Matlab-to-Verilog Conversion of interface
% block between Digital TX output and RFIC TX BB input
    
% --- Authors -------------------------------------------------------------
% Steffen Trautmann
% -------------------------------------------------------------------------
    
% --- Copyright -----------------------------------------------------------
% Intel Austria GmbH, Connected Home Division, Villach
% -------------------------------------------------------------------------

%% ####################### MODEL_SPECIFIC PARAMETERS #########################

%% -------------------------------- Model Name --------------------------------
tModelName = 'tx_dig2rfic';

%% ------------------------------ Model Arguments -----------------------------
% function [outp_i, outn_i, outp_q, outn_q] = tx_dig2rfic(in_i, in_q)
cModelArgs = cell(2,1);
cModelArgs{1} = coder.typeof(fi(0,numerictype(1,14,13)));   % in_i (connects to 14-bit Digital TX output)
cModelArgs{2} = coder.typeof(fi(0,numerictype(1,14,13)));   % in_q 


%% call generic Matlab2SV conversion function
addpath ../matlab2sv
Matlab2SV(tModelName, cModelArgs)
rmpath ../matlab2sv
