#ifndef _LIB_WRX654_SEQUENCES_H
#define _LIB_WRX654_SEQUENCES_H

// full Init sequence
void rfic_init(void);
void rfic_central_init(void);
void rfic_band_init(uint8_t AntMsk);

// PLL related shortcuts and sequences
pll_config rfic_get_pll_status(uint8_t Pll);                                                        // read PLL status (returns complete PLL config struct)
rx_gain_cfg rfic_get_rxgain_status(uint8_t Ant);													// read out RX gain config struct
uint8_t rfic_start_pll(uint8_t Pll, uint8_t AntSet, uint16_t LoFreq);                               // complete sequence to start PLL in single LO mode
void rfic_lock_pll(uint8_t Pll, uint16_t LoFreq);													// sequence to start PLL in single LO mode (without antennas connection)
uint16_t rfic_poll_pll_lock(uint8_t Pll);															// wait for pll lock
uint8_t rfic_start_pll_fasthop(uint8_t Pll, uint8_t AntSet, uint16_t LoFreq0, uint16_t LoFreq1, uint16_t LoFreq2, uint16_t LoFreq3, uint16_t LoFreq4, uint16_t LoFreq5);
                                                                                                    // complete sequence to start PLL in fasthop LO mode

void rfic_init_pll(uint8_t Pll, uint8_t IntFracMode, uint8_t HbLb, uint8_t RefClk, uint8_t HiPwr);  // Initialize PLL (including explicit choice of IntN/FracN mode)
void rfic_set_pll_hblb(uint8_t Pll, uint8_t HbLb);                                                  // set PLL to HB or LB
void rfic_set_pll_pwrmode(uint8_t Pll, uint8_t HiPwr);                                              // set PLL power mode to High Power or Reduced Power
void rfic_set_pll_intfrac(uint8_t Pll, uint8_t IntFracMode);                                        // set PLL to IntN or FracN mode
void rfic_set_pll_refclk(uint8_t Pll, uint8_t RefClk);                                              // change PLL reference clock
void rfic_set_lo_frequency(uint8_t Pll, uint16_t LoFreq);                                           // program LO single frequency (IntN/FracN choice according PLL configuration)
void rfic_set_lo_frequencies(uint8_t Pll, uint16_t LoFreq0, uint16_t LoFreq1, uint16_t LoFreq2, uint16_t LoFreq3, uint16_t LoFreq4, uint16_t LoFreq5);
                                                                                                    // program LO fasthop frequencies (IntN/FracN choice according PLL configuration)
void rfic_connect_to_pll(uint8_t AntSet, uint8_t Pll, uint8_t bActHbLb);                            // connect set of antennas to specific PLL (HB or LB chosen according PLL configuration), optionally activate HB/LB

#endif
