/**
* @file        MODULE_rf_antenna_long.cpp
* @author      klatzer
* @copyright   INTEL
*
* @briefAntenna Long Registers
*
* This is a Spectool2 file.
*/

#include "MODULE_rf_antenna_long.h"

#include "IndirectAccessPort.h"
#include "Register.h"
#include "RField.h"
#include "Attribute.h"
#include "Format.h"
#include "Utilities.h"
#include "python/str.h"

MODULE_rf_antenna_long::MODULE_rf_antenna_long()
{
  ///////////////////////////
  //// MODULE PROPERTIES ////
  setBaseName ("rf_antenna_long");
  setLongName ("Antenna Long Registers");
  setDescription ("ANTENNAx LONG REGISTER");
  setContact ("klatzer");
  setFile (__FILE__);
  setGenerateGraphic(true);
  setIp(true);
  // addDocuLink("path to location", "description");
  // addDocuPicture("path to picture", "title");
  // addReference("module path to reference", "title");
  
  ////////////////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLED EXTERNALLY (INPUT PORTS) ////
  Port* p_FCSI = new Port (this);
  p_FCSI->setInstName ("FCSI");
  p_FCSI->setLongName ("Single Antenna FCSI Interface");
  p_FCSI->setDescription ("");
  p_FCSI->setAddrBase (16);
  p_FCSI->setDataWidth (16);
  p_FCSI->setAddrSpace (0x00000030);
  p_FCSI->setAccess (AddressableNode::RW);
  p_FCSI->setOffsetAsView(0x00000000);
  p_FCSI->setAllowAddrOverlap(false);
  p_FCSI->setAddrAlignCheck(AddressableNode::AAC_AUTO_OFF);
  p_FCSI->setBusProtocol (Bus::FCSI);
  p_FCSI->setCollapse (false);

  
  ///////////////////////////////////////////////////
  /// PORTS WHICH ARE CONTROLLING EXTERNAL PORTS (OUTPUT PORTS) ////
  
  /////////////////////
  //// SUB-MODULES ////
  
  ////////////////////////
  //// INTERNAL PORTS ////
  
  ////////////////////////
  //// INTERNAL BUSES ////
  
  //////////////////////////////
  //// REGISTERS AND FIELDS ////
  Register* r_FCSI_LOCENTLB = new Register;
  r_FCSI_LOCENTLB->setInstName ("LOCENTLB");
  r_FCSI_LOCENTLB->setLongName ("LOCENT LB");
  r_FCSI_LOCENTLB->setDescription ("FCSI-LDO1V2");
  r_FCSI_LOCENTLB->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_LOCENTLB, 0x00000000);

  RField* f_FCSI_LOCENTLB_ant_off = new RField;
  f_FCSI_LOCENTLB_ant_off->setInstName ("ant_off");
  f_FCSI_LOCENTLB_ant_off->setLongName ("ANT OFF");
  f_FCSI_LOCENTLB_ant_off->setDescription ("Switch off Antenna");
  f_FCSI_LOCENTLB_ant_off->setDataWidth (1);
  f_FCSI_LOCENTLB_ant_off->setResetVal ("1'b0");
  f_FCSI_LOCENTLB_ant_off->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_ant_off, 0);

  Attribute* a_FCSI_LOCENTLB_ant_off_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_ant_off_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_ant_off_0_0->setLongName ("");
  a_FCSI_LOCENTLB_ant_off_0_0->setDescription ("");
  a_FCSI_LOCENTLB_ant_off_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_ant_off_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_ant_off->connectAttribute (a_FCSI_LOCENTLB_ant_off_0_0);

  RField* f_FCSI_LOCENTLB_enable_lbsw1_pll0 = new RField;
  f_FCSI_LOCENTLB_enable_lbsw1_pll0->setInstName ("enable_lbsw1_pll0");
  f_FCSI_LOCENTLB_enable_lbsw1_pll0->setLongName ("ENABLE LBSW1 PLL0");
  f_FCSI_LOCENTLB_enable_lbsw1_pll0->setDescription ("Enable LB FOB for PLL0");
  f_FCSI_LOCENTLB_enable_lbsw1_pll0->setDataWidth (1);
  f_FCSI_LOCENTLB_enable_lbsw1_pll0->setResetVal ("1'b1");
  f_FCSI_LOCENTLB_enable_lbsw1_pll0->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_enable_lbsw1_pll0, 2);

  Attribute* a_FCSI_LOCENTLB_enable_lbsw1_pll0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_enable_lbsw1_pll0_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_enable_lbsw1_pll0_0_0->setLongName ("");
  a_FCSI_LOCENTLB_enable_lbsw1_pll0_0_0->setDescription ("");
  a_FCSI_LOCENTLB_enable_lbsw1_pll0_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_enable_lbsw1_pll0_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_enable_lbsw1_pll0->connectAttribute (a_FCSI_LOCENTLB_enable_lbsw1_pll0_0_0);

  RField* f_FCSI_LOCENTLB_enable_lbdrv1_pll0 = new RField;
  f_FCSI_LOCENTLB_enable_lbdrv1_pll0->setInstName ("enable_lbdrv1_pll0");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll0->setLongName ("ENABLE LBDRV1 PLL0");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll0->setDescription ("Enable LB driver for PLL0");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll0->setDataWidth (1);
  f_FCSI_LOCENTLB_enable_lbdrv1_pll0->setResetVal ("1'b1");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll0->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_enable_lbdrv1_pll0, 3);

  Attribute* a_FCSI_LOCENTLB_enable_lbdrv1_pll0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_enable_lbdrv1_pll0_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_enable_lbdrv1_pll0_0_0->setLongName ("");
  a_FCSI_LOCENTLB_enable_lbdrv1_pll0_0_0->setDescription ("");
  a_FCSI_LOCENTLB_enable_lbdrv1_pll0_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_enable_lbdrv1_pll0_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll0->connectAttribute (a_FCSI_LOCENTLB_enable_lbdrv1_pll0_0_0);

  RField* f_FCSI_LOCENTLB_enable_lbsw1_pll1 = new RField;
  f_FCSI_LOCENTLB_enable_lbsw1_pll1->setInstName ("enable_lbsw1_pll1");
  f_FCSI_LOCENTLB_enable_lbsw1_pll1->setLongName ("ENABLE LBSW1 PLL1");
  f_FCSI_LOCENTLB_enable_lbsw1_pll1->setDescription ("Enable LB FOB for PLL1");
  f_FCSI_LOCENTLB_enable_lbsw1_pll1->setDataWidth (1);
  f_FCSI_LOCENTLB_enable_lbsw1_pll1->setResetVal ("1'b0");
  f_FCSI_LOCENTLB_enable_lbsw1_pll1->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_enable_lbsw1_pll1, 4);

  Attribute* a_FCSI_LOCENTLB_enable_lbsw1_pll1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_enable_lbsw1_pll1_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_enable_lbsw1_pll1_0_0->setLongName ("");
  a_FCSI_LOCENTLB_enable_lbsw1_pll1_0_0->setDescription ("");
  a_FCSI_LOCENTLB_enable_lbsw1_pll1_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_enable_lbsw1_pll1_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_enable_lbsw1_pll1->connectAttribute (a_FCSI_LOCENTLB_enable_lbsw1_pll1_0_0);

  RField* f_FCSI_LOCENTLB_enable_lbdrv1_pll1 = new RField;
  f_FCSI_LOCENTLB_enable_lbdrv1_pll1->setInstName ("enable_lbdrv1_pll1");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll1->setLongName ("ENABLE LBDRV1 PLL1");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll1->setDescription ("Enable LB driver for PLL1");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll1->setDataWidth (1);
  f_FCSI_LOCENTLB_enable_lbdrv1_pll1->setResetVal ("1'b0");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll1->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_enable_lbdrv1_pll1, 5);

  Attribute* a_FCSI_LOCENTLB_enable_lbdrv1_pll1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_enable_lbdrv1_pll1_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_enable_lbdrv1_pll1_0_0->setLongName ("");
  a_FCSI_LOCENTLB_enable_lbdrv1_pll1_0_0->setDescription ("");
  a_FCSI_LOCENTLB_enable_lbdrv1_pll1_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_enable_lbdrv1_pll1_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_enable_lbdrv1_pll1->connectAttribute (a_FCSI_LOCENTLB_enable_lbdrv1_pll1_0_0);

  RField* f_FCSI_LOCENTLB_ctl_vout = new RField;
  f_FCSI_LOCENTLB_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_LOCENTLB_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_LOCENTLB_ctl_vout->setDescription ("Control output voltage of LOTREELDO");
  f_FCSI_LOCENTLB_ctl_vout->setDataWidth (4);
  f_FCSI_LOCENTLB_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_LOCENTLB_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_ctl_vout, 6);

  Attribute* a_FCSI_LOCENTLB_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_ctl_vout_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_ctl_vout_0_0->setLongName ("");
  a_FCSI_LOCENTLB_ctl_vout_0_0->setDescription ("");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("2", "4'b0010", "1.234V (default)");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_LOCENTLB_ctl_vout_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_LOCENTLB_ctl_vout->connectAttribute (a_FCSI_LOCENTLB_ctl_vout_0_0);

  RField* f_FCSI_LOCENTLB_ctl_lpgain = new RField;
  f_FCSI_LOCENTLB_ctl_lpgain->setInstName ("ctl_lpgain");
  f_FCSI_LOCENTLB_ctl_lpgain->setLongName ("CTL LPGAIN");
  f_FCSI_LOCENTLB_ctl_lpgain->setDescription ("Control loop gain");
  f_FCSI_LOCENTLB_ctl_lpgain->setDataWidth (1);
  f_FCSI_LOCENTLB_ctl_lpgain->setResetVal ("1'b0");
  f_FCSI_LOCENTLB_ctl_lpgain->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_ctl_lpgain, 10);

  Attribute* a_FCSI_LOCENTLB_ctl_lpgain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_ctl_lpgain_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_ctl_lpgain_0_0->setLongName ("");
  a_FCSI_LOCENTLB_ctl_lpgain_0_0->setDescription ("");
  a_FCSI_LOCENTLB_ctl_lpgain_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_ctl_lpgain_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_ctl_lpgain->connectAttribute (a_FCSI_LOCENTLB_ctl_lpgain_0_0);

  RField* f_FCSI_LOCENTLB_en_rload = new RField;
  f_FCSI_LOCENTLB_en_rload->setInstName ("en_rload");
  f_FCSI_LOCENTLB_en_rload->setLongName ("EN RLOAD");
  f_FCSI_LOCENTLB_en_rload->setDescription ("Enable resistive load");
  f_FCSI_LOCENTLB_en_rload->setDataWidth (1);
  f_FCSI_LOCENTLB_en_rload->setResetVal ("1'b0");
  f_FCSI_LOCENTLB_en_rload->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_en_rload, 11);

  Attribute* a_FCSI_LOCENTLB_en_rload_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_en_rload_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_en_rload_0_0->setLongName ("");
  a_FCSI_LOCENTLB_en_rload_0_0->setDescription ("");
  a_FCSI_LOCENTLB_en_rload_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_en_rload_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_en_rload->connectAttribute (a_FCSI_LOCENTLB_en_rload_0_0);

  RField* f_FCSI_LOCENTLB_en_ptrack = new RField;
  f_FCSI_LOCENTLB_en_ptrack->setInstName ("en_ptrack");
  f_FCSI_LOCENTLB_en_ptrack->setLongName ("EN PTRACK");
  f_FCSI_LOCENTLB_en_ptrack->setDescription ("Enable process tracking");
  f_FCSI_LOCENTLB_en_ptrack->setDataWidth (1);
  f_FCSI_LOCENTLB_en_ptrack->setResetVal ("1'b0");
  f_FCSI_LOCENTLB_en_ptrack->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_en_ptrack, 12);

  Attribute* a_FCSI_LOCENTLB_en_ptrack_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_en_ptrack_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_en_ptrack_0_0->setLongName ("");
  a_FCSI_LOCENTLB_en_ptrack_0_0->setDescription ("");
  a_FCSI_LOCENTLB_en_ptrack_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_en_ptrack_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_en_ptrack->connectAttribute (a_FCSI_LOCENTLB_en_ptrack_0_0);

  RField* f_FCSI_LOCENTLB_en_bypass = new RField;
  f_FCSI_LOCENTLB_en_bypass->setInstName ("en_bypass");
  f_FCSI_LOCENTLB_en_bypass->setLongName ("EN BYPASS");
  f_FCSI_LOCENTLB_en_bypass->setDescription ("Enable bypass mode");
  f_FCSI_LOCENTLB_en_bypass->setDataWidth (1);
  f_FCSI_LOCENTLB_en_bypass->setResetVal ("1'b0");
  f_FCSI_LOCENTLB_en_bypass->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_en_bypass, 13);

  Attribute* a_FCSI_LOCENTLB_en_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_en_bypass_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_en_bypass_0_0->setLongName ("");
  a_FCSI_LOCENTLB_en_bypass_0_0->setDescription ("");
  a_FCSI_LOCENTLB_en_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_en_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_en_bypass->connectAttribute (a_FCSI_LOCENTLB_en_bypass_0_0);

  RField* f_FCSI_LOCENTLB_enable_lbldo_test = new RField;
  f_FCSI_LOCENTLB_enable_lbldo_test->setInstName ("enable_lbldo_test");
  f_FCSI_LOCENTLB_enable_lbldo_test->setLongName ("ENABLE LB LDO TEST");
  f_FCSI_LOCENTLB_enable_lbldo_test->setDescription ("Enable LB LDO TEST output (to TEST_LDO pad)");
  f_FCSI_LOCENTLB_enable_lbldo_test->setDataWidth (1);
  f_FCSI_LOCENTLB_enable_lbldo_test->setResetVal ("1'b0");
  f_FCSI_LOCENTLB_enable_lbldo_test->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_enable_lbldo_test, 14);

  Attribute* a_FCSI_LOCENTLB_enable_lbldo_test_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_enable_lbldo_test_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_enable_lbldo_test_0_0->setLongName ("");
  a_FCSI_LOCENTLB_enable_lbldo_test_0_0->setDescription ("");
  a_FCSI_LOCENTLB_enable_lbldo_test_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_enable_lbldo_test_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_enable_lbldo_test->connectAttribute (a_FCSI_LOCENTLB_enable_lbldo_test_0_0);

  RField* f_FCSI_LOCENTLB_enable_lbldo = new RField;
  f_FCSI_LOCENTLB_enable_lbldo->setInstName ("enable_lbldo");
  f_FCSI_LOCENTLB_enable_lbldo->setLongName ("ENABLE LB LDO");
  f_FCSI_LOCENTLB_enable_lbldo->setDescription ("Enable LB LDO");
  f_FCSI_LOCENTLB_enable_lbldo->setDataWidth (1);
  f_FCSI_LOCENTLB_enable_lbldo->setResetVal ("1'b0");
  f_FCSI_LOCENTLB_enable_lbldo->setAccProp (AccProp::RW);
  r_FCSI_LOCENTLB->connectRField (f_FCSI_LOCENTLB_enable_lbldo, 15);

  Attribute* a_FCSI_LOCENTLB_enable_lbldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTLB_enable_lbldo_0_0->setInstName ("0");
  a_FCSI_LOCENTLB_enable_lbldo_0_0->setLongName ("");
  a_FCSI_LOCENTLB_enable_lbldo_0_0->setDescription ("");
  a_FCSI_LOCENTLB_enable_lbldo_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTLB_enable_lbldo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTLB_enable_lbldo->connectAttribute (a_FCSI_LOCENTLB_enable_lbldo_0_0);

  Register* r_FCSI_LOCENTHB = new Register;
  r_FCSI_LOCENTHB->setInstName ("LOCENTHB");
  r_FCSI_LOCENTHB->setLongName ("LOCENT HB");
  r_FCSI_LOCENTHB->setDescription ("FCSI-LDO1V2");
  r_FCSI_LOCENTHB->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_LOCENTHB, 0x00000001);

  RField* f_FCSI_LOCENTHB_enable_hbsw1_pll0 = new RField;
  f_FCSI_LOCENTHB_enable_hbsw1_pll0->setInstName ("enable_hbsw1_pll0");
  f_FCSI_LOCENTHB_enable_hbsw1_pll0->setLongName ("ENABLE HBSW1 PLL0");
  f_FCSI_LOCENTHB_enable_hbsw1_pll0->setDescription ("Enable HB FOB for PLL0");
  f_FCSI_LOCENTHB_enable_hbsw1_pll0->setDataWidth (1);
  f_FCSI_LOCENTHB_enable_hbsw1_pll0->setResetVal ("1'b1");
  f_FCSI_LOCENTHB_enable_hbsw1_pll0->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_enable_hbsw1_pll0, 0);

  Attribute* a_FCSI_LOCENTHB_enable_hbsw1_pll0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_enable_hbsw1_pll0_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_enable_hbsw1_pll0_0_0->setLongName ("");
  a_FCSI_LOCENTHB_enable_hbsw1_pll0_0_0->setDescription ("");
  a_FCSI_LOCENTHB_enable_hbsw1_pll0_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_enable_hbsw1_pll0_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_enable_hbsw1_pll0->connectAttribute (a_FCSI_LOCENTHB_enable_hbsw1_pll0_0_0);

  RField* f_FCSI_LOCENTHB_enable_hbsw2_pll0 = new RField;
  f_FCSI_LOCENTHB_enable_hbsw2_pll0->setInstName ("enable_hbsw2_pll0");
  f_FCSI_LOCENTHB_enable_hbsw2_pll0->setLongName ("ENABLE HBSW2 PLL0");
  f_FCSI_LOCENTHB_enable_hbsw2_pll0->setDescription ("Enable HB buffer for PLL0");
  f_FCSI_LOCENTHB_enable_hbsw2_pll0->setDataWidth (1);
  f_FCSI_LOCENTHB_enable_hbsw2_pll0->setResetVal ("1'b1");
  f_FCSI_LOCENTHB_enable_hbsw2_pll0->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_enable_hbsw2_pll0, 1);

  Attribute* a_FCSI_LOCENTHB_enable_hbsw2_pll0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_enable_hbsw2_pll0_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_enable_hbsw2_pll0_0_0->setLongName ("");
  a_FCSI_LOCENTHB_enable_hbsw2_pll0_0_0->setDescription ("");
  a_FCSI_LOCENTHB_enable_hbsw2_pll0_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_enable_hbsw2_pll0_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_enable_hbsw2_pll0->connectAttribute (a_FCSI_LOCENTHB_enable_hbsw2_pll0_0_0);

  RField* f_FCSI_LOCENTHB_enable_hbv2i_pll0 = new RField;
  f_FCSI_LOCENTHB_enable_hbv2i_pll0->setInstName ("enable_hbv2i_pll0");
  f_FCSI_LOCENTHB_enable_hbv2i_pll0->setLongName ("ENABLE HBV2I PLL0");
  f_FCSI_LOCENTHB_enable_hbv2i_pll0->setDescription ("Enable HB V2I for PLL0");
  f_FCSI_LOCENTHB_enable_hbv2i_pll0->setDataWidth (1);
  f_FCSI_LOCENTHB_enable_hbv2i_pll0->setResetVal ("1'b1");
  f_FCSI_LOCENTHB_enable_hbv2i_pll0->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_enable_hbv2i_pll0, 2);

  Attribute* a_FCSI_LOCENTHB_enable_hbv2i_pll0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_enable_hbv2i_pll0_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_enable_hbv2i_pll0_0_0->setLongName ("");
  a_FCSI_LOCENTHB_enable_hbv2i_pll0_0_0->setDescription ("");
  a_FCSI_LOCENTHB_enable_hbv2i_pll0_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_enable_hbv2i_pll0_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_enable_hbv2i_pll0->connectAttribute (a_FCSI_LOCENTHB_enable_hbv2i_pll0_0_0);

  RField* f_FCSI_LOCENTHB_enable_hbsw1_pll1 = new RField;
  f_FCSI_LOCENTHB_enable_hbsw1_pll1->setInstName ("enable_hbsw1_pll1");
  f_FCSI_LOCENTHB_enable_hbsw1_pll1->setLongName ("ENABLE HBSW1 PLL1");
  f_FCSI_LOCENTHB_enable_hbsw1_pll1->setDescription ("Enable HB FOB for PLL1");
  f_FCSI_LOCENTHB_enable_hbsw1_pll1->setDataWidth (1);
  f_FCSI_LOCENTHB_enable_hbsw1_pll1->setResetVal ("1'b0");
  f_FCSI_LOCENTHB_enable_hbsw1_pll1->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_enable_hbsw1_pll1, 3);

  Attribute* a_FCSI_LOCENTHB_enable_hbsw1_pll1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_enable_hbsw1_pll1_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_enable_hbsw1_pll1_0_0->setLongName ("");
  a_FCSI_LOCENTHB_enable_hbsw1_pll1_0_0->setDescription ("");
  a_FCSI_LOCENTHB_enable_hbsw1_pll1_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_enable_hbsw1_pll1_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_enable_hbsw1_pll1->connectAttribute (a_FCSI_LOCENTHB_enable_hbsw1_pll1_0_0);

  RField* f_FCSI_LOCENTHB_enable_hbsw2_pll1 = new RField;
  f_FCSI_LOCENTHB_enable_hbsw2_pll1->setInstName ("enable_hbsw2_pll1");
  f_FCSI_LOCENTHB_enable_hbsw2_pll1->setLongName ("ENABLE HBSW2 PLL1");
  f_FCSI_LOCENTHB_enable_hbsw2_pll1->setDescription ("Enable HB buffer for PLL1");
  f_FCSI_LOCENTHB_enable_hbsw2_pll1->setDataWidth (1);
  f_FCSI_LOCENTHB_enable_hbsw2_pll1->setResetVal ("1'b0");
  f_FCSI_LOCENTHB_enable_hbsw2_pll1->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_enable_hbsw2_pll1, 4);

  Attribute* a_FCSI_LOCENTHB_enable_hbsw2_pll1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_enable_hbsw2_pll1_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_enable_hbsw2_pll1_0_0->setLongName ("");
  a_FCSI_LOCENTHB_enable_hbsw2_pll1_0_0->setDescription ("");
  a_FCSI_LOCENTHB_enable_hbsw2_pll1_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_enable_hbsw2_pll1_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_enable_hbsw2_pll1->connectAttribute (a_FCSI_LOCENTHB_enable_hbsw2_pll1_0_0);

  RField* f_FCSI_LOCENTHB_enable_hbv2i_pll1 = new RField;
  f_FCSI_LOCENTHB_enable_hbv2i_pll1->setInstName ("enable_hbv2i_pll1");
  f_FCSI_LOCENTHB_enable_hbv2i_pll1->setLongName ("ENABLE HBV2I PLL1");
  f_FCSI_LOCENTHB_enable_hbv2i_pll1->setDescription ("Enable HB V2I for PLL1");
  f_FCSI_LOCENTHB_enable_hbv2i_pll1->setDataWidth (1);
  f_FCSI_LOCENTHB_enable_hbv2i_pll1->setResetVal ("1'b0");
  f_FCSI_LOCENTHB_enable_hbv2i_pll1->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_enable_hbv2i_pll1, 5);

  Attribute* a_FCSI_LOCENTHB_enable_hbv2i_pll1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_enable_hbv2i_pll1_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_enable_hbv2i_pll1_0_0->setLongName ("");
  a_FCSI_LOCENTHB_enable_hbv2i_pll1_0_0->setDescription ("");
  a_FCSI_LOCENTHB_enable_hbv2i_pll1_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_enable_hbv2i_pll1_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_enable_hbv2i_pll1->connectAttribute (a_FCSI_LOCENTHB_enable_hbv2i_pll1_0_0);

  RField* f_FCSI_LOCENTHB_ctl_vout = new RField;
  f_FCSI_LOCENTHB_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_LOCENTHB_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_LOCENTHB_ctl_vout->setDescription ("Control output voltage of LOTREELDO");
  f_FCSI_LOCENTHB_ctl_vout->setDataWidth (4);
  f_FCSI_LOCENTHB_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_LOCENTHB_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_ctl_vout, 6);

  Attribute* a_FCSI_LOCENTHB_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_ctl_vout_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_ctl_vout_0_0->setLongName ("");
  a_FCSI_LOCENTHB_ctl_vout_0_0->setDescription ("");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("7", "4'b0111", "1.283V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("6", "4'b0110", "1.273V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("5", "4'b0101", "1.263V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("4", "4'b0100", "1.254V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("3", "4'b0011", "1.244V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("2", "4'b0010", "1.234V (default)");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("1", "4'b0001", "1.225V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("0", "4'b0000", "1.215V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("15", "4'b1111", "1.205V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("14", "4'b1110", "1.195V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("13", "4'b1101", "1.186V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("12", "4'b1100", "1.176V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("11", "4'b1011", "1.166V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("10", "4'b1010", "1.157V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("9", "4'b1001", "1.147V");
  a_FCSI_LOCENTHB_ctl_vout_0_0->addItem("8", "4'b1000", "1.137V");
  f_FCSI_LOCENTHB_ctl_vout->connectAttribute (a_FCSI_LOCENTHB_ctl_vout_0_0);

  RField* f_FCSI_LOCENTHB_ctl_lpgain = new RField;
  f_FCSI_LOCENTHB_ctl_lpgain->setInstName ("ctl_lpgain");
  f_FCSI_LOCENTHB_ctl_lpgain->setLongName ("CTL LPGAIN");
  f_FCSI_LOCENTHB_ctl_lpgain->setDescription ("Control loop gain");
  f_FCSI_LOCENTHB_ctl_lpgain->setDataWidth (1);
  f_FCSI_LOCENTHB_ctl_lpgain->setResetVal ("1'b0");
  f_FCSI_LOCENTHB_ctl_lpgain->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_ctl_lpgain, 10);

  Attribute* a_FCSI_LOCENTHB_ctl_lpgain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_ctl_lpgain_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_ctl_lpgain_0_0->setLongName ("");
  a_FCSI_LOCENTHB_ctl_lpgain_0_0->setDescription ("");
  a_FCSI_LOCENTHB_ctl_lpgain_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_ctl_lpgain_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_ctl_lpgain->connectAttribute (a_FCSI_LOCENTHB_ctl_lpgain_0_0);

  RField* f_FCSI_LOCENTHB_en_rload = new RField;
  f_FCSI_LOCENTHB_en_rload->setInstName ("en_rload");
  f_FCSI_LOCENTHB_en_rload->setLongName ("EN RLOAD");
  f_FCSI_LOCENTHB_en_rload->setDescription ("Enable resistive load");
  f_FCSI_LOCENTHB_en_rload->setDataWidth (1);
  f_FCSI_LOCENTHB_en_rload->setResetVal ("1'b0");
  f_FCSI_LOCENTHB_en_rload->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_en_rload, 11);

  Attribute* a_FCSI_LOCENTHB_en_rload_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_en_rload_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_en_rload_0_0->setLongName ("");
  a_FCSI_LOCENTHB_en_rload_0_0->setDescription ("");
  a_FCSI_LOCENTHB_en_rload_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_en_rload_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_en_rload->connectAttribute (a_FCSI_LOCENTHB_en_rload_0_0);

  RField* f_FCSI_LOCENTHB_en_ptrack = new RField;
  f_FCSI_LOCENTHB_en_ptrack->setInstName ("en_ptrack");
  f_FCSI_LOCENTHB_en_ptrack->setLongName ("EN PTRACK");
  f_FCSI_LOCENTHB_en_ptrack->setDescription ("Enable process tracking");
  f_FCSI_LOCENTHB_en_ptrack->setDataWidth (1);
  f_FCSI_LOCENTHB_en_ptrack->setResetVal ("1'b0");
  f_FCSI_LOCENTHB_en_ptrack->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_en_ptrack, 12);

  Attribute* a_FCSI_LOCENTHB_en_ptrack_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_en_ptrack_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_en_ptrack_0_0->setLongName ("");
  a_FCSI_LOCENTHB_en_ptrack_0_0->setDescription ("");
  a_FCSI_LOCENTHB_en_ptrack_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_en_ptrack_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_en_ptrack->connectAttribute (a_FCSI_LOCENTHB_en_ptrack_0_0);

  RField* f_FCSI_LOCENTHB_en_bypass = new RField;
  f_FCSI_LOCENTHB_en_bypass->setInstName ("en_bypass");
  f_FCSI_LOCENTHB_en_bypass->setLongName ("EN BYPASS");
  f_FCSI_LOCENTHB_en_bypass->setDescription ("Enable bypass mode");
  f_FCSI_LOCENTHB_en_bypass->setDataWidth (1);
  f_FCSI_LOCENTHB_en_bypass->setResetVal ("1'b0");
  f_FCSI_LOCENTHB_en_bypass->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_en_bypass, 13);

  Attribute* a_FCSI_LOCENTHB_en_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_en_bypass_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_en_bypass_0_0->setLongName ("");
  a_FCSI_LOCENTHB_en_bypass_0_0->setDescription ("");
  a_FCSI_LOCENTHB_en_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_en_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_en_bypass->connectAttribute (a_FCSI_LOCENTHB_en_bypass_0_0);

  RField* f_FCSI_LOCENTHB_enable_hbldo_test = new RField;
  f_FCSI_LOCENTHB_enable_hbldo_test->setInstName ("enable_hbldo_test");
  f_FCSI_LOCENTHB_enable_hbldo_test->setLongName ("ENABLE HB LDO TEST");
  f_FCSI_LOCENTHB_enable_hbldo_test->setDescription ("Enable HB LDO TEST output (to TEST_LDO pad)");
  f_FCSI_LOCENTHB_enable_hbldo_test->setDataWidth (1);
  f_FCSI_LOCENTHB_enable_hbldo_test->setResetVal ("1'b0");
  f_FCSI_LOCENTHB_enable_hbldo_test->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_enable_hbldo_test, 14);

  Attribute* a_FCSI_LOCENTHB_enable_hbldo_test_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_enable_hbldo_test_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_enable_hbldo_test_0_0->setLongName ("");
  a_FCSI_LOCENTHB_enable_hbldo_test_0_0->setDescription ("");
  a_FCSI_LOCENTHB_enable_hbldo_test_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_enable_hbldo_test_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_enable_hbldo_test->connectAttribute (a_FCSI_LOCENTHB_enable_hbldo_test_0_0);

  RField* f_FCSI_LOCENTHB_enable_hbldo = new RField;
  f_FCSI_LOCENTHB_enable_hbldo->setInstName ("enable_hbldo");
  f_FCSI_LOCENTHB_enable_hbldo->setLongName ("ENABLE HB LDO");
  f_FCSI_LOCENTHB_enable_hbldo->setDescription ("Enable HB LDO");
  f_FCSI_LOCENTHB_enable_hbldo->setDataWidth (1);
  f_FCSI_LOCENTHB_enable_hbldo->setResetVal ("1'b0");
  f_FCSI_LOCENTHB_enable_hbldo->setAccProp (AccProp::RW);
  r_FCSI_LOCENTHB->connectRField (f_FCSI_LOCENTHB_enable_hbldo, 15);

  Attribute* a_FCSI_LOCENTHB_enable_hbldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOCENTHB_enable_hbldo_0_0->setInstName ("0");
  a_FCSI_LOCENTHB_enable_hbldo_0_0->setLongName ("");
  a_FCSI_LOCENTHB_enable_hbldo_0_0->setDescription ("");
  a_FCSI_LOCENTHB_enable_hbldo_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOCENTHB_enable_hbldo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOCENTHB_enable_hbldo->connectAttribute (a_FCSI_LOCENTHB_enable_hbldo_0_0);

  Register* r_FCSI_BBIOCONF0 = new Register;
  r_FCSI_BBIOCONF0->setInstName ("BBIOCONF0");
  r_FCSI_BBIOCONF0->setLongName ("BBIO CONFIG0");
  r_FCSI_BBIOCONF0->setDescription ("FCSI-LDO1V2");
  r_FCSI_BBIOCONF0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_BBIOCONF0, 0x00000002);

  RField* f_FCSI_BBIOCONF0_enable_bbo_q = new RField;
  f_FCSI_BBIOCONF0_enable_bbo_q->setInstName ("enable_bbo_q");
  f_FCSI_BBIOCONF0_enable_bbo_q->setLongName ("ENABLE BBO Q");
  f_FCSI_BBIOCONF0_enable_bbo_q->setDescription ("Enable of BBO Q");
  f_FCSI_BBIOCONF0_enable_bbo_q->setDataWidth (1);
  f_FCSI_BBIOCONF0_enable_bbo_q->setResetVal ("1'b0");
  f_FCSI_BBIOCONF0_enable_bbo_q->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_enable_bbo_q, 0);

  Attribute* a_FCSI_BBIOCONF0_enable_bbo_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_enable_bbo_q_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_enable_bbo_q_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_enable_bbo_q_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_enable_bbo_q_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOCONF0_enable_bbo_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOCONF0_enable_bbo_q->connectAttribute (a_FCSI_BBIOCONF0_enable_bbo_q_0_0);

  RField* f_FCSI_BBIOCONF0_enable_in0_i = new RField;
  f_FCSI_BBIOCONF0_enable_in0_i->setInstName ("enable_in0_i");
  f_FCSI_BBIOCONF0_enable_in0_i->setLongName ("ENABLE IN0 I");
  f_FCSI_BBIOCONF0_enable_in0_i->setDescription ("Enable of in0 I");
  f_FCSI_BBIOCONF0_enable_in0_i->setDataWidth (1);
  f_FCSI_BBIOCONF0_enable_in0_i->setResetVal ("1'b0");
  f_FCSI_BBIOCONF0_enable_in0_i->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_enable_in0_i, 1);

  Attribute* a_FCSI_BBIOCONF0_enable_in0_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_enable_in0_i_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_enable_in0_i_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_enable_in0_i_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_enable_in0_i_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOCONF0_enable_in0_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOCONF0_enable_in0_i->connectAttribute (a_FCSI_BBIOCONF0_enable_in0_i_0_0);

  RField* f_FCSI_BBIOCONF0_ctl_en_bbo = new RField;
  f_FCSI_BBIOCONF0_ctl_en_bbo->setInstName ("ctl_en_bbo");
  f_FCSI_BBIOCONF0_ctl_en_bbo->setLongName ("CTL ENABLE BBO");
  f_FCSI_BBIOCONF0_ctl_en_bbo->setDescription ("Control enable BBO");
  f_FCSI_BBIOCONF0_ctl_en_bbo->setDataWidth (1);
  f_FCSI_BBIOCONF0_ctl_en_bbo->setResetVal ("1'b0");
  f_FCSI_BBIOCONF0_ctl_en_bbo->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_ctl_en_bbo, 2);

  Attribute* a_FCSI_BBIOCONF0_ctl_en_bbo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_ctl_en_bbo_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_ctl_en_bbo_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_ctl_en_bbo_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_ctl_en_bbo_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOCONF0_ctl_en_bbo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOCONF0_ctl_en_bbo->connectAttribute (a_FCSI_BBIOCONF0_ctl_en_bbo_0_0);

  RField* f_FCSI_BBIOCONF0_enable_in0_q = new RField;
  f_FCSI_BBIOCONF0_enable_in0_q->setInstName ("enable_in0_q");
  f_FCSI_BBIOCONF0_enable_in0_q->setLongName ("ENABLE IN0 Q");
  f_FCSI_BBIOCONF0_enable_in0_q->setDescription ("Enable in0 Q");
  f_FCSI_BBIOCONF0_enable_in0_q->setDataWidth (1);
  f_FCSI_BBIOCONF0_enable_in0_q->setResetVal ("1'b0");
  f_FCSI_BBIOCONF0_enable_in0_q->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_enable_in0_q, 3);

  Attribute* a_FCSI_BBIOCONF0_enable_in0_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_enable_in0_q_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_enable_in0_q_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_enable_in0_q_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_enable_in0_q_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOCONF0_enable_in0_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOCONF0_enable_in0_q->connectAttribute (a_FCSI_BBIOCONF0_enable_in0_q_0_0);

  RField* f_FCSI_BBIOCONF0_enable_bbo_i = new RField;
  f_FCSI_BBIOCONF0_enable_bbo_i->setInstName ("enable_bbo_i");
  f_FCSI_BBIOCONF0_enable_bbo_i->setLongName ("ENABLE BBO I");
  f_FCSI_BBIOCONF0_enable_bbo_i->setDescription ("Enable BBO I");
  f_FCSI_BBIOCONF0_enable_bbo_i->setDataWidth (1);
  f_FCSI_BBIOCONF0_enable_bbo_i->setResetVal ("1'b0");
  f_FCSI_BBIOCONF0_enable_bbo_i->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_enable_bbo_i, 4);

  Attribute* a_FCSI_BBIOCONF0_enable_bbo_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_enable_bbo_i_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_enable_bbo_i_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_enable_bbo_i_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_enable_bbo_i_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBIOCONF0_enable_bbo_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOCONF0_enable_bbo_i->connectAttribute (a_FCSI_BBIOCONF0_enable_bbo_i_0_0);

  RField* f_FCSI_BBIOCONF0_ctl_olgain_nop = new RField;
  f_FCSI_BBIOCONF0_ctl_olgain_nop->setInstName ("ctl_olgain_nop");
  f_FCSI_BBIOCONF0_ctl_olgain_nop->setLongName ("CTL OLGAIN NOP");
  f_FCSI_BBIOCONF0_ctl_olgain_nop->setDescription ("Control open loop gain in normal operation");
  f_FCSI_BBIOCONF0_ctl_olgain_nop->setDataWidth (3);
  f_FCSI_BBIOCONF0_ctl_olgain_nop->setResetVal ("3'b000");
  f_FCSI_BBIOCONF0_ctl_olgain_nop->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_ctl_olgain_nop, 5);

  Attribute* a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0->addItem("0", "3'b000", "29dB");
  a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0->addItem("3", "3'b011", "32dB");
  a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0->addItem("5", "3'b101", "35dB");
  a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0->addItem("6", "3'b110", "38dB");
  a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0->addItem("7", "3'b111", "41dB (default)");
  f_FCSI_BBIOCONF0_ctl_olgain_nop->connectAttribute (a_FCSI_BBIOCONF0_ctl_olgain_nop_0_0);

  RField* f_FCSI_BBIOCONF0_ctl_olgain_pup = new RField;
  f_FCSI_BBIOCONF0_ctl_olgain_pup->setInstName ("ctl_olgain_pup");
  f_FCSI_BBIOCONF0_ctl_olgain_pup->setLongName ("CTL OLGAIN PUP");
  f_FCSI_BBIOCONF0_ctl_olgain_pup->setDescription ("Control open loop gain in power up");
  f_FCSI_BBIOCONF0_ctl_olgain_pup->setDataWidth (3);
  f_FCSI_BBIOCONF0_ctl_olgain_pup->setResetVal ("3'b000");
  f_FCSI_BBIOCONF0_ctl_olgain_pup->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_ctl_olgain_pup, 8);

  Attribute* a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0->addItem("0", "3'b000", "29dB (default)");
  a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0->addItem("3", "3'b011", "32dB");
  a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0->addItem("5", "3'b101", "35dB");
  a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0->addItem("6", "3'b110", "38dB");
  a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0->addItem("7", "3'b111", "41dB");
  f_FCSI_BBIOCONF0_ctl_olgain_pup->connectAttribute (a_FCSI_BBIOCONF0_ctl_olgain_pup_0_0);

  RField* f_FCSI_BBIOCONF0_ctl_cm_gain = new RField;
  f_FCSI_BBIOCONF0_ctl_cm_gain->setInstName ("ctl_cm_gain");
  f_FCSI_BBIOCONF0_ctl_cm_gain->setLongName ("CTL CM GAIN");
  f_FCSI_BBIOCONF0_ctl_cm_gain->setDescription ("Control common mode loop gain of BBIO buffer");
  f_FCSI_BBIOCONF0_ctl_cm_gain->setDataWidth (2);
  f_FCSI_BBIOCONF0_ctl_cm_gain->setResetVal ("2'b00");
  f_FCSI_BBIOCONF0_ctl_cm_gain->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_ctl_cm_gain, 11);

  Attribute* a_FCSI_BBIOCONF0_ctl_cm_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_ctl_cm_gain_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_ctl_cm_gain_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_ctl_cm_gain_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_ctl_cm_gain_0_0->addItem("2", "2'b10", "31dB (default)");
  a_FCSI_BBIOCONF0_ctl_cm_gain_0_0->addItem("1", "2'b01", "36dB");
  a_FCSI_BBIOCONF0_ctl_cm_gain_0_0->addItem("0", "2'b00", "40dB");
  f_FCSI_BBIOCONF0_ctl_cm_gain->connectAttribute (a_FCSI_BBIOCONF0_ctl_cm_gain_0_0);

  RField* f_FCSI_BBIOCONF0_ctl_vcm_in = new RField;
  f_FCSI_BBIOCONF0_ctl_vcm_in->setInstName ("ctl_vcm_in");
  f_FCSI_BBIOCONF0_ctl_vcm_in->setLongName ("CTL VCM IN");
  f_FCSI_BBIOCONF0_ctl_vcm_in->setDescription ("Control opamp input common mode voltage");
  f_FCSI_BBIOCONF0_ctl_vcm_in->setDataWidth (2);
  f_FCSI_BBIOCONF0_ctl_vcm_in->setResetVal ("2'b00");
  f_FCSI_BBIOCONF0_ctl_vcm_in->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_ctl_vcm_in, 13);

  Attribute* a_FCSI_BBIOCONF0_ctl_vcm_in_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_ctl_vcm_in_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_ctl_vcm_in_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_ctl_vcm_in_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_ctl_vcm_in_0_0->addItem("2", "2'b10", "500mV");
  a_FCSI_BBIOCONF0_ctl_vcm_in_0_0->addItem("1", "2'b01", "450mV");
  a_FCSI_BBIOCONF0_ctl_vcm_in_0_0->addItem("0", "2'b00", "550mV (default)");
  f_FCSI_BBIOCONF0_ctl_vcm_in->connectAttribute (a_FCSI_BBIOCONF0_ctl_vcm_in_0_0);

  RField* f_FCSI_BBIOCONF0_ctl_psave_cm = new RField;
  f_FCSI_BBIOCONF0_ctl_psave_cm->setInstName ("ctl_psave_cm");
  f_FCSI_BBIOCONF0_ctl_psave_cm->setLongName ("CTL PSAVE CM");
  f_FCSI_BBIOCONF0_ctl_psave_cm->setDescription ("Power save modes of BBIO buffer common mode stage");
  f_FCSI_BBIOCONF0_ctl_psave_cm->setDataWidth (1);
  f_FCSI_BBIOCONF0_ctl_psave_cm->setResetVal ("1'b0");
  f_FCSI_BBIOCONF0_ctl_psave_cm->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF0->connectRField (f_FCSI_BBIOCONF0_ctl_psave_cm, 15);

  Attribute* a_FCSI_BBIOCONF0_ctl_psave_cm_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF0_ctl_psave_cm_0_0->setInstName ("0");
  a_FCSI_BBIOCONF0_ctl_psave_cm_0_0->setLongName ("");
  a_FCSI_BBIOCONF0_ctl_psave_cm_0_0->setDescription ("");
  a_FCSI_BBIOCONF0_ctl_psave_cm_0_0->addItem("1", "1'b1", "-500uA");
  a_FCSI_BBIOCONF0_ctl_psave_cm_0_0->addItem("0", "1'b0", "Full power (default)");
  f_FCSI_BBIOCONF0_ctl_psave_cm->connectAttribute (a_FCSI_BBIOCONF0_ctl_psave_cm_0_0);

  Register* r_FCSI_BBIOCONF1 = new Register;
  r_FCSI_BBIOCONF1->setInstName ("BBIOCONF1");
  r_FCSI_BBIOCONF1->setLongName ("BBIO CONFIG1");
  r_FCSI_BBIOCONF1->setDescription ("FCSI-LDO1V2");
  r_FCSI_BBIOCONF1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_BBIOCONF1, 0x00000003);

  RField* f_FCSI_BBIOCONF1_ctl_bbo_psave_LP = new RField;
  f_FCSI_BBIOCONF1_ctl_bbo_psave_LP->setInstName ("ctl_bbo_psave_LP");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_LP->setLongName ("CTL BBO PSAVE LP");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_LP->setDescription ("Control low power save mode for BBO buffer");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_LP->setDataWidth (3);
  f_FCSI_BBIOCONF1_ctl_bbo_psave_LP->setResetVal ("3'b000");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_LP->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF1->connectRField (f_FCSI_BBIOCONF1_ctl_bbo_psave_LP, 0);

  Attribute* a_FCSI_BBIOCONF1_ctl_bbo_psave_LP_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF1_ctl_bbo_psave_LP_0_0->setInstName ("0");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_LP_0_0->setLongName ("");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_LP_0_0->setDescription ("");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_LP_0_0->addItem("0", "3'b000", "Full power");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_LP_0_0->addItem("1", "3'b001", "-1mA");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_LP_0_0->addItem("3", "3'b011", "-2mA");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_LP_0_0->addItem("7", "3'b111", "-3mA (default)");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_LP->connectAttribute (a_FCSI_BBIOCONF1_ctl_bbo_psave_LP_0_0);

  RField* f_FCSI_BBIOCONF1_ctl_bbo_psave_RP = new RField;
  f_FCSI_BBIOCONF1_ctl_bbo_psave_RP->setInstName ("ctl_bbo_psave_RP");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_RP->setLongName ("CTL BBO PSAVE RP");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_RP->setDescription ("Control reduced power save mode for BBO buffer");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_RP->setDataWidth (3);
  f_FCSI_BBIOCONF1_ctl_bbo_psave_RP->setResetVal ("3'b000");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_RP->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF1->connectRField (f_FCSI_BBIOCONF1_ctl_bbo_psave_RP, 3);

  Attribute* a_FCSI_BBIOCONF1_ctl_bbo_psave_RP_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF1_ctl_bbo_psave_RP_0_0->setInstName ("0");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_RP_0_0->setLongName ("");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_RP_0_0->setDescription ("");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_RP_0_0->addItem("0", "3'b000", "Full power");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_RP_0_0->addItem("1", "3'b001", "-1mA");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_RP_0_0->addItem("3", "3'b011", "-2mA (default)");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_RP_0_0->addItem("7", "3'b111", "-3mA");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_RP->connectAttribute (a_FCSI_BBIOCONF1_ctl_bbo_psave_RP_0_0);

  RField* f_FCSI_BBIOCONF1_ctl_bbo_psave_HP = new RField;
  f_FCSI_BBIOCONF1_ctl_bbo_psave_HP->setInstName ("ctl_bbo_psave_HP");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_HP->setLongName ("CTL BBO PSAVE HP");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_HP->setDescription ("Control high power save mode for BBO buffer");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_HP->setDataWidth (3);
  f_FCSI_BBIOCONF1_ctl_bbo_psave_HP->setResetVal ("3'b000");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_HP->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF1->connectRField (f_FCSI_BBIOCONF1_ctl_bbo_psave_HP, 6);

  Attribute* a_FCSI_BBIOCONF1_ctl_bbo_psave_HP_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF1_ctl_bbo_psave_HP_0_0->setInstName ("0");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_HP_0_0->setLongName ("");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_HP_0_0->setDescription ("");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_HP_0_0->addItem("0", "3'b000", "Full power (default)");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_HP_0_0->addItem("1", "3'b001", "-1mA");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_HP_0_0->addItem("3", "3'b011", "-2mA");
  a_FCSI_BBIOCONF1_ctl_bbo_psave_HP_0_0->addItem("7", "3'b111", "-3mA");
  f_FCSI_BBIOCONF1_ctl_bbo_psave_HP->connectAttribute (a_FCSI_BBIOCONF1_ctl_bbo_psave_HP_0_0);

  RField* f_FCSI_BBIOCONF1_ctl_bbo_bw2040 = new RField;
  f_FCSI_BBIOCONF1_ctl_bbo_bw2040->setInstName ("ctl_bbo_bw2040");
  f_FCSI_BBIOCONF1_ctl_bbo_bw2040->setLongName ("CTL BBO BW2040");
  f_FCSI_BBIOCONF1_ctl_bbo_bw2040->setDescription ("Control BBO feedback capacitor (BW 20/40MHz)");
  f_FCSI_BBIOCONF1_ctl_bbo_bw2040->setDataWidth (2);
  f_FCSI_BBIOCONF1_ctl_bbo_bw2040->setResetVal ("2'b00");
  f_FCSI_BBIOCONF1_ctl_bbo_bw2040->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF1->connectRField (f_FCSI_BBIOCONF1_ctl_bbo_bw2040, 9);

  Attribute* a_FCSI_BBIOCONF1_ctl_bbo_bw2040_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF1_ctl_bbo_bw2040_0_0->setInstName ("0");
  a_FCSI_BBIOCONF1_ctl_bbo_bw2040_0_0->setLongName ("");
  a_FCSI_BBIOCONF1_ctl_bbo_bw2040_0_0->setDescription ("");
  a_FCSI_BBIOCONF1_ctl_bbo_bw2040_0_0->addItem("3", "2'b11", "1350fF (default)");
  a_FCSI_BBIOCONF1_ctl_bbo_bw2040_0_0->addItem("1", "2'b01", "900fF");
  a_FCSI_BBIOCONF1_ctl_bbo_bw2040_0_0->addItem("0", "2'b00", "450fF");
  f_FCSI_BBIOCONF1_ctl_bbo_bw2040->connectAttribute (a_FCSI_BBIOCONF1_ctl_bbo_bw2040_0_0);

  RField* f_FCSI_BBIOCONF1_ctl_bbo_bw80 = new RField;
  f_FCSI_BBIOCONF1_ctl_bbo_bw80->setInstName ("ctl_bbo_bw80");
  f_FCSI_BBIOCONF1_ctl_bbo_bw80->setLongName ("CTL BBO BW80");
  f_FCSI_BBIOCONF1_ctl_bbo_bw80->setDescription ("Control BBO feedback capacitor (BW 80MHz)");
  f_FCSI_BBIOCONF1_ctl_bbo_bw80->setDataWidth (2);
  f_FCSI_BBIOCONF1_ctl_bbo_bw80->setResetVal ("2'b00");
  f_FCSI_BBIOCONF1_ctl_bbo_bw80->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF1->connectRField (f_FCSI_BBIOCONF1_ctl_bbo_bw80, 11);

  Attribute* a_FCSI_BBIOCONF1_ctl_bbo_bw80_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF1_ctl_bbo_bw80_0_0->setInstName ("0");
  a_FCSI_BBIOCONF1_ctl_bbo_bw80_0_0->setLongName ("");
  a_FCSI_BBIOCONF1_ctl_bbo_bw80_0_0->setDescription ("");
  a_FCSI_BBIOCONF1_ctl_bbo_bw80_0_0->addItem("3", "2'b11", "1350fF");
  a_FCSI_BBIOCONF1_ctl_bbo_bw80_0_0->addItem("1", "2'b01", "900fF (default)");
  a_FCSI_BBIOCONF1_ctl_bbo_bw80_0_0->addItem("0", "2'b00", "450fF");
  f_FCSI_BBIOCONF1_ctl_bbo_bw80->connectAttribute (a_FCSI_BBIOCONF1_ctl_bbo_bw80_0_0);

  RField* f_FCSI_BBIOCONF1_ctl_bbo_bw160 = new RField;
  f_FCSI_BBIOCONF1_ctl_bbo_bw160->setInstName ("ctl_bbo_bw160");
  f_FCSI_BBIOCONF1_ctl_bbo_bw160->setLongName ("CTL BBO BW160");
  f_FCSI_BBIOCONF1_ctl_bbo_bw160->setDescription ("Control BBO feedback capacitor (BW 160MHz)");
  f_FCSI_BBIOCONF1_ctl_bbo_bw160->setDataWidth (2);
  f_FCSI_BBIOCONF1_ctl_bbo_bw160->setResetVal ("2'b00");
  f_FCSI_BBIOCONF1_ctl_bbo_bw160->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF1->connectRField (f_FCSI_BBIOCONF1_ctl_bbo_bw160, 13);

  Attribute* a_FCSI_BBIOCONF1_ctl_bbo_bw160_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF1_ctl_bbo_bw160_0_0->setInstName ("0");
  a_FCSI_BBIOCONF1_ctl_bbo_bw160_0_0->setLongName ("");
  a_FCSI_BBIOCONF1_ctl_bbo_bw160_0_0->setDescription ("");
  a_FCSI_BBIOCONF1_ctl_bbo_bw160_0_0->addItem("3", "2'b11", "1350fF");
  a_FCSI_BBIOCONF1_ctl_bbo_bw160_0_0->addItem("1", "2'b01", "900fF");
  a_FCSI_BBIOCONF1_ctl_bbo_bw160_0_0->addItem("0", "2'b00", "450fF (default)");
  f_FCSI_BBIOCONF1_ctl_bbo_bw160->connectAttribute (a_FCSI_BBIOCONF1_ctl_bbo_bw160_0_0);

  RField* f_FCSI_BBIOCONF1_ctl_soft_pup = new RField;
  f_FCSI_BBIOCONF1_ctl_soft_pup->setInstName ("ctl_soft_pup");
  f_FCSI_BBIOCONF1_ctl_soft_pup->setLongName ("CTL SOFT PUP");
  f_FCSI_BBIOCONF1_ctl_soft_pup->setDescription ("Control soft power up");
  f_FCSI_BBIOCONF1_ctl_soft_pup->setDataWidth (1);
  f_FCSI_BBIOCONF1_ctl_soft_pup->setResetVal ("1'b0");
  f_FCSI_BBIOCONF1_ctl_soft_pup->setAccProp (AccProp::RW);
  r_FCSI_BBIOCONF1->connectRField (f_FCSI_BBIOCONF1_ctl_soft_pup, 15);

  Attribute* a_FCSI_BBIOCONF1_ctl_soft_pup_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBIOCONF1_ctl_soft_pup_0_0->setInstName ("0");
  a_FCSI_BBIOCONF1_ctl_soft_pup_0_0->setLongName ("");
  a_FCSI_BBIOCONF1_ctl_soft_pup_0_0->setDescription ("");
  a_FCSI_BBIOCONF1_ctl_soft_pup_0_0->addItem("1", "1'b1", "enable (default)");
  a_FCSI_BBIOCONF1_ctl_soft_pup_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBIOCONF1_ctl_soft_pup->connectAttribute (a_FCSI_BBIOCONF1_ctl_soft_pup_0_0);

  Register* r_FCSI_TXHBLDO1V2 = new Register;
  r_FCSI_TXHBLDO1V2->setInstName ("TXHBLDO1V2");
  r_FCSI_TXHBLDO1V2->setLongName ("RF LDO1V2 TX HB");
  r_FCSI_TXHBLDO1V2->setDescription ("FCSI-LDO1V2");
  r_FCSI_TXHBLDO1V2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TXHBLDO1V2, 0x00000004);

  RField* f_FCSI_TXHBLDO1V2_enable = new RField;
  f_FCSI_TXHBLDO1V2_enable->setInstName ("enable");
  f_FCSI_TXHBLDO1V2_enable->setLongName ("ENABLE");
  f_FCSI_TXHBLDO1V2_enable->setDescription ("Enable TX HB LDO");
  f_FCSI_TXHBLDO1V2_enable->setDataWidth (1);
  f_FCSI_TXHBLDO1V2_enable->setResetVal ("1'b0");
  f_FCSI_TXHBLDO1V2_enable->setAccProp (AccProp::RW);
  r_FCSI_TXHBLDO1V2->connectRField (f_FCSI_TXHBLDO1V2_enable, 0);

  Attribute* a_FCSI_TXHBLDO1V2_enable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXHBLDO1V2_enable_0_0->setInstName ("0");
  a_FCSI_TXHBLDO1V2_enable_0_0->setLongName ("");
  a_FCSI_TXHBLDO1V2_enable_0_0->setDescription ("");
  a_FCSI_TXHBLDO1V2_enable_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TXHBLDO1V2_enable_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TXHBLDO1V2_enable->connectAttribute (a_FCSI_TXHBLDO1V2_enable_0_0);

  RField* f_FCSI_TXHBLDO1V2_en_rload = new RField;
  f_FCSI_TXHBLDO1V2_en_rload->setInstName ("en_rload");
  f_FCSI_TXHBLDO1V2_en_rload->setLongName ("ENABLE RLOAD");
  f_FCSI_TXHBLDO1V2_en_rload->setDescription ("Enable resistive load");
  f_FCSI_TXHBLDO1V2_en_rload->setDataWidth (1);
  f_FCSI_TXHBLDO1V2_en_rload->setResetVal ("1'b0");
  f_FCSI_TXHBLDO1V2_en_rload->setAccProp (AccProp::RW);
  r_FCSI_TXHBLDO1V2->connectRField (f_FCSI_TXHBLDO1V2_en_rload, 1);

  Attribute* a_FCSI_TXHBLDO1V2_en_rload_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXHBLDO1V2_en_rload_0_0->setInstName ("0");
  a_FCSI_TXHBLDO1V2_en_rload_0_0->setLongName ("");
  a_FCSI_TXHBLDO1V2_en_rload_0_0->setDescription ("");
  a_FCSI_TXHBLDO1V2_en_rload_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TXHBLDO1V2_en_rload_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TXHBLDO1V2_en_rload->connectAttribute (a_FCSI_TXHBLDO1V2_en_rload_0_0);

  RField* f_FCSI_TXHBLDO1V2_en_bypass = new RField;
  f_FCSI_TXHBLDO1V2_en_bypass->setInstName ("en_bypass");
  f_FCSI_TXHBLDO1V2_en_bypass->setLongName ("ENABLE BYPASS");
  f_FCSI_TXHBLDO1V2_en_bypass->setDescription ("Enable bypass mode");
  f_FCSI_TXHBLDO1V2_en_bypass->setDataWidth (1);
  f_FCSI_TXHBLDO1V2_en_bypass->setResetVal ("1'b0");
  f_FCSI_TXHBLDO1V2_en_bypass->setAccProp (AccProp::RW);
  r_FCSI_TXHBLDO1V2->connectRField (f_FCSI_TXHBLDO1V2_en_bypass, 2);

  Attribute* a_FCSI_TXHBLDO1V2_en_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXHBLDO1V2_en_bypass_0_0->setInstName ("0");
  a_FCSI_TXHBLDO1V2_en_bypass_0_0->setLongName ("");
  a_FCSI_TXHBLDO1V2_en_bypass_0_0->setDescription ("");
  a_FCSI_TXHBLDO1V2_en_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TXHBLDO1V2_en_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TXHBLDO1V2_en_bypass->connectAttribute (a_FCSI_TXHBLDO1V2_en_bypass_0_0);

  RField* f_FCSI_TXHBLDO1V2_ctl_vout = new RField;
  f_FCSI_TXHBLDO1V2_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_TXHBLDO1V2_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_TXHBLDO1V2_ctl_vout->setDescription ("Control output voltage");
  f_FCSI_TXHBLDO1V2_ctl_vout->setDataWidth (4);
  f_FCSI_TXHBLDO1V2_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_TXHBLDO1V2_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_TXHBLDO1V2->connectRField (f_FCSI_TXHBLDO1V2_ctl_vout, 3);

  Attribute* a_FCSI_TXHBLDO1V2_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->setInstName ("0");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->setLongName ("");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->setDescription ("");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_TXHBLDO1V2_ctl_vout_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_TXHBLDO1V2_ctl_vout->connectAttribute (a_FCSI_TXHBLDO1V2_ctl_vout_0_0);

  RField* f_FCSI_TXHBLDO1V2_ctl_comp = new RField;
  f_FCSI_TXHBLDO1V2_ctl_comp->setInstName ("ctl_comp");
  f_FCSI_TXHBLDO1V2_ctl_comp->setLongName ("CTL COMP");
  f_FCSI_TXHBLDO1V2_ctl_comp->setDescription ("Control compensation capacitor");
  f_FCSI_TXHBLDO1V2_ctl_comp->setDataWidth (2);
  f_FCSI_TXHBLDO1V2_ctl_comp->setResetVal ("2'b00");
  f_FCSI_TXHBLDO1V2_ctl_comp->setAccProp (AccProp::RW);
  r_FCSI_TXHBLDO1V2->connectRField (f_FCSI_TXHBLDO1V2_ctl_comp, 7);

  Attribute* a_FCSI_TXHBLDO1V2_ctl_comp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXHBLDO1V2_ctl_comp_0_0->setInstName ("0");
  a_FCSI_TXHBLDO1V2_ctl_comp_0_0->setLongName ("");
  a_FCSI_TXHBLDO1V2_ctl_comp_0_0->setDescription ("");
  a_FCSI_TXHBLDO1V2_ctl_comp_0_0->addItem("3", "2'b11", "5pF");
  a_FCSI_TXHBLDO1V2_ctl_comp_0_0->addItem("2", "2'b10", "4pF");
  a_FCSI_TXHBLDO1V2_ctl_comp_0_0->addItem("1", "2'b01", "4.5pF");
  a_FCSI_TXHBLDO1V2_ctl_comp_0_0->addItem("0", "2'b00", "3.5pF");
  f_FCSI_TXHBLDO1V2_ctl_comp->connectAttribute (a_FCSI_TXHBLDO1V2_ctl_comp_0_0);

  RField* f_FCSI_TXHBLDO1V2_ctl_buf = new RField;
  f_FCSI_TXHBLDO1V2_ctl_buf->setInstName ("ctl_buf");
  f_FCSI_TXHBLDO1V2_ctl_buf->setLongName ("CTL BUF");
  f_FCSI_TXHBLDO1V2_ctl_buf->setDescription ("Control buffer current");
  f_FCSI_TXHBLDO1V2_ctl_buf->setDataWidth (1);
  f_FCSI_TXHBLDO1V2_ctl_buf->setResetVal ("1'b0");
  f_FCSI_TXHBLDO1V2_ctl_buf->setAccProp (AccProp::RW);
  r_FCSI_TXHBLDO1V2->connectRField (f_FCSI_TXHBLDO1V2_ctl_buf, 9);

  Attribute* a_FCSI_TXHBLDO1V2_ctl_buf_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXHBLDO1V2_ctl_buf_0_0->setInstName ("0");
  a_FCSI_TXHBLDO1V2_ctl_buf_0_0->setLongName ("");
  a_FCSI_TXHBLDO1V2_ctl_buf_0_0->setDescription ("");
  a_FCSI_TXHBLDO1V2_ctl_buf_0_0->addItem("1", "1'b1", "1mA");
  a_FCSI_TXHBLDO1V2_ctl_buf_0_0->addItem("0", "1'b0", "0.5mA");
  f_FCSI_TXHBLDO1V2_ctl_buf->connectAttribute (a_FCSI_TXHBLDO1V2_ctl_buf_0_0);

  RField* f_FCSI_TXHBLDO1V2_ctl_enable_txon = new RField;
  f_FCSI_TXHBLDO1V2_ctl_enable_txon->setInstName ("ctl_enable_txon");
  f_FCSI_TXHBLDO1V2_ctl_enable_txon->setLongName ("CTL ENABLE_TXON");
  f_FCSI_TXHBLDO1V2_ctl_enable_txon->setDescription ("Control enable txon");
  f_FCSI_TXHBLDO1V2_ctl_enable_txon->setDataWidth (1);
  f_FCSI_TXHBLDO1V2_ctl_enable_txon->setResetVal ("1'b0");
  f_FCSI_TXHBLDO1V2_ctl_enable_txon->setAccProp (AccProp::RW);
  r_FCSI_TXHBLDO1V2->connectRField (f_FCSI_TXHBLDO1V2_ctl_enable_txon, 10);

  Attribute* a_FCSI_TXHBLDO1V2_ctl_enable_txon_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXHBLDO1V2_ctl_enable_txon_0_0->setInstName ("0");
  a_FCSI_TXHBLDO1V2_ctl_enable_txon_0_0->setLongName ("");
  a_FCSI_TXHBLDO1V2_ctl_enable_txon_0_0->setDescription ("");
  a_FCSI_TXHBLDO1V2_ctl_enable_txon_0_0->addItem("1", "1'b1", "1mA");
  a_FCSI_TXHBLDO1V2_ctl_enable_txon_0_0->addItem("0", "1'b0", "0.5mA");
  f_FCSI_TXHBLDO1V2_ctl_enable_txon->connectAttribute (a_FCSI_TXHBLDO1V2_ctl_enable_txon_0_0);

  Register* r_FCSI_TXLBLDO1V2 = new Register;
  r_FCSI_TXLBLDO1V2->setInstName ("TXLBLDO1V2");
  r_FCSI_TXLBLDO1V2->setLongName ("RF LDO1V2 TX LB");
  r_FCSI_TXLBLDO1V2->setDescription ("FCSI-LDO1V2");
  r_FCSI_TXLBLDO1V2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TXLBLDO1V2, 0x00000005);

  RField* f_FCSI_TXLBLDO1V2_enable = new RField;
  f_FCSI_TXLBLDO1V2_enable->setInstName ("enable");
  f_FCSI_TXLBLDO1V2_enable->setLongName ("ENABLE");
  f_FCSI_TXLBLDO1V2_enable->setDescription ("Enable TX LB LDO");
  f_FCSI_TXLBLDO1V2_enable->setDataWidth (1);
  f_FCSI_TXLBLDO1V2_enable->setResetVal ("1'b0");
  f_FCSI_TXLBLDO1V2_enable->setAccProp (AccProp::RW);
  r_FCSI_TXLBLDO1V2->connectRField (f_FCSI_TXLBLDO1V2_enable, 0);

  Attribute* a_FCSI_TXLBLDO1V2_enable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXLBLDO1V2_enable_0_0->setInstName ("0");
  a_FCSI_TXLBLDO1V2_enable_0_0->setLongName ("");
  a_FCSI_TXLBLDO1V2_enable_0_0->setDescription ("");
  a_FCSI_TXLBLDO1V2_enable_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TXLBLDO1V2_enable_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TXLBLDO1V2_enable->connectAttribute (a_FCSI_TXLBLDO1V2_enable_0_0);

  RField* f_FCSI_TXLBLDO1V2_en_rload = new RField;
  f_FCSI_TXLBLDO1V2_en_rload->setInstName ("en_rload");
  f_FCSI_TXLBLDO1V2_en_rload->setLongName ("ENABLE RLOAD");
  f_FCSI_TXLBLDO1V2_en_rload->setDescription ("Enable resistive load");
  f_FCSI_TXLBLDO1V2_en_rload->setDataWidth (1);
  f_FCSI_TXLBLDO1V2_en_rload->setResetVal ("1'b0");
  f_FCSI_TXLBLDO1V2_en_rload->setAccProp (AccProp::RW);
  r_FCSI_TXLBLDO1V2->connectRField (f_FCSI_TXLBLDO1V2_en_rload, 1);

  Attribute* a_FCSI_TXLBLDO1V2_en_rload_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXLBLDO1V2_en_rload_0_0->setInstName ("0");
  a_FCSI_TXLBLDO1V2_en_rload_0_0->setLongName ("");
  a_FCSI_TXLBLDO1V2_en_rload_0_0->setDescription ("");
  a_FCSI_TXLBLDO1V2_en_rload_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TXLBLDO1V2_en_rload_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TXLBLDO1V2_en_rload->connectAttribute (a_FCSI_TXLBLDO1V2_en_rload_0_0);

  RField* f_FCSI_TXLBLDO1V2_en_bypass = new RField;
  f_FCSI_TXLBLDO1V2_en_bypass->setInstName ("en_bypass");
  f_FCSI_TXLBLDO1V2_en_bypass->setLongName ("ENABLE BYPASS");
  f_FCSI_TXLBLDO1V2_en_bypass->setDescription ("Enable bypass mode");
  f_FCSI_TXLBLDO1V2_en_bypass->setDataWidth (1);
  f_FCSI_TXLBLDO1V2_en_bypass->setResetVal ("1'b0");
  f_FCSI_TXLBLDO1V2_en_bypass->setAccProp (AccProp::RW);
  r_FCSI_TXLBLDO1V2->connectRField (f_FCSI_TXLBLDO1V2_en_bypass, 2);

  Attribute* a_FCSI_TXLBLDO1V2_en_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXLBLDO1V2_en_bypass_0_0->setInstName ("0");
  a_FCSI_TXLBLDO1V2_en_bypass_0_0->setLongName ("");
  a_FCSI_TXLBLDO1V2_en_bypass_0_0->setDescription ("");
  a_FCSI_TXLBLDO1V2_en_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TXLBLDO1V2_en_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TXLBLDO1V2_en_bypass->connectAttribute (a_FCSI_TXLBLDO1V2_en_bypass_0_0);

  RField* f_FCSI_TXLBLDO1V2_ctl_vout = new RField;
  f_FCSI_TXLBLDO1V2_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_TXLBLDO1V2_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_TXLBLDO1V2_ctl_vout->setDescription ("Control output voltage");
  f_FCSI_TXLBLDO1V2_ctl_vout->setDataWidth (4);
  f_FCSI_TXLBLDO1V2_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_TXLBLDO1V2_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_TXLBLDO1V2->connectRField (f_FCSI_TXLBLDO1V2_ctl_vout, 3);

  Attribute* a_FCSI_TXLBLDO1V2_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->setInstName ("0");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->setLongName ("");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->setDescription ("");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_TXLBLDO1V2_ctl_vout_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_TXLBLDO1V2_ctl_vout->connectAttribute (a_FCSI_TXLBLDO1V2_ctl_vout_0_0);

  RField* f_FCSI_TXLBLDO1V2_ctl_comp = new RField;
  f_FCSI_TXLBLDO1V2_ctl_comp->setInstName ("ctl_comp");
  f_FCSI_TXLBLDO1V2_ctl_comp->setLongName ("CTL COMP");
  f_FCSI_TXLBLDO1V2_ctl_comp->setDescription ("Control compensation capacitor");
  f_FCSI_TXLBLDO1V2_ctl_comp->setDataWidth (2);
  f_FCSI_TXLBLDO1V2_ctl_comp->setResetVal ("2'b00");
  f_FCSI_TXLBLDO1V2_ctl_comp->setAccProp (AccProp::RW);
  r_FCSI_TXLBLDO1V2->connectRField (f_FCSI_TXLBLDO1V2_ctl_comp, 7);

  Attribute* a_FCSI_TXLBLDO1V2_ctl_comp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXLBLDO1V2_ctl_comp_0_0->setInstName ("0");
  a_FCSI_TXLBLDO1V2_ctl_comp_0_0->setLongName ("");
  a_FCSI_TXLBLDO1V2_ctl_comp_0_0->setDescription ("");
  a_FCSI_TXLBLDO1V2_ctl_comp_0_0->addItem("3", "2'b11", "5pF");
  a_FCSI_TXLBLDO1V2_ctl_comp_0_0->addItem("2", "2'b10", "4pF");
  a_FCSI_TXLBLDO1V2_ctl_comp_0_0->addItem("1", "2'b01", "4.5pF");
  a_FCSI_TXLBLDO1V2_ctl_comp_0_0->addItem("0", "2'b00", "3.5pF");
  f_FCSI_TXLBLDO1V2_ctl_comp->connectAttribute (a_FCSI_TXLBLDO1V2_ctl_comp_0_0);

  RField* f_FCSI_TXLBLDO1V2_ctl_buf = new RField;
  f_FCSI_TXLBLDO1V2_ctl_buf->setInstName ("ctl_buf");
  f_FCSI_TXLBLDO1V2_ctl_buf->setLongName ("CTL BUF");
  f_FCSI_TXLBLDO1V2_ctl_buf->setDescription ("Control buffer current");
  f_FCSI_TXLBLDO1V2_ctl_buf->setDataWidth (1);
  f_FCSI_TXLBLDO1V2_ctl_buf->setResetVal ("1'b0");
  f_FCSI_TXLBLDO1V2_ctl_buf->setAccProp (AccProp::RW);
  r_FCSI_TXLBLDO1V2->connectRField (f_FCSI_TXLBLDO1V2_ctl_buf, 9);

  Attribute* a_FCSI_TXLBLDO1V2_ctl_buf_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXLBLDO1V2_ctl_buf_0_0->setInstName ("0");
  a_FCSI_TXLBLDO1V2_ctl_buf_0_0->setLongName ("");
  a_FCSI_TXLBLDO1V2_ctl_buf_0_0->setDescription ("");
  a_FCSI_TXLBLDO1V2_ctl_buf_0_0->addItem("1", "1'b1", "1mA");
  a_FCSI_TXLBLDO1V2_ctl_buf_0_0->addItem("0", "1'b0", "0.5mA");
  f_FCSI_TXLBLDO1V2_ctl_buf->connectAttribute (a_FCSI_TXLBLDO1V2_ctl_buf_0_0);

  RField* f_FCSI_TXLBLDO1V2_ctl_enable_txon = new RField;
  f_FCSI_TXLBLDO1V2_ctl_enable_txon->setInstName ("ctl_enable_txon");
  f_FCSI_TXLBLDO1V2_ctl_enable_txon->setLongName ("CTL ENABLE_TXON");
  f_FCSI_TXLBLDO1V2_ctl_enable_txon->setDescription ("Control enable txon");
  f_FCSI_TXLBLDO1V2_ctl_enable_txon->setDataWidth (1);
  f_FCSI_TXLBLDO1V2_ctl_enable_txon->setResetVal ("1'b0");
  f_FCSI_TXLBLDO1V2_ctl_enable_txon->setAccProp (AccProp::RW);
  r_FCSI_TXLBLDO1V2->connectRField (f_FCSI_TXLBLDO1V2_ctl_enable_txon, 10);

  Attribute* a_FCSI_TXLBLDO1V2_ctl_enable_txon_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TXLBLDO1V2_ctl_enable_txon_0_0->setInstName ("0");
  a_FCSI_TXLBLDO1V2_ctl_enable_txon_0_0->setLongName ("");
  a_FCSI_TXLBLDO1V2_ctl_enable_txon_0_0->setDescription ("");
  a_FCSI_TXLBLDO1V2_ctl_enable_txon_0_0->addItem("1", "1'b1", "1mA");
  a_FCSI_TXLBLDO1V2_ctl_enable_txon_0_0->addItem("0", "1'b0", "0.5mA");
  f_FCSI_TXLBLDO1V2_ctl_enable_txon->connectAttribute (a_FCSI_TXLBLDO1V2_ctl_enable_txon_0_0);

  Register* r_FCSI_RXLDO1V2 = new Register;
  r_FCSI_RXLDO1V2->setInstName ("RXLDO1V2");
  r_FCSI_RXLDO1V2->setLongName ("RF LDO1V2 RX");
  r_FCSI_RXLDO1V2->setDescription ("FCSI-LDO1V2");
  r_FCSI_RXLDO1V2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXLDO1V2, 0x00000006);

  RField* f_FCSI_RXLDO1V2_enable = new RField;
  f_FCSI_RXLDO1V2_enable->setInstName ("enable");
  f_FCSI_RXLDO1V2_enable->setLongName ("ENABLE");
  f_FCSI_RXLDO1V2_enable->setDescription ("Enable RX LDO");
  f_FCSI_RXLDO1V2_enable->setDataWidth (1);
  f_FCSI_RXLDO1V2_enable->setResetVal ("1'b0");
  f_FCSI_RXLDO1V2_enable->setAccProp (AccProp::RW);
  r_FCSI_RXLDO1V2->connectRField (f_FCSI_RXLDO1V2_enable, 0);

  Attribute* a_FCSI_RXLDO1V2_enable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXLDO1V2_enable_0_0->setInstName ("0");
  a_FCSI_RXLDO1V2_enable_0_0->setLongName ("");
  a_FCSI_RXLDO1V2_enable_0_0->setDescription ("");
  a_FCSI_RXLDO1V2_enable_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXLDO1V2_enable_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXLDO1V2_enable->connectAttribute (a_FCSI_RXLDO1V2_enable_0_0);

  RField* f_FCSI_RXLDO1V2_en_rload = new RField;
  f_FCSI_RXLDO1V2_en_rload->setInstName ("en_rload");
  f_FCSI_RXLDO1V2_en_rload->setLongName ("ENABLE RLOAD");
  f_FCSI_RXLDO1V2_en_rload->setDescription ("Enable resistive load");
  f_FCSI_RXLDO1V2_en_rload->setDataWidth (1);
  f_FCSI_RXLDO1V2_en_rload->setResetVal ("1'b0");
  f_FCSI_RXLDO1V2_en_rload->setAccProp (AccProp::RW);
  r_FCSI_RXLDO1V2->connectRField (f_FCSI_RXLDO1V2_en_rload, 1);

  Attribute* a_FCSI_RXLDO1V2_en_rload_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXLDO1V2_en_rload_0_0->setInstName ("0");
  a_FCSI_RXLDO1V2_en_rload_0_0->setLongName ("");
  a_FCSI_RXLDO1V2_en_rload_0_0->setDescription ("");
  a_FCSI_RXLDO1V2_en_rload_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXLDO1V2_en_rload_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXLDO1V2_en_rload->connectAttribute (a_FCSI_RXLDO1V2_en_rload_0_0);

  RField* f_FCSI_RXLDO1V2_en_bypass = new RField;
  f_FCSI_RXLDO1V2_en_bypass->setInstName ("en_bypass");
  f_FCSI_RXLDO1V2_en_bypass->setLongName ("ENABLE BYPASS");
  f_FCSI_RXLDO1V2_en_bypass->setDescription ("Enable bypass mode");
  f_FCSI_RXLDO1V2_en_bypass->setDataWidth (1);
  f_FCSI_RXLDO1V2_en_bypass->setResetVal ("1'b0");
  f_FCSI_RXLDO1V2_en_bypass->setAccProp (AccProp::RW);
  r_FCSI_RXLDO1V2->connectRField (f_FCSI_RXLDO1V2_en_bypass, 2);

  Attribute* a_FCSI_RXLDO1V2_en_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXLDO1V2_en_bypass_0_0->setInstName ("0");
  a_FCSI_RXLDO1V2_en_bypass_0_0->setLongName ("");
  a_FCSI_RXLDO1V2_en_bypass_0_0->setDescription ("");
  a_FCSI_RXLDO1V2_en_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXLDO1V2_en_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXLDO1V2_en_bypass->connectAttribute (a_FCSI_RXLDO1V2_en_bypass_0_0);

  RField* f_FCSI_RXLDO1V2_ctl_vout = new RField;
  f_FCSI_RXLDO1V2_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_RXLDO1V2_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_RXLDO1V2_ctl_vout->setDescription ("Control output voltage");
  f_FCSI_RXLDO1V2_ctl_vout->setDataWidth (4);
  f_FCSI_RXLDO1V2_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_RXLDO1V2_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_RXLDO1V2->connectRField (f_FCSI_RXLDO1V2_ctl_vout, 3);

  Attribute* a_FCSI_RXLDO1V2_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXLDO1V2_ctl_vout_0_0->setInstName ("0");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->setLongName ("");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->setDescription ("");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_RXLDO1V2_ctl_vout_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_RXLDO1V2_ctl_vout->connectAttribute (a_FCSI_RXLDO1V2_ctl_vout_0_0);

  RField* f_FCSI_RXLDO1V2_ctl_comp = new RField;
  f_FCSI_RXLDO1V2_ctl_comp->setInstName ("ctl_comp");
  f_FCSI_RXLDO1V2_ctl_comp->setLongName ("CTL COMP");
  f_FCSI_RXLDO1V2_ctl_comp->setDescription ("Control compensation capacitor");
  f_FCSI_RXLDO1V2_ctl_comp->setDataWidth (2);
  f_FCSI_RXLDO1V2_ctl_comp->setResetVal ("2'b00");
  f_FCSI_RXLDO1V2_ctl_comp->setAccProp (AccProp::RW);
  r_FCSI_RXLDO1V2->connectRField (f_FCSI_RXLDO1V2_ctl_comp, 7);

  Attribute* a_FCSI_RXLDO1V2_ctl_comp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXLDO1V2_ctl_comp_0_0->setInstName ("0");
  a_FCSI_RXLDO1V2_ctl_comp_0_0->setLongName ("");
  a_FCSI_RXLDO1V2_ctl_comp_0_0->setDescription ("");
  a_FCSI_RXLDO1V2_ctl_comp_0_0->addItem("3", "2'b11", "5pF");
  a_FCSI_RXLDO1V2_ctl_comp_0_0->addItem("2", "2'b10", "4pF");
  a_FCSI_RXLDO1V2_ctl_comp_0_0->addItem("1", "2'b01", "4.5pF");
  a_FCSI_RXLDO1V2_ctl_comp_0_0->addItem("0", "2'b00", "3.5pF");
  f_FCSI_RXLDO1V2_ctl_comp->connectAttribute (a_FCSI_RXLDO1V2_ctl_comp_0_0);

  RField* f_FCSI_RXLDO1V2_ctl_buf = new RField;
  f_FCSI_RXLDO1V2_ctl_buf->setInstName ("ctl_buf");
  f_FCSI_RXLDO1V2_ctl_buf->setLongName ("CTL BUF");
  f_FCSI_RXLDO1V2_ctl_buf->setDescription ("Control buffer current");
  f_FCSI_RXLDO1V2_ctl_buf->setDataWidth (1);
  f_FCSI_RXLDO1V2_ctl_buf->setResetVal ("1'b0");
  f_FCSI_RXLDO1V2_ctl_buf->setAccProp (AccProp::RW);
  r_FCSI_RXLDO1V2->connectRField (f_FCSI_RXLDO1V2_ctl_buf, 9);

  Attribute* a_FCSI_RXLDO1V2_ctl_buf_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXLDO1V2_ctl_buf_0_0->setInstName ("0");
  a_FCSI_RXLDO1V2_ctl_buf_0_0->setLongName ("");
  a_FCSI_RXLDO1V2_ctl_buf_0_0->setDescription ("");
  a_FCSI_RXLDO1V2_ctl_buf_0_0->addItem("1", "1'b1", "1mA");
  a_FCSI_RXLDO1V2_ctl_buf_0_0->addItem("0", "1'b0", "0.5mA");
  f_FCSI_RXLDO1V2_ctl_buf->connectAttribute (a_FCSI_RXLDO1V2_ctl_buf_0_0);

  RField* f_FCSI_RXLDO1V2_ctl_enable_txon = new RField;
  f_FCSI_RXLDO1V2_ctl_enable_txon->setInstName ("ctl_enable_txon");
  f_FCSI_RXLDO1V2_ctl_enable_txon->setLongName ("CTL ENABLE_TXON");
  f_FCSI_RXLDO1V2_ctl_enable_txon->setDescription ("Control enable txon");
  f_FCSI_RXLDO1V2_ctl_enable_txon->setDataWidth (1);
  f_FCSI_RXLDO1V2_ctl_enable_txon->setResetVal ("1'b0");
  f_FCSI_RXLDO1V2_ctl_enable_txon->setAccProp (AccProp::RW);
  r_FCSI_RXLDO1V2->connectRField (f_FCSI_RXLDO1V2_ctl_enable_txon, 10);

  Attribute* a_FCSI_RXLDO1V2_ctl_enable_txon_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXLDO1V2_ctl_enable_txon_0_0->setInstName ("0");
  a_FCSI_RXLDO1V2_ctl_enable_txon_0_0->setLongName ("");
  a_FCSI_RXLDO1V2_ctl_enable_txon_0_0->setDescription ("");
  a_FCSI_RXLDO1V2_ctl_enable_txon_0_0->addItem("1", "1'b1", "1mA");
  a_FCSI_RXLDO1V2_ctl_enable_txon_0_0->addItem("0", "1'b0", "0.5mA");
  f_FCSI_RXLDO1V2_ctl_enable_txon->connectAttribute (a_FCSI_RXLDO1V2_ctl_enable_txon_0_0);

  Register* r_FCSI_BBLDO1V2 = new Register;
  r_FCSI_BBLDO1V2->setInstName ("BBLDO1V2");
  r_FCSI_BBLDO1V2->setLongName ("RF LDO1V2 BB");
  r_FCSI_BBLDO1V2->setDescription ("FCSI-LDO1V2");
  r_FCSI_BBLDO1V2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_BBLDO1V2, 0x00000007);

  RField* f_FCSI_BBLDO1V2_enable = new RField;
  f_FCSI_BBLDO1V2_enable->setInstName ("enable");
  f_FCSI_BBLDO1V2_enable->setLongName ("ENABLE");
  f_FCSI_BBLDO1V2_enable->setDescription ("Enable BB LDO");
  f_FCSI_BBLDO1V2_enable->setDataWidth (1);
  f_FCSI_BBLDO1V2_enable->setResetVal ("1'b0");
  f_FCSI_BBLDO1V2_enable->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_enable, 0);

  Attribute* a_FCSI_BBLDO1V2_enable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_enable_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_enable_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_enable_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_enable_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBLDO1V2_enable_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBLDO1V2_enable->connectAttribute (a_FCSI_BBLDO1V2_enable_0_0);

  RField* f_FCSI_BBLDO1V2_en_rload = new RField;
  f_FCSI_BBLDO1V2_en_rload->setInstName ("en_rload");
  f_FCSI_BBLDO1V2_en_rload->setLongName ("ENABLE RLOAD");
  f_FCSI_BBLDO1V2_en_rload->setDescription ("Enable resistive load");
  f_FCSI_BBLDO1V2_en_rload->setDataWidth (1);
  f_FCSI_BBLDO1V2_en_rload->setResetVal ("1'b0");
  f_FCSI_BBLDO1V2_en_rload->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_en_rload, 1);

  Attribute* a_FCSI_BBLDO1V2_en_rload_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_en_rload_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_en_rload_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_en_rload_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_en_rload_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBLDO1V2_en_rload_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBLDO1V2_en_rload->connectAttribute (a_FCSI_BBLDO1V2_en_rload_0_0);

  RField* f_FCSI_BBLDO1V2_en_bypass = new RField;
  f_FCSI_BBLDO1V2_en_bypass->setInstName ("en_bypass");
  f_FCSI_BBLDO1V2_en_bypass->setLongName ("ENABLE BYPASS");
  f_FCSI_BBLDO1V2_en_bypass->setDescription ("Enable bypass mode");
  f_FCSI_BBLDO1V2_en_bypass->setDataWidth (1);
  f_FCSI_BBLDO1V2_en_bypass->setResetVal ("1'b0");
  f_FCSI_BBLDO1V2_en_bypass->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_en_bypass, 2);

  Attribute* a_FCSI_BBLDO1V2_en_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_en_bypass_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_en_bypass_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_en_bypass_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_en_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBLDO1V2_en_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBLDO1V2_en_bypass->connectAttribute (a_FCSI_BBLDO1V2_en_bypass_0_0);

  RField* f_FCSI_BBLDO1V2_ctl_vout = new RField;
  f_FCSI_BBLDO1V2_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_BBLDO1V2_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_BBLDO1V2_ctl_vout->setDescription ("Control output voltage");
  f_FCSI_BBLDO1V2_ctl_vout->setDataWidth (4);
  f_FCSI_BBLDO1V2_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_BBLDO1V2_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_ctl_vout, 3);

  Attribute* a_FCSI_BBLDO1V2_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_ctl_vout_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("15", "4'b1111", "1.37V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("14", "4'b1110", "1.36V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("13", "4'b1101", "1.35V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("12", "4'b1100", "1.34V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("11", "4'b1011", "1.33V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("10", "4'b1010", "1.32V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("9", "4'b1001", "1.31V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("8", "4'b1000", "1.30V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("7", "4'b0111", "1.29V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("6", "4'b0110", "1.28V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("5", "4'b0101", "1.27V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("4", "4'b0100", "1.26V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("3", "4'b0011", "1.25V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("2", "4'b0010", "1.24V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("1", "4'b0001", "1.23V");
  a_FCSI_BBLDO1V2_ctl_vout_0_0->addItem("0", "4'b0000", "1.22V");
  f_FCSI_BBLDO1V2_ctl_vout->connectAttribute (a_FCSI_BBLDO1V2_ctl_vout_0_0);

  RField* f_FCSI_BBLDO1V2_ctl_comp = new RField;
  f_FCSI_BBLDO1V2_ctl_comp->setInstName ("ctl_comp");
  f_FCSI_BBLDO1V2_ctl_comp->setLongName ("CTL COMP");
  f_FCSI_BBLDO1V2_ctl_comp->setDescription ("Control compensation capacitor");
  f_FCSI_BBLDO1V2_ctl_comp->setDataWidth (2);
  f_FCSI_BBLDO1V2_ctl_comp->setResetVal ("2'b00");
  f_FCSI_BBLDO1V2_ctl_comp->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_ctl_comp, 7);

  Attribute* a_FCSI_BBLDO1V2_ctl_comp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_ctl_comp_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_ctl_comp_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_ctl_comp_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_ctl_comp_0_0->addItem("3", "2'b11", "5pF");
  a_FCSI_BBLDO1V2_ctl_comp_0_0->addItem("2", "2'b10", "4pF");
  a_FCSI_BBLDO1V2_ctl_comp_0_0->addItem("1", "2'b01", "4.5pF");
  a_FCSI_BBLDO1V2_ctl_comp_0_0->addItem("0", "2'b00", "3.5pF");
  f_FCSI_BBLDO1V2_ctl_comp->connectAttribute (a_FCSI_BBLDO1V2_ctl_comp_0_0);

  RField* f_FCSI_BBLDO1V2_ctl_buf = new RField;
  f_FCSI_BBLDO1V2_ctl_buf->setInstName ("ctl_buf");
  f_FCSI_BBLDO1V2_ctl_buf->setLongName ("CTL BUF");
  f_FCSI_BBLDO1V2_ctl_buf->setDescription ("Control buffer current");
  f_FCSI_BBLDO1V2_ctl_buf->setDataWidth (1);
  f_FCSI_BBLDO1V2_ctl_buf->setResetVal ("1'b0");
  f_FCSI_BBLDO1V2_ctl_buf->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_ctl_buf, 9);

  Attribute* a_FCSI_BBLDO1V2_ctl_buf_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_ctl_buf_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_ctl_buf_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_ctl_buf_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_ctl_buf_0_0->addItem("1", "1'b1", "1mA");
  a_FCSI_BBLDO1V2_ctl_buf_0_0->addItem("0", "1'b0", "0.5mA");
  f_FCSI_BBLDO1V2_ctl_buf->connectAttribute (a_FCSI_BBLDO1V2_ctl_buf_0_0);

  RField* f_FCSI_BBLDO1V2_force_ldo_rdy = new RField;
  f_FCSI_BBLDO1V2_force_ldo_rdy->setInstName ("force_ldo_rdy");
  f_FCSI_BBLDO1V2_force_ldo_rdy->setLongName ("FORCE LDO RDY");
  f_FCSI_BBLDO1V2_force_ldo_rdy->setDescription ("Force LDO ready signal");
  f_FCSI_BBLDO1V2_force_ldo_rdy->setDataWidth (1);
  f_FCSI_BBLDO1V2_force_ldo_rdy->setResetVal ("1'b0");
  f_FCSI_BBLDO1V2_force_ldo_rdy->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_force_ldo_rdy, 10);

  Attribute* a_FCSI_BBLDO1V2_force_ldo_rdy_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_force_ldo_rdy_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_force_ldo_rdy_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_force_ldo_rdy_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_force_ldo_rdy_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBLDO1V2_force_ldo_rdy_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBLDO1V2_force_ldo_rdy->connectAttribute (a_FCSI_BBLDO1V2_force_ldo_rdy_0_0);

  RField* f_FCSI_BBLDO1V2_ctl_ldo_rdy = new RField;
  f_FCSI_BBLDO1V2_ctl_ldo_rdy->setInstName ("ctl_ldo_rdy");
  f_FCSI_BBLDO1V2_ctl_ldo_rdy->setLongName ("CTL LDO RDY");
  f_FCSI_BBLDO1V2_ctl_ldo_rdy->setDescription ("Control LDO ready signal");
  f_FCSI_BBLDO1V2_ctl_ldo_rdy->setDataWidth (1);
  f_FCSI_BBLDO1V2_ctl_ldo_rdy->setResetVal ("1'b0");
  f_FCSI_BBLDO1V2_ctl_ldo_rdy->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_ctl_ldo_rdy, 11);

  Attribute* a_FCSI_BBLDO1V2_ctl_ldo_rdy_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_ctl_ldo_rdy_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_ctl_ldo_rdy_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_ctl_ldo_rdy_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_ctl_ldo_rdy_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBLDO1V2_ctl_ldo_rdy_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBLDO1V2_ctl_ldo_rdy->connectAttribute (a_FCSI_BBLDO1V2_ctl_ldo_rdy_0_0);

  RField* f_FCSI_BBLDO1V2_en_antbias_current_mirror = new RField;
  f_FCSI_BBLDO1V2_en_antbias_current_mirror->setInstName ("en_antbias_current_mirror");
  f_FCSI_BBLDO1V2_en_antbias_current_mirror->setLongName ("EN ANTBIAS CURRENT MIRROR");
  f_FCSI_BBLDO1V2_en_antbias_current_mirror->setDescription ("Enable antenna biasing current mirror");
  f_FCSI_BBLDO1V2_en_antbias_current_mirror->setDataWidth (1);
  f_FCSI_BBLDO1V2_en_antbias_current_mirror->setResetVal ("1'b0");
  f_FCSI_BBLDO1V2_en_antbias_current_mirror->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_en_antbias_current_mirror, 12);

  Attribute* a_FCSI_BBLDO1V2_en_antbias_current_mirror_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_en_antbias_current_mirror_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_en_antbias_current_mirror_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_en_antbias_current_mirror_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_en_antbias_current_mirror_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_BBLDO1V2_en_antbias_current_mirror_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_BBLDO1V2_en_antbias_current_mirror->connectAttribute (a_FCSI_BBLDO1V2_en_antbias_current_mirror_0_0);

  RField* f_FCSI_BBLDO1V2_ctl_hb_lb = new RField;
  f_FCSI_BBLDO1V2_ctl_hb_lb->setInstName ("ctl_hb_lb");
  f_FCSI_BBLDO1V2_ctl_hb_lb->setLongName ("CTL HBLB");
  f_FCSI_BBLDO1V2_ctl_hb_lb->setDescription ("Control HBLB");
  f_FCSI_BBLDO1V2_ctl_hb_lb->setDataWidth (1);
  f_FCSI_BBLDO1V2_ctl_hb_lb->setResetVal ("1'b0");
  f_FCSI_BBLDO1V2_ctl_hb_lb->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_ctl_hb_lb, 13);

  Attribute* a_FCSI_BBLDO1V2_ctl_hb_lb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_ctl_hb_lb_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_ctl_hb_lb_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_ctl_hb_lb_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_ctl_hb_lb_0_0->addItem("1", "1'b1", "HB");
  a_FCSI_BBLDO1V2_ctl_hb_lb_0_0->addItem("0", "1'b0", "LB");
  f_FCSI_BBLDO1V2_ctl_hb_lb->connectAttribute (a_FCSI_BBLDO1V2_ctl_hb_lb_0_0);

  RField* f_FCSI_BBLDO1V2_ctl_hb_lb_fcsi = new RField;
  f_FCSI_BBLDO1V2_ctl_hb_lb_fcsi->setInstName ("ctl_hb_lb_fcsi");
  f_FCSI_BBLDO1V2_ctl_hb_lb_fcsi->setLongName ("CTL HBLB FCSI");
  f_FCSI_BBLDO1V2_ctl_hb_lb_fcsi->setDescription ("Control HBLB FCSI");
  f_FCSI_BBLDO1V2_ctl_hb_lb_fcsi->setDataWidth (1);
  f_FCSI_BBLDO1V2_ctl_hb_lb_fcsi->setResetVal ("1'b0");
  f_FCSI_BBLDO1V2_ctl_hb_lb_fcsi->setAccProp (AccProp::RW);
  r_FCSI_BBLDO1V2->connectRField (f_FCSI_BBLDO1V2_ctl_hb_lb_fcsi, 14);

  Attribute* a_FCSI_BBLDO1V2_ctl_hb_lb_fcsi_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_BBLDO1V2_ctl_hb_lb_fcsi_0_0->setInstName ("0");
  a_FCSI_BBLDO1V2_ctl_hb_lb_fcsi_0_0->setLongName ("");
  a_FCSI_BBLDO1V2_ctl_hb_lb_fcsi_0_0->setDescription ("");
  a_FCSI_BBLDO1V2_ctl_hb_lb_fcsi_0_0->addItem("1", "1'b1", "HB");
  a_FCSI_BBLDO1V2_ctl_hb_lb_fcsi_0_0->addItem("0", "1'b0", "LB");
  f_FCSI_BBLDO1V2_ctl_hb_lb_fcsi->connectAttribute (a_FCSI_BBLDO1V2_ctl_hb_lb_fcsi_0_0);

  Register* r_FCSI_RFLDO2V5 = new Register;
  r_FCSI_RFLDO2V5->setInstName ("RFLDO2V5");
  r_FCSI_RFLDO2V5->setLongName ("RF LDO2V5");
  r_FCSI_RFLDO2V5->setDescription ("FCSI-LDO1V2");
  r_FCSI_RFLDO2V5->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RFLDO2V5, 0x00000008);

  RField* f_FCSI_RFLDO2V5_enable = new RField;
  f_FCSI_RFLDO2V5_enable->setInstName ("enable");
  f_FCSI_RFLDO2V5_enable->setLongName ("ENABLE");
  f_FCSI_RFLDO2V5_enable->setDescription ("Enable RF 2V5 LDO");
  f_FCSI_RFLDO2V5_enable->setDataWidth (1);
  f_FCSI_RFLDO2V5_enable->setResetVal ("1'b0");
  f_FCSI_RFLDO2V5_enable->setAccProp (AccProp::RW);
  r_FCSI_RFLDO2V5->connectRField (f_FCSI_RFLDO2V5_enable, 0);

  Attribute* a_FCSI_RFLDO2V5_enable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RFLDO2V5_enable_0_0->setInstName ("0");
  a_FCSI_RFLDO2V5_enable_0_0->setLongName ("");
  a_FCSI_RFLDO2V5_enable_0_0->setDescription ("");
  a_FCSI_RFLDO2V5_enable_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RFLDO2V5_enable_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RFLDO2V5_enable->connectAttribute (a_FCSI_RFLDO2V5_enable_0_0);

  RField* f_FCSI_RFLDO2V5_en_rload = new RField;
  f_FCSI_RFLDO2V5_en_rload->setInstName ("en_rload");
  f_FCSI_RFLDO2V5_en_rload->setLongName ("ENABLE RLOAD");
  f_FCSI_RFLDO2V5_en_rload->setDescription ("Enable resistive load");
  f_FCSI_RFLDO2V5_en_rload->setDataWidth (1);
  f_FCSI_RFLDO2V5_en_rload->setResetVal ("1'b0");
  f_FCSI_RFLDO2V5_en_rload->setAccProp (AccProp::RW);
  r_FCSI_RFLDO2V5->connectRField (f_FCSI_RFLDO2V5_en_rload, 1);

  Attribute* a_FCSI_RFLDO2V5_en_rload_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RFLDO2V5_en_rload_0_0->setInstName ("0");
  a_FCSI_RFLDO2V5_en_rload_0_0->setLongName ("");
  a_FCSI_RFLDO2V5_en_rload_0_0->setDescription ("");
  a_FCSI_RFLDO2V5_en_rload_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RFLDO2V5_en_rload_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RFLDO2V5_en_rload->connectAttribute (a_FCSI_RFLDO2V5_en_rload_0_0);

  RField* f_FCSI_RFLDO2V5_en_bypass = new RField;
  f_FCSI_RFLDO2V5_en_bypass->setInstName ("en_bypass");
  f_FCSI_RFLDO2V5_en_bypass->setLongName ("ENABLE BYPASS");
  f_FCSI_RFLDO2V5_en_bypass->setDescription ("Enable bypass mode");
  f_FCSI_RFLDO2V5_en_bypass->setDataWidth (1);
  f_FCSI_RFLDO2V5_en_bypass->setResetVal ("1'b0");
  f_FCSI_RFLDO2V5_en_bypass->setAccProp (AccProp::RW);
  r_FCSI_RFLDO2V5->connectRField (f_FCSI_RFLDO2V5_en_bypass, 2);

  Attribute* a_FCSI_RFLDO2V5_en_bypass_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RFLDO2V5_en_bypass_0_0->setInstName ("0");
  a_FCSI_RFLDO2V5_en_bypass_0_0->setLongName ("");
  a_FCSI_RFLDO2V5_en_bypass_0_0->setDescription ("");
  a_FCSI_RFLDO2V5_en_bypass_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RFLDO2V5_en_bypass_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RFLDO2V5_en_bypass->connectAttribute (a_FCSI_RFLDO2V5_en_bypass_0_0);

  RField* f_FCSI_RFLDO2V5_en_lc = new RField;
  f_FCSI_RFLDO2V5_en_lc->setInstName ("en_lc");
  f_FCSI_RFLDO2V5_en_lc->setLongName ("EN LC");
  f_FCSI_RFLDO2V5_en_lc->setDescription ("Enable loop compensation");
  f_FCSI_RFLDO2V5_en_lc->setDataWidth (1);
  f_FCSI_RFLDO2V5_en_lc->setResetVal ("1'b0");
  f_FCSI_RFLDO2V5_en_lc->setAccProp (AccProp::RW);
  r_FCSI_RFLDO2V5->connectRField (f_FCSI_RFLDO2V5_en_lc, 3);

  Attribute* a_FCSI_RFLDO2V5_en_lc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RFLDO2V5_en_lc_0_0->setInstName ("0");
  a_FCSI_RFLDO2V5_en_lc_0_0->setLongName ("");
  a_FCSI_RFLDO2V5_en_lc_0_0->setDescription ("");
  a_FCSI_RFLDO2V5_en_lc_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RFLDO2V5_en_lc_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RFLDO2V5_en_lc->connectAttribute (a_FCSI_RFLDO2V5_en_lc_0_0);

  RField* f_FCSI_RFLDO2V5_ctl_lpgain = new RField;
  f_FCSI_RFLDO2V5_ctl_lpgain->setInstName ("ctl_lpgain");
  f_FCSI_RFLDO2V5_ctl_lpgain->setLongName ("CTL LP GAIN");
  f_FCSI_RFLDO2V5_ctl_lpgain->setDescription ("Control loop gain");
  f_FCSI_RFLDO2V5_ctl_lpgain->setDataWidth (1);
  f_FCSI_RFLDO2V5_ctl_lpgain->setResetVal ("1'b0");
  f_FCSI_RFLDO2V5_ctl_lpgain->setAccProp (AccProp::RW);
  r_FCSI_RFLDO2V5->connectRField (f_FCSI_RFLDO2V5_ctl_lpgain, 4);

  Attribute* a_FCSI_RFLDO2V5_ctl_lpgain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RFLDO2V5_ctl_lpgain_0_0->setInstName ("0");
  a_FCSI_RFLDO2V5_ctl_lpgain_0_0->setLongName ("");
  a_FCSI_RFLDO2V5_ctl_lpgain_0_0->setDescription ("");
  a_FCSI_RFLDO2V5_ctl_lpgain_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RFLDO2V5_ctl_lpgain_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RFLDO2V5_ctl_lpgain->connectAttribute (a_FCSI_RFLDO2V5_ctl_lpgain_0_0);

  RField* f_FCSI_RFLDO2V5_ctl_vout = new RField;
  f_FCSI_RFLDO2V5_ctl_vout->setInstName ("ctl_vout");
  f_FCSI_RFLDO2V5_ctl_vout->setLongName ("CTL VOUT");
  f_FCSI_RFLDO2V5_ctl_vout->setDescription ("Control output voltage");
  f_FCSI_RFLDO2V5_ctl_vout->setDataWidth (4);
  f_FCSI_RFLDO2V5_ctl_vout->setResetVal ("4'b0000");
  f_FCSI_RFLDO2V5_ctl_vout->setAccProp (AccProp::RW);
  r_FCSI_RFLDO2V5->connectRField (f_FCSI_RFLDO2V5_ctl_vout, 5);

  Attribute* a_FCSI_RFLDO2V5_ctl_vout_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RFLDO2V5_ctl_vout_0_0->setInstName ("0");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->setLongName ("");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->setDescription ("");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("7", "4'b0111", "2.65V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("6", "4'b0110", "2.63V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("5", "4'b0101", "2.61V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("4", "4'b0100", "2.59V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("3", "4'b0011", "2.57V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("2", "4'b0010", "2.55V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("1", "4'b0001", "2.53V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("0", "4'b0000", "2.51V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("15", "4'b1111", "2.49V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("14", "4'b1110", "2.47V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("13", "4'b1101", "2.45V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("12", "4'b1100", "2.43V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("11", "4'b1011", "2.41V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("10", "4'b1010", "2.39V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("9", "4'b1001", "2.37V");
  a_FCSI_RFLDO2V5_ctl_vout_0_0->addItem("8", "4'b1000", "2.35V");
  f_FCSI_RFLDO2V5_ctl_vout->connectAttribute (a_FCSI_RFLDO2V5_ctl_vout_0_0);

  Register* r_FCSI_FECTL01 = new Register;
  r_FCSI_FECTL01->setInstName ("FECTL01");
  r_FCSI_FECTL01->setLongName ("FECTL CONFIG RX GAIN01");
  r_FCSI_FECTL01->setDescription ("FCSI-LDO1V2");
  r_FCSI_FECTL01->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_FECTL01, 0x00000009);

  RField* f_FCSI_FECTL01_lna_gain0 = new RField;
  f_FCSI_FECTL01_lna_gain0->setInstName ("lna_gain0");
  f_FCSI_FECTL01_lna_gain0->setLongName ("LNA GAIN0");
  f_FCSI_FECTL01_lna_gain0->setDescription ("LNA gain0");
  f_FCSI_FECTL01_lna_gain0->setDataWidth (2);
  f_FCSI_FECTL01_lna_gain0->setResetVal ("2'b00");
  f_FCSI_FECTL01_lna_gain0->setAccProp (AccProp::RW);
  r_FCSI_FECTL01->connectRField (f_FCSI_FECTL01_lna_gain0, 0);

  Attribute* a_FCSI_FECTL01_lna_gain0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL01_lna_gain0_0_0->setInstName ("0");
  a_FCSI_FECTL01_lna_gain0_0_0->setLongName ("");
  a_FCSI_FECTL01_lna_gain0_0_0->setDescription ("");
  a_FCSI_FECTL01_lna_gain0_0_0->addItem("0", "2'b00", "-18dB");
  a_FCSI_FECTL01_lna_gain0_0_0->addItem("1", "2'b01", "-12dB");
  a_FCSI_FECTL01_lna_gain0_0_0->addItem("2", "2'b10", "-6dB");
  a_FCSI_FECTL01_lna_gain0_0_0->addItem("3", "2'b11", "High gain");
  f_FCSI_FECTL01_lna_gain0->connectAttribute (a_FCSI_FECTL01_lna_gain0_0_0);

  RField* f_FCSI_FECTL01_fectl_gain0 = new RField;
  f_FCSI_FECTL01_fectl_gain0->setInstName ("fectl_gain0");
  f_FCSI_FECTL01_fectl_gain0->setLongName ("FECTL GAIN0");
  f_FCSI_FECTL01_fectl_gain0->setDescription ("FECTL gain0");
  f_FCSI_FECTL01_fectl_gain0->setDataWidth (6);
  f_FCSI_FECTL01_fectl_gain0->setResetVal ("6'b000000");
  f_FCSI_FECTL01_fectl_gain0->setAccProp (AccProp::RW);
  r_FCSI_FECTL01->connectRField (f_FCSI_FECTL01_fectl_gain0, 2);

  Attribute* a_FCSI_FECTL01_fectl_gain0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL01_fectl_gain0_0_0->setInstName ("0");
  a_FCSI_FECTL01_fectl_gain0_0_0->setLongName ("");
  a_FCSI_FECTL01_fectl_gain0_0_0->setDescription ("");
  a_FCSI_FECTL01_fectl_gain0_0_0->addItem("0", "6'b000000", "");
  a_FCSI_FECTL01_fectl_gain0_0_0->addItem("1", "6'b000001", "");
  a_FCSI_FECTL01_fectl_gain0_0_0->addItem("62", "6'b111110", "");
  a_FCSI_FECTL01_fectl_gain0_0_0->addItem("63", "6'b111111", "");
  f_FCSI_FECTL01_fectl_gain0->connectAttribute (a_FCSI_FECTL01_fectl_gain0_0_0);

  RField* f_FCSI_FECTL01_lna_gain1 = new RField;
  f_FCSI_FECTL01_lna_gain1->setInstName ("lna_gain1");
  f_FCSI_FECTL01_lna_gain1->setLongName ("LNA GAIN1");
  f_FCSI_FECTL01_lna_gain1->setDescription ("LNA gain1");
  f_FCSI_FECTL01_lna_gain1->setDataWidth (2);
  f_FCSI_FECTL01_lna_gain1->setResetVal ("2'b00");
  f_FCSI_FECTL01_lna_gain1->setAccProp (AccProp::RW);
  r_FCSI_FECTL01->connectRField (f_FCSI_FECTL01_lna_gain1, 8);

  Attribute* a_FCSI_FECTL01_lna_gain1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL01_lna_gain1_0_0->setInstName ("0");
  a_FCSI_FECTL01_lna_gain1_0_0->setLongName ("");
  a_FCSI_FECTL01_lna_gain1_0_0->setDescription ("");
  a_FCSI_FECTL01_lna_gain1_0_0->addItem("0", "2'b00", "-18dB");
  a_FCSI_FECTL01_lna_gain1_0_0->addItem("1", "2'b01", "-12dB");
  a_FCSI_FECTL01_lna_gain1_0_0->addItem("2", "2'b10", "-6dB");
  a_FCSI_FECTL01_lna_gain1_0_0->addItem("3", "2'b11", "High gain");
  f_FCSI_FECTL01_lna_gain1->connectAttribute (a_FCSI_FECTL01_lna_gain1_0_0);

  RField* f_FCSI_FECTL01_fectl_gain1 = new RField;
  f_FCSI_FECTL01_fectl_gain1->setInstName ("fectl_gain1");
  f_FCSI_FECTL01_fectl_gain1->setLongName ("FECTL GAIN1");
  f_FCSI_FECTL01_fectl_gain1->setDescription ("FECTL gain1");
  f_FCSI_FECTL01_fectl_gain1->setDataWidth (6);
  f_FCSI_FECTL01_fectl_gain1->setResetVal ("6'b000000");
  f_FCSI_FECTL01_fectl_gain1->setAccProp (AccProp::RW);
  r_FCSI_FECTL01->connectRField (f_FCSI_FECTL01_fectl_gain1, 10);

  Attribute* a_FCSI_FECTL01_fectl_gain1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL01_fectl_gain1_0_0->setInstName ("0");
  a_FCSI_FECTL01_fectl_gain1_0_0->setLongName ("");
  a_FCSI_FECTL01_fectl_gain1_0_0->setDescription ("");
  a_FCSI_FECTL01_fectl_gain1_0_0->addItem("0", "6'b000000", "");
  a_FCSI_FECTL01_fectl_gain1_0_0->addItem("1", "6'b000001", "");
  a_FCSI_FECTL01_fectl_gain1_0_0->addItem("62", "6'b111110", "");
  a_FCSI_FECTL01_fectl_gain1_0_0->addItem("63", "6'b111111", "");
  f_FCSI_FECTL01_fectl_gain1->connectAttribute (a_FCSI_FECTL01_fectl_gain1_0_0);

  Register* r_FCSI_FECTL23 = new Register;
  r_FCSI_FECTL23->setInstName ("FECTL23");
  r_FCSI_FECTL23->setLongName ("FECTL CONFIG RX GAIN23");
  r_FCSI_FECTL23->setDescription ("FCSI-LDO1V2");
  r_FCSI_FECTL23->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_FECTL23, 0x0000000A);

  RField* f_FCSI_FECTL23_lna_gain2 = new RField;
  f_FCSI_FECTL23_lna_gain2->setInstName ("lna_gain2");
  f_FCSI_FECTL23_lna_gain2->setLongName ("LNA GAIN2");
  f_FCSI_FECTL23_lna_gain2->setDescription ("LNA gain2");
  f_FCSI_FECTL23_lna_gain2->setDataWidth (2);
  f_FCSI_FECTL23_lna_gain2->setResetVal ("2'b00");
  f_FCSI_FECTL23_lna_gain2->setAccProp (AccProp::RW);
  r_FCSI_FECTL23->connectRField (f_FCSI_FECTL23_lna_gain2, 0);

  Attribute* a_FCSI_FECTL23_lna_gain2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL23_lna_gain2_0_0->setInstName ("0");
  a_FCSI_FECTL23_lna_gain2_0_0->setLongName ("");
  a_FCSI_FECTL23_lna_gain2_0_0->setDescription ("");
  a_FCSI_FECTL23_lna_gain2_0_0->addItem("0", "2'b00", "-18dB");
  a_FCSI_FECTL23_lna_gain2_0_0->addItem("1", "2'b01", "-12dB");
  a_FCSI_FECTL23_lna_gain2_0_0->addItem("2", "2'b10", "-6dB");
  a_FCSI_FECTL23_lna_gain2_0_0->addItem("3", "2'b11", "High gain");
  f_FCSI_FECTL23_lna_gain2->connectAttribute (a_FCSI_FECTL23_lna_gain2_0_0);

  RField* f_FCSI_FECTL23_fectl_gain2 = new RField;
  f_FCSI_FECTL23_fectl_gain2->setInstName ("fectl_gain2");
  f_FCSI_FECTL23_fectl_gain2->setLongName ("FECTL GAIN2");
  f_FCSI_FECTL23_fectl_gain2->setDescription ("FECTL gain2");
  f_FCSI_FECTL23_fectl_gain2->setDataWidth (6);
  f_FCSI_FECTL23_fectl_gain2->setResetVal ("6'b000000");
  f_FCSI_FECTL23_fectl_gain2->setAccProp (AccProp::RW);
  r_FCSI_FECTL23->connectRField (f_FCSI_FECTL23_fectl_gain2, 2);

  Attribute* a_FCSI_FECTL23_fectl_gain2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL23_fectl_gain2_0_0->setInstName ("0");
  a_FCSI_FECTL23_fectl_gain2_0_0->setLongName ("");
  a_FCSI_FECTL23_fectl_gain2_0_0->setDescription ("");
  a_FCSI_FECTL23_fectl_gain2_0_0->addItem("0", "6'b000000", "");
  a_FCSI_FECTL23_fectl_gain2_0_0->addItem("1", "6'b000001", "");
  a_FCSI_FECTL23_fectl_gain2_0_0->addItem("62", "6'b111110", "");
  a_FCSI_FECTL23_fectl_gain2_0_0->addItem("63", "6'b111111", "");
  f_FCSI_FECTL23_fectl_gain2->connectAttribute (a_FCSI_FECTL23_fectl_gain2_0_0);

  RField* f_FCSI_FECTL23_lna_gain3 = new RField;
  f_FCSI_FECTL23_lna_gain3->setInstName ("lna_gain3");
  f_FCSI_FECTL23_lna_gain3->setLongName ("LNA GAIN3");
  f_FCSI_FECTL23_lna_gain3->setDescription ("LNA gain3");
  f_FCSI_FECTL23_lna_gain3->setDataWidth (2);
  f_FCSI_FECTL23_lna_gain3->setResetVal ("2'b00");
  f_FCSI_FECTL23_lna_gain3->setAccProp (AccProp::RW);
  r_FCSI_FECTL23->connectRField (f_FCSI_FECTL23_lna_gain3, 8);

  Attribute* a_FCSI_FECTL23_lna_gain3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL23_lna_gain3_0_0->setInstName ("0");
  a_FCSI_FECTL23_lna_gain3_0_0->setLongName ("");
  a_FCSI_FECTL23_lna_gain3_0_0->setDescription ("");
  a_FCSI_FECTL23_lna_gain3_0_0->addItem("0", "2'b00", "-18dB");
  a_FCSI_FECTL23_lna_gain3_0_0->addItem("1", "2'b01", "-12dB");
  a_FCSI_FECTL23_lna_gain3_0_0->addItem("2", "2'b10", "-6dB");
  a_FCSI_FECTL23_lna_gain3_0_0->addItem("3", "2'b11", "High gain");
  f_FCSI_FECTL23_lna_gain3->connectAttribute (a_FCSI_FECTL23_lna_gain3_0_0);

  RField* f_FCSI_FECTL23_fectl_gain3 = new RField;
  f_FCSI_FECTL23_fectl_gain3->setInstName ("fectl_gain3");
  f_FCSI_FECTL23_fectl_gain3->setLongName ("FECTL GAIN3");
  f_FCSI_FECTL23_fectl_gain3->setDescription ("FECTL gain3");
  f_FCSI_FECTL23_fectl_gain3->setDataWidth (6);
  f_FCSI_FECTL23_fectl_gain3->setResetVal ("6'b000000");
  f_FCSI_FECTL23_fectl_gain3->setAccProp (AccProp::RW);
  r_FCSI_FECTL23->connectRField (f_FCSI_FECTL23_fectl_gain3, 10);

  Attribute* a_FCSI_FECTL23_fectl_gain3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL23_fectl_gain3_0_0->setInstName ("0");
  a_FCSI_FECTL23_fectl_gain3_0_0->setLongName ("");
  a_FCSI_FECTL23_fectl_gain3_0_0->setDescription ("");
  a_FCSI_FECTL23_fectl_gain3_0_0->addItem("0", "6'b000000", "");
  a_FCSI_FECTL23_fectl_gain3_0_0->addItem("1", "6'b000001", "");
  a_FCSI_FECTL23_fectl_gain3_0_0->addItem("62", "6'b111110", "");
  a_FCSI_FECTL23_fectl_gain3_0_0->addItem("63", "6'b111111", "");
  f_FCSI_FECTL23_fectl_gain3->connectAttribute (a_FCSI_FECTL23_fectl_gain3_0_0);

  Register* r_FCSI_FECTL45 = new Register;
  r_FCSI_FECTL45->setInstName ("FECTL45");
  r_FCSI_FECTL45->setLongName ("FECTL CONFIG RX GAIN45");
  r_FCSI_FECTL45->setDescription ("FCSI-LDO1V2");
  r_FCSI_FECTL45->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_FECTL45, 0x0000000B);

  RField* f_FCSI_FECTL45_lna_gain4 = new RField;
  f_FCSI_FECTL45_lna_gain4->setInstName ("lna_gain4");
  f_FCSI_FECTL45_lna_gain4->setLongName ("LNA GAIN4");
  f_FCSI_FECTL45_lna_gain4->setDescription ("LNA gain4");
  f_FCSI_FECTL45_lna_gain4->setDataWidth (2);
  f_FCSI_FECTL45_lna_gain4->setResetVal ("2'b00");
  f_FCSI_FECTL45_lna_gain4->setAccProp (AccProp::RW);
  r_FCSI_FECTL45->connectRField (f_FCSI_FECTL45_lna_gain4, 0);

  Attribute* a_FCSI_FECTL45_lna_gain4_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL45_lna_gain4_0_0->setInstName ("0");
  a_FCSI_FECTL45_lna_gain4_0_0->setLongName ("");
  a_FCSI_FECTL45_lna_gain4_0_0->setDescription ("");
  a_FCSI_FECTL45_lna_gain4_0_0->addItem("0", "2'b00", "-18dB");
  a_FCSI_FECTL45_lna_gain4_0_0->addItem("1", "2'b01", "-12dB");
  a_FCSI_FECTL45_lna_gain4_0_0->addItem("2", "2'b10", "-6dB");
  a_FCSI_FECTL45_lna_gain4_0_0->addItem("3", "2'b11", "High gain");
  f_FCSI_FECTL45_lna_gain4->connectAttribute (a_FCSI_FECTL45_lna_gain4_0_0);

  RField* f_FCSI_FECTL45_fectl_gain4 = new RField;
  f_FCSI_FECTL45_fectl_gain4->setInstName ("fectl_gain4");
  f_FCSI_FECTL45_fectl_gain4->setLongName ("FECTL GAIN4");
  f_FCSI_FECTL45_fectl_gain4->setDescription ("FECTL gain4");
  f_FCSI_FECTL45_fectl_gain4->setDataWidth (6);
  f_FCSI_FECTL45_fectl_gain4->setResetVal ("6'b000000");
  f_FCSI_FECTL45_fectl_gain4->setAccProp (AccProp::RW);
  r_FCSI_FECTL45->connectRField (f_FCSI_FECTL45_fectl_gain4, 2);

  Attribute* a_FCSI_FECTL45_fectl_gain4_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL45_fectl_gain4_0_0->setInstName ("0");
  a_FCSI_FECTL45_fectl_gain4_0_0->setLongName ("");
  a_FCSI_FECTL45_fectl_gain4_0_0->setDescription ("");
  a_FCSI_FECTL45_fectl_gain4_0_0->addItem("0", "6'b000000", "");
  a_FCSI_FECTL45_fectl_gain4_0_0->addItem("1", "6'b000001", "");
  a_FCSI_FECTL45_fectl_gain4_0_0->addItem("62", "6'b111110", "");
  a_FCSI_FECTL45_fectl_gain4_0_0->addItem("63", "6'b111111", "");
  f_FCSI_FECTL45_fectl_gain4->connectAttribute (a_FCSI_FECTL45_fectl_gain4_0_0);

  RField* f_FCSI_FECTL45_lna_gain5 = new RField;
  f_FCSI_FECTL45_lna_gain5->setInstName ("lna_gain5");
  f_FCSI_FECTL45_lna_gain5->setLongName ("LNA GAIN5");
  f_FCSI_FECTL45_lna_gain5->setDescription ("LNA gain5");
  f_FCSI_FECTL45_lna_gain5->setDataWidth (2);
  f_FCSI_FECTL45_lna_gain5->setResetVal ("2'b00");
  f_FCSI_FECTL45_lna_gain5->setAccProp (AccProp::RW);
  r_FCSI_FECTL45->connectRField (f_FCSI_FECTL45_lna_gain5, 8);

  Attribute* a_FCSI_FECTL45_lna_gain5_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL45_lna_gain5_0_0->setInstName ("0");
  a_FCSI_FECTL45_lna_gain5_0_0->setLongName ("");
  a_FCSI_FECTL45_lna_gain5_0_0->setDescription ("");
  a_FCSI_FECTL45_lna_gain5_0_0->addItem("0", "2'b00", "-18dB");
  a_FCSI_FECTL45_lna_gain5_0_0->addItem("1", "2'b01", "-12dB");
  a_FCSI_FECTL45_lna_gain5_0_0->addItem("2", "2'b10", "-6dB");
  a_FCSI_FECTL45_lna_gain5_0_0->addItem("3", "2'b11", "High gain");
  f_FCSI_FECTL45_lna_gain5->connectAttribute (a_FCSI_FECTL45_lna_gain5_0_0);

  RField* f_FCSI_FECTL45_fectl_gain5 = new RField;
  f_FCSI_FECTL45_fectl_gain5->setInstName ("fectl_gain5");
  f_FCSI_FECTL45_fectl_gain5->setLongName ("FECTL GAIN5");
  f_FCSI_FECTL45_fectl_gain5->setDescription ("FECTL gain5");
  f_FCSI_FECTL45_fectl_gain5->setDataWidth (6);
  f_FCSI_FECTL45_fectl_gain5->setResetVal ("6'b000000");
  f_FCSI_FECTL45_fectl_gain5->setAccProp (AccProp::RW);
  r_FCSI_FECTL45->connectRField (f_FCSI_FECTL45_fectl_gain5, 10);

  Attribute* a_FCSI_FECTL45_fectl_gain5_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL45_fectl_gain5_0_0->setInstName ("0");
  a_FCSI_FECTL45_fectl_gain5_0_0->setLongName ("");
  a_FCSI_FECTL45_fectl_gain5_0_0->setDescription ("");
  a_FCSI_FECTL45_fectl_gain5_0_0->addItem("0", "6'b000000", "");
  a_FCSI_FECTL45_fectl_gain5_0_0->addItem("1", "6'b000001", "");
  a_FCSI_FECTL45_fectl_gain5_0_0->addItem("62", "6'b111110", "");
  a_FCSI_FECTL45_fectl_gain5_0_0->addItem("63", "6'b111111", "");
  f_FCSI_FECTL45_fectl_gain5->connectAttribute (a_FCSI_FECTL45_fectl_gain5_0_0);

  Register* r_FCSI_MANFECTL = new Register;
  r_FCSI_MANFECTL->setInstName ("MANFECTL");
  r_FCSI_MANFECTL->setLongName ("MANFECTL PADCTL");
  r_FCSI_MANFECTL->setDescription ("FCSI-LDO1V2");
  r_FCSI_MANFECTL->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_MANFECTL, 0x0000000C);

  RField* f_FCSI_MANFECTL_ctl_manuel_fectl = new RField;
  f_FCSI_MANFECTL_ctl_manuel_fectl->setInstName ("ctl_manuel_fectl");
  f_FCSI_MANFECTL_ctl_manuel_fectl->setLongName ("CTL MANUEL FECTL");
  f_FCSI_MANFECTL_ctl_manuel_fectl->setDescription ("Control manuel FECTL");
  f_FCSI_MANFECTL_ctl_manuel_fectl->setDataWidth (1);
  f_FCSI_MANFECTL_ctl_manuel_fectl->setResetVal ("1'b0");
  f_FCSI_MANFECTL_ctl_manuel_fectl->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_ctl_manuel_fectl, 0);

  Attribute* a_FCSI_MANFECTL_ctl_manuel_fectl_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_ctl_manuel_fectl_0_0->setInstName ("0");
  a_FCSI_MANFECTL_ctl_manuel_fectl_0_0->setLongName ("");
  a_FCSI_MANFECTL_ctl_manuel_fectl_0_0->setDescription ("");
  a_FCSI_MANFECTL_ctl_manuel_fectl_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_MANFECTL_ctl_manuel_fectl_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_MANFECTL_ctl_manuel_fectl->connectAttribute (a_FCSI_MANFECTL_ctl_manuel_fectl_0_0);

  RField* f_FCSI_MANFECTL_fectl_gain = new RField;
  f_FCSI_MANFECTL_fectl_gain->setInstName ("fectl_gain");
  f_FCSI_MANFECTL_fectl_gain->setLongName ("FECTL GAIN");
  f_FCSI_MANFECTL_fectl_gain->setDescription ("FECTL gain");
  f_FCSI_MANFECTL_fectl_gain->setDataWidth (6);
  f_FCSI_MANFECTL_fectl_gain->setResetVal ("6'b000000");
  f_FCSI_MANFECTL_fectl_gain->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_fectl_gain, 1);

  Attribute* a_FCSI_MANFECTL_fectl_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_fectl_gain_0_0->setInstName ("0");
  a_FCSI_MANFECTL_fectl_gain_0_0->setLongName ("");
  a_FCSI_MANFECTL_fectl_gain_0_0->setDescription ("");
  a_FCSI_MANFECTL_fectl_gain_0_0->addItem("0", "6'b000000", "");
  a_FCSI_MANFECTL_fectl_gain_0_0->addItem("1", "6'b000001", "");
  a_FCSI_MANFECTL_fectl_gain_0_0->addItem("62", "6'b111110", "");
  a_FCSI_MANFECTL_fectl_gain_0_0->addItem("63", "6'b111111", "");
  f_FCSI_MANFECTL_fectl_gain->connectAttribute (a_FCSI_MANFECTL_fectl_gain_0_0);

  RField* f_FCSI_MANFECTL_fectl_ds = new RField;
  f_FCSI_MANFECTL_fectl_ds->setInstName ("fectl_ds");
  f_FCSI_MANFECTL_fectl_ds->setLongName ("FECTL DS");
  f_FCSI_MANFECTL_fectl_ds->setDescription ("Control driver strength of FECTL PAD's");
  f_FCSI_MANFECTL_fectl_ds->setDataWidth (1);
  f_FCSI_MANFECTL_fectl_ds->setResetVal ("1'b0");
  f_FCSI_MANFECTL_fectl_ds->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_fectl_ds, 7);

  Attribute* a_FCSI_MANFECTL_fectl_ds_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_fectl_ds_0_0->setInstName ("0");
  a_FCSI_MANFECTL_fectl_ds_0_0->setLongName ("");
  a_FCSI_MANFECTL_fectl_ds_0_0->setDescription ("");
  a_FCSI_MANFECTL_fectl_ds_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_MANFECTL_fectl_ds_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_MANFECTL_fectl_ds->connectAttribute (a_FCSI_MANFECTL_fectl_ds_0_0);

  RField* f_FCSI_MANFECTL_fectl0_disable = new RField;
  f_FCSI_MANFECTL_fectl0_disable->setInstName ("fectl0_disable");
  f_FCSI_MANFECTL_fectl0_disable->setLongName ("FECTL0 DISABLE");
  f_FCSI_MANFECTL_fectl0_disable->setDescription ("Disable output driver of FECTL0 PAD and enable pull down resistor");
  f_FCSI_MANFECTL_fectl0_disable->setDataWidth (1);
  f_FCSI_MANFECTL_fectl0_disable->setResetVal ("1'b0");
  f_FCSI_MANFECTL_fectl0_disable->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_fectl0_disable, 8);

  Attribute* a_FCSI_MANFECTL_fectl0_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_fectl0_disable_0_0->setInstName ("0");
  a_FCSI_MANFECTL_fectl0_disable_0_0->setLongName ("");
  a_FCSI_MANFECTL_fectl0_disable_0_0->setDescription ("");
  a_FCSI_MANFECTL_fectl0_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_MANFECTL_fectl0_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_MANFECTL_fectl0_disable->connectAttribute (a_FCSI_MANFECTL_fectl0_disable_0_0);

  RField* f_FCSI_MANFECTL_fectl1_disable = new RField;
  f_FCSI_MANFECTL_fectl1_disable->setInstName ("fectl1_disable");
  f_FCSI_MANFECTL_fectl1_disable->setLongName ("FECTL1 DISABLE");
  f_FCSI_MANFECTL_fectl1_disable->setDescription ("Disable output driver of FECTL1 PAD and enable pull down resistor");
  f_FCSI_MANFECTL_fectl1_disable->setDataWidth (1);
  f_FCSI_MANFECTL_fectl1_disable->setResetVal ("1'b0");
  f_FCSI_MANFECTL_fectl1_disable->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_fectl1_disable, 9);

  Attribute* a_FCSI_MANFECTL_fectl1_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_fectl1_disable_0_0->setInstName ("0");
  a_FCSI_MANFECTL_fectl1_disable_0_0->setLongName ("");
  a_FCSI_MANFECTL_fectl1_disable_0_0->setDescription ("");
  a_FCSI_MANFECTL_fectl1_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_MANFECTL_fectl1_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_MANFECTL_fectl1_disable->connectAttribute (a_FCSI_MANFECTL_fectl1_disable_0_0);

  RField* f_FCSI_MANFECTL_fectl2_disable = new RField;
  f_FCSI_MANFECTL_fectl2_disable->setInstName ("fectl2_disable");
  f_FCSI_MANFECTL_fectl2_disable->setLongName ("FECTL2 DISABLE");
  f_FCSI_MANFECTL_fectl2_disable->setDescription ("Disable output driver of FECTL2 PAD and enable pull down resistor");
  f_FCSI_MANFECTL_fectl2_disable->setDataWidth (1);
  f_FCSI_MANFECTL_fectl2_disable->setResetVal ("1'b0");
  f_FCSI_MANFECTL_fectl2_disable->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_fectl2_disable, 10);

  Attribute* a_FCSI_MANFECTL_fectl2_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_fectl2_disable_0_0->setInstName ("0");
  a_FCSI_MANFECTL_fectl2_disable_0_0->setLongName ("");
  a_FCSI_MANFECTL_fectl2_disable_0_0->setDescription ("");
  a_FCSI_MANFECTL_fectl2_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_MANFECTL_fectl2_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_MANFECTL_fectl2_disable->connectAttribute (a_FCSI_MANFECTL_fectl2_disable_0_0);

  RField* f_FCSI_MANFECTL_fectl3_disable = new RField;
  f_FCSI_MANFECTL_fectl3_disable->setInstName ("fectl3_disable");
  f_FCSI_MANFECTL_fectl3_disable->setLongName ("FECTL3 DISABLE");
  f_FCSI_MANFECTL_fectl3_disable->setDescription ("Disable output driver of FECTL3 PAD and enable pull down resistor");
  f_FCSI_MANFECTL_fectl3_disable->setDataWidth (1);
  f_FCSI_MANFECTL_fectl3_disable->setResetVal ("1'b0");
  f_FCSI_MANFECTL_fectl3_disable->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_fectl3_disable, 11);

  Attribute* a_FCSI_MANFECTL_fectl3_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_fectl3_disable_0_0->setInstName ("0");
  a_FCSI_MANFECTL_fectl3_disable_0_0->setLongName ("");
  a_FCSI_MANFECTL_fectl3_disable_0_0->setDescription ("");
  a_FCSI_MANFECTL_fectl3_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_MANFECTL_fectl3_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_MANFECTL_fectl3_disable->connectAttribute (a_FCSI_MANFECTL_fectl3_disable_0_0);

  RField* f_FCSI_MANFECTL_fectl4_disable = new RField;
  f_FCSI_MANFECTL_fectl4_disable->setInstName ("fectl4_disable");
  f_FCSI_MANFECTL_fectl4_disable->setLongName ("FECTL4 DISABLE");
  f_FCSI_MANFECTL_fectl4_disable->setDescription ("Disable output driver of FECTL4 PAD and enable pull down resistor");
  f_FCSI_MANFECTL_fectl4_disable->setDataWidth (1);
  f_FCSI_MANFECTL_fectl4_disable->setResetVal ("1'b0");
  f_FCSI_MANFECTL_fectl4_disable->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_fectl4_disable, 12);

  Attribute* a_FCSI_MANFECTL_fectl4_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_fectl4_disable_0_0->setInstName ("0");
  a_FCSI_MANFECTL_fectl4_disable_0_0->setLongName ("");
  a_FCSI_MANFECTL_fectl4_disable_0_0->setDescription ("");
  a_FCSI_MANFECTL_fectl4_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_MANFECTL_fectl4_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_MANFECTL_fectl4_disable->connectAttribute (a_FCSI_MANFECTL_fectl4_disable_0_0);

  RField* f_FCSI_MANFECTL_fectl5_disable = new RField;
  f_FCSI_MANFECTL_fectl5_disable->setInstName ("fectl5_disable");
  f_FCSI_MANFECTL_fectl5_disable->setLongName ("FECTL5 DISABLE");
  f_FCSI_MANFECTL_fectl5_disable->setDescription ("Disable output driver of FECTL5 PAD and enable pull down resistor");
  f_FCSI_MANFECTL_fectl5_disable->setDataWidth (1);
  f_FCSI_MANFECTL_fectl5_disable->setResetVal ("1'b0");
  f_FCSI_MANFECTL_fectl5_disable->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_fectl5_disable, 13);

  Attribute* a_FCSI_MANFECTL_fectl5_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_fectl5_disable_0_0->setInstName ("0");
  a_FCSI_MANFECTL_fectl5_disable_0_0->setLongName ("");
  a_FCSI_MANFECTL_fectl5_disable_0_0->setDescription ("");
  a_FCSI_MANFECTL_fectl5_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_MANFECTL_fectl5_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_MANFECTL_fectl5_disable->connectAttribute (a_FCSI_MANFECTL_fectl5_disable_0_0);

  RField* f_FCSI_MANFECTL_fectl6_disable = new RField;
  f_FCSI_MANFECTL_fectl6_disable->setInstName ("fectl6_disable");
  f_FCSI_MANFECTL_fectl6_disable->setLongName ("FECTL6 DISABLE");
  f_FCSI_MANFECTL_fectl6_disable->setDescription ("Disable output driver of FECTL6 PAD and enable pull down resistor");
  f_FCSI_MANFECTL_fectl6_disable->setDataWidth (1);
  f_FCSI_MANFECTL_fectl6_disable->setResetVal ("1'b0");
  f_FCSI_MANFECTL_fectl6_disable->setAccProp (AccProp::RW);
  r_FCSI_MANFECTL->connectRField (f_FCSI_MANFECTL_fectl6_disable, 14);

  Attribute* a_FCSI_MANFECTL_fectl6_disable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_MANFECTL_fectl6_disable_0_0->setInstName ("0");
  a_FCSI_MANFECTL_fectl6_disable_0_0->setLongName ("");
  a_FCSI_MANFECTL_fectl6_disable_0_0->setDescription ("");
  a_FCSI_MANFECTL_fectl6_disable_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_MANFECTL_fectl6_disable_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_MANFECTL_fectl6_disable->connectAttribute (a_FCSI_MANFECTL_fectl6_disable_0_0);

  Register* r_FCSI_FECTL6 = new Register;
  r_FCSI_FECTL6->setInstName ("FECTL6");
  r_FCSI_FECTL6->setLongName ("FECTL CONFIG RX GAIN6");
  r_FCSI_FECTL6->setDescription ("FCSI-LDO1V2");
  r_FCSI_FECTL6->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_FECTL6, 0x0000000D);

  RField* f_FCSI_FECTL6_lna_gain6 = new RField;
  f_FCSI_FECTL6_lna_gain6->setInstName ("lna_gain6");
  f_FCSI_FECTL6_lna_gain6->setLongName ("LNA GAIN6");
  f_FCSI_FECTL6_lna_gain6->setDescription ("LNA gain6");
  f_FCSI_FECTL6_lna_gain6->setDataWidth (2);
  f_FCSI_FECTL6_lna_gain6->setResetVal ("2'b00");
  f_FCSI_FECTL6_lna_gain6->setAccProp (AccProp::RW);
  r_FCSI_FECTL6->connectRField (f_FCSI_FECTL6_lna_gain6, 0);

  Attribute* a_FCSI_FECTL6_lna_gain6_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL6_lna_gain6_0_0->setInstName ("0");
  a_FCSI_FECTL6_lna_gain6_0_0->setLongName ("");
  a_FCSI_FECTL6_lna_gain6_0_0->setDescription ("");
  a_FCSI_FECTL6_lna_gain6_0_0->addItem("0", "2'b00", "");
  a_FCSI_FECTL6_lna_gain6_0_0->addItem("1", "2'b01", "");
  a_FCSI_FECTL6_lna_gain6_0_0->addItem("2", "2'b10", "");
  a_FCSI_FECTL6_lna_gain6_0_0->addItem("3", "2'b11", "");
  f_FCSI_FECTL6_lna_gain6->connectAttribute (a_FCSI_FECTL6_lna_gain6_0_0);

  RField* f_FCSI_FECTL6_fectl_gain6 = new RField;
  f_FCSI_FECTL6_fectl_gain6->setInstName ("fectl_gain6");
  f_FCSI_FECTL6_fectl_gain6->setLongName ("FECTL GAIN6");
  f_FCSI_FECTL6_fectl_gain6->setDescription ("FECTL gain6");
  f_FCSI_FECTL6_fectl_gain6->setDataWidth (6);
  f_FCSI_FECTL6_fectl_gain6->setResetVal ("6'b000000");
  f_FCSI_FECTL6_fectl_gain6->setAccProp (AccProp::RW);
  r_FCSI_FECTL6->connectRField (f_FCSI_FECTL6_fectl_gain6, 2);

  Attribute* a_FCSI_FECTL6_fectl_gain6_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_FECTL6_fectl_gain6_0_0->setInstName ("0");
  a_FCSI_FECTL6_fectl_gain6_0_0->setLongName ("");
  a_FCSI_FECTL6_fectl_gain6_0_0->setDescription ("");
  a_FCSI_FECTL6_fectl_gain6_0_0->addItem("0", "6'b000000", "");
  a_FCSI_FECTL6_fectl_gain6_0_0->addItem("1", "6'b000001", "");
  a_FCSI_FECTL6_fectl_gain6_0_0->addItem("62", "6'b111110", "");
  a_FCSI_FECTL6_fectl_gain6_0_0->addItem("63", "6'b111111", "");
  f_FCSI_FECTL6_fectl_gain6->connectAttribute (a_FCSI_FECTL6_fectl_gain6_0_0);

  Register* r_FCSI_DIRSTEP2 = new Register;
  r_FCSI_DIRSTEP2->setInstName ("DIRSTEP2");
  r_FCSI_DIRSTEP2->setLongName ("DIRSTEP2");
  r_FCSI_DIRSTEP2->setDescription ("BB-LDO1V2");
  r_FCSI_DIRSTEP2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_DIRSTEP2, 0x0000000E);

  RField* f_FCSI_DIRSTEP2_lna = new RField;
  f_FCSI_DIRSTEP2_lna->setInstName ("lna");
  f_FCSI_DIRSTEP2_lna->setLongName ("LNA");
  f_FCSI_DIRSTEP2_lna->setDescription ("LNA");
  f_FCSI_DIRSTEP2_lna->setDataWidth (3);
  f_FCSI_DIRSTEP2_lna->setResetVal ("3'b000");
  f_FCSI_DIRSTEP2_lna->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP2->connectRField (f_FCSI_DIRSTEP2_lna, 0);

  Attribute* a_FCSI_DIRSTEP2_lna_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP2_lna_0_0->setInstName ("0");
  a_FCSI_DIRSTEP2_lna_0_0->setLongName ("");
  a_FCSI_DIRSTEP2_lna_0_0->setDescription ("");
  a_FCSI_DIRSTEP2_lna_0_0->addItem("0", "3'b000", "");
  a_FCSI_DIRSTEP2_lna_0_0->addItem("1", "3'b001", "");
  a_FCSI_DIRSTEP2_lna_0_0->addItem("2", "3'b010", "");
  a_FCSI_DIRSTEP2_lna_0_0->addItem("3", "3'b011", "");
  a_FCSI_DIRSTEP2_lna_0_0->addItem("4", "3'b100", "");
  a_FCSI_DIRSTEP2_lna_0_0->addItem("5", "3'b101", "");
  a_FCSI_DIRSTEP2_lna_0_0->addItem("6", "3'b110", "");
  a_FCSI_DIRSTEP2_lna_0_0->addItem("7", "3'b111", "");
  f_FCSI_DIRSTEP2_lna->connectAttribute (a_FCSI_DIRSTEP2_lna_0_0);

  RField* f_FCSI_DIRSTEP2_sel_s2d_rx = new RField;
  f_FCSI_DIRSTEP2_sel_s2d_rx->setInstName ("sel_s2d_rx");
  f_FCSI_DIRSTEP2_sel_s2d_rx->setLongName ("SEL_S2D_RX");
  f_FCSI_DIRSTEP2_sel_s2d_rx->setDescription ("Select RSSI xSSI range for dedicated configurations");
  f_FCSI_DIRSTEP2_sel_s2d_rx->setDataWidth (1);
  f_FCSI_DIRSTEP2_sel_s2d_rx->setResetVal ("1'b0");
  f_FCSI_DIRSTEP2_sel_s2d_rx->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP2->connectRField (f_FCSI_DIRSTEP2_sel_s2d_rx, 3);

  Attribute* a_FCSI_DIRSTEP2_sel_s2d_rx_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP2_sel_s2d_rx_0_0->setInstName ("0");
  a_FCSI_DIRSTEP2_sel_s2d_rx_0_0->setLongName ("");
  a_FCSI_DIRSTEP2_sel_s2d_rx_0_0->setDescription ("");
  a_FCSI_DIRSTEP2_sel_s2d_rx_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_DIRSTEP2_sel_s2d_rx_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_DIRSTEP2_sel_s2d_rx->connectAttribute (a_FCSI_DIRSTEP2_sel_s2d_rx_0_0);

  RField* f_FCSI_DIRSTEP2_pgc_gain = new RField;
  f_FCSI_DIRSTEP2_pgc_gain->setInstName ("pgc_gain");
  f_FCSI_DIRSTEP2_pgc_gain->setLongName ("PGC GAIN");
  f_FCSI_DIRSTEP2_pgc_gain->setDescription ("PGC gain");
  f_FCSI_DIRSTEP2_pgc_gain->setDataWidth (4);
  f_FCSI_DIRSTEP2_pgc_gain->setResetVal ("4'b0000");
  f_FCSI_DIRSTEP2_pgc_gain->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP2->connectRField (f_FCSI_DIRSTEP2_pgc_gain, 4);

  Attribute* a_FCSI_DIRSTEP2_pgc_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP2_pgc_gain_0_0->setInstName ("0");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->setLongName ("");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->setDescription ("");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("0", "4'b0000", "0dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("1", "4'b0001", "2dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("2", "4'b0010", "4dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("3", "4'b0011", "6dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("4", "4'b0100", "8dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("5", "4'b0101", "10dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("6", "4'b0110", "12dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("7", "4'b0111", "14dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("8", "4'b1000", "16dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("9", "4'b1001", "18dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("10", "4'b1010", "20dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("11", "4'b1011", "2dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("12", "4'b1100", "24dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("13", "4'b1101", "26dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("14", "4'b1110", "28dB");
  a_FCSI_DIRSTEP2_pgc_gain_0_0->addItem("15", "4'b1111", "30dB");
  f_FCSI_DIRSTEP2_pgc_gain->connectAttribute (a_FCSI_DIRSTEP2_pgc_gain_0_0);

  RField* f_FCSI_DIRSTEP2_rx_filter = new RField;
  f_FCSI_DIRSTEP2_rx_filter->setInstName ("rx_filter");
  f_FCSI_DIRSTEP2_rx_filter->setLongName ("RX FILTER");
  f_FCSI_DIRSTEP2_rx_filter->setDescription ("RX Filter");
  f_FCSI_DIRSTEP2_rx_filter->setDataWidth (6);
  f_FCSI_DIRSTEP2_rx_filter->setResetVal ("6'b000000");
  f_FCSI_DIRSTEP2_rx_filter->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP2->connectRField (f_FCSI_DIRSTEP2_rx_filter, 8);

  Attribute* a_FCSI_DIRSTEP2_rx_filter_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP2_rx_filter_0_0->setInstName ("0");
  a_FCSI_DIRSTEP2_rx_filter_0_0->setLongName ("");
  a_FCSI_DIRSTEP2_rx_filter_0_0->setDescription ("");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("0", "6'b000000", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("1", "6'b000001", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("2", "6'b000010", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("3", "6'b000011", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("4", "6'b000100", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("5", "6'b000101", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("6", "6'b000110", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("7", "6'b000111", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("8", "6'b001000", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("9", "6'b001001", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("10", "6'b001010", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("11", "6'b001011", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("12", "6'b001100", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("13", "6'b001101", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("14", "6'b001110", "xx");
  a_FCSI_DIRSTEP2_rx_filter_0_0->addItem("15", "6'b001111", "xx");
  f_FCSI_DIRSTEP2_rx_filter->connectAttribute (a_FCSI_DIRSTEP2_rx_filter_0_0);

  Register* r_FCSI_DIRSTEP1 = new Register;
  r_FCSI_DIRSTEP1->setInstName ("DIRSTEP1");
  r_FCSI_DIRSTEP1->setLongName ("DIRSTEP1");
  r_FCSI_DIRSTEP1->setDescription ("BB-LDO1V2");
  r_FCSI_DIRSTEP1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_DIRSTEP1, 0x0000000F);

  RField* f_FCSI_DIRSTEP1_lna = new RField;
  f_FCSI_DIRSTEP1_lna->setInstName ("lna");
  f_FCSI_DIRSTEP1_lna->setLongName ("LNA");
  f_FCSI_DIRSTEP1_lna->setDescription ("LNA");
  f_FCSI_DIRSTEP1_lna->setDataWidth (3);
  f_FCSI_DIRSTEP1_lna->setResetVal ("3'b000");
  f_FCSI_DIRSTEP1_lna->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP1->connectRField (f_FCSI_DIRSTEP1_lna, 0);

  Attribute* a_FCSI_DIRSTEP1_lna_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP1_lna_0_0->setInstName ("0");
  a_FCSI_DIRSTEP1_lna_0_0->setLongName ("");
  a_FCSI_DIRSTEP1_lna_0_0->setDescription ("");
  a_FCSI_DIRSTEP1_lna_0_0->addItem("0", "3'b000", "");
  a_FCSI_DIRSTEP1_lna_0_0->addItem("1", "3'b001", "");
  a_FCSI_DIRSTEP1_lna_0_0->addItem("2", "3'b010", "");
  a_FCSI_DIRSTEP1_lna_0_0->addItem("3", "3'b011", "");
  a_FCSI_DIRSTEP1_lna_0_0->addItem("4", "3'b100", "");
  a_FCSI_DIRSTEP1_lna_0_0->addItem("5", "3'b101", "");
  a_FCSI_DIRSTEP1_lna_0_0->addItem("6", "3'b110", "");
  a_FCSI_DIRSTEP1_lna_0_0->addItem("7", "3'b111", "");
  f_FCSI_DIRSTEP1_lna->connectAttribute (a_FCSI_DIRSTEP1_lna_0_0);

  RField* f_FCSI_DIRSTEP1_sel_s2d_rx = new RField;
  f_FCSI_DIRSTEP1_sel_s2d_rx->setInstName ("sel_s2d_rx");
  f_FCSI_DIRSTEP1_sel_s2d_rx->setLongName ("SEL_S2D_RX");
  f_FCSI_DIRSTEP1_sel_s2d_rx->setDescription ("Select RSSI xSSI range for dedicated configurations");
  f_FCSI_DIRSTEP1_sel_s2d_rx->setDataWidth (1);
  f_FCSI_DIRSTEP1_sel_s2d_rx->setResetVal ("1'b0");
  f_FCSI_DIRSTEP1_sel_s2d_rx->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP1->connectRField (f_FCSI_DIRSTEP1_sel_s2d_rx, 3);

  Attribute* a_FCSI_DIRSTEP1_sel_s2d_rx_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP1_sel_s2d_rx_0_0->setInstName ("0");
  a_FCSI_DIRSTEP1_sel_s2d_rx_0_0->setLongName ("");
  a_FCSI_DIRSTEP1_sel_s2d_rx_0_0->setDescription ("");
  a_FCSI_DIRSTEP1_sel_s2d_rx_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_DIRSTEP1_sel_s2d_rx_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_DIRSTEP1_sel_s2d_rx->connectAttribute (a_FCSI_DIRSTEP1_sel_s2d_rx_0_0);

  RField* f_FCSI_DIRSTEP1_pgc_gain = new RField;
  f_FCSI_DIRSTEP1_pgc_gain->setInstName ("pgc_gain");
  f_FCSI_DIRSTEP1_pgc_gain->setLongName ("PGC GAIN");
  f_FCSI_DIRSTEP1_pgc_gain->setDescription ("PGC gain");
  f_FCSI_DIRSTEP1_pgc_gain->setDataWidth (4);
  f_FCSI_DIRSTEP1_pgc_gain->setResetVal ("4'b0000");
  f_FCSI_DIRSTEP1_pgc_gain->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP1->connectRField (f_FCSI_DIRSTEP1_pgc_gain, 4);

  Attribute* a_FCSI_DIRSTEP1_pgc_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP1_pgc_gain_0_0->setInstName ("0");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->setLongName ("");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->setDescription ("");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("0", "4'b0000", "0dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("1", "4'b0001", "2dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("2", "4'b0010", "4dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("3", "4'b0011", "6dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("4", "4'b0100", "8dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("5", "4'b0101", "10dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("6", "4'b0110", "12dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("7", "4'b0111", "14dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("8", "4'b1000", "16dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("9", "4'b1001", "18dB");
  a_FCSI_DIRSTEP1_pgc_gain_0_0->addItem("10", "4'b1010", "20dB");
  f_FCSI_DIRSTEP1_pgc_gain->connectAttribute (a_FCSI_DIRSTEP1_pgc_gain_0_0);

  RField* f_FCSI_DIRSTEP1_rx_filter = new RField;
  f_FCSI_DIRSTEP1_rx_filter->setInstName ("rx_filter");
  f_FCSI_DIRSTEP1_rx_filter->setLongName ("RX FILTER");
  f_FCSI_DIRSTEP1_rx_filter->setDescription ("RX Filter");
  f_FCSI_DIRSTEP1_rx_filter->setDataWidth (6);
  f_FCSI_DIRSTEP1_rx_filter->setResetVal ("6'b000000");
  f_FCSI_DIRSTEP1_rx_filter->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP1->connectRField (f_FCSI_DIRSTEP1_rx_filter, 8);

  Attribute* a_FCSI_DIRSTEP1_rx_filter_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP1_rx_filter_0_0->setInstName ("0");
  a_FCSI_DIRSTEP1_rx_filter_0_0->setLongName ("");
  a_FCSI_DIRSTEP1_rx_filter_0_0->setDescription ("");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("0", "6'b000000", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("1", "6'b000001", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("2", "6'b000010", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("3", "6'b000011", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("4", "6'b000100", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("5", "6'b000101", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("6", "6'b000110", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("7", "6'b000111", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("8", "6'b001000", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("9", "6'b001001", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("10", "6'b001010", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("11", "6'b001011", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("12", "6'b001100", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("13", "6'b001101", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("14", "6'b001110", "xx");
  a_FCSI_DIRSTEP1_rx_filter_0_0->addItem("15", "6'b001111", "xx");
  f_FCSI_DIRSTEP1_rx_filter->connectAttribute (a_FCSI_DIRSTEP1_rx_filter_0_0);

  Register* r_FCSI_SSBDET = new Register;
  r_FCSI_SSBDET->setInstName ("SSBDET");
  r_FCSI_SSBDET->setLongName ("SSBDET (HB/LB)");
  r_FCSI_SSBDET->setDescription ("BB-LDO1V2");
  r_FCSI_SSBDET->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SSBDET, 0x00000010);

  RField* f_FCSI_SSBDET_enable = new RField;
  f_FCSI_SSBDET_enable->setInstName ("enable");
  f_FCSI_SSBDET_enable->setLongName ("ENABLE");
  f_FCSI_SSBDET_enable->setDescription ("Enable SSBCAL");
  f_FCSI_SSBDET_enable->setDataWidth (1);
  f_FCSI_SSBDET_enable->setResetVal ("1'b0");
  f_FCSI_SSBDET_enable->setAccProp (AccProp::RW);
  r_FCSI_SSBDET->connectRField (f_FCSI_SSBDET_enable, 0);

  Attribute* a_FCSI_SSBDET_enable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSBDET_enable_0_0->setInstName ("0");
  a_FCSI_SSBDET_enable_0_0->setLongName ("");
  a_FCSI_SSBDET_enable_0_0->setDescription ("");
  a_FCSI_SSBDET_enable_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSBDET_enable_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSBDET_enable->connectAttribute (a_FCSI_SSBDET_enable_0_0);

  RField* f_FCSI_SSBDET_ctl_bias_select = new RField;
  f_FCSI_SSBDET_ctl_bias_select->setInstName ("ctl_bias_select");
  f_FCSI_SSBDET_ctl_bias_select->setLongName ("CTL_BIAS_SELECT");
  f_FCSI_SSBDET_ctl_bias_select->setDescription ("Control type of current for SSBCAL");
  f_FCSI_SSBDET_ctl_bias_select->setDataWidth (1);
  f_FCSI_SSBDET_ctl_bias_select->setResetVal ("1'b0");
  f_FCSI_SSBDET_ctl_bias_select->setAccProp (AccProp::RW);
  r_FCSI_SSBDET->connectRField (f_FCSI_SSBDET_ctl_bias_select, 1);

  Attribute* a_FCSI_SSBDET_ctl_bias_select_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSBDET_ctl_bias_select_0_0->setInstName ("0");
  a_FCSI_SSBDET_ctl_bias_select_0_0->setLongName ("");
  a_FCSI_SSBDET_ctl_bias_select_0_0->setDescription ("");
  a_FCSI_SSBDET_ctl_bias_select_0_0->addItem("1", "1'b1", "Local temperature related current");
  a_FCSI_SSBDET_ctl_bias_select_0_0->addItem("0", "1'b0", "Constant current");
  f_FCSI_SSBDET_ctl_bias_select->connectAttribute (a_FCSI_SSBDET_ctl_bias_select_0_0);

  RField* f_FCSI_SSBDET_ctl_Iss = new RField;
  f_FCSI_SSBDET_ctl_Iss->setInstName ("ctl_Iss");
  f_FCSI_SSBDET_ctl_Iss->setLongName ("CTL ISS");
  f_FCSI_SSBDET_ctl_Iss->setDescription ("Control bias current of the detector");
  f_FCSI_SSBDET_ctl_Iss->setDataWidth (4);
  f_FCSI_SSBDET_ctl_Iss->setResetVal ("4'b0000");
  f_FCSI_SSBDET_ctl_Iss->setAccProp (AccProp::RW);
  r_FCSI_SSBDET->connectRField (f_FCSI_SSBDET_ctl_Iss, 2);

  Attribute* a_FCSI_SSBDET_ctl_Iss_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSBDET_ctl_Iss_0_0->setInstName ("0");
  a_FCSI_SSBDET_ctl_Iss_0_0->setLongName ("");
  a_FCSI_SSBDET_ctl_Iss_0_0->setDescription ("");
  a_FCSI_SSBDET_ctl_Iss_0_0->addItem("12", "4'b1100", "109%");
  a_FCSI_SSBDET_ctl_Iss_0_0->addItem("8", "4'b0100", "104.5%");
  a_FCSI_SSBDET_ctl_Iss_0_0->addItem("0", "4'b0000", "100%");
  a_FCSI_SSBDET_ctl_Iss_0_0->addItem("1", "4'b0001", "95.5%");
  a_FCSI_SSBDET_ctl_Iss_0_0->addItem("3", "4'b0011", "91%");
  f_FCSI_SSBDET_ctl_Iss->connectAttribute (a_FCSI_SSBDET_ctl_Iss_0_0);

  Register* r_FCSI_PADRIVER = new Register;
  r_FCSI_PADRIVER->setInstName ("PADRIVER");
  r_FCSI_PADRIVER->setLongName ("PA DRIVER GENERAL (HB/LB)");
  r_FCSI_PADRIVER->setDescription ("BB-LDO1V2");
  r_FCSI_PADRIVER->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PADRIVER, 0x00000011);

  RField* f_FCSI_PADRIVER_ctl_vc_pad = new RField;
  f_FCSI_PADRIVER_ctl_vc_pad->setInstName ("ctl_vc_pad");
  f_FCSI_PADRIVER_ctl_vc_pad->setLongName ("CTL VC PAD");
  f_FCSI_PADRIVER_ctl_vc_pad->setDescription ("Control cascode voltage");
  f_FCSI_PADRIVER_ctl_vc_pad->setDataWidth (3);
  f_FCSI_PADRIVER_ctl_vc_pad->setResetVal ("3'b000");
  f_FCSI_PADRIVER_ctl_vc_pad->setAccProp (AccProp::RW);
  r_FCSI_PADRIVER->connectRField (f_FCSI_PADRIVER_ctl_vc_pad, 0);

  Attribute* a_FCSI_PADRIVER_ctl_vc_pad_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->setInstName ("0");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->setLongName ("");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->setDescription ("");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->addItem("0", "3'b000", "1.25V");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->addItem("1", "3'b001", "1.18V");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->addItem("2", "3'b010", "1.12V");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->addItem("3", "3'b011", "1.05V");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->addItem("4", "3'b100", "0.99V");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->addItem("5", "3'b101", "0.93");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->addItem("6", "3'b110", "0.86");
  a_FCSI_PADRIVER_ctl_vc_pad_0_0->addItem("7", "3'b111", "0.8V");
  f_FCSI_PADRIVER_ctl_vc_pad->connectAttribute (a_FCSI_PADRIVER_ctl_vc_pad_0_0);

  RField* f_FCSI_PADRIVER_en_pad = new RField;
  f_FCSI_PADRIVER_en_pad->setInstName ("en_pad");
  f_FCSI_PADRIVER_en_pad->setLongName ("EN PAD");
  f_FCSI_PADRIVER_en_pad->setDescription ("Enable predriver");
  f_FCSI_PADRIVER_en_pad->setDataWidth (1);
  f_FCSI_PADRIVER_en_pad->setResetVal ("1'b0");
  f_FCSI_PADRIVER_en_pad->setAccProp (AccProp::RW);
  r_FCSI_PADRIVER->connectRField (f_FCSI_PADRIVER_en_pad, 3);

  Attribute* a_FCSI_PADRIVER_en_pad_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PADRIVER_en_pad_0_0->setInstName ("0");
  a_FCSI_PADRIVER_en_pad_0_0->setLongName ("");
  a_FCSI_PADRIVER_en_pad_0_0->setDescription ("");
  a_FCSI_PADRIVER_en_pad_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PADRIVER_en_pad_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PADRIVER_en_pad->connectAttribute (a_FCSI_PADRIVER_en_pad_0_0);

  RField* f_FCSI_PADRIVER_ctl_stby = new RField;
  f_FCSI_PADRIVER_ctl_stby->setInstName ("ctl_stby");
  f_FCSI_PADRIVER_ctl_stby->setLongName ("CTL STBY");
  f_FCSI_PADRIVER_ctl_stby->setDescription ("Enable manual standby");
  f_FCSI_PADRIVER_ctl_stby->setDataWidth (1);
  f_FCSI_PADRIVER_ctl_stby->setResetVal ("1'b0");
  f_FCSI_PADRIVER_ctl_stby->setAccProp (AccProp::RW);
  r_FCSI_PADRIVER->connectRField (f_FCSI_PADRIVER_ctl_stby, 4);

  Attribute* a_FCSI_PADRIVER_ctl_stby_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PADRIVER_ctl_stby_0_0->setInstName ("0");
  a_FCSI_PADRIVER_ctl_stby_0_0->setLongName ("");
  a_FCSI_PADRIVER_ctl_stby_0_0->setDescription ("");
  a_FCSI_PADRIVER_ctl_stby_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PADRIVER_ctl_stby_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PADRIVER_ctl_stby->connectAttribute (a_FCSI_PADRIVER_ctl_stby_0_0);

  RField* f_FCSI_PADRIVER_stby_pad = new RField;
  f_FCSI_PADRIVER_stby_pad->setInstName ("stby_pad");
  f_FCSI_PADRIVER_stby_pad->setLongName ("STBY PAD");
  f_FCSI_PADRIVER_stby_pad->setDescription ("Standby predriver");
  f_FCSI_PADRIVER_stby_pad->setDataWidth (1);
  f_FCSI_PADRIVER_stby_pad->setResetVal ("1'b0");
  f_FCSI_PADRIVER_stby_pad->setAccProp (AccProp::RW);
  r_FCSI_PADRIVER->connectRField (f_FCSI_PADRIVER_stby_pad, 5);

  Attribute* a_FCSI_PADRIVER_stby_pad_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PADRIVER_stby_pad_0_0->setInstName ("0");
  a_FCSI_PADRIVER_stby_pad_0_0->setLongName ("");
  a_FCSI_PADRIVER_stby_pad_0_0->setDescription ("");
  a_FCSI_PADRIVER_stby_pad_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PADRIVER_stby_pad_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PADRIVER_stby_pad->connectAttribute (a_FCSI_PADRIVER_stby_pad_0_0);

  RField* f_FCSI_PADRIVER_ctl_pad_bias = new RField;
  f_FCSI_PADRIVER_ctl_pad_bias->setInstName ("ctl_pad_bias");
  f_FCSI_PADRIVER_ctl_pad_bias->setLongName ("CTL PAD BIAS");
  f_FCSI_PADRIVER_ctl_pad_bias->setDescription ("Control PAD bias");
  f_FCSI_PADRIVER_ctl_pad_bias->setDataWidth (3);
  f_FCSI_PADRIVER_ctl_pad_bias->setResetVal ("3'b000");
  f_FCSI_PADRIVER_ctl_pad_bias->setAccProp (AccProp::RW);
  r_FCSI_PADRIVER->connectRField (f_FCSI_PADRIVER_ctl_pad_bias, 6);

  Attribute* a_FCSI_PADRIVER_ctl_pad_bias_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->setInstName ("0");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->setLongName ("");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->setDescription ("");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->addItem("3", "3'b011", "130%");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->addItem("2", "3'b010", "120%");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->addItem("1", "3'b001", "110%");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->addItem("0", "3'b000", "100%");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->addItem("7", "3'b111", "90%");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->addItem("6", "3'b110", "80%");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->addItem("5", "3'b101", "70%");
  a_FCSI_PADRIVER_ctl_pad_bias_0_0->addItem("4", "3'b100", "60%");
  f_FCSI_PADRIVER_ctl_pad_bias->connectAttribute (a_FCSI_PADRIVER_ctl_pad_bias_0_0);

  RField* f_FCSI_PADRIVER_en_ctl_padgain = new RField;
  f_FCSI_PADRIVER_en_ctl_padgain->setInstName ("en_ctl_padgain");
  f_FCSI_PADRIVER_en_ctl_padgain->setLongName ("EN CTL PAD GAIN");
  f_FCSI_PADRIVER_en_ctl_padgain->setDescription ("Enable gain-control of the predriver");
  f_FCSI_PADRIVER_en_ctl_padgain->setDataWidth (1);
  f_FCSI_PADRIVER_en_ctl_padgain->setResetVal ("1'b0");
  f_FCSI_PADRIVER_en_ctl_padgain->setAccProp (AccProp::RW);
  r_FCSI_PADRIVER->connectRField (f_FCSI_PADRIVER_en_ctl_padgain, 9);

  Attribute* a_FCSI_PADRIVER_en_ctl_padgain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PADRIVER_en_ctl_padgain_0_0->setInstName ("0");
  a_FCSI_PADRIVER_en_ctl_padgain_0_0->setLongName ("");
  a_FCSI_PADRIVER_en_ctl_padgain_0_0->setDescription ("");
  a_FCSI_PADRIVER_en_ctl_padgain_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PADRIVER_en_ctl_padgain_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PADRIVER_en_ctl_padgain->connectAttribute (a_FCSI_PADRIVER_en_ctl_padgain_0_0);

  RField* f_FCSI_PADRIVER_ctl_pad_gain = new RField;
  f_FCSI_PADRIVER_ctl_pad_gain->setInstName ("ctl_pad_gain");
  f_FCSI_PADRIVER_ctl_pad_gain->setLongName ("CTL PAD GAIN");
  f_FCSI_PADRIVER_ctl_pad_gain->setDescription ("Predriver gain for manual operation");
  f_FCSI_PADRIVER_ctl_pad_gain->setDataWidth (6);
  f_FCSI_PADRIVER_ctl_pad_gain->setResetVal ("6'b000000");
  f_FCSI_PADRIVER_ctl_pad_gain->setAccProp (AccProp::RW);
  r_FCSI_PADRIVER->connectRField (f_FCSI_PADRIVER_ctl_pad_gain, 10);

  Attribute* a_FCSI_PADRIVER_ctl_pad_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->setInstName ("0");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->setLongName ("");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->setDescription ("");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("63", "6'b111111", " 0dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("50", "6'b110010", "-2dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("40", "6'b101000", "-3.95dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("32", "6'b100000", "-5.88dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("21", "6'b011001", "-8.03dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("20", "6'b010100", "-9.97dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("16", "6'b010000", "-11.9dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("11", "6'b001101", "-13.71dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("10", "6'b001010", "-15.99dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("8", "6'b001000", "-17.93dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("6", "6'b000110", "-20.42dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("5", "6'b000101", "-22.01dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("4", "6'b000100", "-23.95dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("3", "6'b000011", "-26.44dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("2", "6'b000010", "-29.97dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("1", "6'b000001", "-35.99dB");
  a_FCSI_PADRIVER_ctl_pad_gain_0_0->addItem("0", "6'b000000", "off");
  f_FCSI_PADRIVER_ctl_pad_gain->connectAttribute (a_FCSI_PADRIVER_ctl_pad_gain_0_0);

  Register* r_FCSI_TPCMIXER = new Register;
  r_FCSI_TPCMIXER->setInstName ("TPCMIXER");
  r_FCSI_TPCMIXER->setLongName ("TPC MIXER (HB/LB)");
  r_FCSI_TPCMIXER->setDescription ("BB-LDO1V2");
  r_FCSI_TPCMIXER->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TPCMIXER, 0x00000012);

  RField* f_FCSI_TPCMIXER_ctl_en_tpc = new RField;
  f_FCSI_TPCMIXER_ctl_en_tpc->setInstName ("ctl_en_tpc");
  f_FCSI_TPCMIXER_ctl_en_tpc->setLongName ("CTL EN TPC");
  f_FCSI_TPCMIXER_ctl_en_tpc->setDescription ("Control Enable TPC");
  f_FCSI_TPCMIXER_ctl_en_tpc->setDataWidth (1);
  f_FCSI_TPCMIXER_ctl_en_tpc->setResetVal ("1'b0");
  f_FCSI_TPCMIXER_ctl_en_tpc->setAccProp (AccProp::RW);
  r_FCSI_TPCMIXER->connectRField (f_FCSI_TPCMIXER_ctl_en_tpc, 0);

  Attribute* a_FCSI_TPCMIXER_ctl_en_tpc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCMIXER_ctl_en_tpc_0_0->setInstName ("0");
  a_FCSI_TPCMIXER_ctl_en_tpc_0_0->setLongName ("");
  a_FCSI_TPCMIXER_ctl_en_tpc_0_0->setDescription ("");
  a_FCSI_TPCMIXER_ctl_en_tpc_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TPCMIXER_ctl_en_tpc_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TPCMIXER_ctl_en_tpc->connectAttribute (a_FCSI_TPCMIXER_ctl_en_tpc_0_0);

  RField* f_FCSI_TPCMIXER_en_tpc = new RField;
  f_FCSI_TPCMIXER_en_tpc->setInstName ("en_tpc");
  f_FCSI_TPCMIXER_en_tpc->setLongName ("EN TPC");
  f_FCSI_TPCMIXER_en_tpc->setDescription ("Enable TPC (incl. I&Q offset DAC)");
  f_FCSI_TPCMIXER_en_tpc->setDataWidth (1);
  f_FCSI_TPCMIXER_en_tpc->setResetVal ("1'b0");
  f_FCSI_TPCMIXER_en_tpc->setAccProp (AccProp::RW);
  r_FCSI_TPCMIXER->connectRField (f_FCSI_TPCMIXER_en_tpc, 1);

  Attribute* a_FCSI_TPCMIXER_en_tpc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCMIXER_en_tpc_0_0->setInstName ("0");
  a_FCSI_TPCMIXER_en_tpc_0_0->setLongName ("");
  a_FCSI_TPCMIXER_en_tpc_0_0->setDescription ("");
  a_FCSI_TPCMIXER_en_tpc_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TPCMIXER_en_tpc_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TPCMIXER_en_tpc->connectAttribute (a_FCSI_TPCMIXER_en_tpc_0_0);

  RField* f_FCSI_TPCMIXER_en_tpc_oa_dctl = new RField;
  f_FCSI_TPCMIXER_en_tpc_oa_dctl->setInstName ("en_tpc_oa_dctl");
  f_FCSI_TPCMIXER_en_tpc_oa_dctl->setLongName ("EN TPC OA DCTL");
  f_FCSI_TPCMIXER_en_tpc_oa_dctl->setDescription ("Enable manual setup of TPC OA");
  f_FCSI_TPCMIXER_en_tpc_oa_dctl->setDataWidth (1);
  f_FCSI_TPCMIXER_en_tpc_oa_dctl->setResetVal ("1'b0");
  f_FCSI_TPCMIXER_en_tpc_oa_dctl->setAccProp (AccProp::RW);
  r_FCSI_TPCMIXER->connectRField (f_FCSI_TPCMIXER_en_tpc_oa_dctl, 2);

  Attribute* a_FCSI_TPCMIXER_en_tpc_oa_dctl_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCMIXER_en_tpc_oa_dctl_0_0->setInstName ("0");
  a_FCSI_TPCMIXER_en_tpc_oa_dctl_0_0->setLongName ("");
  a_FCSI_TPCMIXER_en_tpc_oa_dctl_0_0->setDescription ("");
  a_FCSI_TPCMIXER_en_tpc_oa_dctl_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TPCMIXER_en_tpc_oa_dctl_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TPCMIXER_en_tpc_oa_dctl->connectAttribute (a_FCSI_TPCMIXER_en_tpc_oa_dctl_0_0);

  RField* f_FCSI_TPCMIXER_ctl_tpc_oa_dctl = new RField;
  f_FCSI_TPCMIXER_ctl_tpc_oa_dctl->setInstName ("ctl_tpc_oa_dctl");
  f_FCSI_TPCMIXER_ctl_tpc_oa_dctl->setLongName ("CTL TPC OA DCTL");
  f_FCSI_TPCMIXER_ctl_tpc_oa_dctl->setDescription ("Control manual setup of TPC OA");
  f_FCSI_TPCMIXER_ctl_tpc_oa_dctl->setDataWidth (4);
  f_FCSI_TPCMIXER_ctl_tpc_oa_dctl->setResetVal ("4'b0000");
  f_FCSI_TPCMIXER_ctl_tpc_oa_dctl->setAccProp (AccProp::RW);
  r_FCSI_TPCMIXER->connectRField (f_FCSI_TPCMIXER_ctl_tpc_oa_dctl, 3);

  Attribute* a_FCSI_TPCMIXER_ctl_tpc_oa_dctl_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCMIXER_ctl_tpc_oa_dctl_0_0->setInstName ("0");
  a_FCSI_TPCMIXER_ctl_tpc_oa_dctl_0_0->setLongName ("");
  a_FCSI_TPCMIXER_ctl_tpc_oa_dctl_0_0->setDescription ("");
  a_FCSI_TPCMIXER_ctl_tpc_oa_dctl_0_0->addItem("0", "4'b0000", "");
  f_FCSI_TPCMIXER_ctl_tpc_oa_dctl->connectAttribute (a_FCSI_TPCMIXER_ctl_tpc_oa_dctl_0_0);

  RField* f_FCSI_TPCMIXER_ctl_tpc_ibias = new RField;
  f_FCSI_TPCMIXER_ctl_tpc_ibias->setInstName ("ctl_tpc_ibias");
  f_FCSI_TPCMIXER_ctl_tpc_ibias->setLongName ("CTL TPC IBIAS");
  f_FCSI_TPCMIXER_ctl_tpc_ibias->setDescription ("Control bias current");
  f_FCSI_TPCMIXER_ctl_tpc_ibias->setDataWidth (2);
  f_FCSI_TPCMIXER_ctl_tpc_ibias->setResetVal ("2'b00");
  f_FCSI_TPCMIXER_ctl_tpc_ibias->setAccProp (AccProp::RW);
  r_FCSI_TPCMIXER->connectRField (f_FCSI_TPCMIXER_ctl_tpc_ibias, 7);

  Attribute* a_FCSI_TPCMIXER_ctl_tpc_ibias_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCMIXER_ctl_tpc_ibias_0_0->setInstName ("0");
  a_FCSI_TPCMIXER_ctl_tpc_ibias_0_0->setLongName ("");
  a_FCSI_TPCMIXER_ctl_tpc_ibias_0_0->setDescription ("");
  a_FCSI_TPCMIXER_ctl_tpc_ibias_0_0->addItem("3", "2'b11", "Nominal bias current (25uA)");
  a_FCSI_TPCMIXER_ctl_tpc_ibias_0_0->addItem("2", "2'b10", "+10%");
  a_FCSI_TPCMIXER_ctl_tpc_ibias_0_0->addItem("1", "2'b01", "-10%");
  a_FCSI_TPCMIXER_ctl_tpc_ibias_0_0->addItem("0", "2'b00", "Nominal bias current (25uA)");
  f_FCSI_TPCMIXER_ctl_tpc_ibias->connectAttribute (a_FCSI_TPCMIXER_ctl_tpc_ibias_0_0);

  RField* f_FCSI_TPCMIXER_disable_rxon_control = new RField;
  f_FCSI_TPCMIXER_disable_rxon_control->setInstName ("disable_rxon_control");
  f_FCSI_TPCMIXER_disable_rxon_control->setLongName ("DISABLE RXON CONTROL");
  f_FCSI_TPCMIXER_disable_rxon_control->setDescription ("Disable rx_on control of the TX MIXER");
  f_FCSI_TPCMIXER_disable_rxon_control->setDataWidth (1);
  f_FCSI_TPCMIXER_disable_rxon_control->setResetVal ("1'b0");
  f_FCSI_TPCMIXER_disable_rxon_control->setAccProp (AccProp::RW);
  r_FCSI_TPCMIXER->connectRField (f_FCSI_TPCMIXER_disable_rxon_control, 11);

  Attribute* a_FCSI_TPCMIXER_disable_rxon_control_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCMIXER_disable_rxon_control_0_0->setInstName ("0");
  a_FCSI_TPCMIXER_disable_rxon_control_0_0->setLongName ("");
  a_FCSI_TPCMIXER_disable_rxon_control_0_0->setDescription ("");
  a_FCSI_TPCMIXER_disable_rxon_control_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TPCMIXER_disable_rxon_control_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TPCMIXER_disable_rxon_control->connectAttribute (a_FCSI_TPCMIXER_disable_rxon_control_0_0);

  RField* f_FCSI_TPCMIXER_ctl_vc_bias_pad = new RField;
  f_FCSI_TPCMIXER_ctl_vc_bias_pad->setInstName ("ctl_vc_bias_pad");
  f_FCSI_TPCMIXER_ctl_vc_bias_pad->setLongName ("CTL_VC_BIAS_PAD");
  f_FCSI_TPCMIXER_ctl_vc_bias_pad->setDescription ("Control cascode buffer bias of PADRIVER");
  f_FCSI_TPCMIXER_ctl_vc_bias_pad->setDataWidth (2);
  f_FCSI_TPCMIXER_ctl_vc_bias_pad->setResetVal ("2'b00");
  f_FCSI_TPCMIXER_ctl_vc_bias_pad->setAccProp (AccProp::RW);
  r_FCSI_TPCMIXER->connectRField (f_FCSI_TPCMIXER_ctl_vc_bias_pad, 12);

  Attribute* a_FCSI_TPCMIXER_ctl_vc_bias_pad_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCMIXER_ctl_vc_bias_pad_0_0->setInstName ("0");
  a_FCSI_TPCMIXER_ctl_vc_bias_pad_0_0->setLongName ("");
  a_FCSI_TPCMIXER_ctl_vc_bias_pad_0_0->setDescription ("");
  a_FCSI_TPCMIXER_ctl_vc_bias_pad_0_0->addItem("0", "2'b00", "100%");
  a_FCSI_TPCMIXER_ctl_vc_bias_pad_0_0->addItem("1", "2'b01", "200%");
  a_FCSI_TPCMIXER_ctl_vc_bias_pad_0_0->addItem("2", "2'b10", "300%");
  a_FCSI_TPCMIXER_ctl_vc_bias_pad_0_0->addItem("3", "2'b11", "400%");
  f_FCSI_TPCMIXER_ctl_vc_bias_pad->connectAttribute (a_FCSI_TPCMIXER_ctl_vc_bias_pad_0_0);

  RField* f_FCSI_TPCMIXER_enable_act_mirror = new RField;
  f_FCSI_TPCMIXER_enable_act_mirror->setInstName ("enable_act_mirror");
  f_FCSI_TPCMIXER_enable_act_mirror->setLongName ("ENABLE ACT MIRROR");
  f_FCSI_TPCMIXER_enable_act_mirror->setDescription ("Enable act mirror of PADRIVER (for HB only)");
  f_FCSI_TPCMIXER_enable_act_mirror->setDataWidth (1);
  f_FCSI_TPCMIXER_enable_act_mirror->setResetVal ("1'b0");
  f_FCSI_TPCMIXER_enable_act_mirror->setAccProp (AccProp::RW);
  r_FCSI_TPCMIXER->connectRField (f_FCSI_TPCMIXER_enable_act_mirror, 14);

  Attribute* a_FCSI_TPCMIXER_enable_act_mirror_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCMIXER_enable_act_mirror_0_0->setInstName ("0");
  a_FCSI_TPCMIXER_enable_act_mirror_0_0->setLongName ("");
  a_FCSI_TPCMIXER_enable_act_mirror_0_0->setDescription ("");
  a_FCSI_TPCMIXER_enable_act_mirror_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TPCMIXER_enable_act_mirror_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TPCMIXER_enable_act_mirror->connectAttribute (a_FCSI_TPCMIXER_enable_act_mirror_0_0);

  RField* f_FCSI_TPCMIXER_enable_vc_bias = new RField;
  f_FCSI_TPCMIXER_enable_vc_bias->setInstName ("enable_vc_bias");
  f_FCSI_TPCMIXER_enable_vc_bias->setLongName ("ENABLE VC BIAS");
  f_FCSI_TPCMIXER_enable_vc_bias->setDescription ("Enable vc biasing of PADRIVER (for HB only)");
  f_FCSI_TPCMIXER_enable_vc_bias->setDataWidth (1);
  f_FCSI_TPCMIXER_enable_vc_bias->setResetVal ("1'b0");
  f_FCSI_TPCMIXER_enable_vc_bias->setAccProp (AccProp::RW);
  r_FCSI_TPCMIXER->connectRField (f_FCSI_TPCMIXER_enable_vc_bias, 15);

  Attribute* a_FCSI_TPCMIXER_enable_vc_bias_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCMIXER_enable_vc_bias_0_0->setInstName ("0");
  a_FCSI_TPCMIXER_enable_vc_bias_0_0->setLongName ("");
  a_FCSI_TPCMIXER_enable_vc_bias_0_0->setDescription ("");
  a_FCSI_TPCMIXER_enable_vc_bias_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_TPCMIXER_enable_vc_bias_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_TPCMIXER_enable_vc_bias->connectAttribute (a_FCSI_TPCMIXER_enable_vc_bias_0_0);

  Register* r_FCSI_TPCFILTER0 = new Register;
  r_FCSI_TPCFILTER0->setInstName ("TPCFILTER0");
  r_FCSI_TPCFILTER0->setLongName ("TPC FILTER TUN0 (HB/LB)");
  r_FCSI_TPCFILTER0->setDescription ("BB-LDO1V2");
  r_FCSI_TPCFILTER0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TPCFILTER0, 0x00000013);

  RField* f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz = new RField;
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz->setInstName ("ctl_tpc_fb_csel_20MHz");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz->setLongName ("CTL TPC FB CSEL 20MHz");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz->setDescription ("Control TPC feedback capacitor (binary coded) 20MHz BW");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz->setDataWidth (7);
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz->setResetVal ("7'b0000000");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz->setAccProp (AccProp::RW);
  r_FCSI_TPCFILTER0->connectRField (f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz, 0);

  Attribute* a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz_0_0->setInstName ("0");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz_0_0->setLongName ("");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz_0_0->setDescription ("");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz_0_0->addItem("0", "7'b0000000", "3.175pF (default)");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz_0_0->addItem("1", "7'b0000001", "3.150pF ");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz_0_0->addItem("126", "7'b1111110", "25fF");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz_0_0->addItem("127", "7'b1111111", "0");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz->connectAttribute (a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_20MHz_0_0);

  RField* f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz = new RField;
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz->setInstName ("ctl_tpc_fb_csel_40MHz");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz->setLongName ("CTL TPC FB CSEL 40MHz");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz->setDescription ("Control TPC feedback capacitor (binary coded) 40MHz BW");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz->setDataWidth (7);
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz->setResetVal ("7'b0000000");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz->setAccProp (AccProp::RW);
  r_FCSI_TPCFILTER0->connectRField (f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz, 7);

  Attribute* a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz_0_0->setInstName ("0");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz_0_0->setLongName ("");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz_0_0->setDescription ("");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz_0_0->addItem("0", "7'b0000000", "3.175pF");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz_0_0->addItem("45", "7'b0101101", "2.05pF (default)");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz_0_0->addItem("126", "7'b1111110", "25fF");
  a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz_0_0->addItem("127", "7'b1111111", "0");
  f_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz->connectAttribute (a_FCSI_TPCFILTER0_ctl_tpc_fb_csel_40MHz_0_0);

  Register* r_FCSI_TPCFILTER1 = new Register;
  r_FCSI_TPCFILTER1->setInstName ("TPCFILTER1");
  r_FCSI_TPCFILTER1->setLongName ("TPC FILTER TUN1 (HB/LB)");
  r_FCSI_TPCFILTER1->setDescription ("BB-LDO1V2");
  r_FCSI_TPCFILTER1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TPCFILTER1, 0x00000014);

  RField* f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz = new RField;
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz->setInstName ("ctl_tpc_fb_csel_80MHz");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz->setLongName ("CTL TPC FB CSEL 80MHz");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz->setDescription ("Control TPC feedback capacitor (binary coded) 80MHz BW");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz->setDataWidth (7);
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz->setResetVal ("7'b0000000");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz->setAccProp (AccProp::RW);
  r_FCSI_TPCFILTER1->connectRField (f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz, 0);

  Attribute* a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz_0_0->setInstName ("0");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz_0_0->setLongName ("");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz_0_0->setDescription ("");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz_0_0->addItem("0", "7'b0000000", "3.175pF");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz_0_0->addItem("84", "7'b1010100", "1.075pF (default)");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz_0_0->addItem("126", "7'b1111110", "25fF");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz_0_0->addItem("127", "7'b1111111", "0");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz->connectAttribute (a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_80MHz_0_0);

  RField* f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz = new RField;
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz->setInstName ("ctl_tpc_fb_csel_160MHz");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz->setLongName ("CTL TPC FB CSEL 160MHz");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz->setDescription ("Control TPC feedback capacitor (binary coded) 160MHz BW");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz->setDataWidth (7);
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz->setResetVal ("7'b0000000");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz->setAccProp (AccProp::RW);
  r_FCSI_TPCFILTER1->connectRField (f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz, 7);

  Attribute* a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz_0_0->setInstName ("0");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz_0_0->setLongName ("");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz_0_0->setDescription ("");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz_0_0->addItem("0", "7'b0000000", "3.175pF");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz_0_0->addItem("101", "7'b1100101", "0.65pF (default)");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz_0_0->addItem("126", "7'b1111110", "25fF");
  a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz_0_0->addItem("127", "7'b1111111", "0");
  f_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz->connectAttribute (a_FCSI_TPCFILTER1_ctl_tpc_fb_csel_160MHz_0_0);

  Register* r_FCSI_TPCGAIN = new Register;
  r_FCSI_TPCGAIN->setInstName ("TPCGAIN");
  r_FCSI_TPCGAIN->setLongName ("TPC GAIN CONTROL");
  r_FCSI_TPCGAIN->setDescription ("BB-LDO1V2");
  r_FCSI_TPCGAIN->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TPCGAIN, 0x00000015);

  RField* f_FCSI_TPCGAIN_ctl_tpc_gain0 = new RField;
  f_FCSI_TPCGAIN_ctl_tpc_gain0->setInstName ("ctl_tpc_gain0");
  f_FCSI_TPCGAIN_ctl_tpc_gain0->setLongName ("CTL TPC GAIN0");
  f_FCSI_TPCGAIN_ctl_tpc_gain0->setDescription ("Control TPC gain0");
  f_FCSI_TPCGAIN_ctl_tpc_gain0->setDataWidth (3);
  f_FCSI_TPCGAIN_ctl_tpc_gain0->setResetVal ("3'b000");
  f_FCSI_TPCGAIN_ctl_tpc_gain0->setAccProp (AccProp::RW);
  r_FCSI_TPCGAIN->connectRField (f_FCSI_TPCGAIN_ctl_tpc_gain0, 0);

  Attribute* a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->setInstName ("0");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->setLongName ("");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->setDescription ("");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->addItem("0", "3'b000", "-6dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->addItem("1", "3'b001", "-4dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->addItem("2", "3'b010", "-2dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->addItem("3", "3'b011", "0dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->addItem("4", "3'b100", "2dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->addItem("5", "3'b101", "4dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->addItem("6", "3'b110", "6dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0->addItem("7", "3'b111", "N.A.");
  f_FCSI_TPCGAIN_ctl_tpc_gain0->connectAttribute (a_FCSI_TPCGAIN_ctl_tpc_gain0_0_0);

  RField* f_FCSI_TPCGAIN_ctl_tpc_gain1 = new RField;
  f_FCSI_TPCGAIN_ctl_tpc_gain1->setInstName ("ctl_tpc_gain1");
  f_FCSI_TPCGAIN_ctl_tpc_gain1->setLongName ("CTL TPC GAIN1");
  f_FCSI_TPCGAIN_ctl_tpc_gain1->setDescription ("Control TPC gain1");
  f_FCSI_TPCGAIN_ctl_tpc_gain1->setDataWidth (3);
  f_FCSI_TPCGAIN_ctl_tpc_gain1->setResetVal ("3'b000");
  f_FCSI_TPCGAIN_ctl_tpc_gain1->setAccProp (AccProp::RW);
  r_FCSI_TPCGAIN->connectRField (f_FCSI_TPCGAIN_ctl_tpc_gain1, 3);

  Attribute* a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->setInstName ("0");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->setLongName ("");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->setDescription ("");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->addItem("0", "3'b000", "-6dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->addItem("1", "3'b001", "-4dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->addItem("2", "3'b010", "-2dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->addItem("3", "3'b011", "0dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->addItem("4", "3'b100", "2dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->addItem("5", "3'b101", "4dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->addItem("6", "3'b110", "6dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0->addItem("7", "3'b111", "N.A.");
  f_FCSI_TPCGAIN_ctl_tpc_gain1->connectAttribute (a_FCSI_TPCGAIN_ctl_tpc_gain1_0_0);

  RField* f_FCSI_TPCGAIN_ctl_tpc_gain2 = new RField;
  f_FCSI_TPCGAIN_ctl_tpc_gain2->setInstName ("ctl_tpc_gain2");
  f_FCSI_TPCGAIN_ctl_tpc_gain2->setLongName ("CTL TPC GAIN2");
  f_FCSI_TPCGAIN_ctl_tpc_gain2->setDescription ("Control TPC gain2");
  f_FCSI_TPCGAIN_ctl_tpc_gain2->setDataWidth (3);
  f_FCSI_TPCGAIN_ctl_tpc_gain2->setResetVal ("3'b000");
  f_FCSI_TPCGAIN_ctl_tpc_gain2->setAccProp (AccProp::RW);
  r_FCSI_TPCGAIN->connectRField (f_FCSI_TPCGAIN_ctl_tpc_gain2, 6);

  Attribute* a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->setInstName ("0");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->setLongName ("");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->setDescription ("");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->addItem("0", "3'b000", "-6dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->addItem("1", "3'b001", "-4dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->addItem("2", "3'b010", "-2dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->addItem("3", "3'b011", "0dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->addItem("4", "3'b100", "2dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->addItem("5", "3'b101", "4dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->addItem("6", "3'b110", "6dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0->addItem("7", "3'b111", "N.A.");
  f_FCSI_TPCGAIN_ctl_tpc_gain2->connectAttribute (a_FCSI_TPCGAIN_ctl_tpc_gain2_0_0);

  RField* f_FCSI_TPCGAIN_ctl_tpc_gain3 = new RField;
  f_FCSI_TPCGAIN_ctl_tpc_gain3->setInstName ("ctl_tpc_gain3");
  f_FCSI_TPCGAIN_ctl_tpc_gain3->setLongName ("CTL TPC GAIN3");
  f_FCSI_TPCGAIN_ctl_tpc_gain3->setDescription ("Control TPC gain3");
  f_FCSI_TPCGAIN_ctl_tpc_gain3->setDataWidth (3);
  f_FCSI_TPCGAIN_ctl_tpc_gain3->setResetVal ("3'b000");
  f_FCSI_TPCGAIN_ctl_tpc_gain3->setAccProp (AccProp::RW);
  r_FCSI_TPCGAIN->connectRField (f_FCSI_TPCGAIN_ctl_tpc_gain3, 9);

  Attribute* a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->setInstName ("0");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->setLongName ("");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->setDescription ("");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->addItem("0", "3'b000", "-6dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->addItem("1", "3'b001", "-4dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->addItem("2", "3'b010", "-2dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->addItem("3", "3'b011", "0dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->addItem("4", "3'b100", "2dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->addItem("5", "3'b101", "4dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->addItem("6", "3'b110", "6dB");
  a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0->addItem("7", "3'b111", "N.A.");
  f_FCSI_TPCGAIN_ctl_tpc_gain3->connectAttribute (a_FCSI_TPCGAIN_ctl_tpc_gain3_0_0);

  Register* r_FCSI_TPCOFF01 = new Register;
  r_FCSI_TPCOFF01->setInstName ("TPCOFF01");
  r_FCSI_TPCOFF01->setLongName ("TPC OFFSET01 (HB/LB)");
  r_FCSI_TPCOFF01->setDescription ("BB-LDO1V2");
  r_FCSI_TPCOFF01->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TPCOFF01, 0x00000016);

  RField* f_FCSI_TPCOFF01_i_gain0 = new RField;
  f_FCSI_TPCOFF01_i_gain0->setInstName ("i_gain0");
  f_FCSI_TPCOFF01_i_gain0->setLongName ("I GAIN0");
  f_FCSI_TPCOFF01_i_gain0->setDescription ("TX DC offset for gain0 I-path (2's complement with 0.8mV step)");
  f_FCSI_TPCOFF01_i_gain0->setDataWidth (4);
  f_FCSI_TPCOFF01_i_gain0->setResetVal ("4'b0000");
  f_FCSI_TPCOFF01_i_gain0->setAccProp (AccProp::RW);
  r_FCSI_TPCOFF01->connectRField (f_FCSI_TPCOFF01_i_gain0, 0);

  Attribute* a_FCSI_TPCOFF01_i_gain0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCOFF01_i_gain0_0_0->setInstName ("0");
  a_FCSI_TPCOFF01_i_gain0_0_0->setLongName ("");
  a_FCSI_TPCOFF01_i_gain0_0_0->setDescription ("");
  a_FCSI_TPCOFF01_i_gain0_0_0->addItem("7", "4'b0111", "6mV");
  a_FCSI_TPCOFF01_i_gain0_0_0->addItem("8", "4'b1000", "-6mV");
  a_FCSI_TPCOFF01_i_gain0_0_0->addItem("0", "4'b0000", "0.4mV");
  a_FCSI_TPCOFF01_i_gain0_0_0->addItem("15", "4'b1111", "-0.4mV");
  f_FCSI_TPCOFF01_i_gain0->connectAttribute (a_FCSI_TPCOFF01_i_gain0_0_0);

  RField* f_FCSI_TPCOFF01_q_gain0 = new RField;
  f_FCSI_TPCOFF01_q_gain0->setInstName ("q_gain0");
  f_FCSI_TPCOFF01_q_gain0->setLongName ("Q GAIN0");
  f_FCSI_TPCOFF01_q_gain0->setDescription ("TX DC offset for gain0 Q-path (2's complement with 0.8mV step)");
  f_FCSI_TPCOFF01_q_gain0->setDataWidth (4);
  f_FCSI_TPCOFF01_q_gain0->setResetVal ("4'b0000");
  f_FCSI_TPCOFF01_q_gain0->setAccProp (AccProp::RW);
  r_FCSI_TPCOFF01->connectRField (f_FCSI_TPCOFF01_q_gain0, 4);

  Attribute* a_FCSI_TPCOFF01_q_gain0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCOFF01_q_gain0_0_0->setInstName ("0");
  a_FCSI_TPCOFF01_q_gain0_0_0->setLongName ("");
  a_FCSI_TPCOFF01_q_gain0_0_0->setDescription ("");
  a_FCSI_TPCOFF01_q_gain0_0_0->addItem("7", "4'b0111", "6mV");
  a_FCSI_TPCOFF01_q_gain0_0_0->addItem("8", "4'b1000", "-6mV");
  a_FCSI_TPCOFF01_q_gain0_0_0->addItem("0", "4'b0000", "0.4mV");
  a_FCSI_TPCOFF01_q_gain0_0_0->addItem("15", "4'b1111", "-0.4mV");
  f_FCSI_TPCOFF01_q_gain0->connectAttribute (a_FCSI_TPCOFF01_q_gain0_0_0);

  RField* f_FCSI_TPCOFF01_i_gain1 = new RField;
  f_FCSI_TPCOFF01_i_gain1->setInstName ("i_gain1");
  f_FCSI_TPCOFF01_i_gain1->setLongName ("I GAIN1");
  f_FCSI_TPCOFF01_i_gain1->setDescription ("TX DC offset for gain1 I-path (2's complement with 0.8mV step)");
  f_FCSI_TPCOFF01_i_gain1->setDataWidth (4);
  f_FCSI_TPCOFF01_i_gain1->setResetVal ("4'b0000");
  f_FCSI_TPCOFF01_i_gain1->setAccProp (AccProp::RW);
  r_FCSI_TPCOFF01->connectRField (f_FCSI_TPCOFF01_i_gain1, 8);

  Attribute* a_FCSI_TPCOFF01_i_gain1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCOFF01_i_gain1_0_0->setInstName ("0");
  a_FCSI_TPCOFF01_i_gain1_0_0->setLongName ("");
  a_FCSI_TPCOFF01_i_gain1_0_0->setDescription ("");
  a_FCSI_TPCOFF01_i_gain1_0_0->addItem("7", "4'b0111", "6mV");
  a_FCSI_TPCOFF01_i_gain1_0_0->addItem("8", "4'b1000", "-6mV");
  a_FCSI_TPCOFF01_i_gain1_0_0->addItem("0", "4'b0000", "0.4mV");
  a_FCSI_TPCOFF01_i_gain1_0_0->addItem("15", "4'b1111", "-0.4mV");
  f_FCSI_TPCOFF01_i_gain1->connectAttribute (a_FCSI_TPCOFF01_i_gain1_0_0);

  RField* f_FCSI_TPCOFF01_q_gain1 = new RField;
  f_FCSI_TPCOFF01_q_gain1->setInstName ("q_gain1");
  f_FCSI_TPCOFF01_q_gain1->setLongName ("Q GAIN1");
  f_FCSI_TPCOFF01_q_gain1->setDescription ("TX DC offset for gain1 Q-path (2's complement with 0.8mV step)");
  f_FCSI_TPCOFF01_q_gain1->setDataWidth (4);
  f_FCSI_TPCOFF01_q_gain1->setResetVal ("4'b0000");
  f_FCSI_TPCOFF01_q_gain1->setAccProp (AccProp::RW);
  r_FCSI_TPCOFF01->connectRField (f_FCSI_TPCOFF01_q_gain1, 12);

  Attribute* a_FCSI_TPCOFF01_q_gain1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCOFF01_q_gain1_0_0->setInstName ("0");
  a_FCSI_TPCOFF01_q_gain1_0_0->setLongName ("");
  a_FCSI_TPCOFF01_q_gain1_0_0->setDescription ("");
  a_FCSI_TPCOFF01_q_gain1_0_0->addItem("7", "4'b0111", "6mV");
  a_FCSI_TPCOFF01_q_gain1_0_0->addItem("8", "4'b1000", "-6mV");
  a_FCSI_TPCOFF01_q_gain1_0_0->addItem("0", "4'b0000", "0.4mV");
  a_FCSI_TPCOFF01_q_gain1_0_0->addItem("15", "4'b1111", "-0.4mV");
  f_FCSI_TPCOFF01_q_gain1->connectAttribute (a_FCSI_TPCOFF01_q_gain1_0_0);

  Register* r_FCSI_TPCOFF23 = new Register;
  r_FCSI_TPCOFF23->setInstName ("TPCOFF23");
  r_FCSI_TPCOFF23->setLongName ("TPC OFFSET23 (HB/LB)");
  r_FCSI_TPCOFF23->setDescription ("BB-LDO1V2");
  r_FCSI_TPCOFF23->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TPCOFF23, 0x00000017);

  RField* f_FCSI_TPCOFF23_i_gain2 = new RField;
  f_FCSI_TPCOFF23_i_gain2->setInstName ("i_gain2");
  f_FCSI_TPCOFF23_i_gain2->setLongName ("I GAIN2");
  f_FCSI_TPCOFF23_i_gain2->setDescription ("TX DC offset for gain2 I-path (2's complement with 0.8mV step)");
  f_FCSI_TPCOFF23_i_gain2->setDataWidth (4);
  f_FCSI_TPCOFF23_i_gain2->setResetVal ("4'b0000");
  f_FCSI_TPCOFF23_i_gain2->setAccProp (AccProp::RW);
  r_FCSI_TPCOFF23->connectRField (f_FCSI_TPCOFF23_i_gain2, 0);

  Attribute* a_FCSI_TPCOFF23_i_gain2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCOFF23_i_gain2_0_0->setInstName ("0");
  a_FCSI_TPCOFF23_i_gain2_0_0->setLongName ("");
  a_FCSI_TPCOFF23_i_gain2_0_0->setDescription ("");
  a_FCSI_TPCOFF23_i_gain2_0_0->addItem("7", "4'b0111", "6mV");
  a_FCSI_TPCOFF23_i_gain2_0_0->addItem("8", "4'b1000", "-6mV");
  a_FCSI_TPCOFF23_i_gain2_0_0->addItem("0", "4'b0000", "0.4mV");
  a_FCSI_TPCOFF23_i_gain2_0_0->addItem("15", "4'b1111", "-0.4mV");
  f_FCSI_TPCOFF23_i_gain2->connectAttribute (a_FCSI_TPCOFF23_i_gain2_0_0);

  RField* f_FCSI_TPCOFF23_q_gain2 = new RField;
  f_FCSI_TPCOFF23_q_gain2->setInstName ("q_gain2");
  f_FCSI_TPCOFF23_q_gain2->setLongName ("Q GAIN2");
  f_FCSI_TPCOFF23_q_gain2->setDescription ("TX DC offset for gain2 Q-path (2's complement with 0.8mV step)");
  f_FCSI_TPCOFF23_q_gain2->setDataWidth (4);
  f_FCSI_TPCOFF23_q_gain2->setResetVal ("4'b0000");
  f_FCSI_TPCOFF23_q_gain2->setAccProp (AccProp::RW);
  r_FCSI_TPCOFF23->connectRField (f_FCSI_TPCOFF23_q_gain2, 4);

  Attribute* a_FCSI_TPCOFF23_q_gain2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCOFF23_q_gain2_0_0->setInstName ("0");
  a_FCSI_TPCOFF23_q_gain2_0_0->setLongName ("");
  a_FCSI_TPCOFF23_q_gain2_0_0->setDescription ("");
  a_FCSI_TPCOFF23_q_gain2_0_0->addItem("7", "4'b0111", "6mV");
  a_FCSI_TPCOFF23_q_gain2_0_0->addItem("8", "4'b1000", "-6mV");
  a_FCSI_TPCOFF23_q_gain2_0_0->addItem("0", "4'b0000", "0.4mV");
  a_FCSI_TPCOFF23_q_gain2_0_0->addItem("15", "4'b1111", "-0.4mV");
  f_FCSI_TPCOFF23_q_gain2->connectAttribute (a_FCSI_TPCOFF23_q_gain2_0_0);

  RField* f_FCSI_TPCOFF23_i_gain3 = new RField;
  f_FCSI_TPCOFF23_i_gain3->setInstName ("i_gain3");
  f_FCSI_TPCOFF23_i_gain3->setLongName ("I GAIN3");
  f_FCSI_TPCOFF23_i_gain3->setDescription ("TX DC offset for gain3 I-path (2's complement with 0.8mV step)");
  f_FCSI_TPCOFF23_i_gain3->setDataWidth (4);
  f_FCSI_TPCOFF23_i_gain3->setResetVal ("4'b0000");
  f_FCSI_TPCOFF23_i_gain3->setAccProp (AccProp::RW);
  r_FCSI_TPCOFF23->connectRField (f_FCSI_TPCOFF23_i_gain3, 8);

  Attribute* a_FCSI_TPCOFF23_i_gain3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCOFF23_i_gain3_0_0->setInstName ("0");
  a_FCSI_TPCOFF23_i_gain3_0_0->setLongName ("");
  a_FCSI_TPCOFF23_i_gain3_0_0->setDescription ("");
  a_FCSI_TPCOFF23_i_gain3_0_0->addItem("7", "4'b0111", "6mV");
  a_FCSI_TPCOFF23_i_gain3_0_0->addItem("8", "4'b1000", "-6mV");
  a_FCSI_TPCOFF23_i_gain3_0_0->addItem("0", "4'b0000", "0.4mV");
  a_FCSI_TPCOFF23_i_gain3_0_0->addItem("15", "4'b1111", "-0.4mV");
  f_FCSI_TPCOFF23_i_gain3->connectAttribute (a_FCSI_TPCOFF23_i_gain3_0_0);

  RField* f_FCSI_TPCOFF23_q_gain3 = new RField;
  f_FCSI_TPCOFF23_q_gain3->setInstName ("q_gain3");
  f_FCSI_TPCOFF23_q_gain3->setLongName ("Q GAIN3");
  f_FCSI_TPCOFF23_q_gain3->setDescription ("TX DC offset for gain3 Q-path (2's complement with 0.8mV step)");
  f_FCSI_TPCOFF23_q_gain3->setDataWidth (4);
  f_FCSI_TPCOFF23_q_gain3->setResetVal ("4'b0000");
  f_FCSI_TPCOFF23_q_gain3->setAccProp (AccProp::RW);
  r_FCSI_TPCOFF23->connectRField (f_FCSI_TPCOFF23_q_gain3, 12);

  Attribute* a_FCSI_TPCOFF23_q_gain3_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TPCOFF23_q_gain3_0_0->setInstName ("0");
  a_FCSI_TPCOFF23_q_gain3_0_0->setLongName ("");
  a_FCSI_TPCOFF23_q_gain3_0_0->setDescription ("");
  a_FCSI_TPCOFF23_q_gain3_0_0->addItem("7", "4'b0111", "6mV");
  a_FCSI_TPCOFF23_q_gain3_0_0->addItem("8", "4'b1000", "-6mV");
  a_FCSI_TPCOFF23_q_gain3_0_0->addItem("0", "4'b0000", "0.4mV");
  a_FCSI_TPCOFF23_q_gain3_0_0->addItem("15", "4'b1111", "-0.4mV");
  f_FCSI_TPCOFF23_q_gain3->connectAttribute (a_FCSI_TPCOFF23_q_gain3_0_0);

  Register* r_FCSI_LNARSSI = new Register;
  r_FCSI_LNARSSI->setInstName ("LNARSSI");
  r_FCSI_LNARSSI->setLongName ("LNA RSSI (HB/LB)");
  r_FCSI_LNARSSI->setDescription ("BB-LDO1V2");
  r_FCSI_LNARSSI->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_LNARSSI, 0x00000018);

  RField* f_FCSI_LNARSSI_enable_rssi = new RField;
  f_FCSI_LNARSSI_enable_rssi->setInstName ("enable_rssi");
  f_FCSI_LNARSSI_enable_rssi->setLongName ("ENABLE RSSI");
  f_FCSI_LNARSSI_enable_rssi->setDescription ("Enable RSSI");
  f_FCSI_LNARSSI_enable_rssi->setDataWidth (1);
  f_FCSI_LNARSSI_enable_rssi->setResetVal ("1'b0");
  f_FCSI_LNARSSI_enable_rssi->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_enable_rssi, 0);

  Attribute* a_FCSI_LNARSSI_enable_rssi_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_enable_rssi_0_0->setInstName ("0");
  a_FCSI_LNARSSI_enable_rssi_0_0->setLongName ("");
  a_FCSI_LNARSSI_enable_rssi_0_0->setDescription ("");
  a_FCSI_LNARSSI_enable_rssi_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LNARSSI_enable_rssi_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LNARSSI_enable_rssi->connectAttribute (a_FCSI_LNARSSI_enable_rssi_0_0);

  RField* f_FCSI_LNARSSI_ctl_stby_rssi = new RField;
  f_FCSI_LNARSSI_ctl_stby_rssi->setInstName ("ctl_stby_rssi");
  f_FCSI_LNARSSI_ctl_stby_rssi->setLongName ("CTL STBY RSSI");
  f_FCSI_LNARSSI_ctl_stby_rssi->setDescription ("Control standby of RSSI");
  f_FCSI_LNARSSI_ctl_stby_rssi->setDataWidth (1);
  f_FCSI_LNARSSI_ctl_stby_rssi->setResetVal ("1'b0");
  f_FCSI_LNARSSI_ctl_stby_rssi->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_ctl_stby_rssi, 1);

  Attribute* a_FCSI_LNARSSI_ctl_stby_rssi_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_ctl_stby_rssi_0_0->setInstName ("0");
  a_FCSI_LNARSSI_ctl_stby_rssi_0_0->setLongName ("");
  a_FCSI_LNARSSI_ctl_stby_rssi_0_0->setDescription ("");
  a_FCSI_LNARSSI_ctl_stby_rssi_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LNARSSI_ctl_stby_rssi_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LNARSSI_ctl_stby_rssi->connectAttribute (a_FCSI_LNARSSI_ctl_stby_rssi_0_0);

  RField* f_FCSI_LNARSSI_stby_rssi = new RField;
  f_FCSI_LNARSSI_stby_rssi->setInstName ("stby_rssi");
  f_FCSI_LNARSSI_stby_rssi->setLongName ("STBY RSSI");
  f_FCSI_LNARSSI_stby_rssi->setDescription ("Control manual standby of RSSI");
  f_FCSI_LNARSSI_stby_rssi->setDataWidth (1);
  f_FCSI_LNARSSI_stby_rssi->setResetVal ("1'b0");
  f_FCSI_LNARSSI_stby_rssi->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_stby_rssi, 2);

  Attribute* a_FCSI_LNARSSI_stby_rssi_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_stby_rssi_0_0->setInstName ("0");
  a_FCSI_LNARSSI_stby_rssi_0_0->setLongName ("");
  a_FCSI_LNARSSI_stby_rssi_0_0->setDescription ("");
  a_FCSI_LNARSSI_stby_rssi_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LNARSSI_stby_rssi_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LNARSSI_stby_rssi->connectAttribute (a_FCSI_LNARSSI_stby_rssi_0_0);

  RField* f_FCSI_LNARSSI_enable_lna = new RField;
  f_FCSI_LNARSSI_enable_lna->setInstName ("enable_lna");
  f_FCSI_LNARSSI_enable_lna->setLongName ("ENABLE LNA");
  f_FCSI_LNARSSI_enable_lna->setDescription ("Enable LNA");
  f_FCSI_LNARSSI_enable_lna->setDataWidth (1);
  f_FCSI_LNARSSI_enable_lna->setResetVal ("1'b0");
  f_FCSI_LNARSSI_enable_lna->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_enable_lna, 3);

  Attribute* a_FCSI_LNARSSI_enable_lna_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_enable_lna_0_0->setInstName ("0");
  a_FCSI_LNARSSI_enable_lna_0_0->setLongName ("");
  a_FCSI_LNARSSI_enable_lna_0_0->setDescription ("");
  a_FCSI_LNARSSI_enable_lna_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LNARSSI_enable_lna_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LNARSSI_enable_lna->connectAttribute (a_FCSI_LNARSSI_enable_lna_0_0);

  RField* f_FCSI_LNARSSI_ctl_stby_lna = new RField;
  f_FCSI_LNARSSI_ctl_stby_lna->setInstName ("ctl_stby_lna");
  f_FCSI_LNARSSI_ctl_stby_lna->setLongName ("CTL STBY LNA");
  f_FCSI_LNARSSI_ctl_stby_lna->setDescription ("Control standby of LNA");
  f_FCSI_LNARSSI_ctl_stby_lna->setDataWidth (1);
  f_FCSI_LNARSSI_ctl_stby_lna->setResetVal ("1'b0");
  f_FCSI_LNARSSI_ctl_stby_lna->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_ctl_stby_lna, 4);

  Attribute* a_FCSI_LNARSSI_ctl_stby_lna_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_ctl_stby_lna_0_0->setInstName ("0");
  a_FCSI_LNARSSI_ctl_stby_lna_0_0->setLongName ("");
  a_FCSI_LNARSSI_ctl_stby_lna_0_0->setDescription ("");
  a_FCSI_LNARSSI_ctl_stby_lna_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LNARSSI_ctl_stby_lna_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LNARSSI_ctl_stby_lna->connectAttribute (a_FCSI_LNARSSI_ctl_stby_lna_0_0);

  RField* f_FCSI_LNARSSI_stby_lna = new RField;
  f_FCSI_LNARSSI_stby_lna->setInstName ("stby_lna");
  f_FCSI_LNARSSI_stby_lna->setLongName ("STBY LNA");
  f_FCSI_LNARSSI_stby_lna->setDescription ("Control manual standby of LNA");
  f_FCSI_LNARSSI_stby_lna->setDataWidth (1);
  f_FCSI_LNARSSI_stby_lna->setResetVal ("1'b0");
  f_FCSI_LNARSSI_stby_lna->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_stby_lna, 5);

  Attribute* a_FCSI_LNARSSI_stby_lna_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_stby_lna_0_0->setInstName ("0");
  a_FCSI_LNARSSI_stby_lna_0_0->setLongName ("");
  a_FCSI_LNARSSI_stby_lna_0_0->setDescription ("");
  a_FCSI_LNARSSI_stby_lna_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LNARSSI_stby_lna_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LNARSSI_stby_lna->connectAttribute (a_FCSI_LNARSSI_stby_lna_0_0);

  RField* f_FCSI_LNARSSI_en_lna_noise = new RField;
  f_FCSI_LNARSSI_en_lna_noise->setInstName ("en_lna_noise");
  f_FCSI_LNARSSI_en_lna_noise->setLongName ("ENABLE LNA NOISE");
  f_FCSI_LNARSSI_en_lna_noise->setDescription ("Enable LNA noise source");
  f_FCSI_LNARSSI_en_lna_noise->setDataWidth (1);
  f_FCSI_LNARSSI_en_lna_noise->setResetVal ("1'b0");
  f_FCSI_LNARSSI_en_lna_noise->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_en_lna_noise, 6);

  Attribute* a_FCSI_LNARSSI_en_lna_noise_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_en_lna_noise_0_0->setInstName ("0");
  a_FCSI_LNARSSI_en_lna_noise_0_0->setLongName ("");
  a_FCSI_LNARSSI_en_lna_noise_0_0->setDescription ("");
  a_FCSI_LNARSSI_en_lna_noise_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LNARSSI_en_lna_noise_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LNARSSI_en_lna_noise->connectAttribute (a_FCSI_LNARSSI_en_lna_noise_0_0);

  RField* f_FCSI_LNARSSI_en_lna_clamp = new RField;
  f_FCSI_LNARSSI_en_lna_clamp->setInstName ("en_lna_clamp");
  f_FCSI_LNARSSI_en_lna_clamp->setLongName ("ENABLE LNA NOISE");
  f_FCSI_LNARSSI_en_lna_clamp->setDescription ("Enable LNA input clamp");
  f_FCSI_LNARSSI_en_lna_clamp->setDataWidth (1);
  f_FCSI_LNARSSI_en_lna_clamp->setResetVal ("1'b0");
  f_FCSI_LNARSSI_en_lna_clamp->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_en_lna_clamp, 7);

  Attribute* a_FCSI_LNARSSI_en_lna_clamp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_en_lna_clamp_0_0->setInstName ("0");
  a_FCSI_LNARSSI_en_lna_clamp_0_0->setLongName ("");
  a_FCSI_LNARSSI_en_lna_clamp_0_0->setDescription ("");
  a_FCSI_LNARSSI_en_lna_clamp_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LNARSSI_en_lna_clamp_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LNARSSI_en_lna_clamp->connectAttribute (a_FCSI_LNARSSI_en_lna_clamp_0_0);

  RField* f_FCSI_LNARSSI_ctl_rx_band = new RField;
  f_FCSI_LNARSSI_ctl_rx_band->setInstName ("ctl_rx_band");
  f_FCSI_LNARSSI_ctl_rx_band->setLongName ("CTL RX BAND");
  f_FCSI_LNARSSI_ctl_rx_band->setDescription ("Control RX band of LNA");
  f_FCSI_LNARSSI_ctl_rx_band->setDataWidth (1);
  f_FCSI_LNARSSI_ctl_rx_band->setResetVal ("1'b0");
  f_FCSI_LNARSSI_ctl_rx_band->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_ctl_rx_band, 8);

  Attribute* a_FCSI_LNARSSI_ctl_rx_band_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_ctl_rx_band_0_0->setInstName ("0");
  a_FCSI_LNARSSI_ctl_rx_band_0_0->setLongName ("");
  a_FCSI_LNARSSI_ctl_rx_band_0_0->setDescription ("");
  a_FCSI_LNARSSI_ctl_rx_band_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LNARSSI_ctl_rx_band_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LNARSSI_ctl_rx_band->connectAttribute (a_FCSI_LNARSSI_ctl_rx_band_0_0);

  RField* f_FCSI_LNARSSI_rx_band = new RField;
  f_FCSI_LNARSSI_rx_band->setInstName ("rx_band");
  f_FCSI_LNARSSI_rx_band->setLongName ("RX BAND");
  f_FCSI_LNARSSI_rx_band->setDescription ("Manual RX band");
  f_FCSI_LNARSSI_rx_band->setDataWidth (3);
  f_FCSI_LNARSSI_rx_band->setResetVal ("3'b000");
  f_FCSI_LNARSSI_rx_band->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_rx_band, 9);

  Attribute* a_FCSI_LNARSSI_rx_band_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_rx_band_0_0->setInstName ("0");
  a_FCSI_LNARSSI_rx_band_0_0->setLongName ("");
  a_FCSI_LNARSSI_rx_band_0_0->setDescription ("");
  a_FCSI_LNARSSI_rx_band_0_0->addItem("0", "3'b000", "min");
  a_FCSI_LNARSSI_rx_band_0_0->addItem("1", "3'b001", "");
  a_FCSI_LNARSSI_rx_band_0_0->addItem("2", "3'b010", "");
  a_FCSI_LNARSSI_rx_band_0_0->addItem("3", "3'b011", "");
  a_FCSI_LNARSSI_rx_band_0_0->addItem("4", "3'b100", "");
  a_FCSI_LNARSSI_rx_band_0_0->addItem("5", "3'b101", "");
  a_FCSI_LNARSSI_rx_band_0_0->addItem("6", "3'b110", "");
  a_FCSI_LNARSSI_rx_band_0_0->addItem("7", "3'b111", "max");
  f_FCSI_LNARSSI_rx_band->connectAttribute (a_FCSI_LNARSSI_rx_band_0_0);

  RField* f_FCSI_LNARSSI_ctl_lna_finegain = new RField;
  f_FCSI_LNARSSI_ctl_lna_finegain->setInstName ("ctl_lna_finegain");
  f_FCSI_LNARSSI_ctl_lna_finegain->setLongName ("CTL LNA FINEGAIN");
  f_FCSI_LNARSSI_ctl_lna_finegain->setDescription ("Control LNA finegain (with 1dB step)");
  f_FCSI_LNARSSI_ctl_lna_finegain->setDataWidth (4);
  f_FCSI_LNARSSI_ctl_lna_finegain->setResetVal ("4'b0000");
  f_FCSI_LNARSSI_ctl_lna_finegain->setAccProp (AccProp::RW);
  r_FCSI_LNARSSI->connectRField (f_FCSI_LNARSSI_ctl_lna_finegain, 12);

  Attribute* a_FCSI_LNARSSI_ctl_lna_finegain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LNARSSI_ctl_lna_finegain_0_0->setInstName ("0");
  a_FCSI_LNARSSI_ctl_lna_finegain_0_0->setLongName ("");
  a_FCSI_LNARSSI_ctl_lna_finegain_0_0->setDescription ("");
  a_FCSI_LNARSSI_ctl_lna_finegain_0_0->addItem("0", "4'b0000", "min");
  a_FCSI_LNARSSI_ctl_lna_finegain_0_0->addItem("15", "4'b1111", "max");
  f_FCSI_LNARSSI_ctl_lna_finegain->connectAttribute (a_FCSI_LNARSSI_ctl_lna_finegain_0_0);

  Register* r_FCSI_RXMIXER = new Register;
  r_FCSI_RXMIXER->setInstName ("RXMIXER");
  r_FCSI_RXMIXER->setLongName ("RX MIXER (HB/LB)");
  r_FCSI_RXMIXER->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXER->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXER, 0x00000019);

  RField* f_FCSI_RXMIXER_enable_rxmixer = new RField;
  f_FCSI_RXMIXER_enable_rxmixer->setInstName ("enable_rxmixer");
  f_FCSI_RXMIXER_enable_rxmixer->setLongName ("ENABLE RX MIXER");
  f_FCSI_RXMIXER_enable_rxmixer->setDescription ("Enable RX MIXER");
  f_FCSI_RXMIXER_enable_rxmixer->setDataWidth (1);
  f_FCSI_RXMIXER_enable_rxmixer->setResetVal ("1'b0");
  f_FCSI_RXMIXER_enable_rxmixer->setAccProp (AccProp::RW);
  r_FCSI_RXMIXER->connectRField (f_FCSI_RXMIXER_enable_rxmixer, 0);

  Attribute* a_FCSI_RXMIXER_enable_rxmixer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXER_enable_rxmixer_0_0->setInstName ("0");
  a_FCSI_RXMIXER_enable_rxmixer_0_0->setLongName ("");
  a_FCSI_RXMIXER_enable_rxmixer_0_0->setDescription ("");
  a_FCSI_RXMIXER_enable_rxmixer_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXMIXER_enable_rxmixer_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXER_enable_rxmixer->connectAttribute (a_FCSI_RXMIXER_enable_rxmixer_0_0);

  RField* f_FCSI_RXMIXER_en_ch_mixer = new RField;
  f_FCSI_RXMIXER_en_ch_mixer->setInstName ("en_ch_mixer");
  f_FCSI_RXMIXER_en_ch_mixer->setLongName ("ENABLE CH MIXER");
  f_FCSI_RXMIXER_en_ch_mixer->setDescription ("Enable I/Q path of the mixer");
  f_FCSI_RXMIXER_en_ch_mixer->setDataWidth (2);
  f_FCSI_RXMIXER_en_ch_mixer->setResetVal ("2'b00");
  f_FCSI_RXMIXER_en_ch_mixer->setAccProp (AccProp::RW);
  r_FCSI_RXMIXER->connectRField (f_FCSI_RXMIXER_en_ch_mixer, 1);

  Attribute* a_FCSI_RXMIXER_en_ch_mixer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXER_en_ch_mixer_0_0->setInstName ("0");
  a_FCSI_RXMIXER_en_ch_mixer_0_0->setLongName ("");
  a_FCSI_RXMIXER_en_ch_mixer_0_0->setDescription ("");
  a_FCSI_RXMIXER_en_ch_mixer_0_0->addItem("0", "2'b00", "I-Q path disabled");
  a_FCSI_RXMIXER_en_ch_mixer_0_0->addItem("1", "2'b01", "I-path enabled");
  a_FCSI_RXMIXER_en_ch_mixer_0_0->addItem("2", "2'b10", "q-path enabled");
  a_FCSI_RXMIXER_en_ch_mixer_0_0->addItem("3", "2'b11", "I-Q path enabled");
  f_FCSI_RXMIXER_en_ch_mixer->connectAttribute (a_FCSI_RXMIXER_en_ch_mixer_0_0);

  RField* f_FCSI_RXMIXER_enable_Isink_mixer = new RField;
  f_FCSI_RXMIXER_enable_Isink_mixer->setInstName ("enable_Isink_mixer");
  f_FCSI_RXMIXER_enable_Isink_mixer->setLongName ("ENABLE ISINK MIXER");
  f_FCSI_RXMIXER_enable_Isink_mixer->setDescription ("Enable bleed current of MIXER");
  f_FCSI_RXMIXER_enable_Isink_mixer->setDataWidth (1);
  f_FCSI_RXMIXER_enable_Isink_mixer->setResetVal ("1'b0");
  f_FCSI_RXMIXER_enable_Isink_mixer->setAccProp (AccProp::RW);
  r_FCSI_RXMIXER->connectRField (f_FCSI_RXMIXER_enable_Isink_mixer, 3);

  Attribute* a_FCSI_RXMIXER_enable_Isink_mixer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXER_enable_Isink_mixer_0_0->setInstName ("0");
  a_FCSI_RXMIXER_enable_Isink_mixer_0_0->setLongName ("");
  a_FCSI_RXMIXER_enable_Isink_mixer_0_0->setDescription ("");
  a_FCSI_RXMIXER_enable_Isink_mixer_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXMIXER_enable_Isink_mixer_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXER_enable_Isink_mixer->connectAttribute (a_FCSI_RXMIXER_enable_Isink_mixer_0_0);

  RField* f_FCSI_RXMIXER_ctl_stby_mixer = new RField;
  f_FCSI_RXMIXER_ctl_stby_mixer->setInstName ("ctl_stby_mixer");
  f_FCSI_RXMIXER_ctl_stby_mixer->setLongName ("CTL STBY MIXER");
  f_FCSI_RXMIXER_ctl_stby_mixer->setDescription ("Control standby of mixer");
  f_FCSI_RXMIXER_ctl_stby_mixer->setDataWidth (1);
  f_FCSI_RXMIXER_ctl_stby_mixer->setResetVal ("1'b0");
  f_FCSI_RXMIXER_ctl_stby_mixer->setAccProp (AccProp::RW);
  r_FCSI_RXMIXER->connectRField (f_FCSI_RXMIXER_ctl_stby_mixer, 4);

  Attribute* a_FCSI_RXMIXER_ctl_stby_mixer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXER_ctl_stby_mixer_0_0->setInstName ("0");
  a_FCSI_RXMIXER_ctl_stby_mixer_0_0->setLongName ("");
  a_FCSI_RXMIXER_ctl_stby_mixer_0_0->setDescription ("");
  a_FCSI_RXMIXER_ctl_stby_mixer_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXMIXER_ctl_stby_mixer_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXER_ctl_stby_mixer->connectAttribute (a_FCSI_RXMIXER_ctl_stby_mixer_0_0);

  RField* f_FCSI_RXMIXER_stby_mixer = new RField;
  f_FCSI_RXMIXER_stby_mixer->setInstName ("stby_mixer");
  f_FCSI_RXMIXER_stby_mixer->setLongName ("STBY MIXER");
  f_FCSI_RXMIXER_stby_mixer->setDescription ("Control manual standby of mixer");
  f_FCSI_RXMIXER_stby_mixer->setDataWidth (1);
  f_FCSI_RXMIXER_stby_mixer->setResetVal ("1'b0");
  f_FCSI_RXMIXER_stby_mixer->setAccProp (AccProp::RW);
  r_FCSI_RXMIXER->connectRField (f_FCSI_RXMIXER_stby_mixer, 5);

  Attribute* a_FCSI_RXMIXER_stby_mixer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXER_stby_mixer_0_0->setInstName ("0");
  a_FCSI_RXMIXER_stby_mixer_0_0->setLongName ("");
  a_FCSI_RXMIXER_stby_mixer_0_0->setDescription ("");
  a_FCSI_RXMIXER_stby_mixer_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXMIXER_stby_mixer_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXER_stby_mixer->connectAttribute (a_FCSI_RXMIXER_stby_mixer_0_0);

  Register* r_FCSI_DIRSTEP3 = new Register;
  r_FCSI_DIRSTEP3->setInstName ("DIRSTEP3");
  r_FCSI_DIRSTEP3->setLongName ("DIRSTEP3");
  r_FCSI_DIRSTEP3->setDescription ("BB-LDO1V2");
  r_FCSI_DIRSTEP3->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_DIRSTEP3, 0x0000001A);

  RField* f_FCSI_DIRSTEP3_lna = new RField;
  f_FCSI_DIRSTEP3_lna->setInstName ("lna");
  f_FCSI_DIRSTEP3_lna->setLongName ("LNA");
  f_FCSI_DIRSTEP3_lna->setDescription ("LNA");
  f_FCSI_DIRSTEP3_lna->setDataWidth (3);
  f_FCSI_DIRSTEP3_lna->setResetVal ("3'b000");
  f_FCSI_DIRSTEP3_lna->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP3->connectRField (f_FCSI_DIRSTEP3_lna, 0);

  Attribute* a_FCSI_DIRSTEP3_lna_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP3_lna_0_0->setInstName ("0");
  a_FCSI_DIRSTEP3_lna_0_0->setLongName ("");
  a_FCSI_DIRSTEP3_lna_0_0->setDescription ("");
  a_FCSI_DIRSTEP3_lna_0_0->addItem("0", "3'b000", "");
  a_FCSI_DIRSTEP3_lna_0_0->addItem("1", "3'b001", "");
  a_FCSI_DIRSTEP3_lna_0_0->addItem("2", "3'b010", "");
  a_FCSI_DIRSTEP3_lna_0_0->addItem("3", "3'b011", "");
  a_FCSI_DIRSTEP3_lna_0_0->addItem("4", "3'b100", "");
  a_FCSI_DIRSTEP3_lna_0_0->addItem("5", "3'b101", "");
  a_FCSI_DIRSTEP3_lna_0_0->addItem("6", "3'b110", "");
  a_FCSI_DIRSTEP3_lna_0_0->addItem("7", "3'b111", "");
  f_FCSI_DIRSTEP3_lna->connectAttribute (a_FCSI_DIRSTEP3_lna_0_0);

  RField* f_FCSI_DIRSTEP3_sel_s2d_rx = new RField;
  f_FCSI_DIRSTEP3_sel_s2d_rx->setInstName ("sel_s2d_rx");
  f_FCSI_DIRSTEP3_sel_s2d_rx->setLongName ("SEL_S2D_RX");
  f_FCSI_DIRSTEP3_sel_s2d_rx->setDescription ("Select RSSI xSSI range for dedicated configurations");
  f_FCSI_DIRSTEP3_sel_s2d_rx->setDataWidth (1);
  f_FCSI_DIRSTEP3_sel_s2d_rx->setResetVal ("1'b0");
  f_FCSI_DIRSTEP3_sel_s2d_rx->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP3->connectRField (f_FCSI_DIRSTEP3_sel_s2d_rx, 3);

  Attribute* a_FCSI_DIRSTEP3_sel_s2d_rx_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP3_sel_s2d_rx_0_0->setInstName ("0");
  a_FCSI_DIRSTEP3_sel_s2d_rx_0_0->setLongName ("");
  a_FCSI_DIRSTEP3_sel_s2d_rx_0_0->setDescription ("");
  a_FCSI_DIRSTEP3_sel_s2d_rx_0_0->addItem("1", "1'b1", "disable");
  a_FCSI_DIRSTEP3_sel_s2d_rx_0_0->addItem("0", "1'b0", "enable");
  f_FCSI_DIRSTEP3_sel_s2d_rx->connectAttribute (a_FCSI_DIRSTEP3_sel_s2d_rx_0_0);

  RField* f_FCSI_DIRSTEP3_pgc_gain = new RField;
  f_FCSI_DIRSTEP3_pgc_gain->setInstName ("pgc_gain");
  f_FCSI_DIRSTEP3_pgc_gain->setLongName ("PGC GAIN");
  f_FCSI_DIRSTEP3_pgc_gain->setDescription ("PGC gain");
  f_FCSI_DIRSTEP3_pgc_gain->setDataWidth (4);
  f_FCSI_DIRSTEP3_pgc_gain->setResetVal ("4'b0000");
  f_FCSI_DIRSTEP3_pgc_gain->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP3->connectRField (f_FCSI_DIRSTEP3_pgc_gain, 4);

  Attribute* a_FCSI_DIRSTEP3_pgc_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP3_pgc_gain_0_0->setInstName ("0");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->setLongName ("");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->setDescription ("");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("0", "4'b0000", "0dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("1", "4'b0001", "2dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("2", "4'b0010", "4dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("3", "4'b0011", "6dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("4", "4'b0100", "8dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("5", "4'b0101", "10dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("6", "4'b0110", "12dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("7", "4'b0111", "14dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("8", "4'b1000", "16dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("9", "4'b1001", "18dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("10", "4'b1010", "20dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("11", "4'b1011", "2dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("12", "4'b1100", "24dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("13", "4'b1101", "26dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("14", "4'b1110", "28dB");
  a_FCSI_DIRSTEP3_pgc_gain_0_0->addItem("15", "4'b1111", "30dB");
  f_FCSI_DIRSTEP3_pgc_gain->connectAttribute (a_FCSI_DIRSTEP3_pgc_gain_0_0);

  RField* f_FCSI_DIRSTEP3_rx_filter = new RField;
  f_FCSI_DIRSTEP3_rx_filter->setInstName ("rx_filter");
  f_FCSI_DIRSTEP3_rx_filter->setLongName ("RX FILTER");
  f_FCSI_DIRSTEP3_rx_filter->setDescription ("RX Filter");
  f_FCSI_DIRSTEP3_rx_filter->setDataWidth (6);
  f_FCSI_DIRSTEP3_rx_filter->setResetVal ("6'b000000");
  f_FCSI_DIRSTEP3_rx_filter->setAccProp (AccProp::RW);
  r_FCSI_DIRSTEP3->connectRField (f_FCSI_DIRSTEP3_rx_filter, 8);

  Attribute* a_FCSI_DIRSTEP3_rx_filter_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_DIRSTEP3_rx_filter_0_0->setInstName ("0");
  a_FCSI_DIRSTEP3_rx_filter_0_0->setLongName ("");
  a_FCSI_DIRSTEP3_rx_filter_0_0->setDescription ("");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("0", "6'b000000", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("1", "6'b000001", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("2", "6'b000010", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("3", "6'b000011", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("4", "6'b000100", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("5", "6'b000101", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("6", "6'b000110", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("7", "6'b000111", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("8", "6'b001000", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("9", "6'b001001", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("10", "6'b001010", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("11", "6'b001011", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("12", "6'b001100", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("13", "6'b001101", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("14", "6'b001110", "xx");
  a_FCSI_DIRSTEP3_rx_filter_0_0->addItem("15", "6'b001111", "xx");
  f_FCSI_DIRSTEP3_rx_filter->connectAttribute (a_FCSI_DIRSTEP3_rx_filter_0_0);

  Register* r_FCSI_RSSIBIAS = new Register;
  r_FCSI_RSSIBIAS->setInstName ("RSSIBIAS");
  r_FCSI_RSSIBIAS->setLongName ("RSSIBIAS");
  r_FCSI_RSSIBIAS->setDescription ("BB-LDO1V2");
  r_FCSI_RSSIBIAS->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RSSIBIAS, 0x0000001B);

  RField* f_FCSI_RSSIBIAS_enable_rssi_bias = new RField;
  f_FCSI_RSSIBIAS_enable_rssi_bias->setInstName ("enable_rssi_bias");
  f_FCSI_RSSIBIAS_enable_rssi_bias->setLongName ("ENABLE RSSI BIAS");
  f_FCSI_RSSIBIAS_enable_rssi_bias->setDescription ("Enable RSSI bias");
  f_FCSI_RSSIBIAS_enable_rssi_bias->setDataWidth (1);
  f_FCSI_RSSIBIAS_enable_rssi_bias->setResetVal ("1'b0");
  f_FCSI_RSSIBIAS_enable_rssi_bias->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_enable_rssi_bias, 0);

  Attribute* a_FCSI_RSSIBIAS_enable_rssi_bias_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_enable_rssi_bias_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_enable_rssi_bias_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_enable_rssi_bias_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_enable_rssi_bias_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RSSIBIAS_enable_rssi_bias_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RSSIBIAS_enable_rssi_bias->connectAttribute (a_FCSI_RSSIBIAS_enable_rssi_bias_0_0);

  RField* f_FCSI_RSSIBIAS_ctl_en_HBLB = new RField;
  f_FCSI_RSSIBIAS_ctl_en_HBLB->setInstName ("ctl_en_HBLB");
  f_FCSI_RSSIBIAS_ctl_en_HBLB->setLongName ("CONTROL ENABLE HBLB");
  f_FCSI_RSSIBIAS_ctl_en_HBLB->setDescription ("Control enable HBLB of RSSI bias");
  f_FCSI_RSSIBIAS_ctl_en_HBLB->setDataWidth (1);
  f_FCSI_RSSIBIAS_ctl_en_HBLB->setResetVal ("1'b0");
  f_FCSI_RSSIBIAS_ctl_en_HBLB->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_ctl_en_HBLB, 1);

  Attribute* a_FCSI_RSSIBIAS_ctl_en_HBLB_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_ctl_en_HBLB_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_ctl_en_HBLB_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_ctl_en_HBLB_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_ctl_en_HBLB_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RSSIBIAS_ctl_en_HBLB_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RSSIBIAS_ctl_en_HBLB->connectAttribute (a_FCSI_RSSIBIAS_ctl_en_HBLB_0_0);

  RField* f_FCSI_RSSIBIAS_enable_HB = new RField;
  f_FCSI_RSSIBIAS_enable_HB->setInstName ("enable_HB");
  f_FCSI_RSSIBIAS_enable_HB->setLongName ("ENABLE HB");
  f_FCSI_RSSIBIAS_enable_HB->setDescription ("Enable HB");
  f_FCSI_RSSIBIAS_enable_HB->setDataWidth (1);
  f_FCSI_RSSIBIAS_enable_HB->setResetVal ("1'b0");
  f_FCSI_RSSIBIAS_enable_HB->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_enable_HB, 2);

  Attribute* a_FCSI_RSSIBIAS_enable_HB_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_enable_HB_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_enable_HB_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_enable_HB_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_enable_HB_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RSSIBIAS_enable_HB_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RSSIBIAS_enable_HB->connectAttribute (a_FCSI_RSSIBIAS_enable_HB_0_0);

  RField* f_FCSI_RSSIBIAS_enable_LB = new RField;
  f_FCSI_RSSIBIAS_enable_LB->setInstName ("enable_LB");
  f_FCSI_RSSIBIAS_enable_LB->setLongName ("ENABLE LB");
  f_FCSI_RSSIBIAS_enable_LB->setDescription ("Enable LB");
  f_FCSI_RSSIBIAS_enable_LB->setDataWidth (1);
  f_FCSI_RSSIBIAS_enable_LB->setResetVal ("1'b0");
  f_FCSI_RSSIBIAS_enable_LB->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_enable_LB, 3);

  Attribute* a_FCSI_RSSIBIAS_enable_LB_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_enable_LB_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_enable_LB_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_enable_LB_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_enable_LB_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RSSIBIAS_enable_LB_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RSSIBIAS_enable_LB->connectAttribute (a_FCSI_RSSIBIAS_enable_LB_0_0);

  RField* f_FCSI_RSSIBIAS_ctl_stby = new RField;
  f_FCSI_RSSIBIAS_ctl_stby->setInstName ("ctl_stby");
  f_FCSI_RSSIBIAS_ctl_stby->setLongName ("CTL STBY");
  f_FCSI_RSSIBIAS_ctl_stby->setDescription ("Control standby of RSSI bias");
  f_FCSI_RSSIBIAS_ctl_stby->setDataWidth (1);
  f_FCSI_RSSIBIAS_ctl_stby->setResetVal ("1'b0");
  f_FCSI_RSSIBIAS_ctl_stby->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_ctl_stby, 4);

  Attribute* a_FCSI_RSSIBIAS_ctl_stby_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_ctl_stby_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_ctl_stby_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_ctl_stby_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_ctl_stby_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RSSIBIAS_ctl_stby_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RSSIBIAS_ctl_stby->connectAttribute (a_FCSI_RSSIBIAS_ctl_stby_0_0);

  RField* f_FCSI_RSSIBIAS_stby = new RField;
  f_FCSI_RSSIBIAS_stby->setInstName ("stby");
  f_FCSI_RSSIBIAS_stby->setLongName ("STBY");
  f_FCSI_RSSIBIAS_stby->setDescription ("Control manual standby of RSSI bias");
  f_FCSI_RSSIBIAS_stby->setDataWidth (1);
  f_FCSI_RSSIBIAS_stby->setResetVal ("1'b0");
  f_FCSI_RSSIBIAS_stby->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_stby, 5);

  Attribute* a_FCSI_RSSIBIAS_stby_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_stby_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_stby_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_stby_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_stby_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RSSIBIAS_stby_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RSSIBIAS_stby->connectAttribute (a_FCSI_RSSIBIAS_stby_0_0);

  RField* f_FCSI_RSSIBIAS_ctl_temp_comp = new RField;
  f_FCSI_RSSIBIAS_ctl_temp_comp->setInstName ("ctl_temp_comp");
  f_FCSI_RSSIBIAS_ctl_temp_comp->setLongName ("CTL_TEMP_COMP");
  f_FCSI_RSSIBIAS_ctl_temp_comp->setDescription ("Control temperature compensation");
  f_FCSI_RSSIBIAS_ctl_temp_comp->setDataWidth (1);
  f_FCSI_RSSIBIAS_ctl_temp_comp->setResetVal ("1'b0");
  f_FCSI_RSSIBIAS_ctl_temp_comp->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_ctl_temp_comp, 6);

  Attribute* a_FCSI_RSSIBIAS_ctl_temp_comp_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_ctl_temp_comp_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_ctl_temp_comp_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_ctl_temp_comp_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_ctl_temp_comp_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RSSIBIAS_ctl_temp_comp_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RSSIBIAS_ctl_temp_comp->connectAttribute (a_FCSI_RSSIBIAS_ctl_temp_comp_0_0);

  RField* f_FCSI_RSSIBIAS_ctl_range_select = new RField;
  f_FCSI_RSSIBIAS_ctl_range_select->setInstName ("ctl_range_select");
  f_FCSI_RSSIBIAS_ctl_range_select->setLongName ("CTL RANGE SELECT");
  f_FCSI_RSSIBIAS_ctl_range_select->setDescription ("Control RSSI range select");
  f_FCSI_RSSIBIAS_ctl_range_select->setDataWidth (1);
  f_FCSI_RSSIBIAS_ctl_range_select->setResetVal ("1'b0");
  f_FCSI_RSSIBIAS_ctl_range_select->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_ctl_range_select, 7);

  Attribute* a_FCSI_RSSIBIAS_ctl_range_select_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_ctl_range_select_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_ctl_range_select_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_ctl_range_select_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_ctl_range_select_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RSSIBIAS_ctl_range_select_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RSSIBIAS_ctl_range_select->connectAttribute (a_FCSI_RSSIBIAS_ctl_range_select_0_0);

  RField* f_FCSI_RSSIBIAS_ctl_range = new RField;
  f_FCSI_RSSIBIAS_ctl_range->setInstName ("ctl_range");
  f_FCSI_RSSIBIAS_ctl_range->setLongName ("CTL RANGE");
  f_FCSI_RSSIBIAS_ctl_range->setDescription ("Control range of rssi bias");
  f_FCSI_RSSIBIAS_ctl_range->setDataWidth (2);
  f_FCSI_RSSIBIAS_ctl_range->setResetVal ("2'b00");
  f_FCSI_RSSIBIAS_ctl_range->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_ctl_range, 8);

  Attribute* a_FCSI_RSSIBIAS_ctl_range_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_ctl_range_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_ctl_range_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_ctl_range_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_ctl_range_0_0->addItem("0", "2'b00", "75uA");
  a_FCSI_RSSIBIAS_ctl_range_0_0->addItem("1", "2'b01", "0uA");
  a_FCSI_RSSIBIAS_ctl_range_0_0->addItem("2", "2'b10", "-100uA");
  a_FCSI_RSSIBIAS_ctl_range_0_0->addItem("3", "2'b11", "-200uA");
  f_FCSI_RSSIBIAS_ctl_range->connectAttribute (a_FCSI_RSSIBIAS_ctl_range_0_0);

  RField* f_FCSI_RSSIBIAS_ctl_bias_select = new RField;
  f_FCSI_RSSIBIAS_ctl_bias_select->setInstName ("ctl_bias_select");
  f_FCSI_RSSIBIAS_ctl_bias_select->setLongName ("CTL BIAS SELECT");
  f_FCSI_RSSIBIAS_ctl_bias_select->setDescription ("Control RSSI bias select");
  f_FCSI_RSSIBIAS_ctl_bias_select->setDataWidth (1);
  f_FCSI_RSSIBIAS_ctl_bias_select->setResetVal ("1'b0");
  f_FCSI_RSSIBIAS_ctl_bias_select->setAccProp (AccProp::RW);
  r_FCSI_RSSIBIAS->connectRField (f_FCSI_RSSIBIAS_ctl_bias_select, 10);

  Attribute* a_FCSI_RSSIBIAS_ctl_bias_select_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSIBIAS_ctl_bias_select_0_0->setInstName ("0");
  a_FCSI_RSSIBIAS_ctl_bias_select_0_0->setLongName ("");
  a_FCSI_RSSIBIAS_ctl_bias_select_0_0->setDescription ("");
  a_FCSI_RSSIBIAS_ctl_bias_select_0_0->addItem("1", "1'b1", "P2pr bias current");
  a_FCSI_RSSIBIAS_ctl_bias_select_0_0->addItem("0", "1'b0", "Constant bias current");
  f_FCSI_RSSIBIAS_ctl_bias_select->connectAttribute (a_FCSI_RSSIBIAS_ctl_bias_select_0_0);

  Register* r_FCSI_PGC = new Register;
  r_FCSI_PGC->setInstName ("PGC");
  r_FCSI_PGC->setLongName ("PGC");
  r_FCSI_PGC->setDescription ("BB-LDO1V2");
  r_FCSI_PGC->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_PGC, 0x0000001C);

  RField* f_FCSI_PGC_ctl_enable = new RField;
  f_FCSI_PGC_ctl_enable->setInstName ("ctl_enable");
  f_FCSI_PGC_ctl_enable->setLongName ("CTL ENABLE");
  f_FCSI_PGC_ctl_enable->setDescription ("Control enable of PGC");
  f_FCSI_PGC_ctl_enable->setDataWidth (1);
  f_FCSI_PGC_ctl_enable->setResetVal ("1'b0");
  f_FCSI_PGC_ctl_enable->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_ctl_enable, 0);

  Attribute* a_FCSI_PGC_ctl_enable_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_ctl_enable_0_0->setInstName ("0");
  a_FCSI_PGC_ctl_enable_0_0->setLongName ("");
  a_FCSI_PGC_ctl_enable_0_0->setDescription ("");
  a_FCSI_PGC_ctl_enable_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PGC_ctl_enable_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PGC_ctl_enable->connectAttribute (a_FCSI_PGC_ctl_enable_0_0);

  RField* f_FCSI_PGC_enable_pgc = new RField;
  f_FCSI_PGC_enable_pgc->setInstName ("enable_pgc");
  f_FCSI_PGC_enable_pgc->setLongName ("ENABLE PGC");
  f_FCSI_PGC_enable_pgc->setDescription ("Enable of PGC");
  f_FCSI_PGC_enable_pgc->setDataWidth (1);
  f_FCSI_PGC_enable_pgc->setResetVal ("1'b0");
  f_FCSI_PGC_enable_pgc->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_enable_pgc, 1);

  Attribute* a_FCSI_PGC_enable_pgc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_enable_pgc_0_0->setInstName ("0");
  a_FCSI_PGC_enable_pgc_0_0->setLongName ("");
  a_FCSI_PGC_enable_pgc_0_0->setDescription ("");
  a_FCSI_PGC_enable_pgc_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PGC_enable_pgc_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PGC_enable_pgc->connectAttribute (a_FCSI_PGC_enable_pgc_0_0);

  RField* f_FCSI_PGC_ctl_stby = new RField;
  f_FCSI_PGC_ctl_stby->setInstName ("ctl_stby");
  f_FCSI_PGC_ctl_stby->setLongName ("CTL STBY");
  f_FCSI_PGC_ctl_stby->setDescription ("Control standby of PGC");
  f_FCSI_PGC_ctl_stby->setDataWidth (1);
  f_FCSI_PGC_ctl_stby->setResetVal ("1'b0");
  f_FCSI_PGC_ctl_stby->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_ctl_stby, 2);

  Attribute* a_FCSI_PGC_ctl_stby_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_ctl_stby_0_0->setInstName ("0");
  a_FCSI_PGC_ctl_stby_0_0->setLongName ("");
  a_FCSI_PGC_ctl_stby_0_0->setDescription ("");
  a_FCSI_PGC_ctl_stby_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PGC_ctl_stby_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PGC_ctl_stby->connectAttribute (a_FCSI_PGC_ctl_stby_0_0);

  RField* f_FCSI_PGC_stby = new RField;
  f_FCSI_PGC_stby->setInstName ("stby");
  f_FCSI_PGC_stby->setLongName ("STBY");
  f_FCSI_PGC_stby->setDescription ("Control manual standby of PGC");
  f_FCSI_PGC_stby->setDataWidth (1);
  f_FCSI_PGC_stby->setResetVal ("1'b0");
  f_FCSI_PGC_stby->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_stby, 3);

  Attribute* a_FCSI_PGC_stby_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_stby_0_0->setInstName ("0");
  a_FCSI_PGC_stby_0_0->setLongName ("");
  a_FCSI_PGC_stby_0_0->setDescription ("");
  a_FCSI_PGC_stby_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PGC_stby_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PGC_stby->connectAttribute (a_FCSI_PGC_stby_0_0);

  RField* f_FCSI_PGC_en_ch_mixer = new RField;
  f_FCSI_PGC_en_ch_mixer->setInstName ("en_ch_mixer");
  f_FCSI_PGC_en_ch_mixer->setLongName ("ENABLE CH MIXER");
  f_FCSI_PGC_en_ch_mixer->setDescription ("Enable I/Q path of the mixer");
  f_FCSI_PGC_en_ch_mixer->setDataWidth (2);
  f_FCSI_PGC_en_ch_mixer->setResetVal ("2'b00");
  f_FCSI_PGC_en_ch_mixer->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_en_ch_mixer, 4);

  Attribute* a_FCSI_PGC_en_ch_mixer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_en_ch_mixer_0_0->setInstName ("0");
  a_FCSI_PGC_en_ch_mixer_0_0->setLongName ("");
  a_FCSI_PGC_en_ch_mixer_0_0->setDescription ("");
  a_FCSI_PGC_en_ch_mixer_0_0->addItem("0", "2'b00", "I-Q path disabled");
  a_FCSI_PGC_en_ch_mixer_0_0->addItem("1", "2'b01", "I-path enabled");
  a_FCSI_PGC_en_ch_mixer_0_0->addItem("2", "2'b10", "q-path enabled");
  a_FCSI_PGC_en_ch_mixer_0_0->addItem("3", "2'b11", "I-Q path enabled");
  f_FCSI_PGC_en_ch_mixer->connectAttribute (a_FCSI_PGC_en_ch_mixer_0_0);

  RField* f_FCSI_PGC_en_pgc_cal = new RField;
  f_FCSI_PGC_en_pgc_cal->setInstName ("en_pgc_cal");
  f_FCSI_PGC_en_pgc_cal->setLongName ("ENABLE PGC CAL");
  f_FCSI_PGC_en_pgc_cal->setDescription ("Enable PGC calibration loop");
  f_FCSI_PGC_en_pgc_cal->setDataWidth (2);
  f_FCSI_PGC_en_pgc_cal->setResetVal ("2'b00");
  f_FCSI_PGC_en_pgc_cal->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_en_pgc_cal, 6);

  Attribute* a_FCSI_PGC_en_pgc_cal_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_en_pgc_cal_0_0->setInstName ("0");
  a_FCSI_PGC_en_pgc_cal_0_0->setLongName ("");
  a_FCSI_PGC_en_pgc_cal_0_0->setDescription ("");
  a_FCSI_PGC_en_pgc_cal_0_0->addItem("0", "2'b00", "I-Q path disabled");
  a_FCSI_PGC_en_pgc_cal_0_0->addItem("1", "2'b01", "I-path enabled");
  a_FCSI_PGC_en_pgc_cal_0_0->addItem("2", "2'b10", "q-path enabled");
  a_FCSI_PGC_en_pgc_cal_0_0->addItem("3", "2'b11", "I-Q path enabled");
  f_FCSI_PGC_en_pgc_cal->connectAttribute (a_FCSI_PGC_en_pgc_cal_0_0);

  RField* f_FCSI_PGC_enable_mixer = new RField;
  f_FCSI_PGC_enable_mixer->setInstName ("enable_mixer");
  f_FCSI_PGC_enable_mixer->setLongName ("ENABLE MIXER");
  f_FCSI_PGC_enable_mixer->setDescription ("Enable BB core of mixer");
  f_FCSI_PGC_enable_mixer->setDataWidth (1);
  f_FCSI_PGC_enable_mixer->setResetVal ("1'b0");
  f_FCSI_PGC_enable_mixer->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_enable_mixer, 8);

  Attribute* a_FCSI_PGC_enable_mixer_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_enable_mixer_0_0->setInstName ("0");
  a_FCSI_PGC_enable_mixer_0_0->setLongName ("");
  a_FCSI_PGC_enable_mixer_0_0->setDescription ("");
  a_FCSI_PGC_enable_mixer_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PGC_enable_mixer_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PGC_enable_mixer->connectAttribute (a_FCSI_PGC_enable_mixer_0_0);

  RField* f_FCSI_PGC_enable_iqcal_gnd_sw = new RField;
  f_FCSI_PGC_enable_iqcal_gnd_sw->setInstName ("enable_iqcal_gnd_sw");
  f_FCSI_PGC_enable_iqcal_gnd_sw->setLongName ("ENABLE IQCAL GND SW");
  f_FCSI_PGC_enable_iqcal_gnd_sw->setDescription ("Enable IACAL GND switch");
  f_FCSI_PGC_enable_iqcal_gnd_sw->setDataWidth (1);
  f_FCSI_PGC_enable_iqcal_gnd_sw->setResetVal ("1'b0");
  f_FCSI_PGC_enable_iqcal_gnd_sw->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_enable_iqcal_gnd_sw, 9);

  Attribute* a_FCSI_PGC_enable_iqcal_gnd_sw_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_enable_iqcal_gnd_sw_0_0->setInstName ("0");
  a_FCSI_PGC_enable_iqcal_gnd_sw_0_0->setLongName ("");
  a_FCSI_PGC_enable_iqcal_gnd_sw_0_0->setDescription ("");
  a_FCSI_PGC_enable_iqcal_gnd_sw_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PGC_enable_iqcal_gnd_sw_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PGC_enable_iqcal_gnd_sw->connectAttribute (a_FCSI_PGC_enable_iqcal_gnd_sw_0_0);

  RField* f_FCSI_PGC_enable_iqcal_loop = new RField;
  f_FCSI_PGC_enable_iqcal_loop->setInstName ("enable_iqcal_loop");
  f_FCSI_PGC_enable_iqcal_loop->setLongName ("ENABLE IQCAL GND LOOP");
  f_FCSI_PGC_enable_iqcal_loop->setDescription ("Enable IACAL loop");
  f_FCSI_PGC_enable_iqcal_loop->setDataWidth (1);
  f_FCSI_PGC_enable_iqcal_loop->setResetVal ("1'b0");
  f_FCSI_PGC_enable_iqcal_loop->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_enable_iqcal_loop, 10);

  Attribute* a_FCSI_PGC_enable_iqcal_loop_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_enable_iqcal_loop_0_0->setInstName ("0");
  a_FCSI_PGC_enable_iqcal_loop_0_0->setLongName ("");
  a_FCSI_PGC_enable_iqcal_loop_0_0->setDescription ("");
  a_FCSI_PGC_enable_iqcal_loop_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PGC_enable_iqcal_loop_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PGC_enable_iqcal_loop->connectAttribute (a_FCSI_PGC_enable_iqcal_loop_0_0);

  RField* f_FCSI_PGC_ctl_comp_cap = new RField;
  f_FCSI_PGC_ctl_comp_cap->setInstName ("ctl_comp_cap");
  f_FCSI_PGC_ctl_comp_cap->setLongName ("CTL COMP CAP");
  f_FCSI_PGC_ctl_comp_cap->setDescription ("Control compensation capacitor");
  f_FCSI_PGC_ctl_comp_cap->setDataWidth (2);
  f_FCSI_PGC_ctl_comp_cap->setResetVal ("2'b00");
  f_FCSI_PGC_ctl_comp_cap->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_ctl_comp_cap, 11);

  Attribute* a_FCSI_PGC_ctl_comp_cap_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_ctl_comp_cap_0_0->setInstName ("0");
  a_FCSI_PGC_ctl_comp_cap_0_0->setLongName ("");
  a_FCSI_PGC_ctl_comp_cap_0_0->setDescription ("");
  a_FCSI_PGC_ctl_comp_cap_0_0->addItem("0", "2'b00", "xx");
  a_FCSI_PGC_ctl_comp_cap_0_0->addItem("1", "2'b01", "xx");
  a_FCSI_PGC_ctl_comp_cap_0_0->addItem("2", "2'b10", "xx");
  a_FCSI_PGC_ctl_comp_cap_0_0->addItem("3", "2'b11", "xx");
  f_FCSI_PGC_ctl_comp_cap->connectAttribute (a_FCSI_PGC_ctl_comp_cap_0_0);

  RField* f_FCSI_PGC_ctl_bias_current = new RField;
  f_FCSI_PGC_ctl_bias_current->setInstName ("ctl_bias_current");
  f_FCSI_PGC_ctl_bias_current->setLongName ("CTL BIAS CURRENT");
  f_FCSI_PGC_ctl_bias_current->setDescription ("Control bias current");
  f_FCSI_PGC_ctl_bias_current->setDataWidth (1);
  f_FCSI_PGC_ctl_bias_current->setResetVal ("1'b0");
  f_FCSI_PGC_ctl_bias_current->setAccProp (AccProp::RW);
  r_FCSI_PGC->connectRField (f_FCSI_PGC_ctl_bias_current, 13);

  Attribute* a_FCSI_PGC_ctl_bias_current_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_PGC_ctl_bias_current_0_0->setInstName ("0");
  a_FCSI_PGC_ctl_bias_current_0_0->setLongName ("");
  a_FCSI_PGC_ctl_bias_current_0_0->setDescription ("");
  a_FCSI_PGC_ctl_bias_current_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_PGC_ctl_bias_current_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_PGC_ctl_bias_current->connectAttribute (a_FCSI_PGC_ctl_bias_current_0_0);

  Register* r_FCSI_SSI = new Register;
  r_FCSI_SSI->setInstName ("SSI");
  r_FCSI_SSI->setLongName ("SSI");
  r_FCSI_SSI->setDescription ("BB-LDO1V2");
  r_FCSI_SSI->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_SSI, 0x0000001D);

  RField* f_FCSI_SSI_enable_ssi_odac = new RField;
  f_FCSI_SSI_enable_ssi_odac->setInstName ("enable_ssi_odac");
  f_FCSI_SSI_enable_ssi_odac->setLongName ("ENABLE SSI ODAC");
  f_FCSI_SSI_enable_ssi_odac->setDescription ("Enable of SSI ODAC");
  f_FCSI_SSI_enable_ssi_odac->setDataWidth (1);
  f_FCSI_SSI_enable_ssi_odac->setResetVal ("1'b0");
  f_FCSI_SSI_enable_ssi_odac->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_enable_ssi_odac, 0);

  Attribute* a_FCSI_SSI_enable_ssi_odac_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_enable_ssi_odac_0_0->setInstName ("0");
  a_FCSI_SSI_enable_ssi_odac_0_0->setLongName ("");
  a_FCSI_SSI_enable_ssi_odac_0_0->setDescription ("");
  a_FCSI_SSI_enable_ssi_odac_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_enable_ssi_odac_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_enable_ssi_odac->connectAttribute (a_FCSI_SSI_enable_ssi_odac_0_0);

  RField* f_FCSI_SSI_enable_ssi_gain = new RField;
  f_FCSI_SSI_enable_ssi_gain->setInstName ("enable_ssi_gain");
  f_FCSI_SSI_enable_ssi_gain->setLongName ("ENABLE SSI GAIN");
  f_FCSI_SSI_enable_ssi_gain->setDescription ("Enable of gain");
  f_FCSI_SSI_enable_ssi_gain->setDataWidth (1);
  f_FCSI_SSI_enable_ssi_gain->setResetVal ("1'b0");
  f_FCSI_SSI_enable_ssi_gain->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_enable_ssi_gain, 1);

  Attribute* a_FCSI_SSI_enable_ssi_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_enable_ssi_gain_0_0->setInstName ("0");
  a_FCSI_SSI_enable_ssi_gain_0_0->setLongName ("");
  a_FCSI_SSI_enable_ssi_gain_0_0->setDescription ("");
  a_FCSI_SSI_enable_ssi_gain_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_enable_ssi_gain_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_enable_ssi_gain->connectAttribute (a_FCSI_SSI_enable_ssi_gain_0_0);

  RField* f_FCSI_SSI_ctl_ssi_odac = new RField;
  f_FCSI_SSI_ctl_ssi_odac->setInstName ("ctl_ssi_odac");
  f_FCSI_SSI_ctl_ssi_odac->setLongName ("CTL SSI ODAC");
  f_FCSI_SSI_ctl_ssi_odac->setDescription ("Control SSI ODAC");
  f_FCSI_SSI_ctl_ssi_odac->setDataWidth (1);
  f_FCSI_SSI_ctl_ssi_odac->setResetVal ("1'b0");
  f_FCSI_SSI_ctl_ssi_odac->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_ctl_ssi_odac, 2);

  Attribute* a_FCSI_SSI_ctl_ssi_odac_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_ctl_ssi_odac_0_0->setInstName ("0");
  a_FCSI_SSI_ctl_ssi_odac_0_0->setLongName ("");
  a_FCSI_SSI_ctl_ssi_odac_0_0->setDescription ("");
  a_FCSI_SSI_ctl_ssi_odac_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_ctl_ssi_odac_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_ctl_ssi_odac->connectAttribute (a_FCSI_SSI_ctl_ssi_odac_0_0);

  RField* f_FCSI_SSI_enable_tssi_v2i = new RField;
  f_FCSI_SSI_enable_tssi_v2i->setInstName ("enable_tssi_v2i");
  f_FCSI_SSI_enable_tssi_v2i->setLongName ("ENABLE TSSI V2I");
  f_FCSI_SSI_enable_tssi_v2i->setDescription ("Enable of TSSI V2I");
  f_FCSI_SSI_enable_tssi_v2i->setDataWidth (1);
  f_FCSI_SSI_enable_tssi_v2i->setResetVal ("1'b0");
  f_FCSI_SSI_enable_tssi_v2i->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_enable_tssi_v2i, 3);

  Attribute* a_FCSI_SSI_enable_tssi_v2i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_enable_tssi_v2i_0_0->setInstName ("0");
  a_FCSI_SSI_enable_tssi_v2i_0_0->setLongName ("");
  a_FCSI_SSI_enable_tssi_v2i_0_0->setDescription ("");
  a_FCSI_SSI_enable_tssi_v2i_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_enable_tssi_v2i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_enable_tssi_v2i->connectAttribute (a_FCSI_SSI_enable_tssi_v2i_0_0);

  RField* f_FCSI_SSI_ctl_tssi_v2i = new RField;
  f_FCSI_SSI_ctl_tssi_v2i->setInstName ("ctl_tssi_v2i");
  f_FCSI_SSI_ctl_tssi_v2i->setLongName ("CTL TSSI V2I");
  f_FCSI_SSI_ctl_tssi_v2i->setDescription ("Control TSSI V2I");
  f_FCSI_SSI_ctl_tssi_v2i->setDataWidth (1);
  f_FCSI_SSI_ctl_tssi_v2i->setResetVal ("1'b0");
  f_FCSI_SSI_ctl_tssi_v2i->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_ctl_tssi_v2i, 4);

  Attribute* a_FCSI_SSI_ctl_tssi_v2i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_ctl_tssi_v2i_0_0->setInstName ("0");
  a_FCSI_SSI_ctl_tssi_v2i_0_0->setLongName ("");
  a_FCSI_SSI_ctl_tssi_v2i_0_0->setDescription ("");
  a_FCSI_SSI_ctl_tssi_v2i_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_ctl_tssi_v2i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_ctl_tssi_v2i->connectAttribute (a_FCSI_SSI_ctl_tssi_v2i_0_0);

  RField* f_FCSI_SSI_ctl_tssi_range = new RField;
  f_FCSI_SSI_ctl_tssi_range->setInstName ("ctl_tssi_range");
  f_FCSI_SSI_ctl_tssi_range->setLongName ("CTL TSSI RANGE");
  f_FCSI_SSI_ctl_tssi_range->setDescription ("Control TSSI input range via resistive divider");
  f_FCSI_SSI_ctl_tssi_range->setDataWidth (1);
  f_FCSI_SSI_ctl_tssi_range->setResetVal ("1'b0");
  f_FCSI_SSI_ctl_tssi_range->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_ctl_tssi_range, 5);

  Attribute* a_FCSI_SSI_ctl_tssi_range_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_ctl_tssi_range_0_0->setInstName ("0");
  a_FCSI_SSI_ctl_tssi_range_0_0->setLongName ("");
  a_FCSI_SSI_ctl_tssi_range_0_0->setDescription ("");
  a_FCSI_SSI_ctl_tssi_range_0_0->addItem("1", "1'b1", "ratio = 0.9");
  a_FCSI_SSI_ctl_tssi_range_0_0->addItem("0", "1'b0", "ratio = 0.6");
  f_FCSI_SSI_ctl_tssi_range->connectAttribute (a_FCSI_SSI_ctl_tssi_range_0_0);

  RField* f_FCSI_SSI_enable_anamux = new RField;
  f_FCSI_SSI_enable_anamux->setInstName ("enable_anamux");
  f_FCSI_SSI_enable_anamux->setLongName ("ENABLE ANAMUX");
  f_FCSI_SSI_enable_anamux->setDescription ("Enable anamux");
  f_FCSI_SSI_enable_anamux->setDataWidth (1);
  f_FCSI_SSI_enable_anamux->setResetVal ("1'b0");
  f_FCSI_SSI_enable_anamux->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_enable_anamux, 6);

  Attribute* a_FCSI_SSI_enable_anamux_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_enable_anamux_0_0->setInstName ("0");
  a_FCSI_SSI_enable_anamux_0_0->setLongName ("");
  a_FCSI_SSI_enable_anamux_0_0->setDescription ("");
  a_FCSI_SSI_enable_anamux_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_enable_anamux_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_enable_anamux->connectAttribute (a_FCSI_SSI_enable_anamux_0_0);

  RField* f_FCSI_SSI_en_ssi_in = new RField;
  f_FCSI_SSI_en_ssi_in->setInstName ("en_ssi_in");
  f_FCSI_SSI_en_ssi_in->setLongName ("EN SSI IN");
  f_FCSI_SSI_en_ssi_in->setDescription ("Enable SSI as input");
  f_FCSI_SSI_en_ssi_in->setDataWidth (1);
  f_FCSI_SSI_en_ssi_in->setResetVal ("1'b0");
  f_FCSI_SSI_en_ssi_in->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_en_ssi_in, 7);

  Attribute* a_FCSI_SSI_en_ssi_in_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_en_ssi_in_0_0->setInstName ("0");
  a_FCSI_SSI_en_ssi_in_0_0->setLongName ("");
  a_FCSI_SSI_en_ssi_in_0_0->setDescription ("");
  a_FCSI_SSI_en_ssi_in_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_en_ssi_in_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_en_ssi_in->connectAttribute (a_FCSI_SSI_en_ssi_in_0_0);

  RField* f_FCSI_SSI_en_supplymon_in = new RField;
  f_FCSI_SSI_en_supplymon_in->setInstName ("en_supplymon_in");
  f_FCSI_SSI_en_supplymon_in->setLongName ("EN SUPPLYMON IN");
  f_FCSI_SSI_en_supplymon_in->setDescription ("Enable supply monitor as input");
  f_FCSI_SSI_en_supplymon_in->setDataWidth (1);
  f_FCSI_SSI_en_supplymon_in->setResetVal ("1'b0");
  f_FCSI_SSI_en_supplymon_in->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_en_supplymon_in, 8);

  Attribute* a_FCSI_SSI_en_supplymon_in_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_en_supplymon_in_0_0->setInstName ("0");
  a_FCSI_SSI_en_supplymon_in_0_0->setLongName ("");
  a_FCSI_SSI_en_supplymon_in_0_0->setDescription ("");
  a_FCSI_SSI_en_supplymon_in_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_en_supplymon_in_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_en_supplymon_in->connectAttribute (a_FCSI_SSI_en_supplymon_in_0_0);

  RField* f_FCSI_SSI_ctl_ib = new RField;
  f_FCSI_SSI_ctl_ib->setInstName ("ctl_ib");
  f_FCSI_SSI_ctl_ib->setLongName ("CTL IB");
  f_FCSI_SSI_ctl_ib->setDescription ("Control current in output stage of OpAmp");
  f_FCSI_SSI_ctl_ib->setDataWidth (2);
  f_FCSI_SSI_ctl_ib->setResetVal ("2'b00");
  f_FCSI_SSI_ctl_ib->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_ctl_ib, 9);

  Attribute* a_FCSI_SSI_ctl_ib_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_ctl_ib_0_0->setInstName ("0");
  a_FCSI_SSI_ctl_ib_0_0->setLongName ("");
  a_FCSI_SSI_ctl_ib_0_0->setDescription ("");
  a_FCSI_SSI_ctl_ib_0_0->addItem("0", "2'b00", "650uA");
  a_FCSI_SSI_ctl_ib_0_0->addItem("1", "2'b01", "750uA");
  a_FCSI_SSI_ctl_ib_0_0->addItem("2", "2'b10", "550uA");
  a_FCSI_SSI_ctl_ib_0_0->addItem("3", "2'b11", "650uA");
  f_FCSI_SSI_ctl_ib->connectAttribute (a_FCSI_SSI_ctl_ib_0_0);

  RField* f_FCSI_SSI_enable_rssi_loop = new RField;
  f_FCSI_SSI_enable_rssi_loop->setInstName ("enable_rssi_loop");
  f_FCSI_SSI_enable_rssi_loop->setLongName ("ENABLE RSSI LOOP");
  f_FCSI_SSI_enable_rssi_loop->setDescription ("Enable RSSI loop");
  f_FCSI_SSI_enable_rssi_loop->setDataWidth (1);
  f_FCSI_SSI_enable_rssi_loop->setResetVal ("1'b0");
  f_FCSI_SSI_enable_rssi_loop->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_enable_rssi_loop, 11);

  Attribute* a_FCSI_SSI_enable_rssi_loop_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_enable_rssi_loop_0_0->setInstName ("0");
  a_FCSI_SSI_enable_rssi_loop_0_0->setLongName ("");
  a_FCSI_SSI_enable_rssi_loop_0_0->setDescription ("");
  a_FCSI_SSI_enable_rssi_loop_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_enable_rssi_loop_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_enable_rssi_loop->connectAttribute (a_FCSI_SSI_enable_rssi_loop_0_0);

  RField* f_FCSI_SSI_ctl_rssi_loop = new RField;
  f_FCSI_SSI_ctl_rssi_loop->setInstName ("ctl_rssi_loop");
  f_FCSI_SSI_ctl_rssi_loop->setLongName ("CTL RSSI LOOP");
  f_FCSI_SSI_ctl_rssi_loop->setDescription ("Control RSSI loop");
  f_FCSI_SSI_ctl_rssi_loop->setDataWidth (1);
  f_FCSI_SSI_ctl_rssi_loop->setResetVal ("1'b0");
  f_FCSI_SSI_ctl_rssi_loop->setAccProp (AccProp::RW);
  r_FCSI_SSI->connectRField (f_FCSI_SSI_ctl_rssi_loop, 12);

  Attribute* a_FCSI_SSI_ctl_rssi_loop_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_SSI_ctl_rssi_loop_0_0->setInstName ("0");
  a_FCSI_SSI_ctl_rssi_loop_0_0->setLongName ("");
  a_FCSI_SSI_ctl_rssi_loop_0_0->setDescription ("");
  a_FCSI_SSI_ctl_rssi_loop_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_SSI_ctl_rssi_loop_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_SSI_ctl_rssi_loop->connectAttribute (a_FCSI_SSI_ctl_rssi_loop_0_0);

  Register* r_FCSI_VDDMON = new Register;
  r_FCSI_VDDMON->setInstName ("VDDMON");
  r_FCSI_VDDMON->setLongName ("VDD MONITOR");
  r_FCSI_VDDMON->setDescription ("BB-LDO1V2");
  r_FCSI_VDDMON->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_VDDMON, 0x0000001E);

  RField* f_FCSI_VDDMON_en_opamps = new RField;
  f_FCSI_VDDMON_en_opamps->setInstName ("en_opamps");
  f_FCSI_VDDMON_en_opamps->setLongName ("EN OPAMPS");
  f_FCSI_VDDMON_en_opamps->setDescription ("Enable supply monitor opamps");
  f_FCSI_VDDMON_en_opamps->setDataWidth (1);
  f_FCSI_VDDMON_en_opamps->setResetVal ("1'b0");
  f_FCSI_VDDMON_en_opamps->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_en_opamps, 0);

  Attribute* a_FCSI_VDDMON_en_opamps_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_en_opamps_0_0->setInstName ("0");
  a_FCSI_VDDMON_en_opamps_0_0->setLongName ("");
  a_FCSI_VDDMON_en_opamps_0_0->setDescription ("");
  a_FCSI_VDDMON_en_opamps_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_en_opamps_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_en_opamps->connectAttribute (a_FCSI_VDDMON_en_opamps_0_0);

  RField* f_FCSI_VDDMON_en_chopping = new RField;
  f_FCSI_VDDMON_en_chopping->setInstName ("en_chopping");
  f_FCSI_VDDMON_en_chopping->setLongName ("EN CHOPPING");
  f_FCSI_VDDMON_en_chopping->setDescription ("Enable chopping of the opamp inputs");
  f_FCSI_VDDMON_en_chopping->setDataWidth (1);
  f_FCSI_VDDMON_en_chopping->setResetVal ("1'b0");
  f_FCSI_VDDMON_en_chopping->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_en_chopping, 1);

  Attribute* a_FCSI_VDDMON_en_chopping_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_en_chopping_0_0->setInstName ("0");
  a_FCSI_VDDMON_en_chopping_0_0->setLongName ("");
  a_FCSI_VDDMON_en_chopping_0_0->setDescription ("");
  a_FCSI_VDDMON_en_chopping_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_en_chopping_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_en_chopping->connectAttribute (a_FCSI_VDDMON_en_chopping_0_0);

  RField* f_FCSI_VDDMON_ctl_hbldo = new RField;
  f_FCSI_VDDMON_ctl_hbldo->setInstName ("ctl_hbldo");
  f_FCSI_VDDMON_ctl_hbldo->setLongName ("CTL HB LDO");
  f_FCSI_VDDMON_ctl_hbldo->setDescription ("Switch HB LDO to buffer");
  f_FCSI_VDDMON_ctl_hbldo->setDataWidth (1);
  f_FCSI_VDDMON_ctl_hbldo->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_hbldo->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_hbldo, 2);

  Attribute* a_FCSI_VDDMON_ctl_hbldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_hbldo_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_hbldo_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_hbldo_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_hbldo_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_hbldo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_hbldo->connectAttribute (a_FCSI_VDDMON_ctl_hbldo_0_0);

  RField* f_FCSI_VDDMON_ctl_lbldo = new RField;
  f_FCSI_VDDMON_ctl_lbldo->setInstName ("ctl_lbldo");
  f_FCSI_VDDMON_ctl_lbldo->setLongName ("CTL LB LDO");
  f_FCSI_VDDMON_ctl_lbldo->setDescription ("Switch LB LDO to buffer");
  f_FCSI_VDDMON_ctl_lbldo->setDataWidth (1);
  f_FCSI_VDDMON_ctl_lbldo->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_lbldo->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_lbldo, 3);

  Attribute* a_FCSI_VDDMON_ctl_lbldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_lbldo_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_lbldo_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_lbldo_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_lbldo_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_lbldo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_lbldo->connectAttribute (a_FCSI_VDDMON_ctl_lbldo_0_0);

  RField* f_FCSI_VDDMON_ctl_bbldo = new RField;
  f_FCSI_VDDMON_ctl_bbldo->setInstName ("ctl_bbldo");
  f_FCSI_VDDMON_ctl_bbldo->setLongName ("CTL BB LDO");
  f_FCSI_VDDMON_ctl_bbldo->setDescription ("Switch BB LDO to buffer");
  f_FCSI_VDDMON_ctl_bbldo->setDataWidth (1);
  f_FCSI_VDDMON_ctl_bbldo->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_bbldo->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_bbldo, 4);

  Attribute* a_FCSI_VDDMON_ctl_bbldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_bbldo_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_bbldo_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_bbldo_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_bbldo_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_bbldo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_bbldo->connectAttribute (a_FCSI_VDDMON_ctl_bbldo_0_0);

  RField* f_FCSI_VDDMON_ctl_rxldo = new RField;
  f_FCSI_VDDMON_ctl_rxldo->setInstName ("ctl_rxldo");
  f_FCSI_VDDMON_ctl_rxldo->setLongName ("CTL RX LDO");
  f_FCSI_VDDMON_ctl_rxldo->setDescription ("Switch RX LDO to buffer");
  f_FCSI_VDDMON_ctl_rxldo->setDataWidth (1);
  f_FCSI_VDDMON_ctl_rxldo->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_rxldo->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_rxldo, 5);

  Attribute* a_FCSI_VDDMON_ctl_rxldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_rxldo_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_rxldo_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_rxldo_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_rxldo_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_rxldo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_rxldo->connectAttribute (a_FCSI_VDDMON_ctl_rxldo_0_0);

  RField* f_FCSI_VDDMON_ctl_2v5ldo = new RField;
  f_FCSI_VDDMON_ctl_2v5ldo->setInstName ("ctl_2v5ldo");
  f_FCSI_VDDMON_ctl_2v5ldo->setLongName ("CTL 2V5 LDO");
  f_FCSI_VDDMON_ctl_2v5ldo->setDescription ("Switch 2V5 LDO to buffer");
  f_FCSI_VDDMON_ctl_2v5ldo->setDataWidth (1);
  f_FCSI_VDDMON_ctl_2v5ldo->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_2v5ldo->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_2v5ldo, 6);

  Attribute* a_FCSI_VDDMON_ctl_2v5ldo_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_2v5ldo_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_2v5ldo_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_2v5ldo_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_2v5ldo_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_2v5ldo_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_2v5ldo->connectAttribute (a_FCSI_VDDMON_ctl_2v5ldo_0_0);

  RField* f_FCSI_VDDMON_ctl_1v5ldo_in = new RField;
  f_FCSI_VDDMON_ctl_1v5ldo_in->setInstName ("ctl_1v5ldo_in");
  f_FCSI_VDDMON_ctl_1v5ldo_in->setLongName ("CTL 1V5 LDO IN");
  f_FCSI_VDDMON_ctl_1v5ldo_in->setDescription ("Switch 1V5 LDO input supply to buffer");
  f_FCSI_VDDMON_ctl_1v5ldo_in->setDataWidth (1);
  f_FCSI_VDDMON_ctl_1v5ldo_in->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_1v5ldo_in->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_1v5ldo_in, 7);

  Attribute* a_FCSI_VDDMON_ctl_1v5ldo_in_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_1v5ldo_in_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_1v5ldo_in_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_1v5ldo_in_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_1v5ldo_in_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_1v5ldo_in_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_1v5ldo_in->connectAttribute (a_FCSI_VDDMON_ctl_1v5ldo_in_0_0);

  RField* f_FCSI_VDDMON_ctl_3v3ldo_in = new RField;
  f_FCSI_VDDMON_ctl_3v3ldo_in->setInstName ("ctl_3v3ldo_in");
  f_FCSI_VDDMON_ctl_3v3ldo_in->setLongName ("CTL 3V3 LDO IN");
  f_FCSI_VDDMON_ctl_3v3ldo_in->setDescription ("Switch 3V3 LDO input supply to buffer");
  f_FCSI_VDDMON_ctl_3v3ldo_in->setDataWidth (1);
  f_FCSI_VDDMON_ctl_3v3ldo_in->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_3v3ldo_in->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_3v3ldo_in, 8);

  Attribute* a_FCSI_VDDMON_ctl_3v3ldo_in_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_3v3ldo_in_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_3v3ldo_in_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_3v3ldo_in_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_3v3ldo_in_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_3v3ldo_in_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_3v3ldo_in->connectAttribute (a_FCSI_VDDMON_ctl_3v3ldo_in_0_0);

  RField* f_FCSI_VDDMON_ctl_tssi_in = new RField;
  f_FCSI_VDDMON_ctl_tssi_in->setInstName ("ctl_tssi_in");
  f_FCSI_VDDMON_ctl_tssi_in->setLongName ("CTL TSSI IN");
  f_FCSI_VDDMON_ctl_tssi_in->setDescription ("Open connection from TSSI input");
  f_FCSI_VDDMON_ctl_tssi_in->setDataWidth (1);
  f_FCSI_VDDMON_ctl_tssi_in->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_tssi_in->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_tssi_in, 9);

  Attribute* a_FCSI_VDDMON_ctl_tssi_in_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_tssi_in_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_tssi_in_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_tssi_in_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_tssi_in_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_tssi_in_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_tssi_in->connectAttribute (a_FCSI_VDDMON_ctl_tssi_in_0_0);

  RField* f_FCSI_VDDMON_ctl_1v5ldo_current = new RField;
  f_FCSI_VDDMON_ctl_1v5ldo_current->setInstName ("ctl_1v5ldo_current");
  f_FCSI_VDDMON_ctl_1v5ldo_current->setLongName ("CTL 1V5 LDO CURRENT");
  f_FCSI_VDDMON_ctl_1v5ldo_current->setDescription ("Open connection from 1V5 LDO input supply");
  f_FCSI_VDDMON_ctl_1v5ldo_current->setDataWidth (1);
  f_FCSI_VDDMON_ctl_1v5ldo_current->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_1v5ldo_current->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_1v5ldo_current, 10);

  Attribute* a_FCSI_VDDMON_ctl_1v5ldo_current_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_1v5ldo_current_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_1v5ldo_current_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_1v5ldo_current_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_1v5ldo_current_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_1v5ldo_current_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_1v5ldo_current->connectAttribute (a_FCSI_VDDMON_ctl_1v5ldo_current_0_0);

  RField* f_FCSI_VDDMON_ctl_3v3ldo_current = new RField;
  f_FCSI_VDDMON_ctl_3v3ldo_current->setInstName ("ctl_3v3ldo_current");
  f_FCSI_VDDMON_ctl_3v3ldo_current->setLongName ("CTL 3V3 LDO CURRENT");
  f_FCSI_VDDMON_ctl_3v3ldo_current->setDescription ("Open connection from 3V3 LDO input supply");
  f_FCSI_VDDMON_ctl_3v3ldo_current->setDataWidth (1);
  f_FCSI_VDDMON_ctl_3v3ldo_current->setResetVal ("1'b0");
  f_FCSI_VDDMON_ctl_3v3ldo_current->setAccProp (AccProp::RW);
  r_FCSI_VDDMON->connectRField (f_FCSI_VDDMON_ctl_3v3ldo_current, 11);

  Attribute* a_FCSI_VDDMON_ctl_3v3ldo_current_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VDDMON_ctl_3v3ldo_current_0_0->setInstName ("0");
  a_FCSI_VDDMON_ctl_3v3ldo_current_0_0->setLongName ("");
  a_FCSI_VDDMON_ctl_3v3ldo_current_0_0->setDescription ("");
  a_FCSI_VDDMON_ctl_3v3ldo_current_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VDDMON_ctl_3v3ldo_current_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VDDMON_ctl_3v3ldo_current->connectAttribute (a_FCSI_VDDMON_ctl_3v3ldo_current_0_0);

  Register* r_FCSI_LOLOCAL = new Register;
  r_FCSI_LOLOCAL->setInstName ("LOLOCAL");
  r_FCSI_LOLOCAL->setLongName ("LO LOCAL");
  r_FCSI_LOLOCAL->setDescription ("BB-LDO1V2");
  r_FCSI_LOLOCAL->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_LOLOCAL, 0x0000001F);

  RField* f_FCSI_LOLOCAL_ctl_i2v = new RField;
  f_FCSI_LOLOCAL_ctl_i2v->setInstName ("ctl_i2v");
  f_FCSI_LOLOCAL_ctl_i2v->setLongName ("CTL I2V");
  f_FCSI_LOLOCAL_ctl_i2v->setDescription ("Control I2V");
  f_FCSI_LOLOCAL_ctl_i2v->setDataWidth (1);
  f_FCSI_LOLOCAL_ctl_i2v->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_ctl_i2v->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_ctl_i2v, 0);

  Attribute* a_FCSI_LOLOCAL_ctl_i2v_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_ctl_i2v_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_ctl_i2v_0_0->setLongName ("");
  a_FCSI_LOLOCAL_ctl_i2v_0_0->setDescription ("");
  a_FCSI_LOLOCAL_ctl_i2v_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_ctl_i2v_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_ctl_i2v->connectAttribute (a_FCSI_LOLOCAL_ctl_i2v_0_0);

  RField* f_FCSI_LOLOCAL_enable_i2v = new RField;
  f_FCSI_LOLOCAL_enable_i2v->setInstName ("enable_i2v");
  f_FCSI_LOLOCAL_enable_i2v->setLongName ("ENABLE I2V");
  f_FCSI_LOLOCAL_enable_i2v->setDescription ("Enable I2V");
  f_FCSI_LOLOCAL_enable_i2v->setDataWidth (1);
  f_FCSI_LOLOCAL_enable_i2v->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_enable_i2v->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_enable_i2v, 1);

  Attribute* a_FCSI_LOLOCAL_enable_i2v_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_enable_i2v_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_enable_i2v_0_0->setLongName ("");
  a_FCSI_LOLOCAL_enable_i2v_0_0->setDescription ("");
  a_FCSI_LOLOCAL_enable_i2v_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_enable_i2v_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_enable_i2v->connectAttribute (a_FCSI_LOLOCAL_enable_i2v_0_0);

  RField* f_FCSI_LOLOCAL_ctl_rxbuf = new RField;
  f_FCSI_LOLOCAL_ctl_rxbuf->setInstName ("ctl_rxbuf");
  f_FCSI_LOLOCAL_ctl_rxbuf->setLongName ("CTL RXBUF");
  f_FCSI_LOLOCAL_ctl_rxbuf->setDescription ("Control RX buffer");
  f_FCSI_LOLOCAL_ctl_rxbuf->setDataWidth (1);
  f_FCSI_LOLOCAL_ctl_rxbuf->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_ctl_rxbuf->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_ctl_rxbuf, 2);

  Attribute* a_FCSI_LOLOCAL_ctl_rxbuf_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_ctl_rxbuf_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_ctl_rxbuf_0_0->setLongName ("");
  a_FCSI_LOLOCAL_ctl_rxbuf_0_0->setDescription ("");
  a_FCSI_LOLOCAL_ctl_rxbuf_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_ctl_rxbuf_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_ctl_rxbuf->connectAttribute (a_FCSI_LOLOCAL_ctl_rxbuf_0_0);

  RField* f_FCSI_LOLOCAL_ctl_txbuf = new RField;
  f_FCSI_LOLOCAL_ctl_txbuf->setInstName ("ctl_txbuf");
  f_FCSI_LOLOCAL_ctl_txbuf->setLongName ("CTL TXBUF");
  f_FCSI_LOLOCAL_ctl_txbuf->setDescription ("Control TX buffer");
  f_FCSI_LOLOCAL_ctl_txbuf->setDataWidth (1);
  f_FCSI_LOLOCAL_ctl_txbuf->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_ctl_txbuf->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_ctl_txbuf, 3);

  Attribute* a_FCSI_LOLOCAL_ctl_txbuf_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_ctl_txbuf_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_ctl_txbuf_0_0->setLongName ("");
  a_FCSI_LOLOCAL_ctl_txbuf_0_0->setDescription ("");
  a_FCSI_LOLOCAL_ctl_txbuf_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_ctl_txbuf_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_ctl_txbuf->connectAttribute (a_FCSI_LOLOCAL_ctl_txbuf_0_0);

  RField* f_FCSI_LOLOCAL_enable_txbuf1 = new RField;
  f_FCSI_LOLOCAL_enable_txbuf1->setInstName ("enable_txbuf1");
  f_FCSI_LOLOCAL_enable_txbuf1->setLongName ("ENABLE TXBUF1");
  f_FCSI_LOLOCAL_enable_txbuf1->setDescription ("Enable TX buffer1");
  f_FCSI_LOLOCAL_enable_txbuf1->setDataWidth (1);
  f_FCSI_LOLOCAL_enable_txbuf1->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_enable_txbuf1->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_enable_txbuf1, 4);

  Attribute* a_FCSI_LOLOCAL_enable_txbuf1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_enable_txbuf1_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_enable_txbuf1_0_0->setLongName ("");
  a_FCSI_LOLOCAL_enable_txbuf1_0_0->setDescription ("");
  a_FCSI_LOLOCAL_enable_txbuf1_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_enable_txbuf1_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_enable_txbuf1->connectAttribute (a_FCSI_LOLOCAL_enable_txbuf1_0_0);

  RField* f_FCSI_LOLOCAL_enable_txbuf2 = new RField;
  f_FCSI_LOLOCAL_enable_txbuf2->setInstName ("enable_txbuf2");
  f_FCSI_LOLOCAL_enable_txbuf2->setLongName ("ENABLE TXBUF2");
  f_FCSI_LOLOCAL_enable_txbuf2->setDescription ("Enable TX buffer2");
  f_FCSI_LOLOCAL_enable_txbuf2->setDataWidth (1);
  f_FCSI_LOLOCAL_enable_txbuf2->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_enable_txbuf2->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_enable_txbuf2, 5);

  Attribute* a_FCSI_LOLOCAL_enable_txbuf2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_enable_txbuf2_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_enable_txbuf2_0_0->setLongName ("");
  a_FCSI_LOLOCAL_enable_txbuf2_0_0->setDescription ("");
  a_FCSI_LOLOCAL_enable_txbuf2_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_enable_txbuf2_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_enable_txbuf2->connectAttribute (a_FCSI_LOLOCAL_enable_txbuf2_0_0);

  RField* f_FCSI_LOLOCAL_enable_rxbuf1 = new RField;
  f_FCSI_LOLOCAL_enable_rxbuf1->setInstName ("enable_rxbuf1");
  f_FCSI_LOLOCAL_enable_rxbuf1->setLongName ("ENABLE RXBUF1");
  f_FCSI_LOLOCAL_enable_rxbuf1->setDescription ("Enable RX buffer1");
  f_FCSI_LOLOCAL_enable_rxbuf1->setDataWidth (1);
  f_FCSI_LOLOCAL_enable_rxbuf1->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_enable_rxbuf1->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_enable_rxbuf1, 6);

  Attribute* a_FCSI_LOLOCAL_enable_rxbuf1_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_enable_rxbuf1_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_enable_rxbuf1_0_0->setLongName ("");
  a_FCSI_LOLOCAL_enable_rxbuf1_0_0->setDescription ("");
  a_FCSI_LOLOCAL_enable_rxbuf1_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_enable_rxbuf1_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_enable_rxbuf1->connectAttribute (a_FCSI_LOLOCAL_enable_rxbuf1_0_0);

  RField* f_FCSI_LOLOCAL_enable_rxbuf2 = new RField;
  f_FCSI_LOLOCAL_enable_rxbuf2->setInstName ("enable_rxbuf2");
  f_FCSI_LOLOCAL_enable_rxbuf2->setLongName ("ENABLE RXBUF2");
  f_FCSI_LOLOCAL_enable_rxbuf2->setDescription ("Enable RX buffer2");
  f_FCSI_LOLOCAL_enable_rxbuf2->setDataWidth (1);
  f_FCSI_LOLOCAL_enable_rxbuf2->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_enable_rxbuf2->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_enable_rxbuf2, 7);

  Attribute* a_FCSI_LOLOCAL_enable_rxbuf2_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_enable_rxbuf2_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_enable_rxbuf2_0_0->setLongName ("");
  a_FCSI_LOLOCAL_enable_rxbuf2_0_0->setDescription ("");
  a_FCSI_LOLOCAL_enable_rxbuf2_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_enable_rxbuf2_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_enable_rxbuf2->connectAttribute (a_FCSI_LOLOCAL_enable_rxbuf2_0_0);

  RField* f_FCSI_LOLOCAL_ctl_txbuf_lb = new RField;
  f_FCSI_LOLOCAL_ctl_txbuf_lb->setInstName ("ctl_txbuf_lb");
  f_FCSI_LOLOCAL_ctl_txbuf_lb->setLongName ("CTL TX BUF LB");
  f_FCSI_LOLOCAL_ctl_txbuf_lb->setDescription ("Control TX buffer LB");
  f_FCSI_LOLOCAL_ctl_txbuf_lb->setDataWidth (1);
  f_FCSI_LOLOCAL_ctl_txbuf_lb->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_ctl_txbuf_lb->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_ctl_txbuf_lb, 8);

  Attribute* a_FCSI_LOLOCAL_ctl_txbuf_lb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_ctl_txbuf_lb_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_ctl_txbuf_lb_0_0->setLongName ("");
  a_FCSI_LOLOCAL_ctl_txbuf_lb_0_0->setDescription ("");
  a_FCSI_LOLOCAL_ctl_txbuf_lb_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_ctl_txbuf_lb_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_ctl_txbuf_lb->connectAttribute (a_FCSI_LOLOCAL_ctl_txbuf_lb_0_0);

  RField* f_FCSI_LOLOCAL_enable_txbuf_lb = new RField;
  f_FCSI_LOLOCAL_enable_txbuf_lb->setInstName ("enable_txbuf_lb");
  f_FCSI_LOLOCAL_enable_txbuf_lb->setLongName ("ENABLE TX BUF LB");
  f_FCSI_LOLOCAL_enable_txbuf_lb->setDescription ("Enable TX buffer LB");
  f_FCSI_LOLOCAL_enable_txbuf_lb->setDataWidth (1);
  f_FCSI_LOLOCAL_enable_txbuf_lb->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_enable_txbuf_lb->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_enable_txbuf_lb, 9);

  Attribute* a_FCSI_LOLOCAL_enable_txbuf_lb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_enable_txbuf_lb_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_enable_txbuf_lb_0_0->setLongName ("");
  a_FCSI_LOLOCAL_enable_txbuf_lb_0_0->setDescription ("");
  a_FCSI_LOLOCAL_enable_txbuf_lb_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_enable_txbuf_lb_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_enable_txbuf_lb->connectAttribute (a_FCSI_LOLOCAL_enable_txbuf_lb_0_0);

  RField* f_FCSI_LOLOCAL_ctl_rxbuf_lb = new RField;
  f_FCSI_LOLOCAL_ctl_rxbuf_lb->setInstName ("ctl_rxbuf_lb");
  f_FCSI_LOLOCAL_ctl_rxbuf_lb->setLongName ("CTL RX BUF LB");
  f_FCSI_LOLOCAL_ctl_rxbuf_lb->setDescription ("Control RX buffer LB");
  f_FCSI_LOLOCAL_ctl_rxbuf_lb->setDataWidth (1);
  f_FCSI_LOLOCAL_ctl_rxbuf_lb->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_ctl_rxbuf_lb->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_ctl_rxbuf_lb, 10);

  Attribute* a_FCSI_LOLOCAL_ctl_rxbuf_lb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_ctl_rxbuf_lb_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_ctl_rxbuf_lb_0_0->setLongName ("");
  a_FCSI_LOLOCAL_ctl_rxbuf_lb_0_0->setDescription ("");
  a_FCSI_LOLOCAL_ctl_rxbuf_lb_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_ctl_rxbuf_lb_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_ctl_rxbuf_lb->connectAttribute (a_FCSI_LOLOCAL_ctl_rxbuf_lb_0_0);

  RField* f_FCSI_LOLOCAL_enable_rxbuf_lb = new RField;
  f_FCSI_LOLOCAL_enable_rxbuf_lb->setInstName ("enable_rxbuf_lb");
  f_FCSI_LOLOCAL_enable_rxbuf_lb->setLongName ("ENABLE RX BUF LB");
  f_FCSI_LOLOCAL_enable_rxbuf_lb->setDescription ("Enable RX buffer LB");
  f_FCSI_LOLOCAL_enable_rxbuf_lb->setDataWidth (1);
  f_FCSI_LOLOCAL_enable_rxbuf_lb->setResetVal ("1'b0");
  f_FCSI_LOLOCAL_enable_rxbuf_lb->setAccProp (AccProp::RW);
  r_FCSI_LOLOCAL->connectRField (f_FCSI_LOLOCAL_enable_rxbuf_lb, 11);

  Attribute* a_FCSI_LOLOCAL_enable_rxbuf_lb_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_LOLOCAL_enable_rxbuf_lb_0_0->setInstName ("0");
  a_FCSI_LOLOCAL_enable_rxbuf_lb_0_0->setLongName ("");
  a_FCSI_LOLOCAL_enable_rxbuf_lb_0_0->setDescription ("");
  a_FCSI_LOLOCAL_enable_rxbuf_lb_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_LOLOCAL_enable_rxbuf_lb_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_LOLOCAL_enable_rxbuf_lb->connectAttribute (a_FCSI_LOLOCAL_enable_rxbuf_lb_0_0);

  Register* r_FCSI_RSSI0 = new Register;
  r_FCSI_RSSI0->setInstName ("RSSI0");
  r_FCSI_RSSI0->setLongName ("RSSI0");
  r_FCSI_RSSI0->setDescription ("BB-LDO1V2");
  r_FCSI_RSSI0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RSSI0, 0x00000020);

  RField* f_FCSI_RSSI0_s2d_offset = new RField;
  f_FCSI_RSSI0_s2d_offset->setInstName ("s2d_offset");
  f_FCSI_RSSI0_s2d_offset->setLongName ("S2D OFFSET");
  f_FCSI_RSSI0_s2d_offset->setDescription ("Single to differential offset");
  f_FCSI_RSSI0_s2d_offset->setDataWidth (5);
  f_FCSI_RSSI0_s2d_offset->setResetVal ("5'b00000");
  f_FCSI_RSSI0_s2d_offset->setAccProp (AccProp::RW);
  r_FCSI_RSSI0->connectRField (f_FCSI_RSSI0_s2d_offset, 0);

  Attribute* a_FCSI_RSSI0_s2d_offset_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSI0_s2d_offset_0_0->setInstName ("0");
  a_FCSI_RSSI0_s2d_offset_0_0->setLongName ("");
  a_FCSI_RSSI0_s2d_offset_0_0->setDescription ("");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("0", "5'b00000", "0");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("1", "5'b00001", "5uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("2", "5'b00010", "10uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("3", "5'b00011", "15uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("4", "5'b00100", "20uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("5", "5'b00101", "25uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("6", "5'b00110", "30uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("7", "5'b00111", "35uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("8", "5'b01000", "40uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("9", "5'b01001", "45uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("10", "5'b01010", "50uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("11", "5'b01011", "55uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("12", "5'b01100", "60uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("13", "5'b01101", "65uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("14", "5'b01110", "70uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("15", "5'b01111", "75uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("16", "5'b10000", "80uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("17", "5'b10001", "85uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("18", "5'b10010", "90uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("19", "5'b10011", "95uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("20", "5'b10100", "100uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("21", "5'b10101", "105uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("22", "5'b10110", "110uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("23", "5'b10111", "115uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("24", "5'b11000", "120uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("25", "5'b11001", "125uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("26", "5'b11010", "130uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("27", "5'b11011", "135uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("28", "5'b11100", "140uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("29", "5'b11101", "145uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("30", "5'b11110", "150uA");
  a_FCSI_RSSI0_s2d_offset_0_0->addItem("31", "5'b11111", "155uA");
  f_FCSI_RSSI0_s2d_offset->connectAttribute (a_FCSI_RSSI0_s2d_offset_0_0);

  RField* f_FCSI_RSSI0_s2d_gain = new RField;
  f_FCSI_RSSI0_s2d_gain->setInstName ("s2d_gain");
  f_FCSI_RSSI0_s2d_gain->setLongName ("S2D GAIN");
  f_FCSI_RSSI0_s2d_gain->setDescription ("Single to differential gain");
  f_FCSI_RSSI0_s2d_gain->setDataWidth (4);
  f_FCSI_RSSI0_s2d_gain->setResetVal ("4'b0000");
  f_FCSI_RSSI0_s2d_gain->setAccProp (AccProp::RW);
  r_FCSI_RSSI0->connectRField (f_FCSI_RSSI0_s2d_gain, 5);

  Attribute* a_FCSI_RSSI0_s2d_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSI0_s2d_gain_0_0->setInstName ("0");
  a_FCSI_RSSI0_s2d_gain_0_0->setLongName ("");
  a_FCSI_RSSI0_s2d_gain_0_0->setDescription ("");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("0", "4'b0000", "-10dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("1", "4'b0001", "-8dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("2", "4'b0010", "-6dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("3", "4'b0011", "-4dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("4", "4'b0100", "-2dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("5", "4'b0101", "0dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("6", "4'b0110", "2dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("7", "4'b0111", "4dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("8", "4'b1000", "6dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("9", "4'b1001", "8dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("10", "4'b1010", "10dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("11", "4'b1011", "12dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("12", "4'b1100", "14dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("13", "4'b1101", "16dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("14", "4'b1110", "18dB");
  a_FCSI_RSSI0_s2d_gain_0_0->addItem("15", "4'b1111", "20dB");
  f_FCSI_RSSI0_s2d_gain->connectAttribute (a_FCSI_RSSI0_s2d_gain_0_0);

  RField* f_FCSI_RSSI0_rssi_det_range = new RField;
  f_FCSI_RSSI0_rssi_det_range->setInstName ("rssi_det_range");
  f_FCSI_RSSI0_rssi_det_range->setLongName ("RSSI DET RANGE");
  f_FCSI_RSSI0_rssi_det_range->setDescription ("RSSI detector range selection (coarse output current selection)");
  f_FCSI_RSSI0_rssi_det_range->setDataWidth (2);
  f_FCSI_RSSI0_rssi_det_range->setResetVal ("2'b00");
  f_FCSI_RSSI0_rssi_det_range->setAccProp (AccProp::RW);
  r_FCSI_RSSI0->connectRField (f_FCSI_RSSI0_rssi_det_range, 9);

  Attribute* a_FCSI_RSSI0_rssi_det_range_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSI0_rssi_det_range_0_0->setInstName ("0");
  a_FCSI_RSSI0_rssi_det_range_0_0->setLongName ("");
  a_FCSI_RSSI0_rssi_det_range_0_0->setDescription ("");
  a_FCSI_RSSI0_rssi_det_range_0_0->addItem("3", "2'b11", "-200uA");
  a_FCSI_RSSI0_rssi_det_range_0_0->addItem("2", "2'b10", "-100uA");
  a_FCSI_RSSI0_rssi_det_range_0_0->addItem("1", "2'b01", "0uA");
  a_FCSI_RSSI0_rssi_det_range_0_0->addItem("0", "2'b00", "75uA");
  f_FCSI_RSSI0_rssi_det_range->connectAttribute (a_FCSI_RSSI0_rssi_det_range_0_0);

  Register* r_FCSI_RSSI1 = new Register;
  r_FCSI_RSSI1->setInstName ("RSSI1");
  r_FCSI_RSSI1->setLongName ("RSSI1");
  r_FCSI_RSSI1->setDescription ("BB-LDO1V2");
  r_FCSI_RSSI1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RSSI1, 0x00000021);

  RField* f_FCSI_RSSI1_s2d_offset = new RField;
  f_FCSI_RSSI1_s2d_offset->setInstName ("s2d_offset");
  f_FCSI_RSSI1_s2d_offset->setLongName ("S2D OFFSET");
  f_FCSI_RSSI1_s2d_offset->setDescription ("Single to differential offset");
  f_FCSI_RSSI1_s2d_offset->setDataWidth (5);
  f_FCSI_RSSI1_s2d_offset->setResetVal ("5'b00000");
  f_FCSI_RSSI1_s2d_offset->setAccProp (AccProp::RW);
  r_FCSI_RSSI1->connectRField (f_FCSI_RSSI1_s2d_offset, 0);

  Attribute* a_FCSI_RSSI1_s2d_offset_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSI1_s2d_offset_0_0->setInstName ("0");
  a_FCSI_RSSI1_s2d_offset_0_0->setLongName ("");
  a_FCSI_RSSI1_s2d_offset_0_0->setDescription ("");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("0", "5'b00000", "0");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("1", "5'b00001", "5uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("2", "5'b00010", "10uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("3", "5'b00011", "15uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("4", "5'b00100", "20uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("5", "5'b00101", "25uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("6", "5'b00110", "30uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("7", "5'b00111", "35uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("8", "5'b01000", "40uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("9", "5'b01001", "45uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("10", "5'b01010", "50uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("11", "5'b01011", "55uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("12", "5'b01100", "60uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("13", "5'b01101", "65uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("14", "5'b01110", "70uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("15", "5'b01111", "75uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("16", "5'b10000", "80uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("17", "5'b10001", "85uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("18", "5'b10010", "90uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("19", "5'b10011", "95uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("20", "5'b10100", "100uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("21", "5'b10101", "105uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("22", "5'b10110", "110uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("23", "5'b10111", "115uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("24", "5'b11000", "120uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("25", "5'b11001", "125uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("26", "5'b11010", "130uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("27", "5'b11011", "135uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("28", "5'b11100", "140uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("29", "5'b11101", "145uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("30", "5'b11110", "150uA");
  a_FCSI_RSSI1_s2d_offset_0_0->addItem("31", "5'b11111", "155uA");
  f_FCSI_RSSI1_s2d_offset->connectAttribute (a_FCSI_RSSI1_s2d_offset_0_0);

  RField* f_FCSI_RSSI1_s2d_gain = new RField;
  f_FCSI_RSSI1_s2d_gain->setInstName ("s2d_gain");
  f_FCSI_RSSI1_s2d_gain->setLongName ("S2D GAIN");
  f_FCSI_RSSI1_s2d_gain->setDescription ("Single to differential gain");
  f_FCSI_RSSI1_s2d_gain->setDataWidth (4);
  f_FCSI_RSSI1_s2d_gain->setResetVal ("4'b0000");
  f_FCSI_RSSI1_s2d_gain->setAccProp (AccProp::RW);
  r_FCSI_RSSI1->connectRField (f_FCSI_RSSI1_s2d_gain, 5);

  Attribute* a_FCSI_RSSI1_s2d_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSI1_s2d_gain_0_0->setInstName ("0");
  a_FCSI_RSSI1_s2d_gain_0_0->setLongName ("");
  a_FCSI_RSSI1_s2d_gain_0_0->setDescription ("");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("0", "4'b0000", "-10dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("1", "4'b0001", "-8dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("2", "4'b0010", "-6dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("3", "4'b0011", "-4dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("4", "4'b0100", "-2dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("5", "4'b0101", "0dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("6", "4'b0110", "2dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("7", "4'b0111", "4dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("8", "4'b1000", "6dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("9", "4'b1001", "8dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("10", "4'b1010", "10dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("11", "4'b1011", "12dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("12", "4'b1100", "14dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("13", "4'b1101", "16dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("14", "4'b1110", "18dB");
  a_FCSI_RSSI1_s2d_gain_0_0->addItem("15", "4'b1111", "20dB");
  f_FCSI_RSSI1_s2d_gain->connectAttribute (a_FCSI_RSSI1_s2d_gain_0_0);

  RField* f_FCSI_RSSI1_rssi_det_range = new RField;
  f_FCSI_RSSI1_rssi_det_range->setInstName ("rssi_det_range");
  f_FCSI_RSSI1_rssi_det_range->setLongName ("RSSI DET RANGE");
  f_FCSI_RSSI1_rssi_det_range->setDescription ("RSSI detector range selection (coarse output current selection)");
  f_FCSI_RSSI1_rssi_det_range->setDataWidth (2);
  f_FCSI_RSSI1_rssi_det_range->setResetVal ("2'b00");
  f_FCSI_RSSI1_rssi_det_range->setAccProp (AccProp::RW);
  r_FCSI_RSSI1->connectRField (f_FCSI_RSSI1_rssi_det_range, 9);

  Attribute* a_FCSI_RSSI1_rssi_det_range_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RSSI1_rssi_det_range_0_0->setInstName ("0");
  a_FCSI_RSSI1_rssi_det_range_0_0->setLongName ("");
  a_FCSI_RSSI1_rssi_det_range_0_0->setDescription ("");
  a_FCSI_RSSI1_rssi_det_range_0_0->addItem("3", "2'b11", "-200uA");
  a_FCSI_RSSI1_rssi_det_range_0_0->addItem("2", "2'b10", "-100uA");
  a_FCSI_RSSI1_rssi_det_range_0_0->addItem("1", "2'b01", "0uA");
  a_FCSI_RSSI1_rssi_det_range_0_0->addItem("0", "2'b00", "75uA");
  f_FCSI_RSSI1_rssi_det_range->connectAttribute (a_FCSI_RSSI1_rssi_det_range_0_0);

  Register* r_FCSI_TSSI0 = new Register;
  r_FCSI_TSSI0->setInstName ("TSSI0");
  r_FCSI_TSSI0->setLongName ("TSSI0");
  r_FCSI_TSSI0->setDescription ("BB-LDO1V2");
  r_FCSI_TSSI0->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TSSI0, 0x00000022);

  RField* f_FCSI_TSSI0_s2d_offset = new RField;
  f_FCSI_TSSI0_s2d_offset->setInstName ("s2d_offset");
  f_FCSI_TSSI0_s2d_offset->setLongName ("S2D OFFSET");
  f_FCSI_TSSI0_s2d_offset->setDescription ("Single to differential offset");
  f_FCSI_TSSI0_s2d_offset->setDataWidth (5);
  f_FCSI_TSSI0_s2d_offset->setResetVal ("5'b00000");
  f_FCSI_TSSI0_s2d_offset->setAccProp (AccProp::RW);
  r_FCSI_TSSI0->connectRField (f_FCSI_TSSI0_s2d_offset, 0);

  Attribute* a_FCSI_TSSI0_s2d_offset_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TSSI0_s2d_offset_0_0->setInstName ("0");
  a_FCSI_TSSI0_s2d_offset_0_0->setLongName ("");
  a_FCSI_TSSI0_s2d_offset_0_0->setDescription ("");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("0", "5'b00000", "0");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("1", "5'b00001", "5uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("2", "5'b00010", "10uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("3", "5'b00011", "15uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("4", "5'b00100", "20uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("5", "5'b00101", "25uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("6", "5'b00110", "30uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("7", "5'b00111", "35uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("8", "5'b01000", "40uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("9", "5'b01001", "45uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("10", "5'b01010", "50uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("11", "5'b01011", "55uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("12", "5'b01100", "60uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("13", "5'b01101", "65uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("14", "5'b01110", "70uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("15", "5'b01111", "75uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("16", "5'b10000", "80uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("17", "5'b10001", "85uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("18", "5'b10010", "90uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("19", "5'b10011", "95uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("20", "5'b10100", "100uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("21", "5'b10101", "105uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("22", "5'b10110", "110uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("23", "5'b10111", "115uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("24", "5'b11000", "120uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("25", "5'b11001", "125uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("26", "5'b11010", "130uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("27", "5'b11011", "135uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("28", "5'b11100", "140uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("29", "5'b11101", "145uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("30", "5'b11110", "150uA");
  a_FCSI_TSSI0_s2d_offset_0_0->addItem("31", "5'b11111", "155uA");
  f_FCSI_TSSI0_s2d_offset->connectAttribute (a_FCSI_TSSI0_s2d_offset_0_0);

  RField* f_FCSI_TSSI0_s2d_gain = new RField;
  f_FCSI_TSSI0_s2d_gain->setInstName ("s2d_gain");
  f_FCSI_TSSI0_s2d_gain->setLongName ("S2D GAIN");
  f_FCSI_TSSI0_s2d_gain->setDescription ("Single to differential gain");
  f_FCSI_TSSI0_s2d_gain->setDataWidth (4);
  f_FCSI_TSSI0_s2d_gain->setResetVal ("4'b0000");
  f_FCSI_TSSI0_s2d_gain->setAccProp (AccProp::RW);
  r_FCSI_TSSI0->connectRField (f_FCSI_TSSI0_s2d_gain, 5);

  Attribute* a_FCSI_TSSI0_s2d_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TSSI0_s2d_gain_0_0->setInstName ("0");
  a_FCSI_TSSI0_s2d_gain_0_0->setLongName ("");
  a_FCSI_TSSI0_s2d_gain_0_0->setDescription ("");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("0", "4'b0000", "-10dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("1", "4'b0001", "-8dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("2", "4'b0010", "-6dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("3", "4'b0011", "-4dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("4", "4'b0100", "-2dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("5", "4'b0101", "0dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("6", "4'b0110", "2dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("7", "4'b0111", "4dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("8", "4'b1000", "6dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("9", "4'b1001", "8dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("10", "4'b1010", "10dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("11", "4'b1011", "12dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("12", "4'b1100", "14dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("13", "4'b1101", "16dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("14", "4'b1110", "18dB");
  a_FCSI_TSSI0_s2d_gain_0_0->addItem("15", "4'b1111", "20dB");
  f_FCSI_TSSI0_s2d_gain->connectAttribute (a_FCSI_TSSI0_s2d_gain_0_0);

  Register* r_FCSI_TSSI1 = new Register;
  r_FCSI_TSSI1->setInstName ("TSSI1");
  r_FCSI_TSSI1->setLongName ("TSSI1");
  r_FCSI_TSSI1->setDescription ("BB-LDO1V2");
  r_FCSI_TSSI1->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TSSI1, 0x00000023);

  RField* f_FCSI_TSSI1_s2d_offset = new RField;
  f_FCSI_TSSI1_s2d_offset->setInstName ("s2d_offset");
  f_FCSI_TSSI1_s2d_offset->setLongName ("S2D OFFSET");
  f_FCSI_TSSI1_s2d_offset->setDescription ("Single to differential offset");
  f_FCSI_TSSI1_s2d_offset->setDataWidth (5);
  f_FCSI_TSSI1_s2d_offset->setResetVal ("5'b00000");
  f_FCSI_TSSI1_s2d_offset->setAccProp (AccProp::RW);
  r_FCSI_TSSI1->connectRField (f_FCSI_TSSI1_s2d_offset, 0);

  Attribute* a_FCSI_TSSI1_s2d_offset_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TSSI1_s2d_offset_0_0->setInstName ("0");
  a_FCSI_TSSI1_s2d_offset_0_0->setLongName ("");
  a_FCSI_TSSI1_s2d_offset_0_0->setDescription ("");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("0", "5'b00000", "0");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("1", "5'b00001", "5uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("2", "5'b00010", "10uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("3", "5'b00011", "15uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("4", "5'b00100", "20uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("5", "5'b00101", "25uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("6", "5'b00110", "30uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("7", "5'b00111", "35uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("8", "5'b01000", "40uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("9", "5'b01001", "45uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("10", "5'b01010", "50uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("11", "5'b01011", "55uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("12", "5'b01100", "60uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("13", "5'b01101", "65uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("14", "5'b01110", "70uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("15", "5'b01111", "75uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("16", "5'b10000", "80uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("17", "5'b10001", "85uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("18", "5'b10010", "90uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("19", "5'b10011", "95uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("20", "5'b10100", "100uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("21", "5'b10101", "105uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("22", "5'b10110", "110uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("23", "5'b10111", "115uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("24", "5'b11000", "120uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("25", "5'b11001", "125uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("26", "5'b11010", "130uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("27", "5'b11011", "135uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("28", "5'b11100", "140uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("29", "5'b11101", "145uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("30", "5'b11110", "150uA");
  a_FCSI_TSSI1_s2d_offset_0_0->addItem("31", "5'b11111", "155uA");
  f_FCSI_TSSI1_s2d_offset->connectAttribute (a_FCSI_TSSI1_s2d_offset_0_0);

  RField* f_FCSI_TSSI1_s2d_gain = new RField;
  f_FCSI_TSSI1_s2d_gain->setInstName ("s2d_gain");
  f_FCSI_TSSI1_s2d_gain->setLongName ("S2D GAIN");
  f_FCSI_TSSI1_s2d_gain->setDescription ("Single to differential gain");
  f_FCSI_TSSI1_s2d_gain->setDataWidth (4);
  f_FCSI_TSSI1_s2d_gain->setResetVal ("4'b0000");
  f_FCSI_TSSI1_s2d_gain->setAccProp (AccProp::RW);
  r_FCSI_TSSI1->connectRField (f_FCSI_TSSI1_s2d_gain, 5);

  Attribute* a_FCSI_TSSI1_s2d_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TSSI1_s2d_gain_0_0->setInstName ("0");
  a_FCSI_TSSI1_s2d_gain_0_0->setLongName ("");
  a_FCSI_TSSI1_s2d_gain_0_0->setDescription ("");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("0", "4'b0000", "-10dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("1", "4'b0001", "-8dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("2", "4'b0010", "-6dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("3", "4'b0011", "-4dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("4", "4'b0100", "-2dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("5", "4'b0101", "0dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("6", "4'b0110", "2dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("7", "4'b0111", "4dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("8", "4'b1000", "6dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("9", "4'b1001", "8dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("10", "4'b1010", "10dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("11", "4'b1011", "12dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("12", "4'b1100", "14dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("13", "4'b1101", "16dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("14", "4'b1110", "18dB");
  a_FCSI_TSSI1_s2d_gain_0_0->addItem("15", "4'b1111", "20dB");
  f_FCSI_TSSI1_s2d_gain->connectAttribute (a_FCSI_TSSI1_s2d_gain_0_0);

  Register* r_FCSI_TSSI2 = new Register;
  r_FCSI_TSSI2->setInstName ("TSSI2");
  r_FCSI_TSSI2->setLongName ("TSSI2");
  r_FCSI_TSSI2->setDescription ("BB-LDO1V2");
  r_FCSI_TSSI2->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_TSSI2, 0x00000024);

  RField* f_FCSI_TSSI2_s2d_offset = new RField;
  f_FCSI_TSSI2_s2d_offset->setInstName ("s2d_offset");
  f_FCSI_TSSI2_s2d_offset->setLongName ("S2D OFFSET");
  f_FCSI_TSSI2_s2d_offset->setDescription ("Single to differential offset");
  f_FCSI_TSSI2_s2d_offset->setDataWidth (5);
  f_FCSI_TSSI2_s2d_offset->setResetVal ("5'b00000");
  f_FCSI_TSSI2_s2d_offset->setAccProp (AccProp::RW);
  r_FCSI_TSSI2->connectRField (f_FCSI_TSSI2_s2d_offset, 0);

  Attribute* a_FCSI_TSSI2_s2d_offset_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TSSI2_s2d_offset_0_0->setInstName ("0");
  a_FCSI_TSSI2_s2d_offset_0_0->setLongName ("");
  a_FCSI_TSSI2_s2d_offset_0_0->setDescription ("");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("0", "5'b00000", "0");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("1", "5'b00001", "5uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("2", "5'b00010", "10uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("3", "5'b00011", "15uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("4", "5'b00100", "20uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("5", "5'b00101", "25uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("6", "5'b00110", "30uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("7", "5'b00111", "35uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("8", "5'b01000", "40uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("9", "5'b01001", "45uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("10", "5'b01010", "50uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("11", "5'b01011", "55uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("12", "5'b01100", "60uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("13", "5'b01101", "65uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("14", "5'b01110", "70uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("15", "5'b01111", "75uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("16", "5'b10000", "80uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("17", "5'b10001", "85uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("18", "5'b10010", "90uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("19", "5'b10011", "95uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("20", "5'b10100", "100uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("21", "5'b10101", "105uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("22", "5'b10110", "110uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("23", "5'b10111", "115uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("24", "5'b11000", "120uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("25", "5'b11001", "125uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("26", "5'b11010", "130uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("27", "5'b11011", "135uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("28", "5'b11100", "140uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("29", "5'b11101", "145uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("30", "5'b11110", "150uA");
  a_FCSI_TSSI2_s2d_offset_0_0->addItem("31", "5'b11111", "155uA");
  f_FCSI_TSSI2_s2d_offset->connectAttribute (a_FCSI_TSSI2_s2d_offset_0_0);

  RField* f_FCSI_TSSI2_s2d_gain = new RField;
  f_FCSI_TSSI2_s2d_gain->setInstName ("s2d_gain");
  f_FCSI_TSSI2_s2d_gain->setLongName ("S2D GAIN");
  f_FCSI_TSSI2_s2d_gain->setDescription ("Single to differential gain");
  f_FCSI_TSSI2_s2d_gain->setDataWidth (4);
  f_FCSI_TSSI2_s2d_gain->setResetVal ("4'b0000");
  f_FCSI_TSSI2_s2d_gain->setAccProp (AccProp::RW);
  r_FCSI_TSSI2->connectRField (f_FCSI_TSSI2_s2d_gain, 5);

  Attribute* a_FCSI_TSSI2_s2d_gain_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_TSSI2_s2d_gain_0_0->setInstName ("0");
  a_FCSI_TSSI2_s2d_gain_0_0->setLongName ("");
  a_FCSI_TSSI2_s2d_gain_0_0->setDescription ("");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("0", "4'b0000", "-10dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("1", "4'b0001", "-8dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("2", "4'b0010", "-6dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("3", "4'b0011", "-4dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("4", "4'b0100", "-2dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("5", "4'b0101", "0dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("6", "4'b0110", "2dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("7", "4'b0111", "4dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("8", "4'b1000", "6dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("9", "4'b1001", "8dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("10", "4'b1010", "10dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("11", "4'b1011", "12dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("12", "4'b1100", "14dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("13", "4'b1101", "16dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("14", "4'b1110", "18dB");
  a_FCSI_TSSI2_s2d_gain_0_0->addItem("15", "4'b1111", "20dB");
  f_FCSI_TSSI2_s2d_gain->connectAttribute (a_FCSI_TSSI2_s2d_gain_0_0);

  Register* r_FCSI_VCMBIAS = new Register;
  r_FCSI_VCMBIAS->setInstName ("VCMBIAS");
  r_FCSI_VCMBIAS->setLongName ("VCMBIAS");
  r_FCSI_VCMBIAS->setDescription ("BB-LDO1V2");
  r_FCSI_VCMBIAS->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_VCMBIAS, 0x00000025);

  RField* f_FCSI_VCMBIAS_en_vcmbuffer_0v6 = new RField;
  f_FCSI_VCMBIAS_en_vcmbuffer_0v6->setInstName ("en_vcmbuffer_0v6");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v6->setLongName ("EN VCM BUFFER 0V6");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v6->setDescription ("Enable VCM buffer for PGC and SSBCAL");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v6->setDataWidth (1);
  f_FCSI_VCMBIAS_en_vcmbuffer_0v6->setResetVal ("1'b0");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v6->setAccProp (AccProp::RW);
  r_FCSI_VCMBIAS->connectRField (f_FCSI_VCMBIAS_en_vcmbuffer_0v6, 0);

  Attribute* a_FCSI_VCMBIAS_en_vcmbuffer_0v6_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VCMBIAS_en_vcmbuffer_0v6_0_0->setInstName ("0");
  a_FCSI_VCMBIAS_en_vcmbuffer_0v6_0_0->setLongName ("");
  a_FCSI_VCMBIAS_en_vcmbuffer_0v6_0_0->setDescription ("");
  a_FCSI_VCMBIAS_en_vcmbuffer_0v6_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VCMBIAS_en_vcmbuffer_0v6_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v6->connectAttribute (a_FCSI_VCMBIAS_en_vcmbuffer_0v6_0_0);

  RField* f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6 = new RField;
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6->setInstName ("en_i_h_vcmbuffer_0v6");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6->setLongName ("EN I H VCM BUFFER 0V6");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6->setDescription ("Double the current in output stage of VCM OpAmp");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6->setDataWidth (1);
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6->setResetVal ("1'b0");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6->setAccProp (AccProp::RW);
  r_FCSI_VCMBIAS->connectRField (f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6, 1);

  Attribute* a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6_0_0->setInstName ("0");
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6_0_0->setLongName ("");
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6_0_0->setDescription ("");
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6->connectAttribute (a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v6_0_0);

  RField* f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6 = new RField;
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6->setInstName ("ctl_vout_vcmbuffer_0v6");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6->setLongName ("CTL VOUT VCM BUFFER 0V6");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6->setDescription ("Control voltage output of VCM buffer 0.6V");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6->setDataWidth (2);
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6->setResetVal ("2'b00");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6->setAccProp (AccProp::RW);
  r_FCSI_VCMBIAS->connectRField (f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6, 2);

  Attribute* a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6_0_0->setInstName ("0");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6_0_0->setLongName ("");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6_0_0->setDescription ("");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6_0_0->addItem("0", "2'b00", "0.55V");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6_0_0->addItem("1", "2'b01", "0.6V");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6_0_0->addItem("2", "2'b10", "0.45V");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6_0_0->addItem("3", "2'b11", "0.5V");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6->connectAttribute (a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v6_0_0);

  RField* f_FCSI_VCMBIAS_en_vcmbuffer_0v5 = new RField;
  f_FCSI_VCMBIAS_en_vcmbuffer_0v5->setInstName ("en_vcmbuffer_0v5");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v5->setLongName ("EN VCM BUFFER 0V5");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v5->setDescription ("Enable VCM buffer for ANAMUX and TXMIXER");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v5->setDataWidth (1);
  f_FCSI_VCMBIAS_en_vcmbuffer_0v5->setResetVal ("1'b0");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v5->setAccProp (AccProp::RW);
  r_FCSI_VCMBIAS->connectRField (f_FCSI_VCMBIAS_en_vcmbuffer_0v5, 4);

  Attribute* a_FCSI_VCMBIAS_en_vcmbuffer_0v5_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VCMBIAS_en_vcmbuffer_0v5_0_0->setInstName ("0");
  a_FCSI_VCMBIAS_en_vcmbuffer_0v5_0_0->setLongName ("");
  a_FCSI_VCMBIAS_en_vcmbuffer_0v5_0_0->setDescription ("");
  a_FCSI_VCMBIAS_en_vcmbuffer_0v5_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VCMBIAS_en_vcmbuffer_0v5_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VCMBIAS_en_vcmbuffer_0v5->connectAttribute (a_FCSI_VCMBIAS_en_vcmbuffer_0v5_0_0);

  RField* f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5 = new RField;
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5->setInstName ("en_i_h_vcmbuffer_0v5");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5->setLongName ("EN I H VCM BUFFER 0V5");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5->setDescription ("Double the current in output stage of VCM OpAmp");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5->setDataWidth (1);
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5->setResetVal ("1'b0");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5->setAccProp (AccProp::RW);
  r_FCSI_VCMBIAS->connectRField (f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5, 5);

  Attribute* a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5_0_0->setInstName ("0");
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5_0_0->setLongName ("");
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5_0_0->setDescription ("");
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5->connectAttribute (a_FCSI_VCMBIAS_en_i_h_vcmbuffer_0v5_0_0);

  RField* f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5 = new RField;
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5->setInstName ("ctl_vout_vcmbuffer_0v5");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5->setLongName ("CTL VOUT VCM BUFFER 0V5");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5->setDescription ("Control voltage output of VCM buffer 0.5V");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5->setDataWidth (2);
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5->setResetVal ("2'b00");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5->setAccProp (AccProp::RW);
  r_FCSI_VCMBIAS->connectRField (f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5, 6);

  Attribute* a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5_0_0->setInstName ("0");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5_0_0->setLongName ("");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5_0_0->setDescription ("");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5_0_0->addItem("0", "2'b00", "0.55V");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5_0_0->addItem("1", "2'b01", "0.6V");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5_0_0->addItem("2", "2'b10", "0.45V");
  a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5_0_0->addItem("3", "2'b11", "0.5V");
  f_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5->connectAttribute (a_FCSI_VCMBIAS_ctl_vout_vcmbuffer_0v5_0_0);

  RField* f_FCSI_VCMBIAS_ctl_ptat_const_lna = new RField;
  f_FCSI_VCMBIAS_ctl_ptat_const_lna->setInstName ("ctl_ptat_const_lna");
  f_FCSI_VCMBIAS_ctl_ptat_const_lna->setLongName ("CTL PTAT CONST LNA");
  f_FCSI_VCMBIAS_ctl_ptat_const_lna->setDescription ("Switch between const and ptat current to the LNA");
  f_FCSI_VCMBIAS_ctl_ptat_const_lna->setDataWidth (1);
  f_FCSI_VCMBIAS_ctl_ptat_const_lna->setResetVal ("1'b0");
  f_FCSI_VCMBIAS_ctl_ptat_const_lna->setAccProp (AccProp::RW);
  r_FCSI_VCMBIAS->connectRField (f_FCSI_VCMBIAS_ctl_ptat_const_lna, 8);

  Attribute* a_FCSI_VCMBIAS_ctl_ptat_const_lna_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VCMBIAS_ctl_ptat_const_lna_0_0->setInstName ("0");
  a_FCSI_VCMBIAS_ctl_ptat_const_lna_0_0->setLongName ("");
  a_FCSI_VCMBIAS_ctl_ptat_const_lna_0_0->setDescription ("");
  a_FCSI_VCMBIAS_ctl_ptat_const_lna_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VCMBIAS_ctl_ptat_const_lna_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VCMBIAS_ctl_ptat_const_lna->connectAttribute (a_FCSI_VCMBIAS_ctl_ptat_const_lna_0_0);

  RField* f_FCSI_VCMBIAS_ctl_ptat_const_predriver = new RField;
  f_FCSI_VCMBIAS_ctl_ptat_const_predriver->setInstName ("ctl_ptat_const_predriver");
  f_FCSI_VCMBIAS_ctl_ptat_const_predriver->setLongName ("CTL PTAT CONST PREDRIVER");
  f_FCSI_VCMBIAS_ctl_ptat_const_predriver->setDescription ("Switch between const and ptat current to the predriver");
  f_FCSI_VCMBIAS_ctl_ptat_const_predriver->setDataWidth (1);
  f_FCSI_VCMBIAS_ctl_ptat_const_predriver->setResetVal ("1'b0");
  f_FCSI_VCMBIAS_ctl_ptat_const_predriver->setAccProp (AccProp::RW);
  r_FCSI_VCMBIAS->connectRField (f_FCSI_VCMBIAS_ctl_ptat_const_predriver, 9);

  Attribute* a_FCSI_VCMBIAS_ctl_ptat_const_predriver_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VCMBIAS_ctl_ptat_const_predriver_0_0->setInstName ("0");
  a_FCSI_VCMBIAS_ctl_ptat_const_predriver_0_0->setLongName ("");
  a_FCSI_VCMBIAS_ctl_ptat_const_predriver_0_0->setDescription ("");
  a_FCSI_VCMBIAS_ctl_ptat_const_predriver_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_VCMBIAS_ctl_ptat_const_predriver_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_VCMBIAS_ctl_ptat_const_predriver->connectAttribute (a_FCSI_VCMBIAS_ctl_ptat_const_predriver_0_0);

  RField* f_FCSI_VCMBIAS_ctl_ib_pgc = new RField;
  f_FCSI_VCMBIAS_ctl_ib_pgc->setInstName ("ctl_ib_pgc");
  f_FCSI_VCMBIAS_ctl_ib_pgc->setLongName ("CTL IB PGC");
  f_FCSI_VCMBIAS_ctl_ib_pgc->setDescription ("Control current output of PGC");
  f_FCSI_VCMBIAS_ctl_ib_pgc->setDataWidth (2);
  f_FCSI_VCMBIAS_ctl_ib_pgc->setResetVal ("2'b00");
  f_FCSI_VCMBIAS_ctl_ib_pgc->setAccProp (AccProp::RW);
  r_FCSI_VCMBIAS->connectRField (f_FCSI_VCMBIAS_ctl_ib_pgc, 10);

  Attribute* a_FCSI_VCMBIAS_ctl_ib_pgc_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_VCMBIAS_ctl_ib_pgc_0_0->setInstName ("0");
  a_FCSI_VCMBIAS_ctl_ib_pgc_0_0->setLongName ("");
  a_FCSI_VCMBIAS_ctl_ib_pgc_0_0->setDescription ("");
  a_FCSI_VCMBIAS_ctl_ib_pgc_0_0->addItem("0", "2'b00", "25uA");
  a_FCSI_VCMBIAS_ctl_ib_pgc_0_0->addItem("1", "2'b01", "27uA");
  a_FCSI_VCMBIAS_ctl_ib_pgc_0_0->addItem("2", "2'b10", "23uA");
  a_FCSI_VCMBIAS_ctl_ib_pgc_0_0->addItem("3", "2'b11", "25uA");
  f_FCSI_VCMBIAS_ctl_ib_pgc->connectAttribute (a_FCSI_VCMBIAS_ctl_ib_pgc_0_0);

  Register* r_FCSI_RXDCOCTL = new Register;
  r_FCSI_RXDCOCTL->setInstName ("RXDCOCTL");
  r_FCSI_RXDCOCTL->setLongName ("RX MIXER DC OFFSET CONTROL");
  r_FCSI_RXDCOCTL->setDescription ("BB-LDO1V2");
  r_FCSI_RXDCOCTL->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXDCOCTL, 0x00000026);

  RField* f_FCSI_RXDCOCTL_int_bwidth_dco_q = new RField;
  f_FCSI_RXDCOCTL_int_bwidth_dco_q->setInstName ("int_bwidth_dco_q");
  f_FCSI_RXDCOCTL_int_bwidth_dco_q->setLongName ("INT BW DCO Q");
  f_FCSI_RXDCOCTL_int_bwidth_dco_q->setDescription ("Integrator bandwidth Q");
  f_FCSI_RXDCOCTL_int_bwidth_dco_q->setDataWidth (2);
  f_FCSI_RXDCOCTL_int_bwidth_dco_q->setResetVal ("2'b00");
  f_FCSI_RXDCOCTL_int_bwidth_dco_q->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_int_bwidth_dco_q, 0);

  Attribute* a_FCSI_RXDCOCTL_int_bwidth_dco_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_int_bwidth_dco_q_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_int_bwidth_dco_q_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_int_bwidth_dco_q_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_int_bwidth_dco_q_0_0->addItem("0", "2'b00", "10bit");
  a_FCSI_RXDCOCTL_int_bwidth_dco_q_0_0->addItem("1", "2'b01", "11bit");
  a_FCSI_RXDCOCTL_int_bwidth_dco_q_0_0->addItem("2", "2'b10", "12bit");
  a_FCSI_RXDCOCTL_int_bwidth_dco_q_0_0->addItem("3", "2'b11", "13bit");
  f_FCSI_RXDCOCTL_int_bwidth_dco_q->connectAttribute (a_FCSI_RXDCOCTL_int_bwidth_dco_q_0_0);

  RField* f_FCSI_RXDCOCTL_toggle_freq_dco_q = new RField;
  f_FCSI_RXDCOCTL_toggle_freq_dco_q->setInstName ("toggle_freq_dco_q");
  f_FCSI_RXDCOCTL_toggle_freq_dco_q->setLongName ("TOGGLE FREQ DCO Q");
  f_FCSI_RXDCOCTL_toggle_freq_dco_q->setDescription ("Selects toggle frequency of comperator Q");
  f_FCSI_RXDCOCTL_toggle_freq_dco_q->setDataWidth (1);
  f_FCSI_RXDCOCTL_toggle_freq_dco_q->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_toggle_freq_dco_q->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_toggle_freq_dco_q, 2);

  Attribute* a_FCSI_RXDCOCTL_toggle_freq_dco_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_toggle_freq_dco_q_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_toggle_freq_dco_q_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_toggle_freq_dco_q_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_toggle_freq_dco_q_0_0->addItem("1", "1'b1", "clk_q/16");
  a_FCSI_RXDCOCTL_toggle_freq_dco_q_0_0->addItem("0", "1'b0", "clk_q/8");
  f_FCSI_RXDCOCTL_toggle_freq_dco_q->connectAttribute (a_FCSI_RXDCOCTL_toggle_freq_dco_q_0_0);

  RField* f_FCSI_RXDCOCTL_toggle_en_dco_q = new RField;
  f_FCSI_RXDCOCTL_toggle_en_dco_q->setInstName ("toggle_en_dco_q");
  f_FCSI_RXDCOCTL_toggle_en_dco_q->setLongName ("TOGGLE EN DCO Q");
  f_FCSI_RXDCOCTL_toggle_en_dco_q->setDescription ("Enable toggling of comperator Q");
  f_FCSI_RXDCOCTL_toggle_en_dco_q->setDataWidth (1);
  f_FCSI_RXDCOCTL_toggle_en_dco_q->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_toggle_en_dco_q->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_toggle_en_dco_q, 3);

  Attribute* a_FCSI_RXDCOCTL_toggle_en_dco_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_toggle_en_dco_q_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_toggle_en_dco_q_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_toggle_en_dco_q_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_toggle_en_dco_q_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXDCOCTL_toggle_en_dco_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXDCOCTL_toggle_en_dco_q->connectAttribute (a_FCSI_RXDCOCTL_toggle_en_dco_q_0_0);

  RField* f_FCSI_RXDCOCTL_test_dco_q = new RField;
  f_FCSI_RXDCOCTL_test_dco_q->setInstName ("test_dco_q");
  f_FCSI_RXDCOCTL_test_dco_q->setLongName ("TEST DCO Q");
  f_FCSI_RXDCOCTL_test_dco_q->setDescription ("Test mode Q");
  f_FCSI_RXDCOCTL_test_dco_q->setDataWidth (1);
  f_FCSI_RXDCOCTL_test_dco_q->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_test_dco_q->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_test_dco_q, 4);

  Attribute* a_FCSI_RXDCOCTL_test_dco_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_test_dco_q_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_test_dco_q_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_test_dco_q_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_test_dco_q_0_0->addItem("1", "1'b1", "test mode (ramp)");
  a_FCSI_RXDCOCTL_test_dco_q_0_0->addItem("0", "1'b0", "functional mode");
  f_FCSI_RXDCOCTL_test_dco_q->connectAttribute (a_FCSI_RXDCOCTL_test_dco_q_0_0);

  RField* f_FCSI_RXDCOCTL_rstn_dco_q = new RField;
  f_FCSI_RXDCOCTL_rstn_dco_q->setInstName ("rstn_dco_q");
  f_FCSI_RXDCOCTL_rstn_dco_q->setLongName ("RSTN DCO Q");
  f_FCSI_RXDCOCTL_rstn_dco_q->setDescription ("Asynchronous reset Q");
  f_FCSI_RXDCOCTL_rstn_dco_q->setDataWidth (1);
  f_FCSI_RXDCOCTL_rstn_dco_q->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_rstn_dco_q->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_rstn_dco_q, 5);

  Attribute* a_FCSI_RXDCOCTL_rstn_dco_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_rstn_dco_q_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_rstn_dco_q_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_rstn_dco_q_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_rstn_dco_q_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXDCOCTL_rstn_dco_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXDCOCTL_rstn_dco_q->connectAttribute (a_FCSI_RXDCOCTL_rstn_dco_q_0_0);

  RField* f_FCSI_RXDCOCTL_en_dco_q = new RField;
  f_FCSI_RXDCOCTL_en_dco_q->setInstName ("en_dco_q");
  f_FCSI_RXDCOCTL_en_dco_q->setLongName ("EN DCO Q");
  f_FCSI_RXDCOCTL_en_dco_q->setDescription ("Global module enable Q");
  f_FCSI_RXDCOCTL_en_dco_q->setDataWidth (1);
  f_FCSI_RXDCOCTL_en_dco_q->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_en_dco_q->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_en_dco_q, 6);

  Attribute* a_FCSI_RXDCOCTL_en_dco_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_en_dco_q_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_en_dco_q_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_en_dco_q_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_en_dco_q_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXDCOCTL_en_dco_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXDCOCTL_en_dco_q->connectAttribute (a_FCSI_RXDCOCTL_en_dco_q_0_0);

  RField* f_FCSI_RXDCOCTL_rdy2start_dco_q = new RField;
  f_FCSI_RXDCOCTL_rdy2start_dco_q->setInstName ("rdy2start_dco_q");
  f_FCSI_RXDCOCTL_rdy2start_dco_q->setLongName ("RDY2START DCO Q");
  f_FCSI_RXDCOCTL_rdy2start_dco_q->setDescription ("Ready to start Q");
  f_FCSI_RXDCOCTL_rdy2start_dco_q->setDataWidth (1);
  f_FCSI_RXDCOCTL_rdy2start_dco_q->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_rdy2start_dco_q->setAccProp (AccProp::R);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_rdy2start_dco_q, 7);

  Attribute* a_FCSI_RXDCOCTL_rdy2start_dco_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_rdy2start_dco_q_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_rdy2start_dco_q_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_rdy2start_dco_q_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_rdy2start_dco_q_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXDCOCTL_rdy2start_dco_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXDCOCTL_rdy2start_dco_q->connectAttribute (a_FCSI_RXDCOCTL_rdy2start_dco_q_0_0);

  RField* f_FCSI_RXDCOCTL_int_bwidth_dco_i = new RField;
  f_FCSI_RXDCOCTL_int_bwidth_dco_i->setInstName ("int_bwidth_dco_i");
  f_FCSI_RXDCOCTL_int_bwidth_dco_i->setLongName ("INT BW DCO I");
  f_FCSI_RXDCOCTL_int_bwidth_dco_i->setDescription ("Integrator bandwidth I");
  f_FCSI_RXDCOCTL_int_bwidth_dco_i->setDataWidth (2);
  f_FCSI_RXDCOCTL_int_bwidth_dco_i->setResetVal ("2'b00");
  f_FCSI_RXDCOCTL_int_bwidth_dco_i->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_int_bwidth_dco_i, 8);

  Attribute* a_FCSI_RXDCOCTL_int_bwidth_dco_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_int_bwidth_dco_i_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_int_bwidth_dco_i_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_int_bwidth_dco_i_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_int_bwidth_dco_i_0_0->addItem("0", "2'b00", "10bit");
  a_FCSI_RXDCOCTL_int_bwidth_dco_i_0_0->addItem("1", "2'b01", "11bit");
  a_FCSI_RXDCOCTL_int_bwidth_dco_i_0_0->addItem("2", "2'b10", "12bit");
  a_FCSI_RXDCOCTL_int_bwidth_dco_i_0_0->addItem("3", "2'b11", "13bit");
  f_FCSI_RXDCOCTL_int_bwidth_dco_i->connectAttribute (a_FCSI_RXDCOCTL_int_bwidth_dco_i_0_0);

  RField* f_FCSI_RXDCOCTL_toggle_freq_dco_i = new RField;
  f_FCSI_RXDCOCTL_toggle_freq_dco_i->setInstName ("toggle_freq_dco_i");
  f_FCSI_RXDCOCTL_toggle_freq_dco_i->setLongName ("TOGGLE FREQ DCO I");
  f_FCSI_RXDCOCTL_toggle_freq_dco_i->setDescription ("Selects toggle frequency of comperator I");
  f_FCSI_RXDCOCTL_toggle_freq_dco_i->setDataWidth (1);
  f_FCSI_RXDCOCTL_toggle_freq_dco_i->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_toggle_freq_dco_i->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_toggle_freq_dco_i, 10);

  Attribute* a_FCSI_RXDCOCTL_toggle_freq_dco_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_toggle_freq_dco_i_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_toggle_freq_dco_i_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_toggle_freq_dco_i_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_toggle_freq_dco_i_0_0->addItem("1", "1'b1", "clk_i/16");
  a_FCSI_RXDCOCTL_toggle_freq_dco_i_0_0->addItem("0", "1'b0", "clk_i/8");
  f_FCSI_RXDCOCTL_toggle_freq_dco_i->connectAttribute (a_FCSI_RXDCOCTL_toggle_freq_dco_i_0_0);

  RField* f_FCSI_RXDCOCTL_toggle_en_dco_i = new RField;
  f_FCSI_RXDCOCTL_toggle_en_dco_i->setInstName ("toggle_en_dco_i");
  f_FCSI_RXDCOCTL_toggle_en_dco_i->setLongName ("TOGGLE EN DCO I");
  f_FCSI_RXDCOCTL_toggle_en_dco_i->setDescription ("Enable toggling of comperator I");
  f_FCSI_RXDCOCTL_toggle_en_dco_i->setDataWidth (1);
  f_FCSI_RXDCOCTL_toggle_en_dco_i->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_toggle_en_dco_i->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_toggle_en_dco_i, 11);

  Attribute* a_FCSI_RXDCOCTL_toggle_en_dco_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_toggle_en_dco_i_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_toggle_en_dco_i_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_toggle_en_dco_i_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_toggle_en_dco_i_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXDCOCTL_toggle_en_dco_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXDCOCTL_toggle_en_dco_i->connectAttribute (a_FCSI_RXDCOCTL_toggle_en_dco_i_0_0);

  RField* f_FCSI_RXDCOCTL_test_dco_i = new RField;
  f_FCSI_RXDCOCTL_test_dco_i->setInstName ("test_dco_i");
  f_FCSI_RXDCOCTL_test_dco_i->setLongName ("TEST DCO I");
  f_FCSI_RXDCOCTL_test_dco_i->setDescription ("Test mode I");
  f_FCSI_RXDCOCTL_test_dco_i->setDataWidth (1);
  f_FCSI_RXDCOCTL_test_dco_i->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_test_dco_i->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_test_dco_i, 12);

  Attribute* a_FCSI_RXDCOCTL_test_dco_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_test_dco_i_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_test_dco_i_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_test_dco_i_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_test_dco_i_0_0->addItem("1", "1'b1", "test mode (ramp)");
  a_FCSI_RXDCOCTL_test_dco_i_0_0->addItem("0", "1'b0", "functional mode");
  f_FCSI_RXDCOCTL_test_dco_i->connectAttribute (a_FCSI_RXDCOCTL_test_dco_i_0_0);

  RField* f_FCSI_RXDCOCTL_rstn_dco_i = new RField;
  f_FCSI_RXDCOCTL_rstn_dco_i->setInstName ("rstn_dco_i");
  f_FCSI_RXDCOCTL_rstn_dco_i->setLongName ("RSTN DCO I");
  f_FCSI_RXDCOCTL_rstn_dco_i->setDescription ("Asynchronous reset I");
  f_FCSI_RXDCOCTL_rstn_dco_i->setDataWidth (1);
  f_FCSI_RXDCOCTL_rstn_dco_i->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_rstn_dco_i->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_rstn_dco_i, 13);

  Attribute* a_FCSI_RXDCOCTL_rstn_dco_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_rstn_dco_i_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_rstn_dco_i_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_rstn_dco_i_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_rstn_dco_i_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXDCOCTL_rstn_dco_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXDCOCTL_rstn_dco_i->connectAttribute (a_FCSI_RXDCOCTL_rstn_dco_i_0_0);

  RField* f_FCSI_RXDCOCTL_en_dco_i = new RField;
  f_FCSI_RXDCOCTL_en_dco_i->setInstName ("en_dco_i");
  f_FCSI_RXDCOCTL_en_dco_i->setLongName ("EN DCO I");
  f_FCSI_RXDCOCTL_en_dco_i->setDescription ("Global module enable I");
  f_FCSI_RXDCOCTL_en_dco_i->setDataWidth (1);
  f_FCSI_RXDCOCTL_en_dco_i->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_en_dco_i->setAccProp (AccProp::RW);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_en_dco_i, 14);

  Attribute* a_FCSI_RXDCOCTL_en_dco_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_en_dco_i_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_en_dco_i_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_en_dco_i_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_en_dco_i_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXDCOCTL_en_dco_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXDCOCTL_en_dco_i->connectAttribute (a_FCSI_RXDCOCTL_en_dco_i_0_0);

  RField* f_FCSI_RXDCOCTL_rdy2start_dco_i = new RField;
  f_FCSI_RXDCOCTL_rdy2start_dco_i->setInstName ("rdy2start_dco_i");
  f_FCSI_RXDCOCTL_rdy2start_dco_i->setLongName ("RDY2START DCO I");
  f_FCSI_RXDCOCTL_rdy2start_dco_i->setDescription ("Ready to start I");
  f_FCSI_RXDCOCTL_rdy2start_dco_i->setDataWidth (1);
  f_FCSI_RXDCOCTL_rdy2start_dco_i->setResetVal ("1'b0");
  f_FCSI_RXDCOCTL_rdy2start_dco_i->setAccProp (AccProp::R);
  r_FCSI_RXDCOCTL->connectRField (f_FCSI_RXDCOCTL_rdy2start_dco_i, 15);

  Attribute* a_FCSI_RXDCOCTL_rdy2start_dco_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOCTL_rdy2start_dco_i_0_0->setInstName ("0");
  a_FCSI_RXDCOCTL_rdy2start_dco_i_0_0->setLongName ("");
  a_FCSI_RXDCOCTL_rdy2start_dco_i_0_0->setDescription ("");
  a_FCSI_RXDCOCTL_rdy2start_dco_i_0_0->addItem("1", "1'b1", "enable");
  a_FCSI_RXDCOCTL_rdy2start_dco_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXDCOCTL_rdy2start_dco_i->connectAttribute (a_FCSI_RXDCOCTL_rdy2start_dco_i_0_0);

  Register* r_FCSI_RXDCOMAN = new Register;
  r_FCSI_RXDCOMAN->setInstName ("RXDCOMAN");
  r_FCSI_RXDCOMAN->setLongName ("RX MIXER DC OFFSET CONTROL MANUAL");
  r_FCSI_RXDCOMAN->setDescription ("BB-LDO1V2");
  r_FCSI_RXDCOMAN->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXDCOMAN, 0x00000027);

  RField* f_FCSI_RXDCOMAN_i_offset_dac0 = new RField;
  f_FCSI_RXDCOMAN_i_offset_dac0->setInstName ("i_offset_dac0");
  f_FCSI_RXDCOMAN_i_offset_dac0->setLongName ("I OFFSET DAC0");
  f_FCSI_RXDCOMAN_i_offset_dac0->setDescription ("I offset for DAC0 (manual setting)");
  f_FCSI_RXDCOMAN_i_offset_dac0->setDataWidth (6);
  f_FCSI_RXDCOMAN_i_offset_dac0->setResetVal ("6'b000000");
  f_FCSI_RXDCOMAN_i_offset_dac0->setAccProp (AccProp::RW);
  r_FCSI_RXDCOMAN->connectRField (f_FCSI_RXDCOMAN_i_offset_dac0, 0);

  RField* f_FCSI_RXDCOMAN_q_offset_dac0 = new RField;
  f_FCSI_RXDCOMAN_q_offset_dac0->setInstName ("q_offset_dac0");
  f_FCSI_RXDCOMAN_q_offset_dac0->setLongName ("Q OFFSET DAC0");
  f_FCSI_RXDCOMAN_q_offset_dac0->setDescription ("Q offset for DAC0 (manual setting)");
  f_FCSI_RXDCOMAN_q_offset_dac0->setDataWidth (6);
  f_FCSI_RXDCOMAN_q_offset_dac0->setResetVal ("6'b000000");
  f_FCSI_RXDCOMAN_q_offset_dac0->setAccProp (AccProp::RW);
  r_FCSI_RXDCOMAN->connectRField (f_FCSI_RXDCOMAN_q_offset_dac0, 6);

  RField* f_FCSI_RXDCOMAN_force_dac0 = new RField;
  f_FCSI_RXDCOMAN_force_dac0->setInstName ("force_dac0");
  f_FCSI_RXDCOMAN_force_dac0->setLongName ("FORCE DAC0 (RX-MIXER)");
  f_FCSI_RXDCOMAN_force_dac0->setDescription ("Force DAC0 to manual mode (Rx-Mixer)");
  f_FCSI_RXDCOMAN_force_dac0->setDataWidth (1);
  f_FCSI_RXDCOMAN_force_dac0->setResetVal ("1'b0");
  f_FCSI_RXDCOMAN_force_dac0->setAccProp (AccProp::RW);
  r_FCSI_RXDCOMAN->connectRField (f_FCSI_RXDCOMAN_force_dac0, 12);

  Attribute* a_FCSI_RXDCOMAN_force_dac0_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXDCOMAN_force_dac0_0_0->setInstName ("0");
  a_FCSI_RXDCOMAN_force_dac0_0_0->setLongName ("");
  a_FCSI_RXDCOMAN_force_dac0_0_0->setDescription ("");
  a_FCSI_RXDCOMAN_force_dac0_0_0->addItem("0", "1'b0", "disable");
  a_FCSI_RXDCOMAN_force_dac0_0_0->addItem("1", "1'b1", "disable");
  f_FCSI_RXDCOMAN_force_dac0->connectAttribute (a_FCSI_RXDCOMAN_force_dac0_0_0);

  Register* r_FCSI_RXMIXDC00 = new Register;
  r_FCSI_RXMIXDC00->setInstName ("RXMIXDC00");
  r_FCSI_RXMIXDC00->setLongName ("RX MIXER OFFSET GAIN0 RXDCCH0 ");
  r_FCSI_RXMIXDC00->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC00->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC00, 0x00000028);

  RField* f_FCSI_RXMIXDC00_success_i = new RField;
  f_FCSI_RXMIXDC00_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC00_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC00_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC00_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC00_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC00_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC00->connectRField (f_FCSI_RXMIXDC00_success_i, 0);

  Attribute* a_FCSI_RXMIXDC00_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC00_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC00_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC00_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC00_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC00_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC00_success_i->connectAttribute (a_FCSI_RXMIXDC00_success_i_0_0);

  RField* f_FCSI_RXMIXDC00_success_q = new RField;
  f_FCSI_RXMIXDC00_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC00_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC00_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC00_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC00_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC00_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC00->connectRField (f_FCSI_RXMIXDC00_success_q, 1);

  Attribute* a_FCSI_RXMIXDC00_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC00_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC00_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC00_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC00_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC00_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC00_success_q->connectAttribute (a_FCSI_RXMIXDC00_success_q_0_0);

  RField* f_FCSI_RXMIXDC00_daci = new RField;
  f_FCSI_RXMIXDC00_daci->setInstName ("daci");
  f_FCSI_RXMIXDC00_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC00_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC00_daci->setDataWidth (6);
  f_FCSI_RXMIXDC00_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC00_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC00->connectRField (f_FCSI_RXMIXDC00_daci, 4);

  RField* f_FCSI_RXMIXDC00_dacq = new RField;
  f_FCSI_RXMIXDC00_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC00_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC00_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC00_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC00_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC00_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC00->connectRField (f_FCSI_RXMIXDC00_dacq, 10);

  Register* r_FCSI_RXMIXDC01 = new Register;
  r_FCSI_RXMIXDC01->setInstName ("RXMIXDC01");
  r_FCSI_RXMIXDC01->setLongName ("RX MIXER OFFSET GAIN0 RXDCCH1");
  r_FCSI_RXMIXDC01->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC01->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC01, 0x00000029);

  RField* f_FCSI_RXMIXDC01_success_i = new RField;
  f_FCSI_RXMIXDC01_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC01_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC01_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC01_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC01_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC01_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC01->connectRField (f_FCSI_RXMIXDC01_success_i, 0);

  Attribute* a_FCSI_RXMIXDC01_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC01_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC01_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC01_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC01_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC01_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC01_success_i->connectAttribute (a_FCSI_RXMIXDC01_success_i_0_0);

  RField* f_FCSI_RXMIXDC01_success_q = new RField;
  f_FCSI_RXMIXDC01_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC01_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC01_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC01_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC01_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC01_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC01->connectRField (f_FCSI_RXMIXDC01_success_q, 1);

  Attribute* a_FCSI_RXMIXDC01_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC01_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC01_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC01_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC01_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC01_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC01_success_q->connectAttribute (a_FCSI_RXMIXDC01_success_q_0_0);

  RField* f_FCSI_RXMIXDC01_daci = new RField;
  f_FCSI_RXMIXDC01_daci->setInstName ("daci");
  f_FCSI_RXMIXDC01_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC01_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC01_daci->setDataWidth (6);
  f_FCSI_RXMIXDC01_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC01_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC01->connectRField (f_FCSI_RXMIXDC01_daci, 4);

  RField* f_FCSI_RXMIXDC01_dacq = new RField;
  f_FCSI_RXMIXDC01_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC01_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC01_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC01_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC01_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC01_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC01->connectRField (f_FCSI_RXMIXDC01_dacq, 10);

  Register* r_FCSI_RXMIXDC02 = new Register;
  r_FCSI_RXMIXDC02->setInstName ("RXMIXDC02");
  r_FCSI_RXMIXDC02->setLongName ("RX MIXER OFFSET GAIN0 RXDCCH2");
  r_FCSI_RXMIXDC02->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC02->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC02, 0x0000002A);

  RField* f_FCSI_RXMIXDC02_success_i = new RField;
  f_FCSI_RXMIXDC02_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC02_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC02_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC02_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC02_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC02_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC02->connectRField (f_FCSI_RXMIXDC02_success_i, 0);

  Attribute* a_FCSI_RXMIXDC02_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC02_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC02_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC02_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC02_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC02_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC02_success_i->connectAttribute (a_FCSI_RXMIXDC02_success_i_0_0);

  RField* f_FCSI_RXMIXDC02_success_q = new RField;
  f_FCSI_RXMIXDC02_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC02_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC02_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC02_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC02_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC02_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC02->connectRField (f_FCSI_RXMIXDC02_success_q, 1);

  Attribute* a_FCSI_RXMIXDC02_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC02_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC02_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC02_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC02_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC02_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC02_success_q->connectAttribute (a_FCSI_RXMIXDC02_success_q_0_0);

  RField* f_FCSI_RXMIXDC02_daci = new RField;
  f_FCSI_RXMIXDC02_daci->setInstName ("daci");
  f_FCSI_RXMIXDC02_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC02_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC02_daci->setDataWidth (6);
  f_FCSI_RXMIXDC02_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC02_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC02->connectRField (f_FCSI_RXMIXDC02_daci, 4);

  RField* f_FCSI_RXMIXDC02_dacq = new RField;
  f_FCSI_RXMIXDC02_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC02_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC02_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC02_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC02_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC02_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC02->connectRField (f_FCSI_RXMIXDC02_dacq, 10);

  Register* r_FCSI_RXMIXDC03 = new Register;
  r_FCSI_RXMIXDC03->setInstName ("RXMIXDC03");
  r_FCSI_RXMIXDC03->setLongName ("RX MIXER OFFSET GAIN0 RXDCCH3");
  r_FCSI_RXMIXDC03->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC03->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC03, 0x0000002B);

  RField* f_FCSI_RXMIXDC03_success_i = new RField;
  f_FCSI_RXMIXDC03_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC03_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC03_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC03_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC03_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC03_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC03->connectRField (f_FCSI_RXMIXDC03_success_i, 0);

  Attribute* a_FCSI_RXMIXDC03_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC03_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC03_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC03_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC03_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC03_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC03_success_i->connectAttribute (a_FCSI_RXMIXDC03_success_i_0_0);

  RField* f_FCSI_RXMIXDC03_success_q = new RField;
  f_FCSI_RXMIXDC03_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC03_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC03_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC03_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC03_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC03_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC03->connectRField (f_FCSI_RXMIXDC03_success_q, 1);

  Attribute* a_FCSI_RXMIXDC03_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC03_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC03_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC03_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC03_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC03_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC03_success_q->connectAttribute (a_FCSI_RXMIXDC03_success_q_0_0);

  RField* f_FCSI_RXMIXDC03_daci = new RField;
  f_FCSI_RXMIXDC03_daci->setInstName ("daci");
  f_FCSI_RXMIXDC03_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC03_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC03_daci->setDataWidth (6);
  f_FCSI_RXMIXDC03_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC03_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC03->connectRField (f_FCSI_RXMIXDC03_daci, 4);

  RField* f_FCSI_RXMIXDC03_dacq = new RField;
  f_FCSI_RXMIXDC03_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC03_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC03_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC03_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC03_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC03_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC03->connectRField (f_FCSI_RXMIXDC03_dacq, 10);

  Register* r_FCSI_RXMIXDC10 = new Register;
  r_FCSI_RXMIXDC10->setInstName ("RXMIXDC10");
  r_FCSI_RXMIXDC10->setLongName ("RX MIXER OFFSET GAIN1 RXDCCH0");
  r_FCSI_RXMIXDC10->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC10->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC10, 0x0000002C);

  RField* f_FCSI_RXMIXDC10_success_i = new RField;
  f_FCSI_RXMIXDC10_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC10_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC10_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC10_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC10_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC10_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC10->connectRField (f_FCSI_RXMIXDC10_success_i, 0);

  Attribute* a_FCSI_RXMIXDC10_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC10_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC10_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC10_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC10_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC10_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC10_success_i->connectAttribute (a_FCSI_RXMIXDC10_success_i_0_0);

  RField* f_FCSI_RXMIXDC10_success_q = new RField;
  f_FCSI_RXMIXDC10_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC10_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC10_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC10_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC10_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC10_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC10->connectRField (f_FCSI_RXMIXDC10_success_q, 1);

  Attribute* a_FCSI_RXMIXDC10_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC10_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC10_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC10_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC10_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC10_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC10_success_q->connectAttribute (a_FCSI_RXMIXDC10_success_q_0_0);

  RField* f_FCSI_RXMIXDC10_daci = new RField;
  f_FCSI_RXMIXDC10_daci->setInstName ("daci");
  f_FCSI_RXMIXDC10_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC10_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC10_daci->setDataWidth (6);
  f_FCSI_RXMIXDC10_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC10_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC10->connectRField (f_FCSI_RXMIXDC10_daci, 4);

  RField* f_FCSI_RXMIXDC10_dacq = new RField;
  f_FCSI_RXMIXDC10_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC10_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC10_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC10_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC10_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC10_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC10->connectRField (f_FCSI_RXMIXDC10_dacq, 10);

  Register* r_FCSI_RXMIXDC11 = new Register;
  r_FCSI_RXMIXDC11->setInstName ("RXMIXDC11");
  r_FCSI_RXMIXDC11->setLongName ("RX MIXER OFFSET GAIN1 RXDCCH1");
  r_FCSI_RXMIXDC11->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC11->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC11, 0x0000002D);

  RField* f_FCSI_RXMIXDC11_success_i = new RField;
  f_FCSI_RXMIXDC11_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC11_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC11_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC11_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC11_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC11_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC11->connectRField (f_FCSI_RXMIXDC11_success_i, 0);

  Attribute* a_FCSI_RXMIXDC11_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC11_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC11_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC11_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC11_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC11_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC11_success_i->connectAttribute (a_FCSI_RXMIXDC11_success_i_0_0);

  RField* f_FCSI_RXMIXDC11_success_q = new RField;
  f_FCSI_RXMIXDC11_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC11_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC11_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC11_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC11_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC11_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC11->connectRField (f_FCSI_RXMIXDC11_success_q, 1);

  Attribute* a_FCSI_RXMIXDC11_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC11_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC11_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC11_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC11_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC11_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC11_success_q->connectAttribute (a_FCSI_RXMIXDC11_success_q_0_0);

  RField* f_FCSI_RXMIXDC11_daci = new RField;
  f_FCSI_RXMIXDC11_daci->setInstName ("daci");
  f_FCSI_RXMIXDC11_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC11_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC11_daci->setDataWidth (6);
  f_FCSI_RXMIXDC11_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC11_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC11->connectRField (f_FCSI_RXMIXDC11_daci, 4);

  RField* f_FCSI_RXMIXDC11_dacq = new RField;
  f_FCSI_RXMIXDC11_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC11_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC11_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC11_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC11_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC11_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC11->connectRField (f_FCSI_RXMIXDC11_dacq, 10);

  Register* r_FCSI_RXMIXDC12 = new Register;
  r_FCSI_RXMIXDC12->setInstName ("RXMIXDC12");
  r_FCSI_RXMIXDC12->setLongName ("RX MIXER OFFSET GAIN1 RXDCCH2");
  r_FCSI_RXMIXDC12->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC12->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC12, 0x0000002E);

  RField* f_FCSI_RXMIXDC12_success_i = new RField;
  f_FCSI_RXMIXDC12_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC12_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC12_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC12_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC12_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC12_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC12->connectRField (f_FCSI_RXMIXDC12_success_i, 0);

  Attribute* a_FCSI_RXMIXDC12_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC12_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC12_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC12_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC12_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC12_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC12_success_i->connectAttribute (a_FCSI_RXMIXDC12_success_i_0_0);

  RField* f_FCSI_RXMIXDC12_success_q = new RField;
  f_FCSI_RXMIXDC12_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC12_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC12_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC12_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC12_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC12_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC12->connectRField (f_FCSI_RXMIXDC12_success_q, 1);

  Attribute* a_FCSI_RXMIXDC12_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC12_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC12_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC12_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC12_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC12_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC12_success_q->connectAttribute (a_FCSI_RXMIXDC12_success_q_0_0);

  RField* f_FCSI_RXMIXDC12_daci = new RField;
  f_FCSI_RXMIXDC12_daci->setInstName ("daci");
  f_FCSI_RXMIXDC12_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC12_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC12_daci->setDataWidth (6);
  f_FCSI_RXMIXDC12_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC12_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC12->connectRField (f_FCSI_RXMIXDC12_daci, 4);

  RField* f_FCSI_RXMIXDC12_dacq = new RField;
  f_FCSI_RXMIXDC12_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC12_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC12_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC12_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC12_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC12_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC12->connectRField (f_FCSI_RXMIXDC12_dacq, 10);

  Register* r_FCSI_RXMIXDC13 = new Register;
  r_FCSI_RXMIXDC13->setInstName ("RXMIXDC13");
  r_FCSI_RXMIXDC13->setLongName ("RX MIXER OFFSET GAIN1 RXDCCH3");
  r_FCSI_RXMIXDC13->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC13->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC13, 0x0000002F);

  RField* f_FCSI_RXMIXDC13_success_i = new RField;
  f_FCSI_RXMIXDC13_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC13_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC13_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC13_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC13_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC13_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC13->connectRField (f_FCSI_RXMIXDC13_success_i, 0);

  Attribute* a_FCSI_RXMIXDC13_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC13_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC13_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC13_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC13_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC13_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC13_success_i->connectAttribute (a_FCSI_RXMIXDC13_success_i_0_0);

  RField* f_FCSI_RXMIXDC13_success_q = new RField;
  f_FCSI_RXMIXDC13_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC13_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC13_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC13_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC13_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC13_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC13->connectRField (f_FCSI_RXMIXDC13_success_q, 1);

  Attribute* a_FCSI_RXMIXDC13_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC13_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC13_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC13_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC13_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC13_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC13_success_q->connectAttribute (a_FCSI_RXMIXDC13_success_q_0_0);

  RField* f_FCSI_RXMIXDC13_daci = new RField;
  f_FCSI_RXMIXDC13_daci->setInstName ("daci");
  f_FCSI_RXMIXDC13_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC13_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC13_daci->setDataWidth (6);
  f_FCSI_RXMIXDC13_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC13_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC13->connectRField (f_FCSI_RXMIXDC13_daci, 4);

  RField* f_FCSI_RXMIXDC13_dacq = new RField;
  f_FCSI_RXMIXDC13_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC13_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC13_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC13_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC13_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC13_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC13->connectRField (f_FCSI_RXMIXDC13_dacq, 10);

  Register* r_FCSI_RXMIXDC20 = new Register;
  r_FCSI_RXMIXDC20->setInstName ("RXMIXDC20");
  r_FCSI_RXMIXDC20->setLongName ("RX MIXER OFFSET GAIN2 RXDCCH0");
  r_FCSI_RXMIXDC20->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC20->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC20, 0x00000030);

  RField* f_FCSI_RXMIXDC20_success_i = new RField;
  f_FCSI_RXMIXDC20_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC20_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC20_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC20_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC20_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC20_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC20->connectRField (f_FCSI_RXMIXDC20_success_i, 0);

  Attribute* a_FCSI_RXMIXDC20_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC20_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC20_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC20_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC20_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC20_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC20_success_i->connectAttribute (a_FCSI_RXMIXDC20_success_i_0_0);

  RField* f_FCSI_RXMIXDC20_success_q = new RField;
  f_FCSI_RXMIXDC20_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC20_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC20_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC20_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC20_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC20_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC20->connectRField (f_FCSI_RXMIXDC20_success_q, 1);

  Attribute* a_FCSI_RXMIXDC20_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC20_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC20_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC20_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC20_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC20_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC20_success_q->connectAttribute (a_FCSI_RXMIXDC20_success_q_0_0);

  RField* f_FCSI_RXMIXDC20_daci = new RField;
  f_FCSI_RXMIXDC20_daci->setInstName ("daci");
  f_FCSI_RXMIXDC20_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC20_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC20_daci->setDataWidth (6);
  f_FCSI_RXMIXDC20_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC20_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC20->connectRField (f_FCSI_RXMIXDC20_daci, 4);

  RField* f_FCSI_RXMIXDC20_dacq = new RField;
  f_FCSI_RXMIXDC20_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC20_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC20_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC20_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC20_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC20_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC20->connectRField (f_FCSI_RXMIXDC20_dacq, 10);

  Register* r_FCSI_RXMIXDC21 = new Register;
  r_FCSI_RXMIXDC21->setInstName ("RXMIXDC21");
  r_FCSI_RXMIXDC21->setLongName ("RX MIXER OFFSET GAIN2 RXDCCH1");
  r_FCSI_RXMIXDC21->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC21->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC21, 0x00000031);

  RField* f_FCSI_RXMIXDC21_success_i = new RField;
  f_FCSI_RXMIXDC21_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC21_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC21_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC21_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC21_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC21_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC21->connectRField (f_FCSI_RXMIXDC21_success_i, 0);

  Attribute* a_FCSI_RXMIXDC21_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC21_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC21_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC21_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC21_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC21_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC21_success_i->connectAttribute (a_FCSI_RXMIXDC21_success_i_0_0);

  RField* f_FCSI_RXMIXDC21_success_q = new RField;
  f_FCSI_RXMIXDC21_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC21_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC21_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC21_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC21_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC21_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC21->connectRField (f_FCSI_RXMIXDC21_success_q, 1);

  Attribute* a_FCSI_RXMIXDC21_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC21_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC21_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC21_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC21_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC21_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC21_success_q->connectAttribute (a_FCSI_RXMIXDC21_success_q_0_0);

  RField* f_FCSI_RXMIXDC21_daci = new RField;
  f_FCSI_RXMIXDC21_daci->setInstName ("daci");
  f_FCSI_RXMIXDC21_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC21_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC21_daci->setDataWidth (6);
  f_FCSI_RXMIXDC21_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC21_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC21->connectRField (f_FCSI_RXMIXDC21_daci, 4);

  RField* f_FCSI_RXMIXDC21_dacq = new RField;
  f_FCSI_RXMIXDC21_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC21_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC21_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC21_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC21_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC21_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC21->connectRField (f_FCSI_RXMIXDC21_dacq, 10);

  Register* r_FCSI_RXMIXDC22 = new Register;
  r_FCSI_RXMIXDC22->setInstName ("RXMIXDC22");
  r_FCSI_RXMIXDC22->setLongName ("RX MIXER OFFSET GAIN2 RXDCCH2");
  r_FCSI_RXMIXDC22->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC22->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC22, 0x00000032);

  RField* f_FCSI_RXMIXDC22_success_i = new RField;
  f_FCSI_RXMIXDC22_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC22_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC22_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC22_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC22_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC22_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC22->connectRField (f_FCSI_RXMIXDC22_success_i, 0);

  Attribute* a_FCSI_RXMIXDC22_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC22_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC22_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC22_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC22_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC22_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC22_success_i->connectAttribute (a_FCSI_RXMIXDC22_success_i_0_0);

  RField* f_FCSI_RXMIXDC22_success_q = new RField;
  f_FCSI_RXMIXDC22_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC22_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC22_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC22_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC22_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC22_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC22->connectRField (f_FCSI_RXMIXDC22_success_q, 1);

  Attribute* a_FCSI_RXMIXDC22_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC22_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC22_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC22_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC22_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC22_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC22_success_q->connectAttribute (a_FCSI_RXMIXDC22_success_q_0_0);

  RField* f_FCSI_RXMIXDC22_daci = new RField;
  f_FCSI_RXMIXDC22_daci->setInstName ("daci");
  f_FCSI_RXMIXDC22_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC22_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC22_daci->setDataWidth (6);
  f_FCSI_RXMIXDC22_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC22_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC22->connectRField (f_FCSI_RXMIXDC22_daci, 4);

  RField* f_FCSI_RXMIXDC22_dacq = new RField;
  f_FCSI_RXMIXDC22_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC22_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC22_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC22_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC22_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC22_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC22->connectRField (f_FCSI_RXMIXDC22_dacq, 10);

  Register* r_FCSI_RXMIXDC23 = new Register;
  r_FCSI_RXMIXDC23->setInstName ("RXMIXDC23");
  r_FCSI_RXMIXDC23->setLongName ("RX MIXER OFFSET GAIN2 RXDCCH3");
  r_FCSI_RXMIXDC23->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC23->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC23, 0x00000033);

  RField* f_FCSI_RXMIXDC23_success_i = new RField;
  f_FCSI_RXMIXDC23_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC23_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC23_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC23_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC23_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC23_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC23->connectRField (f_FCSI_RXMIXDC23_success_i, 0);

  Attribute* a_FCSI_RXMIXDC23_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC23_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC23_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC23_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC23_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC23_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC23_success_i->connectAttribute (a_FCSI_RXMIXDC23_success_i_0_0);

  RField* f_FCSI_RXMIXDC23_success_q = new RField;
  f_FCSI_RXMIXDC23_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC23_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC23_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC23_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC23_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC23_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC23->connectRField (f_FCSI_RXMIXDC23_success_q, 1);

  Attribute* a_FCSI_RXMIXDC23_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC23_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC23_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC23_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC23_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC23_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC23_success_q->connectAttribute (a_FCSI_RXMIXDC23_success_q_0_0);

  RField* f_FCSI_RXMIXDC23_daci = new RField;
  f_FCSI_RXMIXDC23_daci->setInstName ("daci");
  f_FCSI_RXMIXDC23_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC23_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC23_daci->setDataWidth (6);
  f_FCSI_RXMIXDC23_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC23_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC23->connectRField (f_FCSI_RXMIXDC23_daci, 4);

  RField* f_FCSI_RXMIXDC23_dacq = new RField;
  f_FCSI_RXMIXDC23_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC23_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC23_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC23_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC23_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC23_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC23->connectRField (f_FCSI_RXMIXDC23_dacq, 10);

  Register* r_FCSI_RXMIXDC30 = new Register;
  r_FCSI_RXMIXDC30->setInstName ("RXMIXDC30");
  r_FCSI_RXMIXDC30->setLongName ("RX MIXER OFFSET GAIN3 RXDCCH0");
  r_FCSI_RXMIXDC30->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC30->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC30, 0x00000034);

  RField* f_FCSI_RXMIXDC30_success_i = new RField;
  f_FCSI_RXMIXDC30_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC30_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC30_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC30_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC30_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC30_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC30->connectRField (f_FCSI_RXMIXDC30_success_i, 0);

  Attribute* a_FCSI_RXMIXDC30_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC30_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC30_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC30_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC30_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC30_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC30_success_i->connectAttribute (a_FCSI_RXMIXDC30_success_i_0_0);

  RField* f_FCSI_RXMIXDC30_success_q = new RField;
  f_FCSI_RXMIXDC30_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC30_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC30_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC30_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC30_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC30_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC30->connectRField (f_FCSI_RXMIXDC30_success_q, 1);

  Attribute* a_FCSI_RXMIXDC30_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC30_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC30_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC30_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC30_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC30_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC30_success_q->connectAttribute (a_FCSI_RXMIXDC30_success_q_0_0);

  RField* f_FCSI_RXMIXDC30_daci = new RField;
  f_FCSI_RXMIXDC30_daci->setInstName ("daci");
  f_FCSI_RXMIXDC30_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC30_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC30_daci->setDataWidth (6);
  f_FCSI_RXMIXDC30_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC30_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC30->connectRField (f_FCSI_RXMIXDC30_daci, 4);

  RField* f_FCSI_RXMIXDC30_dacq = new RField;
  f_FCSI_RXMIXDC30_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC30_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC30_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC30_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC30_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC30_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC30->connectRField (f_FCSI_RXMIXDC30_dacq, 10);

  Register* r_FCSI_RXMIXDC31 = new Register;
  r_FCSI_RXMIXDC31->setInstName ("RXMIXDC31");
  r_FCSI_RXMIXDC31->setLongName ("RX MIXER OFFSET GAIN3 RXDCCH1");
  r_FCSI_RXMIXDC31->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC31->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC31, 0x00000035);

  RField* f_FCSI_RXMIXDC31_success_i = new RField;
  f_FCSI_RXMIXDC31_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC31_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC31_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC31_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC31_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC31_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC31->connectRField (f_FCSI_RXMIXDC31_success_i, 0);

  Attribute* a_FCSI_RXMIXDC31_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC31_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC31_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC31_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC31_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC31_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC31_success_i->connectAttribute (a_FCSI_RXMIXDC31_success_i_0_0);

  RField* f_FCSI_RXMIXDC31_success_q = new RField;
  f_FCSI_RXMIXDC31_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC31_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC31_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC31_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC31_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC31_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC31->connectRField (f_FCSI_RXMIXDC31_success_q, 1);

  Attribute* a_FCSI_RXMIXDC31_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC31_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC31_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC31_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC31_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC31_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC31_success_q->connectAttribute (a_FCSI_RXMIXDC31_success_q_0_0);

  RField* f_FCSI_RXMIXDC31_daci = new RField;
  f_FCSI_RXMIXDC31_daci->setInstName ("daci");
  f_FCSI_RXMIXDC31_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC31_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC31_daci->setDataWidth (6);
  f_FCSI_RXMIXDC31_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC31_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC31->connectRField (f_FCSI_RXMIXDC31_daci, 4);

  RField* f_FCSI_RXMIXDC31_dacq = new RField;
  f_FCSI_RXMIXDC31_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC31_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC31_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC31_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC31_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC31_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC31->connectRField (f_FCSI_RXMIXDC31_dacq, 10);

  Register* r_FCSI_RXMIXDC32 = new Register;
  r_FCSI_RXMIXDC32->setInstName ("RXMIXDC32");
  r_FCSI_RXMIXDC32->setLongName ("RX MIXER OFFSET GAIN3 RXDCCH2");
  r_FCSI_RXMIXDC32->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC32->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC32, 0x00000036);

  RField* f_FCSI_RXMIXDC32_success_i = new RField;
  f_FCSI_RXMIXDC32_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC32_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC32_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC32_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC32_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC32_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC32->connectRField (f_FCSI_RXMIXDC32_success_i, 0);

  Attribute* a_FCSI_RXMIXDC32_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC32_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC32_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC32_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC32_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC32_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC32_success_i->connectAttribute (a_FCSI_RXMIXDC32_success_i_0_0);

  RField* f_FCSI_RXMIXDC32_success_q = new RField;
  f_FCSI_RXMIXDC32_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC32_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC32_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC32_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC32_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC32_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC32->connectRField (f_FCSI_RXMIXDC32_success_q, 1);

  Attribute* a_FCSI_RXMIXDC32_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC32_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC32_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC32_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC32_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC32_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC32_success_q->connectAttribute (a_FCSI_RXMIXDC32_success_q_0_0);

  RField* f_FCSI_RXMIXDC32_daci = new RField;
  f_FCSI_RXMIXDC32_daci->setInstName ("daci");
  f_FCSI_RXMIXDC32_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC32_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC32_daci->setDataWidth (6);
  f_FCSI_RXMIXDC32_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC32_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC32->connectRField (f_FCSI_RXMIXDC32_daci, 4);

  RField* f_FCSI_RXMIXDC32_dacq = new RField;
  f_FCSI_RXMIXDC32_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC32_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC32_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC32_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC32_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC32_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC32->connectRField (f_FCSI_RXMIXDC32_dacq, 10);

  Register* r_FCSI_RXMIXDC33 = new Register;
  r_FCSI_RXMIXDC33->setInstName ("RXMIXDC33");
  r_FCSI_RXMIXDC33->setLongName ("RX MIXER OFFSET GAIN3 RXDCCH3");
  r_FCSI_RXMIXDC33->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC33->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC33, 0x00000037);

  RField* f_FCSI_RXMIXDC33_success_i = new RField;
  f_FCSI_RXMIXDC33_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC33_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC33_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC33_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC33_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC33_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC33->connectRField (f_FCSI_RXMIXDC33_success_i, 0);

  Attribute* a_FCSI_RXMIXDC33_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC33_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC33_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC33_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC33_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC33_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC33_success_i->connectAttribute (a_FCSI_RXMIXDC33_success_i_0_0);

  RField* f_FCSI_RXMIXDC33_success_q = new RField;
  f_FCSI_RXMIXDC33_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC33_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC33_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC33_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC33_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC33_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC33->connectRField (f_FCSI_RXMIXDC33_success_q, 1);

  Attribute* a_FCSI_RXMIXDC33_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC33_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC33_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC33_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC33_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC33_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC33_success_q->connectAttribute (a_FCSI_RXMIXDC33_success_q_0_0);

  RField* f_FCSI_RXMIXDC33_daci = new RField;
  f_FCSI_RXMIXDC33_daci->setInstName ("daci");
  f_FCSI_RXMIXDC33_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC33_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC33_daci->setDataWidth (6);
  f_FCSI_RXMIXDC33_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC33_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC33->connectRField (f_FCSI_RXMIXDC33_daci, 4);

  RField* f_FCSI_RXMIXDC33_dacq = new RField;
  f_FCSI_RXMIXDC33_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC33_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC33_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC33_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC33_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC33_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC33->connectRField (f_FCSI_RXMIXDC33_dacq, 10);

  Register* r_FCSI_RXMIXDC40 = new Register;
  r_FCSI_RXMIXDC40->setInstName ("RXMIXDC40");
  r_FCSI_RXMIXDC40->setLongName ("RX MIXER OFFSET GAIN4 RXDCCH0");
  r_FCSI_RXMIXDC40->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC40->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC40, 0x00000038);

  RField* f_FCSI_RXMIXDC40_success_i = new RField;
  f_FCSI_RXMIXDC40_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC40_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC40_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC40_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC40_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC40_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC40->connectRField (f_FCSI_RXMIXDC40_success_i, 0);

  Attribute* a_FCSI_RXMIXDC40_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC40_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC40_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC40_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC40_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC40_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC40_success_i->connectAttribute (a_FCSI_RXMIXDC40_success_i_0_0);

  RField* f_FCSI_RXMIXDC40_success_q = new RField;
  f_FCSI_RXMIXDC40_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC40_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC40_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC40_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC40_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC40_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC40->connectRField (f_FCSI_RXMIXDC40_success_q, 1);

  Attribute* a_FCSI_RXMIXDC40_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC40_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC40_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC40_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC40_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC40_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC40_success_q->connectAttribute (a_FCSI_RXMIXDC40_success_q_0_0);

  RField* f_FCSI_RXMIXDC40_daci = new RField;
  f_FCSI_RXMIXDC40_daci->setInstName ("daci");
  f_FCSI_RXMIXDC40_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC40_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC40_daci->setDataWidth (6);
  f_FCSI_RXMIXDC40_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC40_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC40->connectRField (f_FCSI_RXMIXDC40_daci, 4);

  RField* f_FCSI_RXMIXDC40_dacq = new RField;
  f_FCSI_RXMIXDC40_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC40_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC40_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC40_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC40_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC40_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC40->connectRField (f_FCSI_RXMIXDC40_dacq, 10);

  Register* r_FCSI_RXMIXDC41 = new Register;
  r_FCSI_RXMIXDC41->setInstName ("RXMIXDC41");
  r_FCSI_RXMIXDC41->setLongName ("RX MIXER OFFSET GAIN4 RXDCCH1");
  r_FCSI_RXMIXDC41->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC41->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC41, 0x00000039);

  RField* f_FCSI_RXMIXDC41_success_i = new RField;
  f_FCSI_RXMIXDC41_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC41_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC41_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC41_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC41_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC41_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC41->connectRField (f_FCSI_RXMIXDC41_success_i, 0);

  Attribute* a_FCSI_RXMIXDC41_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC41_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC41_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC41_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC41_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC41_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC41_success_i->connectAttribute (a_FCSI_RXMIXDC41_success_i_0_0);

  RField* f_FCSI_RXMIXDC41_success_q = new RField;
  f_FCSI_RXMIXDC41_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC41_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC41_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC41_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC41_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC41_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC41->connectRField (f_FCSI_RXMIXDC41_success_q, 1);

  Attribute* a_FCSI_RXMIXDC41_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC41_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC41_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC41_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC41_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC41_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC41_success_q->connectAttribute (a_FCSI_RXMIXDC41_success_q_0_0);

  RField* f_FCSI_RXMIXDC41_daci = new RField;
  f_FCSI_RXMIXDC41_daci->setInstName ("daci");
  f_FCSI_RXMIXDC41_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC41_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC41_daci->setDataWidth (6);
  f_FCSI_RXMIXDC41_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC41_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC41->connectRField (f_FCSI_RXMIXDC41_daci, 4);

  RField* f_FCSI_RXMIXDC41_dacq = new RField;
  f_FCSI_RXMIXDC41_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC41_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC41_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC41_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC41_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC41_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC41->connectRField (f_FCSI_RXMIXDC41_dacq, 10);

  Register* r_FCSI_RXMIXDC42 = new Register;
  r_FCSI_RXMIXDC42->setInstName ("RXMIXDC42");
  r_FCSI_RXMIXDC42->setLongName ("RX MIXER OFFSET GAIN4 RXDCCH2");
  r_FCSI_RXMIXDC42->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC42->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC42, 0x0000003A);

  RField* f_FCSI_RXMIXDC42_success_i = new RField;
  f_FCSI_RXMIXDC42_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC42_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC42_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC42_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC42_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC42_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC42->connectRField (f_FCSI_RXMIXDC42_success_i, 0);

  Attribute* a_FCSI_RXMIXDC42_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC42_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC42_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC42_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC42_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC42_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC42_success_i->connectAttribute (a_FCSI_RXMIXDC42_success_i_0_0);

  RField* f_FCSI_RXMIXDC42_success_q = new RField;
  f_FCSI_RXMIXDC42_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC42_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC42_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC42_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC42_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC42_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC42->connectRField (f_FCSI_RXMIXDC42_success_q, 1);

  Attribute* a_FCSI_RXMIXDC42_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC42_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC42_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC42_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC42_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC42_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC42_success_q->connectAttribute (a_FCSI_RXMIXDC42_success_q_0_0);

  RField* f_FCSI_RXMIXDC42_daci = new RField;
  f_FCSI_RXMIXDC42_daci->setInstName ("daci");
  f_FCSI_RXMIXDC42_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC42_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC42_daci->setDataWidth (6);
  f_FCSI_RXMIXDC42_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC42_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC42->connectRField (f_FCSI_RXMIXDC42_daci, 4);

  RField* f_FCSI_RXMIXDC42_dacq = new RField;
  f_FCSI_RXMIXDC42_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC42_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC42_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC42_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC42_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC42_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC42->connectRField (f_FCSI_RXMIXDC42_dacq, 10);

  Register* r_FCSI_RXMIXDC43 = new Register;
  r_FCSI_RXMIXDC43->setInstName ("RXMIXDC43");
  r_FCSI_RXMIXDC43->setLongName ("RX MIXER OFFSET GAIN4 RXDCCH3");
  r_FCSI_RXMIXDC43->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC43->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC43, 0x0000003B);

  RField* f_FCSI_RXMIXDC43_success_i = new RField;
  f_FCSI_RXMIXDC43_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC43_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC43_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC43_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC43_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC43_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC43->connectRField (f_FCSI_RXMIXDC43_success_i, 0);

  Attribute* a_FCSI_RXMIXDC43_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC43_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC43_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC43_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC43_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC43_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC43_success_i->connectAttribute (a_FCSI_RXMIXDC43_success_i_0_0);

  RField* f_FCSI_RXMIXDC43_success_q = new RField;
  f_FCSI_RXMIXDC43_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC43_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC43_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC43_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC43_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC43_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC43->connectRField (f_FCSI_RXMIXDC43_success_q, 1);

  Attribute* a_FCSI_RXMIXDC43_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC43_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC43_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC43_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC43_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC43_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC43_success_q->connectAttribute (a_FCSI_RXMIXDC43_success_q_0_0);

  RField* f_FCSI_RXMIXDC43_daci = new RField;
  f_FCSI_RXMIXDC43_daci->setInstName ("daci");
  f_FCSI_RXMIXDC43_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC43_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC43_daci->setDataWidth (6);
  f_FCSI_RXMIXDC43_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC43_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC43->connectRField (f_FCSI_RXMIXDC43_daci, 4);

  RField* f_FCSI_RXMIXDC43_dacq = new RField;
  f_FCSI_RXMIXDC43_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC43_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC43_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC43_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC43_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC43_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC43->connectRField (f_FCSI_RXMIXDC43_dacq, 10);

  Register* r_FCSI_RXMIXDC50 = new Register;
  r_FCSI_RXMIXDC50->setInstName ("RXMIXDC50");
  r_FCSI_RXMIXDC50->setLongName ("RX MIXER OFFSET GAIN5 RXDCCH0");
  r_FCSI_RXMIXDC50->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC50->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC50, 0x0000003C);

  RField* f_FCSI_RXMIXDC50_success_i = new RField;
  f_FCSI_RXMIXDC50_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC50_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC50_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC50_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC50_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC50_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC50->connectRField (f_FCSI_RXMIXDC50_success_i, 0);

  Attribute* a_FCSI_RXMIXDC50_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC50_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC50_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC50_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC50_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC50_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC50_success_i->connectAttribute (a_FCSI_RXMIXDC50_success_i_0_0);

  RField* f_FCSI_RXMIXDC50_success_q = new RField;
  f_FCSI_RXMIXDC50_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC50_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC50_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC50_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC50_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC50_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC50->connectRField (f_FCSI_RXMIXDC50_success_q, 1);

  Attribute* a_FCSI_RXMIXDC50_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC50_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC50_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC50_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC50_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC50_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC50_success_q->connectAttribute (a_FCSI_RXMIXDC50_success_q_0_0);

  RField* f_FCSI_RXMIXDC50_daci = new RField;
  f_FCSI_RXMIXDC50_daci->setInstName ("daci");
  f_FCSI_RXMIXDC50_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC50_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC50_daci->setDataWidth (6);
  f_FCSI_RXMIXDC50_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC50_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC50->connectRField (f_FCSI_RXMIXDC50_daci, 4);

  RField* f_FCSI_RXMIXDC50_dacq = new RField;
  f_FCSI_RXMIXDC50_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC50_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC50_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC50_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC50_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC50_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC50->connectRField (f_FCSI_RXMIXDC50_dacq, 10);

  Register* r_FCSI_RXMIXDC51 = new Register;
  r_FCSI_RXMIXDC51->setInstName ("RXMIXDC51");
  r_FCSI_RXMIXDC51->setLongName ("RX MIXER OFFSET GAIN5 RXDCCH1");
  r_FCSI_RXMIXDC51->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC51->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC51, 0x0000003D);

  RField* f_FCSI_RXMIXDC51_success_i = new RField;
  f_FCSI_RXMIXDC51_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC51_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC51_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC51_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC51_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC51_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC51->connectRField (f_FCSI_RXMIXDC51_success_i, 0);

  Attribute* a_FCSI_RXMIXDC51_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC51_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC51_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC51_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC51_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC51_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC51_success_i->connectAttribute (a_FCSI_RXMIXDC51_success_i_0_0);

  RField* f_FCSI_RXMIXDC51_success_q = new RField;
  f_FCSI_RXMIXDC51_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC51_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC51_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC51_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC51_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC51_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC51->connectRField (f_FCSI_RXMIXDC51_success_q, 1);

  Attribute* a_FCSI_RXMIXDC51_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC51_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC51_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC51_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC51_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC51_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC51_success_q->connectAttribute (a_FCSI_RXMIXDC51_success_q_0_0);

  RField* f_FCSI_RXMIXDC51_daci = new RField;
  f_FCSI_RXMIXDC51_daci->setInstName ("daci");
  f_FCSI_RXMIXDC51_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC51_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC51_daci->setDataWidth (6);
  f_FCSI_RXMIXDC51_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC51_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC51->connectRField (f_FCSI_RXMIXDC51_daci, 4);

  RField* f_FCSI_RXMIXDC51_dacq = new RField;
  f_FCSI_RXMIXDC51_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC51_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC51_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC51_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC51_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC51_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC51->connectRField (f_FCSI_RXMIXDC51_dacq, 10);

  Register* r_FCSI_RXMIXDC52 = new Register;
  r_FCSI_RXMIXDC52->setInstName ("RXMIXDC52");
  r_FCSI_RXMIXDC52->setLongName ("RX MIXER OFFSET GAIN5 RXDCCH2");
  r_FCSI_RXMIXDC52->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC52->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC52, 0x0000003E);

  RField* f_FCSI_RXMIXDC52_success_i = new RField;
  f_FCSI_RXMIXDC52_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC52_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC52_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC52_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC52_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC52_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC52->connectRField (f_FCSI_RXMIXDC52_success_i, 0);

  Attribute* a_FCSI_RXMIXDC52_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC52_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC52_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC52_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC52_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC52_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC52_success_i->connectAttribute (a_FCSI_RXMIXDC52_success_i_0_0);

  RField* f_FCSI_RXMIXDC52_success_q = new RField;
  f_FCSI_RXMIXDC52_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC52_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC52_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC52_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC52_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC52_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC52->connectRField (f_FCSI_RXMIXDC52_success_q, 1);

  Attribute* a_FCSI_RXMIXDC52_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC52_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC52_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC52_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC52_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC52_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC52_success_q->connectAttribute (a_FCSI_RXMIXDC52_success_q_0_0);

  RField* f_FCSI_RXMIXDC52_daci = new RField;
  f_FCSI_RXMIXDC52_daci->setInstName ("daci");
  f_FCSI_RXMIXDC52_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC52_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC52_daci->setDataWidth (6);
  f_FCSI_RXMIXDC52_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC52_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC52->connectRField (f_FCSI_RXMIXDC52_daci, 4);

  RField* f_FCSI_RXMIXDC52_dacq = new RField;
  f_FCSI_RXMIXDC52_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC52_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC52_dacq->setDescription ("");
  f_FCSI_RXMIXDC52_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC52_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC52_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC52->connectRField (f_FCSI_RXMIXDC52_dacq, 10);

  Register* r_FCSI_RXMIXDC53 = new Register;
  r_FCSI_RXMIXDC53->setInstName ("RXMIXDC53");
  r_FCSI_RXMIXDC53->setLongName ("RX MIXER OFFSET GAIN5 RXDCCH3");
  r_FCSI_RXMIXDC53->setDescription ("BB-LDO1V2");
  r_FCSI_RXMIXDC53->setAddrSpace (0x00000001);
  p_FCSI->connectRegister (r_FCSI_RXMIXDC53, 0x0000003F);

  RField* f_FCSI_RXMIXDC53_success_i = new RField;
  f_FCSI_RXMIXDC53_success_i->setInstName ("success_i");
  f_FCSI_RXMIXDC53_success_i->setLongName ("SUCCESS I");
  f_FCSI_RXMIXDC53_success_i->setDescription ("DC offset radar I success bit");
  f_FCSI_RXMIXDC53_success_i->setDataWidth (1);
  f_FCSI_RXMIXDC53_success_i->setResetVal ("1'b0");
  f_FCSI_RXMIXDC53_success_i->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC53->connectRField (f_FCSI_RXMIXDC53_success_i, 0);

  Attribute* a_FCSI_RXMIXDC53_success_i_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC53_success_i_0_0->setInstName ("0");
  a_FCSI_RXMIXDC53_success_i_0_0->setLongName ("");
  a_FCSI_RXMIXDC53_success_i_0_0->setDescription ("");
  a_FCSI_RXMIXDC53_success_i_0_0->addItem("1", "1'b1", "Success I");
  a_FCSI_RXMIXDC53_success_i_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC53_success_i->connectAttribute (a_FCSI_RXMIXDC53_success_i_0_0);

  RField* f_FCSI_RXMIXDC53_success_q = new RField;
  f_FCSI_RXMIXDC53_success_q->setInstName ("success_q");
  f_FCSI_RXMIXDC53_success_q->setLongName ("SUCCESS Q");
  f_FCSI_RXMIXDC53_success_q->setDescription ("DC offset radar Q success bit");
  f_FCSI_RXMIXDC53_success_q->setDataWidth (1);
  f_FCSI_RXMIXDC53_success_q->setResetVal ("1'b0");
  f_FCSI_RXMIXDC53_success_q->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC53->connectRField (f_FCSI_RXMIXDC53_success_q, 1);

  Attribute* a_FCSI_RXMIXDC53_success_q_0_0 = new Attribute(Attribute::ENUM);
  a_FCSI_RXMIXDC53_success_q_0_0->setInstName ("0");
  a_FCSI_RXMIXDC53_success_q_0_0->setLongName ("");
  a_FCSI_RXMIXDC53_success_q_0_0->setDescription ("");
  a_FCSI_RXMIXDC53_success_q_0_0->addItem("1", "1'b1", "Success Q");
  a_FCSI_RXMIXDC53_success_q_0_0->addItem("0", "1'b0", "disable");
  f_FCSI_RXMIXDC53_success_q->connectAttribute (a_FCSI_RXMIXDC53_success_q_0_0);

  RField* f_FCSI_RXMIXDC53_daci = new RField;
  f_FCSI_RXMIXDC53_daci->setInstName ("daci");
  f_FCSI_RXMIXDC53_daci->setLongName ("DAC-I");
  f_FCSI_RXMIXDC53_daci->setDescription ("Offset DAC-I bits (2's complement)");
  f_FCSI_RXMIXDC53_daci->setDataWidth (6);
  f_FCSI_RXMIXDC53_daci->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC53_daci->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC53->connectRField (f_FCSI_RXMIXDC53_daci, 4);

  RField* f_FCSI_RXMIXDC53_dacq = new RField;
  f_FCSI_RXMIXDC53_dacq->setInstName ("dacq");
  f_FCSI_RXMIXDC53_dacq->setLongName ("DAC-Q");
  f_FCSI_RXMIXDC53_dacq->setDescription ("Offset DAC-Q bits (2's complement)");
  f_FCSI_RXMIXDC53_dacq->setDataWidth (6);
  f_FCSI_RXMIXDC53_dacq->setResetVal ("6'b000000");
  f_FCSI_RXMIXDC53_dacq->setAccProp (AccProp::RW);
  r_FCSI_RXMIXDC53->connectRField (f_FCSI_RXMIXDC53_dacq, 10);

  
}

